<!DOCTYPE html>
<head>
    <meta http-equiv="Content-type" content="text/html; charset=utf-8">
    <title>jQuery integration</title>
    <script src="//code.jquery.com/jquery-1.7.1.min.js?v=6.1.5"></script>
    <script src="http://export.dhtmlx.com/gantt/api.js"></script>
    <script src="../../codebase/dhtmlxgantt.js?v=6.1.5"></script>
    <script src="../../codebase/ext/dhtmlxgantt_marker.js?v=6.1.5"></script>
    <script src="../../codebase/ext/dhtmlxgantt_tooltip.js"></script>
    <link rel="stylesheet" href="../../codebase/skins/dhtmlxgantt_broadway.css?v=4.0">

<!--    <link rel="stylesheet" href="../../codebase/skins/dhtmlxgantt_material.css?v=4.0">-->
<!--    <link rel="stylesheet" href="../../codebase/dhtmlxgantt.css?v=6.1">-->
    <script src="../common/testdata.js?v=6.1.5"></script>
    <style>
        html, body {
            height: 100%;
            padding: 0px;
            margin: 0px;
            overflow: hidden;
        }
        .project, .project .gantt_task_progress{
            background-color:#008080;
            border-color: #007575;
            box-shadow: none;
        }

        .gantt_task_line.project{
            background-image: none;
        }

        .controls_bar{
            border-top:1px solid #bababa;
            border-bottom:1px solid #bababa;
            clear:both;
            margin-top:90px;
            height:28px;
            background:#f1f1f1;
            color:#494949;
            font-family:Arial, sans-serif;
            font-size:13px;
            padding-left:10px;
            line-height:25px
        }
        .gantt_tree_content
        {
            font-size:11px;
        }

        .gantt_grid_head_cell
        {
            background-color:#1b1e24;
            padding:0;
            margin:0;
        }



    </style>
</head>
<body style="padding:0">
<div class="mygantt" style='width:100%; height:95%;margin-top:0;margin-left:0'></div>

<div>
<label><input class="radiobox" type="radio" name="scale" value="day" checked/>Day scale</label>
<label><input type="radio" name="scale" value="week"/>Week scale</label>
<label><input type="radio" name="scale" value="month"/>Month scale</label>
<label><input type="radio" name="scale" value="year"/>Year scale</label>
    <button onclick="toggleMode(this)">Zoom to Fit</button>
</div>

<script>

    var els = document.querySelectorAll("input[name='scale']");
    for (var i = 0; i < els.length; i++) {
        els[i].onclick = function(e){
            e = e || window.event;
            var el = e.target || e.srcElement;
            var value = el.value;
            setScaleConfig(value);
            gantt.render();
        };
    }

    /* global gantt */
    function setScaleConfig(level) {
        switch (level) {
            case "day":
                gantt.config.scale_unit = "day";
                gantt.config.step = 1;
                gantt.config.date_scale = "%d %M";
                gantt.templates.date_scale = null;

                gantt.config.scale_height = 27;

                gantt.config.subscales = [];
                break;
            case "week":
                var weekScaleTemplate = function (date) {
                    var dateToStr = gantt.date.date_to_str("%d %M");
                    var endDate = gantt.date.add(gantt.date.add(date, 1, "week"), -1, "day");
                    return dateToStr(date) + " - " + dateToStr(endDate);
                };

                gantt.config.scale_unit = "week";
                gantt.config.step = 1;
                gantt.templates.date_scale = weekScaleTemplate;

                gantt.config.scale_height = 50;

                gantt.config.subscales = [
                    {unit: "day", step: 1, date: "%D"}
                ];
                break;
            case "month":
                gantt.config.scale_unit = "month";
                gantt.config.date_scale = "%F, %Y";
                gantt.templates.date_scale = null;

                gantt.config.scale_height = 50;

                gantt.config.subscales = [
                    {unit: "day", step: 1, date: "%j, %D"}
                ];

                break;
            case "year":
                gantt.config.scale_unit = "year";
                gantt.config.step = 1;
                gantt.config.date_scale = "%Y";
                gantt.templates.date_scale = null;

                gantt.config.min_column_width = 50;
                gantt.config.scale_height = 90;

                gantt.config.subscales = [
                    {unit: "month", step: 1, date: "%M"}
                ];
                break;
        }
    }

    gantt.templates.task_class = function(start, end, obj){
        return obj.project ? "project" : "";
    }

    gantt.templates.tooltip_text = function(start,end,task){
        return "<b>Task:</b> "+task.text+"<br/><b>Duration:</b> " + task.duration;
    };


    var toggleCritical = function () {
        if (gantt.config.highlight_critical_path)
            gantt.config.highlight_critical_path = !true;
        else
            gantt.config.highlight_critical_path = true;
        gantt.render();
    }
    gantt.config.xml_date="%Y-%m-%d %H:%i:%s";
    gantt.config.scale_height = 36 * 3;
    var weekScaleTemplate = function (date) {
        var dateToStr = gantt.date.date_to_str("%d %M %Y");
        var endDate = gantt.date.add(gantt.date.add(date, 1, "week"), -1, "day");
        return dateToStr(date) + " - " + dateToStr(endDate);
    };

    gantt.config.columns = [

        {name: "text", label: "Projects / Tasks", tree: true, width: 200, "resize": true, min_width: 10},
        {name: "start_date", label: "Start", align: "center", width: 70, "resize": true},
        {name: "end_date", label: "End", align: "center", width: 70, "resize": true},
        {name: "duration", label: "Days", align: "center", width: 50, "resize": true}
        // {name: "add", width: 40}
    ];

    gantt.config.readonly = true;


    gantt.config.date_scale = "%D";
    gantt.config.start_on_monday = false;

    gantt.config.subscales = [
        {unit: "month", step: 1, date: "%F"},
        {unit: "week", step: 1, template: weekScaleTemplate}
    ];


    gantt.attachEvent("onGanttReady", function(){
        gantt.config.buttons_left = ["gantt_save_btn","gantt_cancel_btn","complete_button"];
        gantt.config.buttons_right = ["gantt_delete_btn"];
    });

    gantt.locale.labels["complete_button"] = "View more";

    gantt.attachEvent("onLightboxButton", function(button_id, node, e){
        if(button_id == "complete_button"){
            var id = gantt.getState().lightbox;
            window.open('../../../service_call.php?service_call_id='+ id, '_blank');
        }
    });



    gantt.templates.rightside_text = function(start, end, task){
        return "<b>" + task.text+"<b>";
    };


    gantt.templates.task_text=function(start,end,task){

        if(task.project==1)
        {
            return task.text;
        }
        else
        {
            return"";
        }

    };


    gantt.config.font_width_ratio = 2;




    function toggleMode(toggle) {
        toggle.enabled = !toggle.enabled;
        if (toggle.enabled) {
            toggle.innerHTML = "Set default Scale";
            //Saving previous scale state for future restore
            saveConfig();
            zoomToFit();
        } else {

            toggle.innerHTML = "Zoom to Fit";
            //Restore previous scale state
            restoreConfig();
            gantt.render();
        }
    }

    var cachedSettings = {};

    function saveConfig() {
        var config = gantt.config;
        cachedSettings = {};
        cachedSettings.scale_unit = config.scale_unit;
        cachedSettings.date_scale = config.date_scale;
        cachedSettings.step = config.step;
        cachedSettings.subscales = config.subscales;
        cachedSettings.template = gantt.templates.date_scale;
        cachedSettings.start_date = config.start_date;
        cachedSettings.end_date = config.end_date;
    }

    function restoreConfig() {
        applyConfig(cachedSettings);
    }

    function applyConfig(config, dates) {
        gantt.config.scale_unit = config.scale_unit;
        if (config.date_scale) {
            gantt.config.date_scale = config.date_scale;
            gantt.templates.date_scale = null;
        }
        else {
            gantt.templates.date_scale = config.template;
        }

        gantt.config.step = config.step;
        gantt.config.subscales = config.subscales;

        if (dates && dates.start_date && dates.start_date) {
            gantt.config.start_date = gantt.date.add(dates.start_date, -1, config.unit);
            gantt.config.end_date = gantt.date.add(gantt.date[config.unit + "_start"](dates.end_date), 2, config.unit);
        } else {
            gantt.config.start_date = gantt.config.end_date = null;
        }
    }


    function zoomToFit() {
        var project = gantt.getSubtaskDates(),
            areaWidth = gantt.$task.offsetWidth;

        for (var i = 0; i < scaleConfigs.length; i++) {
            var columnCount = getUnitsBetween(project.start_date, project.end_date, scaleConfigs[i].unit, scaleConfigs[i].step);
            if ((columnCount + 2) * gantt.config.min_column_width <= areaWidth) {
                break;
            }
        }

        if (i == scaleConfigs.length) {
            i--;
        }

        applyConfig(scaleConfigs[i], project);
        gantt.render();
    }

    // get number of columns in timeline
    function getUnitsBetween(from, to, unit, step) {
        var start = new Date(from),
            end = new Date(to);
        var units = 0;
        while (start.valueOf() < end.valueOf()) {
            units++;
            start = gantt.date.add(start, step, unit);
        }
        return units;
    }

    //Setting available scales
    var scaleConfigs = [
        // minutes
        {
            unit: "minute", step: 1, scale_unit: "hour", date_scale: "%H", subscales: [
            {unit: "minute", step: 1, date: "%H:%i"}
        ]
        },
        // hours
        {
            unit: "hour", step: 1, scale_unit: "day", date_scale: "%j %M",
            subscales: [
                {unit: "hour", step: 1, date: "%H:%i"}
            ]
        },
        // days
        {
            unit: "day", step: 1, scale_unit: "month", date_scale: "%F",
            subscales: [
                {unit: "day", step: 1, date: "%j"}
            ]
        },
        // weeks
        {
            unit: "week", step: 1, scale_unit: "month", date_scale: "%F",
            subscales: [
                {
                    unit: "week", step: 1, template: function (date) {
                    var dateToStr = gantt.date.date_to_str("%d %M");
                    var endDate = gantt.date.add(gantt.date.add(date, 1, "week"), -1, "day");
                    return dateToStr(date) + " - " + dateToStr(endDate);
                }
                }
            ]
        },
        // months
        {
            unit: "month", step: 1, scale_unit: "year", date_scale: "%Y",
            subscales: [
                {unit: "month", step: 1, date: "%M"}
            ]
        },
        // quarters
        {
            unit: "month", step: 3, scale_unit: "year", date_scale: "%Y",
            subscales: [
                {
                    unit: "month", step: 3, template: function (date) {
                    var dateToStr = gantt.date.date_to_str("%M");
                    var endDate = gantt.date.add(gantt.date.add(date, 3, "month"), -1, "day");
                    return dateToStr(date) + " - " + dateToStr(endDate);
                }
                }
            ]
        },
        // years
        {
            unit: "year", step: 1, scale_unit: "year", date_scale: "%Y",
            subscales: [
                {
                    unit: "year", step: 5, template: function (date) {
                    var dateToStr = gantt.date.date_to_str("%Y");
                    var endDate = gantt.date.add(gantt.date.add(date, 5, "year"), -1, "day");
                    return dateToStr(date) + " - " + dateToStr(endDate);
                }
                }
            ]
        },
        // decades
        {
            unit: "year", step: 10, scale_unit: "year", template: function (date) {
            var dateToStr = gantt.date.date_to_str("%Y");
            var endDate = gantt.date.add(gantt.date.add(date, 10, "year"), -1, "day");
            return dateToStr(date) + " - " + dateToStr(endDate);
        },
            subscales: [
                {
                    unit: "year", step: 100, template: function (date) {
                    var dateToStr = gantt.date.date_to_str("%Y");
                    var endDate = gantt.date.add(gantt.date.add(date, 100, "year"), -1, "day");
                    return dateToStr(date) + " - " + dateToStr(endDate);
                }
                }
            ]
        }
    ];

    var date_to_str = gantt.date.date_to_str(gantt.config.task_date);

    var today = new Date();
    gantt.addMarker({
        start_date: today,
        css: "today",
        text: "Today",
        title: "Today: " + date_to_str(today)
    });





    $(document).ready(function () {

        var customerID = '<?php echo $_GET['customer_id'];?>';

        $.ajax({
            url: 'getTasksByCustomer.php',
            type: "POST",
            data: { customerID: customerID },
            success: function (json) {



                $(".mygantt").dhx_gantt({
                    data:  json
                });

            }
        });

        var dp = gantt.createDataProcessor(function(entity, action, data, id) {
            switch(action) {
                case "create":
                    $.ajax({
                        url: 'createTask.php',
                        data: {
                            'text':data['text'],
                            'start_date':data['start_date'],
                            'parent':data['parent'],
                            'end_date':data['end_date']

                        },
                        type: "POST",
                        success: function (json)
                        {




                        }
                    });
                    break;
                case "update":
//                            return gantt.ajax.post(
//                                "updateTask.php",
//                                data
//                            );

                    $.ajax({
                        url: 'updateTask.php',
                        data: {
                            'serviceCallID':id,
                            'start_date':data['start_date'],
                            'parent':data['parent'],
                            'end_date':data['end_date']

                        },
                        type: "POST",
                        success: function (json)
                        {


                        }
                    });

                    break;
                case "delete":
                    $.ajax({
                        url: 'updateTask.php',
                        data: {
                            'serviceCallID':id,
                            'start_date':data['start_date'],
                            'parent':data['parent'],
                            'end_date':data['end_date'],
                            'delete':true

                        },
                        type: "POST",
                        success: function (json)
                        {


                        }
                    });
                    break;
            }
        });

    });
</script>
</body>