<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

require_once('SAPClient.php');
require_once('SAPClientPreferences.php');
require_once('importFunctions.php');

if (isset($_POST['testConnection']) && $_POST['testConnection']) {

    $client = new SAPClient($b1Host, $b1Port, $b1UserName, $b1Password, $b1CompanyDB);
    ob_start();
    $client->startConnection();
    $errors = ob_get_clean();

    $sessionID = $client->getSessionID();

    if (empty($errors) && !empty($sessionID)) {
        echo json_encode(['status' => 'success', 'sessionID' => $sessionID]);
    } else {
        echo json_encode(['status' => 'fail', 'error' => $errors]);
    }

    exit();
}

if (isset($_POST['apiCall'])) {
    $apiCall = $_POST['apiCall'];
    $filter = isset($_POST['filter']) ? $_POST['filter'] : '';
    $skip = isset($_POST['skip']) ? $_POST['skip'] : '';
    $top = isset($_POST['top']) ? $_POST['top'] : '';
    $select  = isset($_POST['select']) ? $_POST['select'] : '';
    $orderby  = isset($_POST['orderby']) ? $_POST['orderby'] : '';


    try {
        $client = new SAPClient($b1Host, $b1Port, $b1UserName, $b1Password, $b1CompanyDB);
        $client->startConnection();
        $params = [];
        if (!empty($filterNext)) {
            $params[] = '$filter=' . $filterNext;
        }
        if (!empty($skip)) {
            $params[] = '$skip=' . $skip;
        }
        if (!empty($top)) {
            $params[] = '$top=' . $top;
        }
        if (!empty($orderby)) {
            $params[] = '$orderby=' . $orderby;
        }
        if (!empty($select)) {
            $params[] = '$select=' . $select;
        }

        if(!empty($params)){
            $filterQuery = implode('&', $params);
        }
        else{
            $filterQuery = '';
        }

        $filterQuery = str_replace(' ', '%20', $filterQuery);

        $result = $client->requestDataForTest($apiCall, $filterQuery, true);


        echo json_encode($result);

    } catch (Exception $e) {
        echo json_encode( $e->getMessage());
    }
}
?>
