<?php

function importOrders($client,$today)
{

    echo "<br><b>---ORDERS---</b><br>";

    $skip = '';
    $filterNext = '';
    $hasMore = true;
    $isFirst = true;

    if(strcmp($today,'')!=0){
        $filterSelect= '$filter=UpdateDate ge '."'$today'";
    } else {
        $filterSelect= '';
    }

    $filterSelect = str_replace(' ','%20',$filterSelect);

    while($hasMore){

        if($isFirst){$isFirst=false;}else{$filterSelect='';}
        if(strcmp($skip,'')!=0){$filterNext= "?".explode('?',$skip)[1];}

        $result = $client->requestData('Orders'.$filterNext,$filterSelect,true);

        $skip   = $result[1];
        $orders = $result[0];

        if(strcmp($skip,'')!=0){ $hasMore = true;} else {$hasMore = false;}

        foreach($orders AS $order){
            $order = (object)$order;

            $orderIdNumber = "$order->DocEntry";
            $sapOrderCustomerCode = "$order->CardCode";
            $sapOrderCustomerName = "$order->CardName";
            $sapOrderCustomerAddress = str_replace("\r",", ","$order->Address");

            if(strcmp("$sapOrderCustomerCode","")==0){
                $sapOrderCustomerCode = "GenericCustomer";
                $sapOrderCustomerName = "Generic Customer";
                $sapOrderCustomerAddress = " ";
            }

            $ordersArray = array();
            $orderItems = array();

            $subtotals = 0;
            $discountTotals = 0;
            $vatTotals = 0;

            echo "<br>---------------- SAP Order $order->DocNum ($order->DocEntry) -------------------";

            foreach($order->DocumentLines AS $orderLine){
                $orderLine = (object)$orderLine;

                $qty = floatval($orderLine->Quantity);
                $sapOrderWarehouseCode = $orderLine->WarehouseCode;

                $warehouseID = getWarehouseID("$sapOrderWarehouseCode");
                $itemID = getItemID($orderLine->ItemCode);

                if(intval($itemID) == 0){
                    $itemID = importOrderItemFromSAP($client,$orderLine->ItemCode);
                }

                $vatID = getVatItemID($itemID);
                $vatPercent = getVatPercent($vatID);

                $lineDiscount = floatval($orderLine->UnitPrice) - floatval($orderLine->Price);
                $lineDiscount *= $qty;

                $lineTotal = floatval($orderLine->UnitPrice)*floatval($orderLine->Quantity);
                $vatTotal = ($lineTotal-$lineDiscount)*$vatPercent/100;

                $subtotals += $lineTotal;
                $discountTotals += $lineDiscount;
                $vatTotals += $vatTotal;

                $orderItem = new stdClass();
                $orderItem->itemID = $itemID;
                $orderItem->qty = $qty;
                $orderItem->unitPrice = $orderLine->UnitPrice;
                $orderItem->lineDiscount = $lineDiscount;
                $orderItem->globalDiscount = 0;
                $orderItem->vatTotal = $vatTotal;
                $orderItem->priceTypeID = 10001;
                $orderItem->vatID = $vatID;
                $orderItem->lineDiscountPercent = $orderLine->DiscountPercent;
                $orderItem->itemNotes = $orderLine->ItemDescription.' |CostingCode| '.$orderLine->CostingCode.' |AccountCode| '.$orderLine->AccountCode.' |DocEntry| '.$order->DocEntry.' |LineNum| '.$orderLine->LineNum;

                echo "<br> LineNum $orderLine->LineNum - Item($itemID): $orderLine->ItemCode - $orderLine->ItemDescription | UnitPrice: $orderLine->UnitPrice | Quantity: $qty  ";

                array_push($orderItems,$orderItem);


            }


            if(count($ordersArray) > 1){
                $sapOrderCustomerCode = "MultiCustomer";
                $sapOrderCustomerName = "Multiple Customers";
                $sapOrderCustomerAddress = "";
            }


            $customerID = intval(getCustomerID($sapOrderCustomerCode));

            if($customerID == 0){

                $customer_code="$sapOrderCustomerCode";
                $customer_company_name="$sapOrderCustomerName";
                $customer_report_name="";
                $logo="";
                $registration_code="";
                $mobile="";
                $website="";
                $email="";
                $description="";
                $type_of_business="Credit";
                $tic_code="";
                $vat_code="";
                $credit_limit=0;
                $address_code_eurosoft="";
                $customer_type="Credit";
                $balance=0;
                echo "<br>INSERT CUSTOMER $customer_code - $customer_company_name<br>";
                $customerID = intval(insertCustomer($customer_code,$customer_company_name,$customer_report_name,$logo,$registration_code,$mobile,$website,$email,$description,$type_of_business,$tic_code,$vat_code,$credit_limit,$address_code_eurosoft,$customer_type,$balance));
            }

            $coprimeCodeNumber = 10000 + intval($order->DocEntry);

            $orderBillingAddress = $order->AddressExtension['BillToStreet'];
            $orderDeliveryAddress = $order->AddressExtension['ShipToStreet'];

//            if(strcmp("$orderBillingAddress","")==0 && strcmp("$orderDeliveryAddress","")!=0){$orderBillingAddress = $orderDeliveryAddress;}
//            if(strcmp("$orderDeliveryAddress","")==0 && strcmp("$orderBillingAddress","")!=0){$orderDeliveryAddress = $orderBillingAddress;}

            $sapOrder = new stdClass();
            $sapOrder->CoprimeType = 'Order';
            $sapOrder->CoprimePrefix = '';
            $sapOrder->orderCode = $sapOrder->CoprimePrefix.$coprimeCodeNumber;
            $sapOrder->orderDate = $order->DocDate;
            $sapOrder->orderDueDate = $order->DocDueDate;
            $sapOrder->customerID = $customerID;
            $sapOrder->customerCode = $sapOrderCustomerCode;
            $sapOrder->customerName = $sapOrderCustomerName;
            $sapOrder->customerAddress = $sapOrderCustomerAddress;
            $sapOrder->billingAddressID = getAddressIdFromStreet($customerID, "$orderBillingAddress");
            $sapOrder->deliveryAddressID = getAddressIdFromStreet($customerID, "$orderDeliveryAddress");
            $sapOrder->warehouseID = $warehouseID;
            $sapOrder->salespersonID = intval(getSalespersonID("$sapOrder->SalesPersonCode"));
            $sapOrder->details = trim(rtrim(trim("$order->DocNum - $sapOrder->Comments"),'-'));
            $sapOrder->lines = $orderItems;
            $sapOrder->status = 'Placed';

            if(strcmp("$order->DocumentStatus","bost_Open")!=0){
                $sapOrder->status = str_replace('bost_','',$order->DocumentStatus);
            }

            if(intval($warehouseID) == 0){$sapOrder->warehouseID = 10000;}

            $objectActionHash = sha1(json_encode($sapOrder));

            $paymentMethod = 0;
            $orderCode = $sapOrder->orderCode;
            $companyID = 0;
            $salespersonID = $sapOrder->salespersonID;
            $subtotal = floatval($subtotals);
            $vatTotal = floatval($vatTotals);
            $discount = floatval($discountTotals);
            $grandTotal = $subtotal+$vatTotal-$discount;
            $globalDiscountPercentage = 0;
            $billingAddress = intval($sapOrder->billingAddressID);
            $deliveryAddress = intval($sapOrder->deliveryAddressID);
            $orderDate = "$sapOrder->orderDate";
            $dueDate = "$sapOrder->orderDueDate";
            $details = $sapOrder->details;
            $status = $sapOrder->status;
            $warehouseID = $sapOrder->warehouseID;
            $tenderID = intval($orderIdNumber);
            $currencyID = 0;
            $actionHash = "$objectActionHash";


            if(!orderExists($orderCode)){
                if(strcmp("$order->Reference2","")!=0 && orderExists("$order->Reference2")){
                    $orderCode = "$order->Reference2";
                    echo "<br>--------- Coprime Order $orderCode -------------<br>";
                    continue;
                } else if(strcmp("$order->NumAtCard","")!=0 && orderExists("$order->NumAtCard")){
                    $orderCode = "$order->NumAtCard";
                    echo "<br>--------- Coprime Order $orderCode -------------<br>";
                    continue;
                }
            }

            if(orderExists($orderCode)){

                if(orderHasPick($orderCode)){
                    echo "<br> ------------- $orderCode LOCKED (Has Pick) -------------<br>";
                } else {
                    $orderID = updateOrderSingleTransaction($orderCode,$companyID,$customerID,$salespersonID,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$billingAddress,$deliveryAddress,$orderDate,$dueDate,$details,$globalDiscountPercentage,$status,$warehouseID,$tenderID,$currencyID,$actionHash,$orderItems);
                    if($orderID == -1){
                        echo "<br> ------------- $orderCode No Change -------------<br>";
                    } else {
                        echo "<br> ------------- Updated Order $orderCode: $orderID -------------<br>";
                    }
                }

            } else {
                if(count($orderItems) > 0){
                    $orderID = insertOrderSingleTransaction($orderCode,$companyID,$customerID,$salespersonID,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$billingAddress,$deliveryAddress,$orderDate,$dueDate,$details,$globalDiscountPercentage,$status,$warehouseID,$tenderID,$currencyID,$actionHash,$orderItems);
                    echo "<br> ------------- Inserted Order $orderCode: $orderID -------------<br>";
                } else {
                    echo "<br> ------------- $orderCode No Items -------------<br>";
                }
            }


        }


    }
    echo "<br><b>---ORDERS/---</b><br>";


}

function importOrderItemFromSAP($client,$sapCode){

    $itemFilter = '$filter=ItemCode eq '."'$sapCode'";
    $itemFilter = str_replace(' ','%20',$itemFilter);
    $item = $client->requestData('Items',$itemFilter);
    $item = (object)$item[0][0];

    echo "<br><b>ADD Item---</b>";
    echo $item->ItemCode;
    echo " [ItemCode] ";
    echo $item->ItemName;
    echo " [ItemName] ";
    echo $item->UpdateDate;
    echo " [UpdateDate] ";

    $vatCode      = $item->SalesVATGroup;
    $categoryCode = $item->ItemsGroupCode;
    $isSalesItem  = $item->SalesItem;
    $itemType     = $item->ItemType;

    $itemCode       = $item->ItemCode;
    $itemSKU        = "".str_replace('-','',$itemCode);
    $companyID      = 0;
    $vatID          = getVatID($vatCode);
    $subunits       = 1;
    $salesUnits     = $item->SalesUnit;
    $manufacturerID = 0;
    $itemName       = $item->ItemName;
    $shortDesc      = $item->ForeignName;
    $longDesc       = "";
    $thumbnailURL   = "";
    $reorderLevel   = 0;
    $targetQty      = 0;
    $bundled        = " ";
    $maxStock       = 0;
    $minStock       = 0;
    $packing        = $item->SalesPackagingUnit;
    $stockControl   = "yes";
    $sellable       = trim(strtolower($item->SalesItem),'t');
    $weight         = $item->SalesUnitWeight;
    $cbm            = 0;
    $status         = 0;
    $inactive       = trim(strtolower($item->Frozen),'t');
    $defaultBarcode = $item->BarCode;

    if(strcmp($inactive,'yes')==0){$status = 'inactive';}


    if(strcmp($salesUnits,'')==0){$salesUnits = 'EACH';}
    if(strcmp($vatID,'')==0){$vatID = 0;}
    if(strcmp($weight,'')==0){$weight = 0;}
    if(strcmp($packing,'')==0){$packing = 0;}
    if(strcmp($weight,'')==0){$weight = 0;}
    if(strcmp($itemSKU,'')==0){$itemSKU = " ";}
    if(is_null($shortDesc)){$shortDesc = "";}
    if(strcmp($item->ManageSerialNumbers,"tYes")==0)
    {
        $manufacturerID=-400;
    }

    if(itemExits($itemCode)){
        $itemID = updateItem($itemCode,$vatID,$subunits,$salesUnits,$itemName,$shortDesc,$longDesc,$weight,$status,$packing);
        echo " -> updateItem $itemCode  : ID $itemID STATUS: $status, WEIGHT: $weight, Packing: $packing";

    } else {
        $itemID = insertItem($itemCode,$itemSKU,$companyID,$vatID,$subunits,$salesUnits,$manufacturerID,$itemName,$shortDesc,$longDesc,$thumbnailURL,$reorderLevel,$targetQty,$bundled,$maxStock,$minStock,$packing,$stockControl,$sellable,$weight,$cbm,$status);
        echo " -> insertItem($itemCode,$itemSKU,$companyID,$vatID,$subunits,$salesUnits,$manufacturerID,$itemName,$shortDesc,$longDesc,$thumbnailURL,$reorderLevel,$targetQty,$bundled,$maxStock,$minStock,$packing,$stockControl,$sellable,$weight,$cbm,$status)";
    }



    if(strcmp($item->U_Category1,'')!=0)
    {
        $categoryLevel = $item->U_Category1;
        if(categoryExists($categoryLevel)){
            $categoryID=getCategoryID($categoryLevel);
            insertItemToCategory($itemID,$categoryID);
        }

    }

    if(strcmp($item->U_Category2,'')!=0)
    {
        $categoryLevel = $item->U_Category2;
        if(categoryExists($categoryLevel)){
            $categoryID=getCategoryID($categoryLevel);
            insertItemToCategory($itemID,$categoryID);
        }

    }

    if(strcmp($item->U_Category3,'')!=0)
    {
        $categoryLevel = $item->U_Category2;
        if(categoryExists($categoryLevel)){
            $categoryID=getCategoryID($categoryLevel);
            insertItemToCategory($itemID,$categoryID);
        }

    }

    if($itemID > 0){
        if(categoryExists($categoryCode)){
            $categoryID = getCategoryID($categoryCode);
            if($categoryID >0){
                if(itemExistsInCategory($itemID, $categoryID)){
                    // echo "<b>Item Category---</b> Item $itemCode exists in Category $categoryCode<br>";
                } else {
                    insertItemToCategory($itemID,$categoryID);
                    // echo "<b>Item Category---</b> insertItemToCategory $categoryCode<br>";
                }
            }
        }
    }

    foreach($item->ItemPrices as $itemPrice){
        $itemPrice = (object)$itemPrice;

        $priceTypeCode = $itemPrice->PriceList;
        $price         = $itemPrice->Price;

        if(strcmp($priceTypeCode,'')!=0){
            if(strcmp($price,'')==0){$price=0;}
            $priceTypeID = getPriceTypeID($priceTypeCode);
            if($priceTypeID > 0){

                $prevPrice = getPrice($priceTypeID,$itemID);
                if($price !== $prevPrice){
                    insertPrices($itemID,$priceTypeID,$price);
                }
                updateSpecialPrices($itemID,$priceTypeID,$price);

            }
        }
    }
    foreach($item->ItemWarehouseInfoCollection as $itemStock){
        $itemStock = (object)$itemStock;

        $warehouseCode = $itemStock->WarehouseCode;
        $available = $itemStock->InStock;
        $reserved = $itemStock->Committed;
        $onOrder = $itemStock->Ordered;
        $locked=$itemStock->Locked;

        if(strcmp(trim($itemStock->U_BinLoc),'')!=0){
            updateItemLongDescription($itemID,"$itemStock->U_BinLoc");
        }

        $delivered = 0;

        if(strcmp($warehouseCode,'')!=0){
            $warehouseID = getWarehouseID($warehouseCode);
            $batchnumber = "0";

            if(strcmp($locked,"tYES")==0){
                $batchnumber = "0";
                $available=-10000;
            }

            if($warehouseID > 0){
                //  insertStock($warehouseID,$itemID,$batchnumber,$available,$onOrder,$reserved,$delivered);
            }
        }
    }

    $uomGroupID = $item->UoMGroupEntry;
    foreach($item->ItemUnitOfMeasurementCollection as $uom){
        $uom = (object)$uom;
        $uomID = $uom->UoMEntry;
        $multiplier = getUOMMultiplier($uomGroupID,$uomID);
        if(!UOMItemExists($itemID,$uomID,$multiplier)){
            insertUOMItem($itemID,$uomID,$position=1,$multiplier);
            // echo " -> insertUOMItem($itemID,$uomID,$position,$multiplier);";
        }
    }

    return $itemID;
}

?>