<?php
//-------------------------------------------------------DATEBASE FUNCTIONS---------------------------------------------
function insertPick($pickCode,$compenyID,$salespersonID,$date,$notes,$status)
{
    global $username;
    global $password;
    global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
	$pickID = getNextID("Pick","pick_id");
 	$stmt = $db->prepare("INSERT INTO Pick(pick_id, pick_code, company_id, salesperson_id, date, notes, status, timestamp) VALUES (?,?,?,?,?,?,?,NOW())");
	$stmt->bind_param('sssssss',$pickID,$pickCode,$compenyID,$salespersonID,$date,$notes,$status);
 	$stmt->execute(); 	
 	$stmt->close(); 
 	
 	return $pickID;
}
function insertPickItem($pickID,$itemID,$batchNumber,$warehouseID,$qty,$qtyToPick,$notes)
{
    global $username;
    global $password;
    global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
	$pickItemID = getNextID("Pick_Item","pick_item_id");
 	$stmt = $db->prepare("INSERT INTO Pick_Item(pick_item_id, pick_id, item_id, batch_number, warehouse_id, qty, qty_to_pick, notes, timestamp) VALUES (?,?,?,?,?,?,?,?,NOW())");
	$stmt->bind_param('ssssssss',$pickItemID,$pickID,$itemID,$batchNumber,$warehouseID,$qty,$qtyToPick,$notes);
 	$stmt->execute(); 	
 	$stmt->close(); 
 	
 	return $pickItemID;
}

function pickExists($code) {

global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(pick_id) FROM Pick WHERE pick_code='$code'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
}
   
function insertContract($customerID,$itemID,$serialNumberID)
{
   global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
	$contractID = getNextID("Contracts","contract_id");
 	$stmt = $db->prepare("INSERT INTO Contracts (contract_id,customer_id,item_id,serial_number_id,timestamp) VALUES(?,?,?,?,NOW())");
	$stmt->bind_param('iiii',$contractID,$customerID,$itemID,$serialNumberID);
 	$stmt->execute(); 	
 	$stmt->close(); 
}

function insertPriceGroup($priceGroupCode,$priceGroupName,$priceGroupType)
{
    global $username;
    global $password;
    global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
	$priceGroupID = getNextID("Price_Group_Definitions","price_group_definition_id");
 	$stmt = $db->prepare("INSERT INTO Price_Group_Definitions (price_group_definition_id,price_group_code,name,type,timestamp) VALUES(?,?,?,?,NOW())");
	$stmt->bind_param('isss',$priceGroupID,$priceGroupCode,$priceGroupName,$priceGroupType);
 	$stmt->execute(); 	
 	$stmt->close(); 
 	
 	return $priceGroupID;
}

function insertPriceGroupRule($priceGroupDefinitionID,$categoryID,$discountPrcent,$priceTypeID,$priceGroupRuleID)
{
    global $username;
    global $password;
    global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
	if($priceGroupRuleID==0)
	{
	    $priceGroupRuleID = getNextID("Price_Group_Rules","price_group_rule_id");
	}
 	$stmt = $db->prepare("INSERT INTO Price_Group_Rules (price_group_rule_id,price_group_definition_id,category_id,discount_percent,price_type_id,timestamp) VALUES(?,?,?,?,?,NOW()) ON DUPLICATE KEY UPDATE discount_percent=?, price_type_id=?");
	$stmt->bind_param('iiididi',$priceGroupRuleID,$priceGroupDefinitionID,$categoryID,$discountPrcent,$priceTypeID,$discountPrcent,$priceTypeID);
 	$stmt->execute(); 	
 	$stmt->close(); 
 	
 	return $priceGroupRuleID;
}

function insertCustomerToPriceGroup($priceGroupDefinitionID,$customerID)
{
    global $username;
    global $password;
    global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
	
	$priceGroupCustomerID = getNextID("Price_Group_Customer","price_group_customer_id");
 	$stmt = $db->prepare("INSERT INTO Price_Group_Customer (price_group_customer_id,price_group_definition_id,customer_id,timestamp) VALUES(?,?,?,NOW())");
	$stmt->bind_param('iii',$priceGroupCustomerID,$priceGroupDefinitionID,$customerID);
 	$stmt->execute(); 	
 	$stmt->close(); 
 	
 	return $priceGroupCustomerID;
}

function customerExistInPriceGroup($priceGroupDefinitionID,$customerID){
    
    global $username;
    global $password;
    global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(price_group_customer_id) FROM Price_Group_Customer WHERE price_group_definition_id='$priceGroupDefinitionID' AND customer_id='$customerID'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
} 

function insertCustomerGroupToPriceGroup($priceGroupDefinitionID,$customerGroupID)
{
    global $username;
    global $password;
    global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
	
	$priceGroupCustomerID = getNextID("Price_Group_Customer_Group","price_group_customer_id");
 	$stmt = $db->prepare("INSERT INTO Price_Group_Customer_Group (price_group_customer_id,price_group_definition_id,customer_group_id,timestamp) VALUES(?,?,?,NOW())");
	$stmt->bind_param('iii',$priceGroupCustomerID,$priceGroupDefinitionID,$customerGroupID);
 	$stmt->execute(); 	
 	$stmt->close(); 
 	
 	return $priceGroupCustomerID;
}

function customerGroupExistInPriceGroup($priceGroupDefinitionID,$customerGroupID){
    
    global $username;
    global $password;
    global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(price_group_customer_id) FROM Price_Group_Customer_Group WHERE price_group_definition_id='$priceGroupDefinitionID' AND customer_group_id='$customerGroupID'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
}

function getPriceGroupRuleID($priceGroupDefinitionID,$categoryID) {
global $username;
global $password;
global $database;
	$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT price_group_rule_id FROM Price_Group_Rules WHERE price_group_definition_id=? AND category_id=? LIMIT 1");
	$stm1->bind_param('ii',$priceGroupDefinitionID,$categoryID);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function getPriceGroupID($priceGroupCode) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT price_group_definition_id FROM Price_Group_Definitions WHERE price_group_code=? LIMIT 1");
	$stm1->bind_param('s',$priceGroupCode);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function priceGroupExist($priceGroupCode){
    
    global $username;
    global $password;
    global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(price_group_definition_id) FROM Price_Group_Definitions WHERE price_group_code='$priceGroupCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
}  

function supplierExists($customerCode) {

global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(customer_id) FROM Suppliers WHERE customer_code='$customerCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
}

function customerExists($customerCode) {

global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(customer_id) FROM Customers WHERE customer_code='$customerCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
}

function customerExistsInGroup($groupID,$customerID)
{
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(group_id) FROM Customer_CustomersGroup WHERE group_id='$groupID' AND customer_id='$customerID'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();

    return $z;
}

function updateSupplier($customerCode,$customer_company_name=" ",$customer_report_name=" ",$logo=" ",$registration_code=" ",$mobile=" ",$website=" ",$email=" ",$description=" ",$type_of_business=" ",$tic_code=" ",$vat_code=" ",$credit_limit=0,$address_code_eurosoft=" ",$customer_type=" ",$balance=0) {

    global $username, $password, $database;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Suppliers SET customer_company_name=?,customer_report_name=?,logo=?,registration_code=?,mobile=?,website=?,email=?,description=?,type_of_business=?,tic_code=?,vat_code=?,credit_limit=?,address_code_eurosoft=?,customer_type=?,balance=? WHERE customer_code='$customerCode'");
	$stmt1->bind_param('sssssssssssdssd',$customer_company_name,$customer_report_name,$logo,$registration_code,$mobile,$website,$email,$description,$type_of_business,$tic_code,$vat_code,$credit_limit,$address_code_eurosoft,$customer_type,$balance);
 	$stmt1->execute(); 	
 	$stmt1->close();

    // return $stmt->error;
    return getSupplierID($customerCode);
}

function updateCustomer($customerCode,$customer_company_name=" ",$customer_report_name=" ",$logo=" ",$registration_code=" ",$mobile=" ",$website=" ",$email=" ",$description=" ",$type_of_business=" ",$tic_code=" ",$vat_code=" ",$credit_limit=0,$address_code_eurosoft=" ",$customer_type=" ",$balance=0) {

    global $username, $password, $database;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Customers SET customer_company_name=?,customer_report_name=?,logo=?,registration_code=?,mobile=?,website=?,email=?,type_of_business=?,tic_code=?,vat_code=?,credit_limit=?,address_code_eurosoft=?,customer_type=?,balance=? WHERE customer_code='$customerCode'");
	$stmt1->bind_param('ssssssssssdssd',$customer_company_name,$customer_report_name,$logo,$registration_code,$mobile,$website,$email,$type_of_business,$tic_code,$vat_code,$credit_limit,$address_code_eurosoft,$customer_type,$balance);
 	$stmt1->execute(); 	
 	$stmt1->close();

    // return $stmt->error;
    return getCustomerID($customerCode);
}


function updateCustomerBalance($customerID,$balance) {

    global $username, $password, $database;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Customers SET balance=? WHERE customer_id=?");
	$stmt1->bind_param('ii',$balance,$customerID);
 	$stmt1->execute(); 	
 	$stmt1->close();

}

function insertSupplier($customer_code,$customer_company_name=" ",$customer_report_name=" ",$logo=" ",$registration_code=" ",$mobile=" ",$website=" ",$email=" ",$description=" ",$type_of_business="Credit",$tic_code=" ",$vat_code=" ",$credit_limit=0,$address_code_eurosoft=" ",$customer_type="Credit",$balance=0) {

    global $username, $password, $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
    $customer_id = getNextID("Suppliers","customer_id");
 	$stmt = $db->prepare("INSERT INTO Suppliers (customer_id,customer_code,customer_company_name,customer_report_name,logo,registration_code,mobile,website,email,description,type_of_business,tic_code,vat_code,credit_limit,address_code_eurosoft,customer_type,balance,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
	$stmt->bind_param('issssssssssssdssd',$customer_id,$customer_code,$customer_company_name,$customer_report_name,$logo,$registration_code,$mobile,$website,$email,$description,$type_of_business,$tic_code,$vat_code,$credit_limit,$address_code_eurosoft,$customer_type,$balance);
 	$stmt->execute();
    $stmt->execute();
 	$stmt->close();

    // return $stmt->error;
    return $customer_id;
}


function insertCustomer($customer_code,$customer_company_name=" ",$customer_report_name=" ",$logo=" ",$registration_code=" ",$mobile=" ",$website=" ",$email=" ",$description=" ",$type_of_business="Credit",$tic_code=" ",$vat_code=" ",$credit_limit=0,$address_code_eurosoft=" ",$customer_type="Credit",$balance=0) {

    global $username, $password, $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
    $customer_id = getNextID("Customers","customer_id");
 	$stmt = $db->prepare("INSERT INTO Customers (customer_id,customer_code,customer_company_name,customer_report_name,logo,registration_code,mobile,website,email,description,type_of_business,tic_code,vat_code,credit_limit,address_code_eurosoft,customer_type,balance,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
	$stmt->bind_param('issssssssssssdssd',$customer_id,$customer_code,$customer_company_name,$customer_report_name,$logo,$registration_code,$mobile,$website,$email,$description,$type_of_business,$tic_code,$vat_code,$credit_limit,$address_code_eurosoft,$customer_type,$balance);
 	$stmt->execute();
    $stmt->execute();
 	$stmt->close();

    // return $stmt->error;
    return $customer_id;
}


function insertCustomerToGroup($groupID,$customerID){
global $username;
global $password;
global $database;

    $db2 = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno())
 	{
 	    printf("Connect failed: %s\n", mysqli_connect_error());
 	    exit();
 	}
 	$db2->set_charset("utf8");
 	$stmt2 = $db2->prepare("INSERT INTO Customer_CustomersGroup (group_id,customer_id,added_date,timestamp) VALUES(?,?,CURDATE(),NOW())");
 	$stmt2->bind_param('ss',$groupID,$customerID);
 	$stmt2->execute();
 	$stmt2->close();
}

function customerExistsInOtherSALGroups($groupID,$customerID)
{
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(group_id) FROM Customer_CustomersGroup WHERE group_id IN(SELECT group_id FROM CustomerGroups WHERE description='SAL' AND NOT group_id='$groupID') AND customer_id='$customerID'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();

    return $z;
}

function removeCustomerfroOtherSALGroups($categorySALID,$customerID){
global $username;
global $password;
global $database;

    $db2 = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno())
 	{
 	    printf("Connect failed: %s\n", mysqli_connect_error());
 	    exit();
 	}
 	$db2->set_charset("utf8");
 	$stmt2 = $db2->prepare("DELETE FROM Customer_CustomersGroup WHERE group_id IN(SELECT group_id FROM CustomerGroups WHERE description='SAL' AND NOT group_id=?) AND customer_id=?");
 	$stmt2->bind_param('ss',$categorySALID,$customerID);
 	$stmt2->execute();
 	$stmt2->close();
 	
    $deleteID = getNextID("Deletes", "delete_id");
    $statement ="DELETE FROM Customer_CustomersGroup WHERE group_id IN(SELECT group_id FROM CustomerGroups WHERE description='SAL' AND NOT group_id='$categorySALID') AND customer_id=$customerID";
    $stmt2 = $db2->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
    $stmt2->bind_param('is',$deleteID,$statement);
    $stmt2->execute();
    $stmt2->close();

}
function categoryExists($categoryCode){
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(category_id) FROM Categories WHERE category_code='$categoryCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;


}


function updateCategory($categoryCode,$categoryName,$categoryDescription,$categoryLevel){
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Categories SET name=?,description=? WHERE category_code='$categoryCode'");
	$stmt1->bind_param('ss',$categoryName,$categoryDescription);
 	$stmt1->execute(); 	
 	$stmt1->close();

 	return getCategoryID($categoryCode);
}

function updateCategoryNameCustom($categoryCode,$categoryName,$categoryDescription){
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Categories SET name=? WHERE category_code='$categoryCode' AND description='$categoryDescription'");
	$stmt1->bind_param('s',$categoryName);
 	$stmt1->execute(); 	
 	$stmt1->close();

//  	return getCategoryID($categoryCode);
}

function insertCategory($categoryCode,$categoryName,$categoryDescription,$categoryLevel){
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
	$categoryID = getNextID("Categories","category_id");
 	$stmt = $db->prepare("INSERT INTO Categories (category_id,category_code,name,description,level,timestamp) VALUES(?,?,?,?,?,NOW())");
	$stmt->bind_param('isssi',$categoryID,$categoryCode,$categoryName,$categoryDescription,$categoryLevel);
 	$stmt->execute(); 	
 	$stmt->close();

 	return $categoryID;
}

function insertSubCategory($categoryID,$subcategoryID){
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
 	$stmt = $db->prepare("INSERT IGNORE INTO Subcategories (category_id,subcategory_id,date_added,timestamp) VALUES(?,?,NOW(),NOW())");
	$stmt->bind_param('ii',$categoryID,$subcategoryID);
 	$stmt->execute(); 	
 	$stmt->close();
}

function vatExits($vatCode)
{
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(vat_id) FROM Vats WHERE vat_code='$vatCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();
   
   
        return $z;

}

function updateVAT($vatCode,$vatName,$percentage)
{
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Vats SET vat_display_name = ?, percentage =? WHERE vat_code='$vatCode'");
	$stmt1->bind_param('sd',$vatName,$percentage);
 	$stmt1->execute(); 	
 	$stmt1->close();

    return getVatID($vatCode);
}


function insertVAT($vatCode,$vatName,$percentage)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
	$vatID = getNextID("Vats","vat_id");
 	$stmt = $db->prepare("INSERT INTO Vats (vat_id,vat_code,vat_display_name,percentage) VALUES(?,?,?,?)");
	$stmt->bind_param('issd',$vatID,$vatCode,$vatName,$percentage);
 	$stmt->execute(); 	
 	$stmt->close();

 	return $vatID;
}



function getVatID($vatCode)
{
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
			$z=$counter;		
	 }
	 $stm1->close();
   
   
        return $z;



}


function getVatItemID($itemID)
{
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT vat_id FROM Items WHERE item_id='$itemID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
			$z=$counter;		
	 }
	 $stm1->close();
   
   
        return $z;


}
function itemExits($itemCode)
{
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(item_id) FROM Items WHERE item_code='$itemCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();  
   
        return $z;
}

function itemExistsInCategory($itemID, $categoryID){
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(item_id) FROM Category_Item WHERE category_id='$categoryID' AND item_id='$itemID' LIMIT 1 ");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();


    return $z;


}

function itemExistsInDescriptedCategory($itemID, $categoryID, $descripton){
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(item_id) FROM Category_Item WHERE category_id IN (select category_id FROM Categories WHERE description='$descripton') AND item_id='$itemID' AND NOT category_id='$categoryID'  LIMIT 1 ");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();


    return $z;


}

function removeItemfromDescreptedCategory($itemID, $categoryID, $descripton){
global $username;
global $password;
global $database;

    $db2 = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno())
 	{
 	    printf("Connect failed: %s\n", mysqli_connect_error());
 	    exit();
 	}
 	$db2->set_charset("utf8");
 	$stmt2 = $db2->prepare("DELETE FROM Category_Item WHERE category_id IN(SELECT category_id FROM Categories WHERE description=? AND NOT category_id=?) AND item_id=?");
 	$stmt2->bind_param('sii',$descripton,$categoryID,$itemID);
 	$stmt2->execute();
 	$stmt2->close();
 	
    $deleteID = getNextID("Deletes", "delete_id");
    $statement ="DELETE FROM Category_Item WHERE category_id IN(SELECT category_id FROM Categories WHERE description='$descripton' AND NOT category_id='$categoryID') AND item_id='$itemID'";
    $stmt2 = $db2->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
    $stmt2->bind_param('is',$deleteID,$statement);
    $stmt2->execute();
    $stmt2->close();

}

function removeItemfromCategory($itemID, $categoryID){
global $username;
global $password;
global $database;

    $db2 = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno())
 	{
 	    printf("Connect failed: %s\n", mysqli_connect_error());
 	    exit();
 	}
 	$db2->set_charset("utf8");
 	$stmt2 = $db2->prepare("DELETE FROM Category_Item WHERE category_id=? AND item_id=?");
 	$stmt2->bind_param('ii',$categoryID,$itemID);
 	$stmt2->execute();
 	$stmt2->close();
 	
    $deleteID = getNextID("Deletes", "delete_id");
    $statement ="DELETE FROM Category_Item WHERE category_id='$categoryID' AND item_id='$itemID'";
    $stmt2 = $db2->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
    $stmt2->bind_param('is',$deleteID,$statement);
    $stmt2->execute();
    $stmt2->close();

}

function insertItem($item_code,$item_sku='',$company_id=0,$vat_id=0,$subunits=1,$sales_units='EACH',$manufacturer_id=0,$name='',$short_description='',$long_description='',$thumbnail_url='',$reorder_level=0,$target_qty=0,$bundled='',$max_stock=0,$min_stock=0,$packing=0,$stock_control='yes',$sellable='yes',$weight=0,$cbm=0,$status='yes')
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
 	$db->set_charset("utf8");
    $item_id = getNextID("Items","item_id");
 	$stmt = $db->prepare("INSERT INTO Items(item_id,item_code,item_sku,company_id,vat_id,subunits,sales_units,manufacturer_id,name,short_description,long_description,thumbnail_url,reorder_level,target_qty,bundled,max_stock,min_stock,packing,stock_control,sellable,weight,cbm,status,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 	$stmt->bind_param('issiidsissssdisdddssdds',$item_id,$item_code,$item_sku,$company_id,$vat_id,$subunits,$sales_units,$manufacturer_id,$name,$short_description,$long_description,$thumbnail_url,$reorder_level,$target_qty,$bundled,$max_stock,$min_stock,$packing,$stock_control,$sellable,$weight,$cbm,$status);
 	$stmt->execute();
 	echo $stmt->error;
 	$stmt->close();
 	

 	return $item_id ;
}


function updateItem($itemCode,$vatID=0,$subUnits=1,$salesUnits='',$name='',$shortDescription='',$longDescription='',$itemWeight=0,$status='yes',$packing=0)
{
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Items SET vat_id=?,subunits=?,sales_units=?,name=?,short_description=?,weight=?,status=?,subunits=?,packing=? WHERE item_code='$itemCode'");
	$stmt1->bind_param('issssdsdd',$vatID,$subunits,$salesUnits,$name,$shortDescription,$itemWeight,$status,$subUnits,$packing);
 	$stmt1->execute(); 
 	$stmt1->close();
 	
 	return getItemID($itemCode);

}

function setInactiveItemsNotInArray($itemIDs){
    $status = "inactive";
    global $username;
    global $password;
    global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Items SET status=? WHERE item_id NOT IN ($itemIDs)");
	$stmt1->bind_param('s',$status);
 	$stmt1->execute(); 	
 	$stmt1->close();
}

function setInactiveCustomersNotInArray($customerIDs){
    $status = "Inactive";
    global $username;
    global $password;
    global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Customers SET type_of_business=? WHERE customer_id NOT IN ($customerIDs)");
	$stmt1->bind_param('s',$status);
 	$stmt1->execute(); 	
 	$stmt1->close();
}

function  insetBarcode($barcode,$itemID)
{
    global $username;
    global $password;
    global $database;
    $db2 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");
    $stmt2 = $db2->prepare("INSERT INTO Item_Barcode (item_id,barcode) VALUES(?,?)");
    $stmt2->bind_param('ss',$itemID,$barcode);
    $stmt2->execute();
    $stmt2->close();

}

function  insertUOM($uomID,$description,$active)
{
    global $username;
    global $password;
    global $database;
    $db2 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");
    $stmt2 = $db2->prepare("REPLACE INTO UOMs (uom_id,description,active) VALUES(?,?,?)");
    $stmt2->bind_param('iss',$uomID,$description,$active);
    $stmt2->execute();
    $stmt2->close();

}

function UOMExists($uomID,$uomDescription){
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(uom_id) FROM UOMs WHERE uom_id='$uomID' AND description='$uomDescription'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();

    return $z;

}

function  insertUOMGroup($uomgroupID,$description,$uomID,$multiplier)
{
    global $username;
    global $password;
    global $database;
    $db2 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");
    $stmt2 = $db2->prepare("REPLACE INTO ZG_Uom_Groups (uom_group_id,description,uom_id,multiplier) VALUES(?,?,?,?)");
    $stmt2->bind_param('isii',$uomgroupID,$description,$uomID,$multiplier);
    $stmt2->execute();
    $stmt2->close();

}

function  insertUOMItem($itemID,$uomID,$position,$multiplier)
{
    global $username;
    global $password;
    global $database;
    $db2 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");
    $stmt2 = $db2->prepare("REPLACE INTO UOM_Item (item_id, uom_id, position, multiplier, timestamp) VALUES(?,?,?,?,NOW())");
    $stmt2->bind_param('iiii',$itemID,$uomID,$position,$multiplier);
    $stmt2->execute();
    $stmt2->close();

}

function UOMItemExists($itemID,$uomID,$multiplier){
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(item_id) FROM UOM_Item WHERE item_id='$itemID' AND uom_id='$uomID' AND multiplier='$multiplier'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();

    return $z;

}

function getUOMMultiplier($uomgroupID,$uomID)
{
global $username;
global $password;
global $database;
	$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT multiplier FROM ZG_Uom_Groups WHERE uom_group_id='$uomgroupID' AND uom_id='$uomID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
				$z=$counter;	
	 }
	 $stm1->close();  
   
        return $z;
}

function UOMGroupExists($uomgroupID,$uomID,$multiplier){
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(uom_group_id) FROM ZG_Uom_Groups WHERE uom_group_id='$uomgroupID' AND uom_id='$uomID' AND multiplier='$multiplier'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();

    return $z;

}

function  insetBarcodeDefaultFlag($barcode,$itemID)
{
    global $username;
    global $password;
    global $database;
    $no=' ';
    $yes='yes';
    $db2 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    
    
    $stmt2 = $db2->prepare("SELECT item_id FROM Item_Barcode WHERE barcode=? AND NOT item_id=? LIMIT 1");
    $stmt2->bind_param('si',$barcode,$itemID);
    $stmt2-> execute();
    $stmt2-> bind_result($redundantItemID);
    while ($stmt2->fetch()) {
        
        $db3 = new mysqli('localhost',$username,$password,$database);
     	if (mysqli_connect_errno())
     	{
     	    printf("Connect failed: %s\n", mysqli_connect_error());
     	    exit();
     	}
     	$db3->set_charset("utf8");
     	$stmt3 = $db3->prepare("DELETE FROM Item_Barcode WHERE item_id=? AND barcode=?");
     	$stmt3->bind_param('is',$redundantItemID,$barcode);
     	$stmt3->execute();
     	$stmt3->close();
     	
        $deleteID = getNextID("Deletes", "delete_id");
        $statement ="DELETE FROM Item_Barcode WHERE item_id='$redundantItemID' AND barcode='$barcode'";
        $stmt3 = $db3->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
        $stmt3->bind_param('is',$deleteID,$statement);
        $stmt3->execute();
        $stmt3->close();
        
    }
    $stmt2->close();
    

    
    $db2->set_charset("utf8");
    $stmt2 = $db2->prepare("UPDATE Item_Barcode SET default_barcode=? WHERE item_id=?");
    $stmt2->bind_param('si',$no,$itemID);
    $stmt2->execute();
    $stmt2->close();
    
    $db2->set_charset("utf8");
    $stmt2 = $db2->prepare("UPDATE Item_Barcode SET default_barcode=? WHERE item_id=? AND barcode=?");
    $stmt2->bind_param('sis',$yes,$itemID,$barcode);
    $stmt2->execute();
    $stmt2->close();
    
    $db2->set_charset("utf8");
    $stmt2 = $db2->prepare("UPDATE Items SET item_sku=? WHERE item_id=?");
    $stmt2->bind_param('si',$barcode,$itemID);
    $stmt2->execute();
    $stmt2->close();

}

function  barcodeExists($barcode,$itemID)
{
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(item_id) FROM Item_Barcode WHERE item_id=? AND barcode=?");
    $stm1->bind_param('is',$itemID,$barcode);
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();

    return $z;


}

function insertPrices($itemID,$priceTypeId,$price)
{
global $username;
global $password;
global $database;
    
	  $db1 = new mysqli(localhost,$username,$password,$database);
	  if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	          }
 	$db1->set_charset("utf8");
 	$stmt1 = $db1->prepare("INSERT INTO Prices(item_id,pricetype_id,price) VALUES(?,?,?) ON DUPLICATE KEY UPDATE price=?");
 	$stmt1->bind_param('iidd',$itemID,$priceTypeId,$price,$price);
 	$stmt1->execute();
     $stmt1->close();
  

}


function getItemID($itemCode)
{
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT item_id FROM Items WHERE item_code='$itemCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
				$z=$counter;	
	 }
	 $stm1->close();  
   
        return $z;
}

function getSupplierID($customerCode) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_id FROM Suppliers WHERE customer_code=? LIMIT 1");
	$stm1->bind_param('s',$customerCode);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}


function getCustomerID($customerCode) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_id FROM Customers WHERE customer_code=? LIMIT 1");
	$stm1->bind_param('s',$customerCode);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function getCompanyID($companyCode) {
global $username;
global $password;
global $database;
	$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT company_id FROM Companies WHERE company_code=? LIMIT 1");
	$stm1->bind_param('s',$companyCode);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function getCustomFormCode($customFormID) {
global $username;
global $password;
global $database;
	$z='';
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT custom_form_code FROM ZA_Custom_Form_Definition WHERE custom_form_definition_id=? LIMIT 1");
	$stm1->bind_param('s',$customFormID);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function getCustomFieldID($customFieldName) {
global $username;
global $password;
global $database;
	$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT custom_field_id FROM ZA_Custom_Field_Definition WHERE custom_field_name=? LIMIT 1");
	$stm1->bind_param('s',$customFieldName);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function getCustomFormObjectID($linkedTable,$linkedTableID,$customFormID) {
global $username;
global $password;
global $database;
	$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT custom_form_object_id FROM  ZA_Custom_Form_Object,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Object.custom_form_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table=? AND linked_table_id=? AND ZA_Custom_Form_Object.custom_form_id=?");
	$stm1->bind_param('sii',$linkedTable,$linkedTableID,$customFormID);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function insertCustomFormObject($customFormID,$customFormCode,$linkedTableID)
{
    global $username;
    global $password;
    global $database;

	  $db = new mysqli(localhost,$username,$password,$database);
 	  if (mysqli_connect_errno()) 
      {
    	   printf("Connect failed: %s\n", mysqli_connect_error());
    	   exit();
	  }
	  $customFormObjectID = getNextID("ZA_Custom_Form_Object", "custom_form_object_id");
	  $db->set_charset("utf8");  
      $stmt3 = $db->prepare("INSERT INTO ZA_Custom_Form_Object (custom_form_object_id,custom_form_id,custom_form_code,linked_table_id,timestamp) VALUES(?,?,?,?,NOW())");
 	  $stmt3->bind_param('iisi',$customFormObjectID,$customFormID,$customFormCode,$linkedTableID);
 	  $stmt3->execute();
 	  $stmt3->close();
 	  
 	  return $customFormObjectID;
	
}

function getCustomFieldObjectID($customFieldID,$customFormObjectID) {
global $username;
global $password;
global $database;
	$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT custom_field_object_id FROM ZA_Custom_Field_Object WHERE custom_field_id=? AND custom_form_object_id=?");
	$stm1->bind_param('ii',$customFieldID,$customFormObjectID);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function insertCustomFieldObject($customFieldID,$customFormObjectID,$customFieldValue) {
global $username;
global $password;
global $database;
	 $db = new mysqli(localhost,$username,$password,$database);
 	   if (mysqli_connect_errno()) 
    	{
    	   printf("Connect failed: %s\n", mysqli_connect_error());
    	   exit();
	  }
	  $customFieldObjectID = getNextID("ZA_Custom_Field_Object","custom_field_object_id");
	  $db->set_charset("utf8");  
      $stmt3 = $db->prepare("INSERT INTO ZA_Custom_Field_Object (custom_field_object_id,custom_field_id,custom_form_object_id,value,timestamp) VALUES(?,?,?,?,NOW())");
 	  $stmt3->bind_param('iiis', $customFieldObjectID, $customFieldID, $customFormObjectID, $customFieldValue);
 	  $stmt3->execute();
 	  $stmt3->close();
}

function updateCustomFieldObject($customFieldObjectID,$customFieldValue) {

    global $username;
    global $password;
    global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE ZA_Custom_Field_Object SET value= ? WHERE custom_field_object_id=?");
	$stmt1->bind_param('si',$customFieldValue,$customFieldObjectID);
 	$stmt1->execute(); 	
 	$stmt1->close();

}

function insertContractPrice($customerID,$itemID,$price,$discount=0,$priceListID='')
{
global $username;
global $password;
global $database;

        if((int)$priceListID==0){$priceListID=10005;}
    
	    $db = new mysqli(localhost,$username,$password,$database);
 	   if (mysqli_connect_errno()) 
    	{
    	   printf("Connect failed: %s\n", mysqli_connect_error());
    	   exit();
	  }
	  $db->set_charset("utf8");  
     $stmt3 = $db->prepare("INSERT INTO ContractPrices (customer_id,item_id,price,percentage,pricetype_id) VALUES(?,?,?,?,?) ON DUPLICATE KEY UPDATE price=?,percentage=?,pricetype_id=?");
 	  $stmt3->bind_param('ssddiddi',$customerID,$itemID,$price,$discount,$priceListID,$price,$discount,$priceListID);
 	  $stmt3->execute();
 	  $stmt3->close();
	
}

function insertContractPricePercentage($customerID,$itemID,$price,$discount=0,$priceListID='')
{
global $username;
global $password;
global $database;

        if((int)$priceListID==0){$priceListID=10005;}
    
	    $db = new mysqli(localhost,$username,$password,$database);
 	   if (mysqli_connect_errno()) 
    	{
    	   printf("Connect failed: %s\n", mysqli_connect_error());
    	   exit();
	  }
	  $db->set_charset("utf8");  
     $stmt3 = $db->prepare("INSERT INTO ContractPrices (customer_id,item_id,price,percentage,pricetype_id) VALUES(?,?,?,?,?) ON DUPLICATE KEY UPDATE percentage=?,pricetype_id=?");
 	  $stmt3->bind_param('ssddidi',$customerID,$itemID,$price,$discount,$priceListID,$discount,$priceListID);
 	  $stmt3->execute();
 	  $stmt3->close();
	
}

function insertContractPriceHelper($customerID,$itemID,$price,$discount=0,$priceListID='')
{
    global $username;
    global $password;
    global $database;
    
    if(strcmp($priceListID,'')==0){$priceListID=10005;}
    
	    $db = new mysqli(localhost,$username,$password,$database);
 	   if (mysqli_connect_errno()) 
    	{
    	   printf("Connect failed: %s\n", mysqli_connect_error());
    	   exit();
	  }
	  $db->set_charset("utf8");  
     $stmt3 = $db->prepare("INSERT INTO ContractPrices_Helper (customer_id,item_id,price,percentage,pricetype_id) VALUES(?,?,?,?,?) ON DUPLICATE KEY UPDATE price=?,percentage=?,pricetype_id=?");
 	  $stmt3->bind_param('ssddiddi',$customerID,$itemID,$price,$discount,$priceListID,$price,$discount,$priceListID);
 	  $stmt3->execute();
 	  $stmt3->close();
	
}

function  deleteContractPricesHelper()
{
    global $username;
    global $password;
    global $database;
    
	$db1 = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
    	exit();
	}
    
    $db1->set_charset("utf8");  
    $stmt5 = $db1->prepare("DELETE FROM ContractPrices_Helper WHERE 1=1");
    $stmt5->execute();
    $stmt5->close();

}

function removeContractPricesNotInHelper()
{
    global $username;
    global $password;
    global $database;

    $db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_id,item_id,min_qty FROM ContractPrices WHERE (customer_id,item_id,min_qty) NOT IN(SELECT customer_id,item_id,min_qty FROM ContractPrices_Helper)");
	$stm1-> execute();
	$stm1-> bind_result($customerID,$itemID,$minQty);
	while ($stm1->fetch()) {
		
        $db2 = new mysqli(localhost,$username,$password,$database);
     	if (mysqli_connect_errno())
     	{
     	    printf("Connect failed: %s\n", mysqli_connect_error());
     	    exit();
     	}
     	$db2->set_charset("utf8");
     	$stmt2 = $db2->prepare("DELETE FROM ContractPrices WHERE customer_id=? AND item_id=? AND min_qty=?");
     	$stmt2->bind_param('iid',$customerID,$itemID,$minQty);
     	$stmt2->execute();
     	$stmt2->close();
     	
        $deleteID = getNextID("Deletes", "delete_id");
        $statement ="DELETE FROM ContractPrices WHERE customer_id=$customerID AND item_id=$itemID AND min_qty=$minQty";
        $stmt2 = $db2->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
        $stmt2->bind_param('is',$deleteID,$statement);
        $stmt2->execute();
        $stmt2->close();
		
	 }
	 $stm1->close();
	 
//      $resetFlag = '0000-00-00';
//      $stmt3 = $db->prepare("UPDATE ContractPrices SET valid_from=? WHERE NOT valid_from = ?");
//  	 $stmt3->bind_param('ss',$resetFlag,$flag);
//  	 $stmt3->execute();
//  	 $stmt3->close();


    

}

function warehouseExists($warehouseCode)
{
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(warehouse_id) FROM Warehouses WHERE warehouse_code='$warehouseCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();  
   
        return $z;


}


function updateWarehouse($warehouseCode,$warehouseName,$region)
{
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Warehouses SET name= ?, region= ? WHERE warehouse_code='$warehouseCode'");
	$stmt1->bind_param('ss',$warehouseName,$region);
 	$stmt1->execute(); 	
 	$stmt1->close();

 	return getWarehouseID($warehouseCode);

}


function insertWarehouse($warehouseCode,$warehouseName,$region) {

	global $username;
global $password;
global $database;
		$db2 = new mysqli(localhost,$username,$password,$database);
 		if (mysqli_connect_errno()) 
 		{
      		printf("Connect failed: %s\n", mysqli_connect_error());
    		  exit();
 		}
 		$db2->set_charset("utf8");
		$warehouseID = getNextID("Warehouses","warehouse_id");
		 $stmt2 = $db2->prepare("INSERT INTO Warehouses (warehouse_id,warehouse_code,name,region) VALUES(?,?,?,?)");
 		$stmt2->bind_param('isss',$warehouseID,$warehouseCode,$warehouseName,$region);
 		$stmt2->execute();
 		$stmt2->close();

 		return $warehouseID;
}



function getCategoryID($categoryCode){
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT category_id FROM Categories WHERE category_code='$categoryCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;


}

function getCategoryIDCustom($categoryCode,$description){
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT category_id FROM Categories WHERE category_code='$categoryCode' AND description='$description' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;


}

function insertItemToB2BCategory($itemID,$categoryID)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
	 $db->set_charset("utf8");  
 	$stmt3 = $db->prepare("INSERT IGNORE INTO Category_Item (category_id,item_id) VALUES(?,?)");
 	$stmt3->bind_param('ss',$categoryID,$itemID);
 	$stmt3->execute();
 	$stmt3->close();


}



function insertItemToCategory($itemID,$categoryID)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
	 $db->set_charset("utf8");  
 	$stmt3 = $db->prepare("INSERT INTO Category_Item (category_id,item_id) VALUES(?,?)");
 	$stmt3->bind_param('ss',$categoryID,$itemID);
 	$stmt3->execute();
 	$stmt3->close();


}

function getWarehouseID($warehouseCode)
{
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT warehouse_id FROM Warehouses WHERE warehouse_code='$warehouseCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();  
   
        return $z;


}

function getWarehouseRegion($warehouseCode)
{
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT region FROM Warehouses WHERE warehouse_code='$warehouseCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();  
   
        return $z;


}

function stockExists($warehouseID,$itemID,$batchnumber)
{
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT warehouse_id FROM Stock WHERE warehouse_id='$warehouseID' AND item_id='$itemID' AND batch_number='$batchnumber' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();  
   
        return $z;


}


function insertStock($warehouseID,$itemID,$batchnumber,$available,$onOrder,$reserved,$delivered)
{
	global $username;
global $password;
global $database;

  
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
	
 	$stmt3 = $db->prepare("INSERT INTO Stock (warehouse_id,item_id,batch_number,available,reserved,delivered,on_order) VALUES(?,?,?,?,?,?,?) ON DUPLICATE KEY UPDATE available=?,reserved=?,on_order=?");
 	$stmt3->bind_param('iisddddddd',$warehouseID,$itemID,$batchnumber,$available,$reserved,$delivered,$onOrder,$available,$reserved,$onOrder);
 	$stmt3->execute();
 	$stmt3->close();
  




}


function getCustomerIDFromAddress($addressCode)
{
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_id FROM Customers WHERE address_code_eurosoft =? LIMIT 1");
	$stm1->bind_param('s',$addressCode);
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();  
   
        return $z;

}

function addressExists($addressCode)
{
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(customer_address_id) FROM CustomerAddress WHERE address_code='$addressCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();  
   
        return $z;


}

function supplierAddressExists($addressCode)
{
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(supplier_address_id) FROM SupplierAddress WHERE address_code='$addressCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();  
   
        return $z;


}

function insertSupplierAddress($customerID,$addressCode,$addressLine1=" ",$addressLine2=" ",$postcode=" ",$country=" ",$city=" ",$landline=" ",$primaryAddress=" ")
{
    global $username;
    global $password;
    global $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $addressID = getNextID("SupplierAddress","supplier_address_id");
    $stmt3 = $db->prepare("INSERT INTO SupplierAddress (supplier_address_id,address_code,supplier_id,country,city,address_line_1,address_line_2,postcode,landline,primary_address) VALUES(?,?,?,?,?,?,?,?,?,?)");
    $stmt3->bind_param('isisssssss',$addressID,$addressCode,$customerID,$country,$city,$addressLine1,$addressLine2,$postcode,$landline,$primaryAddress);
    $stmt3->execute();
    echo $stmt3->error;
    $stmt3->close();

    return $addressID;

}

function insertAddress($customerID,$addressCode,$addressLine1=" ",$addressLine2=" ",$postcode=" ",$country=" ",$city=" ",$landline=" ",$primaryAddress=" ")
{
    global $username;
    global $password;
    global $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $addressID = getNextID("CustomerAddress","customer_address_id");
    $stmt3 = $db->prepare("INSERT INTO CustomerAddress (customer_address_id,address_code,customer_id,country,city,address_line_1,address_line_2,postcode,landline,primary_address) VALUES(?,?,?,?,?,?,?,?,?,?)");
    $stmt3->bind_param('isisssssss',$addressID,$addressCode,$customerID,$country,$city,$addressLine1,$addressLine2,$postcode,$landline,$primaryAddress);
    $stmt3->execute();
    $stmt3->close();

    return $addressID;

}

function updateSupplierAddress($customerID,$addressCode,$addressLine1=" ",$addressLine2=" ",$postcode=" ",$country=" ",$city=" ",$landline=" ",$primaryAddress=" ")
{
    global $username;
    global $password;
    global $database;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stmt1 = $db1->prepare("UPDATE SupplierAddress SET supplier_id=?,country=?,city=?,address_line_1=?,address_line_2=?,postcode=?,landline=?,primary_address=? WHERE address_code='$addressCode'");
    $stmt1->bind_param('isssssss',$customerID,$country,$city,$addressLine1,$addressLine2,$postcode,$landline,$primaryAddress);
    $stmt1->execute();
    $stmt1->close();

    return getAddressID($addressCode);
}

function updateAddress($customerID,$addressCode,$addressLine1=" ",$addressLine2=" ",$postcode=" ",$country=" ",$city=" ",$landline=" ",$primaryAddress=" ")
{
    global $username;
    global $password;
    global $database;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stmt1 = $db1->prepare("UPDATE CustomerAddress SET customer_id=?,country=?,city=?,address_line_1=?,address_line_2=?,postcode=?,landline=?,primary_address=? WHERE address_code='$addressCode'");
    $stmt1->bind_param('isssssss',$customerID,$country,$city,$addressLine1,$addressLine2,$postcode,$landline,$primaryAddress);
    $stmt1->execute();
    $stmt1->close();

    return getAddressID($addressCode);
}


function setCustomerEmailWebste($customerID,$email,$website)
{
global $username;
global $password;
global $database;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Customers SET email= ?, website= ? WHERE customer_id='$customerID'");
	$stmt1->bind_param('ss',$email,$website);
 	$stmt1->execute(); 	
 	$stmt1->close();


}

function contactExists($customerID)
{
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(contact_person_id) FROM Contact_Person WHERE customer_id='$customerID'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();  
   
        return $z;

}

function getContactID($customerID) {
    global $username;
    global $password;
    global $database;
    $z="";
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT contact_person_id FROM Contact_Person WHERE customer_id=? LIMIT 1");
    $stm1->bind_param('s',$customerID);

    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {

        $z=$counter;

    }
    $stm1->close();


    return $z;
}

function insertContact($customer_id,$first_name=' ',$last_name=' ',$position=1,$landline=' ',$mobile=' ',$fax=' ',$email=' ',$notes=' ')
{
    global $username;
    global $password;
    global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
 	}
 	$db->set_charset("utf8");
    $contact_person_id = getNextID("Contact_Person","contact_person_id");
 	$stmt3 = $db->prepare("INSERT INTO Contact_Person (contact_person_id,first_name,last_name,position,landline,mobile,fax,email,customer_id,notes,timestamp ) VALUES(?,?,?,?,?,?,?,?,?,?,NOW())");
 	$stmt3->bind_param('isssssssis',$contact_person_id,$first_name,$last_name,$position,$landline,$mobile,$fax,$email,$customer_id,$notes);
 	$stmt3->execute();
 	$stmt3->close();

 	return $contact_person_id;
}

function updateContact($customerID,$first_name='',$last_name='',$position=1,$landline='',$mobile='',$fax='',$email='',$notes='')
{
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");
	$stmt1 = $db1->prepare("UPDATE Contact_Person SET first_name=?,last_name=?,position=?,landline=?,mobile=?,fax=?,email=?,notes=? WHERE customer_id='$customerID'");
	$stmt1->bind_param('ssssssss',$first_name,$last_name,$position,$landline,$mobile,$fax,$email,$notes);
 	$stmt1->execute(); 	
 	$stmt1->close();

 	return getContactID($customerID);
 	
 }

function groupExist($groupCode)
{
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(group_id) FROM CustomerGroups WHERE group_code='$groupCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();  
   
        return $z;
}

function insertGroup($groupCode,$groupName,$description)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
	 $groupID = getNextID("CustomerGroups","group_id");
	 
 	$db->set_charset("utf8");
 	$stmt3 = $db->prepare("INSERT INTO CustomerGroups (group_id,group_code,name,description) VALUES(?,?,?,?)");
 	$stmt3->bind_param('isss',$groupID,$groupCode,$groupName,$description);
 	$stmt3->execute();
 	$stmt3->close();

 	return $groupID;
}

function updateGroup($groupCode,$groupName,$description)
{
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");
	$stmt1 = $db1->prepare("UPDATE CustomerGroups SET name= ?, description=? WHERE group_code='$groupCode'");
	$stmt1->bind_param('ss',$groupName,$description);
 	$stmt1->execute(); 	
 	$stmt1->close();

 	return getGroupID($groupCode);
}


function insertPriceType($priceCode,$priceName)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
	 $db->set_charset("utf8");
    $priceTypeID = getNextID("PriceTypes","pricetype_id");
 	$stmt3 = $db->prepare("INSERT INTO PriceTypes (pricetype_id,price_code,name) VALUES(?,?,?)");
 	$stmt3->bind_param('iss',$priceTypeID,$priceCode,$priceName);
 	$stmt3->execute();
 	$stmt3->close();

 	return $priceTypeID;

}

function priceTypeExists($priceCode)
{
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(pricetype_id) FROM PriceTypes WHERE price_code='$priceCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();

    return $z;
}

function getPriceTypeID($priceCode) {
    global $username;
    global $password;
    global $database;
    $z=0;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT pricetype_id FROM PriceTypes WHERE price_code='$priceCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {

        $z=$counter;

    }
    $stm1->close();


    return $z;
}

function getCustomersFromPriceType($customerPriceTypeID){
    global $username;
    global $password;
    global $database;
    $z= array();
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT customer_id FROM Customer_Pricelist WHERE pricetype_id='$customerPriceTypeID'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {

        array_push($z,$counter);

    }
    $stm1->close();
    
    return $z;
}

function getCustomersFromGroup($customersGroupID){
    global $username;
    global $password;
    global $database;
    $z= array();
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT customer_id FROM Customer_CustomersGroup WHERE group_id='$customersGroupID'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {

        array_push($z,$counter);

    }
    $stm1->close();
    
    return $z;
}

function getCustomerPriceTypeID($customerID) {
    global $username;
    global $password;
    global $database;
    $z=0;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT pricetype_id FROM Customer_Pricelist WHERE customer_id='$customerID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {

        $z=$counter;

    }
    $stm1->close();


    return $z;
}

function customerChanged($customerCode,$customerName)
{
global $username;
global $password;
global $database;
	$z=true;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(customer_id) FROM Customers WHERE customer_code='$customerCode' AND customer_company_name='$customerName' ");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=false;
		}
	 }
	 $stm1->close();  
   
        return $z;




}

function addressChanged($addressCode,$addressLine1,$addressLine2)
{
//global $username;
//global $password;
//global $database;
	//$z=true;
  //  	$db1 = new mysqli(localhost,$username,$password,$database);
	//if (mysqli_connect_errno()) {
  //  		printf("Connect failed: %s\n", mysqli_connect_error());
   // 		exit();
	//}
 	//$db1->set_charset("utf8");

	//$stm1 = $db1->prepare("SELECT COUNT(customer_address_id) FROM CustomerAddress WHERE address_code='$addressCode' AND //address_line_1='$addressLine1' AND address_line_2 ='$addressLine2'");
	//$stm1-> execute();
	//$stm1-> bind_result($counter);
	//while ($stm1->fetch()) {
	//	if($counter>0)
	//	{
	//		$z=false;
	//	}
	// }
	// $stm1->close();  

$z = false;
   
        return $z;


}

function itemChanged($itemCode,$name='',$vatID='')
{
global $username;
global $password;
global $database;
	$z=true;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(item_id) FROM Items WHERE item_code='$itemCode' AND name ='$name'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=false;
		}
	 }
	 $stm1->close();  
   
        return $z;




}


function getNextID($tableName,$idName)
{
global $username;
global $password;
global $database;
global $prefix;
$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$likeVar = $prefix."%";
	$stm1 = $db1->prepare("SELECT $idName FROM $tableName WHERE $idName LIKE '$likeVar' ORDER BY $idName DESC LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($nextID);
	while ($stm1->fetch()) {
		
			$z = substr($nextID,4,strlen($nextID));
			$z+=1;
			
		
	 }
	 $stm1->close();  
   
   
return $prefix.$z;
   
       


}

function insertBalance($customerCode,$balance)
{
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");
	$stmt1 = $db1->prepare("UPDATE Customers SET balance= ? WHERE customer_code='$customerCode'");
	$stmt1->bind_param('d',$balance);
 	$stmt1->execute(); 	
 	$stmt1->close();



}

function getSupplierAddressID($addressCode) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT supplier_address_id FROM SupplierAddress WHERE address_code=? LIMIT 1");
    $stm1->bind_param("s",$addressCode);
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function getAddressID($addressCode) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_address_id FROM CustomerAddress WHERE address_code=? LIMIT 1");
    $stm1->bind_param("s",$addressCode);
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}


function getSalespersonID($salespersonCode) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT salesperson_id FROM SalesPersons WHERE salesperson_code='$salespersonCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function insertInvoice($invoiceCode,$printCount,$invoiceDATE,$customerID,$billingAddressID,$deliveryAddressID,$warehouseID,$salespersonID,$invoiceType,$details,$dueDate,$subTotalInvo,$vatTotalInvo,$discountTotalInvo,$grandTotal,$timestamp)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
 	$db->set_charset("utf8");
	$companyID=1;
	$status ="Not Paid";
	$invoiceID = getNextID("Invoices","invoice_id");
 	$stmt = $db->prepare("INSERT INTO Invoices(invoice_id,invoice_code,company_id,customer_id,salesperson_id,grand_total,invoice_address_id,delivery_address_id,print_count,invoice_date,details,invoice_type,due_date,status,subtotal,vat_amount,discount_amount,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 	$stmt->bind_param('isiiidiiisssssddd',$invoiceID,$invoiceCode,$companyID,$customerID,$salespersonID,$grandTotal,$billingAddressID,$deliveryAddressID,$printCount,$invoiceDATE,$details,$invoiceType,$dueDate,$status,$subTotalInvo,$vatTotalInvo,$discountTotalInvo);
 	$stmt->execute(); 	
 	$error = $stmt->error;
 	$stmt->close();
 
    if(strcmp($error,'')!=0){
 	    return 0 ;
 	} else {
 	    return $invoiceID ;
    }


}

function purchaseOrderExists($order_code)
{

global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(order_id) FROM Purchase_Orders WHERE order_code='$order_code'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
}



function insertOrderHeader($orderCode,$tenderID, $customerID, $salespersonID, $orderDate,$deliveryDate, $subTotal, $grandTotal, $vatTotal, $discount, $notes)
{
	global $username;
	global $password;
	global $database;


	$status="Placed";
	$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno())
	{
		printf("Connect failed: %s\n", mysqli_connect_error());
		exit();
	}
$db->set_charset("utf8");

    $orderID = getNextID("Orders","order_id");
    $stmt3 = $db->prepare("INSERT INTO Orders (order_id,order_code,tender_id,customer_id,salesperson_id,order_date,delivery_date,subtotal,grand_total,vat_amount,discount_amount,details,status,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
    $stmt3->bind_param('issiissddddss',$orderID,$orderCode,$tenderID,$customerID,$salespersonID,$orderDate,$deliveryDate,$subTotal,$grandTotal,$vatTotal,$discount,$notes,$status);
    $stmt3->execute();
    $stmt3->close();
    return $orderID;


}

function insertPurchaseOrder($sha1,$order_code,$company_id,$customer_id,$salesperson_id,$paymenttype_id,$order_date,$subtotal,$grand_total,$vat_amount,$discount_amount,$print_count,$order_address_id,$delivery_address_id,$tender_id,$vat_i_or_e,$delivery_date,$deposit_amount,$details,$status,$currency_id,$global_discount_percentage,$delivery_method,$shipping_company,$tracking_number,$loading_date,$landing_date,$cbm_total,$cover_period_start,$cover_period_end)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
 	$db->set_charset("utf8");
 	$order_id = getNextID("Purchase_Orders","order_id");
 	$stmt = $db->prepare("INSERT INTO Purchase_Orders(order_id, order_code, company_id, customer_id, salesperson_id, paymenttype_id, order_date, subtotal, grand_total, vat_amount, discount_amount, print_count, order_address_id, delivery_address_id, tender_id, vat_i_or_e, delivery_date, deposit_amount, details, status, currency_id, global_discount_percentage, delivery_method, shipping_company, tracking_number, loading_date, landing_date, cbm_total, cover_period_start, cover_period_end, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 	$stmt->bind_param('isiiiisddddiiiissdssidsssssdss',$order_id,$order_code,$company_id,$customer_id,$salesperson_id,$paymenttype_id,$order_date,$subtotal,$grand_total,$vat_amount,$discount_amount,$print_count,$order_address_id,$delivery_address_id,$tender_id,$vat_i_or_e,$delivery_date,$deposit_amount,$details,$status,$currency_id,$global_discount_percentage,$delivery_method,$shipping_company,$tracking_number,$loading_date,$landing_date,$cbm_total,$cover_period_start,$cover_period_end);
 	$stmt->execute(); 	
 	$stmt->close();
 	$stmt3 = $db->prepare("INSERT INTO Purchase_Orders_Hash (order_id,hash) VALUES(?,?)");
 	$stmt3->bind_param('is',$order_id,$sha1);
 	$stmt3->execute();
 	echo $stmt3->error;
 	$stmt3->close();
 	return $order_id ;


}

function updatePurchaseOrder($sha1,$order_id,$order_code,$company_id,$customer_id,$salesperson_id,$paymenttype_id,$order_date,$subtotal,$grand_total,$vat_amount,$discount_amount,$print_count,$order_address_id,$delivery_address_id,$tender_id,$vat_i_or_e,$delivery_date,$deposit_amount,$details,$status,$currency_id,$global_discount_percentage,$delivery_method,$shipping_company,$tracking_number,$loading_date,$landing_date,$cbm_total,$cover_period_start,$cover_period_end)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
 	$db->set_charset("utf8");
	$companyID=1;

 	$stmt = $db->prepare("UPDATE Purchase_Orders SET company_id=?, customer_id=?, salesperson_id=?, paymenttype_id=?, order_date=?, subtotal=?, grand_total=?, vat_amount=?, discount_amount=?, print_count=?, order_address_id=?, delivery_address_id=?, tender_id=?, vat_i_or_e=?, delivery_date=?, deposit_amount=?, details=?, status=?, currency_id=?, global_discount_percentage=?, delivery_method=?, shipping_company=?, tracking_number=?, loading_date=?, landing_date=?, cbm_total=?, cover_period_start=?, cover_period_end=?, timestamp=NOW() WHERE order_code=?");
 	$stmt->bind_param('iiiisddddiiiissdssidsssssdsss',$company_id,$customer_id,$salesperson_id,$paymenttype_id,$order_date,$subtotal,$grand_total,$vat_amount,$discount_amount,$print_count,$order_address_id,$delivery_address_id,$tender_id,$vat_i_or_e,$delivery_date,$deposit_amount,$details,$status,$currency_id,$global_discount_percentage,$delivery_method,$shipping_company,$tracking_number,$loading_date,$landing_date,$cbm_total,$cover_period_start,$cover_period_end,$order_code);
 	$stmt->execute(); 	
 	$stmt->close();
 	$stmt3 = $db->prepare("INSERT INTO Purchase_Orders_Hash (order_id,hash) VALUES(?,?) ON DUPLICATE KEY UPDATE hash=?");
 	$stmt3->bind_param('iss',$order_id,$sha1,$sha1);
 	$stmt3->execute();
 	echo $stmt3->error;
 	$stmt3->close();
 	return $order_id ;


}

function updatePurchaseOrderStatus($status,$orderID)
{
    global $username;
    global $password;
    global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
 	$db->set_charset("utf8");
	$companyID=1;

 	$stmt = $db->prepare("UPDATE Purchase_Orders SET status=? WHERE order_id=?");
 	$stmt->bind_param('si',$status,$orderID);
 	$stmt->execute(); 	
 	$stmt->close();



}

function insertPurchaseOrderLine($order_id,$item_id,$qty,$qty_delivered,$qty_invoiced,$unit_price,$line_discount,$global_discount,$line_discount_percentage,$vat_amount,$pricetype_id,$vat_id,$description,$delivery_date)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
 	$db->set_charset("utf8");

	

	$order_item_id = getNextID("Purchase_Order_Item","order_item_id");
 	$stmt = $db->prepare("INSERT INTO Purchase_Order_Item(order_item_id, order_id, item_id, qty, qty_delivered, qty_invoiced, unit_price, line_discount, global_discount, line_discount_percentage, vat_amount, pricetype_id, vat_id, description, delivery_date, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 	$stmt->bind_param('iiiddddddddiiss',$order_item_id,$order_id,$item_id,$qty,$qty_delivered,$qty_invoiced,$unit_price,$line_discount,$global_discount,$line_discount_percentage,$vat_amount,$pricetype_id,$vat_id,$description,$delivery_date);
 	$stmt->execute(); 
 	echo $stmt->error;
 	$stmt->close();
    
 	return $order_item_id ;



}

function removePurchaseOrderLines($order_id)
{
global $username;
global $password;
global $database;

    $db2 = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno())
 	{
 	    printf("Connect failed: %s\n", mysqli_connect_error());
 	    exit();
 	}
 	$db2->set_charset("utf8");
 	$stmt2 = $db2->prepare("DELETE FROM Purchase_Order_Item WHERE order_id=?");
 	$stmt2->bind_param('i',$order_id);
 	$stmt2->execute();
 	$stmt2->close();
 	
    $deleteID = getNextID("Deletes", "delete_id");
    $statement ="DELETE FROM Purchase_Order_Item WHERE order_id=$order_id";
    $stmt2 = $db2->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
    $stmt2->bind_param('is',$deleteID,$statement);
    $stmt2->execute();
    $stmt2->close();

}

function getPurchaseOrderID($order_code) 
{
global $username;
global $password;
global $database;
	$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT order_id FROM Purchase_Orders WHERE order_code='$order_code' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function getHashPurchaseOrder($orderID) {

global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli("p:".localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT hash FROM Purchase_Orders_Hash WHERE order_id='$orderID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($hash);
	while ($stm1->fetch()) {
	
	 }
	 $stm1->close();
   
   
    return $hash;
}

function insertLine($invoiceID,$itemID,$qty,$lineTotal,$lineDiscount,$globalDiscount,$vatTotal,$description,$priceCode,$warehouseID,$unitPrice,$vatID,$timestamp)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
 	$db->set_charset("utf8");
	$companyID=1;
	$status ="Not Paid";
	
    if(strcmp($itemID,'') != 0)
    {
	$invoiceItemID = getNextID("Invoice_Item","invoice_item_id");
	$batch="0";
	if($unitPrice==0)
	{
		$unitPrice = $lineTotal/$qty;
	}
 	$stmt = $db->prepare("INSERT INTO Invoice_Item(invoice_item_id,invoice_id,item_id,batch_number,warehouse_id,qty,unit_price,line_discount,global_discount,vat_amount,description,vat_id,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 	$stmt->bind_param('iiisidddddsi',$invoiceItemID,$invoiceID,$itemID,$batch,$warehouseID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$vatTotal,$description,$vatID);
 	$stmt->execute(); 	
 	$stmt->close();
    }
 	return $invoiceID ;



}


function getPrice($priceCode,$itemID) {
global $username;
global $password;
global $database;
	$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT price FROM Prices WHERE pricetype_id='$priceCode' AND item_id='$itemID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function orderExists($order_code)
{

    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(order_id) FROM Orders WHERE order_code='$order_code' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();

// 	 echo "SELECT COUNT(order_id) FROM Orders WHERE order_code='$order_code' LIMIT 1 || $counter <br>";


    return $z;
}

function orderHasPick($order_code)
{

    global $username;
    global $password;
    global $database;

    $z=false;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT order_id FROM Orders WHERE order_code='$order_code' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($orderID);
    while ($stm1->fetch()) {}
    $stm1->close();

    if(intval($orderID) > 0){
        $stm1 = $db1->prepare("SELECT Pick_Order.pick_id FROM Pick_Order,Pick WHERE Pick_Order.pick_id=Pick.pick_id AND Pick_Order.order_id='$orderID' AND NOT Pick.status LIKE 'Canceled' LIMIT 1");
        $stm1-> execute();
        $stm1-> bind_result($pickID);
        while ($stm1->fetch()) {
            if(intval($pickID) > 0){
                $z=true;
            }
        }
        $stm1->close();
    }

    return $z;
}

function insertOrderSingleTransaction($orderCode,$companyID,$customerID,$salespersonID,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$billingAddress,$deliveryAddress,$orderDate,$dueDate,$details,$globalDiscountPercentage,$status,$warehouseID,$tenderID,$currencyID,$actionHash,$orderItems)
{
    global $username;
    global $password;
    global $database;

    $db3 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db3->set_charset("utf8");

    try {
        $db3->begin_transaction();

        $orderCode = "$orderCode";
        $companyID = intval($companyID);
        $customerID = intval($customerID);
        $salespersonID = intval($salespersonID);
        $paymentMethod = intval($paymentMethod);
        $subtotal = floatval($subtotal);
        $grandTotal = floatval($grandTotal);
        $vatTotal = floatval($vatTotal);
        $discount = floatval($discount);
        $billingAddress = intval($billingAddress);
        $deliveryAddress = intval($deliveryAddress);
        $orderDate = "$orderDate";
        $dueDate = "$dueDate";
        $details = "$details";
        $globalDiscountPercentage = floatval($globalDiscountPercentage);
        $status = "$status";
        $warehouseID = "$warehouseID";
        $tenderID = "$tenderID";
        $currencyID = "$currencyID";
        $actionHash = "$actionHash";

        $orderID = getNextIDSingleTransaction("Orders","order_id",$db3);
        $stmt3 = $db3->prepare("INSERT INTO Orders (order_id,order_code,company_id,customer_id,salesperson_id,paymenttype_id,subtotal,grand_total,vat_amount,discount_amount,order_address_id,delivery_address_id,order_date,delivery_date,details,global_discount_percentage,status, delivery_method,tender_id,currency_id,action_hash) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt3->bind_param('isiiiiddddiisssdssiis',$orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$billingAddress,$deliveryAddress,$orderDate,$dueDate,$details,$globalDiscountPercentage,$status,$warehouseID,$tenderID,$currencyID,$actionHash);
        $stmt3->execute();
        if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
        $stmt3->close();

        $discount = floatval($discount);

        if(count($orderItems) == 0) {throw new Exception();}

        foreach($orderItems as $orderItem)
        {

            $itemID         = intval($orderItem->itemID);
            $qty            = floatval($orderItem->qty);
            $unitPrice      = floatval($orderItem->unitPrice);
            $lineDiscount   = floatval($orderItem->lineDiscount);
            $globalDiscount = floatval($orderItem->globalDiscount);
            $vatTotal       = floatval($orderItem->vatTotal);
            $priceType      = intval($orderItem->priceTypeID);
            $vatID          = intval($orderItem->vatID);
            $discPercent    = floatval($orderItem->lineDiscountPercent);
            $itemNotes      = "$orderItem->itemNotes";
            $promotionNumber = intval($orderItem->promotionNumber);

            $orderItemID = getNextIDSingleTransaction("Order_Item","order_item_id",$db3);
            $stmt3 = $db3->prepare("INSERT INTO Order_Item (order_item_id,order_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description,promotion_number) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt3->bind_param('iiidddddiidsi', $orderItemID, $orderID, $itemID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID,$discPercent,$itemNotes,$promotionNumber);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
            $stmt3->close();
        }

        $db3->commit(true);

        return $orderID;

    } catch (Exception  $e) {

        $errorlogfile = fopen('ERROR_LOG_FILE.TXT','w');
        fwrite($errorlogfile , "\n ".date('Y-m-d H:i:s')." - insertOrderSingleTransaction() :: ".$e->getMessage()." :: ".$e->getLine());
        fclose($errorlogfile);

        $db3->rollback();

        return 0;

    }


}

function updateOrderSingleTransaction($orderCode,$companyID,$customerID,$salespersonID,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$billingAddress,$deliveryAddress,$orderDate,$dueDate,$details,$globalDiscountPercentage,$status,$warehouseID,$tenderID,$currencyID,$actionHash,$orderItems)
{
    global $username;
    global $password;
    global $database;

    $db3 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db3->set_charset("utf8");

    try {
        $db3->begin_transaction();

        $sapStatus = "$status";

        $stmt3 = $db3->prepare("SELECT order_id,status,action_hash FROM Orders WHERE order_code=? LIMIT 1");
        $stmt3->bind_param('s',$orderCode);
        $stmt3-> execute();
        $stmt3-> bind_result($orderID,$status,$prevActionHash);
        while ($stmt3->fetch()) {}
        $stmt3->close();

        if(strcmp("$sapStatus","Closed")==0){
            $status = "$sapStatus";
        }

        if(strcmp("$actionHash","$prevActionHash")!=0){

            $orderCode = "$orderCode";
            $companyID = intval($companyID);
            $customerID = intval($customerID);
            $salespersonID = intval($salespersonID);
            $paymentMethod = intval($paymentMethod);
            $subtotal = floatval($subtotal);
            $grandTotal = floatval($grandTotal);
            $vatTotal = floatval($vatTotal);
            $discount = floatval($discount);
            $billingAddress = intval($billingAddress);
            $deliveryAddress = intval($deliveryAddress);
            $orderDate = "$orderDate";
            $dueDate = "$dueDate";
            $details = "$details";
            $globalDiscountPercentage = floatval($globalDiscountPercentage);
            $status = "$status";
            $warehouseID = "$warehouseID";
            $tenderID = "$tenderID";
            $currencyID = "$currencyID";
            $actionHash = "$actionHash";


            $stmt3 = $db3->prepare("UPDATE Orders SET order_code=?,company_id=?,customer_id=?,salesperson_id=?,paymenttype_id=?,subtotal=?,grand_total=?,vat_amount=?,discount_amount=?,order_address_id=?,delivery_address_id=?,order_date=?,delivery_date=?,details=?,global_discount_percentage=?,status=?, delivery_method=?,tender_id=?,currency_id=?,action_hash=? WHERE order_id=?");
            $stmt3->bind_param('siiiiddddiisssdssiisi',$orderCode,$companyID,$customerID,$salespersonID,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$billingAddress,$deliveryAddress,$orderDate,$dueDate,$details,$globalDiscountPercentage,$status,$warehouseID,$tenderID,$currencyID,$actionHash,$orderID);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception("$orderCode ($orderID) $actionHash ".$stmt3->error);}
            $stmt3->close();

            $stmt3 = $db3->prepare("DELETE FROM Order_Item WHERE order_id=?");
            $stmt3->bind_param('i',$orderID);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
            $stmt3->close();

            $deleteID = getNextIDSingleTransaction("Deletes", "delete_id",$db3);
            $statement ="DELETE FROM Order_Item WHERE order_id=$orderID";
            $stmt3 = $db3->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
            $stmt3->bind_param('is',$deleteID,$statement);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
            $stmt3->close();

            $discount = floatval($discount);

            // if(count($orderItems) == 0) {throw new Exception();}

            foreach($orderItems as $orderItem)
            {

                $itemID         = intval($orderItem->itemID);
                $qty            = floatval($orderItem->qty);
                $unitPrice      = floatval($orderItem->unitPrice);
                $lineDiscount   = floatval($orderItem->lineDiscount);
                $globalDiscount = floatval($orderItem->globalDiscount);
                $vatTotal       = floatval($orderItem->vatTotal);
                $priceType      = intval($orderItem->priceTypeID);
                $vatID          = intval($orderItem->vatID);
                $discPercent    = floatval($orderItem->lineDiscountPercent);
                $itemNotes      = "$orderItem->itemNotes";
                $promotionNumber = intval($orderItem->promotionNumber);

                $orderItemID = getNextIDSingleTransaction("Order_Item","order_item_id",$db3);
                $stmt3 = $db3->prepare("INSERT INTO Order_Item (order_item_id,order_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description,promotion_number) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)");
                $stmt3->bind_param('iiidddddiidsi', $orderItemID, $orderID, $itemID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID,$discPercent,$itemNotes,$promotionNumber);
                $stmt3->execute();
                if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
                $stmt3->close();
            }
        } else {
            $orderID = -1;
        }

        $db3->commit(true);

        return $orderID;

    } catch (Exception  $e) {

        $errorlogfile = fopen('ERROR_LOG_FILE.TXT','w');
        fwrite($errorlogfile , "\n ".date('Y-m-d H:i:s')." - insertOrderSingleTransaction() :: ".$e->getMessage()." :: ".$e->getLine());
        fclose($errorlogfile);

        $db3->rollback();

        return 0;

    }


}



function invoiceExists($invoiceCode) {

global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(invoice_id) FROM Invoices WHERE invoice_code='$invoiceCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
}

function invoiceHasWaybill($invoice_code)
{

    global $username;
    global $password;
    global $database;

    $z=false;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT invoice_id FROM Invoices WHERE invoice_code='$invoice_code' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($invoiceID);
    while ($stm1->fetch()) {}
    $stm1->close();

    if(intval($invoiceID) > 0){
        $stm1 = $db1->prepare("SELECT Waybill_Invoice.waybill_id FROM Waybill_Invoice,Waybills WHERE Waybill_Invoice.waybill_id=Waybills.waybill_id AND Waybill_Invoice.invoice_id='$invoiceID' AND NOT Waybills.status LIKE 'Canceled' LIMIT 1");
        $stm1-> execute();
        $stm1-> bind_result($waybillID);
        while ($stm1->fetch()) {
            if(intval($waybillID) > 0){
                $z=true;
            }
        }
        $stm1->close();
    }

    return $z;
}

function insertInvoiceSingleTransaction($invoiceCode,$companyID,$customerID,$salespersonID,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$billingAddress,$deliveryAddress,$invoiceDate,$dueDate,$details,$globalDiscountPercentage,$status,$tenderID,$orderID,$vatIE,$invoiceType,$currencyID,$actionHash,$invoiceItems)
{
    global $username;
    global $password;
    global $database;

    $db3 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db3->set_charset("utf8");

    try {
        $db3->begin_transaction();

        $invoiceCode = "$invoiceCode";
        $companyID = intval($companyID);
        $customerID = intval($customerID);
        $salespersonID = intval($salespersonID);
        $paymentMethod = intval($paymentMethod);
        $subtotal = floatval($subtotal);
        $grandTotal = floatval($grandTotal);
        $vatTotal = floatval($vatTotal);
        $discount = floatval($discount);
        $billingAddress = intval($billingAddress);
        $deliveryAddress = intval($deliveryAddress);
        $invoiceDate = "$invoiceDate";
        $dueDate = "$dueDate";
        $details = "$details";
        $globalDiscountPercentage = floatval($globalDiscountPercentage);
        $status = "$status";
        $tenderID = "$tenderID";
        $orderID = "$orderID";
        $vatIE = "$vatIE";
        $currencyID = "$currencyID";
        $actionHash = "$actionHash";
        $invoiceType = "$invoiceType";
        $printCount = 0;

        $invoiceID = getNextIDSingleTransaction("Invoices","invoice_id",$db3);
        $stmt3 = $db3->prepare("INSERT INTO Invoices (invoice_id, invoice_code, company_id, customer_id, salesperson_id, paymenttype_id, order_id, tender_id, subtotal, grand_total, vat_amount, vat_i_e, discount_amount, invoice_address_id, delivery_address_id, print_count, invoice_date, details, invoice_type, due_date, status, currency_id, global_discount_percentage, action_hash) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt3->bind_param('isiiiiiidddsdiiisssssids',$invoiceID,$invoiceCode,$companyID,$customerID,$salespersonID,$paymentMethod,$orderID,$tenderID,$subtotal,$grandTotal,$vatTotal,$vatIE,$discount,$billingAddress,$deliveryAddress,$printCount,$invoiceDate,$details,$invoiceType,$dueDate,$status,$currencyID,$globalDiscountPercentage,$actionHash);
        $stmt3->execute();
        if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
        $stmt3->close();

        $discount = floatval($discount);

        if(count($invoiceItems) == 0) {throw new Exception();}

        foreach($invoiceItems as $invoiceItem)
        {

            $itemID         = intval($invoiceItem->itemID);
            $qty            = floatval($invoiceItem->qty);
            $unitPrice      = floatval($invoiceItem->unitPrice);
            $lineDiscount   = floatval($invoiceItem->lineDiscount);
            $globalDiscount = floatval($invoiceItem->globalDiscount);
            $vatTotal       = floatval($invoiceItem->vatTotal);
            $priceType      = intval($invoiceItem->priceTypeID);
            $vatID          = intval($invoiceItem->vatID);
            $warehouseID    = intval($invoiceItem->warehouseID);
            $batchNumber    = "$invoiceItem->batchNumber";
            $serialNumber   = "$invoiceItem->serialNumber";
            $discPercent    = floatval($invoiceItem->lineDiscountPercent);
            $itemNotes      = "$invoiceItem->itemNotes";
            $promotionNumber = intval($invoiceItem->promotionNumber);

            $invoiceItemID = getNextIDSingleTransaction("Invoice_Item","invoice_item_id",$db3);
            $stmt3 = $db3->prepare("INSERT INTO Invoice_Item (invoice_item_id, invoice_id, item_id, batch_number, warehouse_id, qty, unit_price, line_discount, global_discount, line_discount_percentage, vat_amount, pricetype_id, vat_id, serialnumber,promotion_number, description) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt3->bind_param('iiisiddddddiiiss',$invoiceItemID,$invoiceID,$itemID,$batchNumber,$warehouseID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$discPercent,$vatTotal,$priceType,$vatID,$serialNumber,$promotionNumber,$itemNotes);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
            $stmt3->close();
        }

        $db3->commit(true);

        return $invoiceID;

    } catch (Exception  $e) {

        $errorlogfile = fopen('ERROR_LOG_FILE.TXT','w');
        fwrite($errorlogfile , "\n ".date('Y-m-d H:i:s')." - insertInvoiceSingleTransaction() :: ".$e->getMessage()." :: ".$e->getLine());
        fclose($errorlogfile);

        $db3->rollback();

        return 0;

    }


}

function updateInvoiceSingleTransaction($invoiceCode,$companyID,$customerID,$salespersonID,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$billingAddress,$deliveryAddress,$invoiceDate,$dueDate,$details,$globalDiscountPercentage,$status,$tenderID,$orderID,$vatIE,$invoiceType,$currencyID,$actionHash,$invoiceItems)
{
    global $username;
    global $password;
    global $database;

    $db3 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db3->set_charset("utf8");

    try {
        $db3->begin_transaction();

        $sapStatus = "$status";

        $stmt3 = $db3->prepare("SELECT invoice_id,status,action_hash FROM Invoices WHERE invoice_code=? LIMIT 1");
        $stmt3->bind_param('s',$invoiceCode);
        $stmt3-> execute();
        $stmt3-> bind_result($invoiceID,$status,$prevActionHash);
        while ($stmt3->fetch()) {}
        $stmt3->close();

        if(strcmp("$sapStatus","Closed")==0){
            $status = "$sapStatus";
        }

        if(strcmp("$actionHash","$prevActionHash")!=0){

            $invoiceCode = "$invoiceCode";
            $companyID = intval($companyID);
            $customerID = intval($customerID);
            $salespersonID = intval($salespersonID);
            $paymentMethod = intval($paymentMethod);
            $subtotal = floatval($subtotal);
            $grandTotal = floatval($grandTotal);
            $vatTotal = floatval($vatTotal);
            $discount = floatval($discount);
            $billingAddress = intval($billingAddress);
            $deliveryAddress = intval($deliveryAddress);
            $orderDate = "$invoiceDate";
            $dueDate = "$dueDate";
            $details = "$details";
            $globalDiscountPercentage = floatval($globalDiscountPercentage);
            $status = "$status";
            $tenderID = "$tenderID";
            $currencyID = "$currencyID";
            $actionHash = "$actionHash";


            $stmt3 = $db3->prepare("UPDATE Invoices SET invoice_code=?,company_id=?,customer_id=?,salesperson_id=?,paymenttype_id=?,order_id=?,tender_id=?,subtotal=?,grand_total=?,vat_amount=?,vat_i_e=?,discount_amount=?,invoice_address_id=?,delivery_address_id=?,invoice_date=?,details=?,invoice_type=?,due_date=?,status=?,currency_id=?,global_discount_percentage=?,action_hash=? WHERE invoice_id=?");
            $stmt3->bind_param('siiiiiidddsdiisssssidsi',$invoiceCode,$companyID,$customerID,$salespersonID,$paymentMethod,$orderID,$tenderID,$subtotal,$grandTotal,$vatTotal,$vatIE,$discount,$billingAddress,$deliveryAddress,$invoiceDate,$details,$invoiceType,$dueDate,$status,$currencyID,$globalDiscountPercentage,$actionHash,$invoiceID);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception("$invoiceCode ($invoiceID) $actionHash ".$stmt3->error);}
            $stmt3->close();

            $stmt3 = $db3->prepare("DELETE FROM Invoice_Item WHERE invoice_id=?");
            $stmt3->bind_param('i',$invoiceID);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
            $stmt3->close();

            $deleteID = getNextIDSingleTransaction("Deletes", "delete_id",$db3);
            $statement ="DELETE FROM Invoice_Item WHERE invoice_id=$invoiceID";
            $stmt3 = $db3->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
            $stmt3->bind_param('is',$deleteID,$statement);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
            $stmt3->close();

            $discount = floatval($discount);

            if(count($invoiceItems) == 0) {throw new Exception();}

            foreach($invoiceItems as $invoiceItem)
            {

                $itemID         = intval($invoiceItem->itemID);
                $qty            = floatval($invoiceItem->qty);
                $unitPrice      = floatval($invoiceItem->unitPrice);
                $lineDiscount   = floatval($invoiceItem->lineDiscount);
                $globalDiscount = floatval($invoiceItem->globalDiscount);
                $vatTotal       = floatval($invoiceItem->vatTotal);
                $priceType      = intval($invoiceItem->priceTypeID);
                $vatID          = intval($invoiceItem->vatID);
                $warehouseID    = intval($invoiceItem->warehouseID);
                $batchNumber    = "$invoiceItem->batchNumber";
                $serialNumber   = "$invoiceItem->serialNumber";
                $discPercent    = floatval($invoiceItem->lineDiscountPercent);
                $itemNotes      = "$invoiceItem->itemNotes";
                $promotionNumber = intval($invoiceItem->promotionNumber);

                $invoiceItemID = getNextIDSingleTransaction("Invoice_Item","invoice_item_id",$db3);
                $stmt3 = $db3->prepare("INSERT INTO Invoice_Item (invoice_item_id, invoice_id, item_id, batch_number, warehouse_id, qty, unit_price, line_discount, global_discount, line_discount_percentage, vat_amount, pricetype_id, vat_id, serialnumber,promotion_number, description) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                $stmt3->bind_param('iiisiddddddiiiss',$invoiceItemID,$invoiceID,$itemID,$batchNumber,$warehouseID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$discPercent,$vatTotal,$priceType,$vatID,$serialNumber,$promotionNumber,$itemNotes);
                $stmt3->execute();
                if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
                $stmt3->close();
            }
        } else {
            $invoiceID = -1;
        }

        $db3->commit(true);

        return $invoiceID;

    } catch (Exception  $e) {

        $errorlogfile = fopen('ERROR_LOG_FILE.TXT','w');
        fwrite($errorlogfile , "\n ".date('Y-m-d H:i:s')." - insertInvoiceSingleTransaction() :: ".$e->getMessage()." :: ".$e->getLine());
        fclose($errorlogfile);

        $db3->rollback();

        return 0;

    }


}


function receiptExists($receiptCode) {

    $z=false;

    global $username,$password,$database;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(receipt_id) FROM Receipts WHERE receipt_code='$receiptCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0) {$z=true;}
    }
    $stm1->close();

    return $z;
}

function insertReceiptSingleTransaction($receiptCode,$customerID,$companyID,$salespersonID,$orderID,$invoiceID,$addressID,$amount,$paymentMethod,$cashDiscount,$bank,$branch,$chequeNumber,$chequeDate,$receiptDate,$printCount,$notes,$status,$actionHash,$receiptItems)
{
    global $username;
    global $password;
    global $database;

    $db3 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db3->set_charset("utf8");

    try {
        $db3->begin_transaction();

        $receiptCode = "$receiptCode";
        $customerID = intval($customerID);
        $companyID = intval($companyID);
        $salespersonID = intval($salespersonID);
        $orderID = intval($orderID);
        $invoiceID = intval($invoiceID);
        $addressID = intval($addressID);
        $amount = floatval($amount);
        $paymentMethod = trim($paymentMethod);
        $cashDiscount = floatval($cashDiscount);
        $bank = "$bank";
        $branch = "$branch";
        $chequeNumber = "$chequeNumber";
        $chequeDate = "$chequeDate";
        $receiptDate = "$receiptDate";
        $printCount = intval($printCount);
        $notes = "$notes";
        $actionHash = "$actionHash";
        $status = "$status";

        $receiptID = getNextIDSingleTransaction("Receipts","receipt_id",$db3);
        $stmt3 = $db3->prepare("INSERT INTO Receipts (receipt_id, receipt_code, customer_id, company_id, salesperson_id, order_id, invoice_id, address_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, receipt_date, notes,print_count,status,action_hash,action_time,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),NOW())");
        $stmt3->bind_param('isiiiiiidsdsssssssss', $receiptID, $receiptCode, $customerID, $companyID, $salespersonID, $orderID, $invoiceID, $addressID, $amount, $paymentMethod, $cashDiscount, $bank, $branch, $chequeNumber, $chequeDate, $receiptDate, $notes,$printCount,$status,$actionHash);
        $stmt3->execute();
        if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
        $stmt3->close();


        foreach($receiptItems as $receiptItem) {

            $amount = floatval($receiptItem->amount);
            $paymentMethod = trim($receiptItem->paymentMethod);
            $cashDiscount = floatval($receiptItem->cashDiscount);
            $bank = "$receiptItem->bank";
            $branch = "$receiptItem->branch";
            $chequeNumber = "$receiptItem->chequeNumber";
            $chequeDate = "$receiptItem->chequeDate";
            $notes = "$receiptItem->notes";

            $receiptItemID = getNextIDSingleTransaction("Receipt_Item","receipt_item_id",$db3);
            $stmt3 = $db3->prepare("INSERT INTO Receipt_Item (receipt_item_id, receipt_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, notes) VALUES (?,?,?,?,?,?,?,?,?,?)");
            $stmt3->bind_param('iidsdsssss',$receiptItemID,$receiptID,$amount,$paymentMethod,$cashDiscount,$bank,$branch,$chequeNumber,$chequeDate,$notes);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
            $stmt3->close();
        }

        $db3->commit(true);

        return $receiptID;

    } catch (Exception  $e) {

        $errorlogfile = fopen('ERROR_LOG_FILE.TXT','w');
        fwrite($errorlogfile , "\n ".date('Y-m-d H:i:s')." - insertReceiptSingleTransaction() :: ".$e->getMessage()." :: ".$e->getLine());
        fclose($errorlogfile);

        $db3->rollback();

        return 0;

    }


}

function updateReceiptSingleTransaction($receiptCode,$customerID,$companyID,$salespersonID,$orderID,$invoiceID,$addressID,$amount,$paymentMethod,$cashDiscount,$bank,$branch,$chequeNumber,$chequeDate,$receiptDate,$printCount,$notes,$status,$actionHash,$receiptItems){
    global $username;
    global $password;
    global $database;

    $db3 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db3->set_charset("utf8");

    try {
        $db3->begin_transaction();

        $stmt3 = $db3->prepare("SELECT receipt_id,status,action_hash FROM Receipts WHERE receipt_code=? LIMIT 1");
        $stmt3->bind_param('s',$receiptCode);
        $stmt3-> execute();
        $stmt3-> bind_result($receiptID,$prevStatus,$prevActionHash);
        while ($stmt3->fetch()) {}
        $stmt3->close();


        if(strcmp("$actionHash","$prevActionHash")!=0){

            $receiptCode = "$receiptCode";
            $customerID = intval($customerID);
            $companyID = intval($companyID);
            $salespersonID = intval($salespersonID);
            $orderID = intval($orderID);
            $invoiceID = intval($invoiceID);
            $addressID = intval($addressID);
            $amount = floatval($amount);
            $paymentMethod = trim($paymentMethod);
            $cashDiscount = floatval($cashDiscount);
            $bank = "$bank";
            $branch = "$branch";
            $chequeNumber = "$chequeNumber";
            $chequeDate = "$chequeDate";
            $receiptDate = "$receiptDate";
            $printCount = intval($printCount);
            $notes = "$notes";
            $actionHash = "$actionHash";
            $status = "$status";

            $stmt3 = $db3->prepare("UPDATE Receipts SET customer_id=?, company_id=?, salesperson_id=?, order_id=?, invoice_id=?, address_id=?, amount=?, payment_method=?, cash_discount=?, bank=?, branch=?, cheque_number=?, cheque_date=?, receipt_date=?, notes=?,print_count=?,status=?,action_hash=? WHERE receipt_id=?");
            $stmt3->bind_param('iiiiiidsdssssssissi',$customerID,$companyID,$salespersonID,$orderID,$invoiceID,$addressID,$amount,$paymentMethod,$cashDiscount,$bank,$branch,$chequeNumber,$chequeDate,$receiptDate,$notes,$printCount,$status,$actionHash,$receiptID);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception("$receiptCode ($receiptID) $actionHash ".$stmt3->error);}
            $stmt3->close();

            $stmt3 = $db3->prepare("DELETE FROM Receipt_Item WHERE receipt_id=?");
            $stmt3->bind_param('i',$receiptID);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
            $stmt3->close();

            $deleteID = getNextIDSingleTransaction("Deletes", "delete_id",$db3);
            $statement ="DELETE FROM Receipt_Item WHERE receipt_id=$receiptID";
            $stmt3 = $db3->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
            $stmt3->bind_param('is',$deleteID,$statement);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
            $stmt3->close();

            foreach($receiptItems as $receiptItem) {

                $amount = floatval($receiptItem->amount);
                $paymentMethod = trim($receiptItem->paymentMethod);
                $cashDiscount = floatval($receiptItem->cashDiscount);
                $bank = "$receiptItem->bank";
                $branch = "$receiptItem->branch";
                $chequeNumber = "$receiptItem->chequeNumber";
                $chequeDate = "$receiptItem->chequeDate";
                $notes = "$receiptItem->notes";

                $receiptItemID = getNextIDSingleTransaction("Receipt_Item","receipt_item_id",$db3);
                $stmt3 = $db3->prepare("INSERT INTO Receipt_Item (receipt_item_id, receipt_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, notes) VALUES (?,?,?,?,?,?,?,?,?,?)");
                $stmt3->bind_param('iidsdsssss',$receiptItemID,$receiptID,$amount,$paymentMethod,$cashDiscount,$bank,$branch,$chequeNumber,$chequeDate,$notes);
                $stmt3->execute();
                if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
                $stmt3->close();
            }


        } else {
            $receiptID = -1;
        }

        $db3->commit(true);

        return $receiptID;

    } catch (Exception  $e) {

        $errorlogfile = fopen('ERROR_LOG_FILE.TXT','w');
        fwrite($errorlogfile , "\n ".date('Y-m-d H:i:s')." - UpdateReceiptSingleTransaction() :: ".$e->getMessage()." :: ".$e->getLine());
        fclose($errorlogfile);

        $db3->rollback();

        return 0;

    }

}


function returnExists($returnCode) {
    global $username,$password,$database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stm1 = $db1->prepare("SELECT COUNT(return_id) FROM Returns WHERE return_code='$returnCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0) {
            $z=true;
        }
    }
    $stm1->close();

    return $z;

}

function insertReturnSingleTransaction($returnCode,$companyID,$customerID,$salespersonID,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$returnAddress,$returnDate,$dueDate,$details,$globalDiscountPercentage,$status,$orderID,$vatIE,$returnType,$currencyID,$actionHash,$returnItems){

    global $username, $password, $database;
    $db3 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db3->set_charset("utf8");

    try {
        $db3->begin_transaction();

        $returnCode = "$returnCode";
        $companyID = intval($companyID);
        $customerID = intval($customerID);
        $salespersonID = intval($salespersonID);
        $paymentMethod = intval($paymentMethod);
        $subtotal = floatval($subtotal);
        $grandTotal = floatval($grandTotal);
        $vatTotal = floatval($vatTotal);
        $discount = floatval($discount);
        $returnAddress = intval($returnAddress);
        $returnDate = "$returnDate";
        $details = "$details";
        $globalDiscountPercentage = floatval($globalDiscountPercentage);
        $status = "$status";
        $orderID = "$orderID";
        $vatIE = "$vatIE";
        $currencyID = "$currencyID";
        $actionHash = "$actionHash";
        $returnType = "$returnType";
        $printCount = 0;

        $returnID = getNextIDSingleTransaction("Returns","return_id",$db3);
        $stmt3 = $db3->prepare("INSERT INTO Returns (return_id, return_code, company_id, customer_id, salesperson_id, paymenttype_id, order_id,  subtotal, grand_total, vat_amount, vat_i_e, discount_amount, return_address_id, print_count, return_date, details, return_type, status, currency_id, global_discount_percentage, action_hash) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt3->bind_param('isiiiiidddsdiissssids',$returnID,$returnCode,$companyID,$customerID,$salespersonID,$paymentMethod,$orderID,$subtotal,$grandTotal,$vatTotal,$vatIE,$discount,$returnAddress,$printCount,$returnDate,$details,$returnType,$status,$currencyID,$globalDiscountPercentage,$actionHash);
        $stmt3->execute();
        if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
        $stmt3->close();

        $discount = floatval($discount);

        if(count($returnItems) == 0) {throw new Exception();}

        foreach($returnItems as $returnItem) {

            $itemID         = intval($returnItem->itemID);
            $qty            = floatval($returnItem->qty);
            $unitPrice      = floatval($returnItem->unitPrice);
            $lineDiscount   = floatval($returnItem->lineDiscount);
            $globalDiscount = floatval($returnItem->globalDiscount);
            $vatTotal       = floatval($returnItem->vatTotal);
            $priceType      = intval($returnItem->priceTypeID);
            $vatID          = intval($returnItem->vatID);
            $warehouseID    = intval($returnItem->warehouseID);
            $batchNumber    = "$returnItem->batchNumber";
            $serialNumber   = "$returnItem->serialNumber";
            $discPercent    = floatval($returnItem->lineDiscountPercent);
            $itemNotes      = "$returnItem->itemNotes";
            $lineStatus     = "$returnItem->status";
            $lineCost       = floatval($returnItem->cost);

            $returnItemID = getNextIDSingleTransaction("Return_Item","return_item_id",$db3);
            $stmt3 = $db3->prepare("INSERT INTO Return_Item (return_item_id, return_id, item_id, batch_number, warehouse_id, qty, unit_price, line_discount, global_discount, line_discount_percentage, vat_amount, pricetype_id, vat_id, serialnumber, description,status,cost) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt3->bind_param('iiisiddddddiisssd',$returnItemID,$returnID,$itemID,$batchNumber,$warehouseID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$discPercent,$vatTotal,$priceType,$vatID,$serialNumber,$itemNotes,$lineStatus,$lineCost);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
            $stmt3->close();
        }

        $db3->commit(true);

        return $returnID;


    } catch (Exception  $e) {

        $errorlogfile = fopen('ERROR_LOG_FILE.TXT','w');
        fwrite($errorlogfile , "\n ".date('Y-m-d H:i:s')." - insertReturnSingleTransaction() :: ".$e->getMessage()." :: ".$e->getLine());
        fclose($errorlogfile);

        $db3->rollback();

        return 0;

    }
}

function updateReturnSingleTransaction($returnCode,$companyID,$customerID,$salespersonID,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$returnAddress,$returnDate,$dueDate,$details,$globalDiscountPercentage,$status,$orderID,$vatIE,$returnType,$currencyID,$actionHash,$returnItems){

    global $username,$password,$database;
    $db3 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db3->set_charset("utf8");

    try {
        $db3->begin_transaction();

        $sapStatus = "$status";

        $stmt3 = $db3->prepare("SELECT return_id,status,action_hash FROM Returns WHERE return_code=? LIMIT 1");
        $stmt3->bind_param('s',$returnCode);
        $stmt3-> execute();
        $stmt3-> bind_result($returnID,$status,$prevActionHash);
        while ($stmt3->fetch()) {}
        $stmt3->close();

        if(strcmp("$sapStatus","Closed")==0){
            $status = "$sapStatus";
        }

        if(strcmp("$actionHash","$prevActionHash")!=0) {

            $returnCode = "$returnCode";
            $companyID = intval($companyID);
            $customerID = intval($customerID);
            $salespersonID = intval($salespersonID);
            $paymentMethod = intval($paymentMethod);
            $subtotal = floatval($subtotal);
            $grandTotal = floatval($grandTotal);
            $vatTotal = floatval($vatTotal);
            $discount = floatval($discount);
            $returnAddress = intval($returnAddress);
            $returnDate = "$returnDate";
            $details = "$details";
            $globalDiscountPercentage = floatval($globalDiscountPercentage);
            $status = "$status";
            $orderID = "$orderID";
            $currencyID = "$currencyID";
            $actionHash = "$actionHash";


            $stmt3 = $db3->prepare("UPDATE Returns SET return_code=?,company_id=?,customer_id=?,salesperson_id=?,paymenttype_id=?,order_id=?,subtotal=?,grand_total=?,vat_amount=?,vat_i_e=?,discount_amount=?,return_address_id=?,Returns.return_date=?,details=?,return_type=?,status=?,currency_id=?,global_discount_percentage=?,action_hash=? WHERE return_id=?");
            $stmt3->bind_param('siiiiidddsdissssidsi',$returnCode,$companyID,$customerID,$salespersonID,$paymentMethod,$orderID,$subtotal,$grandTotal,$vatTotal,$vatIE,$discount,$returnAddress,$returnDate,$details,$returnType,$status,$currencyID,$globalDiscountPercentage,$actionHash,$returnID);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception("$returnCode ($returnID) $actionHash ".$stmt3->error);}
            $stmt3->close();

            $stmt3 = $db3->prepare("DELETE FROM Return_Item WHERE return_id=?");
            $stmt3->bind_param('i',$returnID);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
            $stmt3->close();

            $deleteID = getNextIDSingleTransaction("Deletes", "delete_id",$db3);
            $statement ="DELETE FROM Return_Item WHERE return_id=$returnID";
            $stmt3 = $db3->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
            $stmt3->bind_param('is',$deleteID,$statement);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
            $stmt3->close();

            $discount = floatval($discount);

            if(count($returnItems) == 0) {throw new Exception();}

            foreach($returnItems as $returnItem)
            {

                $itemID         = intval($returnItem->itemID);
                $qty            = floatval($returnItem->qty);
                $unitPrice      = floatval($returnItem->unitPrice);
                $lineDiscount   = floatval($returnItem->lineDiscount);
                $globalDiscount = floatval($returnItem->globalDiscount);
                $vatTotal       = floatval($returnItem->vatTotal);
                $priceType      = intval($returnItem->priceTypeID);
                $vatID          = intval($returnItem->vatID);
                $warehouseID    = intval($returnItem->warehouseID);
                $batchNumber    = "$returnItem->batchNumber";
                $serialNumber   = "$returnItem->serialNumber";
                $discPercent    = floatval($returnItem->lineDiscountPercent);
                $itemNotes      = "$returnItem->itemNotes";
                $lineStatus     = "$returnItem->status";
                $lineCost       = floatval($returnItem->cost);

                $returnItemID = getNextIDSingleTransaction("Return_Item","return_item_id",$db3);
                $stmt3 = $db3->prepare("INSERT INTO Return_Item (return_item_id, return_id, item_id, batch_number, warehouse_id, qty, unit_price, line_discount, global_discount, line_discount_percentage, vat_amount, pricetype_id, vat_id, serialnumber, description,status,cost) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                $stmt3->bind_param('iiisiddddddiisssd',$returnItemID,$returnID,$itemID,$batchNumber,$warehouseID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$discPercent,$vatTotal,$priceType,$vatID,$serialNumber,$itemNotes,$lineStatus,$lineCost);
                $stmt3->execute();
                if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
                $stmt3->close();
            }
        } else {
            $returnID = -1;
        }

        $db3->commit(true);

        return $returnID;

    } catch (Exception  $e) {

        $errorlogfile = fopen('ERROR_LOG_FILE.TXT','w');
        fwrite($errorlogfile , "\n ".date('Y-m-d H:i:s')." - insertReturnSingleTransaction() :: ".$e->getMessage()." :: ".$e->getLine());
        fclose($errorlogfile);

        $db3->rollback();

        return 0;

    }

}


function insertUpdateServiceCallFromOrderSingleTransaction($orderID,$assignedSalespersonID = 0){
    global $username,$password,$database;
    $db3 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db3->set_charset("utf8");

    date_default_timezone_set('Europe/Athens');
    $today = strtotime(date('Y-m-d H:i:s'));
    $local_time = $today + date('Z');
    $local_date = date('Y-m-d H:i:s', $local_time);

    try {
        $db3->begin_transaction();

        $orderID = intval($orderID);

        if($orderID == 0) {throw new Exception('Missing Order ID');}

        $stmt3 = $db3->prepare("SELECT order_id, order_code, company_id, customer_id, salesperson_id, paymenttype_id, order_date, subtotal, grand_total, vat_amount, discount_amount, print_count, order_address_id, delivery_address_id, tender_id, vat_i_or_e, delivery_date, deposit_amount, details, status, currency_id, global_discount_percentage, delivery_method, online_order_id, action_hash, action_time, timestamp FROM Orders WHERE order_id=? LIMIT 1");
        $stmt3->bind_param('i',$orderID);
        $stmt3->execute();
        $stmt3->bind_result($orderID, $orderCode, $companyID, $customerID, $salespersonID, $paymentMethod, $orderDate, $subtotal, $grandTotal, $vatTotal, $discount, $printCount, $orderAddress, $deliveryAddress, $tenderID, $vatIE, $deliveryDate, $depositAmount, $details, $status, $currencyID, $globalDiscountPercentage, $deliveryMethod, $onlineOrderID, $actionHash, $actionTime, $timestamp);
        while ($stmt3->fetch()) {}
        $stmt3->close();

        echo "<br>------------- Order $orderCode -----------------";
        echo "<br>Order Dates - Order Date: $orderDate - Delivery Date: $deliveryDate";

        $timeSlotFromDateTime = '';
        $timeSlotToDateTime = '';
        $stmt3 = $db3->prepare("SELECT time_slot_from,time_slot_to,order_time,delivery_time FROM Order_Delivery_Details WHERE order_id=? LIMIT 1");
        $stmt3->bind_param('i',$orderID);
        $stmt3->execute();
        $stmt3->bind_result($timeSlotFrom,$timeSlotTo,$orderTime,$deliveryTime);
        while ($stmt3->fetch()) {
            if(strcmp("$timeSlotFrom","")!=0 && strcmp("$timeSlotFrom","0000-00-00 00:00:00")!=0){
                $timeSlotFromDateTime = $deliveryDate." ".date_format( date_create_from_format('Y-m-d H:i:s', $timeSlotFrom), 'H:i:s');
            }
            if(strcmp("$timeSlotTo","")!=0 && strcmp("$timeSlotTo","0000-00-00 00:00:00")!=0){
                $timeSlotToDateTime = $deliveryDate." ".date_format( date_create_from_format('Y-m-d H:i:s', $timeSlotTo), 'H:i:s');
                $deliveryDate = $timeSlotToDateTime;
            }
            if(strcmp("$deliveryTime","")!=0 && strcmp("$deliveryTime","0000-00-00 00:00:00")!=0){
                $deliveryDate = "$deliveryTime";
                $timeSlotFromDateTime = "$deliveryTime";
                $timeSlotToDateTime = date('Y-m-d',strtotime(date($deliveryTime) . "+30 minutes"));
            }
            echo "<br>Order Slots - Time Slot From: $timeSlotFromDateTime - Time Slot To: $timeSlotToDateTime - Delivery Time: $deliveryTime";
        }
        $stmt3->close();


        if(strcmp("$orderCode","")==0) {throw new Exception('Missing Order Code');}


        $serviceCallCode = "$orderCode";
        $scSalespersonID = 0;
        $assignTo = intval($assignedSalespersonID);
        $customerID = intval($customerID);
        $addressID = intval($orderAddress);
        $itemID = 0;
        $serialNumberID = 0;
        $sourceID = 0;
        $scTypeID = 1;
        $scStatusID = 1;
        $scPriorityID = 1;
        $topic = "Order $orderCode";
        $scDetails = "$details";
        $sourceName = "";
        $sourceDetails = "";
        $scDate = "$local_date";
        $dueDate = "$deliveryDate";
        $scheduleStartDate = "$timeSlotFromDateTime";
        $scheduleEndDate = "$timeSlotToDateTime";
        $parentID = 0;
        $progress = 0;
        $assignTo2 = 0;
        $actionHash = "";

        echo "<br>Service Call $serviceCallCode - SC Date: $scDate - Due Date: $dueDate - Schedule Start Date: $scheduleStartDate - Schedule End Date: $scheduleEndDate";

        $stmt3 = $db3->prepare("SELECT service_call_id FROM Service_Call WHERE service_call_code=? LIMIT 1");
        $stmt3->bind_param('s',$orderCode);
        $stmt3->execute();
        $stmt3->bind_result($serviceCallID);
        while ($stmt3->fetch()) {}
        $stmt3->close();

        if($serviceCallID > 0){
            $stmt3 = $db3->prepare("UPDATE Service_Call SET service_call_code=?, salesperson_id=?, assign_to=?, customer_id=?, customer_address_id=?, item_id=?, serial_number_id=?, source_id=?, type_id=?, status_id=?, priority_id=?, topic=?, details=?, source_name=?, source_details=?, date=?, due_date=?, schedule_start_date=?, schedule_end_date=?, parent_id=?, progress=?, assign_to_2=?, action_hash=? WHERE service_call_id=?");
            $stmt3->bind_param('siiiiiiiiisssssssssiiisi',$serviceCallCode,$salespersonID,$assignTo,$customerID,$addressID,$itemID,$serialNumberID,$sourceID,$scTypeID,$scStatusID,$scPriorityID,$topic,$scDetails,$sourceName,$sourceDetails,$scDate,$dueDate,$scheduleStartDate,$scheduleEndDate,$parentID,$progress,$assignTo2,$actionHash,$serviceCallID);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
            $stmt3->close();
            echo "<br>------Update Service Call $serviceCallCode ($serviceCallID)------";

        } else {
            $serviceCallID = getNextIDSingleTransaction("Service_Call","service_call_id",$db3);
            $stmt3 = $db3->prepare("INSERT INTO Service_Call (service_call_id, service_call_code, salesperson_id, assign_to, customer_id, customer_address_id, item_id, serial_number_id, source_id, type_id, status_id, priority_id, topic, details, source_name, source_details, date, due_date, schedule_start_date, schedule_end_date, parent_id, progress, assign_to_2, action_hash, action_time, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),NOW())");
            $stmt3->bind_param('isiiiiiiiiisssssssssiiis',$serviceCallID,$serviceCallCode,$salespersonID,$assignTo,$customerID,$addressID,$itemID,$serialNumberID,$sourceID,$scTypeID,$scStatusID,$scPriorityID,$topic,$scDetails,$sourceName,$sourceDetails,$scDate,$dueDate,$scheduleStartDate,$scheduleEndDate,$parentID,$progress,$assignTo2,$actionHash);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
            $stmt3->close();
            echo "<br>------Insert Service Call $serviceCallCode ($serviceCallID)------";


            $serviceCallReplyID = getNextIDSingleTransaction("Service_Call_Reply","service_call_reply_id",$db3);
            $replyStatusID = 0;
            $replyDate = $local_date;
            $replyTypeID = 3;
            $replyDetails = "New Order Issued";
            $documentType = "Orders";
            $salespersonTo = 0;
            $emailResponse = "";
            $priorityID = 0;
            $stmt3 = $db3->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id, service_call_id, salesperson_id, status_id, date, reply_type_id, details, document_id, document_type, salesperson_to, email_response, priority_id, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
            $stmt3->bind_param('iiiisisisisi',$serviceCallReplyID,$serviceCallID,$salespersonID,$replyStatusID,$replyDate,$replyTypeID,$replyDetails,$orderID,$documentType,$salespersonTo,$emailResponse,$priorityID);
            $stmt3->execute();
            if(strcmp("$stmt3->error","")!=0) {throw new Exception($stmt3->error);}
            $stmt3->close();
            echo "<br>------Insert Service Call Reply $serviceCallCode------";

        }


        $db3->commit(true);

        echo "<br>";

        return $serviceCallID;

    } catch (Exception  $e) {

        echo "<br>ERROR: ".$e->getMessage()." :: ".$e->getLine();
        $errorlogfile = fopen('ERROR_LOG_FILE.TXT','w');
        fwrite($errorlogfile , "\n ".date('Y-m-d H:i:s')." - insertUpdateServiceCallFromOrderSingleTransaction() :: ".$e->getMessage()." :: ".$e->getLine());
        fclose($errorlogfile);

        $db3->rollback();

        return 0;

    }
}


function accountExists($accountCode) {

global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(account_id) FROM ChartOfAccounts WHERE account_code='$accountCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
}

function upadateAccount($accountCode,$accountName,$type) {
global $username;
global $password;
global $database;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE ChartOfAccounts SET account_code = ?, account_name = ?,type_id= ? WHERE account_code='$accountCode'");
	$stmt1->bind_param('sss',$accountCode,$accountName,$type);
 	$stmt1->execute(); 	
 	$stmt1->close();
   
   
    return getAccountID($accountCode);
}


function insertAccount($accountCode,$accountName,$type) {
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db->set_charset("utf8");
	 $accountID = getNextID("ChartOfAccounts","account_id");
 	$stmt = $db->prepare("INSERT INTO ChartOfAccounts (account_id,account_code,account_name,type_id,timestamp) VALUES(?,?,?,?,NOW())");
	$stmt->bind_param('isss',$accountID,$accountCode,$accountName,$type);
 	$stmt->execute();
 	$stmt->close();
   
   
    return $accountID;
}
function journalExists($journalCode,$year,$period){

global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(journal_id) FROM Journals WHERE journal_code='$journalCode' AND year='$year' AND period_id='$period'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;


}

function insertJournal($journalCode,$year,$period){
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db->set_charset("utf8");
	 $journalID = getNextID("Journals","journal_id");
 	$stmt = $db->prepare("INSERT INTO Journals (journal_id,journal_code,year,period_id,timestamp) VALUES(?,?,?,?,NOW())");
	$stmt->bind_param('isss',$journalID,$journalCode,$year,$period);
 	$stmt->execute();
 	$stmt->close();
   
   
    return $journalID;
}
	
function insertTransaction($journalID,$accountID,$transactionDate,$reference,$amount,$sign,$details,$unallocateAmount,$year,$period)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db->set_charset("utf8");
	 $transactionID = getNextID("Transactions","transaction_id");
 	$stmt = $db->prepare("INSERT INTO Transactions (transaction_id,journal_id,account_id,transaction_date,action_code,amount,sign,details,outstanding_amount,year,period_id,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW())");
	$stmt->bind_param('iiissddsdii',$transactionID,$journalID,$accountID,$transactionDate,$reference,$amount,$sign,$details,$unallocateAmount,$year,$period);
 	$stmt->execute();
 	$stmt->close();
   
   
    return $journalID;
}


function getAccountID($accountCode) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT account_id FROM ChartOfAccounts WHERE account_code='$accountCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function getAccountType($accountCode) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT type_id FROM ChartOfAccounts WHERE account_code='$accountCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}
function insertCustomerPriceList($customerID,$priceTypeID)
{
global $username;
global $password;
global $database;
              $db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db->set_charset("utf8");
	 
	$stm1 = $db->prepare("SELECT pricetype_id FROM Customer_Pricelist WHERE customer_id='$customerID' AND NOT pricetype_id='$priceTypeID'");
	$stm1-> execute();
	$stm1-> bind_result($oldPriceType);
	while ($stm1->fetch()) {}
	$stm1->close();
	
	if($oldPriceType > 0 && $priceTypeID != $oldPriceType){
        $stmt5 = $db->prepare("DELETE FROM Customer_Pricelist WHERE customer_id=? ");
        $stmt5->bind_param('i',$customerID);
        $stmt5->execute();
        $stmt5->close(); 

        $deleteID = getNextID("Deletes", "delete_id");
        $statement ="DELETE FROM Customer_Pricelist WHERE customer_id=$customerID";
        $stmt2 = $db->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
        $stmt2->bind_param('is',$deleteID,$statement);
        $stmt2->execute();
        $stmt2->close();	    
	}
	
 	$stmt = $db->prepare("INSERT INTO Customer_Pricelist (customer_id,pricetype_id,timestamp) VALUES(?,?,NOW())");
	$stmt->bind_param('ii',$customerID,$priceTypeID);
 	$stmt->execute();
 	$stmt->close();

}
function updateItemflag($itemCode,$status)
{
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Items SET status= ? WHERE item_code='$itemCode'");
	$stmt1->bind_param('s',$status);
 	$stmt1->execute(); 	
 	$stmt1->close();
 	

}

function insertCustomerToGroupG2u($g,$customerID){
global $username;
global $password;
global $database;
   	

        
        $groupIDold = getGroupIDOFCustomer($customerID);
        $db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");
        

	$stm1 = $db1->prepare("SELECT group_id FROM CustomerGroups WHERE group_code='$g' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($groupID);
	while ($stm1->fetch()) {
                if(strcmp($groupIDold,$groupID)!=0)
                {
		$db2 = new mysqli(localhost,$username,$password,$database);
 		if (mysqli_connect_errno()) 
 		{
      		printf("Connect failed: %s\n", mysqli_connect_error());
    		  exit();
 		}
 		$db2->set_charset("utf8");

                $stmt5 = $db2->prepare("DELETE FROM Customer_CustomersGroup WHERE customer_id=? AND group_id=?");
                $stmt5->bind_param('ii',$customerID,$groupIDold);
                $stmt5->execute();
                $stmt5->close(); 

                $deleteID = getNextID("Deletes", "delete_id");
                $statement ="DELETE FROM Customer_CustomersGroup WHERE customer_id=$customerID AND group_id=$groupIDold";
                $stmt2 = $db2->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
                $stmt2->bind_param('is',$deleteID,$statement);
                $stmt2->execute();
                $stmt2->close();


               
		  $stmt2 = $db2->prepare("INSERT INTO Customer_CustomersGroup (group_id,customer_id,added_date,timestamp) VALUES(?,?,CURDATE(),NOW())");
 		  $stmt2->bind_param('ss',$groupID,$customerID);
 		  $stmt2->execute();
 		  $stmt2->close();
                }
	 }
	 $stm1->close();
}

function getGroupID($groupCode){
    global $username;
    global $password;
    global $database;


    $groupID=0;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");


    $stm1 = $db1->prepare("SELECT group_id FROM CustomerGroups WHERE group_code = '$groupCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($groupID);
    while ($stm1->fetch()) {

    }
    $stm1->close();
    return $groupID;

}


function getGroupIDOFCustomer($customerID){
global $username;
global $password;
global $database; 	

        
       $groupID=0;
        $db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");
        

	$stm1 = $db1->prepare("SELECT CustomerGroups.group_id FROM CustomerGroups,Customer_CustomersGroup WHERE group_code LIKE 'G2%' AND CustomerGroups.group_id=Customer_CustomersGroup.group_id AND customer_id='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($groupID);
	while ($stm1->fetch()) {
		
	 }
	 $stm1->close();
      return $groupID;

}


function updateItemLongDescription($itemID,$longDescription)
{
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Items SET long_description= ? WHERE item_id='$itemID'");
	$stmt1->bind_param('s',$longDescription);
 	$stmt1->execute(); 	
 	$stmt1->close();
 	

}


function  insertShortage($osiID,$shipDate,$itemID,$itemText,$qtyCancelled,$salesUnitCancelled,$status,$expectedQty,$expectedSalesUnit,$expectedDate,$ostCode)
{

global $username;
global $password;
global $database;
              $db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db->set_charset("utf8");
	
 	$stmt = $db->prepare("INSERT INTO Shortage (osi_id,ship_date,item_id,item_text,qty_cancelled,salesunits_cancelled,status,expected_qty,salesunits_expected,expected_date,ost_code,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW())");
	$stmt->bind_param('isisdssdsss',$osiID,$shipDate,$itemID,$itemText,$qtyCancelled,$salesUnitCancelled,$status,$expectedQty,$expectedSalesUnit,$expectedDate,$ostCode);
 	$stmt->execute();
 	$stmt->close();




}

function getSerialNumber($serialNumber) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT serial_number_id FROM Serial_Numbers WHERE serial_number='$serialNumber' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function serialNumberExists($serialNumber) {

global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(serial_number_id) FROM Serial_Numbers WHERE serial_number='$serialNumber'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
}



function insertSerialNumber($serialNumber,$itemID)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
 	$db->set_charset("utf8");
	$serialNumberID = getNextID("Serial_Numbers","serial_number_id");
 	$stmt = $db->prepare("INSERT INTO Serial_Numbers(serial_number_id,serial_number,item_id,timestamp) VALUES(?,?,?,NOW())");
 	$stmt->bind_param('isi',$serialNumberID,$serialNumber,$itemID);
 	$stmt->execute(); 	
 	$stmt->close();
 	return $serialNumberID;
}


function updateCustomerMobile($customerID,$mobile)
{
    
    global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Customers SET mobile= ? WHERE customer_id='$customerID'");
	$stmt1->bind_param('s',$mobile);
 	$stmt1->execute(); 	
 	$stmt1->close();
}



function insertCustomerToTown($groupID,$customerID){
global $username;
global $password;
global $database;
   
		$db2 = new mysqli(localhost,$username,$password,$database);
 		if (mysqli_connect_errno()) 
 		{
      		printf("Connect failed: %s\n", mysqli_connect_error());
    		  exit();
 		}
 		$db2->set_charset("utf8");
		 $stmt2 = $db2->prepare("INSERT INTO Customer_CustomersGroup (group_id,customer_id,added_date,timestamp) VALUES(?,?,CURDATE(),NOW())");
 		$stmt2->bind_param('ss',$groupID,$customerID);
 		$stmt2->execute();
 		$stmt2->close();
	 
}

function getCategoryIDCustomForLevel2($categoryCode,$description){
global $username;
global $password;
global $database;
	$z=array();
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT category_id FROM Categories WHERE category_code LIKE'%$categoryCode' AND description='$description'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		   array_push($z,$counter);
		
		
	 }
	 $stm1->close();
   
   
    return $z;


}

function updateCategoryNameCustomLevel2($categoryID,$catName){
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Categories SET name=? WHERE category_id='$categoryID'");
	$stmt1->bind_param('s',$catName);
 	$stmt1->execute(); 	
 	$stmt1->close();

//  	return getCategoryID($categoryCode);
}
function insertBarcodesExported($id,$type,$status,$reason){
    global $username;
    global $password;
    global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
 	$stmt = $db->prepare("INSERT IGNORE INTO Item_Barcode_Exported (item_id,barcode,status,reason,timestamp) VALUES(?,?,?,?,NOW())");
	$stmt->bind_param('isis',$id,$type,$status,$reason);
 	$stmt->execute(); 	
 	$stmt->close();
}

function insertSupplierContractPrice($customerID,$itemID,$price)
{
global $username;
global $password;
global $database;


    
	    $db = new mysqli(localhost,$username,$password,$database);
 	   if (mysqli_connect_errno()) 
    	{
    	   printf("Connect failed: %s\n", mysqli_connect_error());
    	   exit();
	  }
	  $db->set_charset("utf8");  
     $stmt3 = $db->prepare("INSERT INTO Item_Supplier (supplier_id,item_id,price) VALUES(?,?,?) ON DUPLICATE KEY UPDATE price=?");
 	  $stmt3->bind_param('ssdd',$customerID,$itemID,$price,$price);
 	  $stmt3->execute();
 	  $stmt3->close();
	
}

function updateStock($warehouseID,$itemID,$batchnumber,$available,$onOrder,$reserved,$delivered)
{
	global $username;
global $password;
global $database;

  
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
	
 	$stmt3 = $db->prepare(" UPDATE Stock SET available=?,reserved=?,on_order=? WHERE warehouse_id=? AND item_id=? AND batch_number=?");
 	$stmt3->bind_param('dddiii',$available,$reserved,$onOrder,$warehouseID,$itemID,$batchnumber);
 	$stmt3->execute();
 	$stmt3->close();
  




}


function updateSpecialPrices($itemID,$priceTypeID,$price){

    global $username;
    global $password;
    global $database;

    $priceChangesArray = array();

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT customer_id,item_id,min_qty,percentage,price FROM ContractPrices WHERE item_id='$itemID' AND pricetype_id='$priceTypeID'");
    $stm1-> execute();
    $stm1-> bind_result($customerID,$itemID,$minQty,$discountPercent,$prevPrice);
    while ($stm1->fetch()) {

        $newPrice = round($price - $price*($discountPercent/100),3);

        if($newPrice !== $prevPrice){
            $priceObject = new stdClass();
            $priceObject->customerID = $customerID;
            $priceObject->itemID = $itemID;
            $priceObject->minQty = $minQty;
            $priceObject->price = $newPrice;
            array_push($priceChangesArray,$priceObject);
        }
    }
    $stm1->close();


    foreach ($priceChangesArray as $priceObject){
        $customerID = $priceObject->customerID;
        $itemID = $priceObject->itemID;
        $minQty = $priceObject->minQty;
        $price = $priceObject->price;

        $stmt1 = $db1->prepare("UPDATE ContractPrices SET price=? WHERE customer_id=? AND item_id=? AND min_qty=?");
        $stmt1->bind_param('diii',$price,$customerID,$itemID,$minQty);
        $stmt1->execute();
        $stmt1->close();
    }



}


function pickExistsAndEditatble($pickCode) {

	global $username;
	global $password;
	global $database;
	$z=false;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
		printf("Connect failed: %s\n", mysqli_connect_error());
		exit();
	}
	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(pick_id) FROM Pick WHERE pick_code='$pickCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	}
	$stm1->close();


	return $z;
}

function getPickID($pickCode) {

    global $username;
    global $password;
    global $database;
    $z="";
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT pick_id FROM Pick WHERE pick_code='$pickCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {

            $z=$counter;

    }
    $stm1->close();


    return $z;
}

function getPickItems($pickID) {

    global $username;
    global $password;
    global $database;
    $z=array();
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT pick_item_id,item_id FROM Pick_Item WHERE pick_id='$pickID'");
    $stm1-> execute();
    $stm1-> bind_result($pickItemID,$itemID);
    while ($stm1->fetch()) {

            $pickItem="";
            $pickItem->pickItemID=$pickItemID;
            $pickItem->itemID=$itemID;
          
            $pickItem->found=false;
            array_push($z,$pickItem);

    }
    $stm1->close();


    return $z;
}

function insertPickHeader($pickCode,$orderDate,$notes,$status,$pickerID,$orderCode)
{
	global $username;
	global $password;
	global $database;

    $orderID=getOrderID($orderCode);

	$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno())
	{
		printf("Connect failed: %s\n", mysqli_connect_error());
		exit();
	}
$db->set_charset("utf8");

	$pickID = getNextID("Pick","pick_id");
	$stmt3 = $db->prepare("INSERT INTO Pick (pick_id,pick_code,salesperson_id,date,notes,status,timestamp) VALUES(?,?,?,?,?,?,NOW())");
	$stmt3->bind_param('isisss',$pickID,$pickCode,$pickerID,$orderDate,$notes,$status);
	$stmt3->execute();
	$stmt3->close();
	
	$stmt3 = $db->prepare("INSERT INTO Pick_Order (pick_id,order_id) VALUES(?,?)");
	$stmt3->bind_param('ii',$pickID,$orderID);
	$stmt3->execute();
	$stmt3->close();
	
	return $pickID;
	


}


function insertOrderLine($orderID, $itemID, $qty, $price, $discountPercent, $discount, $lineToral, $vatTotal, $vatID, $notes)
{
	global $username;
	global $password;
	global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno())
	{
		printf("Connect failed: %s\n", mysqli_connect_error());
		exit();
	}

	$orderItemID = getNextID("Order_Item","order_item_id");
	$stmt3 = $db->prepare("INSERT INTO Order_Item (order_item_id,order_id,item_id,qty,unit_price,global_discount,line_discount_percentage,vat_amount,vat_id,description,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,NOW())");
	$stmt3->bind_param('iiidddddis',$orderItemID,$orderID,$itemID,$qty,$price,$discount,$discountPercent,$vatTotal,$vatID,$notes);
	$stmt3->execute();
	$stmt3->close();


}

function  getPickItemInArray($pickItemsArray,$itemID) {

   $z=null;
   
   foreach($pickItemsArray as $pickItem)
   {
        if(strcmp($pickItem->itemID,$itemID)==0)
        {
           $z=$pickItem;
        }
    }
    return $z;
}

function updatePickLine($pickItemID, $qtyToPick,$lineNotes,$baseentry,$baseline)
{
	global $username;
	global $password;
	global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno())
	{
		printf("Connect failed: %s\n", mysqli_connect_error());
		exit();
	}

	$stmt3 = $db->prepare("UPDATE Pick_Item SET qty_to_pick=?,notes=? WHERE pick_item_id=?");
	$stmt3->bind_param('dsi',$qtyToPick,$lineNotes,$pickItemID);
	$stmt3->execute();
	$stmt3->close();
	
// 	$stmt3 = $db->prepare("UPDATE Pick_Item_SAP SET baseentry =?,baseline=? WHERE pick_item_id=?");
// 	$stmt3->bind_param('iii',$baseentry,$baseline,$pickItemID);
// 	$stmt3->execute();
// 	$stmt3->close();


}

function insertPickLine($pickID, $itemID, $qtyToPick,$lineNotes,$baseentry,$baseline)
{
	global $username;
	global $password;
	global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno())
	{
		printf("Connect failed: %s\n", mysqli_connect_error());
		exit();
	}

	$pickItemID = getNextID("Pick_Item","pick_item_id");
	$barchNumber="0";
	$warehouseID=0;
	$qty=0;
	$stmt3 = $db->prepare("INSERT INTO Pick_Item (pick_item_id,pick_id,item_id,batch_number,warehouse_id,qty,qty_to_pick,notes,timestamp) VALUES(?,?,?,?,?,?,?,?,NOW())");
	$stmt3->bind_param('iiisidds',$pickItemID,$pickID,$itemID,$barchNumber,$warehouseID,$qty,$qtyToPick,$lineNotes);
	$stmt3->execute();
	$stmt3->close();
	
// 	$stmt3 = $db->prepare("INSERT INTO Pick_Item_SAP (pick_item_id,baseentry,baseline,timestamp) VALUES(?,?,?,NOW())");
// 	$stmt3->bind_param('iii',$pickItemID,$baseentry,$baseline);
// 	$stmt3->execute();
// 	$stmt3->close();


}

function getOrderID($orderCode) {

    global $username;
    global $password;
    global $database;
    $z="";
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT order_id FROM Orders WHERE order_code='$orderCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {

            $z=$counter;

    }
    $stm1->close();


    return $z;
}

function insertAnalyticBinLocation($warehouseID,$binLocation,$description,$attribute1,$attribute2,$attribute3,$attribute4,$attribute5,$status)
{
	global $username;
	global $password;
	global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno())
	{
		printf("Connect failed: %s\n", mysqli_connect_error());
		exit();
	}

	$binLocationID = getNextID("Warehouse_BinLocations","bin_location_id");
	$stmt3 = $db->prepare("INSERT INTO Warehouse_BinLocations (warehouse_id,bin_location_id,bin_location_code,bin_location,description,attribute1,attribute2,attribute3,attribute4,attribute5,status) VALUES(?,?,?,?,?,?,?,?,?,?,?)");
	$stmt3->bind_param('iisssssssss',$warehouseID,$binLocationID,$binLocation,$binLocation,$description,$attribute1,$attribute2,$attribute3,$attribute4,$attribute5,$status);
	$stmt3->execute();
	$stmt3->close();


}

function updateAnalyticBinLocation($warehouseID,$binLocation,$description,$attribute1,$attribute2,$attribute3,$attribute4,$attribute5,$status)
{
	global $username;
	global $password;
	global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno())
	{
		printf("Connect failed: %s\n", mysqli_connect_error());
		exit();
	}

	$stmt3 = $db->prepare("UPDATE Warehouse_BinLocations SET description=?,attribute1=?,attribute2=?,attribute3=?,attribute4=?,attribute5=?,status=? WHERE warehouse_id=? AND bin_location=?");
	$stmt3->bind_param('sssssssis',$description,$attribute1,$attribute2,$attribute3,$attribute4,$attribute5,$status,$warehouseID,$binLocation);
	$stmt3->execute();
	$stmt3->close();


}

function binExists($warehouseID,$binLocation)
{
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT bin_location_id FROM Warehouse_BinLocations WHERE warehouse_id='$warehouseID' AND bin_location ='$binLocation' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();  
   
        return $z;


}

function poHasGrn($poID){
    global $username;
    global $password;
    global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT GRNs.waybill_id FROM Purchase_Order_GRN,GRNs WHERE Purchase_Order_GRN.waybill_id=GRNs.waybill_id AND NOT status='Canceled' AND Purchase_Order_GRN.order_id='$poID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();  
   
        return $z;
}



function getNextIDSingleTransaction($tableName,$idName,$db1)
{
    global $username;
    global $password;
    global $database;
    global $prefix;
    $z=0;


    $likeVar = $prefix."%";
    $stm1 = $db1->prepare("SELECT $idName FROM $tableName WHERE $idName LIKE '$likeVar' ORDER BY $idName DESC LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($nextID);
    while ($stm1->fetch()) {

        $z = substr($nextID,4,strlen($nextID));
        $z+=1;


    }
    $stm1->close();


    return $prefix.$z;

}

function bankExists($bankCode)
{
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(bank_id) FROM Banks WHERE code='$bankCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0) {$z=true;}
    }
    $stm1->close();

    return $z;

}

function insertBank($bankCode,$bankName)
{
    global $username;
    global $password;
    global $database;

    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $status = 'yes';
    $bankID = getNextID("Banks","bank_id");

    $stmt3 = $db->prepare("INSERT INTO Banks(bank_id, code, name, status, timestamp) VALUES (?,?,?,?,NOW())");
    $stmt3->bind_param('isss',$bankID,$bankCode,$bankName,$status);
    $stmt3->execute();
    $stmt3->close();

}

function updateBank($bankCode,$bankName)
{
    global $username;
    global $password;
    global $database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stmt1 = $db1->prepare("UPDATE Banks SET name = ? WHERE code=?");
    $stmt1->bind_param('ss',$bankName,$bankCode);
    $stmt1->execute();
    $stmt1->close();

}

function getVatPercent($vatID){
    global $username;
    global $password;
    global $database;
    $z=0;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT percentage FROM Vats WHERE vat_id='$vatID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter > 0){$z=$counter;}
    }
    $stm1->close();


    return $z;

}

function getBankNameByCode($bankCode){

    if(strcmp("$bankCode","")==0){return $bankCode;}

    global $username;
    global $password;
    global $database;
    $z="$bankCode";
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT name FROM Banks WHERE code='$bankCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if(strcmp("$counter","")!=0){$z=$counter;}
    }
    $stm1->close();


    return $z;

}


function getAddressIdFromStreet($customerID, $customerAddress) {
    global $username;
    global $password;
    global $database;

    $z=0;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $customerAddress1 = substr($customerAddress,0,100);
    $customerAddress2 = substr($customerAddress,0,50);

    $stm1 = $db1->prepare("SELECT customer_address_id FROM CustomerAddress WHERE customer_id=? AND (address_line_1 LIKE ? OR address_line_2 LIKE ?) LIMIT 1");
    $stm1->bind_param("iss",$customerID,$customerAddress1,$customerAddress2);
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {$z=$counter;}
    $stm1->close();

    if(intval($z) == 0){
        $stm1 = $db1->prepare("SELECT customer_address_id FROM CustomerAddress WHERE customer_id=? ORDER BY primary_address DESC,timestamp DESC LIMIT 1");
        $stm1->bind_param("i",$customerID);
        $stm1-> execute();
        $stm1-> bind_result($counter);
        while ($stm1->fetch()) {$z=$counter;}
        $stm1->close();
    }

    return intval($z);
}

function getStatusOfServiceCallByScID($code){

    global $username;
    global $password;
    global $database;
    $z=1;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT status_id FROM Service_Call WHERE service_call_code='$code' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter > 0){
            $z=$counter;
        }
    }
    $stm1->close();


    return $z;

}

function serviceCallExists($serviceCallCode){
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT service_call_id FROM Service_Call WHERE service_call_code='$serviceCallCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0) {$z=true;}
    }
    $stm1->close();

    return $z;
}

function getScPriorityIdByName($name){
    global $username;
    global $password;
    global $database;
    $z=3;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT priority_id FROM SC_Priorities WHERE priority_name LIKE '$name' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter > 0){
            $z=$counter;
        }
    }
    $stm1->close();


    return $z;
}

function getScStatusID($code){
    global $username;
    global $password;
    global $database;
    $z=1;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT status_id FROM SC_Status WHERE status_code = '$code' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter > 0){
            $z=$counter;
        }
    }
    $stm1->close();


    return $z;
}

function getScTypeID($code){
    global $username;
    global $password;
    global $database;
    $z=0;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT type_id FROM SC_Types WHERE type_code = '$code' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter > 0){
            $z=$counter;
        }
    }
    $stm1->close();


    return $z;
}

function updateServiceCall($serviceCallCode,$salespersonSearch,$customerID,$customerAddressID,$serialNumberID,$sourceID,$serviceCallType,$serviceCallStatus,$priority,$serviceCallTitle,$serviceCallDetails,$sourceName,$callerDetails,$serviceCallDate,$dueDate,$serviceCallscheduleStartDate,$serviceCallscheduleEndDate,$progress){
    global $username;
    global $password;
    global $database;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stmt1 = $db1->prepare("UPDATE Service_Call SET assign_to=?,customer_id=?,source_id=?,type_id=?,status_id=?,priority_id=?,topic=?,details=?,source_name=?,source_details=?,date=?,due_date=?,customer_address_id=?,serial_number_id=?,schedule_start_date=?,schedule_end_date=?,progress=? WHERE service_call_code=?");
    $stmt1->bind_param('iiiiiissssssiissis',$salespersonSearch,$customerID,$sourceID,$serviceCallType,$serviceCallStatus,$priority,$serviceCallTitle,$serviceCallDetails,$sourceName,$callerDetails,$serviceCallDate,$dueDate,$customerAddressID,$serialNumberID,$serviceCallscheduleStartDate,$serviceCallscheduleEndDate,$progress,$serviceCallCode);
    $stmt1->execute();
    echo "$stmt1->error ";
    $stmt1->close();

    return getServiceCallID($serviceCallCode);
}

function insertServiceCall($serviceCallCode,$salespersonSearch,$customerID,$customerAddressID,$serialNumberID,$sourceID,$serviceCallType,$serviceCallStatus,$priority,$serviceCallTitle,$serviceCallDetails,$sourceName,$callerDetails,$serviceCallDate,$dueDate,$serviceCallscheduleStartDate,$serviceCallscheduleEndDate,$progress){

    global $username;
    global $password;
    global $database;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $serviceCallID = getNextID("Service_Call","service_call_id");
    $salespersonID = 0;
    $stmt1 = $db1->prepare("INSERT INTO Service_Call (service_call_id,service_call_code,salesperson_id,assign_to,customer_id,customer_address_id,serial_number_id,source_id,type_id,status_id,priority_id,topic,details,source_name,source_details,date,due_date,schedule_start_date,schedule_end_date,progress,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
    $stmt1->bind_param('isiiiiiiiiissssssssi',$serviceCallID,$serviceCallCode,$salespersonID,$salespersonSearch,$customerID,$customerAddressID,$serialNumberID,$sourceID,$serviceCallType,$serviceCallStatus,$priority,$serviceCallTitle,$serviceCallDetails,$sourceName,$callerDetails,$serviceCallDate,$dueDate,$serviceCallscheduleStartDate,$serviceCallscheduleEndDate,$progress);
    $stmt1->execute();
    $error = $stmt1->error;
    echo "$error ";
    $stmt1->close();
    if(strcmp("$error","")==0){
        return $serviceCallID;
    } else {
        return 0;
    }
}

function getServiceCallID($code) {

    global $username;
    global $password;
    global $database;
    $z=0;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT service_call_id FROM Service_Call WHERE service_call_code='$code' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter > 0){
            $z=$counter;
        }
    }
    $stm1->close();


    return $z;
}

function profitCenterExists($code) {

    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT profit_center_id FROM Profit_Center WHERE profit_center_code='$code' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();


    return $z;
}

function insertProfitCenter($code,$name,$active)
{
    global $username;
    global $password;
    global $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $profitCenterID = getNextID("Profit_Center","profit_center_id");
    $stmt = $db->prepare("INSERT INTO Profit_Center(profit_center_id, profit_center_code, profit_center_name, active, timestamp) VALUES (?,?,?,?,NOW())");
    $stmt->bind_param('isss',$profitCenterID,$code,$name,$active);
    $stmt->execute();
    $stmt->close();

}

function updateProfitCenter($code,$name,$active)
{
    global $username;
    global $password;
    global $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stmt = $db->prepare("UPDATE Profit_Center SET profit_center_name=? active=? WHERE profit_center_code=?");
    $stmt->bind_param('sss',$name,$active,$code);
    $stmt->execute();
    $stmt->close();

}


function insertStockBatchExpiry($warehouseID,$itemID,$batchnumber,$available,$expiryDate)
{
    global $username;
    global $password;
    global $database;


    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $reserved = $delivered = $onOrder = 0;
    $stmt3 = $db->prepare("INSERT INTO Stock (warehouse_id,item_id,batch_number,available,reserved,delivered,on_order,expiry_date) VALUES(?,?,?,?,?,?,?,?) ON DUPLICATE KEY UPDATE available=?,expiry_date=?");
    $stmt3->bind_param('iisddddsds',$warehouseID,$itemID,$batchnumber,$available,$reserved,$delivered,$onOrder,$expiryDate,$available,$expiryDate);
    $stmt3->execute();
    $stmt3->close();





}
?>