<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

require_once('dbinfo.php');
require_once('SAPClient.php');
require_once('SAPClientPreferences.php');
require_once('importFunctions.php');
$myfile = fopen("PARSER_STATUS.txt", "w");
$client = new SAPClient($b1Host,$b1Port,$b1UserName,$b1Password,$b1CompanyDB);
$client->startConnection();
// $dateFilter = date('Y-m-d', strtotime("-4 days"));


echo "Session ID: ".$client->getSessionID()."<br>";
echo "<br>--START-- <br>".date('d-m-Y H:i:s')."<br>";

echo "<br>IMPORT B2B Category Tree: <br>".date('d-m-Y H:i:s');
importB2BCategoryStructure($client,$dateFilter,$myfile);
fwrite($myfile, "\nIMPORT B2B Category Tree: ".date('d-m-Y H:i:s'));

function importB2BCategoryStructure($client,$today)
{   
    
    
    echo "<br><b>---CATEGORIES LEVEL 1---</b>";
    $categoryNamesLevel1 = array();
    $hasMore = true;
    $skip = '';
    $filterNext='';
    $itemIDs = array();
    while($hasMore){
        if(strcmp($skip,'')!=0){$filterNext= "?".explode('?',$skip)[1]; } 
        $result = $client->requestData('U_ITMCAT1'.$filterNext,'');
        $skip  = $result[1];
        if(strcmp($skip,'')!=0){ $hasMore = true;} else {$hasMore = false;}
        
        $itemCategories = $result[0];  
        foreach($itemCategories AS $itemCategory){
            
            $itemCategory = (object)$itemCategory;
            
            $categoryNamesLevel1["$itemCategory->Code"] = "$itemCategory->Name";
            
        }
    }
    echo "<b>---CATEGORIES LEVEL 1/---</b><br>";
    
    
    echo "<br><b>---CATEGORIES LEVEL 2---</b>";
    $categoryNamesLevel2 = array();
    $hasMore = true;
    $skip = '';
    $filterNext='';
    $itemIDs = array();
    while($hasMore){
        if(strcmp($skip,'')!=0){$filterNext= "?".explode('?',$skip)[1]; } 
        $result = $client->requestData('U_ITMCAT2'.$filterNext,'');
        $skip  = $result[1];
        if(strcmp($skip,'')!=0){ $hasMore = true;} else {$hasMore = false;}
        
        $itemCategories = $result[0];  
        foreach($itemCategories AS $itemCategory){
            
             $itemCategory = (object)$itemCategory;
            
            $categoryNamesLevel2["$itemCategory->Code"] = "$itemCategory->Name";
            
        }
    }
    echo "<b>---CATEGORIES LEVEL 2/---</b><br>";
    
    
    echo "<br><b>---CATEGORIES LEVEL 3---</b>";
    $categoryNamesLevel3 = array();
    $hasMore = true;
    $skip = '';
    $filterNext='';
    $itemIDs = array();
    while($hasMore){
        if(strcmp($skip,'')!=0){$filterNext= "?".explode('?',$skip)[1]; } 
        $result = $client->requestData('U_ITMCAT3'.$filterNext,'');
        $skip  = $result[1];
        if(strcmp($skip,'')!=0){ $hasMore = true;} else {$hasMore = false;}
        
        $itemCategories = $result[0];  
        foreach($itemCategories AS $itemCategory){
            
            $itemCategory = (object)$itemCategory;
            
            $categoryNamesLevel3["$itemCategory->Code"] = "$itemCategory->Name";
            
        }
    }
    echo "<b>---CATEGORIES LEVEL 3/---</b><br>";
    
    echo "<br><b>---CATEGORIES LEVEL 4---</b>";
    $categoryNamesLevel4 = array();
    $hasMore = true;
    $skip = '';
    $filterNext='';
    $itemIDs = array();
    while($hasMore){
        if(strcmp($skip,'')!=0){$filterNext= "?".explode('?',$skip)[1]; } 
        $result = $client->requestData('U_ITMCAT4'.$filterNext,'');
        $skip  = $result[1];
        if(strcmp($skip,'')!=0){ $hasMore = true;} else {$hasMore = false;}
        
        $itemCategories = $result[0];  
        foreach($itemCategories AS $itemCategory){
            
            $itemCategory = (object)$itemCategory;
            
            $categoryNamesLevel4["$itemCategory->Code"] = "$itemCategory->Name";
            
        }
    }
    echo "<b>---CATEGORIES LEVEL 4/---</b><br>";
    
    
    // echo "<pre>";
    // var_dump($categoryNamesLevel1);
    // var_dump($categoryNamesLevel2);
    // var_dump($categoryNamesLevel3);
    // echo "</pre>";
    // return;
    
    
    $myfile = fopen("PARSER_B2B_PROGRESS.txt", "w") or die("Unable to open file!");
    echo "<br><b>---ITEMS---</b>";
    $hasMore = true;
    $isFirst = true;
    $skip = '';   
    $filterNext='';
    $itemIDs = array();
    $filterToday='';
    $counter=0;
    while($hasMore){
        // if($isFirst){$filterSelect='$filter=startswith(CardCode,\'c\')';$isFirst=false;}else{$filterSelect='';}
        if($isFirst && strcmp($today,'')!=0){$filterToday='$filter=UpdateDate%20ge%20'."'$today'";$isFirst=false;}else{$filterToday='';}
        if(strcmp($skip,'')!=0){$filterNext= "?".explode('?',$skip)[1]; } 
        $result = $client->requestData('Items'.$filterNext,$filterToday);
        $skip  = $result[1];
        if(strcmp($skip,'')!=0){$hasMore = true;} else {$hasMore = false;}
        $items = $result[0];
   
        // echo "<pre>";
        // var_dump($items);
    
    
        foreach($items AS $item){
            $item = (object)$item;
             $counter++;
            if (true) {
                

                if(itemExits($item->ItemCode)){
                    $itemID = getItemID($item->ItemCode);
                }
                
                
                if(strcmp($item->ItemsGroupCode,'')!=0){
                    
                    echo "GROUP: $item->ItemsGroupCode > $item->U_Category1 > $item->U_Category2 > $item->U_Category3 <br>";
                
                    
                    $categoryParent = $item->ItemsGroupCode;
                    
                    if(categoryExists($categoryParent)){
                        $categoryParentID = getCategoryID($categoryParent);
                    }
                    
                    if($categoryParentID > 0 && $itemID > 0){
                        if(!itemExistsInCategory($itemID, $categoryParentID)){
                            insertItemToB2BCategory($itemID,$categoryParentID);
                        }
                    }
                    
                    if($categoryParent > 0){
                    
                        if(strcmp($item->U_Category1,'')!=0){
                            
                            $categoryLevel1 = $categoryParent."_".strtoupper(str_replace(' ','_',make_greeklish_categories($item->U_Category1)));
                            $categoryNameLevel1 = $categoryNamesLevel1["$item->U_Category1"];
                            
                            if(categoryExists($categoryLevel1)){
                                $categoryLevel1ID = updateCategory($categoryLevel1,"$categoryNameLevel1",$categoryDescription="B2B L1",$categoryLevel=0);
                            } else {
                                $categoryLevel1ID = insertCategory($categoryLevel1,"$categoryNameLevel1",$categoryDescription="B2B L1",$categoryLevel=0);
                            }
                            
                            
                            
                            if($categoryLevel1ID > 0){
                                if($itemID > 0){
                                    insertItemToB2BCategory($itemID,$categoryLevel1ID);
                                }
                                
                                if($categoryParentID > 0){
                                    insertSubCategory($categoryParentID,$categoryLevel1ID);
                                }
                            }
        
                        }
                        
                        if(strcmp($item->U_Category2,'')!=0){
                            
                            if(strcmp($item->U_Category1,'')!=0 && $categoryLevel1ID > 0){
                                $categoryParent = $categoryLevel1;
                                $categoryParentID = $categoryLevel1ID;
                            }
                            
                            $categoryLevel2 = $categoryParent."_".strtoupper(str_replace(' ','_',make_greeklish_categories($item->U_Category2)));
                            $categoryNameLevel2 = $categoryNamesLevel2["$item->U_Category2"];
                            
                            if(categoryExists($categoryLevel2)){
                                $categoryLevel2ID = updateCategory($categoryLevel2,"$categoryNameLevel2",$categoryDescription="B2B L2",$categoryLevel=0);
                            } else {
                                $categoryLevel2ID = insertCategory($categoryLevel2,"$categoryNameLevel2",$categoryDescription="B2B L2",$categoryLevel=0);
                            }
                            
                            if($categoryLevel2ID > 0){
                                
                                if($itemID > 0){
                                    insertItemToB2BCategory($itemID,$categoryLevel2ID);
                                }
                                
                                if($categoryParentID > 0){
                                    insertSubCategory($categoryParentID,$categoryLevel2ID);
                                }
                            }
        
                        }
                        
                        
                        if(strcmp($item->U_Category3,'')!=0){
                            
                            if(strcmp($item->U_Category1,'')!=0 && $categoryLevel1ID > 0){
                                $categoryParent = $categoryLevel1;
                                $categoryParentID = $categoryLevel1ID;
                            }
                            
                            if(strcmp($item->U_Category2,'')!=0 && $categoryLevel2ID > 0){
                                $categoryParent = $categoryLevel2;
                                $categoryParentID = $categoryLevel2ID;
                            }
                            
                            $categoryLevel3 = $categoryParent."_".strtoupper(str_replace(' ','_',make_greeklish_categories($item->U_Category3)));
                            $categoryNameLevel3 = $categoryNamesLevel3["$item->U_Category3"];

                            if(categoryExists($categoryLevel3)){
                                $categoryLevel3ID = updateCategory($categoryLevel3,"$categoryNameLevel3",$categoryDescription="B2B L3",$categoryLevel=0);
                            } else {
                                $categoryLevel3ID = insertCategory($categoryLevel3,"$categoryNameLevel3",$categoryDescription="B2B L3",$categoryLevel=0);
                            }
                            
                            if($categoryLevel3ID > 0){
                                
                                if($itemID > 0){
                                    insertItemToB2BCategory($itemID,$categoryLevel3ID);
                                }
                                
                                if($categoryParentID > 0){
                                    insertSubCategory($categoryParentID,$categoryLevel3ID);
                                }
                            }
        
                        }
                        
                        if(strcmp($item->U_Category4,'')!=0){
                            
                            if(strcmp($item->U_Category1,'')!=0 && $categoryLevel1ID > 0){
                                $categoryParent = $categoryLevel1;
                                $categoryParentID = $categoryLevel1ID;
                            }
                            
                            if(strcmp($item->U_Category2,'')!=0 && $categoryLevel2ID > 0){
                                $categoryParent = $categoryLevel2;
                                $categoryParentID = $categoryLevel2ID;
                            }
                            
                            if(strcmp($item->U_Category3,'')!=0 && $categoryLevel3ID > 0){
                                $categoryParent = $categoryLevel3;
                                $categoryParentID = $categoryLevel3ID;
                            }
                            
                            $categoryLevel4 = $categoryParent."_".strtoupper(str_replace(' ','_',make_greeklish_categories($item->U_Category4)));
                            $categoryNameLevel4 = $categoryNamesLevel4["$item->U_Category4"];

                            if(categoryExists($categoryLevel4)){
                                $categoryLevel4ID = updateCategory($categoryLevel4,"$categoryNameLevel4",$categoryDescription="B2B L4",$categoryLevel=0);
                            } else {
                                $categoryLevel4ID = insertCategory($categoryLevel4,"$categoryNameLevel4",$categoryDescription="B2B L4",$categoryLevel=0);
                            }
                            
                            if($categoryLevel4ID > 0){
                                
                                if($itemID > 0){
                                    insertItemToB2BCategory($itemID,$categoryLevel4ID);
                                }
                                
                                if($categoryParentID > 0){
                                    insertSubCategory($categoryParentID,$categoryLevel4ID);
                                }
                            }
        
                        }
                        
                        
                    
                    }
                    
                }
                
                
               
                
                
                
            }
        }
        $txt = "$counter  $filterNext  - ".date("H:s:i")." \n";
        fwrite($myfile, $txt);
        
    }
    echo "<b>---ITEMS/---</b><br>";

    
fclose($myfile);



}

function make_greeklish_categories($text) {
    $expressions = array(
        '/[αΑ][ιίΙΊ]/u' => 'e',
        '/[οΟΕε][ιίΙΊ]/u' => 'i',
        '/[αΑ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'af$1',
        '/[αΑ][υύΥΎ]/u' => 'av',
        '/[εΕ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'ef$1',
        '/[εΕ][υύΥΎ]/u' => 'ev',
        '/[οΟ][υύΥΎ]/u' => 'ou',
        '/(^|\s)[μΜ][πΠ]/u' => '$1b',
        '/[μΜ][πΠ](\s|$)/u' => 'b$1',
        '/[μΜ][πΠ]/u' => 'mp',
        '/[νΝ][τΤ]/u' => 'nt',
        '/[τΤ][σΣ]/u' => 'ts',
        '/[τΤ][ζΖ]/u' => 'tz',
        '/[γΓ][γΓ]/u' => 'ng',
        '/[γΓ][κΚ]/u' => 'gk',
        '/[ηΗ][υΥ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'if$1',
        '/[ηΗ][υΥ]/u' => 'iu',
        '/[θΘ]/u' => 'th',
        '/[χΧ]/u' => 'ch',
        '/[ψΨ]/u' => 'ps',
        '/[αά]/u' => 'a',
        '/[βΒ]/u' => 'v',
        '/[γΓ]/u' => 'g',
        '/[δΔ]/u' => 'd',
        '/[εέΕΈ]/u' => 'e',
        '/[ζΖ]/u' => 'z',
        '/[ηήΗΉ]/u' => 'i',
        '/[ιίϊΙΊΪ]/u' => 'i',
        '/[κΚ]/u' => 'k',
        '/[λΛ]/u' => 'l',
        '/[μΜ]/u' => 'm',
        '/[νΝ]/u' => 'n',
        '/[ξΞ]/u' => 'x',
        '/[οόΟΌ]/u' => 'o',
        '/[πΠ]/u' => 'p',
        '/[ρΡ]/u' => 'r',
        '/[σςΣ]/u' => 's',
        '/[τΤ]/u' => 't',
        '/[υύϋΥΎΫ]/u' => 'i',
        '/[φΦ]/iu' => 'f',
        '/[ωώ]/iu' => 'o',
    );

    $text = preg_replace( array_keys($expressions), array_values($expressions), $text);
    return $text;
}


?>