<?php
function importAndDeleteContractPrices($client,$today)
{   
    $testFile = fopen('ImportContractPrices_LOG.txt','w');
    deleteContractPricesHelper();
    $contractPricesCounter = 0;
    $supplierPricesCounter = 0;
    echo "<br><b>---ALL CONTRACT PRICES---</b><br>";
    $hasMore = true;
    $isFirst = true;
    $skip = '';
    $itemIDs = array();
    while($hasMore){
        // if($isFirst){$filterNext='?$skip=156460';$isFirst=false;}
        if(strcmp($skip,'')!=0){$filterNext= "?".explode('?',$skip)[1]; } 
        $result = $client->requestData('SpecialPrices'.$filterNext,'');
        $skip  = $result[1];
        if(strcmp($skip,'')!=0){ $hasMore = true;} else {$hasMore = false;}
        fwrite($testFile,"\n$result[1]\n");
        $contractPrices = $result[0];
        //  echo "<pre>";
        //  var_dump($contractPrices);
        // echo "</pre>";
        
        foreach($contractPrices AS $contractPrice){
            $contractPrice = (object)$contractPrice;
            
            $itemCode = $contractPrice->ItemCode;
            $customerCode = $contractPrice->CardCode;
            $price = $contractPrice->Price;
            $discountPercent = $contractPrice->DiscountPercent;
            $priceListCode = $contractPrice->PriceListNum;
            $isAutoUpdate = trim(strtolower($contractPrice->AutoUpdate),'t');
            $isValid = trim(strtolower($contractPrice->Valid),'t');
            $customerPriceListID = 0;
            
            if (strpos($customerCode, 'S1') !== false || strpos($customerCode, 'Y0') !== false) {
                
                fwrite($testFile,"\nSUPPLIER PRICE Item: $itemCode, Supplier: $customerCode, Price: $price, Discount: $discountPercent");
                
                $itemID = getItemID($itemCode);
                $supplierID = getSupplierID($customerCode);
                
                if($supplierID > 0 && $itemID > 0){
                    insertSupplierContractPrice($supplierID,$itemID,$price);
                    $supplierPricesCounter++;
                    fwrite($testFile," Counter: $supplierPricesCounter -> inserted (S:$supplierID,I:$itemID,P:$price,D:$discountPercent) \n ");
                } else {
                    fwrite($testFile," Counter: $supplierPricesCounter -> ERROR (S:$supplierID,I:$itemID,P:$price,D:$discountPercent) \n ");
                }
            } else {
            
                // echo "<br>CONTRACT PRICE Item: $itemCode, Customer: $customerCode, PriceList: $priceListCode Discount: $discountPercent";
                fwrite($testFile,"\nCONTRACT PRICE Item: $itemCode, Customer: $customerCode, PriceList: $priceListCode Discount: $discountPercent");
                if(strcmp($isValid,'yes')==0){

                    $itemID = getItemID($itemCode);
                    $priceListID = getPriceTypeID($priceListCode);

                    if(intval($priceListID) > 0 && strcmp("$priceListCode","")!=0) {
                        $plPrice = getPrice($priceListID,$itemID);
                        $price = $plPrice - $plPrice*($discountPercent/100);
                    }
                    
                    if (strpos($customerCode, '*') !== false) {
                        $customerPriceList= trim($customerCode, '*');
                        $customerPriceListID = getPriceTypeID($customerPriceList);
                        
                        if($customerPriceListID > 0){
                            $customerIDs = getCustomersFromPriceType($customerPriceListID);    
                        }

                    } else {
                        $customerIDs = array(getCustomerID($customerCode)); 
                    }

                    if(!empty($customerIDs)){

                        foreach($customerIDs as $customerID){
                            if($customerID > 0 && $itemID > 0){

                                if($customerPriceListID > 0){$priceListID = $customerPriceListID;}
                                
                                $finalPrice = $price;
                                $contractPricesCounter++;
                                insertContractPrice($customerID,$itemID,$finalPrice,$discountPercent,$priceListID);
                                insertContractPriceHelper($customerID,$itemID,$finalPrice,$discountPercent,$priceListID);
                                // echo " -> Insert Contract Price ->  $finalPrice = $plPrice - $plPrice*($discountPercent/100); - Discount: $discountPercent%";
                                fwrite($testFile," Counter: $contractPricesCounter -> inserted (C:$customerID,I:$itemID,P:$finalPrice,D:$discountPercent) | ");
                            } else {
                                fwrite($testFile," Counter: $contractPricesCounter -> ERROR (C:$customerID,I:$itemID,P:$finalPrice,D:$discountPercent) | ");
                            }
                        }

                    } else {
                        //echo "<br> Empty Customers Array-> $customerPriceList = $customerPriceListID";
                    }
                }
            
            } 
        }
    }
    fwrite($testFile,"\nEND OF INSERT");
    echo "<br><b>---ALL CONTRACT PRICES/---</b><br>";
    
    echo "<br><b>---DELETE OLD CONTRACT PRICES---</b><br>";
    if($contractPricesCounter > 2000){
        removeContractPricesNotInHelper();
        fwrite($testFile,"\nEND OF DELETE");
    }
    fwrite($testFile,"\nEND OF PARSER");
    echo "<br><b>---DELETE OLD CONTRACT PRICES/---</b><br>";
    fclose($testFile);

}


?>