<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

require_once('dbinfo.php');
require_once('SAPClient.php');
require_once('SAPClientPreferences.php');
require_once('importFunctions.php');
include_once("exportFunctions.php");

$client = new SAPClient($b1Host,$b1Port,$b1UserName,$b1Password,$b1CompanyDB);
$client->startConnection();
$dateFilter='';

$stockTakingIDsPost = $_POST['stockTakingIDs'];
if(!empty($stockTakingIDsPost)){
    exportStockTakings($client,$today,$stockTakingIDsPost);
} else {
    echo "<center>Something went wrong. Please try again. $stockTakingIDsPost</center>";
}
function exportStockTakings($client,$today,$stockTakingIDsPost)
{   
    global $username;
    global $password;
    global $database;
    
    $stockTakingIDsPost = implode(',',$stockTakingIDsPost);


    $db11 = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
 	$stockTakings = array();
 	$stockTakingIDs = array();
 	$stockTakingCodes = array();
	$db11->set_charset("utf8");
	$stm11 = $db11->prepare("SELECT Stock_Taking.stock_taking_id,Stock_Taking.stock_taking_code, Items.item_code,Warehouses.warehouse_code,Stock_Taking_Item.qty FROM Stock_Taking,Stock_Taking_Item,Warehouses,Items WHERE Warehouses.warehouse_id=Stock_Taking.warehouse_id AND Items.item_id=Stock_Taking_Item.item_id AND Stock_Taking.stock_taking_id=Stock_Taking_Item.stock_taking_id AND Stock_Taking.stock_taking_id NOT IN (SELECT id FROM Documents_Status WHERE type='13') AND Stock_Taking.stock_taking_id IN ($stockTakingIDsPost) ORDER BY Warehouses.warehouse_code ASC,Items.item_code ASC");
	$stm11-> execute();
	$stm11-> bind_result($stockTakingID,$stockTakingCode,$itemCode,$whCode,$qty);
	while ($stm11->fetch()) {
    $stockTakings[$whCode][$itemCode] += $qty;
    array_push($stockTakingIDs,$stockTakingID);
    $stockTakingCodes[$stockTakingID] = $stockTakingCode;
       
        
	}
	$stm11->close();
	
	$stockTakingIDs = array_unique($stockTakingIDs);
	$stockTakingCodes = array_unique($stockTakingCodes);
	
    $postData = array();
	
	
	
	foreach($stockTakings as $warehouseCode => $item){
	    
        $lineCounter = 0;
        $stockTakes = '';
    	$stockTakes->BranchID = getBranchID($warehouseCode);
    	$stockTakes->InventoryCountingLines = array();
    	
	    foreach($item as $itemCode => $counted){
	       $lineCounter++;
	       $uomCode = getUomCode($itemCode);
	       
	       
	       
	       $stockTake = '';
	       $stockTake->LineNumber = $lineCounter;
	       $stockTake->ItemCode = "$itemCode";
	       $stockTake->WarehouseCode = "$warehouseCode";
	       //$stockTake->Counted = "tYES";
	       $stockTake->UoMCode = $uomCode;
	       $stockTake->CountedQuantity = $counted;
	       
	       if(strcmp($uomCode,'Manual')==0){
	           $stockTake->UoMCountedQuantity = null;
	           $stockTake->InventoryCountingLineUoMs = array();
	       } else {
	           
	           $InventoryCountingLineUoMs ='';
	           $InventoryCountingLineUoMs->LineNumber=$lineCounter;
	           $InventoryCountingLineUoMs->ChildNumber=1;
	           $InventoryCountingLineUoMs->UoMCountedQuantity=$counted;
	           $InventoryCountingLineUoMs->UoMCode="$uomCode";
	           
	           $stockTake->UoMCountedQuantity = $counted;
	           $stockTake->InventoryCountingLineUoMs = array($InventoryCountingLineUoMs);
	           
	       }
	       
	       $stockTake->InventoryCountingSerialNumbers = array();
	       $stockTake->InventoryCountingBatchNumbers = array();
	       
	       
           array_push($stockTakes->InventoryCountingLines,$stockTake);
           array_push($postData,$stockTakes);
	        
	    }
	    
	    if(!empty($stockTakes)){
	       // echo "<pre>";
        //     var_dump(json_encode($stockTakes));
        //     echo "</pre>";
            $result = $client->postData("InventoryCountings",$stockTakes);
            // echo "<pre><br>";
            // var_dump($result);
            // echo "</pre><br>";
            if($result["error"]["code"] < 0 ){break;}
	    }
	    
	}
    	
	


    // echo "<pre><br>";
    // var_dump($result);
    // echo "</pre><br>";
    
    $status = 1;
    $type = 13;
    $reason = "OK";
        
    $status = $result["error"]["code"];
    $reason = $result["error"]["message"]["value"];
    
    if(strcmp($status,'')==0){$status = 1;$reason = "OK";}
	echo "<table style='width:100%;'>";
    echo "<tr><td style='padding: 5px;'><b> # </td><td style='padding: 5px;'><b> Stock Taking Code </td><td style='padding: 5px;'><b> Status </td><td style='padding: 5px;'><b> Reason </td></tr>";

	foreach($stockTakingIDs as $stockTakingID){
	    insertDocumentStatuses($stockTakingID,$type,$status,$reason);
        // sendFailErrorEmail('Stock_Taking',$code,$id,$status,$reason,$to='');
	    $stockTakingCode = $stockTakingCodes[$stockTakingID];
	    echo "<tr><td style='padding: 5px;'><img class=\"custom-rounded-image invoice center-canvas\" src=\"//acre.coprimeinfo.com/cop/backend/themes/smartadminACRE/img/stockadjustmenticon.png\" width=\"30\" height=\"30\" ></td><td style='padding: 5px;'> $stockTakingCode </td><td style='padding: 5px;'> $status</td><td style='padding: 5px;'>$reason</td></tr>";
	}
	echo "";


	


}

function getUomCode($itemCode){
    
    global $username;
    global $password;
    global $database;
    $db12 = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
 	$z="";
 	$db12->set_charset("utf8");
	$stm12 = $db12->prepare("SELECT UOMs.description FROM Items,UOM_Item,UOMs WHERE Items.item_id=UOM_Item.item_id AND UOM_Item.uom_id=UOMs.uom_id AND Items.item_code='$itemCode' ORDER BY multiplier ASC LIMIT 1");
	$stm12-> execute();
	$stm12-> bind_result($description);
	while ($stm12->fetch()) {
	    
	    $codeName = explode('-',$description);
	    $code = trim($codeName[0]);
	    $name = trim($codeName[1]);
	    if(strcmp($code,'')!=0){$z=$code;}
	    
	}
	$stm12->close();
	return $z;
}

function getBranchID($warehouseCode){
    
    global $username;
    global $password;
    global $database;
	
    $db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");


      
    $companyID=1;
	$stm1 = $db1->prepare("SELECT company_id FROM Warehouses WHERE warehouse_code ='$warehouseCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($id);
	while ($stm1->fetch()) {
		if($id > 0){
		  $companyID = $id;
		}
	}
	$stm1->close();
    
    $stm1 = $db1->prepare("SELECT company_code FROM Companies WHERE company_id ='$companyID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($companyCode);
	while ($stm1->fetch()) {}
	$stm1->close();
	
	if(strcmp($companyCode,'GDL')==0){$companyCode=1;}
     
    return $companyCode;
	
}


?>