<?php
//-------------------------------------------------------DATEBASE FUNCTIONS---------------------------------------------
   
   
function insertContract($customerID,$itemID,$serialNumberID)
{
   global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
	$contractID = getNextID("Contracts","contract_id");
 	$stmt = $db->prepare("INSERT INTO Contracts (contract_id,customer_id,item_id,serial_number_id,timestamp) VALUES(?,?,?,?,NOW())");
	$stmt->bind_param('iiii',$contractID,$customerID,$itemID,$serialNumberID);
 	$stmt->execute(); 	
 	$stmt->close(); 
}

function insertPriceGroup($priceGroupCode,$priceGroupName,$priceGroupType)
{
    global $username;
    global $password;
    global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
	$priceGroupID = getNextID("Price_Group_Definitions","price_group_definition_id");
 	$stmt = $db->prepare("INSERT INTO Price_Group_Definitions (price_group_definition_id,price_group_code,name,type,timestamp) VALUES(?,?,?,?,NOW())");
	$stmt->bind_param('isss',$priceGroupID,$priceGroupCode,$priceGroupName,$priceGroupType);
 	$stmt->execute(); 	
 	$stmt->close(); 
 	
 	return $priceGroupID;
}

function insertPriceGroupRule($priceGroupDefinitionID,$categoryID,$discountPrcent,$priceTypeID,$priceGroupRuleID)
{
    global $username;
    global $password;
    global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
	if($priceGroupRuleID==0)
	{
	    $priceGroupRuleID = getNextID("Price_Group_Rules","price_group_rule_id");
	}
 	$stmt = $db->prepare("INSERT INTO Price_Group_Rules (price_group_rule_id,price_group_definition_id,category_id,discount_percent,price_type_id,timestamp) VALUES(?,?,?,?,?,NOW()) ON DUPLICATE KEY UPDATE discount_percent=?, price_type_id=?");
	$stmt->bind_param('iiididi',$priceGroupRuleID,$priceGroupDefinitionID,$categoryID,$discountPrcent,$priceTypeID,$discountPrcent,$priceTypeID);
 	$stmt->execute(); 	
 	$stmt->close(); 
 	
 	return $priceGroupRuleID;
}

function insertGroupContractPrice($groupID,$itemID,$priceTypeID,$finalPrice,$DiscountPercentRule,$validFrom,$minQty){
    global $username;
    global $password;
    global $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $validUntil = '2050-01-01';

    $stmt = $db->prepare("INSERT INTO GroupContractPrices (group_id,item_id,price,pricetype_id,percentage,min_qty,valid_from,valid_until,timestamp) VALUES(?,?,?,?,?,?,?,?,NOW()) ON DUPLICATE KEY UPDATE price=?,pricetype_id=?,percentage=?");
    $stmt->bind_param('iididdssdid',$groupID,$itemID,$finalPrice,$priceTypeID,$DiscountPercentRule,$minQty,$validFrom,$validUntil,$finalPrice,$priceTypeID,$DiscountPercentRule);
    $stmt->execute();
    $stmt->close();

    return $priceGroupRuleID;
}

function insertCustomerToPriceGroup($priceGroupDefinitionID,$customerID)
{
    global $username;
    global $password;
    global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
	
	$priceGroupCustomerID = getNextID("Price_Group_Customer","price_group_customer_id");
 	$stmt = $db->prepare("INSERT INTO Price_Group_Customer (price_group_customer_id,price_group_definition_id,customer_id,timestamp) VALUES(?,?,?,NOW())");
	$stmt->bind_param('iii',$priceGroupCustomerID,$priceGroupDefinitionID,$customerID);
 	$stmt->execute(); 	
 	$stmt->close(); 
 	
 	return $priceGroupCustomerID;
}

function customerExistInPriceGroup($priceGroupDefinitionID,$customerID){
    
    global $username;
    global $password;
    global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(price_group_customer_id) FROM Price_Group_Customer WHERE price_group_definition_id='$priceGroupDefinitionID' AND customer_id='$customerID'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
} 

function insertCustomerGroupToPriceGroup($priceGroupDefinitionID,$customerGroupID)
{
    global $username;
    global $password;
    global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
	
	$priceGroupCustomerID = getNextID("Price_Group_Customer_Group","price_group_customer_id");
 	$stmt = $db->prepare("INSERT INTO Price_Group_Customer_Group (price_group_customer_id,price_group_definition_id,customer_group_id,timestamp) VALUES(?,?,?,NOW())");
	$stmt->bind_param('iii',$priceGroupCustomerID,$priceGroupDefinitionID,$customerGroupID);
 	$stmt->execute(); 	
 	$stmt->close(); 
 	
 	return $priceGroupCustomerID;
}

function customerGroupExistInPriceGroup($priceGroupDefinitionID,$customerGroupID){
    
    global $username;
    global $password;
    global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(price_group_customer_id) FROM Price_Group_Customer_Group WHERE price_group_definition_id='$priceGroupDefinitionID' AND customer_group_id='$customerGroupID'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
}

function getPriceGroupRuleID($priceGroupDefinitionID,$categoryID) {
global $username;
global $password;
global $database;
	$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT price_group_rule_id FROM Price_Group_Rules WHERE price_group_definition_id=? AND category_id=? LIMIT 1");
	$stm1->bind_param('ii',$priceGroupDefinitionID,$categoryID);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function getPriceGroupID($priceGroupCode) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT price_group_definition_id FROM Price_Group_Definitions WHERE price_group_code=? LIMIT 1");
	$stm1->bind_param('s',$priceGroupCode);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function priceGroupExist($priceGroupCode){
    
    global $username;
    global $password;
    global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(price_group_definition_id) FROM Price_Group_Definitions WHERE price_group_code='$priceGroupCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
}  

function supplierExists($customerCode) {

global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(customer_id) FROM Suppliers WHERE customer_code='$customerCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
}

function customerExists($customerCode) {

global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(customer_id) FROM Customers WHERE customer_code='$customerCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
}

function customerExistsInGroup($groupID,$customerID)
{
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(group_id) FROM Customer_CustomersGroup WHERE group_id='$groupID' AND customer_id='$customerID'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();

    return $z;
}

function updateSupplier($customerCode,$customer_company_name=" ",$customer_report_name=" ",$logo=" ",$registration_code=" ",$mobile=" ",$website=" ",$email=" ",$description=" ",$type_of_business=" ",$tic_code=" ",$vat_code=" ",$credit_limit=0,$address_code_eurosoft=" ",$customer_type=" ",$balance=0) {

    global $username, $password, $database;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Suppliers SET customer_company_name=?,customer_report_name=?,logo=?,registration_code=?,mobile=?,website=?,email=?,description=?,type_of_business=?,tic_code=?,vat_code=?,credit_limit=?,address_code_eurosoft=?,customer_type=?,balance=? WHERE customer_code='$customerCode'");
	$stmt1->bind_param('sssssssssssdssd',$customer_company_name,$customer_report_name,$logo,$registration_code,$mobile,$website,$email,$description,$type_of_business,$tic_code,$vat_code,$credit_limit,$address_code_eurosoft,$customer_type,$balance);
 	$stmt1->execute(); 	
 	$stmt1->close();

    // return $stmt->error;
    return getSupplierID($customerCode);
}

function updateCustomer($customerCode,$customer_company_name=" ",$customer_report_name=" ",$logo=" ",$registration_code=" ",$mobile=" ",$website=" ",$email=" ",$description=" ",$type_of_business=" ",$tic_code=" ",$vat_code=" ",$credit_limit=0,$address_code_eurosoft=" ",$customer_type=" ",$balance=0) {

    global $username, $password, $database;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Customers SET customer_company_name=?,customer_report_name=?,logo=?,registration_code=?,mobile=?,website=?,email=?,description=?,type_of_business=?,tic_code=?,vat_code=?,credit_limit=?,address_code_eurosoft=?,customer_type=?,balance=? WHERE customer_code='$customerCode'");
	$stmt1->bind_param('sssssssssssdssd',$customer_company_name,$customer_report_name,$logo,$registration_code,$mobile,$website,$email,$description,$type_of_business,$tic_code,$vat_code,$credit_limit,$address_code_eurosoft,$customer_type,$balance);
 	$stmt1->execute(); 	
 	$stmt1->close();

    // return $stmt->error;
    return getCustomerID($customerCode);
}

function insertSupplier($customer_code,$customer_company_name=" ",$customer_report_name=" ",$logo=" ",$registration_code=" ",$mobile=" ",$website=" ",$email=" ",$description=" ",$type_of_business="Credit",$tic_code=" ",$vat_code=" ",$credit_limit=0,$address_code_eurosoft=" ",$customer_type="Credit",$balance=0) {

    global $username, $password, $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
    $customer_id = getNextID("Suppliers","customer_id");
 	$stmt = $db->prepare("INSERT INTO Suppliers (customer_id,customer_code,customer_company_name,customer_report_name,logo,registration_code,mobile,website,email,description,type_of_business,tic_code,vat_code,credit_limit,address_code_eurosoft,customer_type,balance,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
	$stmt->bind_param('issssssssssssdssd',$customer_id,$customer_code,$customer_company_name,$customer_report_name,$logo,$registration_code,$mobile,$website,$email,$description,$type_of_business,$tic_code,$vat_code,$credit_limit,$address_code_eurosoft,$customer_type,$balance);
 	$stmt->execute();
    $stmt->execute();
 	$stmt->close();

    // return $stmt->error;
    return $customer_id;
}


function insertCustomer($customer_code,$customer_company_name=" ",$customer_report_name=" ",$logo=" ",$registration_code=" ",$mobile=" ",$website=" ",$email=" ",$description=" ",$type_of_business="Credit",$tic_code=" ",$vat_code=" ",$credit_limit=0,$address_code_eurosoft=" ",$customer_type="Credit",$balance=0) {

    global $username, $password, $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
    $customer_id = getNextID("Customers","customer_id");
 	$stmt = $db->prepare("INSERT INTO Customers (customer_id,customer_code,customer_company_name,customer_report_name,logo,registration_code,mobile,website,email,description,type_of_business,tic_code,vat_code,credit_limit,address_code_eurosoft,customer_type,balance,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
	$stmt->bind_param('issssssssssssdssd',$customer_id,$customer_code,$customer_company_name,$customer_report_name,$logo,$registration_code,$mobile,$website,$email,$description,$type_of_business,$tic_code,$vat_code,$credit_limit,$address_code_eurosoft,$customer_type,$balance);
 	$stmt->execute();
    $stmt->execute();
 	$stmt->close();

    // return $stmt->error;
    return $customer_id;
}


function insertCustomerToGroup($groupID,$customerID){
global $username;
global $password;
global $database;

    $db2 = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno())
 	{
 	    printf("Connect failed: %s\n", mysqli_connect_error());
 	    exit();
 	}
 	$db2->set_charset("utf8");
 	$stmt2 = $db2->prepare("INSERT INTO Customer_CustomersGroup (group_id,customer_id,added_date,timestamp) VALUES(?,?,CURDATE(),NOW())");
 	$stmt2->bind_param('ss',$groupID,$customerID);
 	$stmt2->execute();
 	$stmt2->close();
}

function customerExistsInOtherSALGroups($groupID,$customerID)
{
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(group_id) FROM Customer_CustomersGroup WHERE group_id IN(SELECT group_id FROM CustomerGroups WHERE description='SAL' AND NOT group_id='$groupID') AND customer_id='$customerID'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();

    return $z;
}

function removeCustomerfroOtherSALGroups($categorySALID,$customerID){
global $username;
global $password;
global $database;

    $db2 = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno())
 	{
 	    printf("Connect failed: %s\n", mysqli_connect_error());
 	    exit();
 	}
 	$db2->set_charset("utf8");
 	$stmt2 = $db2->prepare("DELETE FROM Customer_CustomersGroup WHERE group_id IN(SELECT group_id FROM CustomerGroups WHERE description='SAL' AND NOT group_id=?) AND customer_id=?");
 	$stmt2->bind_param('ss',$categorySALID,$customerID);
 	$stmt2->execute();
 	$stmt2->close();
 	
    $deleteID = getNextID("Deletes", "delete_id");
    $statement ="DELETE FROM Customer_CustomersGroup WHERE group_id IN(SELECT group_id FROM CustomerGroups WHERE description='SAL' AND NOT group_id='$categorySALID') AND customer_id=$customerID";
    $stmt2 = $db2->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
    $stmt2->bind_param('is',$deleteID,$statement);
    $stmt2->execute();
    $stmt2->close();

}
function categoryExists($categoryCode){
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(category_id) FROM Categories WHERE category_code='$categoryCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;


}


function updateCategory($categoryCode,$categoryName,$categoryDescription,$categoryLevel){
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Categories SET name=?,description=? WHERE category_code='$categoryCode'");
	$stmt1->bind_param('ss',$categoryName,$categoryDescription);
 	$stmt1->execute(); 	
 	$stmt1->close();

 	return getCategoryID($categoryCode);
}

function updateCategoryNameCustom($categoryCode,$categoryName,$categoryDescription){
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Categories SET name=? WHERE category_code='$categoryCode' AND description='$categoryDescription'");
	$stmt1->bind_param('s',$categoryName);
 	$stmt1->execute(); 	
 	$stmt1->close();

//  	return getCategoryID($categoryCode);
}

function insertCategory($categoryCode,$categoryName,$categoryDescription,$categoryLevel){
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
	$categoryID = getNextID("Categories","category_id");
 	$stmt = $db->prepare("INSERT INTO Categories (category_id,category_code,name,description,level,timestamp) VALUES(?,?,?,?,?,NOW())");
	$stmt->bind_param('isssi',$categoryID,$categoryCode,$categoryName,$categoryDescription,$categoryLevel);
 	$stmt->execute(); 	
 	$stmt->close();

 	return $categoryID;
}

function insertSubCategory($categoryID,$subcategoryID){
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
 	$stmt = $db->prepare("INSERT IGNORE INTO Subcategories (category_id,subcategory_id,date_added,timestamp) VALUES(?,?,NOW(),NOW())");
	$stmt->bind_param('ii',$categoryID,$subcategoryID);
 	$stmt->execute(); 	
 	$stmt->close();
}

function vatExits($vatCode)
{
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(vat_id) FROM Vats WHERE vat_code='$vatCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();
   
   
        return $z;

}

function updateVAT($vatCode,$vatName,$percentage)
{
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Vats SET vat_display_name = ?, percentage =? WHERE vat_code='$vatCode'");
	$stmt1->bind_param('sd',$vatName,$percentage);
 	$stmt1->execute(); 	
 	$stmt1->close();

    return getVatID($vatCode);
}


function insertVAT($vatCode,$vatName,$percentage)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
	$vatID = getNextID("Vats","vat_id");
 	$stmt = $db->prepare("INSERT INTO Vats (vat_id,vat_code,vat_display_name,percentage) VALUES(?,?,?,?)");
	$stmt->bind_param('issd',$vatID,$vatCode,$vatName,$percentage);
 	$stmt->execute(); 	
 	$stmt->close();

 	return $vatID;
}



function getVatID($vatCode)
{
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
			$z=$counter;		
	 }
	 $stm1->close();
   
   
        return $z;



}


function getVatItemID($itemID)
{
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT vat_id FROM Items WHERE item_id='$itemID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
			$z=$counter;		
	 }
	 $stm1->close();
   
   
        return $z;


}
function itemExits($itemCode)
{
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(item_id) FROM Items WHERE item_code='$itemCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();  
   
        return $z;
}

function itemExistsInCategory($itemID, $categoryID){
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(item_id) FROM Category_Item WHERE category_id='$categoryID' AND item_id='$itemID' LIMIT 1 ");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();


    return $z;


}

function itemExistsInDescriptedCategory($itemID, $categoryID, $descripton){
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(item_id) FROM Category_Item WHERE category_id IN (select category_id FROM Categories WHERE description='$descripton') AND item_id='$itemID' AND NOT category_id='$categoryID'  LIMIT 1 ");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();


    return $z;


}

function removeItemfromDescreptedCategory($itemID, $categoryID, $descripton){
global $username;
global $password;
global $database;

    $db2 = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno())
 	{
 	    printf("Connect failed: %s\n", mysqli_connect_error());
 	    exit();
 	}
 	$db2->set_charset("utf8");
 	$stmt2 = $db2->prepare("DELETE FROM Category_Item WHERE category_id IN(SELECT category_id FROM Categories WHERE description=? AND NOT category_id=?) AND item_id=?");
 	$stmt2->bind_param('sii',$descripton,$categoryID,$itemID);
 	$stmt2->execute();
 	$stmt2->close();
 	
    $deleteID = getNextID("Deletes", "delete_id");
    $statement ="DELETE FROM Category_Item WHERE category_id IN(SELECT category_id FROM Categories WHERE description='$descripton' AND NOT category_id='$categoryID') AND item_id='$itemID'";
    $stmt2 = $db2->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
    $stmt2->bind_param('is',$deleteID,$statement);
    $stmt2->execute();
    $stmt2->close();

}

function removeItemfromCategory($itemID, $categoryID){
global $username;
global $password;
global $database;

    $db2 = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno())
 	{
 	    printf("Connect failed: %s\n", mysqli_connect_error());
 	    exit();
 	}
 	$db2->set_charset("utf8");
 	$stmt2 = $db2->prepare("DELETE FROM Category_Item WHERE category_id=? AND item_id=?");
 	$stmt2->bind_param('ii',$categoryID,$itemID);
 	$stmt2->execute();
 	$stmt2->close();
 	
    $deleteID = getNextID("Deletes", "delete_id");
    $statement ="DELETE FROM Category_Item WHERE category_id='$categoryID' AND item_id='$itemID'";
    $stmt2 = $db2->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
    $stmt2->bind_param('is',$deleteID,$statement);
    $stmt2->execute();
    $stmt2->close();

}

function insertItem($item_code,$item_sku='',$company_id=0,$vat_id=0,$subunits=1,$sales_units='EACH',$manufacturer_id=0,$name='',$short_description='',$long_description='',$thumbnail_url='',$reorder_level=0,$target_qty=0,$bundled='',$max_stock=0,$min_stock=0,$packing=0,$stock_control='yes',$sellable='yes',$weight=0,$cbm=0,$status='yes')
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
 	$db->set_charset("utf8");
    $item_id = getNextID("Items","item_id");
 	$stmt = $db->prepare("INSERT INTO Items(item_id,item_code,item_sku,company_id,vat_id,subunits,sales_units,manufacturer_id,name,short_description,long_description,thumbnail_url,reorder_level,target_qty,bundled,max_stock,min_stock,packing,stock_control,sellable,weight,cbm,status,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 	$stmt->bind_param('issiidsissssdisdddssdds',$item_id,$item_code,$item_sku,$company_id,$vat_id,$subunits,$sales_units,$manufacturer_id,$name,$short_description,$long_description,$thumbnail_url,$reorder_level,$target_qty,$bundled,$max_stock,$min_stock,$packing,$stock_control,$sellable,$weight,$cbm,$status);
 	$stmt->execute();
 	echo $stmt->error;
 	$stmt->close();
 	

 	return $item_id ;
}


function updateItem($itemCode,$vatID=0,$subUnits=1,$salesUnits='',$name='',$shortDescription='',$longDescription='',$itemWeight=0,$status='yes',$packing=0)
{
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Items SET vat_id=?,subunits=?,sales_units=?,name=?,short_description=?,long_description=?,weight=?,status=?,subunits=?,packing=? WHERE item_code='$itemCode'");
	$stmt1->bind_param('isssssdsdd',$vatID,$subunits,$salesUnits,$name,$shortDescription,$longDescription,$itemWeight,$status,$subUnits,$packing);
 	$stmt1->execute(); 
 	$stmt1->close();
 	
 	return getItemID($itemCode);

}

function setInactiveItemsNotInArray($itemIDs){
    $status = "inactive";
    global $username;
    global $password;
    global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Items SET status=? WHERE item_id NOT IN ($itemIDs)");
	$stmt1->bind_param('s',$status);
 	$stmt1->execute(); 	
 	$stmt1->close();
}

function setInactiveCustomersNotInArray($customerIDs){
    $status = "Inactive";
    global $username;
    global $password;
    global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Customers SET type_of_business=? WHERE customer_id NOT IN ($customerIDs)");
	$stmt1->bind_param('s',$status);
 	$stmt1->execute(); 	
 	$stmt1->close();
}

function  insetBarcode($barcode,$itemID)
{
    global $username;
    global $password;
    global $database;
    $db2 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");
    $stmt2 = $db2->prepare("INSERT INTO Item_Barcode (item_id,barcode) VALUES(?,?)");
    $stmt2->bind_param('ss',$itemID,$barcode);
    $stmt2->execute();
    $stmt2->close();

}

function  insertUOM($uomID,$description,$active)
{
    global $username;
    global $password;
    global $database;
    $db2 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");
    $stmt2 = $db2->prepare("REPLACE INTO UOMs (uom_id,description,active) VALUES(?,?,?)");
    $stmt2->bind_param('iss',$uomID,$description,$active);
    $stmt2->execute();
    $stmt2->close();

}

function UOMExists($uomID,$uomDescription){
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(uom_id) FROM UOMs WHERE uom_id='$uomID' AND description='$uomDescription'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();

    return $z;

}

function  insertUOMGroup($uomgroupID,$description,$uomID,$multiplier)
{
    global $username;
    global $password;
    global $database;
    $db2 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");
    $stmt2 = $db2->prepare("REPLACE INTO ZG_Uom_Groups (uom_group_id,description,uom_id,multiplier) VALUES(?,?,?,?)");
    $stmt2->bind_param('isii',$uomgroupID,$description,$uomID,$multiplier);
    $stmt2->execute();
    $stmt2->close();

}

function  insertUOMItem($itemID,$uomID,$position,$multiplier)
{
    global $username;
    global $password;
    global $database;
    $db2 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");
    $stmt2 = $db2->prepare("REPLACE INTO UOM_Item (item_id, uom_id, position, multiplier, timestamp) VALUES(?,?,?,?,NOW())");
    $stmt2->bind_param('iiii',$itemID,$uomID,$position,$multiplier);
    $stmt2->execute();
    $stmt2->close();

}

function UOMItemExists($itemID,$uomID,$multiplier){
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(item_id) FROM UOM_Item WHERE item_id='$itemID' AND uom_id='$uomID' AND multiplier='$multiplier'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();

    return $z;

}

function getUOMMultiplier($uomgroupID,$uomID)
{
global $username;
global $password;
global $database;
	$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT multiplier FROM ZG_Uom_Groups WHERE uom_group_id='$uomgroupID' AND uom_id='$uomID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
				$z=$counter;	
	 }
	 $stm1->close();  
   
        return $z;
}

function UOMGroupExists($uomgroupID,$uomID,$multiplier){
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(uom_group_id) FROM ZG_Uom_Groups WHERE uom_group_id='$uomgroupID' AND uom_id='$uomID' AND multiplier='$multiplier'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();

    return $z;

}

function  insetBarcodeDefaultFlag($barcode,$itemID)
{
    global $username;
    global $password;
    global $database;
    $no=' ';
    $yes='yes';
    $db2 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    
    
    $stmt2 = $db2->prepare("SELECT item_id FROM Item_Barcode WHERE barcode=? AND NOT item_id=? LIMIT 1");
    $stmt2->bind_param('si',$barcode,$itemID);
    $stmt2-> execute();
    $stmt2-> bind_result($redundantItemID);
    while ($stmt2->fetch()) {
        
        $db3 = new mysqli('localhost',$username,$password,$database);
     	if (mysqli_connect_errno())
     	{
     	    printf("Connect failed: %s\n", mysqli_connect_error());
     	    exit();
     	}
     	$db3->set_charset("utf8");
     	$stmt3 = $db3->prepare("DELETE FROM Item_Barcode WHERE item_id=? AND barcode=?");
     	$stmt3->bind_param('is',$redundantItemID,$barcode);
     	$stmt3->execute();
     	$stmt3->close();
     	
        $deleteID = getNextID("Deletes", "delete_id");
        $statement ="DELETE FROM Item_Barcode WHERE item_id='$redundantItemID' AND barcode='$barcode'";
        $stmt3 = $db3->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
        $stmt3->bind_param('is',$deleteID,$statement);
        $stmt3->execute();
        $stmt3->close();
        
    }
    $stmt2->close();
    

    
    $db2->set_charset("utf8");
    $stmt2 = $db2->prepare("UPDATE Item_Barcode SET default_barcode=? WHERE item_id=?");
    $stmt2->bind_param('si',$no,$itemID);
    $stmt2->execute();
    $stmt2->close();
    
    $db2->set_charset("utf8");
    $stmt2 = $db2->prepare("UPDATE Item_Barcode SET default_barcode=? WHERE item_id=? AND barcode=?");
    $stmt2->bind_param('sis',$yes,$itemID,$barcode);
    $stmt2->execute();
    $stmt2->close();
    
    $db2->set_charset("utf8");
    $stmt2 = $db2->prepare("UPDATE Items SET item_sku=? WHERE item_id=?");
    $stmt2->bind_param('si',$barcode,$itemID);
    $stmt2->execute();
    $stmt2->close();

}

function  barcodeExists($barcode,$itemID)
{
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(item_id) FROM Item_Barcode WHERE item_id='$itemID' AND barcode='$barcode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();

    return $z;


}

function insertPrices($itemID,$priceTypeId,$price)
{
global $username;
global $password;
global $database;
    
	  $db1 = new mysqli(localhost,$username,$password,$database);
	  if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	          }
 	$db1->set_charset("utf8");
 	$stmt1 = $db1->prepare("INSERT INTO Prices(item_id,pricetype_id,price) VALUES(?,?,?) ON DUPLICATE KEY UPDATE price=?");
 	$stmt1->bind_param('iidd',$itemID,$priceTypeId,$price,$price);
 	$stmt1->execute();
     $stmt1->close();
  

}


function getItemID($itemCode)
{
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT item_id FROM Items WHERE item_code='$itemCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
				$z=$counter;	
	 }
	 $stm1->close();  
   
        return $z;
}

function getSupplierID($customerCode) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_id FROM Suppliers WHERE customer_code=? LIMIT 1");
	$stm1->bind_param('s',$customerCode);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}


function getCustomerID($customerCode) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_id FROM Customers WHERE customer_code=? LIMIT 1");
	$stm1->bind_param('s',$customerCode);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function getCompanyID($companyCode) {
global $username;
global $password;
global $database;
	$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT company_id FROM Companies WHERE company_code=? LIMIT 1");
	$stm1->bind_param('s',$companyCode);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function getCustomFormCode($customFormID) {
global $username;
global $password;
global $database;
	$z='';
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT custom_form_code FROM ZA_Custom_Form_Definition WHERE custom_form_definition_id=? LIMIT 1");
	$stm1->bind_param('s',$customFormID);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function getCustomFieldID($customFieldName) {
global $username;
global $password;
global $database;
	$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT custom_field_id FROM ZA_Custom_Field_Definition WHERE custom_field_name=? LIMIT 1");
	$stm1->bind_param('s',$customFieldName);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function getCustomFormObjectID($linkedTable,$linkedTableID,$customFormID) {
global $username;
global $password;
global $database;
	$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT custom_form_object_id FROM  ZA_Custom_Form_Object,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Object.custom_form_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table=? AND linked_table_id=? AND ZA_Custom_Form_Object.custom_form_id=?");
	$stm1->bind_param('sii',$linkedTable,$linkedTableID,$customFormID);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function insertCustomFormObject($customFormID,$customFormCode,$linkedTableID)
{
    global $username;
    global $password;
    global $database;

	  $db = new mysqli(localhost,$username,$password,$database);
 	  if (mysqli_connect_errno()) 
      {
    	   printf("Connect failed: %s\n", mysqli_connect_error());
    	   exit();
	  }
	  $customFormObjectID = getNextID("ZA_Custom_Form_Object", "custom_form_object_id");
	  $db->set_charset("utf8");  
      $stmt3 = $db->prepare("INSERT INTO ZA_Custom_Form_Object (custom_form_object_id,custom_form_id,custom_form_code,linked_table_id,timestamp) VALUES(?,?,?,?,NOW())");
 	  $stmt3->bind_param('iisi',$customFormObjectID,$customFormID,$customFormCode,$linkedTableID);
 	  $stmt3->execute();
 	  $stmt3->close();
 	  
 	  return $customFormObjectID;
	
}

function getCustomFieldObjectID($customFieldID,$customFormObjectID) {
global $username;
global $password;
global $database;
	$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT custom_field_object_id FROM ZA_Custom_Field_Object WHERE custom_field_id=? AND custom_form_object_id=?");
	$stm1->bind_param('ii',$customFieldID,$customFormObjectID);
	
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function insertCustomFieldObject($customFieldID,$customFormObjectID,$customFieldValue) {
global $username;
global $password;
global $database;
	 $db = new mysqli(localhost,$username,$password,$database);
 	   if (mysqli_connect_errno()) 
    	{
    	   printf("Connect failed: %s\n", mysqli_connect_error());
    	   exit();
	  }
	  $customFieldObjectID = getNextID("ZA_Custom_Field_Object","custom_field_object_id");
	  $db->set_charset("utf8");  
      $stmt3 = $db->prepare("INSERT INTO ZA_Custom_Field_Object (custom_field_object_id,custom_field_id,custom_form_object_id,value,timestamp) VALUES(?,?,?,?,NOW())");
 	  $stmt3->bind_param('iiis', $customFieldObjectID, $customFieldID, $customFormObjectID, $customFieldValue);
 	  $stmt3->execute();
 	  $stmt3->close();
}

function updateCustomFieldObject($customFieldObjectID,$customFieldValue) {

    global $username;
    global $password;
    global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE ZA_Custom_Field_Object SET value= ? WHERE custom_field_object_id=?");
	$stmt1->bind_param('si',$customFieldValue,$customFieldObjectID);
 	$stmt1->execute(); 	
 	$stmt1->close();

}

function insertContractPrice($customerID,$itemID,$price,$discount=0)
{
global $username;
global $password;
global $database;


    
	    $db = new mysqli(localhost,$username,$password,$database);
 	   if (mysqli_connect_errno()) 
    	{
    	   printf("Connect failed: %s\n", mysqli_connect_error());
    	   exit();
	  }
	  $db->set_charset("utf8");  
     $stmt3 = $db->prepare("INSERT INTO ContractPrices (customer_id,item_id,price,percentage) VALUES(?,?,?,?) ON DUPLICATE KEY UPDATE price=?");
 	  $stmt3->bind_param('ssddd',$customerID,$itemID,$price,$discount,$price);
 	  $stmt3->execute();
 	  $stmt3->close();
	
}

function insertContractPriceHelper($customerID,$itemID,$price,$discount=0)
{
global $username;
global $password;
global $database;


    
	    $db = new mysqli(localhost,$username,$password,$database);
 	   if (mysqli_connect_errno()) 
    	{
    	   printf("Connect failed: %s\n", mysqli_connect_error());
    	   exit();
	  }
	  $db->set_charset("utf8");  
     $stmt3 = $db->prepare("INSERT INTO ContractPrices_HELPER (customer_id,item_id,price,percentage) VALUES(?,?,?,?) ON DUPLICATE KEY UPDATE price=?");
 	  $stmt3->bind_param('ssddd',$customerID,$itemID,$price,$discount,$price);
 	  $stmt3->execute();
 	  $stmt3->close();
	
}

function  deleteContractPricesHelper()
{
    global $username;
    global $password;
    global $database;
    
	$db1 = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
    	exit();
	}
    
    $db1->set_charset("utf8");  
    $stmt5 = $db1->prepare("DELETE FROM ContractPrices_HELPER WHERE 1=1");
    $stmt5->execute();
    $stmt5->close();

}

function removeContractPricesNotInHelper()
{
    global $username;
    global $password;
    global $database;

    $db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_id,item_id,min_qty FROM ContractPrices WHERE (customer_id,item_id,min_qty) NOT IN(SELECT customer_id,item_id,min_qty FROM ContractPrices_HELPER)");
	$stm1-> execute();
	$stm1-> bind_result($customerID,$itemID,$minQty);
	while ($stm1->fetch()) {
		
        $db2 = new mysqli(localhost,$username,$password,$database);
     	if (mysqli_connect_errno())
     	{
     	    printf("Connect failed: %s\n", mysqli_connect_error());
     	    exit();
     	}
     	$db2->set_charset("utf8");
     	$stmt2 = $db2->prepare("DELETE FROM ContractPrices WHERE customer_id=? AND item_id=? AND min_qty=?");
     	$stmt2->bind_param('iid',$customerID,$itemID,$minQty);
     	$stmt2->execute();
     	$stmt2->close();
     	
        $deleteID = getNextID("Deletes", "delete_id");
        $statement ="DELETE FROM ContractPrices WHERE customer_id=$customerID AND item_id=$itemID AND min_qty=$minQty";
        $stmt2 = $db2->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
        $stmt2->bind_param('is',$deleteID,$statement);
        $stmt2->execute();
        $stmt2->close();
		
	 }
	 $stm1->close();
	 
//      $resetFlag = '0000-00-00';
//      $stmt3 = $db->prepare("UPDATE ContractPrices SET valid_from=? WHERE NOT valid_from = ?");
//  	 $stmt3->bind_param('ss',$resetFlag,$flag);
//  	 $stmt3->execute();
//  	 $stmt3->close();


    

}

function warehouseExists($warehouseCode)
{
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(warehouse_id) FROM Warehouses WHERE warehouse_code='$warehouseCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();  
   
        return $z;


}


function updateWarehouse($warehouseCode,$warehouseName,$region)
{
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Warehouses SET name= ?, region= ? WHERE warehouse_code='$warehouseCode'");
	$stmt1->bind_param('ss',$warehouseName,$region);
 	$stmt1->execute(); 	
 	$stmt1->close();

 	return getWarehouseID($warehouseCode);

}


function insertWarehouse($warehouseCode,$warehouseName,$region) {

	global $username;
global $password;
global $database;
		$db2 = new mysqli(localhost,$username,$password,$database);
 		if (mysqli_connect_errno()) 
 		{
      		printf("Connect failed: %s\n", mysqli_connect_error());
    		  exit();
 		}
 		$db2->set_charset("utf8");
		$warehouseID = getNextID("Warehouses","warehouse_id");
		 $stmt2 = $db2->prepare("INSERT INTO Warehouses (warehouse_id,warehouse_code,name,region) VALUES(?,?,?,?)");
 		$stmt2->bind_param('isss',$warehouseID,$warehouseCode,$warehouseName,$region);
 		$stmt2->execute();
 		$stmt2->close();

 		return $warehouseID;
}



function getCategoryID($categoryCode){
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT category_id FROM Categories WHERE category_code='$categoryCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;


}

function getCategoryIDCustom($categoryCode,$description){
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT category_id FROM Categories WHERE category_code='$categoryCode' AND description='$description' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;


}



function insertItemToCategory($itemID,$categoryID)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
	 $db->set_charset("utf8");  
 	$stmt3 = $db->prepare("INSERT INTO Category_Item (category_id,item_id) VALUES(?,?)");
 	$stmt3->bind_param('ss',$categoryID,$itemID);
 	$stmt3->execute();
 	$stmt3->close();


}

function getWarehouseID($warehouseCode)
{
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT warehouse_id FROM Warehouses WHERE warehouse_code='$warehouseCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();  
   
        return $z;


}

function getWarehouseRegion($warehouseCode)
{
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT region FROM Warehouses WHERE warehouse_code='$warehouseCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();  
   
        return $z;


}

function stockExists($warehouseID,$itemID,$batchnumber)
{
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT warehouse_id FROM Stock WHERE warehouse_id='$warehouseID' AND item_id='$itemID' AND batch_number='$batchnumber' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();  
   
        return $z;


}


function insertStock($warehouseID,$itemID,$batchnumber,$available,$onOrder,$reserved,$delivered)
{
	global $username;
global $password;
global $database;

  
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
	
 	$stmt3 = $db->prepare("INSERT INTO Stock (warehouse_id,item_id,batch_number,available,reserved,delivered,on_order) VALUES(?,?,?,?,?,?,?) ON DUPLICATE KEY UPDATE available=?,reserved=?,on_order=?");
 	$stmt3->bind_param('iisddddddd',$warehouseID,$itemID,$batchnumber,$available,$reserved,$delivered,$onOrder,$available,$reserved,$onOrder);
 	$stmt3->execute();
 	$stmt3->close();
  




}


function getCustomerIDFromAddress($addressCode)
{
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_id FROM Customers WHERE address_code_eurosoft =? LIMIT 1");
	$stm1->bind_param('s',$addressCode);
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();  
   
        return $z;

}

function addressExists($addressCode)
{
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(customer_address_id) FROM CustomerAddress WHERE address_code='$addressCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();  
   
        return $z;


}

function supplierAddressExists($addressCode)
{
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(supplier_address_id) FROM SupplierAddress WHERE address_code='$addressCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();  
   
        return $z;


}

function insertSupplierAddress($customerID,$addressCode,$addressLine1=" ",$addressLine2=" ",$postcode=" ",$country=" ",$city=" ",$landline=" ",$primaryAddress=" ")
{
    global $username;
    global $password;
    global $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $addressID = getNextID("SupplierAddress","supplier_address_id");
    $stmt3 = $db->prepare("INSERT INTO SupplierAddress (supplier_address_id,address_code,supplier_id,country,city,address_line_1,address_line_2,postcode,landline,primary_address) VALUES(?,?,?,?,?,?,?,?,?,?)");
    $stmt3->bind_param('isisssssss',$addressID,$addressCode,$customerID,$country,$city,$addressLine1,$addressLine2,$postcode,$landline,$primaryAddress);
    $stmt3->execute();
    echo $stmt3->error;
    $stmt3->close();

    return $addressID;

}

function insertAddress($customerID,$addressCode,$addressLine1=" ",$addressLine2=" ",$postcode=" ",$country=" ",$city=" ",$landline=" ",$primaryAddress=" ")
{
    global $username;
    global $password;
    global $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $addressID = getNextID("CustomerAddress","customer_address_id");
    $stmt3 = $db->prepare("INSERT INTO CustomerAddress (customer_address_id,address_code,customer_id,country,city,address_line_1,address_line_2,postcode,landline,primary_address) VALUES(?,?,?,?,?,?,?,?,?,?)");
    $stmt3->bind_param('isisssssss',$addressID,$addressCode,$customerID,$country,$city,$addressLine1,$addressLine2,$postcode,$landline,$primaryAddress);
    $stmt3->execute();
    $stmt3->close();

    return $addressID;

}

function updateSupplierAddress($customerID,$addressCode,$addressLine1=" ",$addressLine2=" ",$postcode=" ",$country=" ",$city=" ",$landline=" ",$primaryAddress=" ")
{
    global $username;
    global $password;
    global $database;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stmt1 = $db1->prepare("UPDATE SupplierAddress SET supplier_id=?,country=?,city=?,address_line_1=?,address_line_2=?,postcode=?,landline=?,primary_address=? WHERE address_code='$addressCode'");
    $stmt1->bind_param('isssssss',$customerID,$country,$city,$addressLine1,$addressLine2,$postcode,$landline,$primaryAddress);
    $stmt1->execute();
    $stmt1->close();

    return getAddressID($addressCode);
}

function updateAddress($customerID,$addressCode,$addressLine1=" ",$addressLine2=" ",$postcode=" ",$country=" ",$city=" ",$landline=" ",$primaryAddress=" ")
{
    global $username;
    global $password;
    global $database;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stmt1 = $db1->prepare("UPDATE CustomerAddress SET customer_id=?,country=?,city=?,address_line_1=?,address_line_2=?,postcode=?,landline=?,primary_address=? WHERE address_code='$addressCode'");
    $stmt1->bind_param('isssssss',$customerID,$country,$city,$addressLine1,$addressLine2,$postcode,$landline,$primaryAddress);
    $stmt1->execute();
    $stmt1->close();

    return getAddressID($addressCode);
}


function setCustomerEmailWebste($customerID,$email,$website)
{
global $username;
global $password;
global $database;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Customers SET email= ?, website= ? WHERE customer_id='$customerID'");
	$stmt1->bind_param('ss',$email,$website);
 	$stmt1->execute(); 	
 	$stmt1->close();


}

function contactExists($customerID)
{
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(contact_person_id) FROM Contact_Person WHERE customer_id='$customerID'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();  
   
        return $z;

}

function getContactID($customerID) {
    global $username;
    global $password;
    global $database;
    $z="";
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT contact_person_id FROM Contact_Person WHERE customer_id=? LIMIT 1");
    $stm1->bind_param('s',$customerID);

    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {

        $z=$counter;

    }
    $stm1->close();


    return $z;
}

function insertContact($customer_id,$first_name=' ',$last_name=' ',$position=1,$landline=' ',$mobile=' ',$fax=' ',$email=' ',$notes=' ')
{
    global $username;
    global $password;
    global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
 	}
 	$db->set_charset("utf8");
    $contact_person_id = getNextID("Contact_Person","contact_person_id");
 	$stmt3 = $db->prepare("INSERT INTO Contact_Person (contact_person_id,first_name,last_name,position,landline,mobile,fax,email,customer_id,notes,timestamp ) VALUES(?,?,?,?,?,?,?,?,?,?,NOW())");
 	$stmt3->bind_param('isssssssis',$contact_person_id,$first_name,$last_name,$position,$landline,$mobile,$fax,$email,$customer_id,$notes);
 	$stmt3->execute();
 	$stmt3->close();

 	return $contact_person_id;
}

function updateContact($customerID,$first_name='',$last_name='',$position=1,$landline='',$mobile='',$fax='',$email='',$notes='')
{
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");
	$stmt1 = $db1->prepare("UPDATE Contact_Person SET first_name=?,last_name=?,position=?,landline=?,mobile=?,fax=?,email=?,notes=? WHERE customer_id='$customerID'");
	$stmt1->bind_param('ssssssss',$first_name,$last_name,$position,$landline,$mobile,$fax,$email,$notes);
 	$stmt1->execute(); 	
 	$stmt1->close();

 	return getContactID($customerID);
 	
 }

function groupExist($groupCode)
{
global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(group_id) FROM CustomerGroups WHERE group_code='$groupCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=true;
		}
	 }
	 $stm1->close();  
   
        return $z;
}

function insertGroup($groupCode,$groupName,$description)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
	 $groupID = getNextID("CustomerGroups","group_id");
	 
 	$db->set_charset("utf8");
 	$stmt3 = $db->prepare("INSERT INTO CustomerGroups (group_id,group_code,name,description) VALUES(?,?,?,?)");
 	$stmt3->bind_param('isss',$groupID,$groupCode,$groupName,$description);
 	$stmt3->execute();
 	$stmt3->close();

 	return $groupID;
}

function updateGroup($groupCode,$groupName,$description)
{
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");
	$stmt1 = $db1->prepare("UPDATE CustomerGroups SET name= ?, description=? WHERE group_code='$groupCode'");
	$stmt1->bind_param('ss',$groupName,$description);
 	$stmt1->execute(); 	
 	$stmt1->close();

 	return getGroupID($groupCode);
}


function insertPriceType($priceCode,$priceName)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
	 $db->set_charset("utf8");
    $priceTypeID = getNextID("PriceTypes","pricetype_id");
 	$stmt3 = $db->prepare("INSERT INTO PriceTypes (pricetype_id,price_code,name) VALUES(?,?,?)");
 	$stmt3->bind_param('iss',$priceTypeID,$priceCode,$priceName);
 	$stmt3->execute();
 	$stmt3->close();

 	return $priceTypeID;

}

function priceTypeExists($priceCode)
{
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(pricetype_id) FROM PriceTypes WHERE price_code='$priceCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();

    return $z;
}

function getPriceTypeID($priceCode) {
    global $username;
    global $password;
    global $database;
    $z=0;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT pricetype_id FROM PriceTypes WHERE price_code='$priceCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {

        $z=$counter;

    }
    $stm1->close();


    return $z;
}

function getCustomersFromPriceType($customerPriceTypeID){
    global $username;
    global $password;
    global $database;
    $z= array();
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT customer_id FROM Customer_Pricelist WHERE pricetype_id='$customerPriceTypeID'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {

        array_push($z,$counter);

    }
    $stm1->close();
    
    return $z;
}

function getCustomersFromGroup($customersGroupID){
    global $username;
    global $password;
    global $database;
    $z= array();
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT customer_id FROM Customer_CustomersGroup WHERE group_id='$customersGroupID'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {

        array_push($z,$counter);

    }
    $stm1->close();
    
    return $z;
}

function getCustomerPriceTypeID($customerID) {
    global $username;
    global $password;
    global $database;
    $z=0;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT pricetype_id FROM Customer_Pricelist WHERE customer_id='$customerID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {

        $z=$counter;

    }
    $stm1->close();


    return $z;
}

function customerChanged($customerCode,$customerName)
{
global $username;
global $password;
global $database;
	$z=true;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(customer_id) FROM Customers WHERE customer_code='$customerCode' AND customer_company_name='$customerName' ");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=false;
		}
	 }
	 $stm1->close();  
   
        return $z;




}

function addressChanged($addressCode,$addressLine1,$addressLine2)
{
//global $username;
//global $password;
//global $database;
	//$z=true;
  //  	$db1 = new mysqli(localhost,$username,$password,$database);
	//if (mysqli_connect_errno()) {
  //  		printf("Connect failed: %s\n", mysqli_connect_error());
   // 		exit();
	//}
 	//$db1->set_charset("utf8");

	//$stm1 = $db1->prepare("SELECT COUNT(customer_address_id) FROM CustomerAddress WHERE address_code='$addressCode' AND //address_line_1='$addressLine1' AND address_line_2 ='$addressLine2'");
	//$stm1-> execute();
	//$stm1-> bind_result($counter);
	//while ($stm1->fetch()) {
	//	if($counter>0)
	//	{
	//		$z=false;
	//	}
	// }
	// $stm1->close();  

$z = false;
   
        return $z;


}

function itemChanged($itemCode,$name='',$vatID='')
{
global $username;
global $password;
global $database;
	$z=true;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(item_id) FROM Items WHERE item_code='$itemCode' AND name ='$name'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{
			$z=false;
		}
	 }
	 $stm1->close();  
   
        return $z;




}


function getNextID($tableName,$idName)
{
global $username;
global $password;
global $database;
global $prefix;
$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$likeVar = $prefix."%";
	$stm1 = $db1->prepare("SELECT $idName FROM $tableName WHERE $idName LIKE '$likeVar' ORDER BY $idName DESC LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($nextID);
	while ($stm1->fetch()) {
		
			$z = substr($nextID,4,strlen($nextID));
			$z+=1;
			
		
	 }
	 $stm1->close();  
   
   
return $prefix.$z;
   
       


}

function insertBalance($customerCode,$balance)
{
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");
	$stmt1 = $db1->prepare("UPDATE Customers SET balance= ? WHERE customer_code='$customerCode'");
	$stmt1->bind_param('d',$balance);
 	$stmt1->execute(); 	
 	$stmt1->close();



}

function getSupplierAddressID($addressCode) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT supplier_address_id FROM SupplierAddress WHERE address_code=? LIMIT 1");
    $stm1->bind_param("s",$addressCode);
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function getAddressID($addressCode) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_address_id FROM CustomerAddress WHERE address_code=? LIMIT 1");
    $stm1->bind_param("s",$addressCode);
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}


function getSalespersonID($salespersonCode) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT salesperson_id FROM SalesPersons WHERE salesperson_code='$salespersonCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function insertInvoice($invoiceCode,$printCount,$invoiceDATE,$customerID,$billingAddressID,$deliveryAddressID,$warehouseID,$salespersonID,$invoiceType,$details,$dueDate,$subTotalInvo,$vatTotalInvo,$discountTotalInvo,$grandTotal,$timestamp)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
 	$db->set_charset("utf8");
	$companyID=1;
	$status ="Not Paid";
    $invoiceID = getNextID("Invoices","invoice_id");
    $stmt = $db->prepare("INSERT INTO Invoices(invoice_id,invoice_code,company_id,customer_id,salesperson_id,grand_total,invoice_address_id,delivery_address_id,print_count,invoice_date,details,invoice_type,due_date,status,subtotal,vat_amount,discount_amount,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 	$stmt->bind_param('isiiidiiisssssddd',$invoiceID,$invoiceCode,$companyID,$customerID,$salespersonID,$grandTotal,$billingAddressID,$deliveryAddressID,$printCount,$invoiceDATE,$details,$invoiceType,$dueDate,$status,$subTotalInvo,$vatTotalInvo,$discountTotalInvo);
 	$stmt->execute();
    $error = $stmt->error;
    $stmt->close();

    if(strcmp($error,'')!=0){
        return 0 ;
    } else {
        return $invoiceID ;
    }


}

function purchaseOrderExists($order_code)
{

global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(order_id) FROM Purchase_Orders WHERE order_code='$order_code'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
}

function insertPurchaseOrder($sha1,$order_code,$company_id,$customer_id,$salesperson_id,$paymenttype_id,$order_date,$subtotal,$grand_total,$vat_amount,$discount_amount,$print_count,$order_address_id,$delivery_address_id,$tender_id,$vat_i_or_e,$delivery_date,$deposit_amount,$details,$status,$currency_id,$global_discount_percentage,$delivery_method,$shipping_company,$tracking_number,$loading_date,$landing_date,$cbm_total,$cover_period_start,$cover_period_end)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
 	$db->set_charset("utf8");
 	$order_id = getNextID("Purchase_Orders","order_id");
 	$stmt = $db->prepare("INSERT INTO Purchase_Orders(order_id, order_code, company_id, customer_id, salesperson_id, paymenttype_id, order_date, subtotal, grand_total, vat_amount, discount_amount, print_count, order_address_id, delivery_address_id, tender_id, vat_i_or_e, delivery_date, deposit_amount, details, status, currency_id, global_discount_percentage, delivery_method, shipping_company, tracking_number, loading_date, landing_date, cbm_total, cover_period_start, cover_period_end, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 	$stmt->bind_param('isiiiisddddiiiissdssidsssssdss',$order_id,$order_code,$company_id,$customer_id,$salesperson_id,$paymenttype_id,$order_date,$subtotal,$grand_total,$vat_amount,$discount_amount,$print_count,$order_address_id,$delivery_address_id,$tender_id,$vat_i_or_e,$delivery_date,$deposit_amount,$details,$status,$currency_id,$global_discount_percentage,$delivery_method,$shipping_company,$tracking_number,$loading_date,$landing_date,$cbm_total,$cover_period_start,$cover_period_end);
 	$stmt->execute(); 	
 	$stmt->close();
 	$stmt3 = $db->prepare("INSERT INTO Purchase_Orders_Hash (order_id,hash) VALUES(?,?)");
 	$stmt3->bind_param('is',$order_id,$sha1);
 	$stmt3->execute();
 	echo $stmt3->error;
 	$stmt3->close();
 	return $order_id ;


}

function updatePurchaseOrder($sha1,$order_id,$order_code,$company_id,$customer_id,$salesperson_id,$paymenttype_id,$order_date,$subtotal,$grand_total,$vat_amount,$discount_amount,$print_count,$order_address_id,$delivery_address_id,$tender_id,$vat_i_or_e,$delivery_date,$deposit_amount,$details,$status,$currency_id,$global_discount_percentage,$delivery_method,$shipping_company,$tracking_number,$loading_date,$landing_date,$cbm_total,$cover_period_start,$cover_period_end)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
 	$db->set_charset("utf8");
	$companyID=1;
	$status ="Not Paid";
 	$stmt = $db->prepare("UPDATE Purchase_Orders SET company_id=?, customer_id=?, salesperson_id=?, paymenttype_id=?, order_date=?, subtotal=?, grand_total=?, vat_amount=?, discount_amount=?, print_count=?, order_address_id=?, delivery_address_id=?, tender_id=?, vat_i_or_e=?, delivery_date=?, deposit_amount=?, details=?, status=?, currency_id=?, global_discount_percentage=?, delivery_method=?, shipping_company=?, tracking_number=?, loading_date=?, landing_date=?, cbm_total=?, cover_period_start=?, cover_period_end=?, timestamp=NOW() WHERE order_code=?");
 	$stmt->bind_param('iiiisddddiiiissdssidsssssdsss',$company_id,$customer_id,$salesperson_id,$paymenttype_id,$order_date,$subtotal,$grand_total,$vat_amount,$discount_amount,$print_count,$order_address_id,$delivery_address_id,$tender_id,$vat_i_or_e,$delivery_date,$deposit_amount,$details,$status,$currency_id,$global_discount_percentage,$delivery_method,$shipping_company,$tracking_number,$loading_date,$landing_date,$cbm_total,$cover_period_start,$cover_period_end,$order_code);
 	$stmt->execute(); 	
 	$stmt->close();
 	$stmt3 = $db->prepare("INSERT INTO Purchase_Orders_Hash (order_id,hash) VALUES(?,?) ON DUPLICATE KEY UPDATE hash=?");
 	$stmt3->bind_param('iss',$order_id,$sha1,$sha1);
 	$stmt3->execute();
 	echo $stmt3->error;
 	$stmt3->close();
 	return $order_id ;


}

function insertPurchaseOrderLine($order_id,$item_id,$qty,$qty_delivered,$qty_invoiced,$unit_price,$line_discount,$global_discount,$line_discount_percentage,$vat_amount,$pricetype_id,$vat_id,$description,$delivery_date)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
 	$db->set_charset("utf8");

	

	$order_item_id = getNextID("Purchase_Order_Item","order_item_id");
 	$stmt = $db->prepare("INSERT INTO Purchase_Order_Item(order_item_id, order_id, item_id, qty, qty_delivered, qty_invoiced, unit_price, line_discount, global_discount, line_discount_percentage, vat_amount, pricetype_id, vat_id, description, delivery_date, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 	$stmt->bind_param('iiiddddddddiiss',$order_item_id,$order_id,$item_id,$qty,$qty_delivered,$qty_invoiced,$unit_price,$line_discount,$global_discount,$line_discount_percentage,$vat_amount,$pricetype_id,$vat_id,$description,$delivery_date);
 	$stmt->execute(); 
 	echo $stmt->error;
 	$stmt->close();
    
 	return $order_item_id ;



}

function removePurchaseOrderLines($order_id)
{
global $username;
global $password;
global $database;

    $db2 = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno())
 	{
 	    printf("Connect failed: %s\n", mysqli_connect_error());
 	    exit();
 	}
 	$db2->set_charset("utf8");
 	$stmt2 = $db2->prepare("DELETE FROM Purchase_Order_Item WHERE order_id=?");
 	$stmt2->bind_param('i',$order_id);
 	$stmt2->execute();
 	$stmt2->close();
 	
    $deleteID = getNextID("Deletes", "delete_id");
    $statement ="DELETE FROM Purchase_Order_Item WHERE order_id=$order_id";
    $stmt2 = $db2->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
    $stmt2->bind_param('is',$deleteID,$statement);
    $stmt2->execute();
    $stmt2->close();

}

function getPurchaseOrderID($order_code) 
{
global $username;
global $password;
global $database;
	$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT order_id FROM Purchase_Orders WHERE order_code='$order_code' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function getHashPurchaseOrder($orderID) {

global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli("p:".localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT hash FROM Purchase_Orders_Hash WHERE order_id='$orderID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($hash);
	while ($stm1->fetch()) {
	
	 }
	 $stm1->close();
   
   
    return $hash;
}

function insertLine($invoiceID,$itemID,$qty,$lineTotal,$lineDiscount,$globalDiscount,$vatTotal,$description,$priceCode,$warehouseID,$unitPrice,$vatID,$timestamp)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
 	$db->set_charset("utf8");
	$companyID=1;
	$status ="Not Paid";
	
    if(strcmp($itemID,'') != 0)
    {
	$invoiceItemID = getNextID("Invoice_Item","invoice_item_id");
	$batch="0";
	if($unitPrice==0)
	{
		$unitPrice = $lineTotal/$qty;
	}
 	$stmt = $db->prepare("INSERT INTO Invoice_Item(invoice_item_id,invoice_id,item_id,batch_number,warehouse_id,qty,unit_price,line_discount,global_discount,vat_amount,description,vat_id,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 	$stmt->bind_param('iiisidddddsi',$invoiceItemID,$invoiceID,$itemID,$batch,$warehouseID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$vatTotal,$description,$vatID);
 	$stmt->execute(); 	
 	$stmt->close();
    }
 	return $invoiceID ;



}


function getPrice($priceCode,$itemID) {
global $username;
global $password;
global $database;
	$z=0;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT price FROM Prices WHERE pricetype_id='$priceCode' AND item_id='$itemID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function invoiceExists($invoiceCode) {

global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(invoice_id) FROM Invoices WHERE invoice_code='$invoiceCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
}



function accountExists($accountCode) {

global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(account_id) FROM ChartOfAccounts WHERE account_code='$accountCode'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
}

function upadateAccount($accountCode,$accountName,$type) {
global $username;
global $password;
global $database;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE ChartOfAccounts SET account_code = ?, account_name = ?,type_id= ? WHERE account_code='$accountCode'");
	$stmt1->bind_param('sss',$accountCode,$accountName,$type);
 	$stmt1->execute(); 	
 	$stmt1->close();
   
   
    return getAccountID($accountCode);
}


function insertAccount($accountCode,$accountName,$type) {
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db->set_charset("utf8");
	 $accountID = getNextID("ChartOfAccounts","account_id");
 	$stmt = $db->prepare("INSERT INTO ChartOfAccounts (account_id,account_code,account_name,type_id,timestamp) VALUES(?,?,?,?,NOW())");
	$stmt->bind_param('isss',$accountID,$accountCode,$accountName,$type);
 	$stmt->execute();
 	$stmt->close();
   
   
    return $accountID;
}
function journalExists($journalCode,$year,$period){

global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(journal_id) FROM Journals WHERE journal_code='$journalCode' AND year='$year' AND period_id='$period'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;


}

function insertJournal($journalCode,$year,$period){
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db->set_charset("utf8");
	 $journalID = getNextID("Journals","journal_id");
 	$stmt = $db->prepare("INSERT INTO Journals (journal_id,journal_code,year,period_id,timestamp) VALUES(?,?,?,?,NOW())");
	$stmt->bind_param('isss',$journalID,$journalCode,$year,$period);
 	$stmt->execute();
 	$stmt->close();
   
   
    return $journalID;
}
	
function insertTransaction($journalID,$accountID,$transactionDate,$reference,$amount,$sign,$details,$unallocateAmount,$year,$period)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db->set_charset("utf8");
	 $transactionID = getNextID("Transactions","transaction_id");
 	$stmt = $db->prepare("INSERT INTO Transactions (transaction_id,journal_id,account_id,transaction_date,action_code,amount,sign,details,outstanding_amount,year,period_id,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW())");
	$stmt->bind_param('iiissddsdii',$transactionID,$journalID,$accountID,$transactionDate,$reference,$amount,$sign,$details,$unallocateAmount,$year,$period);
 	$stmt->execute();
 	$stmt->close();
   
   
    return $journalID;
}


function getAccountID($accountCode) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT account_id FROM ChartOfAccounts WHERE account_code='$accountCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function getAccountType($accountCode) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT type_id FROM ChartOfAccounts WHERE account_code='$accountCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}
function insertCustomerPriceList($customerID,$priceTypeID)
{
global $username;
global $password;
global $database;
              $db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db->set_charset("utf8");
	 
	$stm1 = $db->prepare("SELECT pricetype_id FROM Customer_Pricelist WHERE customer_id='$customerID' AND NOT pricetype_id='$priceTypeID'");
	$stm1-> execute();
	$stm1-> bind_result($oldPriceType);
	while ($stm1->fetch()) {}
	$stm1->close();
	
	if($oldPriceType > 0 && $priceTypeID != $oldPriceType){
        $stmt5 = $db->prepare("DELETE FROM Customer_Pricelist WHERE customer_id=? ");
        $stmt5->bind_param('i',$customerID);
        $stmt5->execute();
        $stmt5->close(); 

        $deleteID = getNextID("Deletes", "delete_id");
        $statement ="DELETE FROM Customer_Pricelist WHERE customer_id=$customerID";
        $stmt2 = $db->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
        $stmt2->bind_param('is',$deleteID,$statement);
        $stmt2->execute();
        $stmt2->close();	    
	}
	
 	$stmt = $db->prepare("INSERT INTO Customer_Pricelist (customer_id,pricetype_id,timestamp) VALUES(?,?,NOW())");
	$stmt->bind_param('ii',$customerID,$priceTypeID);
 	$stmt->execute();
 	$stmt->close();

}
function updateItemflag($itemCode,$status)
{
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Items SET status= ? WHERE item_code='$itemCode'");
	$stmt1->bind_param('s',$status);
 	$stmt1->execute(); 	
 	$stmt1->close();
 	

}

function insertCustomerToGroupG2u($g,$customerID){
global $username;
global $password;
global $database;
   	

        
        $groupIDold = getGroupIDOFCustomer($customerID);
        $db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");
        

	$stm1 = $db1->prepare("SELECT group_id FROM CustomerGroups WHERE group_code='$g' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($groupID);
	while ($stm1->fetch()) {
                if(strcmp($groupIDold,$groupID)!=0)
                {
		$db2 = new mysqli(localhost,$username,$password,$database);
 		if (mysqli_connect_errno()) 
 		{
      		printf("Connect failed: %s\n", mysqli_connect_error());
    		  exit();
 		}
 		$db2->set_charset("utf8");

                $stmt5 = $db2->prepare("DELETE FROM Customer_CustomersGroup WHERE customer_id=? AND group_id=?");
                $stmt5->bind_param('ii',$customerID,$groupIDold);
                $stmt5->execute();
                $stmt5->close(); 

                $deleteID = getNextID("Deletes", "delete_id");
                $statement ="DELETE FROM Customer_CustomersGroup WHERE customer_id=$customerID AND group_id=$groupIDold";
                $stmt2 = $db2->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
                $stmt2->bind_param('is',$deleteID,$statement);
                $stmt2->execute();
                $stmt2->close();


               
		  $stmt2 = $db2->prepare("INSERT INTO Customer_CustomersGroup (group_id,customer_id,added_date,timestamp) VALUES(?,?,CURDATE(),NOW())");
 		  $stmt2->bind_param('ss',$groupID,$customerID);
 		  $stmt2->execute();
 		  $stmt2->close();
                }
	 }
	 $stm1->close();
}

function getGroupID($groupCode){
    global $username;
    global $password;
    global $database;


    $groupID=0;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");


    $stm1 = $db1->prepare("SELECT group_id FROM CustomerGroups WHERE group_code = '$groupCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($groupID);
    while ($stm1->fetch()) {

    }
    $stm1->close();
    return $groupID;

}


function getGroupIDOFCustomer($customerID){
global $username;
global $password;
global $database; 	

        
       $groupID=0;
        $db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");
        

	$stm1 = $db1->prepare("SELECT CustomerGroups.group_id FROM CustomerGroups,Customer_CustomersGroup WHERE group_code LIKE 'G2%' AND CustomerGroups.group_id=Customer_CustomersGroup.group_id AND customer_id='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($groupID);
	while ($stm1->fetch()) {
		
	 }
	 $stm1->close();
      return $groupID;

}


function updateItemLongDescription($itemID,$longDescription)
{
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Items SET long_description= ? WHERE item_id='$itemID'");
	$stmt1->bind_param('s',$longDescription);
 	$stmt1->execute(); 	
 	$stmt1->close();
 	

}


function  insertShortage($osiID,$shipDate,$itemID,$itemText,$qtyCancelled,$salesUnitCancelled,$status,$expectedQty,$expectedSalesUnit,$expectedDate,$ostCode)
{

global $username;
global $password;
global $database;
              $db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db->set_charset("utf8");
	
 	$stmt = $db->prepare("INSERT INTO Shortage (osi_id,ship_date,item_id,item_text,qty_cancelled,salesunits_cancelled,status,expected_qty,salesunits_expected,expected_date,ost_code,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW())");
	$stmt->bind_param('isisdssdsss',$osiID,$shipDate,$itemID,$itemText,$qtyCancelled,$salesUnitCancelled,$status,$expectedQty,$expectedSalesUnit,$expectedDate,$ostCode);
 	$stmt->execute();
 	$stmt->close();




}

function getSerialNumber($serialNumber) {
global $username;
global $password;
global $database;
	$z="";
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT serial_number_id FROM Serial_Numbers WHERE serial_number='$serialNumber' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		
			$z=$counter;
		
	 }
	 $stm1->close();
   
   
    return $z;
}

function serialNumberExists($serialNumber) {

global $username;
global $password;
global $database;
	$z=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(serial_number_id) FROM Serial_Numbers WHERE serial_number='$serialNumber'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		if($counter>0)
		{		
			$z=true;
		}
	 }
	 $stm1->close();
   
   
    return $z;
}



function insertSerialNumber($serialNumber,$itemID)
{
global $username;
global $password;
global $database;
	$db = new mysqli(localhost,$username,$password,$database);
 	if (mysqli_connect_errno()) 
 	{
    	  printf("Connect failed: %s\n", mysqli_connect_error());
    	  exit();
	 }
 	$db->set_charset("utf8");
	$serialNumberID = getNextID("Serial_Numbers","serial_number_id");
 	$stmt = $db->prepare("INSERT INTO Serial_Numbers(serial_number_id,serial_number,item_id,timestamp) VALUES(?,?,?,NOW())");
 	$stmt->bind_param('isi',$serialNumberID,$serialNumber,$itemID);
 	$stmt->execute(); 	
 	$stmt->close();
 	return $serialNumberID;
}


function updateCustomerMobile($customerID,$mobile)
{
    
    global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Customers SET mobile= ? WHERE customer_id='$customerID'");
	$stmt1->bind_param('s',$mobile);
 	$stmt1->execute(); 	
 	$stmt1->close();
}



function insertCustomerToTown($groupID,$customerID){
global $username;
global $password;
global $database;
   
		$db2 = new mysqli(localhost,$username,$password,$database);
 		if (mysqli_connect_errno()) 
 		{
      		printf("Connect failed: %s\n", mysqli_connect_error());
    		  exit();
 		}
 		$db2->set_charset("utf8");
		 $stmt2 = $db2->prepare("INSERT INTO Customer_CustomersGroup (group_id,customer_id,added_date,timestamp) VALUES(?,?,CURDATE(),NOW())");
 		$stmt2->bind_param('ss',$groupID,$customerID);
 		$stmt2->execute();
 		$stmt2->close();
	 
}

function getCategoryIDCustomForLevel2($categoryCode,$description){
global $username;
global $password;
global $database;
	$z=array();
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT category_id FROM Categories WHERE category_code LIKE'%$categoryCode' AND description='$description'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		   array_push($z,$counter);
		
		
	 }
	 $stm1->close();
   
   
    return $z;


}

function updateCategoryNameCustomLevel2($categoryID,$catName){
global $username;
global $password;
global $database;
	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Categories SET name=? WHERE category_id='$categoryID'");
	$stmt1->bind_param('s',$catName);
 	$stmt1->execute(); 	
 	$stmt1->close();

//  	return getCategoryID($categoryCode);
}
function insertBarcodesExported($id,$type,$status,$reason){
    global $username;
    global $password;
    global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
 	$stmt = $db->prepare("INSERT IGNORE INTO Item_Barcode_Exported (item_id,barcode,status,reason,timestamp) VALUES(?,?,?,?,NOW())");
	$stmt->bind_param('isis',$id,$type,$status,$reason);
 	$stmt->execute(); 	
 	$stmt->close();
}

function insertSupplierContractPrice($customerID,$itemID,$price)
{
global $username;
global $password;
global $database;


    
	    $db = new mysqli(localhost,$username,$password,$database);
 	   if (mysqli_connect_errno()) 
    	{
    	   printf("Connect failed: %s\n", mysqli_connect_error());
    	   exit();
	  }
	  $db->set_charset("utf8");  
     $stmt3 = $db->prepare("INSERT INTO Item_Supplier (supplier_id,item_id,price) VALUES(?,?,?) ON DUPLICATE KEY UPDATE price=?");
 	  $stmt3->bind_param('ssdd',$customerID,$itemID,$price,$price);
 	  $stmt3->execute();
 	  $stmt3->close();
	
}

function paymentTermExits($paymentTermCode)
{
    global $username;
    global $password;
    global $database;
    $z=false;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(payment_term_id) FROM Payment_Terms WHERE payment_term_code='$paymentTermCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $z=true;
        }
    }
    $stm1->close();
    return $z;
}

function insertPaymentTerm($payment_term_code,$payment_term_text,$payment_term_days)
{
    global $username;
    global $password;
    global $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stmt3 = $db->prepare("INSERT INTO Payment_Terms (payment_term_code,payment_term_text,payment_terms_days,timestamp ) VALUES(?,?,?,NOW())");
    $stmt3->bind_param('ssi',$payment_term_code,$payment_term_text,$payment_term_days);
    $stmt3->execute();
    $stmt3->close();

    return $payment_term_code;
}

function getPaymentTermID($payment_term_code) {
    global $username;
    global $password;
    global $database;
    $z=0;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT payment_term_id FROM Payment_Terms WHERE payment_term_code='$payment_term_code' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();
    return $z;
}

function updatePaymentTerm($paymentTermID,$payment_term_code,$payment_term_text,$payment_term_days)
{
    global $username;
    global $password;
    global $database;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stmt1 = $db1->prepare("UPDATE Payment_Terms SET payment_term_code=?,payment_term_text=?,payment_terms_days=? WHERE payment_term_id='$paymentTermID'");
    $stmt1->bind_param('sss',$payment_term_code,$payment_term_text,$payment_term_days);
    $stmt1->execute();
    $stmt1->close();

    return $paymentTermID;

}
?>