<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

require_once('../../ConnectionAuth.php');
require_once('../../../concc/dbinfo.php');
require_once('../../InterfaceLogger.php');
require_once('../../InterfaceSettingsHandler.php');
require_once('../../../backend/core/model/Database.php');

foreach(glob(basename(__DIR__).'*.php') as $file) {
    if(file_exists("./custom/$file")){
        require_once("./custom/$file");
    } else {
        require_once("$file");
    }
}

require_once('../BasicAuthClient.php');

$auth   = new ConnectionAuth($_GET,$_POST);
$db     = $auth->connect(basename(__DIR__));
$cData  = $auth->getErpConnectionData('PRIORITY_REST_API');
$cLog   = $auth->getConnectionLog();

$client = new BasicAuthClient($cData,$cLog);

if(!$db){return;}
if(!$cData){return;}
if(!$auth->callSpecificFunctions($db, $client)){return;}


// outboundOrders($db, $client);
// outboundTenders($db, $client);
// outboundReturns($db, $client);
// outboundReceipts($db, $client);
// outboundWarehouseTransactions($db, $client);


function includeCustomFunctionFile($function,$directoryFolder){
    $functionToInclude = false;
    if(file_exists("../$directoryFolder/$function.php")) {
        $functionToInclude= "../$directoryFolder/$function.php";
    } else if (file_exists("../../$directoryFolder/$function.php")) {
        $functionToInclude= "../$directoryFolder/$function.php";
    } else {
        echo "<b>Custom Function File Does Not Exist: $directoryFolder/$function </b><br>";
        $functionToInclude = false;
    }

    return $functionToInclude;
}
?>