<?php
require_once('../BasicAuthClient.php');
require_once('../../../backend/core/model/Database.php');

require_once('../../../backend/core/model/Invoice.php');
require_once('../../../backend/core/model/Item.php');
require_once('../../../backend/core/model/InvoiceItem.php');
require_once('../../../backend/core/model/PaymentType.php');
require_once('../../../backend/core/model/DocumentStatus.php');

function inboundInvoices($db, $client)
{

    $filter = '?$filter=STATDES eq \'Final\'';
    $filter.= '&$expand=AINVOICEITEMS_SUBFORM';
    $filter.= '&$since='.$client->getDateFilter().'T00:00:00%2B02:00';
    $filter = str_replace(' ','%20', $filter);

    $response = $client->requestData('AINVOICES'.$filter);

    foreach ($response->value as $data) {

        if($db->checkExist('Documents_Status',array('type'=>$db->getDocumentStatusTypeByTable('Invoices'),'export_code'=>$data->IVNUM)))  {

            $existingID   = $db->getData()->id;
            $existingCode = $db->getInvoiceObjectByID($existingID,false)->invoiceCode;
            $client->log(array('Documents_Status'=>"[".date('Y-m-d H:i:s')."] Invoice Exists (Coprime Invoice Code: $existingCode ).\n"));
            continue;

        }

        $customerID    = $db->getCustomerObjectByCode("$data->CUSTNAME")->customerID;
        $paymentTypeID = $db->getPaymentTypeObjectByCode("$data->PAYCODE")->paymentTypeID;
        $warehouseID   = $db->getWarehouseObjectByCode("$data->WARHSNAME")->warehouseID;
        $salespersonID = $db->getSalesPersonIDByCode("$data->AGENTCODE");

        $discountPrice = (float)$data->QPRICE - (float)$data->DISPRICE;

        $invoice = new Invoice(
            $invoiceID          = "",
            $invoiceCode        = "$data->IVNUM",
            $companyID          = "1",
            $customerID         = "$customerID",
            $salespersonID      = "$salespersonID",
            $paymentTypeID      = "$paymentTypeID",
            $orderID            = "0",
            $tenderID           = "0",
            $subTotal           = "$data->QPRICE",
            $grandTotal         = "$data->TOTPRICE",
            $vatAmount          = "$data->VAT",
            $vatIorE            = "",
            $discountAmount     = "$discountPrice",
            $invoiceAddressID   = "0",
            $deliveryAddressID  = "0",
            $printCount         = "0",
            $invoiceDate        = "$data->IVDATE",
            $details            = "$data->DETAILS",
            $invoiceType        = "Credit",
            $dueDate            = "$data->IVDATE",
            $status             = "$data->STATDES",
            $currencyID         = "0",
            $globalDiscPercent  = "$data->PERCENT",
            $actionHash         = "",
            $actionTime         = "",
            $invoiceItems       = array()
        );


        foreach ($data->AINVOICEITEMS_SUBFORM as $dataItem) {

            $item = $db->getItemObjectByCode("$dataItem->PARTNAME");

            $vatID             = $item->vatID;
            $itemID            = $item->itemID;
            $itemSubunits      = $item->subunits;
            $vatPrice          = (float)$dataItem->VPRICE - (float)$dataItem->PRICE;
            $lineDiscountPrice = (float)$dataItem->TQUANT * ((float)$dataItem->PRICE - (float)$dataItem->DISPRICE);
            $unitPrice         = (float)$dataItem->PRICE * (float)$itemSubunits;

            $invoice->addInvoiceItem(
                new InvoiceItem(
                    $invoiceItemID          = "",
                    $invoiceID              = "",
                    $itemID                 = "$itemID",
                    $batchNumber            = "0",
                    $warehouseID            = "$warehouseID",
                    $qty                    = "$dataItem->TQUANT",
                    $unitPrice              = "$unitPrice",
                    $lineDiscount           = "$lineDiscountPrice",
                    $globalDiscount         = "",
                    $lineDiscountPercentage = "$dataItem->PERCENT",
                    $vatAmount              = "$vatPrice",
                    $priceTypeID            = "0",
                    $vatID                  = "$vatID",
                    $serialNumber           = "",
                    $description            = "$dataItem->PDES",
                    $cost                   = "",
                    $promotionID            = "",
                    $promotionNumber        = "",
                    $masterItem             = ""
                )
            );
        }

        $invoice->setActionHash($db->hashObject($invoice));
        $invoice->setActionTime(date('Y-m-d H:i:s'));


        $excludeUpdateColumns=array(
            'Invoices' => array('print_count','order_id','tender_id','action_time')
        );

        $deleteRecordsNotSent=array(

        );

        $invoice = inboundInvoicesAfterObjectCreationBeforeDbInsert($data,$invoice);

        $client->log($db->insertUpdateInvoiceByObject($invoice,$excludeUpdateColumns,$deleteRecordsNotSent));

        $documentStatus = new DocumentStatus(
            $id         = $db->getInvoiceObjectByCode($data->IVNUM,false)->invoiceID,
            $table      = $db->getDocumentStatusTypeByTable("Invoices"),
            $status     = 100,
            $reason     = 'Imported From ERP',
            $exportID   = 100,
            $exportCode = $data->IVNUM
        );

        $client->log($db->insertUpdateDocumentStatusByObject($documentStatus));
    }
    $client->complete();
}

/**
 * custom Functions
 */

function inboundInvoicesAfterObjectCreationBeforeDbInsert($data,$invoice){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $invoice;
}

?>