<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

//$_POST['customerCode']='CN00848';
//$_POST['customerID']='10001';
//$_POST['username']='coprime';
//$_POST['password']='123';
//$_POST['type']='inbound';

getCustomerContractPricesAPI($_POST['customerID'],$_POST['customerCode'],$_POST['username'],$_POST['password'],$_POST['type']);

function getCustomerContractPricesAPI($postCustomerID,$customerCode,$conAuthUsername,$conAuthPassword,$conAuthType)
{

    ob_start();
    require_once('../../ConnectionAuth.php');
    require_once('../../../concc/dbinfo.php');
    require_once('../../InterfaceLogger.php');
    require_once('../../InterfaceSettingsHandler.php');
    require_once('../../../backend/core/model/Database.php');
    require_once('../../../backend/core/model/Item.php');
    require_once('../../../backend/core/model/Customer.php');
    require_once('../../../backend/core/model/PriceType.php');
    require_once('../../../backend/core/model/ContractPrice.php');
    require_once('../BasicAuthClient.php');

    $_GET['username'] = $conAuthUsername;
    $_GET['password'] = $conAuthPassword;
    $_GET['type']     = $conAuthType;

    $auth = new ConnectionAuth($_GET, $_POST);
    $db = $auth->connect(basename(__DIR__));
    $cData = $auth->getErpConnectionData('PRIORITY_REST_API');
    $cLog = $auth->getConnectionLog();
    $client = new BasicAuthClient($cData, $cLog);

    if (!$db) {return;}
    if (!$cData) {return;}

    $hasPrices  = false;


    // -----------------------------------------------------------------------------------

    $urlFilters   = 'CUSTPARTPRICEONE?$filter=CUSTNAME eq \''.$customerCode.'\'';
    $urlFilters   = str_replace(' ', '%20', $urlFilters);
    $dataResponse = $client->requestData($urlFilters,true)->value;

    if(is_array($dataResponse) && count($dataResponse) > 0){

        $db->delete('ContractPrices', 'customer_id', $postCustomerID);
//        $db->displayObject("delete('ContractPrices', 'customer_id', $postCustomerID)");

        $priceTypeObject = $db->getDefaultPriceTypeObject();

        foreach ($dataResponse as $data){

            $itemObject = $db->getItemObjectByCode("$data->PARTNAME");
            $fromDate   = substr("$data->FROMDATE",0,10);
            $toDate     = substr("$data->EXPIRYDATE",0,10);

            $contractPrice = new ContractPrice(
                $customerID   = "$postCustomerID",
                $itemID       = "$itemObject->itemID",
                $priceTypeID  = "$priceTypeObject->priceTypeID",
                $price        = (float)$data->PRICE * (float)$itemObject->subunits,
                $percentage   = "0",
                $minQty       = "0",
                $validFrom    = "$fromDate",
                $validUntil   = "$toDate"
            );

            $excludeUpdateColumns = array('ContractPrices' => array());
            $deleteRecordsNotSent = array();

            if($itemObject->itemID > 0 && $postCustomerID > 0) {
                $hasPrices       = true;
                $client->log($db->insertUpdateContractPriceByObject($contractPrice,$excludeUpdateColumns,$deleteRecordsNotSent));
//                $db->displayObject($contractPrice);
            }


        }


    }
    $client->complete();

    // -----------------------------------------------------------------------------------

    $urlFilters   = 'CUSTPARTDISCONE?$filter=CUSTNAME eq \''.$customerCode.'\'';
    $urlFilters   = str_replace(' ', '%20', $urlFilters);
    $dataResponse = $client->requestData($urlFilters,true)->value;

    if(is_array($dataResponse) && count($dataResponse) > 0){

        if(!$hasPrices){
            $db->delete('ContractPrices', 'customer_id', $postCustomerID);
        }

        $priceTypeObject = $db->getDefaultPriceTypeObject();

        foreach ($dataResponse as $data){
            echo "$data->PARTNAME<br>";
            $itemObject      = $db->getItemObjectByCode("$data->PARTNAME");
            $itemPrice       = $db->getItemPriceFromPriceType($itemObject->itemID,$priceTypeObject->priceTypeID);


            $fromDate = substr("$data->FROMDATE",0,10);
            $toDate   = substr("$data->EXPIRYDATE",0,10);
            $discPrice = round($itemPrice-$itemPrice*($data->PERCENT/100),4);


            $contractPrice = new ContractPrice(
                $customerID   = "$postCustomerID",
                $itemID       = "$itemObject->itemID",
                $priceTypeID  = "$priceTypeObject->priceTypeID",
                $price        = "$discPrice",
                $percentage   = "$data->PERCENT",
                $minQty       = "0",
                $validFrom    = "$fromDate",
                $validUntil   = "$toDate"
            );

            $excludeUpdateColumns = array('ContractPrices' => array());
            $deleteRecordsNotSent = array();
            if($itemObject->itemID > 0 && $postCustomerID > 0) {
                $hasPrices       = true;
                $client->log($db->insertUpdateContractPriceByObject($contractPrice,$excludeUpdateColumns,$deleteRecordsNotSent));
//                $db->displayObject($contractPrice);
            }



        }


    }
    $client->complete();




    ob_end_clean();

    if($hasPrices){
        echo "$postCustomerID";
    }




}
?>