<?php
class AuthTokenClient{

    private $ipRest;
    private $portRest;
    private $usernameRest;
    private $passwordRest;
    private $response;

    private $daysBack;
    private $companyCode;
    private $log;
    private $erpImportID;
    private $erpImportLog;
    private $erpErrorEmail;
    private $db;
    private $authToken;


    public function getCompanyCode()
    {
        return $this->companyCode;
    }


    public function setCompanyCode($companyCode)
    {
        $this->companyCode = $companyCode;
    }


    public function getToken()
    {
        return $this->authToken;
    }

    public function getErpErrorEmail()
    {
        return $this->erpErrorEmail;
    }

    public function getDaysBack()
    {
        return $this->daysBack;
    }

    public function setDaysBack($daysBack)
    {
        $this->daysBack = $daysBack;
        return $this;
    }

    public function getDateFilter()
    {
        $daysBack = (int)$this->daysBack;
        if($daysBack > 0){
            $dateFilter = date('Y-m-d',strtotime(date('Y-m-d') . "-$daysBack days"));
        } else {
            $dateFilter = date('Y-m-d');
        }

        return $dateFilter;
    }

    public function __construct($cData,$cLog)
    {
        InterfaceLogger::start();
        if($cData !== false) {
            $this->ipRest = $cData->erp_host;
            $this->portRest = $cData->erp_port;
            $this->usernameRest = $cData->erp_username;
            $this->passwordRest = $cData->erp_identifier;
            $this->erpImportID = $cData->erp_import_id;
            $this->companyCode = $cData->erp_database;
            $this->daysBack = $cData->daysBack;
            $this->erpErrorEmail = $cData->erp_error_mail;
            $this->db = $cData->db;

            $error = false;
            if(strcmp($this->ipRest,'')==0){$error = true;InterfaceLogger::log("[".date('Y-m-d H:i:s')."] NOTICE : IP Not Provided\n","connection","ERP Connection");}
            if(strcmp($this->usernameRest,'')==0){$error = true;InterfaceLogger::log("[".date('Y-m-d H:i:s')."] NOTICE : Username Not Provided\n","connection","ERP Connection");}
            if(strcmp($this->passwordRest,'')==0){$error = true;InterfaceLogger::log("[".date('Y-m-d H:i:s')."] NOTICE : Password Not Provided\n","connection","ERP Connection");}

            if(!$error){
                $this->requestAuthToken();
            }

        } else {
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] NOTICE : $cLog\n","connection","ERP Connection");
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] NOTICE : $cLog\n","analytic","ERP Connection");
        }
    }

    function requestAuthToken(){

        try {
            $portDelimiter = '';
            if(strcmp(trim($this->portRest),"")!=0){$portDelimiter = ":";}
            $this->log = "[".date('Y-m-d H:i:s')."] Request: ".$this->ipRest.$portDelimiter.$this->portRest."/api/token\n";
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] Request: $this->ipRest:$this->portRest/api/token\n","analytic","token");


            $this->erpImportLog = new ErpImport("token", "", '', '0', '0', '0', "", "", "", "");
            $this->db->resetAffectedRecords();
            $this->erpImportLog->start($this->db, "$this->log", "$this->erpImportID");


            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => "http://".$this->ipRest.$portDelimiter.$this->portRest."/api/token",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => "username=$this->usernameRest&password=$this->passwordRest&grant_type=password",
                CURLOPT_HTTPHEADER => array(
                    "Content-Type: application/x-www-form-urlencoded"
                ),
            ));

            $response = curl_exec($curl);
            curl_close($curl);

            $this->response = $response;
            $this->log .= "[".str_replace('/','_','token')."] [".date('Y-m-d H:i:s')."] Response: ".substr(trim(preg_replace('/\s\s+/', ' ', $response)),0,150)." \n";
            InterfaceLogger::log($this->log,"connection","token");
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] Response: $response\n","analytic","token");

            $response=json_decode($response);
            $this->authToken = $response->access_token;
            $this->complete();
            return $response->access_token;

        } catch(Exception $e) {
            $this->response = $e;
            $this->log .= "[token]"." [".date('Y-m-d H:i:s')."] Exception: $e\n";
            InterfaceLogger::log($this->log,"connection","token");
            $this->erpImportLog->end($this->db,"$this->log",'Exception');
            return $e;

        }

    }

    function requestData($url,$filters,$NewErpImportLog = true){

        try {

            $portDelimiter = '';
            $logUrl = explode('?',$url)[0];
            if(strcmp(trim($this->portRest),"")!=0){$portDelimiter = ":";}
            $this->log = "[".date('Y-m-d H:i:s')."] Request: ".$this->ipRest.$portDelimiter.$this->portRest."/$url\n";
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] Request: $this->ipRest:$this->portRest/$url\n","analytic","$logUrl");

            if($NewErpImportLog) {
                $this->erpImportLog = new ErpImport("$logUrl", "", '', '0', '0', '0', "", "", "", "");
                $this->db->resetAffectedRecords();
                $this->erpImportLog->start($this->db, "$this->log", "$this->erpImportID");
            }

            $ch = curl_init();
            curl_setopt_array($ch, array(
                CURLOPT_URL => $this->ipRest.$portDelimiter.$this->portRest.'/api/' . $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_POSTFIELDS => "$filters",
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_HTTPHEADER => array(
                    "Content-Type: application/json",
                    "Authorization: Bearer ".$this->authToken
                ),
            ));
            $response = curl_exec($ch);
            curl_close($ch);
            $this->response = $response;
            $this->log .= "[".str_replace('/','_',$logUrl)."] [".date('Y-m-d H:i:s')."] Response: ".substr(trim(preg_replace('/\s\s+/', ' ', $response)),0,150)." \n";
            InterfaceLogger::log($this->log,"connection","$logUrl");
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] Response: $response\n","analytic","$logUrl");
            return json_decode($response);

        } catch(Exception $e) {
            $this->response = $e;
            $this->log .= "[$url]"." [".date('Y-m-d H:i:s')."] Exception: $e\n";
            InterfaceLogger::log($this->log,"summary","$url");
            $this->erpImportLog->end($this->db,"$this->log",'Exception');
            return $e;

        }

    }

    function sendPostData($url,$json){
        try {
            $portDelimiter = '';
            if(strcmp(trim($this->portRest),"")!=0){$portDelimiter = ":";}
            $this->log = "[".date('Y-m-d H:i:s')."] Send Data: ".$this->ipRest.$portDelimiter.$this->portRest."/$url\n";
            InterfaceLogger::log("$this->log","analytic","$url");
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] Data Json: $json\n","analytic","$url");

            $this->erpImportLog = new ErpImport( "$url", "", '','0','0','0',"","", "", "");
            $this->db->resetAffectedRecords();
            $this->erpImportLog->start($this->db,"$this->log","$this->erpImportID");

            $ch = curl_init();
            curl_setopt_array($ch, array(
                CURLOPT_URL => $this->ipRest.$portDelimiter.$this->portRest.'/api/' . $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $json,
                CURLOPT_HTTPHEADER => array(
                    "Content-Type: application/json",
                    "Authorization: Bearer $this->authToken"
                )

            ));
            $response = curl_exec($ch);
            curl_close($ch);
            $this->response = $response;
            $this->log .= "[".str_replace('/','_',$url)."] [".date('Y-m-d H:i:s')."] Response: ".substr(trim(preg_replace('/\s\s+/', ' ', $response)),0,150)." \n";
            InterfaceLogger::log($this->log,"connection","$url");
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] Response: $response\n","analytic","$url");
            return json_decode($response);

        } catch(Exception $e) {
            $this->response = $e;
            $this->log .= "[$url]"." [".date('Y-m-d H:i:s')."] Exception: $e\n";
            InterfaceLogger::log($this->log,"summary","$url");
            $this->erpImportLog->end($this->db,"$this->log",'Exception');
            return $e;

        }

    }

    function sendPatchData($url,$json){
        try {
            $portDelimiter = '';
            if(strcmp(trim($this->portRest),"")!=0){$portDelimiter = ":";}
            $this->log = "[".date('Y-m-d H:i:s')."] Send (Patch) Data: ".$this->ipRest.$portDelimiter.$this->portRest."/$url\n";
            InterfaceLogger::log("$this->log","analytic","$url");
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] Data Json: $json\n","analytic","$url");

            $this->erpImportLog = new ErpImport( "$url", "", '','0','0','0',"","", "", "");
            $this->db->resetAffectedRecords();
            $this->erpImportLog->start($this->db,"$this->log","$this->erpImportID");

            $ch = curl_init();
            curl_setopt_array($ch, array(
                CURLOPT_URL => $this->ipRest . '/api/' . $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'PATCH',
                CURLOPT_POSTFIELDS => $json,
                CURLOPT_HTTPHEADER => array(
                    "Content-Type: application/json",
                    "Authorization: Bearer $this->authToken"
                )

            ));
            $response = curl_exec($ch);
            curl_close($ch);
            $this->response = $response;
            $this->log .= "[".str_replace('/','_',$url)."] [".date('Y-m-d H:i:s')."] Response: ".substr(trim(preg_replace('/\s\s+/', ' ', $response)),0,150)." \n";
            InterfaceLogger::log($this->log,"connection","$url");
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] Response: $response\n","analytic","$url");
            return json_decode($response);

        } catch(Exception $e) {
            $this->response = $e;
            $this->log .= "[$url]"." [".date('Y-m-d H:i:s')."] Exception: $e\n";
            InterfaceLogger::log($this->log,"summary","$url");
            $this->erpImportLog->end($this->db,"$this->log",'Exception');
            return $e;

        }

    }

    function log($response,$alterURL=''){
        foreach($response as $url => $text) {
            if(strcmp(trim($alterURL),'')!=0){$url = $alterURL;}
            $url = strtoupper($url);
            InterfaceLogger::log($text, "summary", "$url");
            InterfaceLogger::log($text, "analytic", "$url");
//            $this->erpImportLog->update($this->db,"$text");

        }
        $this->erpImportLog->updateRecordsAffected($this->db,$this->db->affectedRecords,$this->db->deletedRecords,$this->db->deleteStatementRecords);
    }

    function textLog($text){
        InterfaceLogger::log("[".date('Y-m-d H:i:s')."] ".$text, "summary", "TEXT LOG");
        InterfaceLogger::log("[".date('Y-m-d H:i:s')."] ".$text, "analytic", "TEXT LOG");
    }

    function complete(){
        $this->erpImportLog->end($this->db);
        $this->db->resetAffectedRecords();
    }


}