<?php
include(ROOT . "backend/core/model/Salesperson.php");
include(ROOT . "backend/core/model/Warehouse.php");

class DBSalesperson {

    public $db;

    static private $instance;

    public function __construct()
    {
        $this->db = new mysqli(localhost,username,password,database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $this->db->set_charset("utf8");
    }

    static public function getInstance()
    {
        if (!isset(self::$instance)) {
            self::$instance = new DBItem();
        }
        return self::$instance;
    }

    public function getSalesPersonByID($salesPersonID)
    {
        $salesperson=null;
        $stm = $this->db->prepare("SELECT salesperson_id, salesperson_code, first_name, last_name, landline, mobile, email, default_warehouse_id, discount_allowance, allow_tenders, allow_invoices, allow_orders, allow_waybills, allow_returns, allow_receipts, allow_visits, allow_load, allow_unload, view_history, allow_anonymous_customer, allow_negative_stock, only_from_truck, order_stock_info, discount_allowance_line, anonymous_group_id, edit_schedule, create_schedule, allow_discount_receipt, gps_track, gps_track_distance, gps_track_time, take_picture, start_end_km_schedules, load_negative_qty, invoice_type_prefer, stock_reserved_calculation, erp_popular_products, default_qty, search_item_in_category, level_navigation, show_last_price, erp_last_price, show_price_after_discount, no_action_before_schedule, visit_all_before_end_schedule, allow_statements, waybill_show_prices_pdf, waybill_to_invoice_include_items, allow_customer_stock_taking, show_customer_stock_taking_info, allow_crm, cheque_mandatory, credit_limit_warning, stock_warning, allow_load_request, round_up_to_box, auto_generate_statement, allow_credit_note, post_dated_cheque_limit, return_only_from_invoice, post_dated_cheque_credit_limit, use_batch_numbers, return_policy, select_promotion_group FROM SalesPersons WHERE salesperson_id='$salesPersonID' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($salesperson_id, $salesperson_code, $first_name, $last_name, $landline, $mobile, $email, $default_warehouse_id, $discount_allowance, $allow_tenders, $allow_invoices, $allow_orders, $allow_waybills, $allow_returns, $allow_receipts, $allow_visits, $allow_load, $allow_unload, $view_history, $allow_anonymous_customer, $allow_negative_stock, $only_from_truck, $order_stock_info, $discount_allowance_line, $anonymous_group_id, $edit_schedule, $create_schedule, $allow_discount_receipt, $gps_track, $gps_track_distance, $gps_track_time, $take_picture, $start_end_km_schedules, $load_negative_qty, $invoice_type_prefer, $stock_reserved_calculation, $erp_popular_products, $default_qty, $search_item_in_category, $level_navigation, $show_last_price, $erp_last_price, $show_price_after_discount, $no_action_before_schedule, $visit_all_before_end_schedule, $allow_statements, $waybill_show_prices_pdf, $waybill_to_invoice_include_items, $allow_customer_stock_taking, $show_customer_stock_taking_info, $allow_crm, $cheque_mandatory, $credit_limit_warning, $stock_warning, $allow_load_request, $round_up_to_box, $auto_generate_statement, $allow_credit_note, $post_dated_cheque_limit, $return_only_from_invoice, $post_dated_cheque_credit_limit, $use_batch_numbers, $return_policy, $select_promotion_group);
        while ($stm->fetch()) {

            $salesperson = new Salesperson($salesperson_id, $salesperson_code, $first_name, $last_name, $landline, $mobile, $email, $default_warehouse_id, $discount_allowance, $allow_tenders, $allow_invoices, $allow_orders, $allow_waybills, $allow_returns, $allow_receipts, $allow_visits, $allow_load, $allow_unload, $view_history, $allow_anonymous_customer, $allow_negative_stock, $only_from_truck, $order_stock_info, $discount_allowance_line, $anonymous_group_id, $edit_schedule, $create_schedule, $allow_discount_receipt, $gps_track, $gps_track_distance, $gps_track_time, $take_picture, $start_end_km_schedules, $load_negative_qty, $invoice_type_prefer, $stock_reserved_calculation, $erp_popular_products, $default_qty, $search_item_in_category, $level_navigation, $show_last_price, $erp_last_price, $show_price_after_discount, $no_action_before_schedule, $visit_all_before_end_schedule, $allow_statements, $waybill_show_prices_pdf, $waybill_to_invoice_include_items, $allow_customer_stock_taking, $show_customer_stock_taking_info, $allow_crm, $cheque_mandatory, $credit_limit_warning, $stock_warning, $allow_load_request, $round_up_to_box, $auto_generate_statement, $allow_credit_note, $post_dated_cheque_limit, $return_only_from_invoice, $post_dated_cheque_credit_limit, $use_batch_numbers, $return_policy, $select_promotion_group);


        }
        $stm-> close();
        return $salesperson;
    }

    public function getSalesPersonBasicInfo($salesperson)
    {
        $stdClass = new stdClass();
        $stdClass->salespersonID=$salesperson->salesperson_id;
        $stdClass->salespersonCode=$salesperson->salesperson_code;
        $stdClass->firstName=$salesperson->first_name;
        $stdClass->lastName=$salesperson->last_name;
        $stdClass->landline=$salesperson->landline;
        $stdClass->mobile=$salesperson->mobile;
        $stdClass->email=$salesperson->email;
        $stdClass->defaultWarehouse=$this->getWarehouse($salesperson->default_warehouse_id);
        $stdClass->discountAllowance=$salesperson->discount_allowance;
        return $stdClass;
    }


    private function getWarehouse($warehouseID){

        $warehouse = new stdClass();
        $warehouse->warehouseID = $warehouseID;
        $warehouse->warehouseCode = '';
        $warehouse->name = '';
        $warehouse->type = '';

        $stm = $this->db->prepare("SELECT warehouse_code,name,type FROM Warehouses WHERE warehouse_id='$warehouseID' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($warehouse_code,$name,$type);
        while ($stm->fetch()) {

            $warehouse->warehouseCode = $warehouse_code;
            $warehouse->name = $name;
            $warehouse->type = $type;


        }
        $stm-> close();
        return $warehouse;


    }





}