<?php
include_once("../../../../param.php");

global  $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$devicesOptions = '';
$stmt = $db->prepare("SELECT device_id,display_prefix,salesperson_code,SalesPersons.type,first_name,last_name,activation_code,'sal' FROM Devices LEFT JOIN SalesPersons ON (Devices.sales_person_id=SalesPersons.salesperson_id) WHERE Devices.status='active' AND NOT gcm_id = ''
                            UNION ALL
                            SELECT device_pop_id,display_prefix,salesperson_code,SalesPersons.type,first_name,last_name,activation_code,'pur' FROM Devices_Pop LEFT JOIN SalesPersons ON (Devices_Pop.sales_person_id=SalesPersons.salesperson_id) WHERE Devices_Pop.status='active' AND NOT gcm_id = '' 
                            ORDER BY salesperson_code");
$stmt->execute();
$stmt->bind_result($deviceID,$displayPrefix,$salespersonCode,$salesPersonType,$firstName,$lastName,$activationCode,$deviceType);
while ($stmt->fetch()) {

    if(strcmp($deviceType,'pur')==0){
        $deviceDisplayType = 'Purchasing';
    } else {
        $deviceDisplayType = 'Sales';
    }

    $devicesOptions .= "<option value='$deviceID|$deviceType'>$salespersonCode - $firstName $lastName $salesPersonType ($deviceDisplayType App) / $activationCode / $displayPrefix</option>";
}
$stmt->close();

?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white"> Send Push Notification</li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">
        <!-- row -->
        <div class="row">
            <article class="col-xs-12 col-sm-12 col-md-12 col-lg-6">
                <!-- new widget -->
                <div class="jarviswidget" id="wid-id-0" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2>Send Push Notification</h2>
                    </header>

                    <div class="widget-body">

                        <div class="row">

                            <div class="col-sm-12">

                                <form id="pageForm" method="post" class="smart-form" enctype="multipart/form-data">

                                    <fieldset style="padding-top:0px">

                                        <div class="row">

                                            <section class="col-sm-9">
                                                <section>
                                                    <label class="label-bold align-left">Notification Title: </label>
                                                    <input type="text" class="form-control"  id="title" value="" />
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Details: </label>
                                                    <textarea type="text" class="form-control"  id="body"  style="min-height: 100px;"></textarea>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Select Sales Person / Activation Code / Prefix: </label>
                                                    <select class="form-control" id="devices" multiple="multiple">
                                                        <?php echo $devicesOptions; ?>
                                                    </select>
                                                </section>
                                            </section>
                                        </div>
                                        <section class="col-sm-2 pull-right">
                                            <input type="button" id="PostSubmit" class="btn btn-success pull-right" style="padding: 10px;font-size: 16px;"  value="Send Notification" onclick="sendNotification()">
                                        </section>
                                    </fieldset>
                                </form>





                            </div>

                        </div>

                    </div>
                    <!-- end widget div -->
                </div>
                <!-- end widget -->

            </article>

        </div>
        <!-- end row -->
    </div>






</div>





<script type="text/javascript">



    function sendNotification() {
        $('#PostSubmit').hide();
        var devices = $('#devices').val();
        if(devices) {
            for (let i = 0; i < devices.length; i++) {

                var device = devices[i];
                var title = $('#title').val();
                var body = $('#body').val();

                var deviceIdTypeSplit = device.split('|');
                var deviceID = deviceIdTypeSplit[0];
                var deviceType = deviceIdTypeSplit[1];
                var countToSendingNotification = 0;
                if (deviceID > 0 && deviceType.length > 0) {

                    $.ajax({
                        type: 'POST',
                        url: '//<?php echo HTML_PATH?>/cop/libs/gcm/sendFirebasePushMessage.php',
                        dataType: 'html',
                        data: {
                            'deviceID': deviceID,
                            'deviceType': deviceType,
                            'title': title,
                            'body': body
                        },
                        success: function (result) {
                            countToSendingNotification = +countToSendingNotification + +result;
                            console.log(countToSendingNotification);
                            console.log(result);
                            console.log(devices.length);
                            if(countToSendingNotification === devices.length){
                                $('#PostSubmit').show();
                                $.smallBox({
                                    title: 'Success!',
                                    content: "Notification Sent",
                                    color: "#739E73",
                                    timeout: 3000,
                                    icon: "fa fa-user swing animated"
                                });
                            }

                        }
                    });
                }
            }
        }
    }

    // End of SavePost()

    $(document).ready(function() {

        pageSetUp();

        $('#devices').select2();


    })
</script>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>


?>