<?php

class sms {

    private $url;
    private $supplier;
    private $username;
    private $password;
    private $mobile;
    private $title;
    private $content;
    private $error;

    function setUrl ($val){$this->url = $val;}
    function setSupplier ($val){$this->supplier = $val;}
    function setUsername ($val){$this->username = $val;}
    function setPassword ($val){$this->password = $val;}
    function setMobile ($val){$this->mobile = $val;}
    function setTitle ($val){$this->title = $val;}
    function setContent ($val){$this->content = $val;}
    function setError ($val){$this->error = $val;}
    function resetUrl (){$this->url = '';}

    function getUrl (){ return $this->checkIfEmpty($this->url,"url"); }
    function getSupplier (){return $this->checkIfEmpty($this->supplier,'supplier'); }
    function getUsername (){return $this->checkIfEmpty($this->username,'username'); }
    function getPassword (){return $this->checkIfEmpty($this->password,'password'); }
    function getMobile (){return $this->checkIfEmpty($this->mobile,'mobile'); }
    function getTitle (){return $this->checkIfEmpty($this->title,'title'); }
    function getContent (){return $this->checkIfEmpty($this->content,'content'); }
    function getError (){return $this->error;}


    function checkIfEmpty($val,$varName)
    {
        if(!isset($val) || strcmp($val,'')==0)
        {
            $this->setError($this->getError()."$varName not set.<br/>");
        }
        return str_replace(' ','%20',$val);
    }

    function sendSms()
    {
        if(strcmp($this->supplier,'goldentelemedia.com')==0){$this->setContent(str_replace('<br>','',$this->getContent()));}
        if(strcmp($this->supplier,'goldentelemedia.com')==0){$this->setContent(str_replace('</br>','',$this->getContent()));}
        if(strcmp($this->supplier,'') != 0 || strcmp($this->url,'') != 0)
        {
            if(strcmp($this->url,'') != 0)
            {
                try
                {
                    $responce = file_get_contents($this->url);
                    if($responce) {
                        $message = explode(' ', $responce);
                        $this->setError("Sending Message to " . $this->mobile . " " . $message[0] . "<br/>");
                        $this->resetUrl();
                    } else {
                        $this->setError("Sending Message to " . $this->mobile . " : ERROR<br/>");
                        $this->resetUrl();
                    }
                }
                catch(Exception $e){$this->setError($this->getError().$e."<br/>");}
            }
            else {if($this->setUrlFromSupplier()){$this->sendSms();}}
        }
        else {$this->setError($this->getError()."No Supplier/URL provided.<br/>");}
    }

    function setUrlFromSupplier()
    {
        if(strcmp($this->getSupplier(),'') != 0)
        {
            $usr     = $this->getUsername();
            $psw     = $this->getPassword();
            $mobile  = $this->getMobile();
            $title   = $this->getTitle();
            $message = $this->getContent();

            switch ($this->supplier) {
                case 'sendmesms.eu':
                    $this->setUrl("http://sms.sendmesms.eu/sendapiinter.asp?usr=$usr&psw=$psw&mobnu=$mobile&title=$title&message=$message&batchid=1");
                    return true;
                    break;
                case 'goldentelemedia.com':
                    $this->setUrl("https://www.goldentelemedia.com/themmapps/services/dlr/sendsmsdlr.aspx?user=$usr&password=$psw&to=$mobile&header=$title&message=$message");
                    return true;
                    break;
                default:
                    $this->setError($this->getError()."Supplier not Matched. Set Up the New Supplier in smsSender => setUrlFromSupplier().<br/>");
                    return false;
            }
        }
        else {
            $this->setError($this->getError()."No Supplier provided. setSupplier().<br/>");
            return false;
        }
    }


}

?>