<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");


// DB table to use
$table = 'SalesPersons';

// Table's primary key
$primaryKey = "salesperson_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(

    array( 'db' => '`s`.`salesperson_code`',       'dt' =>  'code', 'field' =>'salesperson_code' ),
    array( 'db' => '`s`.`first_name`',       'dt' => 'name', 'field' => 'first_name' ),
    array( 'db' => '`s`.`last_name`',       'dt' => 'surname', 'field' => 'last_name' ),
    array( 'db' => '`s`.`status`',       'dt' => 'status', 'field' => 'status' ),
    array( 'db' => '`s`.`salesperson_id`', 'dt' => 'signature', 'formatter' => function( $d, $row ) {
        if (file_exists(ROOT . 'media/signatures/' . $d . '.jpg')) {
            return '<img id="img-'.$d.'"class="center-canvas" style="width:auto;height:100px;max-width:250px" src="//' . HTML_PATH . '/cop/media/signatures/' . $d . '.jpg?'.date('is').'"></td>';
        } else {
            return '<p>No digital Signature</p>';
        }


    },'field' => 'salesperson_id' ),

    array( 'db' => '`s`.`salesperson_id`',       'dt' => 'actions' , 'formatter' => function( $d, $row ) {

        return 	'
                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#uploadModal" onclick="funTest('.$d.')" style="margin-top:5px;width: 150px;">Upload Signature</button>
                    <br>
                 <button type="button"  onclick="funDelete('.$d.')" class="btn btn-danger" style="margin-top:5px;width: 150px;">Delete Signature</button>
        ';
    }, 'field' => 'salesperson_id' )
);






// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `SalesPersons` AS `s`";
$where="";



//$where ="`a`.`primary_address`='yes'";
require(ROOT . 'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>