<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
require_once('../../../../param.php');
require_once(ROOT . "backend/modules/settlements/model/languageProperties.php");

// DB table to use
$table = 'Settlements';

// Table's primary key
$primaryKey = "settlement_id";


// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`s`.`settlement_id`', 'dt' => 'img', 'formatter' => function( $d, $row ) {
        $GLOBALS['settlement_id']=$d;
        return '';}, 'field' => 'settlement_id' ),

    array( 'db' => '`s`.`settlement_code`', 'dt' => 'img', 'formatter' => function( $d, $row ) {
        $id = $GLOBALS['settlement_id'];
        global $username;
        global $password;
        global $database;
        $db1 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $check = false;
        $db1->set_charset("utf8");
        $stm1 = $db1->prepare("SELECT attachment_url FROM Action_Attachments WHERE  action_id='$id' AND action_type='Settlements' ORDER BY timestamp DESC LIMIT 1 ");
        $stm1-> execute();
        $stm1-> bind_result($imgName);
        while ($stm1->fetch()) {
            if(strcmp($imgName,'')!=0) {
                $d = '//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/imageicon.png';
                $onClick = 'onclick="getImage(\''.$imgName.'\')" style="cursor:pointer;"';
                if (file_exists(ROOT . "media/actionAttachments/$imgName")) {
                    $check = true;
                }
            }

        }
        $stm1->close();
        if(!$check) {
            $onClick = '';
            $d = '//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/receipticon.png';
        }
        return '<img class="custom-rounded-image settlement center-canvas" src="'.$d.'" width="30" height="30" '.$onClick.' title="View Receipts" ></td>';
    }, 'field' => 'settlement_code' ),

    array( 'db' => '`s`.`settlement_code`', 'dt' =>  'code', 'field' =>'settlement_code' ),
    array( 'db' => '`s`.`notes_1`', 'dt' =>  'notes1', 'field' =>'notes_1' ),

    array( 'db' => '`s`.`status`', 'dt' =>  'status', 'field' =>'status' ),

    array( 'db' => '`s`.`settlement_date`', 'dt' => 'date' ,  'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));
    },'field' => 'settlement_date' ),

    array( 'db' => '`sp`.`salesperson_code`', 'dt' => 'salesperson',

        'formatter' => function( $d, $row ) {


            global $username;
            global $password;
            global $database;
            $db1 = new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }

            $db1->set_charset("utf8");
            $stm1 = $db1->prepare("SELECT first_name,last_name FROM SalesPersons WHERE salesperson_code='$d'");
            $stm1-> execute();
            $stm1-> bind_result($fname,$lname);
            while ($stm1->fetch()) {

            }
            $stm1->close();

            return "$d - $fname $lname";



        },


        'field' => 'salesperson_code' ),

    array( 'db' => '`s`.`settlement_id`', 'dt' => 'receipts',

        'formatter' => function( $d, $row ) {


            global $username;
            global $password;
            global $database;
            $db1 = new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }

            $db1->set_charset("utf8");
            $stm1 = $db1->prepare("SELECT count(receipt_id) FROM Settlement_Receipt WHERE settlement_id='$d'");
            $stm1-> execute();
            $stm1-> bind_result($counter);
            while ($stm1->fetch()) {

            }
            $stm1->close();

            if($counter == 0){$counter = '-';} else {$counter = "<b>$counter</b>";}

            return "$counter";



        },


        'field' => 'settlement_id' ),


    array( 'db' => '`s`.`amount`', 'dt' => 'amount', 'formatter' => function( $d, $row ) {
        global $currencySymbol;
        return $currencySymbol. number_format($d,'2','.',',');
    }, 'field' => 'amount' ),
    array( 'db' => '`s`.`status`', 'dt' => 'status', 'field' => 'status' ),

    array( 'db' => '`s`.`settlement_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
        global $addButtonLabel,$editButtonLabel;

//        allagh petros
        global $username;
        global $password;
        global $database;
        $db1 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $db1->set_charset("utf8");
        $arrayDownloadImg = array();
        $resDocumentSearchAttachment = array();
        $stm = $db1->prepare("SELECT receipt_id FROM Settlement_Receipt WHERE settlement_id='$d'");
        $stm->execute();
        $stm->bind_result($receiptID_set);
        while ($stm->fetch()) {
            array_push($resDocumentSearchAttachment,$receiptID_set);
        }
        $stm->close();
        array_push($resDocumentSearchAttachment,$d);
        if (count($resDocumentSearchAttachment)>0){
            $resDocumentSearchAttachmentImplode = implode(',',$resDocumentSearchAttachment);
            $stm = $db1->prepare("SELECT attachment_url FROM Action_Attachments WHERE (action_type='Receipts' OR action_type='Settlements')  AND action_id IN ($resDocumentSearchAttachmentImplode) ");
            $stm->execute();
            $stm->bind_result($imgName);
            while ($stm->fetch()) {
                if (file_exists(ROOT . "media/actionAttachments/$imgName")) {
                    array_push($arrayDownloadImg,$imgName);
                }
            }
            $stm->close();
        }
        if (count($arrayDownloadImg)>0){
            $arrayDownloadImgImplode = implode(',',$arrayDownloadImg);
            $idElement = 'imgSettlements'.$d;
            $buttonImg = "
            			<button  id=\"$idElement\"  class=\"btn btn-settlement\" onclick=\"downloadImg('$idElement','$arrayDownloadImgImplode');\"  style=\"font-size:13px;width:auto;margin-right: 3px;\"><i class='fa fa-download' ></i></button>
            ";
        }else{
            $buttonImg = '';
        }

//        allagh petros
        return '<div style="display: flex">'.$buttonImg.'
              
                <form id="'.$d.'"action="//'.HTML_PATH .'/cop/backend/modules/settlements/views/create_settlement.php" method="post" target="_blank" style="display: inline-block; margin-bottom: 3px;">
           		    <input type="hidden" name="settlement_id" value="'.$d.'">	           			                   
			        <input style="font-size:13px;width:auto;" type="submit" class="btn btn-settlement" value="'.$addButtonLabel.'" >
			    </form></div>';
     }, 'field' => 'settlement_id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


//$where = "NOT status ='Canceled' ";

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$where = '';
if(isset($_GET['status']) && strcmp($_GET['status'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $statusFilter = $_GET['status'];
    $where .= " `s`.`status` = '$statusFilter'";
}
if(isset($_GET['notDraft']) && strcmp($_GET['notDraft'],'yes')==0 && strcmp($_GET['status'],'Draft')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}

    $where .= " NOT `s`.`status` = 'Draft'";
}
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `s`.`salesperson_id` IN (".$_SESSION['Allow_Salespersons'].")";
}


global $username,$password,$database;
$db1 = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db1->set_charset("utf8");
$stm1 = $db1->prepare("SELECT user_group,master_user FROM Admin WHERE id='".$_SESSION['adminID']."'");
$stm1-> execute();
$stm1-> bind_result($fcGroup,$masterUser);
while ($stm1->fetch()) {}
$stm1->close();

if(strcmp(strtolower($fcGroup),'fc')!=0 && strcmp(strtolower($masterUser),'yes')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `s`.`salesperson_id` = '".$_SESSION['adminID']."' ";
}


$joinQuery = "FROM `Settlements` AS `s` LEFT JOIN `SalesPersons` AS `sp` ON (`sp`.`salesperson_id` = `s`.`salesperson_id`)";
require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>