<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include_once("../../../../param.php");
require_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");


$companyID      = $_SESSION['companyID'];
$settlementDate = trim($_POST['settlementDate']);
$salespersonID  = trim($_POST['salesperson']);
$details1       = trim($_POST['details1']);
$details2       = trim($_POST['details2']);
$notes1         = trim($_POST['notes1']);
$notes2         = trim($_POST['notes2']);
$serviceCallID  = trim($_POST['serviceCallID']);
$settlementID   = trim($_POST['settlementID']);
$settlementCode = trim($_POST['settlementCode']);
$status         = trim($_POST['status']);

$checkedReceipts =  array();
$checkedReceipts = $_POST['checkedReceipts'];

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    $amount=0;
    $allCash=true;

    $checkedReceiptsFilter = implode(',',$checkedReceipts);
    if(strcmp($checkedReceiptsFilter,'')!=0) {
        $stmt = $db->prepare("SELECT Receipts.amount,Receipts.payment_method FROM Receipts WHERE receipt_id IN ($checkedReceiptsFilter)");
        $stmt->execute();
        if (strcmp($stmt->error, "") != 0) {throw new Exception();}
        $stmt->bind_result($receiptAmount,$paymentMethod);
        while ($stmt->fetch()) {

            $amount+=$receiptAmount;

            if(strcmp($paymentMethod,"Cash")!=0)
            {
                $allCash=false;
            }


        }
        $stmt->close();


    }

    $amount = (float)$amount;
//    if($allCash){ $status = 'Approved / Waiting Cashier';}


    lockDocumentSingleTransaction($settlementID, "Settlements", $db);

    if(strcmp($status,'')==0) {
        $stmt = $db->prepare("SELECT status FROM Settlements WHERE settlement_id=?");
        $stmt->bind_param('i', $settlementID);
        $stmt->execute();
        if (strcmp($stmt->error, "") != 0) {throw new Exception();}
        $stmt->bind_result($status);
        while ($stmt->fetch()) {}
        $stmt->close();
    }
    $stmt = $db->prepare("DELETE FROM Settlements WHERE settlement_id=?");
    $stmt->bind_param('i', $settlementID);
    $stmt->execute();
    if (strcmp($stmt->error, "") != 0) {throw new Exception();}
    $stmt->close();


    $stmt = $db->prepare("INSERT INTO Settlements (settlement_id, settlement_code, settlement_date, company_id, salesperson_id, amount, details_1, details_2, notes_1, notes_2, status, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW())");
    $stmt->bind_param('sssssssssss', $settlementID, $settlementCode, $settlementDate, $companyID, $salespersonID, $amount, $details1, $details2, $notes1, $notes2, $status);
    $stmt->execute();
    if(strcmp($stmt->error,"")!=0) {throw new Exception();}
    $stmt->close();


    foreach ($checkedReceipts as $receiptID) {

        $stmt = $db->prepare("INSERT IGNORE INTO Settlement_Receipt (settlement_id,receipt_id,timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii', $settlementID, $receiptID);
        $stmt->execute();
        if(strcmp($stmt->error,"")!=0) {throw new Exception();}
        $stmt->close();

    }

    $custTable = new CustomTable('Settlements', $settlementID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode, $db);
    }

    $db->commit(true);

    echo "$settlementID";

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}

$custForm = new CustomForm('Settlements',$settlementID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}




//redirect('./platform/manage_customers.php');


			
			
						
 
				
	
	

	
function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

function getVatID($vatCode,$db)
{

    $z="";
    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;



}

function getSubUnits($itemID,$db) {

    $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $sub;


}

function updateCustomerBalance($customerID,$amount,$db)
{

    $stmt = $db->prepare("UPDATE  Customers SET balance = balance + ? WHERE customer_id=?");
    $stmt->bind_param('di',$amount,$customerID);
    $stmt->execute();
    $stmt->close();

}
?>