<?php

include_once("../../../../param.php");
require(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");

$companyID      = $_SESSION['companyID'];
$settlementDate = trim($_POST['settlementDate']);
$salespersonID  = trim($_POST['salesperson']);
$details1       = trim($_POST['details1']);
$details2       = trim($_POST['details2']);
$notes1         = trim($_POST['notes1']);
$notes2         = trim($_POST['notes2']);
$serviceCallID  = trim($_POST['serviceCallID']);

$checkedReceipts =  array();

if(isset($_POST['autoProcess']) && strcmp($_POST['autoProcess'],'yes')==0){
    $autoProcess = true;
    $checkedReceiptsFilter = trim($_POST['receiptsArrayString']);
    $checkedReceipts = explode(',',$checkedReceiptsFilter);
    $settlementDate = date('Y-m-d');
    $salespersonID  = $_SESSION['adminID'];
} else {
    $autoProcess     = false;
    $checkedReceipts = $_POST['checkedReceipts'];
    $checkedReceiptsFilter = implode(',',$checkedReceipts);
}

$status = 'Draft';



global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();


    if(strcmp($checkedReceiptsFilter,'')!=0) {
        $stmt = $db->prepare("SELECT sum(Receipts.amount) FROM Receipts WHERE receipt_id IN ($checkedReceiptsFilter)");
        $stmt->execute();
        if (strcmp($stmt->error, "") != 0) {throw new Exception();}
        $stmt->bind_result($receiptsAmount);
        while ($stmt->fetch()) {}
        $stmt->close();
    }

//    $amount = '';
  $amount = (float)$receiptsAmount;

    $settlementID   = getNextKeySingleTransaction("Settlements", "settlement_id", $db);
    $settlementCode = getNextCodeSingleTransaction("Settlements", "settlement_code", "SE", "CLOUD", $db);

    if (strcmp($settlementCode, '') == 0) {
        $stm = $db->prepare("SELECT display_prefix FROM Devices WHERE activation_code='CLOUD' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($preFix);
        while ($stm->fetch()) {}
        $stm->close();
        $settlementCode = 'SE'.$preFix.'10000';
    }


    $stmt = $db->prepare("INSERT INTO Settlements (settlement_id, settlement_code, settlement_date, company_id, salesperson_id, amount, details_1, details_2, notes_1, notes_2, status, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW())");
    $stmt->bind_param('sssssssssss', $settlementID, $settlementCode, $settlementDate, $companyID, $salespersonID, $amount, $details1, $details2, $notes1, $notes2, $status);
    $stmt->execute();
    if(strcmp($stmt->error,"")!=0) {echo $stmt->error;throw new Exception();}
    $stmt->close();

    lockDocumentSingleTransaction($settlementID, "Settlements", $db);



    foreach ($checkedReceipts as $receiptID){
        $stmt = $db->prepare("INSERT INTO Settlement_Receipt (settlement_id,receipt_id,timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii', $settlementID, $receiptID);
        $stmt->execute();
        if(strcmp($stmt->error,"")!=0) {throw new Exception();}
        $stmt->close();

    }



    if ($serviceCallID > 0) {
        date_default_timezone_set('Europe/Athens');
        $serviceCallReplyID = getNextKeySingleTransaction("Service_Call_Reply", "service_call_reply_id", $db);
        $status = 0;
        $timezone = 2;
        $date = date("Y-m-d H:i:s");
        $replyTypeID = 3;
        $details = "New Settlement Issued";
        $documentType = "Settlements";
        $salespersonTo = 0;
        $emailResponse = "";
        $priorityID = 0;
        $stmt = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iiiisisisisi', $serviceCallReplyID, $serviceCallID, $salespersonID, $status, $date, $replyTypeID, $details, $receiptID, $documentType, $salespersonTo, $emailResponse, $priorityID);
        $stmt->execute();
        if(strcmp($stmt->error,"")!=0) {throw new Exception();}
        $stmt->close();
    }



    $db->commit(true);

    if ($serviceCallID > 0) {
        echo "$settlementID&service_call_id=$serviceCallID";
    } else {
        if($autoProcess){
            echo "  <form method='post' name='redirectForm' action='//".HTML_PATH."/cop/backend/modules/settlements/views/create_settlement.php?settlement_id=$settlementID' >
                        <input type='hidden' name='receiptsArrayString' id='receiptsArrayString' value='$checkedReceiptsFilter' >
                        <input type='hidden' name='receiptsAmount' id='receiptsAmount' value='$receiptsAmount' >
                        <input type='hidden' name='autoProcess' value='yes' >
                    </form>
                    <script>
                        document.redirectForm.submit();
                    </script>
                  ";
        } else {
            echo "$settlementID";
        }
    }

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}

$custForm = new CustomForm('Settlements',$settlementID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}


			
			
						
 
				
	
	

	
function redirect($url)
{
	if (headers_sent())
	{
		die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
	}
	else
	{
		header('Location: ' . $url);
		die();
	}    
}

function getVatID($vatCode,$db)
{

    $z="";
    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;



}

function getSubUnits($itemID,$db) {

    $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $sub;


}

function updateCustomerBalance($customerID,$amount,$db)
{

    $stmt = $db->prepare("UPDATE  Customers SET balance = balance + ? WHERE customer_id=?");
    $stmt->bind_param('di',$amount,$customerID);
    $stmt->execute();
    $stmt->close();

}
?>