<?php
include_once("../../../../param.php");

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$whereSP = '';
$whereSPSchedule = '';
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    $whereSP .= " WHERE salesperson_id IN (".$_SESSION['Allow_Salespersons'].")";
    $schedulesArray = array();
    $stm = $db->prepare("SELECT schedule_id FROM Schedule_Salesperson $whereSP");
    $stm-> execute();
    $stm-> bind_result( $scheduleFilterID);
    while ($stm->fetch()) {
        array_push($schedulesArray,$scheduleFilterID);
    }
    $whereSPSchedule = implode(',',$schedulesArray);
    if(strcmp($whereSPSchedule,'')!=0){$whereSPSchedule = "WHERE schedule_id IN($whereSPSchedule)";}
}

$stm = $db->prepare("SELECT CONCAT(salesperson_code, ' - ',first_name, ' ', last_name), salesperson_id FROM SalesPersons $whereSP");
$stm-> execute();
$stm-> bind_result($salespersonName, $salespersonID);
while ($stm->fetch()) {
    $salespersonSelection .= "<option value='$salespersonID'>$salespersonName</option>";
}

$stm-> close();

$stm = $db->prepare("SELECT name, schedule_id FROM Schedules $whereSPSchedule");
$stm-> execute();
$stm-> bind_result($scheduleName, $scheduleID);
while ($stm->fetch()) {
    $scheduleSelection .= "<option value='$scheduleID'>$scheduleName</option>";
}

$stm-> close();
?>

<div class="container" style="width: auto;height: 1200px; " >
    <div class="row">
        <article class="col-xs-12 col-sm-7 col-md-8 col-lg-9">
            <div class="map" id="map" style="height: 800px;"></div>
        </article>
        <article class="col-xs-12 col-sm-7 col-md-8 col-lg-3">
            <div class="widget-body" style="padding-left: 6px;">
                <label style="display: block"><b>Select Date Range:</b></label>
                <input type="date" name="dateFrom" id="dateFrom" class="form-control" style="display: inline-block;width: 40%">
                <input type="date" name="dateTo" id="dateTo" class="form-control" style="display: inline-block;width: 40%">
                <label style="display: block; margin-top: 10px"><b>Select Sales Person:</b></label>
                <select name="salesPerson" id="salesPerson" class="form-control" style="width: 80%">
                    <?php echo $salespersonSelection; ?>
                </select>
                <label style="display: block; margin-top: 10px"><b>Select Schedule:</b></label>
                <select name="schedule" id="schedule" class="form-control" style="display: block;width: 80%">
                    <option value="">- All Schedules -</option>
                    <?php echo $scheduleSelection; ?>
                </select><br/>
                <button type="button" name="generateReport" id="generateReport" class="btn btn-primary" onclick="getData()" style="margin-left:25%;margin-right25%;width: 50%">Get Data</button>
                <br>
                <div id="resultMap"></div>
            </div>
        </article>
    </div>
</div>

<style>
    .map { width: 100%; height: 100% ;margin-left: 2%;}

    .info-card {
        background: #a61616;
        border-radius: 12px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        padding: 20px;
        max-width: 400px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        transition: transform 0.2s ease-in-out;
    }
</style>

<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAonEryABOdRQBcgEfH51-nOoXTca3XlWs&libraries=drawing&callback=initMap"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>

<script type="text/javascript">
    var copMap;
    var markers=[];
    var latlngs = [];
    var htmlInfo = '';

    function getData(){
        updateMarkers(copMap);
    }

    function initMap()
    {
        copMap = new google.maps.Map(document.getElementById('map'), {
            center: {lat: 32.8430376, lng: 13.1375243},
            zoom: 3
        });
    }

    function updateMarkers(copMap){
        markers=[];
        countOfOrders = 0;

        var schedule    = $('#schedule').val();
        var salesperson = $('#salesPerson').val();
        var dateFrom    = $('#dateFrom').val();
        var dateTo      = $('#dateTo').val();
        $('#resultMap').html('');
        $.ajax({
            type:"POST",
            dataType: "json",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/scheduleObjectActions/controllers/getScheduleObjectActions.php',
            data: {
                'schedule':schedule,
                'salesperson':salesperson,
                'dateFrom':dateFrom,
                'dateTo':dateTo
            },
            success: function(json) {
                console.log(json.length);
                //loopSchedule
                $.each(json, function(index,value){

                    $.each(value.customers, function(indexCustomers,customers){
                           htmlInfo += customers.htmlSchedules;

                            var marker = new google.maps.Marker({
                                position: new google.maps.LatLng(customers.customerInfo.lat, customers.customerInfo.lng),
                                map: copMap,
                                title: customers.customerInfo.code,

                                label: ''
                            });
                            markers[indexCustomers] = marker;

                            $.each(customers.actions, function(indexActions,actions){
                                console.log(actions.lat);
                                console.log(actions.lng);
                                var marker = new google.maps.Marker({
                                    position: new google.maps.LatLng(actions.lat, actions.lng),
                                    map: copMap,
                                    title: actions.action_type+'-'+actions.action_id,
                                    title: '',
                                    label: '',
                                    icon: pinSymbol('#5caf63')
                                });
                                markers[indexActions] = marker;
                                latlngs[indexActions] = marker.position;
                                console.log(markers);
                                $('#resultMap').html(htmlInfo);
                            });
                    });
                });
            }
        });
    }
    function pinSymbol(color) {
        return {
            path: 'M 0,0 C -2,-20 -10,-22 -10,-30 A 10,10 0 1,1 10,-30 C 10,-22 2,-20 0,0 z',
            fillColor: color,
            fillOpacity: 1,
            strokeColor: 'black',
            strokeWeight: 1,
            scale: 1
        };
    }

    $(document).ready(function() {

        pageSetUp();

        $('#schedule').select2();
        initMap();

    });


</script>
