<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');

// DB table to use
$table = 'ERP_Connection';

// Table's primary key
$primaryKey = "erp_connection_id";

// Array of database columns which should be read and sent back to DataTables.
// The db parameter represents the column name in the database, while the dt
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => 'e.erp_host',
        'dt' => 'host',
        'field' => 'erp_host'
    ),
    array(
        'db' => 'e.erp_port',
        'dt' => 'port',
        'field' => 'erp_port'
    ),

    array(
        'db' => 'e.erp_username',
        'dt' => 'username',
        'field' => 'erp_username'
    ),
    array(
        'db' => 'e.erp_database',
        'dt' => 'database',
        'field' => 'erp_database'
    ),
    array(
        'db' => 'e.erp_instance',
        'dt' => 'instance',
        'field' => 'erp_instance'
    ),
    array(
        'db' => 'e.erp_error_mail',
        'dt' => 'error_mail',
        'field' => 'erp_error_mail'
    ),

    array(
        'db' => 'e.erp_name',
        'dt' => 'name',
        'field' => 'erp_name'
    ),
    array(
        'db' => 'e.erp_active',
        'dt' => 'active',
        'field' => 'erp_active'
    ),


    array(
        'db' => 'e.erp_connection_id',
        'dt' => 'form',
        'formatter' => function ($d, $row) {
            $active = $row['erp_active'];

            if(strcmp(strtolower($active), "yes") == 0)
            {
                $activateButton='<button   id="a'.$d.'" class="btn btn-danger" onclick="deactivateButtonClicked('.$d.');" style="width:100px">Deactive</button>';
            }
            else{
                $activateButton= '
			<button  id="a'.$d.'"  class="btn btn-success" onclick="activateButtonClicked('.$d.');" style="width:100px" >Active</button>
			';
            }

            $editButton = '<form  id="edit_' . $d . '" action="//' . HTML_PATH . '/cop/backend/modules/erpConnection/views/new_erp_connection.php" method="post" style="display:inline;">
                <input type="hidden" name="erpConnectionID" value="' . $d . '">
                <input type="submit" class="btn btn-primary" value="Edit" "> 
            </form>';

            $erpName = strtolower(trim(($row['erp_name'])));
            $testButton='';

            if(strcmp($erpName, "sap") == 0){
                $testButton = '<div style="margin-top:2px;"> <a  target="_blank" href= "//'. HTML_PATH.'/cop/backend/modules/erpConnection/views/sap_service_layer_tester.php" style="margin-top:2px;" class="btn btn-invoice btn-block"> Test</a> </div>';
            }

            return $activateButton . $editButton . $testButton;

        },
        'field' => 'erp_connection_id'
    )



);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM ERP_Connection as e";
$where = ''; // Add any specific where clauses if needed


require(ROOT . 'backend/core/controllers/ssp2.class.php');

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>
