<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

include_once('../../../../param.php');
//require_once(ROOT.'libs/emailer/PHPMailer/Exception.php');
//require_once(ROOT.'libs/emailer/PHPMailer/PHPMailer.php');
//require_once(ROOT.'libs/emailer/PHPMailer/SMTP.php');

include_once(ROOT . "libs/emailer/PHPMailer8/vendor/autoload.php");

$tenders  = false;
$orders   = false;
$invoices = false;
$receipts = false;
$returns  = false;
$waybills = false;

$SMTPCredentialsFromDB  = false;
$SMTPCredentialsFromB2B = false;

$emailTO = "aspanos@coprime.co;";

if(!$SMTPCredentialsFromDB && !$SMTPCredentialsFromB2B) {
    $mailHost     = 'caga.coprime.co';
    $mailUsername = 'info@caga.coprime.co';
    $mailPassword = 'apollon01';
    $senderEmail  = 'info@caga.coprime.co';
    $senderName   = 'Coprime Cloud';
}


global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

if($SMTPCredentialsFromDB) {
    $statement = $db->prepare("SELECT company_name FROM Companies LIMIT 1");
    $statement->execute();
    $statement->bind_result($company_name);
    if ($statement->fetch()) {
        if(strcmp($company_name,'')!=0) {
            $senderName = $company_name;
        }
    } else {
        echo $statement->error;
    }
    $statement->close();

    $statement = $db->prepare("SELECT email_host,email_from,email_username,email_password FROM Cloud_Configuration LIMIT 1");
    $statement->execute();
    $statement->bind_result($email_host, $email_from, $email_username, $email_password);
    if ($statement->fetch()) {
        $mailHost = $email_host;
        $senderEmail = $email_from;
        $mailUsername = $email_username;
        $mailPassword = $email_password;
    } else {
        echo $statement->error;
    }
    $statement->close();
}
else if($SMTPCredentialsFromB2B) {

    $statement = $db->prepare("SELECT email_host,email_from,email_username,email_password,company_name FROM B2B_Configuration LIMIT 1");
    $statement->execute();
    $statement->bind_result($email_host, $email_from, $email_username, $email_password,$company_name);
    if ($statement->fetch()) {
        $mailHost = $email_host;
        $senderEmail = $email_from;
        $mailUsername = $email_username;
        $mailPassword = $email_password;
        $senderName = $company_name;
    } else {
        echo $statement->error;
    }
    $statement->close();
}

if($tenders) {
// ---------- Tenders ----------- //
    $stm = $db->prepare("SELECT tender_id,tender_code, email,Tenders.timestamp FROM Tenders,Customers WHERE Tenders.customer_id = Customers.customer_id AND tender_id NOT IN (SELECT document_id FROM Document_Email WHERE document_type='Tenders') AND DATE(tender_date)=DATE(NOW()) ORDER BY Tenders.timestamp DESC LIMIT 100");
    $stm->execute();
    $stm->bind_result($documentID, $documentCode, $customerEmail, $timestamp);
    while ($stm->fetch()) {

        $db2 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        try {

            echo "$documentID,$documentCode,$emailTO: ";
            if (strcmp($emailTO, '') != 0) {

                $toEmails = $emailTO;
                $toEmails = trim($toEmails, '"');
                $toEmails = str_replace(",", ";", $toEmails);
                $toEmails = rtrim($toEmails, ';');
                $emails = array();
                $emails = explode(';', $toEmails);

                $attachment = ROOT . "media/pdfs/tenders/Tender$documentCode.pdf";

                if (true) {
                    foreach ($emails as $emailTo) {
                        $atCounter = substr_count($emailTo, "@");
                        if ($atCounter < 2) {

                            $mail = new PHPMailer(true);
                            $mail->SMTPDebug = 0;                                               // Enable verbose debug output
                            $mail->isSMTP();                                                    // Set mailer to use SMTP
                            $mail->Host = $mailHost;                              // Specify main and backup SMTP servers
                            $mail->SMTPAuth = true;                                             // Enable SMTP authentication
                            $mail->Username = $mailUsername;                  // SMTP username
                            $mail->Password = $mailPassword;                                     // SMTP password
                            $mail->SMTPSecure = 'tls';                                          // Enable TLS encryption, `ssl` also accepted
                            $mail->Port = 587;                                                  // TCP port to connect to
                            $mail->setFrom($senderEmail, $senderName);    //Recipients
                            $mail->addAddress($emailTo);
                            // $mail->addCC($emailCC);
                            if (file_exists($attachment)) {
                                $mail->addAttachment($attachment);
                            }
                            $mail->CharSet = 'UTF-8';
                            $mail->Encoding = "base64";
                            $mail->isHTML(true);                                  // Set email format to HTML
                            $mail->Subject = "New Tender $documentCode";
                            $mail->Body = getTenderPDFForPrinting($documentID);
                            $mail->send();

                            $documentType = "Tenders";
                            $db2->set_charset("utf8");
                            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                            $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
                            $mailStmt->execute();
                            $mailStmt->close();

                            echo " Sent Email -> $emailTo<br>";
                        } else {
                            echo " Wrong Email Format ($emailTo)<br>";
                            $emailTo = "ERROR: Wrong Email Format ($emailTo) ";

                            $db2->set_charset("utf8");
                            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                            $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
                            $mailStmt->execute();
                            echo $mailStmt->error;
                            $mailStmt->close();
                        }

                    }
                    echo "<br>";
                }

            } else {
                echo " Email does not exist<br>";

                $emailTo = "ERROR: Email does not exist ";
                $documentType = "Tenders";
                $db2->set_charset("utf8");
                $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
                $mailStmt->execute();
                $mailStmt->close();

            }

        } catch (phpmailerException $e) {
            echo $e->errorMessage(); //Pretty error messages from PHPMailer
        } catch (Exception $ex) {

            $emailTo = "ERROR: $ex ";
            $documentType = "Tenders";
            $db2->set_charset("utf8");
            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
            $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
            $mailStmt->execute();
            $mailStmt->close();
        }
    }
    $stm->close();

// -------------- Tenders / ------------ //
}

if($orders)
{
// ---------- Orders ----------- //
    $stm = $db->prepare("SELECT order_id,order_code, email,Orders.timestamp FROM Orders,Customers WHERE Orders.customer_id = Customers.customer_id AND order_id NOT IN (SELECT document_id FROM Document_Email WHERE document_type='Orders') AND DATE(order_date)=DATE(NOW()) ORDER BY Orders.timestamp DESC LIMIT 100");
    $stm->execute();
    $stm->bind_result($documentID, $orderCode, $customerEmail, $timestamp);
    while ($stm->fetch()) {

        $db2 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        try {

            echo "$documentID,$orderCode,$emailTO: ";
            if (strcmp($emailTO, '') != 0) {

                $toEmails = $emailTO;
                $toEmails = trim($toEmails, '"');
                $toEmails = str_replace(",", ";", $toEmails);
                $toEmails = rtrim($toEmails, ';');
                $emails = array();
                $emails = explode(';', $toEmails);

                $attachment = ROOT . "media/pdfs/orders/Order$orderCode.pdf";


                if (true) {
                    foreach ($emails as $emailTo) {
                        $atCounter = substr_count($emailTo, "@");
                        if ($atCounter < 2) {

                            $mail = new PHPMailer(true);
                            $mail->SMTPDebug = 0;                                               // Enable verbose debug output
                            $mail->isSMTP();                                                    // Set mailer to use SMTP
                            $mail->Host = $mailHost;                              // Specify main and backup SMTP servers
                            $mail->SMTPAuth = true;                                             // Enable SMTP authentication
                            $mail->Username = $mailUsername;                  // SMTP username
                            $mail->Password = $mailPassword;                                     // SMTP password
                            $mail->SMTPSecure = 'tls';                                          // Enable TLS encryption, `ssl` also accepted
                            $mail->Port = 587;                                                  // TCP port to connect to
                            $mail->setFrom($senderEmail, $senderName);    //Recipients
                            $mail->addAddress($emailTo);
                            // $mail->addCC($emailCC);
                            if (file_exists($attachment)) {
                                $mail->addAttachment($attachment);
                            }
                            $mail->CharSet = 'UTF-8';
                            $mail->Encoding = "base64";
                            $mail->isHTML(true);                                  // Set email format to HTML
                            $mail->Subject = "New Order $orderCode";
                            $mail->Body = getOrderPDFForPrinting($documentID);
                            $mail->send();


                            $documentType = "Orders";
                            $db2->set_charset("utf8");
                            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                            $mailStmt->bind_param('isss', $documentID, $orderCode, $documentType, $emailTo);
                            $mailStmt->execute();
                            $mailStmt->close();


                            echo " Sent Email -> $emailTo<br>";
                        } else {
                            echo " Wrong Email Format ($emailTo)<br>";
                            $emailTo = "ERROR: Wrong Email Format ($emailTo) ";

                            $db2->set_charset("utf8");
                            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                            $mailStmt->bind_param('isss', $documentID, $orderCode, $documentType, $emailTo);
                            $mailStmt->execute();
                            echo $mailStmt->error;
                            $mailStmt->close();
                        }

                    }
                    echo "<br>";
                }

            } else {
                echo " Email does not exist<br>";

                $emailTo = "ERROR: Email does not exist ";

                $documentType = "Orders";
                $db2->set_charset("utf8");
                $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                $mailStmt->bind_param('isss', $documentID, $orderCode, $documentType, $emailTo);
                $mailStmt->execute();
                $mailStmt->close();
            }

        } catch (phpmailerException $e) {
            echo $e->errorMessage(); //Pretty error messages from PHPMailer
        } catch (Exception $ex) {

            $emailTo = "ERROR: $ex ";

            $db2->set_charset("utf8");
            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
            $mailStmt->bind_param('isss', $documentID, $orderCode, $documentType, $emailTo);
            $mailStmt->execute();
            $mailStmt->close();
        }

    }
    $stm->close();
// -------------- Orders / ------------ //
}

if($invoices) {
// ---------- Invoices ----------- //
    $stm = $db->prepare("SELECT invoice_id,invoice_code, email,Invoices.timestamp FROM Invoices,Customers WHERE Invoices.customer_id = Customers.customer_id AND invoice_id NOT IN (SELECT document_id FROM Document_Email WHERE document_type='Invoices') AND DATE(invoice_date)=DATE(NOW()) ORDER BY Invoices.timestamp DESC LIMIT 100");
    $stm->execute();
    $stm->bind_result($documentID, $documentCode, $customerEmail, $timestamp);
    while ($stm->fetch()) {

        $db2 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        try {

            echo "$documentID,$documentCode,$emailTO: ";
            if (strcmp($emailTO, '') != 0) {

                $toEmails = $emailTO;
                $toEmails = trim($toEmails, '"');
                $toEmails = str_replace(",", ";", $toEmails);
                $toEmails = rtrim($toEmails, ';');
                $emails = array();
                $emails = explode(';', $toEmails);

                $attachment = ROOT . "media/pdfs/invoices/Invoice$documentCode.pdf";


                if (true) {
                    foreach ($emails as $emailTo) {
                        $atCounter = substr_count($emailTo, "@");
                        if ($atCounter < 2) {

                            $mail = new PHPMailer(true);
                            $mail->SMTPDebug = 0;                                               // Enable verbose debug output
                            $mail->isSMTP();                                                    // Set mailer to use SMTP
                            $mail->Host = $mailHost;                              // Specify main and backup SMTP servers
                            $mail->SMTPAuth = true;                                             // Enable SMTP authentication
                            $mail->Username = $mailUsername;                  // SMTP username
                            $mail->Password = $mailPassword;                                     // SMTP password
                            $mail->SMTPSecure = 'tls';                                          // Enable TLS encryption, `ssl` also accepted
                            $mail->Port = 587;                                                  // TCP port to connect to
                            $mail->setFrom($senderEmail, $senderName);    //Recipients
                            $mail->addAddress($emailTo);
                            // $mail->addCC($emailCC);
                            if (file_exists($attachment)) {
                                $mail->addAttachment($attachment);
                            }
                            $mail->CharSet = 'UTF-8';
                            $mail->Encoding = "base64";
                            $mail->isHTML(true);                                  // Set email format to HTML
                            $mail->Subject = "New Invoice $documentCode";
                            $mail->Body = getInvoicePDFForPrinting($documentID);
                            $mail->send();


                            $documentType = "Invoices";
                            $db2->set_charset("utf8");
                            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                            $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
                            $mailStmt->execute();
                            $mailStmt->close();


                            echo " Sent Email -> $emailTo<br>";
                        } else {
                            echo " Wrong Email Format ($emailTo)<br>";
                            $emailTo = "ERROR: Wrong Email Format ($emailTo) ";

                            $db2->set_charset("utf8");
                            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                            $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
                            $mailStmt->execute();
                            echo $mailStmt->error;
                            $mailStmt->close();
                        }

                    }
                    echo "<br>";
                }

            } else {
                echo " Email does not exist<br>";

                $emailTo = "ERROR: Email does not exist ";

                $documentType = "Orders";
                $db2->set_charset("utf8");
                $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
                $mailStmt->execute();
                $mailStmt->close();
            }

        } catch (phpmailerException $e) {
            echo $e->errorMessage(); //Pretty error messages from PHPMailer
        } catch (Exception $ex) {

            $emailTo = "ERROR: $ex ";

            $db2->set_charset("utf8");
            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
            $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
            $mailStmt->execute();
            $mailStmt->close();
        }

    }
    $stm->close();
// -------------- Invoices / ------------ //
}

if($receipts) {
// ---------- Receipts ----------- //
    $stm = $db->prepare("SELECT receipt_id,receipt_code, email,Receipts.timestamp FROM Receipts,Customers WHERE Receipts.customer_id = Customers.customer_id AND receipt_id NOT IN (SELECT document_id FROM Document_Email WHERE document_type='Receipts') AND DATE(receipt_date)=DATE(NOW()) ORDER BY Receipts.timestamp DESC LIMIT 100");
    $stm->execute();
    $stm->bind_result($documentID, $documentCode, $customerEmail, $timestamp);
    while ($stm->fetch()) {

        $db2 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        try {

            echo "$documentID,$documentCode,$emailTO: ";
            if (strcmp($emailTO, '') != 0) {

                $toEmails = $emailTO;
                $toEmails = trim($toEmails, '"');
                $toEmails = str_replace(",", ";", $toEmails);
                $toEmails = rtrim($toEmails, ';');
                $emails = array();
                $emails = explode(';', $toEmails);

                $attachment = ROOT . "media/pdfs/receipts/Receipt$documentCode.pdf";


                if (true) {
                    foreach ($emails as $emailTo) {
                        $atCounter = substr_count($emailTo, "@");
                        if ($atCounter < 2) {

                            $mail = new PHPMailer(true);
                            $mail->SMTPDebug = 0;                                               // Enable verbose debug output
                            $mail->isSMTP();                                                    // Set mailer to use SMTP
                            $mail->Host = $mailHost;                              // Specify main and backup SMTP servers
                            $mail->SMTPAuth = true;                                             // Enable SMTP authentication
                            $mail->Username = $mailUsername;                  // SMTP username
                            $mail->Password = $mailPassword;                                     // SMTP password
                            $mail->SMTPSecure = 'tls';                                          // Enable TLS encryption, `ssl` also accepted
                            $mail->Port = 587;                                                  // TCP port to connect to
                            $mail->setFrom($senderEmail, $senderName);    //Recipients
                            $mail->addAddress($emailTo);
                            // $mail->addCC($emailCC);
                            if (file_exists($attachment)) {
                                $mail->addAttachment($attachment);
                            }
                            $mail->CharSet = 'UTF-8';
                            $mail->Encoding = "base64";
                            $mail->isHTML(true);                                  // Set email format to HTML
                            $mail->Subject = "New Receipt $documentCode";
                            $mail->Body = getReceiptPDFForPrinting($documentID);
                            $mail->send();


                            $documentType = "Receipts";
                            $db2->set_charset("utf8");
                            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                            $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
                            $mailStmt->execute();
                            $mailStmt->close();


                            echo " Sent Email -> $emailTo<br>";
                        } else {
                            echo " Wrong Email Format ($emailTo)<br>";
                            $emailTo = "ERROR: Wrong Email Format ($emailTo) ";

                            $db2->set_charset("utf8");
                            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                            $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
                            $mailStmt->execute();
                            echo $mailStmt->error;
                            $mailStmt->close();
                        }

                    }
                    echo "<br>";
                }

            } else {
                echo " Email does not exist<br>";

                $emailTo = "ERROR: Email does not exist ";

                $documentType = "Orders";
                $db2->set_charset("utf8");
                $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
                $mailStmt->execute();
                $mailStmt->close();
            }

        } catch (phpmailerException $e) {
            echo $e->errorMessage(); //Pretty error messages from PHPMailer
        } catch (Exception $ex) {

            $emailTo = "ERROR: $ex ";

            $db2->set_charset("utf8");
            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
            $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
            $mailStmt->execute();
            $mailStmt->close();
        }

    }
    $stm->close();
// -------------- Receipts / ------------ //
}

if($returns) {
// ---------- Returns ----------- //
    $stm = $db->prepare("SELECT return_id,return_code, email,Returns.timestamp FROM Returns,Customers WHERE Returns.customer_id = Customers.customer_id AND return_id NOT IN (SELECT document_id FROM Document_Email WHERE document_type='Returns') AND DATE(return_date)=DATE(NOW()) ORDER BY Returns.timestamp DESC LIMIT 100");
    $stm->execute();
    $stm->bind_result($documentID, $documentCode, $customerEmail, $timestamp);
    while ($stm->fetch()) {

        $db2 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        try {

            echo "$documentID,$documentCode,$emailTO: ";
            if (strcmp($emailTO, '') != 0) {

                $toEmails = $emailTO;
                $toEmails = trim($toEmails, '"');
                $toEmails = str_replace(",", ";", $toEmails);
                $toEmails = rtrim($toEmails, ';');
                $emails = array();
                $emails = explode(';', $toEmails);

                $attachment = ROOT . "media/pdfs/returns/Return$documentCode.pdf";


                if (true) {
                    foreach ($emails as $emailTo) {
                        $atCounter = substr_count($emailTo, "@");
                        if ($atCounter < 2) {

                            $mail = new PHPMailer(true);
                            $mail->SMTPDebug = 0;                                               // Enable verbose debug output
                            $mail->isSMTP();                                                    // Set mailer to use SMTP
                            $mail->Host = $mailHost;                              // Specify main and backup SMTP servers
                            $mail->SMTPAuth = true;                                             // Enable SMTP authentication
                            $mail->Username = $mailUsername;                  // SMTP username
                            $mail->Password = $mailPassword;                                     // SMTP password
                            $mail->SMTPSecure = 'tls';                                          // Enable TLS encryption, `ssl` also accepted
                            $mail->Port = 587;                                                  // TCP port to connect to
                            $mail->setFrom($senderEmail, $senderName);    //Recipients
                            $mail->addAddress($emailTo);
                            // $mail->addCC($emailCC);
                            if (file_exists($attachment)) {
                                $mail->addAttachment($attachment);
                            }
                            $mail->CharSet = 'UTF-8';
                            $mail->Encoding = "base64";
                            $mail->isHTML(true);                                  // Set email format to HTML
                            $mail->Subject = "New Returns $documentCode";
                            $mail->Body = getReturnPDFForPrinting($documentID);
                            $mail->send();


                            $documentType = "Returns";
                            $db2->set_charset("utf8");
                            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                            $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
                            $mailStmt->execute();
                            $mailStmt->close();


                            echo " Sent Email -> $emailTo<br>";
                        } else {
                            echo " Wrong Email Format ($emailTo)<br>";
                            $emailTo = "ERROR: Wrong Email Format ($emailTo) ";

                            $db2->set_charset("utf8");
                            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                            $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
                            $mailStmt->execute();
                            echo $mailStmt->error;
                            $mailStmt->close();
                        }

                    }
                    echo "<br>";
                }

            } else {
                echo " Email does not exist<br>";

                $emailTo = "ERROR: Email does not exist ";

                $documentType = "Orders";
                $db2->set_charset("utf8");
                $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
                $mailStmt->execute();
                $mailStmt->close();
            }

        } catch (phpmailerException $e) {
            echo $e->errorMessage(); //Pretty error messages from PHPMailer
        } catch (Exception $ex) {

            $emailTo = "ERROR: $ex ";

            $db2->set_charset("utf8");
            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
            $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
            $mailStmt->execute();
            $mailStmt->close();
        }

    }
    $stm->close();
// -------------- Returns / ------------ //
}

if($waybills) {
// ---------- Waybills ----------- //
    $stm = $db->prepare("SELECT waybill_id,waybill_code, email,Waybills.timestamp FROM Waybills,Customers WHERE Waybills.customer_id = Customers.customer_id AND waybill_id NOT IN (SELECT document_id FROM Document_Email WHERE document_type='Waybills') AND DATE(waybill_date)=DATE(NOW()) ORDER BY Waybills.timestamp DESC LIMIT 100");
    $stm->execute();
    $stm->bind_result($documentID, $documentCode, $customerEmail, $timestamp);
    while ($stm->fetch()) {

        $db2 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        try {

            echo "$documentID,$documentCode,$emailTO: ";
            if (strcmp($emailTO, '') != 0) {

                $toEmails = $emailTO;
                $toEmails = trim($toEmails, '"');
                $toEmails = str_replace(",", ";", $toEmails);
                $toEmails = rtrim($toEmails, ';');
                $emails = array();
                $emails = explode(';', $toEmails);

                $attachment = ROOT . "media/pdfs/waybills/Waybill$documentCode.pdf";


                if (true) {
                    foreach ($emails as $emailTo) {
                        $atCounter = substr_count($emailTo, "@");
                        if ($atCounter < 2) {

                            $mail = new PHPMailer(true);
                            $mail->SMTPDebug = 0;                                               // Enable verbose debug output
                            $mail->isSMTP();                                                    // Set mailer to use SMTP
                            $mail->Host = $mailHost;                              // Specify main and backup SMTP servers
                            $mail->SMTPAuth = true;                                             // Enable SMTP authentication
                            $mail->Username = $mailUsername;                  // SMTP username
                            $mail->Password = $mailPassword;                                     // SMTP password
                            $mail->SMTPSecure = 'tls';                                          // Enable TLS encryption, `ssl` also accepted
                            $mail->Port = 587;                                                  // TCP port to connect to
                            $mail->setFrom($senderEmail, $senderName);    //Recipients
                            $mail->addAddress($emailTo);
                            // $mail->addCC($emailCC);
                            if (file_exists($attachment)) {
                                $mail->addAttachment($attachment);
                            }
                            $mail->CharSet = 'UTF-8';
                            $mail->Encoding = "base64";
                            $mail->isHTML(true);                                  // Set email format to HTML
                            $mail->Subject = "New Waybill $documentCode";
                            $mail->Body = getWaybillPDFForPrinting($documentID);
                            $mail->send();


                            $documentType = "Waybills";
                            $db2->set_charset("utf8");
                            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                            $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
                            $mailStmt->execute();
                            $mailStmt->close();


                            echo " Sent Email -> $emailTo<br>";
                        } else {
                            echo " Wrong Email Format ($emailTo)<br>";
                            $emailTo = "ERROR: Wrong Email Format ($emailTo) ";

                            $db2->set_charset("utf8");
                            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                            $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
                            $mailStmt->execute();
                            echo $mailStmt->error;
                            $mailStmt->close();
                        }

                    }
                    echo "<br>";
                }

            } else {
                echo " Email does not exist<br>";

                $emailTo = "ERROR: Email does not exist ";

                $documentType = "Waybills";
                $db2->set_charset("utf8");
                $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
                $mailStmt->execute();
                $mailStmt->close();
            }

        } catch (phpmailerException $e) {
            echo $e->errorMessage(); //Pretty error messages from PHPMailer
        } catch (Exception $ex) {

            $emailTo = "ERROR: $ex ";

            $db2->set_charset("utf8");
            $mailStmt = $db2->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
            $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $emailTo);
            $mailStmt->execute();
            $mailStmt->close();
        }

    }
    $stm->close();
// -------------- Waybills / ------------ //
}


function convertNumber($number){
    list($integer, $fraction) = explode(".", (string) $number);

    $output = "";

    if ($integer{0} == "-")
    {
        $output = "negative ";
        $integer    = ltrim($integer, "-");
    }
    else if ($integer{0} == "+")
    {
        $output = "positive ";
        $integer    = ltrim($integer, "+");
    }

    if ($integer{0} == "0")
    {
        $output .= "zero";
    }
    else
    {
        $integer = str_pad($integer, 36, "0", STR_PAD_LEFT);
        $group   = rtrim(chunk_split($integer, 3, " "), " ");
        $groups  = explode(" ", $group);

        $groups2 = array();
        foreach ($groups as $g)
        {
            $groups2[] = convertThreeDigit($g{0}, $g{1}, $g{2});
        }

        for ($z = 0; $z < count($groups2); $z++)
        {
            if ($groups2[$z] != "")
            {
                $output .= $groups2[$z] . convertGroup(11 - $z) . (
                    $z < 11
                    && !array_search('', array_slice($groups2, $z + 1, -1))
                    && $groups2[11] != ''
                    && $groups[11]{0} == '0'
                        ? " and "
                        : ", "
                    );
            }
        }

        $output = rtrim($output, ", ");
    }

    if ($fraction > 0)
    {
        $output .= " point";
        for ($i = 0; $i < strlen($fraction); $i++)
        {
            $output .= " " . convertDigit($fraction{$i});
        }
    }

    return $output;
}

function convertGroup($index){
    switch ($index)
    {
        case 11:
            return " decillion";
        case 10:
            return " nonillion";
        case 9:
            return " octillion";
        case 8:
            return " septillion";
        case 7:
            return " sextillion";
        case 6:
            return " quintrillion";
        case 5:
            return " quadrillion";
        case 4:
            return " trillion";
        case 3:
            return " billion";
        case 2:
            return " million";
        case 1:
            return " thousand";
        case 0:
            return "";
    }
}

function convertThreeDigit($digit1, $digit2, $digit3){
    $buffer = "";

    if ($digit1 == "0" && $digit2 == "0" && $digit3 == "0")
    {
        return "";
    }

    if ($digit1 != "0")
    {
        $buffer .= convertDigit($digit1) . " hundred";
        if ($digit2 != "0" || $digit3 != "0")
        {
            $buffer .= " ";
        }
    }

    if ($digit2 != "0")
    {
        $buffer .= convertTwoDigit($digit2, $digit3);
    }
    else if ($digit3 != "0")
    {
        $buffer .= convertDigit($digit3);
    }

    return $buffer;
}

function convertTwoDigit($digit1, $digit2){
    if ($digit2 == "0")
    {
        switch ($digit1)
        {
            case "1":
                return "ten";
            case "2":
                return "twenty";
            case "3":
                return "thirty";
            case "4":
                return "forty";
            case "5":
                return "fifty";
            case "6":
                return "sixty";
            case "7":
                return "seventy";
            case "8":
                return "eighty";
            case "9":
                return "ninety";
        }
    } else if ($digit1 == "1")
    {
        switch ($digit2)
        {
            case "1":
                return "eleven";
            case "2":
                return "twelve";
            case "3":
                return "thirteen";
            case "4":
                return "fourteen";
            case "5":
                return "fifteen";
            case "6":
                return "sixteen";
            case "7":
                return "seventeen";
            case "8":
                return "eighteen";
            case "9":
                return "nineteen";
        }
    } else
    {
        $temp = convertDigit($digit2);
        switch ($digit1)
        {
            case "2":
                return "twenty $temp";
            case "3":
                return "thirty $temp";
            case "4":
                return "forty $temp";
            case "5":
                return "fifty $temp";
            case "6":
                return "sixty $temp";
            case "7":
                return "seventy $temp";
            case "8":
                return "eighty $temp";
            case "9":
                return "ninety $temp";
        }
    }
}

function convertDigit($digit){
    switch ($digit)
    {
        case "0":
            return "zero";
        case "1":
            return "one";
        case "2":
            return "two";
        case "3":
            return "three";
        case "4":
            return "four";
        case "5":
            return "five";
        case "6":
            return "six";
        case "7":
            return "seven";
        case "8":
            return "eight";
        case "9":
            return "nine";
    }
}

function displayQty($qty,$sub){

    $unit =  ((int) ($qty/$sub));
    $subunits=$qty % $sub;
    $msg = $unit."u".$subunits."s";
    return $msg;


}

function getItemBarcode($itemID) {
    global $username, $password, $database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT barcode FROM Item_Barcode WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($code);
    while ($stm1->fetch()) {
        return $code;
    }
    $stm1->close();
    return $code;


}

function validateEMAIL($EMAIL) {
    $v = "/[a-zA-Z0-9_-.+]+@[a-zA-Z0-9-]+.[a-zA-Z]+/";

    return (bool)preg_match($v, $EMAIL);
}

function getOrderPDFForPrinting($orderID){

    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT order_code,order_date,delivery_date,salesperson_id,subtotal,grand_total,vat_amount,customer_id,company_id,order_address_id,delivery_address_id,deposit_amount,details FROM Orders WHERE order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($orderCode, $orderDate, $deliveryDate,$salespersonID,$subtotal, $grandTotal, $vatAmount,$customerID,$companyID,$orderAddressID,$deliveryAddress,$depositAmount,$details);

    while ($stm->fetch()) {

    }
    $stm->close();

    $orderDate = date_format( date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');

    if(strcmp($deliveryDate,"0000-00-00") != 0) {
        $deliveryDate = date_format(date_create_from_format('Y-m-d', $deliveryDate), 'd-m-Y');
    }
    else
    {
        $deliveryDate = "Not Set";
    }

    $depositAmount = number_format($depositAmount,2);

    $subtotal = number_format($subtotal,2);
    $grandTotal = number_format($grandTotal,2);
    $vatAmount = number_format($vatAmount,2);
    if($companyID > 100){$companyID = 1;}

    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$orderAddressID'");
    $stm->execute();
    $stm->bind_result($addressLine1, $addressLine2,$postcode,$city,$landline);

    while ($stm->fetch()) {


    }
    $stm->close();

    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$deliveryAddress'");
    $stm->execute();
    $stm->bind_result($addressLine1D, $addressLine2D,$postcodeD,$cityD,$landlineD);
    while ($stm->fetch()) {


    }
    $stm->close();

    $stm = $db->prepare("SELECT CONCAT(salesperson_code,'-',first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id='$salespersonID'");
    $stm->execute();
    $stm->bind_result($salespersonDisplayName);

    while ($stm->fetch()) {


    }
    $stm->close();



    $displayDate =$orderDate;



    $result= "



<style>


        body
        {
           font-family: Helvetica Neue, Helvetica, Arial, sans-serif;

        }

        p
        {

        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        td {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
        
             margin-left: 1.4cm;
             margin-right: 1.4cm;
        
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }

    </style>


<htmlpageheader name='myHTMLHeader1'>
  <table class='heading' >
  <tr>
  <td  valign='top' style='width:100%' align='center'>
     <p style='display:block;font-weight:bold; font-size:24px; width:100%'><center> </center></p>
  </td>
  
   </tr>
  </table>

</htmlpageheader>

<table id='table_info' style='width:100%;margin-top:0;padding-top:0;'>
        <tr>
             <td rowspan='2' valign='top' align='left' style='width:33%'>
                <h4>Order Details</h4>
                <table>
                    <tr><td>Order No: </td><td>$orderCode</td></tr>
                    <tr><td>Order Date: </td><td>$displayDate</td></tr>
                    <tr><td>Delivery Date: </td><td>$deliveryDate</td></tr>
                    <tr><td >Deposit Amount: </td><td>$depositAmount</td></tr>                   
                    <tr><td >Salesperson: </td><td>$salespersonDisplayName</td></tr>
                    <tr><td >&nbsp </td><td></td></tr>
                </table>
            </td>
                     <td rowspan='1' valign='top' align='center' style='width:33%'>
                      <h4 >Billing Address</h4>
                <table>
                    <tr><td style='text-align: center'>Account Code: $customerCode</td></tr>
                    <tr><td style='text-align: center'>$customerName</td></tr>
                    <tr><td style='text-align: center'>$addressLine1</td></tr>
                    <tr><td style='text-align: center'>$addressLine2</td></tr>
                    <tr><td style='text-align: center'>$city</td></tr>
                    <tr><td style='text-align: center'>$landline</td></tr>
                </table>
            </td>
             <td rowspan='1' valign='top' align='right' style='width:33%'>
              <h4 >Delivery Address</h4>
                <table>
                    <tr><td style='text-align: right'>Account Code: $customerCode</td></tr>
                    <tr><td style='text-align: right'>$customerName</td></tr>
                    <tr><td style='text-align: right'>$addressLine1D</td></tr>
                    <tr><td style='text-align: right'>$addressLine2D</td></tr>
                    <tr><td style='text-align: right'>$cityD</td></tr>
                    <tr><td style='text-align: right'>$landlineD</td></tr>
                </table>
            </td>

        </tr>

    </table>

   <div id='item_table' style='height:500px;'>

   <div style='height:500px;'>

     <table repeat_header='1' id='tableHeader' style='border-top: 1px solid #a7c6f9;border-bottom: 1px solid #a7c6f9;padding:0;background:#cadbf7;'>
            <tr>
                <td style='width:5%' ><b>No.</b></td>
                <td style='width:8%'><b>Code</b></td>
                <td style='width:8%'><b>SKU</b></td>
                <td style='width:20%'><b>Description</b></td>
                <td style='width:10%;text-align:center;'><b>UOM</b></td>
                <td style='width:8%;text-align: right'><b>Quantity</b></td>
                <td style='width:9%;text-align: right'><b>Unit Price</b></td>
                <td style='width:10%;text-align: right'><b>Line Disc.</b></td>
                <td style='width:10%;text-align:center;'><b>VAT</b></td>
                <td style='width:12%;text-align: right'><b>Total</b></td>
            </tr>
            

            </table>


            <table style='overflow:hidden;width:100%'>";

    $vatsArray = Array();
    $stm = $db->prepare("SELECT vat_id,vat_code,percentage FROM Vats");
    $stm->execute();
    $stm->bind_result($vatID,$vatCode,$percentage);
    while ($stm->fetch()) {
        $vatObject="";
        $vatObject->id=$vatID;
        $vatObject->code=$vatCode;
        $vatObject->percentage=$percentage;
        $vatObject->vatAmount=0;
        $vatObject->goods=0;
        array_push($vatsArray,$vatObject);
    }
    $stm->close();






    $counter = 0;
    $stm = $db->prepare("SELECT Order_Item.item_id,Items.sales_units,qty,unit_price,Items.vat_id,Vats.vat_code,Order_Item.vat_amount,item_code,name,description,Items.item_sku,Order_Item.line_discount FROM Order_Item,Items,Vats WHERE Vats.vat_id = Order_Item.vat_id AND Order_Item.item_id=Items.item_id AND Order_Item.order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($itemID, $uom,$qty, $unitPrice, $vatID, $vatCode,$vatLineAmount,$itemCode, $name,$description,$itemSKU,$lineDiscount);

    $unitPrice = number_format($unitPrice,2);

    while ($stm->fetch()) {
        $counter++;
        $lineTotal = $unitPrice * $qty;

        $unitPrice = number_format($unitPrice,2);
        $lineTotal = number_format($lineTotal,2);
        $lineDiscount = number_format($lineDiscount,2);

        $result.= "<tr style='margin-top:4px;'>
                <td style='width:5%;font-size:12px'><b>$counter</b></td >
                <td style='width:8%;font-size:12px' > $itemCode  </td >
                <td style='width:8%;font-size:12px' > $itemSKU  </td >
                <td style='width:20%;font-size:12px'> $name </td >
                 <td style='width:10%;text-align:center;font-size:12px;'> $uom</td >
                <td style='width:8%;text-align:right;font-size:12px;'  > $qty</td >
                <td style='width:9%;text-align:right;font-size:12px' > $unitPrice</td >
                <td style='width:10%;text-align:right;font-size:12px' > $lineDiscount</td >
                <td style='width:10%;text-align:center;font-size:12px'> $vatCode</td >
                <td style='width:12%;text-align:right;font-size:12px'  > $lineTotal</td >
            </tr >";



        $result.= "<tr><td></td><td colspan='7' style='font-size:11px'>$description</td></tr>";



        foreach($vatsArray as $vatObject)
        {
            if($vatObject->id==$vatID)
            {
                $vatObject->vatAmount+=$vatLineAmount;
                $vatObject->goods+=$lineTotal;
            }
        }

    }
    $stm->close();

    if(isset($details) && strcmp($details,"") != 0) {
        $result .=
            "  </table>
  
  <p style='font-size: 12px;'>Order Notes: $details </p>

        </div>";
    }
    else{
        $result .=
            "  </table> 

        </div>";
    }



    $result.=
        "




<htmlpagefooter name='myFooter1'>

<br>
 <div id='invoice_total' style='margin-top:40px;border-top: 1px solid #222;border-bottom: 1px solid #222;'>

           <table style='width: 100%;border-top: 1px solid #222;border-bottom: 1px solid #222;'>
             <tr>
               <td style='width:50%;'>

               <table>
                  <tr>
                    <td style='text-align:center'>
                     <p style='display: inline;text-align:center;'><b> VAT Summary</b></p>
                    </td>
                 </tr>
                 </table>
                 <table>
                 <tr>
                   <td style='width:25%;text-align:center;'>
                       <p> Code</p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p > %</p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p > Goods:</p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p> VAT</p>
                   </td>
                 </tr>";


    foreach($vatsArray as $vatObject) {

        if($vatObject->goods>0) {

            $vatObject->goods = number_format($vatObject->goods,2);
            $vatObject->vatAmount = number_format($vatObject->vatAmount,2);
            $result .= "<tr>
                <td style='width:25%;font-size:12px;text-align:center;'> $vatObject->code</td >
                <td style='width:25%;font-size:12px;text-align:center;' > $vatObject->percentage  </td >
                <td style='width:25%;font-size:12px;text-align:center;'>  $vatObject->goods </td >
                 <td style='width:25%;text-align:center;font-size:12px;'> $vatObject->vatAmount</td >
            </tr >";
        }

    }


    $result.="
               </table>

              </td>
              <td style='width:20%'></td>
              <td  style='width:30%;'>
               <table>
                <tr>
                    <td style='text-align:right;font-weight:bold;'> Subtotal</td>
                    <td style='text-align:right;' >$subtotal</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Vat</td>
                    <td style='text-align:right;' >$vatAmount</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Grand Total</td>
                    <td style='text-align:right;' >$grandTotal</td>
                </tr>
            </table>
              </td>
            </tr>
          </table>


        </div>

        <div>
          <p style='margin-top:5px;font-size:10px;font-family: Helvetica Neue, Helvetica, Arial, sans-serif'> Powered by Coprime Mobile Commerce: 25-311504 </p>
        </div>


            </htmlpagefooter>



";


    return $result;
}

function getInvoicePDFForPrinting($orderID){
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }


    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT invoice_code,invoice_date,invoice_type,due_date,paymenttype_id,salesperson_id,subtotal,grand_total,vat_amount,customer_id,company_id,invoice_address_id,delivery_address_id,discount_amount FROM Invoices WHERE invoice_id='$orderID'");
    $stm->execute();
    $stm->bind_result($orderCode, $orderDate, $invoiceType,$dueDate, $paymentTypeID,$salespersonID,$subtotal, $grandTotal, $vatAmount,$customerID,$companyID,$orderAddressID,$deliveryAddress,$discountDocAmount);

    while ($stm->fetch()) {


    }
    $stm->close();

    $orderDate = date_format( date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');
    if(strcmp($dueDate,"0000-00-00") == 0)
    {
        $dueDate = "";
    }
    else {
        $dueDate = date_format(date_create_from_format('Y-m-d', $dueDate), 'd-m-Y');
    }

    $subtotal=$subtotal -$discountDocAmount;

    $subtotal = number_format($subtotal,2);
    $grandTotal = number_format($grandTotal,2);
    $vatAmount = number_format($vatAmount,2);


    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$orderAddressID'");
    $stm->execute();
    $stm->bind_result($addressLine1, $addressLine2,$postcode,$city,$landline);

    while ($stm->fetch()) {


    }
    $stm->close();

    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$deliveryAddress'");
    $stm->execute();
    $stm->bind_result($addressLine1D, $addressLine2D,$postcodeD,$cityD,$landlineD);
    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT name FROM PaymentTypes WHERE paymenttype_id='$paymentTypeID'");
    $stm->execute();
    $stm->bind_result($paymentType);

    while ($stm->fetch()) {


    }
    $stm->close();

    $stm = $db->prepare("SELECT salesperson_code FROM SalesPersons WHERE salesperson_id='$salespersonID'");
    $stm->execute();
    $stm->bind_result($salespersonDisplayName);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT CONCAT(warehouse_code,' - ',name) FROM Warehouses,Invoice_Item WHERE Warehouses.warehouse_id=Invoice_Item.warehouse_id AND invoice_id=$orderID");
    $stm->execute();
    $stm->bind_result($warehouseDisplay);

    while ($stm->fetch()) {


    }
    $stm->close();
    $displayDate =$orderDate;



    $result= "



<style>


        body
        {


        }

        p
        {

        }

        #wrapper
        {
            width:190mm;
            margin:0 10mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        td {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }

    </style>



  <table style='width:100%' >
  <tr>

  <td  valign='top' align='center'>
     <p style='font-weight:bold; font-size:22px;'>$invoiceType Invoice</p>
  </td>
  
   </tr>
  </table>



<table id='table_info' style='width:100%;margin-top:0;padding-top:0;'>
        <tr>
             <td rowspan='2' valign='top' align='left' style='width:33%'>
                <h4>Invoice Details</h4>
                <table>
                    <tr><td>Invoice No: </td><td>$orderCode</td></tr>
                    <tr><td>Invoice Date: </td><td>$displayDate</td></tr>
                    <tr><td >Due Date : </td><td>$dueDate</td></tr>
                    <tr><td >Payment Method: </td><td>$paymentType</td></tr>
                    <tr><td >Salesperson Code: </td><td>$salespersonDisplayName</td></tr>
                    <tr><td >Store : </td><td>$warehouseDisplay</td></tr>
                </table>
            </td>
                     <td rowspan='1' valign='top' align='center' style='width:33%'>
                      <h4 >Billing Address</h4>
                <table>
                  <tr><td >Account Code: $customerCode</td></tr>
                    <tr><td style='text-align: center'>$customerName</td></tr>
                    <tr><td style='text-align: center'>$addressLine1</td></tr>
                    <tr><td style='text-align: center'>$addressLine2</td></tr>
                    <tr><td style='text-align: center'>$city</td></tr>
                    <tr><td style='text-align: center'>$landline</td></tr>
                </table>
            </td>
             <td rowspan='1' valign='top' align='right' style='width:33%'>
              <h4 >Delivery Address</h4>
                <table>
                    <tr><td>Account Code: $customerCode</td></tr>
                    <tr><td style='text-align: right'>$customerName</td></tr>
                    <tr><td style='text-align: right'>$addressLine1D</td></tr>
                    <tr><td style='text-align: right'>$addressLine2D</td></tr>
                    <tr><td style='text-align: right'>$cityD</td></tr>
                    <tr><td style='text-align: right'>$landlineD</td></tr>
                </table>
            </td>

        </tr>

    </table>

   <div id='item_table' style='height:500px;'>

   <div style='height:500px;'>

     <table repeat_header='1' id='tableHeader' style='border-top: 1px solid #222222;border-bottom: 1px solid #222222;background:#f5f8ff;padding-top:3px;padding-bottom:3px;'>
            <tr>";

    global $showDiscount;

    $result .="
                <td style='font-size:13px;width:5%text-align:left' ><b>No.</b></td>
                <td style='font-size:13px;width:15%'><b>Code</b></td>";

    if($showDiscount)
    {
        $result .="  <td style='font-size:13px;width:20%'><b>Description</b></td> ";
    }
    else{
        $result .="  <td style='font-size:13px;width:25%'><b>Description</b></td> ";
    }

    $result .="
                <td style='font-size:13px;width:10%;text-align:center;'><b>UOM</b></td>
                <td style='font-size:13px;width:8%;text-align: right'><b>Qty</b></td>
                <td style='font-size:13px;width:15%;text-align: right'><b>Price</b></td>
                <td style='font-size:13px;width:10%;text-align:center;'><b>VAT</b></td>";

    global $showDiscount;
    if($showDiscount)
    {
        $result .= "<td style='font-size:13px;width:5%;text-align:center;'><b>Disc.</b></td>";
    }
    $result .=  "
                <td style='font-size:13px;width:11%;text-align: right'><b>";
    if($showDiscount)
    {$result .= "Net ";}
    $result .="Total</b></td>
            </tr>
            </table>


            <table style='overflow:hidden;width:100%'>

            ";

    $vatsArray = Array();
    $stm = $db->prepare("SELECT vat_id,vat_code,percentage FROM Vats");
    $stm->execute();
    $stm->bind_result($vatID,$vatCode,$percentage);
    while ($stm->fetch()) {
        $vatObject="";
        $vatObject->id=$vatID;
        $vatObject->code=$vatCode;
        $vatObject->percentage=$percentage;
        $vatObject->vatAmount=0;
        $vatObject->goods=0;
        array_push($vatsArray,$vatObject);
    }
    $stm->close();



    $lineTotalCounter =0;
    $lineDiscountCounter = 0;
    $globalDiscountCounter = 0;



    $counter = 0;
    $stm = $db->prepare("SELECT Invoice_Item.item_id,Items.sales_units,qty,unit_price,Items.vat_id,Vats.vat_code,Invoice_Item.vat_amount,item_code,name,subunits,line_discount,global_discount FROM Invoice_Item,Items,Vats WHERE Vats.vat_id = Invoice_Item.vat_id AND Invoice_Item.item_id=Items.item_id AND Invoice_Item.invoice_id='$orderID'");
    $stm->execute();
    $stm->bind_result($itemID, $uom,$qty, $unitPrice, $vatID, $vatCode,$vatLineAmount,$itemCode, $name,$subunits,$lineDiscount,$globalDiscount);

    $unitPrice = number_format($unitPrice,2);

    while ($stm->fetch()) {
        $counter++;
        $lineTotal = $unitPrice * $qty/$subunits;
        $lineTotalCounter += $lineTotal;
        $lineDiscountCounter += $lineDiscount;
        $globalDiscountCounter += $globalDiscount;


        $unitPrice = number_format($unitPrice,2);
        $lineTotal = number_format($lineTotal,2);

        $dispayQty= displayQty($qty,$subunits);
        $barcode=getItemBarcode($itemID);

        $name .=" - ".$barcode;

        global $showDiscount;

        $result.= "<tr>
                <td style='width:5%;font-size:12px'> $counter</td >
                <td style='width:15%;font-size:12px' > $itemCode  </td >";

        if($showDiscount)
        {
            $result .= " <td style='width:20%;font-size:12px'> $name </td >";
        }
        else
        {
            $result .= " <td style='width:25%;font-size:12px'> $name </td >";
        }
        $result .= "
               
                 <td style='width:10%;text-align:center;font-size:12px;'> $uom</td >
                <td style='width:8%;text-align:right;font-size:12px;'  > $dispayQty</td >
                <td style='width:15%;text-align:right;font-size:12px' > $unitPrice</td >
                <td style='width:10%;text-align:center;font-size:12px'> $vatCode</td >
                ";
        global $showDiscount;
        $netlineTotal=$lineTotal;

        if($showDiscount)
        {
            $discountPercentage = round($lineDiscount/($unitPrice*$qty/$subunits) * 100,2);

            if($discountPercentage==0)
            {
                $result .= "<td style='width:5%;text-align:right;font-size:12px'></td>";
            }
            else
            {
                $result .= "<td style='width:5%;text-align:right;font-size:12px'>$discountPercentage%</td>";
            }


            $netlineTotal = $unitPrice*$qty/$subunits -$lineDiscount;
            $netlineTotal = number_format($netlineTotal,2);


        }
        $result .=  "
                <td style='width:10%;text-align:right;font-size:12px' > $netlineTotal</td >
            </tr>";

        foreach($vatsArray as $vatObject)
        {
            if($vatObject->id==$vatID)
            {
                $vatObject->vatAmount+=$vatLineAmount;
                $vatObject->goods+=$netlineTotal;
            }
        }

    }
    $stm->close();


    $totalDiscount = $lineDiscountCounter + $globalDiscountCounter;

    $totalDiscount = number_format((float)$totalDiscount, 2, '.', '');
    $lineTotalCounter = number_format((float)$lineTotalCounter, 2, '.', '');

    $result.=
        "  </table>

        </div>";

    $result.=
        "




<htmlpagefooter name='myFooter1'>

<br>

 <div id='invoice_total' style='margin-top:20px;border-top: 1px solid #222;border-bottom: 1px solid #222;'>

           <table style='width: 100%'>
             <tr>
               <td style='width:50%;'>

               <table>
                  <tr>
                    <td style='text-align:center'>
                     <p style='display: inline;text-align:center;'><b> VAT Summary</b></p>
                    </td>
                 </tr>
                 </table>
                 <table>
                 <tr>
                   <td style='width:25%;text-align:center;'>
                       <p> Code</p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p > %</p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p > Goods:</p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p> VAT</p>
                   </td>
                 </tr>";


    foreach($vatsArray as $vatObject) {

        if($vatObject->goods>0) {

            $vatObject->goods = number_format($vatObject->goods,2);
            $vatObject->vatAmount = number_format($vatObject->vatAmount,2);
            $result .= "<tr>
                <td style='width:25%;font-size:12px;text-align:center;'> $vatObject->code</td >
                <td style='width:25%;font-size:12px;text-align:center;' > $vatObject->percentage  </td >
                <td style='width:25%;font-size:12px;text-align:center;'>  $vatObject->goods </td >
                 <td style='width:25%;text-align:center;font-size:12px;'> $vatObject->vatAmount</td >
            </tr >";
        }

    }

    if($showDiscount)
    {
        $result .= "
         </table>
        <td style='width:30%;border-left: 1px solid #222222;border-right:1px solid #222222;'>

               <table>
                  <tr>
                    <td style='text-align:center'>
                     <p style='display: inline;text-align:center;'><b> Total Discount</b></p>
                    </td>
                 </tr>
                 </table>
                 <table>
                 <tr>
                   <td style='width:25%;text-align:center;'>
                       <p> <b>Total Goods</b></p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p ><b>Discount</b></p>
                   </td>                   
                 </tr>
                 <tr>
                   <td style='width:25%;text-align:center;'>
                       <p style='font-size:12px;'> $lineTotalCounter</p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p style='font-size:12px;'> $totalDiscount</p>
                   </td>                   
                 </tr>
                 </table>   
        ";
    }



    $result.="
              

              </table>

              </td>
              <td style='width:20%'></td>
              <td  style='width:30%;'>
               <table>
                <tr>
                    <td style='text-align:right;font-weight:bold;'> Subtotal</td>
                    <td style='text-align:right;' >$subtotal</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Vat</td>
                    <td style='text-align:right;' >$vatAmount</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Grand Total</td>
                    <td style='text-align:right;' >$grandTotal</td>
                </tr>
            </table>
              </td>
            </tr>
          </table>


        </div>

        <div>
          <p style='margin-top:5px;font-size:10px;font-family: Helvetica Neue, Helvetica, Arial, sans-serif'> Powered by Coprime Mobile Commerce: 25-311504 </p>
        </div>


            </htmlpagefooter>




";


    return $result;
}

function getReturnPDFForPrinting($returnID){
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }


    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT  return_code, company_id, customer_id, salesperson_id, paymenttype_id, order_id, subtotal, grand_total, vat_amount, discount_amount, return_address_id, return_date, details, status,  global_discount_percentage, return_type FROM Returns WHERE return_id=$returnID");
    $stm->execute();
    $stm->bind_result($returnCode, $companyID, $customerID,$salespersonID, $paymentTypeID,$orderID,$subtotal, $grandTotal, $vatAmount,$discountDocAmount, $returnAddressID, $returnDate, $detail,$status, $globalDiscountPercentage, $returntype);

    while ($stm->fetch()) {


    }
    $stm->close();

    $returnDate = date_format( date_create_from_format('Y-m-d', $returnDate), 'd-m-Y');


    $subtotal=$subtotal -$discountDocAmount;

    $subtotal = number_format($subtotal,2);
    $grandTotal = number_format($grandTotal,2);
    $vatAmount = number_format($vatAmount,2);


    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$returnAddressID'");
    $stm->execute();
    $stm->bind_result($addressLine1, $addressLine2,$postcode,$city,$landline);

    while ($stm->fetch()) {


    }
    $stm->close();



    $stm = $db->prepare("SELECT name FROM PaymentTypes WHERE paymenttype_id='$paymentTypeID'");
    $stm->execute();
    $stm->bind_result($paymentType);

    while ($stm->fetch()) {


    }
    $stm->close();

    $stm = $db->prepare("SELECT salesperson_code FROM SalesPersons WHERE salesperson_id='$salespersonID'");
    $stm->execute();
    $stm->bind_result($salespersonDisplayName);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT CONCAT(warehouse_code,' - ',name) FROM Warehouses,Return_Item WHERE Warehouses.warehouse_id=Return_Item.warehouse_id AND return_id=$returnID");
    $stm->execute();
    $stm->bind_result($warehouseDisplay);

    while ($stm->fetch()) {


    }
    $stm->close();
    $displayDate =$returnDate;



    $result= "



<style>


        body
        {


        }

        p
        {

        }

        #wrapper
        {
            width:190mm;
            margin:0 10mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        td {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }

    </style>


<htmlpageheader name='myHTMLHeader1'>
  <table class='heading' style='width:100%'>
  <tr>
  
  <td  valign='top'  align='center'>
     <p style='font-weight:bold; font-size:22px;'>$returntype Return</p>
  </td>
  
   </tr>
  </table>

</htmlpageheader>

<table id='table_info' style='width:100%;margin-top:0;padding-top:0;'>
        <tr>
             <td rowspan='2' valign='top' align='left' style='width:33%'>
                <h4>Return Details</h4>
                <table>
                    <tr><td>Return No: </td><td>$returnCode</td></tr>
                    <tr><td>Return Date: </td><td>$displayDate</td></tr>
                    <tr><td >Payment Method: </td><td>$paymentType</td></tr>
                    <tr><td >Salesperson Code: </td><td>$salespersonDisplayName</td></tr>
                    <tr><td >Store : </td><td>$warehouseDisplay</td></tr>
                </table>
            </td>
            <td rowspan='1' valign='top' align='center' style='width:33%'>

            </td>
            <td rowspan='1' valign='top' align='right' style='width:33%'>
                <h4 >Return Address</h4>
                <table>
                  <tr><td >Account Code: </td><td>$customerCode</td></tr>
                    <tr><td style='text-align: right' colspan='2'>$customerName</td></tr>
                    <tr><td style='text-align: right' colspan='2'>$addressLine1</td></tr>
                    <tr><td style='text-align: right' colspan='2'>$addressLine2</td></tr>
                    <tr><td style='text-align: right' colspan='2'>$city</td></tr>
                    <tr><td style='text-align: right' colspan='2'>$landline</td></tr>
                </table>
            </td>

        </tr>

    </table>

   <div id='item_table' style='height:500px;margin-top: 5px;'>

   <div style='height:500px;'>

     <table repeat_header='1' id='tableHeader' style='width:100%;border-top: 1px solid #222222;border-bottom: 1px solid #222222;background:#f5f8ff;padding-top:3px;padding-bottom:3px;'>
            <tr>";

    global $showDiscount;

    $result .="
                <td style='font-size:13px;width:5%;text-align:center;' ><b>No.</b></td>
                <td style='font-size:13px;width:15%;text-align: center;'><b>Code</b></td>
                <td style='font-size:13px;width:18%;text-align: center;'><b>Description</b></td>
                <td style='font-size:13px;width:8%;text-align: center;'><b>UOM</b></td>
                <td style='font-size:13px;width:6%;text-align:  center;'><b>Qty</b></td>
                <td style='font-size:13px;width:7%;text-align:  center;'><b>Cond.</b></td>
                <td style='font-size:13px;width:7%;text-align: center;'><b>Price</b></td>
                <td style='font-size:13px;width:7%;text-align: center;'><b>VAT</b></td>
                <td style='font-size:13px;width:7%;text-align:center;'><b>Disc.</b></td>
                <td style='font-size:13px;width:9%;text-align: right'><b>";
    if($showDiscount) {$result .= "Net ";}
    $result .="Total</b></td>
            </tr>
            </table>


            <table style='overflow:hidden;width:100%;'>

            ";

    $vatsArray = Array();
    $stm = $db->prepare("SELECT vat_id,vat_code,percentage FROM Vats");
    $stm->execute();
    $stm->bind_result($vatID,$vatCode,$percentage);
    while ($stm->fetch()) {
        $vatObject="";
        $vatObject->id=$vatID;
        $vatObject->code=$vatCode;
        $vatObject->percentage=$percentage;
        $vatObject->vatAmount=0;
        $vatObject->goods=0;
        array_push($vatsArray,$vatObject);
    }
    $stm->close();



    $lineTotalCounter =0;
    $lineDiscountCounter = 0;
    $globalDiscountCounter = 0;



    $counter = 0;
    $stm = $db->prepare("SELECT Return_Item.item_id,Items.sales_units,qty,unit_price,Items.vat_id,Vats.vat_code,Return_Item.vat_amount,item_code,name,subunits,line_discount,global_discount,Return_Item.status FROM Return_Item,Items,Vats WHERE Vats.vat_id = Return_Item.vat_id AND Return_Item.item_id=Items.item_id AND Return_Item.return_id='$returnID'");
    $stm->execute();
    $stm->bind_result($itemID, $uom,$qty, $unitPrice, $vatID, $vatCode,$vatLineAmount,$itemCode, $name,$subunits,$lineDiscount,$globalDiscount,$itemStatus);

    $unitPrice = number_format($unitPrice,2);

    while ($stm->fetch()) {
        $counter++;
        $lineTotal = $unitPrice * $qty/$subunits;
        $lineTotalCounter += $lineTotal;
        $lineDiscountCounter += $lineDiscount;
        $globalDiscountCounter += $globalDiscount;


        $unitPrice = number_format($unitPrice,2);
        $lineTotal = number_format($lineTotal,2);
        if($subunits == 1){
            $dispayQty = $qty;
        } else {
            $dispayQty = displayQty($qty, $subunits);

        }
        $barcode = getItemBarcode($itemID);
        $name .=" - ".$barcode;

        $discountPercentage = round($lineDiscount/($unitPrice*$qty/$subunits) * 100,2);

        if($discountPercentage==0) {$discountPercentage = '';}
        else{ $discountPercentage = $discountPercentage."%"; }

        $netlineTotal = $unitPrice*$qty/$subunits -$lineDiscount;
        $netlineTotal = number_format($netlineTotal,2);

        $result.= "<tr>
                    <td style='width:5%; font-size:12px;text-align:center;'> $counter           </td >
                    <td style='width:5%;font-size:12px;text-align:center;'> $itemCode          </td >
                    <td style='width:20%;font-size:12px;text-align:left;'  > $name              </td >
                    <td style='width:8%; font-size:12px;text-align:center;'> $uom               </td >
                    <td style='width:8%; font-size:12px;text-align:center;'> $dispayQty         </td >
                    <td style='width:8%; font-size:12px;text-align:center;'> $itemStatus        </td >
                    <td style='width:8%; font-size:12px;text-align:center;'> $unitPrice         </td >
                    <td style='width:6%;font-size:12px;text-align:center;'> $vatCode           </td >
                    <td style='width:10%; font-size:12px;text-align:right;'>$discountPercentage </td >
                    <td style='width:10%;font-size:12px;text-align:right;' > $netlineTotal      </td >
                  </tr>";

        foreach($vatsArray as $vatObject)
        {
            if($vatObject->id==$vatID)
            {
                $vatObject->vatAmount+=$vatLineAmount;
                $vatObject->goods+=$netlineTotal;
            }
        }

    }
    $stm->close();


    $totalDiscount = $lineDiscountCounter + $globalDiscountCounter;

    $totalDiscount = number_format((float)$totalDiscount, 2, '.', '');
    $lineTotalCounter = number_format((float)$lineTotalCounter, 2, '.', '');

    $result.=
        "  </table>

        </div>";

    $result.=
        "




<htmlpagefooter name='myFooter1'>
<br>
 <div id='invoice_total' style='margin-top:20px;border-top: 1px solid #222;border-bottom: 1px solid #222;'>

           <table style='width: 100%'>
             <tr>
               <td style='width:50%;'>

               <table>
                  <tr>
                    <td style='text-align:center'>
                     <p style='display: inline;text-align:center;'><b> VAT Summary</b></p>
                    </td>
                 </tr>
                 </table>
                 <table>
                 <tr>
                   <td style='width:25%;text-align:center;'>
                       <p> Code</p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p > %</p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p > Goods:</p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p> VAT</p>
                   </td>
                 </tr>";


    foreach($vatsArray as $vatObject) {

        if($vatObject->goods>0) {

            $vatObject->goods = number_format($vatObject->goods,2);
            $vatObject->vatAmount = number_format($vatObject->vatAmount,2);
            $result .= "<tr>
                <td style='width:25%;font-size:12px;text-align:center;'> $vatObject->code</td >
                <td style='width:25%;font-size:12px;text-align:center;' > $vatObject->percentage  </td >
                <td style='width:25%;font-size:12px;text-align:center;'>  $vatObject->goods </td >
                 <td style='width:25%;text-align:center;font-size:12px;'> $vatObject->vatAmount</td >
            </tr >";
        }

    }

    if($showDiscount)
    {
        $result .= "
         </table>
        <td style='width:30%;border-left: 1px solid #222222;border-right:1px solid #222222;'>

               <table>
                  <tr>
                    <td style='text-align:center'>
                     <p style='display: inline;text-align:center;'><b> Total Discount</b></p>
                    </td>
                 </tr>
                 </table>
                 <table>
                 <tr>
                   <td style='width:25%;text-align:center;'>
                       <p> <b>Total Goods</b></p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p ><b>Discount</b></p>
                   </td>                   
                 </tr>
                 <tr>
                   <td style='width:25%;text-align:center;'>
                       <p style='font-size:12px;'> $lineTotalCounter</p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p style='font-size:12px;'> $totalDiscount</p>
                   </td>                   
                 </tr>
                 </table>   
        ";
    }



    $result.="
              

              </td>
              <td style='width:20%'></td>
              <td  style='width:30%;'>
               <table>
                <tr>
                    <td style='text-align:right;font-weight:bold;'> Net</td>
                    <td style='text-align:right;' >$subtotal</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Vat</td>
                    <td style='text-align:right;' >$vatAmount</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Grand Total</td>
                    <td style='text-align:right;' >$grandTotal</td>
                </tr>
            </table>
              </td>
            </tr>
          </table>


        </div>

        <div>
          <p style='margin-top:5px;font-size:10px;font-family: Helvetica Neue, Helvetica, Arial, sans-serif'> Powered by Coprime Mobile Commerce: 25-311504 </p>
        </div>

        


            </htmlpagefooter>



";


    return $result;
}

function getReceiptPDFForPrinting($receiptID){
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }


    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT receipt_code, customer_id, company_id, salesperson_id, order_id, invoice_id, address_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, receipt_date, notes, status FROM Receipts WHERE receipt_id=$receiptID");
    $stm->execute();
    $stm->bind_result($receiptCode, $customerID,$companyID,$salespersonID,$orderID,$invoiceID,$receiptAddressID,$amount,$paymentMethod,$cashDiscount,$bank, $branch, $chequeNumber, $chequeDate,$receiptDate, $notes, $status);
    while ($stm->fetch()) {}
    $stm->close();

    $invoiceReference = array();
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT invoice_code, grand_total FROM Invoices,Invoice_Receipt WHERE Invoices.invoice_id = Invoice_Receipt.invoice_id AND receipt_id=$receiptID");
    $stm->execute();
    $stm->bind_result($invoiceCode, $invoiceTotal);
    while ($stm->fetch()) {

        $invoice ='';
        $invoice->code  = $invoiceCode;
        $invoice->total = $invoiceTotal;

        array_push($invoiceReference, $invoice);
    }
    $stm->close();

    $amount       = number_format($amount,2);
    $cashDiscount = number_format($cashDiscount,2);
    $receiptDate  = date_format( date_create_from_format('Y-m-d', $receiptDate), 'd-m-Y');
    $chequeDate   = date_format( date_create_from_format('Y-m-d',  $chequeDate), 'd-m-Y');


    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
    while ($stm->fetch()) {}
    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);
    while ($stm->fetch()) {}
    $stm->close();


    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$receiptAddressID'");
    $stm->execute();
    $stm->bind_result($addressLine1, $addressLine2,$postcode,$city,$landline);
    while ($stm->fetch()) {}
    $stm->close();


    $stm = $db->prepare("SELECT CONCAT(salesperson_code,' - ',first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id='$salespersonID'");
    $stm->execute();
    $stm->bind_result($salespersonDisplayName);
    while ($stm->fetch()) {}
    $stm->close();


    $whole = floor($amount);      // 1
    $decimal = round(($amount - $whole)*100); // .25

    $money = convertNumber($whole);
    $cents = convertNumber($decimal);

    $stringAmount = strtoupper("$money and $cents cents ");

    $result= "



<style>


        body
        {


        }

        p
        {

        }

        #wrapper
        {
            width:190mm;
            margin:0 10mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        td {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }

    </style>


<htmlpageheader name='myHTMLHeader1'>
  <table class='heading' style='width:100%' >
  <tr>

  <td  valign='top' align='center'>
     <p style='font-weight:bold; font-size:22px;'>Receipt</p>
  </td>
  
   </tr>
  </table>

</htmlpageheader>
<h4>$customerName</h4>
<table id='table_info' style='width:100%;margin-top:0;padding-top:0;'>
        <tr>
             <td rowspan='2' valign='top' align='left' style='width:33%'>
                <h4>Customer Details</h4>
                <table>

                    <tr><td >$customerName</td></tr>
                    <tr><td >$addressLine1</td></tr>
                    <tr><td >$addressLine2</td></tr>
                    <tr><td >$postcode    </td></tr>
                    <tr><td >$city        </td></tr>
                    <tr><td >$landline    </td></tr>
                </table>
            </td>
            <td rowspan='1' valign='top' align='center' style='width:33%'>
                <h4 >Additional Details</h4>
                <table>
                  <tr><td >Account Code: </td><td>$customerCode</td></tr>
                  <tr><td colspan='2'>SP: $salespersonDisplayName</td></tr>

                </table>
            </td>
            <td rowspan='1' valign='top' align='right' style='width:33%'>
                <h4 >Receipt Details</h4>
                <table>
                  <tr><td >Receipt Number: $receiptCode  </td></tr>
                  <tr><td >Receipt Date:   $receiptDate  </td></tr>
                  <tr><td >Payment Method: $paymentMethod</td></tr>
                </table>
            </td>

        </tr>

    </table>
    <br/>
    <table repeat_header='1' id='tableHeader' style='width:100%;border-top: 1px solid #222222;border-bottom: 1px solid #222222;background:#f5f8ff;padding-top:3px;padding-bottom:3px;'>
        <tr>
            <td style='font-size:13px;width:5%;text-align:center;' ><b>Receipt Amount</b></td>
        </tr>
        <tr>
            <td style='font-size:13px;width:5%;text-align:center;' ><h1 style='color: #0a6ebd'> &euro;$amount</h1></td>
        </tr>
        <tr>
            <td style='font-size:13px;width:5%;text-align:center;' >$stringAmount</td>
        </tr>
    </table>
    <br/>
    <table id='table_info' style='width:100%;margin-top:0;padding-top:0;'>
        <tr>
             <td rowspan='2' valign='top' align='left' style='width:33%'>";

    if(!empty($invoiceReference)) {
        $result .= "<h4 >Invoice Reference</h4>
                <br/>
                <table>";

        foreach ($invoiceReference as $invoice){
            $result .= " <tr><td>$invoice->code : &euro;$invoice->total</td></tr>";
        }

        $result .= " </table>";
    }

    $result.="</td>
            <td rowspan='1' valign='top' align='center' style='width:33%'>";

    if(strcmp($notes,'') != 0){
        $result .= "<h4 >Receipt Notes</h4>
                <br/>
                 <table>
                  <tr><td >$notes</td></tr>
                 </table>";
    }
    $result.="</td>
            <td rowspan='1' valign='top' align='right' style='width:33%'>";

    if($cashDiscount > 0) {
        $result .= "    <h4 >Cash Discount: &euro;$cashDiscount</h4><br/>";
    }
    if(strcmp($paymentMethod,'Cheque') == 0) {
        $result .= " <table>
                  <tr><td colspan='2'> <h4 >Cheque Details</h4> </td></tr>
                  <tr><td >Bank:         </td><td >$bank        </td></tr>
                  <tr><td >Branch:       </td><td >$branch      </td></tr>
                  <tr><td >Cheque Number:</td><td >$chequeNumber</td></tr>
                  <tr><td >Cheque Date:  </td><td >$chequeDate  </td></tr>
                 </table>";
    }
    $result.=" </td>

        </tr>

    </table>
        <div style='margin-top:80px;width:100%;'>
          &nbsp;<br>

        </div>
        <htmlpagefooter name='myFooter1'>
        <div>
          <p style='margin-top:5px;font-size:10px;font-family: Helvetica Neue, Helvetica, Arial, sans-serif'> Powered by Coprime Mobile Commerce: 25-311504 </p>
        </div>

            </htmlpagefooter>



";


    return $result;
}

function getWaybillPDFForPrinting($orderID){
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT waybill_code,waybill_date,paymenttype_id,salesperson_id,subtotal,grand_total,vat_amount,customer_id,company_id,waybill_address_id,delivery_address_id FROM Waybills WHERE waybill_id='$orderID'");
    $stm->execute();
    $stm->bind_result($orderCode, $orderDate, $paymentTypeID,$salespersonID,$subtotal, $grandTotal, $vatAmount,$customerID,$companyID,$orderAddressID,$deliveryAddress);

    while ($stm->fetch()) {


    }
    $stm->close();

    $orderDate = date_format( date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');


    $subtotal = number_format($subtotal,2);
    $grandTotal = number_format($grandTotal,2);
    $vatAmount = number_format($vatAmount,2);


    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$orderAddressID'");
    $stm->execute();
    $stm->bind_result($addressLine1, $addressLine2,$postcode,$city,$landline);

    while ($stm->fetch()) {


    }
    $stm->close();

    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$deliveryAddress'");
    $stm->execute();
    $stm->bind_result($addressLine1D, $addressLine2D,$postcodeD,$cityD,$landlineD);
    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT name FROM PaymentTypes WHERE paymenttype_id='$paymentTypeID'");
    $stm->execute();
    $stm->bind_result($paymentType);

    while ($stm->fetch()) {


    }
    $stm->close();

    $stm = $db->prepare("SELECT salesperson_code FROM SalesPersons WHERE salesperson_id='$salespersonID'");
    $stm->execute();
    $stm->bind_result($salespersonDisplayName);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT CONCAT(warehouse_code,' - ',name) FROM Warehouses,Waybill_Item WHERE Warehouses.warehouse_id=Waybill_Item.warehouse_id AND waybill_id=$orderID");
    $stm->execute();
    $stm->bind_result($warehouseDisplay);

    while ($stm->fetch()) {


    }
    $stm->close();
    $displayDate =$orderDate;



    $result= "



<style>


        body
        {


        }

        p
        {

        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        td {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }

    </style>


<htmlpageheader name='myHTMLHeader1'>
  <table class='heading' style='width:100%' >
  <tr>

  <td  valign='top' align='center'>
     <p style='font-weight:bold; font-size:22px;'>Waybill</p>
  </td>
  
   </tr>
  </table>

</htmlpageheader>

<table id='table_info' style='width:100%;margin-top:0;padding-top:0;'>
        <tr>
             <td rowspan='2' valign='top' align='left' style='width:33%'>
                <h4>Waybill Details</h4>
                <table>
                    <tr><td>Waybill No: </td><td>$orderCode</td></tr>
                    <tr><td>Waybill Date: </td><td>$displayDate</td></tr>
                    <tr><td >Payment Method: </td><td>$paymentType</td></tr>
                    <tr><td >Salesperson Code: </td><td>$salespersonDisplayName</td></tr>
                    <tr><td >Store : </td><td>$warehouseDisplay</td></tr>
                </table>
            </td>
                     <td rowspan='1' valign='top' align='center' style='width:33%'>
                      <h4 >Billing Address</h4>
                <table>
                  <tr><td >Account Code: $customerCode</td></tr>
                    <tr><td style='text-align: center'>$customerName</td></tr>
                    <tr><td style='text-align: center'>$addressLine1</td></tr>
                    <tr><td style='text-align: center'>$addressLine2</td></tr>
                    <tr><td style='text-align: center'>$city</td></tr>
                    <tr><td style='text-align: center'>$landline</td></tr>
                </table>
            </td>
             <td rowspan='1' valign='top' align='right' style='width:33%'>
              <h4 >Delivery Address</h4>
                <table>
                    <tr><td>Account Code: $customerCode</td></tr>
                    <tr><td style='text-align: right'>$customerName</td></tr>
                    <tr><td style='text-align: right'>$addressLine1D</td></tr>
                    <tr><td style='text-align: right'>$addressLine2D</td></tr>
                    <tr><td style='text-align: right'>$cityD</td></tr>
                    <tr><td style='text-align: right'>$landlineD</td></tr>
                </table>
            </td>

        </tr>

    </table>

   <div id='item_table' style='height:500px;'>

   <div style='height:500px;'>

     <table repeat_header='1' id='tableHeader' style='border-top: 1px solid #a7c6f9;border-bottom: 1px solid #a7c6f9;padding:0;background:#cadbf7;'>
            <tr>
                <td style='width:5%' ><b>No.</b></td>
                <td style='width:15%'><b>Code</b></td>
                <td style='width:25%'><b>Description</b></td>
                <td style='width:10%;text-align:center;'><b>UOM</b></td>
                <td style='width:8%;text-align: right'><b>Quantity</b></td>
                <td style='width:15%;text-align: right'><b>Unit Price</b></td>
                <td style='width:10%;text-align:center;'><b>VAT</b></td>
                <td style='width:12%;text-align: right'><b>Total</b></td>
            </tr>
            </table>


            <table style='overflow:hidden;width:100%'>

            ";

    $vatsArray = Array();
    $stm = $db->prepare("SELECT vat_id,vat_code,percentage FROM Vats");
    $stm->execute();
    $stm->bind_result($vatID,$vatCode,$percentage);
    while ($stm->fetch()) {
        $vatObject="";
        $vatObject->id=$vatID;
        $vatObject->code=$vatCode;
        $vatObject->percentage=$percentage;
        $vatObject->vatAmount=0;
        $vatObject->goods=0;
        array_push($vatsArray,$vatObject);
    }
    $stm->close();






    $counter = 0;
    $stm = $db->prepare("SELECT Waybill_Item.item_id,Items.sales_units,qty,unit_price,Items.vat_id,Vats.vat_code,Waybill_Item.vat_amount,item_code,name FROM Waybill_Item,Items,Vats WHERE Vats.vat_id = Waybill_Item.vat_id AND Waybill_Item.item_id=Items.item_id AND Waybill_Item.waybill_id='$orderID'");
    $stm->execute();
    $stm->bind_result($itemID, $uom,$qty, $unitPrice, $vatID, $vatCode,$vatLineAmount,$itemCode, $name);

    $unitPrice = number_format($unitPrice,2);

    while ($stm->fetch()) {
        $counter++;
        $lineTotal = $unitPrice * $qty;

        $unitPrice = number_format($unitPrice,2);
        $lineTotal = number_format($lineTotal,2);

        $result.= "<tr>
                <td style='width:5%;font-size:12px'> $counter</td >
                <td style='width:15%;font-size:12px' > $itemCode  </td >
                <td style='width:25%;font-size:12px'> $name </td >
                 <td style='width:10%;text-align:center;font-size:12px;'> $uom</td >
                <td style='width:8%;text-align:right;font-size:12px;'  > $qty</td >
                <td style='width:15%;text-align:right;font-size:12px' > $unitPrice</td >
                <td style='width:10%;text-align:center;font-size:12px'> $vatCode</td >
                <td style='width:12%;text-align:right;font-size:12px'  > $lineTotal</td >
            </tr >";

        foreach($vatsArray as $vatObject)
        {
            if($vatObject->id==$vatID)
            {
                $vatObject->vatAmount+=$vatLineAmount;
                $vatObject->goods+=$lineTotal;
            }
        }

    }
    $stm->close();

    $result.=
        "  </table>

        </div>";

    $result.=
        "






<htmlpagefooter name='myFooter1'>

<br>
 <div id='invoice_total' style='margin-top:40px;border-top: 1px solid #222;border-bottom: 1px solid #222;'>

           <table style='width: 100%;border-top: 1px solid #222;border-bottom: 1px solid #222;'>
             <tr>
               <td style='width:50%;'>

               <table>
                  <tr>
                    <td style='text-align:center'>
                     <p style='display: inline;text-align:center;'><b> VAT Summary</b></p>
                    </td>
                 </tr>
                 </table>
                 <table>
                 <tr>
                   <td style='width:25%;text-align:center;'>
                       <p> Code</p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p > %</p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p > Goods:</p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p> VAT</p>
                   </td>
                 </tr>";


    foreach($vatsArray as $vatObject) {

        if($vatObject->goods>0) {

            $vatObject->goods = number_format($vatObject->goods,2);
            $vatObject->vatAmount = number_format($vatObject->vatAmount,2);
            $result .= "<tr>
                <td style='width:25%;font-size:12px;text-align:center;'> $vatObject->code</td >
                <td style='width:25%;font-size:12px;text-align:center;' > $vatObject->percentage  </td >
                <td style='width:25%;font-size:12px;text-align:center;'>  $vatObject->goods </td >
                 <td style='width:25%;text-align:center;font-size:12px;'> $vatObject->vatAmount</td >
            </tr >";
        }

    }


    $result.="
               </table>

              </td>
              <td style='width:20%'></td>
              <td  style='width:30%;'>
               <table>
                <tr>
                    <td style='text-align:right;font-weight:bold;'> Subtotal</td>
                    <td style='text-align:right;' >$subtotal</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Vat</td>
                    <td style='text-align:right;' >$vatAmount</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Grand Total</td>
                    <td style='text-align:right;' >$grandTotal</td>
                </tr>
            </table>
              </td>
            </tr>
          </table>


        </div>

        <div>
          <p style='margin-top:5px;font-size:10px;font-family: Helvetica Neue, Helvetica, Arial, sans-serif'> Powered by Coprime Mobile Commerce: 25-311504 </p>
        </div>


            </htmlpagefooter>



";


    return $result;
}

function getTenderPDFForPrinting($tenderID)
{
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT tender_code,tender_date,salesperson_id,subtotal,grand_total,vat_amount,customer_id,company_id,address_line_1,valid_until,vat_i_e,currency_id FROM Tenders WHERE tender_id='$tenderID'");
    $stm->execute();
    $stm->bind_result($tenderCode, $tenderDate, $salespersonID, $subtotal, $grandTotal, $vatAmount, $customerID, $companyID, $tenderAddress,$validUntil, $vatInclude,$currencyID);
    while ($stm->fetch()) {}
    $stm->close();


    $stm = $db->prepare("SELECT currency_id,currency_code,currency_sign FROM Display_Currency WHERE currency_id='$currencyID' LIMIT 1");
    $stm->execute();
    $stm->bind_result($displayCurrencyID,$displayCurrencyCode,$displayCurrencySign);
    while ($stm->fetch()) {}
    $stm->close();

    if(strcmp($displayCurrencySign,'')==0){
        $stm = $db->prepare("SELECT currency_id,currency_code,currency_sign FROM Display_Currency ORDER BY default_currency DESC LIMIT 1");
        $stm->execute();
        $stm->bind_result($displayCurrencyID,$displayCurrencyCode,$displayCurrencySign);
        while ($stm->fetch()) {}
    }


    if(strcmp($validUntil,'0000-00-00') == 0){
        $validUntil = 'Not Set';
    } else {
        $validUntil = date_format(date_create_from_format('Y-m-d', $validUntil), 'd-m-Y');
    }

    if(strcmp($vatInclude,'i') ==0){
        $vatInclude = 'Included';
    } else {
        $vatInclude = 'Excluded';
    }
    $tenderDate = date_format( date_create_from_format('Y-m-d', $tenderDate), 'd-m-Y');
    $subtotal   = number_format($subtotal,2);
    $grandTotal = number_format($grandTotal,2);
    $vatAmount  = number_format($vatAmount,2);


    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
    while ($stm->fetch()) {}
    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);

    while ($stm->fetch()) {}
    $stm->close();


    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$tenderAddress'");
    $stm->execute();
    $stm->bind_result($addressLine1, $addressLine2,$postcode,$city,$landline);

    while ($stm->fetch()) {}
    $stm->close();



    $stm = $db->prepare("SELECT salesperson_code FROM SalesPersons WHERE salesperson_id='$salespersonID'");
    $stm->execute();
    $stm->bind_result($salespersonDisplayName);

    while ($stm->fetch()) {}
    $stm->close();



    $displayDate =$tenderDate;



    $result= "



<style>


        body
        {
           font-family: Helvetica Neue, Helvetica, Arial, sans-serif;

        }

        p
        {

        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        td {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
        
             margin-left: 1.4cm;
             margin-right: 1.4cm;
        
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }

    </style>


<htmlpageheader name='myHTMLHeader1'>
  <table class='heading' >
  <tr>
  <td valign='top' style='width:30%'>
      <img style='display:block;max-width: 200px;' src='//" . HTML_PATH . "/cop/media/pdfimage/logo.png'/>
  </td>
  <td  valign='top' style='width:40%' align='center'>
     <p style='display:block;font-weight:bold; font-size:24px; width:100%'>Tender</p>
  </td>
  <td valign='top' style='width:30%' align='right'>
     <h1 class='heading' style='display:block;padding-top:2px;padding-bottom:2px;'>$line1</h1>
                <h2 class='heading'>
                    $line2<br/>
                    $line3<br/>
                    $line4<br/>
                    $line5<br/>
                    $line6<br/>
                    $line7
                </h2>
  </td>
   </tr>
  </table>

</htmlpageheader>

<table id='table_info' style='width:100%;margin-top:0;padding-top:0;'>
        <tr>
             <td rowspan='2' valign='top' align='left' style='width:33%'>
                <h4>Tender Details</h4>
                <table>
                    <tr><td>Order No: </td><td>$tenderCode</td></tr>
                    <tr><td>Order Date: </td><td>$displayDate</td></tr>
                    <tr><td>Valid Until: </td><td>$validUntil</td></tr>
                    <tr><td>VAT: </td><td>$vatInclude</td></tr>                   


                </table>
            </td>
                     <td rowspan='1' valign='top' align='center' style='width:33%'>
                      <h4 >Tender Address</h4>
                <table>
                    <tr><td style='text-align: center'>$customerName</td></tr>
                    <tr><td style='text-align: center'>$addressLine1</td></tr>
                    <tr><td style='text-align: center'>$addressLine2</td></tr>
                    <tr><td style='text-align: center'>$city</td></tr>
                    <tr><td style='text-align: center'>$landline</td></tr>
                </table>
            </td>
             <td rowspan='1' valign='top' align='right' style='width:33%'>
              <h4 >Additional Details</h4>
                <table>
                    <tr><td>Account Code: $customerCode</td></tr>
                    <tr><td style='text-align: right'>$customerName</td></tr>
                    <tr><td style='text-align: right'>Salesperson: $salespersonDisplayName</td></tr>
                    <tr><td style='text-align: right'></td></tr>
                </table>
            </td>

        </tr>

    </table>

   <div id='item_table' style='height:500px;'>

   <div style='height:500px;'>

     <table repeat_header='1' id='tableHeader' style='border-top: 1px solid #a7c6f9;border-bottom: 1px solid #a7c6f9;padding:0;background:#cadbf7;'>
            <tr>
                <td style='width:15%'><b>Item Code</b></td>
                <td style='width:20%'><b>Description</b></td>
                <td style='width:8%;text-align:center;'><b>UOM</b></td>
                <td style='width:10%; text-align:center;'><b>Qty</b></td>
                <td style='width:15%;text-align: right;'><b>Price</b></td>
                <td style='width:15%;text-align:center;'><b>VAT</b></td>
                <td style='width:15%;text-align: right;'><b>Total</b></td>
            </tr>
            </table>


            <table style='overflow:hidden;width:100%;' >

            ";

    $vatsArray = Array();
    $stm = $db->prepare("SELECT vat_id,vat_code,percentage FROM Vats");
    $stm->execute();
    $stm->bind_result($vatID,$vatCode,$percentage);
    while ($stm->fetch()) {
        $vatObject= new stdClass();
        $vatObject->id=$vatID;
        $vatObject->code=$vatCode;
        $vatObject->percentage=$percentage;
        $vatObject->vatAmount=0;
        $vatObject->goods=0;
        array_push($vatsArray,$vatObject);
    }
    $stm->close();







    $stm = $db->prepare("SELECT Tender_Item.item_id,Items.sales_units,qty,unit_price,Items.vat_id,Vats.vat_code,Tender_Item.vat_amount,item_code,name,description FROM Tender_Item,Items,Vats WHERE Vats.vat_id = Tender_Item.vat_id AND Tender_Item.item_id=Items.item_id AND Tender_Item.tender_id='$tenderID'");
    $stm->execute();
    $stm->bind_result($itemID, $uom,$qty, $unitPrice, $vatID, $vatCode,$vatLineAmount,$itemCode, $name,$description);

    $unitPrice = number_format($unitPrice,2);

    while ($stm->fetch()) {

        $lineTotal = $unitPrice * $qty;

        $unitPriceDisplay = number_format($unitPrice,2);
        $lineTotalDisplay = number_format($lineTotal,2);

        $result.= "<tr style='margin-top:4px;'>
                    <td style='width:15%; font-size:13px;'                    > $itemCode  </td >
                    <td style='width:20%; font-size:13px;'                    > $name      </td >
                    <td style='width:8%; text-align:center; font-size:13px;' > $uom       </td >
                    <td style='width:10%;  text-align:center;  font-size:13px;' > $qty       </td >
                    <td style='width:15%; text-align:right;  font-size:13px;' > $displayCurrencySign$unitPriceDisplay </td >
                    <td style='width:15%; text-align:center; font-size:13px;' > $vatCode   </td >
                    <td style='width:15%; text-align:right;  font-size:13px;' > $displayCurrencySign$lineTotalDisplay </td >
                   </tr >";



        $result.= "<tr><td colspan='7' style='font-size:14px;margin-top: 4px;'>$description</td></tr>";



        foreach($vatsArray as $vatObject)
        {
            if($vatObject->id==$vatID)
            {
                $vatObject->vatAmount+=$vatLineAmount;
                $vatObject->goods+=$lineTotal;
            }
        }

    }
    $stm->close();

    if(isset($details) && strcmp($details,"") != 0) {
        $result .=
            "  </table>
  
  <p style='font-size: 12px;'>Order Notes: $details </p>

        </div>";
    }
    else{
        $result .=
            "  </table> 

        </div>";
    }



    $result.=
        "




<htmlpagefooter name='myFooter1'>



 <div id='invoice_total' style='margin-top:20px;border-top: 1px solid #222;border-bottom: 1px solid #222;'>

           <table style='width: 100%'>
             <tr>
               <td style='width:50%;'>

               <table>
                  <tr>
                    <td style='text-align:center'>
                     <p style='display: inline;text-align:center;'><b> VAT Summary</b></p>
                    </td>
                 </tr>
                 </table>
                 <table>
                 <tr>
                   <td style='width:25%;text-align:center;'>
                       <p><b>Code</b></p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p ><b>%</b></p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p ><b>Goods:</b></p>
                   </td>
                   <td style='width:25%;text-align:center;'>
                     <p><b>VAT</b></p>
                   </td>
                 </tr>";


    foreach($vatsArray as $vatObject) {

        if($vatObject->goods>0) {

            $vatObject->goods = number_format($vatObject->goods,2);
            $vatObject->vatAmount = number_format($vatObject->vatAmount,2);
            $result .= "<tr>
                <td style='width:25%;font-size:14px;text-align:center;'> $vatObject->code</td >
                <td style='width:25%;font-size:14px;text-align:center;' > $vatObject->percentage  </td >
                <td style='width:25%;font-size:14px;text-align:center;'>  $displayCurrencySign$vatObject->goods </td >
                 <td style='width:25%;text-align:center;font-size:14px;'> $displayCurrencySign$vatObject->vatAmount</td >
            </tr >";
        }

    }


    $result.="
               </table>

              </td>
              <td style='width:20%'></td>
              <td  style='width:30%;'>
               <table>
                <tr>
                    <td style='text-align:right;font-weight:bold;'> Subtotal</td>
                    <td style='text-align:right;' >$displayCurrencySign$subtotal</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Vat</td>
                    <td style='text-align:right;' >$displayCurrencySign$vatAmount</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Grand Total</td>
                    <td style='text-align:right;' >$displayCurrencySign$grandTotal</td>
                </tr>
            </table>
              </td>
            </tr>
          </table>


        </div>

        <div>
          <p style='margin-top:5px;font-size:10px;font-family: Helvetica Neue, Helvetica, Arial, sans-serif'> Powered by Coprime Mobile Commerce: 25-311504 </p>
        </div>

        <div style='margin-top:30px;width:100%;'>
           <table style='width:100%;'>
               <tr>
                  <td style='width:50%;'>
                    <table style='width:100%;'>
                       <tr>
                       <td style='width:33%'>

                       </td>
                        <td style='border-top: 1px solid #000000;width:33%;text-align:center'>
                            <p style='font-size:11px;'>Seller Signature</p>
                       </td>
                        <td style='width:33%'>

                       </td>
                       </tr>
                    </table>
                  </td>
                 <td style='width:50%;'>
                    <table style='width:100%;'>
                       <tr>
                       <td style='width:33%'>

                       </td>
                        <td style='border-top: 1px solid #000000;width:33%;text-align:center'>
                            <p style='font-size:11px;'>Buyer Signature</p>
                       </td>
                        <td style='width:33%'>

                       </td>
                       </tr>
                    </table>
                  </td>
              </tr>
           </table>

        </div>


            <table width='100%' style='vertical-align: bottom; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 8pt;
                color: #000000;  '><tr>
                <td width='33%'><span style=''>{DATE d-m-Y}</span></td>
                <td width='33%' align='center' style=''>{PAGENO} of {nbpg}</td>
                <td width='33%' style='text-align: right; '>$tenderCode</td>
                </tr></table>
            </htmlpagefooter>



";


    return $result;
}
?>