<?php
include_once("../../../../param.php");
$companyID = $_SESSION['companyID'];

if(isset($_POST['date']) && strcmp($_POST['date'],'')!=0){
    $dateVar = $_POST['date'];
    $where = " WHERE DATE(timestamp) >= DATE('$dateVar') ";
} else {
    $dateVar = date('Y-m-d',strtotime(date('Y-m-d') . "-30 days"));
    $where = " WHERE DATE(timestamp) >= DATE('$dateVar') ";
}

if(isset($_POST['date2']) && strcmp($_POST['date2'],'')!=0){
    $dateVar2 = $_POST['date2'];
    $where .= " AND DATE(timestamp) <= DATE('$dateVar2') ";
} else {
    $dateVar2 = date('Y-m-d');
    $where .= " AND DATE(timestamp) <= DATE('$dateVar2') ";
}
if(strcmp($dateVar,$dateVar2)!=0){
    $displayDate = "Range: ".date_format( date_create_from_format('Y-m-d', $dateVar), 'd-m-Y')." - ".date_format( date_create_from_format('Y-m-d', $dateVar2), 'd-m-Y');
} else {
    $displayDate = "Date: ".date_format( date_create_from_format('Y-m-d', $dateVar), 'd-m-Y');

}


if(isset($_POST['errors']) && strcmp($_POST['errors'],'')!=0){
    if(strcmp($_POST['errors'],'yes')==0){
        $showingErrors = true;
        $errorVar = 'no';
        $where = " WHERE status < 1 ";
        $errorFilterClass = 'primary';
        $errorFilterLabel = 'Show All (By Date)';
        $displayDate = "DOCUMENT ERRORS";
    } else {
        $showingErrors = false;
        $errorVar = 'yes';
        $errorFilterClass = 'danger';
        $errorFilterLabel = 'Filter Errors';
    }
} else {
    $showingErrors = false;
    $errorVar = 'yes';
    $errorFilterClass = 'danger';
    $errorFilterLabel = 'Filter Errors';
}


function getDocumentsForDownload($db,$docTypes,$docType,$extraWhere){

    if(strcmp($docTypes[$docType],'Transfer')==0){
        $class = "btn-visit";
        $table = "Warehouse_Transactions";
        $fileView = "warehouse_transaction";
        $fileEdit = "warehouse_transfer";
        $codeColumn = "warehouse_transaction_code";
        $idColumn = 'warehouse_transaction_id';
        $dateColumn = 'transaction_date';
        $statusColumn = 'type';
    } else {
        $class = strtolower($docTypes[$docType]);
        $table = $docTypes[$docType] . "s";
        $codeColumn = strtolower($docTypes[$docType]) . "_code";
        $idColumn = strtolower($docTypes[$docType]) . '_id';
        $dateColumn = strtolower($docTypes[$docType]) . '_date';
        $statusColumn = 'status';
        $fileEdit = $fileView = $class;
    }
    $postArray = array();
    $result = new stdClass();
    $rows = '';

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT $idColumn,$codeColumn,$statusColumn,$dateColumn FROM $table WHERE NOT $statusColumn ='Cancelled' AND NOT $statusColumn ='Canceled' AND $idColumn NOT IN (SELECT id FROM Documents_Status_Per_File WHERE type = $docType) $extraWhere");
    $stm->execute();
    $stm->bind_result($docID,$docCode, $docStatus, $recTimestamp);
    while ($stm->fetch()) {
        array_push($postArray,$docID);

        $recTimestampSort = $recTimestamp;
        $recTimestamp = date_format( date_create_from_format('Y-m-d', $recTimestamp), 'd-m-Y');

        $buttons = '<form id="'.$docID.'" action="//' . HTML_PATH . '/cop/backend/core/views/view/view_'.$fileView.'.php" method="post" target="_blank" style="display: inline-block; margin: 2px;">
                                                        <input type="hidden" name="'.$idColumn.'" value="'.$docID.'">	           			                   
                                                        <input style="font-size:13px;width:55px;" type="submit" class="btn btn-return yearly" value="View" >
                                                    </form>';

        $buttons .= '<form id="'.$docID.'" action="//' . HTML_PATH . '/cop/backend/core/views/addedit/create_'.$fileEdit.'.php" method="post" target="_blank" style="display: inline-block; margin: 2px;">
                                                        <input type="hidden" name="'.$idColumn.'" value="'.$docID.'">
                                                        <input style="font-size:13px;width:55px;" type="submit" class="btn btn-primary" value="Edit" >
                                                    </form>';


        $rows .=  "<tr class='$class text-color-white'>";
        $rows .=  "<td><img class='custom-rounded-image ".$class." center-canvas' src='//".HTML_PATH."/cop/backend/themes/".THEME_NAME."/img/".strtolower($docTypes[$docType])."icon.png' width='30' height='30'></td>";
        $rows .=  "<td>$docTypes[$docType]</td>";
        $rows .=  "<td>$docCode</td>";
        $rows .=  "<td>$docStatus</td>";
        $rows .=  "<td data-sort='$recTimestampSort'>$recTimestamp</td>";
        $rows .=  "<td>$buttons</td>";
        $rows .=  "</tr>";
    }
    $stm->close();

    $buttonClass = str_replace('btn-','',$class);
    if(strcmp($buttonClass,'order')==0){$buttonClass='primary';}
    if(strcmp($buttonClass,'receipt')==0){$buttonClass='orange';}

    $result->button =  "<button type='button' class='btn btn-$buttonClass' id='newFile' onclick='downloadFile(0,true,$docType)' style='display: inline-block; margin: 2px;'>Export $docTypes[$docType]s &nbsp;<i class='fa fa-download'></i></button>";

    $result->docs = implode(',',$postArray);
    $result->rows = $rows;

    return $result;
}



$docTypes = array('1' => 'Tender', '2' => 'Order', '3' => 'Waybill', '4' => 'Return', '5' => 'Invoice', '6' => 'Receipt', '7' => 'Transfer');
$inputsToSend = '';
$documentRows = '';
$fileButtons = '';

global $username, $password, $database;
$db = new mysqli('localhost', $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

// Tenders
$tenders = getDocumentsForDownload($db, $docTypes, 1, " LIMIT 20 ");
$inputsToSend .= "<input type='hidden' id='tendersForExport' value='$tenders->docs'>";
$fileButtons  .= $tenders->button;
$documentRows .= $tenders->rows;

// Orders
$orders = getDocumentsForDownload($db, $docTypes, 2, " LIMIT 20 ");
$inputsToSend .= "<input type='hidden' id='ordersForExport' value='$orders->docs'>";
$fileButtons  .= $orders->button;
$documentRows .= $orders->rows;

// Waybills
$waybills = getDocumentsForDownload($db, $docTypes, 3, " LIMIT 20 ");
$inputsToSend .= "<input type='hidden' id='waybillsForExport' value='$waybills->docs'>";
$fileButtons  .= $waybills->button;
$documentRows .= $waybills->rows;

// Invoices
$invoices = getDocumentsForDownload($db, $docTypes, 4, " LIMIT 20 ");
$inputsToSend .= "<input type='hidden' id='invoicesForExport' value='$invoices->docs'>";
$fileButtons  .= $invoices->button;
$documentRows .= $invoices->rows;

// Returns
$returns = getDocumentsForDownload($db, $docTypes, 5, " LIMIT 20 ");
$inputsToSend .= "<input type='hidden' id='returnsForExport' value='$returns->docs'>";
$fileButtons  .= $returns->button;
$documentRows .= $returns->rows;

// Receipts
$receipts = getDocumentsForDownload($db, $docTypes, 6, " LIMIT 20 ");
$inputsToSend .= "<input type='hidden' id='receiptsForExport' value='$receipts->docs'>";
$fileButtons  .= $receipts->button;
$documentRows .= $receipts->rows;

// Transfers
$transfers = getDocumentsForDownload($db, $docTypes, 7, " LIMIT 20 ");
$inputsToSend .= "<input type='hidden' id='transfersForExport' value='$transfers->docs'>";
$fileButtons  .= $transfers->button;
$documentRows .= $transfers->rows;


?>
<div id="main" role="main">
    <!-- Start CUSTOM CODE-->
    <!-- RIBBON -->
    <div id="ribbon" class="yearly">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Manage Document Statuses</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-4">
                <h3 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;">
                    <img style="display:inline;" class="custom-rounded-image yearly" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/invoiceicon.png" width="30" height="30">&nbsp;
                    Document Statuses
                </h3>
            </div>
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-4">
                <form method="post" action="//<?php echo HTML_PATH ?>/cop/backend/modules/documentStatusesPerFile/views/manage_document_statuses_per_file.php" style="<?php if($showingErrors){echo "display:none";}else{echo "display:block;";}?>">
                    <input type="date" name="date" class="form-control" style="width: 34%;display: inline;text-align: center;" value="<?php echo $dateVar;?>">
                    <input type="date" name="date2" class="form-control" style="width: 34%;display: inline;text-align: center;" value="<?php echo $dateVar2;?>">
                    <input type="hidden" name="errors" class="form-control" style="display: inline;text-align: center;" value="no">
                    <input type="submit" class="btn btn-waybill pull-right" value="Select Date Range" style="width: 29%;display: inline;margin-top: 0px;" />
                </form>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-2"></div>
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-2">
                <!--
                <form method="post" action="//<?php echo HTML_PATH ?>/cop/backend/modules/documentStatusesPerFile/views/manage_document_statuses_per_file.php">
                    <input type="hidden" name="errors" class="form-control" style="display: inline;text-align: center;" value="<?php echo $errorVar;?>">
                    <input type="submit" class="btn btn-<?php echo $errorFilterClass; ?> btn-block pull-right" value="<?php echo $errorFilterLabel; ?>" style="display: inline;margin-top: 2px;" />
                </form>
                -->
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-2" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Exported Documents Table </h2>
                        </header>

                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <table id="datatable_fixed_column" class="table " width="100%">

                                    <thead>
                                    <tr>
                                        <th class="hasinput" style="width:6%"></th>
                                        <th class="hasinput" style="width:15%">
                                            <input type="text" class="form-control text-center" placeholder="Filter Type" />
                                        </th>
                                        <th class="hasinput" style="width:14%">
                                            <input type="text" class="form-control text-center" placeholder="Filter Document" value="" />
                                        </th>
                                        <th class="hasinput" style="width:20%">
                                            <input type="text" class="form-control text-center" placeholder="Filter Status" />
                                        </th>
                                        <th class="hasinput" style="width:20%">
                                            <input type="text" class="form-control text-center" placeholder="Filter Reason" />
                                        </th>

                                        <th class="hasinput " style="width:10%">
                                            <input id="dateselect_filter" type="text" placeholder="Date" class="form-control datepicker text-center" data-dateformat="dd-mm-yy">
                                        </th>

                                        <th class="hasinput" style="width:40%">
                                            <center><label><b><?php echo $displayDate; ?></b></label></center>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th class='text-center'></th>
                                        <th class='text-center' >Type</th>
                                        <th class='text-center'>Document Code</th>
                                        <th class='text-center'>Status Code</th>
                                        <th class='text-center'>Reason</th>
                                        <th class='text-center' data-hide="phone">Date</th>
                                        <th class='text-center' data-hide="phone,tablet">Actions</th>
                                    </tr>
                                    </thead>
                                    <?php
                                    $docTypes = array('1'=>'Tender','2'=>'Order','3'=>'Waybill','4'=>'Return','5'=>'Invoice','6'=>'Receipt','7'=>'Transfer');

                                    global $username,$password,$database;
                                    $db = new mysqli('localhost',$username,$password,$database);
                                    if (mysqli_connect_errno()) {
                                        printf("Connect failed: %s\n", mysqli_connect_error());
                                        exit();
                                    }
                                    $db->set_charset("utf8");
                                    $stm = $db->prepare("SELECT export_id,type,export_code,MIN(status),reason,timestamp FROM Documents_Status_Per_File $where GROUP BY export_id");
                                    $stm->execute();
                                    $stm->bind_result($docID,$type,$docCode, $docStatus, $statusReason, $recTimestamp);
                                    while ($stm->fetch()) {
                                        $docType = 7;
                                        if($docStatus < 1){$color="style='background-color:firebrick;color:white;'";} else {$color="style='background-color:green;color:white;'";}
                                        $recTimestampSort = $recTimestamp;
                                        $recTimestamp = date_format( date_create_from_format('Y-m-d H:i:s', $recTimestamp), 'd-m-Y H:i');



                                        $buttons  = '<button type="button" class="btn btn-primary" id="deleteButton'.$docID.'" onclick="viewRecords('.$docID.');" style="display: inline-block; margin: 2px;">View Records &nbsp;&nbsp;<i class="fa fa-eye"></i></button>';
                                        $buttons .= '<button type="button" class="btn btn-invoice" id="deleteButton'.$docID.'" onclick="downloadFile('.$docID.',false,'.$type.');" style="display: inline-block; margin: 2px;">Download File &nbsp;<i class="fa fa-download"></button>';

                                        echo "<tr $color>";
                                        echo "<td><img class='custom-rounded-image center-canvas' src='//".HTML_PATH."/cop/backend/themes/smartadmin/img/".strtolower($docTypes[$docType])."icon.png' width='30' height='30'></td>";
                                        echo "<td>File</td>";
                                        echo "<td>$docCode</td>";
                                        echo "<td>$docStatus</td>";
                                        echo "<td>$statusReason</td>";
                                        echo "<td data-sort='$recTimestampSort'>$recTimestamp</td>";
                                        echo "<td>$buttons</td>";
                                        echo "</tr>";
                                    }
                                    $stm->close();

                                    ?>
                                </table>
                            </div>
                            <!-- end widget content -->
                        </div>
                        <!-- end widget div -->
                    </div>
                    <!-- end widget -->
                </article>
                <!-- WIDGET END -->

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-3" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Documents Not Exported </h2>
                        </header>

                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">
                                <div style="display:flex;justify-content: space-between;"><?php echo $fileButtons;?></div>

                                <table id="datatable_fixed_column2" class="table " width="100%">

                                    <thead>
                                    <tr>
                                        <th class="hasinput" style="width:6%"></th>
                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter Type" />
                                        </th>
                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter Document" value="" />
                                        </th>
                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter Status" />
                                        </th>

                                        <th class="hasinput " >
                                            <input id="dateselect_filter2" type="text" placeholder="Date" class="form-control datepicker text-center" data-dateformat="dd-mm-yy">
                                        </th>

                                        <th class="hasinput" >

                                        </th>
                                    </tr>
                                    <tr>
                                        <th class='text-center'></th>
                                        <th class='text-center' >Type</th>
                                        <th class='text-center'>Document Code</th>
                                        <th class='text-center'>Status Code</th>
                                        <th class='text-center' data-hide="phone">Date</th>
                                        <th class='text-center' data-hide="phone,tablet">Actions</th>
                                    </tr>
                                    </thead>
                                    <?php echo $documentRows;?>
                                </table>
                                <?php echo $inputsToSend;?>

                            </div>
                            <!-- end widget content -->
                        </div>
                        <!-- end widget div -->
                    </div>
                    <!-- end widget -->
                </article>
                <!-- WIDGET END -->
            </div>
            <!-- end row -->
        </section>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="drillDownModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
    <div class="modal-dialog" style="width: 80%;">
        <div class="modal-content">
            <!--                            <div class="modal-header">-->
            <!--                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>-->
            <!--                            </div>-->

            <div class="modal-body" id="drillDownModalBody" style="margin-top:5px;padding-top:5px;">

            </div>

            <footer class="modal-footer" >
                <button onclick="$('#drillDownModal').modal('toggle');" class="btn btn-default" type="button" style="margin-right:10px;">Close</button>
            </footer>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>

<script type="text/javascript">

    function deleteRecord(documentID,documentType){
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/delete/delete_document_status.php',
            data: {'documentID' : documentID,'documentType':documentType},
            success: function (result) {

                $.smallBox({
                    title: "Success!",
                    content: "Record Successfully Deleted",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });

                $('#deleteButton'+documentID).closest('tr').hide();

            }

        });
    }

    function viewRecords(exportID){
        $('#drillDownModalBody').html('<center><h2><b>Fetching Records...</b></h2></center>');
        $('#drillDownModal').modal('toggle');
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/documentStatusesPerFile/controllers/getDocumentStatusRecordsForDrillDown.php',
            data: {'exportID' : exportID},
            success: function (result) {


                $('#drillDownModalBody').html(result);
                // $('#drillDownModal').modal('toggle');

            }

        });
    }

    function getDocumentsFile(exportID,exportCode,type,tendersForExport,ordersForExport,waybillsForExport,returnsForExport,invoicesForExport,receiptsForExport,transfersForExport){

        var docs = '';
        if(type === 1){
            docs = tendersForExport;
        }
        if(type === 2){
            docs = ordersForExport;
        }
        if(type === 3){
            docs = waybillsForExport;
        }
        if(type === 4){
            docs = returnsForExport;
        }
        if(type === 5){
            docs = invoicesForExport;
        }
        if(type === 6){
            docs = receiptsForExport;
        }
        if(type === 7){
            docs = transfersForExport;
        }

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/documentStatusesPerFile/controllers/downloadDcumentsFile.php',
            data: {'exportID': exportID, 'exportCode': exportCode, 'type':type,'docs':docs},
            success: function (result) {
                console.log(result);
                var link = document.createElement("a");
                link.download = exportCode + ".txt";
                link.href = result;
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
                delete link;

            }
        });



    }

    function downloadURI(uri, name) {
        var link = document.createElement("a");
        link.download = name;
        link.href = uri;
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
        delete link;
    }

    function downloadFile(currentExportID,isNew,type){
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/documentStatusesPerFile/controllers/getNextDocumentStatusExportCodeAndID.php',
            data: {'exportID' : currentExportID,'type':'id'},
            success: function (exportID) {

                $.ajax({
                    type: "POST",
                    url: '//<?php echo HTML_PATH ?>/cop/backend/modules/documentStatusesPerFile/controllers/getNextDocumentStatusExportCodeAndID.php',
                    data: {'exportID' : exportID,'type':'code'},
                    success: function (exportCode) {

                        if(isNew === true){
                            var tendersForExport = $('#tendersForExport').val();
                            var ordersForExport = $('#ordersForExport').val();
                            var waybillsForExport = $('#waybillsForExport').val();
                            var returnsForExport = $('#returnsForExport').val();
                            var invoicesForExport = $('#invoicesForExport').val();
                            var receiptsForExport = $('#receiptsForExport').val();
                            var transfersForExport = $('#transfersForExport').val();

                            getDocumentsFile(exportID,exportCode,type,tendersForExport,ordersForExport,waybillsForExport,returnsForExport,invoicesForExport,receiptsForExport,transfersForExport)

                        } else {
                            $.ajax({
                                type: "POST",
                                url: '//<?php echo HTML_PATH ?>/cop/backend/modules/documentStatusesPerFile/controllers/getDocumentStatusExportRecordsByExportID.php',
                                data: {'exportID' : exportID},
                                success: function (result) {
                                    var documents = result.split('|');
                                    var tendersForExport = documents[0];
                                    var ordersForExport = documents[1];
                                    var waybillsForExport = documents[2];
                                    var returnsForExport = documents[3];
                                    var invoicesForExport = documents[4];
                                    var receiptsForExport = documents[5];
                                    var transfersForExport = documents[5];
                                    console.log(tendersForExport);
                                    console.log(documents);

                                    getDocumentsFile(exportID,exportCode,type,tendersForExport,ordersForExport,waybillsForExport,returnsForExport,invoicesForExport,receiptsForExport,transfersForExport)

                                }

                            });
                        }

                    }

                });


            }

        });
    }

    $(document).ready(function() {

        pageSetUp();

        var responsiveHelper_datatable_fixed_column = undefined;

        var breakpointDefinition = {tablet : 1024, phone : 480};


        ///* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
               "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>"+
                   "t"+
                   "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
               "autoWidth" : true,"order": [[ 5, "desc" ]],});


        $("#datatable_fixed_column thead th input[type=text]").on( 'keyup change', function () {

           otable
               .column( $(this).parent().index()+':visible' )
               .search( this.value )
               .draw();

        } ).keyup();
        /* END COLUMN FILTER */

        var responsiveHelper_datatable_fixed_column2 = undefined;

        var breakpointDefinition2 = {tablet : 1024, phone : 480};

        ///* COLUMN FILTER  */
        var otable2 = $('#datatable_fixed_column2').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>"+
                "t"+
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "autoWidth" : true,"order": [[ 4, "desc" ],[ 2, "desc" ]],});


        $("#datatable_fixed_column2 thead th input[type=text]").on( 'keyup change', function () {

            otable2
                .column( $(this).parent().index()+':visible' )
                .search( this.value )
                .draw();

        } ).keyup();
        /* END COLUMN FILTER */
    })

</script>