<?php
include_once('../../../../param.php');

$screenID = trim($_GET['customScreen']);
$joinQuery = '';
$extraWhere = '';
$groupBy = '';

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT query,show_icon_on_lines,class,icon,custom_line_buttons FROM ZB_Custom_Screens WHERE custom_screen_id='$screenID' LIMIT 1");
$stm->execute();
$stm->bind_result($query,$showIconOnLines,$class,$icon,$customLineButtons);
while ($stm->fetch()) {}
$stm->close();

$customizedFields = array();
$stm = $db->prepare("SELECT custom_screen_field_id, field, field_type, default_values, from_query, display_name, input_value, on_click_function, on_change_function FROM ZB_Custom_Screen_Fields WHERE custom_screen_id='$screenID'");
$stm->execute();
$stm->bind_result($custom_screen_field_id, $field, $field_type, $default_values, $from_query, $display_name, $input_value, $on_click_function, $on_change_function);
while ($stm->fetch()) {

    $customizedField = new stdClass();
    $customizedField->field = $field;
    $customizedField->field_type = $field_type;
    $customizedField->default_values = $default_values;
    $customizedField->from_query = $from_query;
    $customizedField->display_name = $display_name;
    $customizedField->input_value = $input_value;
    $customizedField->on_click_function = $on_click_function;
    $customizedField->on_change_function = $on_change_function;
    $customizedField->options_from_query = getDefaultValuesOptionsFromQuery($from_query,$display_name,$input_value);


    $customizedFields[$field] = $customizedField;
}
$stm->close();

$query = str_replace("\r"," ",$query);
$query = str_replace("  "," ",$query);

$query = str_replace("\n"," ",$query);
$query = str_replace("  "," ",$query);

$tables = array();
if(preg_match_all('/\bFROM\s+\K(?:\w+|`[^`]+`)(?:\s*,\s*(?:\w+|`[^`]+`))*(?=\s*(?:WHERE|LEFT JOIN|INNER JOIN|GROUP|HAVING|ORDER|LIMIT|$))/i', $query, $matches)) {
    $tables = $matches[0];
}

$table = explode(',',$tables[0])[0];

$stm = $db->prepare("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE WHERE TABLE_NAME = ? AND CONSTRAINT_NAME = 'PRIMARY'");
$stm->bind_param('s', $table);
$stm->execute();
$stm->bind_result($primaryKey);
while ($stm->fetch()) {}
$stm->close();

$columnsQuery = str_replace(' as ',' AS ',$query);

$functionAliasesArray = extractFunctionAliases($columnsQuery);

foreach($functionAliasesArray as $function => $functionAlias){
    $columnsQuery = str_replace("$function AS $functionAlias","$function",$columnsQuery);
}

$columnsFromQuery = $db->query($columnsQuery)->fetch_fields();

$columns = array();
$columnNames  = array();

if(strcmp(strtolower($showIconOnLines),'yes')==0){
    $column = array( 'db' => $table.'.'.$primaryKey, 'dt' =>  'image', 'field' => $primaryKey,'formatter' => function( $d, $row )  { global $class,$icon; return "<img  class='custom-rounded-image $class' src='//". HTML_PATH ."/cop/backend/themes/smartadmin/img/$icon' width='30' height='30'>";}, 'as' => 'image' );
    array_push($columns,$column);
}


foreach($columnsFromQuery as $columnFromQuery){

    $globalsKey = $columnFromQuery->name;

    if (preg_match('/^([A-Z]+)\((.*)\)$/i', $columnFromQuery->name, $matches)) {
        $globalsKey = rtrim(preg_replace('/[^a-zA-Z]/', '_', $columnFromQuery->name),'_');
    }

    if(strcmp($functionAliasesArray[$columnFromQuery->table.'.'.$columnFromQuery->name],'')!=0) {
        $globalsKey = $functionAliasesArray[$columnFromQuery->table.'.'.$columnFromQuery->name];
    } else if(strcmp($functionAliasesArray[$columnFromQuery->name],'')!=0) {
        $globalsKey = $functionAliasesArray[$columnFromQuery->name];
    }



    array_push($columnNames,$globalsKey);

}

foreach($columnsFromQuery as $columnFromQuery){

    $column_db = $columnFromQuery->table.".".$columnFromQuery->orgname;
    $column_dt = $columnFromQuery->table."_".$columnFromQuery->name;
    $column_name = $columnFromQuery->name;
    $column_as = $columnFromQuery->name;

    if (preg_match('/^([A-Z]+)\((.*)\)$/i', $columnFromQuery->name, $matches)) {

        $functionColumnName = rtrim(preg_replace('/[^a-zA-Z]/', '_', $columnFromQuery->name),'_');
        $column_db = $columnFromQuery->name;
        $column_dt = $functionColumnName;
        $column_name = $functionColumnName;
        $column_as = $functionColumnName;

    }

    $globalsKey = $column_name;

    if(strcmp($functionAliasesArray[$columnFromQuery->table.'.'.$columnFromQuery->name],'')!=0) {
        $globalsKey = $functionAliasesArray[$columnFromQuery->table.'.'.$columnFromQuery->name];
    } else if(strcmp($functionAliasesArray[$columnFromQuery->name],'')!=0) {
        $globalsKey = $functionAliasesArray[$columnFromQuery->name];
    }

    $column = array('db' => $column_db,
                    'dt' =>  $column_dt,
                    'formatter' => function( $d, $row ) use ($globalsKey,$functionAliasesArray,$columnNames,$customizedFields) {
                        $GLOBALS["$globalsKey"]=$d;

                        $input = identifyDate($globalsKey,$d, 'd-m-Y');

                        if (array_key_exists("[$globalsKey]",$customizedFields)){
                            $inputType = $customizedFields["[$globalsKey]"]->field_type;
                            $valuesRange = $customizedFields["[$globalsKey]"]->default_values;
                            $onClick = $customizedFields["[$globalsKey]"]->on_click_function;
                            $onChange = $customizedFields["[$globalsKey]"]->on_change_function;
                            $optionsFromQuery = $customizedFields["[$globalsKey]"]->options_from_query;

                            foreach ($columnNames as $columnName){
                                if(strcmp($functionAliasesArray["$columnName"],'')!=0){$columnName = $functionAliasesArray["$columnName"];}
                                $columnValue = $GLOBALS["$columnName"];
                                $onClick = str_replace("[$columnName]","$columnValue",$onClick);
                                $onChange = str_replace("[$columnName]","$columnValue",$onChange);
                            }
                            

                            $input = getInputType($inputType,'width:90%;','form-control text-center',"$globalsKey",$d,$valuesRange,$onClick,$onChange,$optionsFromQuery,false,true,false);
                        }
                        return $input;
                     },
                    'field' => $column_name,
                    'as' => $column_as );

    array_push($columns,$column);

}

if(strcmp(strtolower($customLineButtons),'')!=0){

    $column = array('db' => $table.'.'.$primaryKey,
                    'dt' =>  'actions',
                    'field' => $primaryKey,
                    'formatter' => function( $d, $row ) use($columnNames,$functionAliasesArray,$customLineButtons) {

                        $customLineButtons = str_replace("[HTML_PATH]",HTML_PATH,$customLineButtons);

                        foreach ($columnNames as $columnName){
                            if(strcmp($functionAliasesArray["$columnName"],'')!=0){$columnName = $functionAliasesArray["$columnName"];}
                            $columnValue = $GLOBALS["$columnName"];
                            $customLineButtons = str_replace("[$columnName]","$columnValue",$customLineButtons);
                        }

                        return $customLineButtons;

                    },
                    'as' => 'actions' );

    array_push($columns,$column);

}

$joinsArray = [];
if (preg_match_all('/\bJOIN\s+(\S+)\s+(AS\s+\S+\s+)?ON\s+(.*)/i', $query, $joins, PREG_SET_ORDER)) {
    foreach ($joins as $join) {
        $join_table = $join[1];
        $join_condition = $join[3];
        $join_type = (strpos($join[0], 'INNER JOIN') !== false) ? 'INNER' : 'LEFT';
        $joinsArray[] = "$join_type JOIN $join_table ON $join_condition";
    }
}

if(preg_match('/WHERE\s+(.*)$/i', $query, $where)) {$extraWhere = $where[1];}
if(preg_match('/GROUP\s+BY\s+(.*)$/i', $query, $group_by)) {$groupBy = $group_by[1];}


$extraWhere  =  explode('GROUP BY' , $extraWhere)[0];
$joinQuery   = "FROM $table ".explode('WHERE' , explode('GROUP BY' ,implode(" ", $joinsArray))[0])[0];

if(strpos($joinQuery, $primaryKey) !== false){ $primaryKey = $columnsFromQuery[0]->name;}

if(strcmp($_GET['echo'],'yes')==0) {
    echo "<pre>";
    echo "Aliases:<br>";
    var_dump($functionAliasesArray);
    echo "Column Names:<br>";
    var_dump($columnNames);
    echo "Columns:<br>";
    var_dump($columns);
    echo "Query: $columnsQuery<br>JOIN: $joinQuery <br>WHERE:  $extraWhere <br>GROUP: $groupBy";
    echo "</pre>";
}
$sql_details = array('user' => $username, 'pass' => $password, 'db'   => $database , 'host' => 'localhost');

require( ROOT.'backend/core/controllers/ssp2.class.php' );
echo json_encode(SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $extraWhere, $groupBy));



function extractFunctionAliases($query)
{

    // Extract columns using regular expressions
    preg_match('/SELECT\s+(.*)\s+FROM/i', $query, $matches);
    $columns = explode(',', $matches[1]);
    $columnsWithKeys=[];
    $multipleKey = '';
    $statsMultipleCommas = false;

    // Remove any function expressions or aliases
    foreach ($columns as &$column) {

        $columnValue = explode('AS',$column);


        if(strpos(trim($columnValue[0]), "(") !== false && strpos(trim($columnValue[0]), ")") !== false) {

            $columnsWithKeys[trim($columnValue[0])] = trim(end($columnValue));

        } else if(strpos(trim($columnValue[0]), "(") !== false){

            $statsMultipleCommas = true;
            $multipleKey .= $columnValue[0];

        } else if(strpos(trim($columnValue[0]), ")") !== false){

            $multipleKey .= ','.$columnValue[0];
            $columnsWithKeys[trim($multipleKey)] = trim(end($columnValue));
            $statsMultipleCommas = false;
            $multipleKey = '';

        } else if($statsMultipleCommas){

            $multipleKey .= ','.$columnValue[0];

        } else {
            $columnsWithKeys[trim($columnValue[0])] = trim(end($columnValue));
        }
    }

    return $columnsWithKeys;
}

function identifyDate($column_name,$date_string, $output_format)
{

    if(strpos(strtolower($column_name), "date") !== false || strpos(strtolower($column_name), "time") !== false) {

        // Supported date formats
        $date_formats = array(
            'Y-m-d',
            'Y/m/d',
            'Y.m.d',
            'm/d/Y',
            'm.d.Y',
            'd/m/Y',
            'd.m.Y',
            'Y-m-d H:i:s',
            'Y/m/d H:i:s',
            'Y.m.d H:i:s',
            'm/d/Y H:i:s',
            'm.d.Y H:i:s',
            'd/m/Y H:i:s',
            'd.m.Y H:i:s'
        );

        // Check if the string matches any of the supported date formats
        foreach ($date_formats as $format) {
            $datetime = DateTime::createFromFormat($format, $date_string);
            if ($datetime !== false) {
                $output = $datetime->format($output_format);
                if (strpos($format, 'H:i:s') !== false && strpos($output_format, 'H:i:s') === false) {
                    // Include the time in the output if the input date string includes a time and the output format does not
                    if(strcmp($column_name,"time") == 0){
                        $output = $datetime->format('H:i:s');
                    } else {
                        $output .= '<br>' . $datetime->format('H:i:s');
                    }

                }
                return $output;
            }
        }
    }

    return $date_string;
}

function getInputType($type,$cssStyle,$class,$customFieldName,$lastValue,$valuesRange,$onClick,$onChange,$optionsFromQuery,$disabled,$editable,$required){
    if($disabled || !$editable){$disable = 'disabled';}else{$disable = '';}
    if($required){$required = 'required';}else{$required = '';}

    switch ($type){
        case 'text':
            $input = "<input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' onclick='$onClick' onchange='$onChange' value='$lastValue' $disable $required/>";
            break;
        case 'combobox':


            $input = "<select style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' onclick='$onClick' onchange='$onChange' $disable>";

            $values = explode(';',$valuesRange);
            $optionCount=0;
            $hasSelected = false;
            foreach ($values as $value){
                if(strcmp($lastValue,$value)==0){
                    $hasSelected = true;
                    $input.= "<option value='$lastValue' selected disabled>$lastValue</option>";
                }else{
                    $input.= "<option value='$value'>$value</option>";
                }
                $optionCount++;
            }
            if(!$hasSelected){
                $input.= "<option value='$lastValue' selected disabled>$lastValue</option>";
            }
            $input .= $optionsFromQuery;
            $input.= "</select>";
            break;
        case 'checkbox':
            if(strcmp($lastValue,'yes')==0){$checked = "checked";} else {$checked = '';}
            $input = "<input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' value='yes' onclick='$onClick' onchange='$onChange' $checked $disable/>";
            break;
        case 'label':
            $input = "<label class='label'>$lastValue</label>";
            break;
        case 'textarea':
            $input = "<textarea type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' onclick='$onClick' onchange='$onChange' $disable $required>$lastValue</textarea>";
            break;
        case 'JSONArray':

            $valuesJson = str_replace('#quote#','"',$valuesRange);
            $values = json_decode($valuesJson);
            $optionCount=0;
            $input = "<select style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' onclick='$onClick' onchange='$onChange' $disable>";
            $input.= "<option value=''></option>";
            foreach ($values as $value){

                $value = json_encode($value);
                $value = str_replace('"','#quote#',$value);

                $lastValueArray = str_replace('#quote#','"',$lastValue);
                $lastValueArray = json_decode($lastValueArray);
                $lastValueDisplay = '';
                $lastValueArrayDB = array();
                $firstValueOption = true;
                foreach ($lastValueArray as $key => $data){
                    array_push($lastValueArrayDB,"#quote#$key#quote#:#quote#$data#quote#");
                    if($firstValueOption) {
                        $lastValueDisplay .= "$key: $data";
                        $firstValueOption = false;
                    } else {
                        $lastValueDisplay .= "</option><option disabled style='font-style:italic' >&nbsp;&#9679;&nbsp;$key: $data";
                    }
                }
                $lastValueDB = "{".implode(',',$lastValueArrayDB)."}";

                $valueArray = str_replace('#quote#','"',$value);
                $valueArray = json_decode($valueArray);
                $valueDisplay = '';
                $valueArrayDB = array();
                $firstValueOption = true;
                foreach ($valueArray as $key => $data){
                    array_push($valueArrayDB,"#quote#$key#quote#:#quote#$data#quote#");
                    if($firstValueOption) {
                        $valueDisplay .= "$key: $data";
                        $firstValueOption = false;
                    } else {
                        $valueDisplay .= "</option><option disabled style='font-style:italic' >&nbsp;&#9679;&nbsp;$key: $data";
                    }
                }
                $valueDB = "{".implode(',',$valueArrayDB)."}";

                if(strcmp($lastValueDB,$valueDB)==0){
                    $input.= "<option value='$lastValueDB' selected>$lastValueDisplay</option>";
                }else{
                    $input.= "<option value='$valueDB'>$valueDisplay</option>";
                }
                $optionCount++;
            }
            $input.= "</select>";

            break;
        case '':
            $input = "$lastValue";
            break;
        default:
            $lastValue = explode('<br>',identifyDate($customFieldName,$lastValue, 'Y-m-d'))[0];
            $input = "<input type='$type' style='$cssStyle' class='$class' id='$customFieldName' name='$customFieldName' value='$lastValue' onclick='$onClick' onchange='$onChange' $disable $required/>";

    }

    return $input;
}

function getDefaultValuesOptionsFromQuery($query,$displayNameColumn,$inputValueColumn){

    $optionsFromQuery = '';

    if(strcmp($query,'')!=0){

        global $username,$password,$database;
        $db2 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");

        $query = str_replace(' as ',' AS ',$query);
        $functionAliasesArray = extractFunctionAliases($query);

        foreach($functionAliasesArray as $function => $functionAlias){
            $query = str_replace("$function AS $functionAlias","$function",$query);
        }

        $columnsFromQuery = $db2->query($query);
        $i=0;
        foreach ($columnsFromQuery AS $value){

            $displayName = $value[array_search($displayNameColumn, $functionAliasesArray)];
            $inputValue = $value[array_search($inputValueColumn, $functionAliasesArray)];

            $optionsFromQuery .= "<option value='$inputValue'>$displayName</option>";
            $i++;

        }


    }

    return $optionsFromQuery;

}

?>