<?php
include_once("../../../../param.php");

if(isset($_POST['menuID']) || isset($_GET['menuID'])) {
    if (isset($_POST['menuID'])) {
        $menuID = $_POST['menuID'];
    } else {
        $menuID = $_GET['menuID'];
    }
}

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT menu_name FROM ZC_Menu WHERE menu_id=? LIMIT 1");
$stm->bind_param("i",$menuID);
$stm->execute();
$stm->bind_result($menuName);
while ($stm->fetch()) {}
$stm->close();

$adminID = intval($_SESSION['adminID']);
$coprimeUser = false;
$stm = $db->prepare("SELECT master_user,coprime_user FROM Admin  WHERE id='$adminID'");
$stm->execute();
$stm->bind_result($isMaster,$isCoprime);
while ($stm->fetch()) {
    if(strcmp(strtolower($isCoprime),'yes')==0){
        $coprimeUser = true;
    }
}
$stm->close();

?>


<div id="main" role="main" class="background-color-whitish">
    <!-- Start CUSTOM CODE-->
    <div id="ribbon" class="bg-color-blue">
        <span class="ribbon-button-alignment">
            <span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
                <i class="fa fa-refresh"></i>
            </span>
        </span>
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Edit Menu</li>
        </ol>
    </div>

    <!-- MAIN CONTENT -->
    <div id="content">
        <div class="row">
            <div class="col-xs-12 col-sm-4 col-md-6 col-lg-8">
                <h3 class="page-title txt-color-blueDark" style="margin-top:5px;margin-bottom: 15px;">
                   <i class="fa fa-tasks" ></i> <?php echo $menuName ?> Menu 
                </h3>
            </div>

            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                <?php if($coprimeUser)
                    echo "<a target='_blank' onclick=\"$('#addMenuDefinitionModal').modal('show');\" class='btn btn-primary btn-block'><i class='fa fa-plus'></i>&nbsp; New Menu Item Definition</a>";

                ?>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                <a href="//<?php echo HTML_PATH?>/cop/backend/modules/customMenu/views/manage_custom_menus.php" class="btn btn-primary btn-block"><i class="fa fa-arrow-left"></i>&nbsp; Back to Menus</a>

            </div>
    </div>
    
<section id="widget-grid" class="">
    <div class="row">
       <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="margin-top:5px;">

        <!-- Widget -->
        <div class="jarviswidget jarviswidget-color-white jarviswidget-sortable" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false" style="margin-bottom: 0px;">
            <header>
                <ul class="nav nav-tabs pull-left in" id="myTab">
                    <li class="active">
                        <a data-toggle="tab" href="#s1"><i class="fa fa-sitemap"></i> <span class="hidden-mobile hidden-tablet">Menu Items</span></a>
                    </li>
                    <li>
                        <a data-toggle="tab" href="#s2"><i class="fa fa-users"></i> <span class="hidden-mobile hidden-tablet">Menu Users</span></a>
                    </li>
                </ul>
            </header>

            <!-- Widget Body -->
            <div class="no-padding">
                <div class="widget-body">
                    <div id="myTabContent" class="tab-content">
                        <!-- Menu Items Tab -->
                        <div class="tab-pane fade active in padding-10 no-padding-bottom" id="s1">
                            <div class="row no-space">
                                <table id="datatable_fixed_column1" class="table table-striped table-hover dataTable" width="100%" border="0" cellpadding="0" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="hasinput" ><input type="text" class="form-control text-center" placeholder="Filter Icon" /></th>
                                            <th class="hasinput"><input type="text" class="form-control text-center" placeholder="Filter Menu Item" /></th>
                                            <th class="hasinput"><input type="text" class="form-control text-center" placeholder="Filter Name" /></th>
                                            <th class="hasinput"><input type="text" class="form-control text-center" id='parentItemFilter' placeholder="Filter Parent" /></th>
                                            <th class="hasinput"><input type="text" class="form-control text-center" placeholder="Filter Position" /></th>
                                            <th class="hasinput" style="width:15%">
                                                <center><button id="showAllButtonItems" class="btn btn-primary btn-block" onclick="showAllMenuItems(1);">Show All Menu Items</button></center>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th class="text-center">Icon</th>
                                            <th class="text-center">Menu Item</th>
                                            <th class="text-center">Custom Name</th>
                                            <th class="text-center">Parent</th>
                                            <th class="text-center">Position</th>
                                            <th class="text-center">Actions</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>

                        <!-- Menu Users Tab -->
                        <div class="tab-pane fade" id="s2">
                            <div class="widget-body-toolbar bg-color-white">
                                <div class="row no-space">
                                    <table id="datatable_fixed_column2" class="table table-striped table-hover dataTable" width="100%" border="0" cellpadding="0" cellspacing="0">
                                        <thead>
                                            <tr>
                                                <th class="hasinput"></th>
                                                <th class="hasinput">
                                                    <input type="text" class="form-control text-center" placeholder="Filter User">
                                                </th>
                                                <th class="hasinput" style="width:40%">
                                                    <input type="text" class="form-control text-center" placeholder="Filter Info">
                                                </th>
                                                <th class="hasinput" style="width:15%">
                                                    <center><button id="showAllButtonUsers" class="btn btn-primary btn-block" onclick="showAllUsers(1);">Show All Users</button></center>
                                                    <input type="hidden" value="0" id="showUsersFilter" />
                                                </th>
                                            </tr>
                                            <tr>
                                                <th class="text-center"><i class="fa fa-lg fa-fw fa-windows"></i></th>
                                                <th class="text-center">Cloud User</th>
                                                <th class="text-center">User Info</th>
                                                <th class="text-center">Actions</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Widget -->
        </div>
      </div>
    </article>
  </section>
</div>


<?php
if($coprimeUser){
    echo  '<div class="modal fade" id="addMenuDefinitionModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" >
    <div class="modal-dialog" role="document" >
        <div class="modal-content">
            <div class="modal-header">
                <center>
                	<button type="button" class="close" data-dismiss="modal" aria-label="Close" style="font-size: 30px;">
                        <span aria-hidden="true">&times;</span> 
                    </button>

                     <h4 class="modal-title"  style="display: inline-block;"><strong >New Menu Item Definition<span id="statusModalHeader"></span></strong></h4>
                </center>
            </div>
            <div class="modal-body">
                <input class="form-control text-center" type="hidden" id="statusID">
                <table class="table table-bordered">
                    <tr>
                        <td>Name:</td>
                        <td><input class="form-control text-center" type="text" id="name-modalDef" ></td>
                    </tr>
                    <tr>
                        <td>Icon:</td>
                        <td>
                            <div id="icon-preview-definitionModal"  style="font-size: 18px; width: 30px; display: inline-block;  margin-right: 10px;"></div>
                            <select  id="icon-modalDef" style="display: inline-block; width: calc(100% - 50px);">
                                <option value="fa-archive">fa-archive</option>
                                <option value="fa-ban">fa-ban</option>
                                <option value="fa-bar-chart-o">fa-bar-chart-o</option>
                                <option value="fa-book">fa-book</option>
                                <option value="fa-bank">fa-bank</option>
                                <option value="fa-credit-card">fa-credit-card</option>
                                <option value="fa-calendar">fa-calendar</option>
                                <option value="fa-envelope">fa-envelope</option>
                                <option value="fa-file-text">fa-file-text</option>
                                <option value="fa-gear">fa-gear</option>
                                <option value="fa-gears">fa-gears</option>
                                <option value="fa-gift">fa-gift</option>
                                <option value="fa-mobile">fa-mobile</option>
                                <option value="fa-money">fa-money</option>
                                <option value="fa-refresh">fa-refresh</option>
                                <option value="fa-signal">fa-signal</option>
                                <option value="fa-sitemap">fa-sitemap</option>
                                <option value="fa-sliders">fa-sliders</option>
                                <option value="fa-shopping-cart">fa-shopping-cart</option>
                                <option value="fa-tasks">fa-tasks</option>
                                <option value="fa-truck">fa-truck</option>
                                <option value="fa-user">fa-user</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>URL:</td>
                        <td>
                             <div style="font-size: 14px; display: inline-block; margin-right: 10px;"><b>cop/</b></div>
                                <input class="form-control text-center" type="text" id="url-modalDef" style="display: inline-block; width: 405px;">
                        </td>
                    </tr>
                    <tr>
                        <td>Params:</td>
                        <td><input class="form-control text-center" type="text" id="params-modalDef" name="params"></td>
                    </tr>
                </table>

                <br>
                <center>
                <button type="button" id="saveButton" class="btn btn-success" onclick="saveMenuItemDefinition()">Save Menu Item Definition</button>
                </center>
            </div>
        </div>
    </div>
</div>';
}
?>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/notification/SmartNotification.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/jquery.tabletojson.js"></script>

	
<script type="text/javascript">
    var otableItems; 
    var otableUsers; 
    
    
    function showAllUsers(value){
        if(value == 0){
			$('#showAllButtonUsers').html("Show All Users").attr("onclick","showAllUsers(1);");
        } else {
			$('#showAllButtonUsers').html("Show Menu Users").attr("onclick","showAllUsers(0);");
		}
		
	    $('#showUsersFilter').val(value);
		
		otableUsers.ajax.reload(null,false);
    }
    
    

    function addUserToMenu(menuID,userID) {
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH . "/cop/backend/modules/customMenu/controllers/addUserToMenu.php" ?>',
            data: {
                'menuID': menuID,
                'userID': userID
            },
            success: function(result) {
                $('#action-btn-' + userID).text('Remove')
                    .removeClass('btn-success')
                    .addClass('btn-danger')
                    .unbind('click')
                    .click(function() {
                        removeUserFromMenu(menuID,userID);
                    });


            }
        });
    }
    
    function removeUserFromMenu(menuID,userID) {
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH . "/cop/backend/modules/customMenu/controllers/removeUserFromMenu.php" ?>',
            data: {
              //  'menuID': menuID,
                'userID': userID
            },
            success: function(result) {
                $('#action-btn-' + userID).text('Add')
                    .removeClass('btn-danger')
                    .addClass('btn-success')
                    .unbind('click')
                    .click(function() {
                        addUserToMenu(menuID,userID);
                    });
            }
        });
    }
    
     function changeUserMenu(menuID,userID) {
         $.ajax({
             type: "POST",
             url: '//<?php echo HTML_PATH . "/cop/backend/modules/customMenu/controllers/changeUserMenu.php" ?>',
             data: {
                 'menuID': menuID,
                 'userID': userID
             },
             success: function(result) {
                 $('#action-btn-'+ userID).text('Remove')
                     .removeClass('btn-primary')
                     .addClass('btn-danger')
                     .unbind('click')
                     .click(function() {
                         removeUserFromMenu(menuID,userID);
                     });
             }
         });
     }
    
    function showAllMenuItems(value){

		if(value == 0){
			$('#showAllButtonItems').html("Show All Menu Items").attr("onclick","showAllMenuItems(1);");
			otableItems.ajax.url("//<?php echo HTML_PATH ?>/cop/backend/modules/customMenu/controllers/getMenuObjectItems.php?menuID=<?php echo $menuID;?>");
        } else {
			$('#showAllButtonItems').html("Show Menu Items").attr("onclick","showAllMenuItems(0);");
			otableItems.ajax.url("//<?php echo HTML_PATH ?>/cop/backend/modules/customMenu/controllers/getMenuDefinitionItems.php?menuID=<?php echo $menuID;?>");
		}
		
		otableItems.ajax.reload();
    }



    function addMenuItem(menuID,menuItemDefID) {
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH . "/cop/backend/modules/customMenu/controllers/addMenuItemToMenu.php" ?>',
            data: {
                'menuID': menuID,
                'menuItemDefID': menuItemDefID
            },
            success: function(result) {
                $('#action-btn-' + menuID + '-' + menuItemDefID).text('Remove')
                    .removeClass('btn-success')
                    .addClass('btn-danger')
                    .unbind('click')
                    .click(function() {
                        removeMenuItem(menuID,menuItemDefID);
                    });
               $('#datatable_fixed_column1').DataTable().reload(null,false);
                    

            }
        });
    }
    
    function removeMenuItem(menuID,menuItemDefID) {
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH . "/cop/backend/modules/customMenu/controllers/removeMenuItemFromMenu.php" ?>',
            data: {
                'menuID': menuID,
                'menuItemDefID': menuItemDefID
            },
            success: function(result) {
                $('#action-btn-' + menuID + '-' + menuItemDefID).text('Add')
                    .removeClass('btn-danger')
                    .addClass('btn-success')
                    .unbind('click')
                    .click(function() {
                        addMenuItem(menuID,menuItemDefID);
                    });
                     $('#datatable_fixed_column1').DataTable().reload(null,false);
            }
        });
    }
    
    function saveStatusField(id, elementName, newValue, suffix) {
        
	    
        $.ajax({
            type: "POST",
            url: "//<?php echo HTML_PATH; ?>/cop/backend/modules/customMenu/controllers/edit_menuItem_object.php",
            data: {
                'menuItemObjID': id,
                'fieldName': elementName,
                'fieldValue': newValue
            }
            ,
            success: function(result) {
                    $.smallBox({
                        title: "Success!",
                        content: "Field successfully updated.",
                        color: "#739E73",
                        timeout: 2000,
                        icon: "fa fa-check swing animated"
                    });
                    
                    $('#value' + suffix).html(newValue);
                    closeEditFields(suffix);
                    $('#datatable_fixed_column1').DataTable().ajax.reload(null,false);
    
                }
            
        });
    }

    
    function  closeEditFields(suffix){
        $('#value' + suffix).show();
        $('#input' + suffix).hide();
        $('#pen' + suffix).show();
        $('#save' + suffix).hide(); 
        $('#icon-preview' + suffix).html('');
               

        
        $('#value' + suffix).closest('td').css('width','');
        $('#value' + suffix).closest('td').css('white-space','');
           
    }
    
    function openEditField(id, elementName, element,defaultIcon=""){
        
        var faHtml = '<span class="btn btn-default" style="margin-top: -8px !important;margin-left:-40px;width:45px !important;"><i class="fa FA-ICON"></i></span>'
        var btnHtml ='<span class="btn  BTN-CLASS" style="height: 30px;margin-top: -7px !important;margin-left:-40px;"><img src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/DATA-ICON" width="18" height="18"</span>'
	    var suffix = '-' + elementName + '-' + id;
	    var value  = $('#value' + suffix).html();
	    
	     if(elementName==="icon" || elementName==="parent" ){
    	        value = $('#hiddenValue' + suffix).val();
	    }
	 
	    else if(value===null){
	        value='';
	    }
	    
        if (value === '&nbsp;' ) {
            value = '';
        }
        
        $('#value' + suffix).closest('td').css('width','fit-content');
        $('#value' + suffix).closest('td').css('white-space','nowrap');
        
	    $('#value' + suffix).hide();
	    $('#pen' + suffix).hide();
	    $('#input' + suffix).val(value);
	    $('#input' + suffix).show();
	    $('#input' + suffix).focus();
	    $('#save' + suffix).show(); 
	    
	    if(elementName==="icon"){
	         if ( value.startsWith('fa-') ) {
                $('#icon-preview' + suffix).html(faHtml.replace("FA-ICON",value));
	         }
	         else if(value.startsWith('btn')){
                    var dataIcon = $('#input-icon-' + id).find('option:selected').data('icon');
                    $('#icon-preview' + suffix).html(btnHtml.replace("BTN-CLASS",value).replace("DATA-ICON",dataIcon));  
            }
            else{
                 $('#icon-preview' + suffix).html(defaultIcon);
            }
	    }

	    

        $('#save' + suffix).unbind().on('click', function() {
            var newValue = $('#input' + suffix).val().trim();  
    	        if(value.localeCompare(newValue)!=0 ){       
                    saveStatusField(id, elementName, newValue,suffix);
    	        }
    	        else {
    	            closeEditFields(suffix);
    	        }
        });
        

        $('#input' + suffix).unbind().focusout(function(){
            if (!$(event.relatedTarget).is($('#save' + suffix))) {
                 closeEditFields(suffix);
            }
        });
        
        
        $('#input-icon-' + id).on('change', function() {
                var iconClass = $(this).find('option:selected').val();
                if ( iconClass.startsWith('fa-') ) {
                    $('#icon-preview' + suffix).html(faHtml.replace("FA-ICON",iconClass));
                    
                }
                else if(iconClass.startsWith('btn')){
                    var dataIcon = $(this).find('option:selected').data('icon');
                    $('#icon-preview' + suffix).html(btnHtml.replace("BTN-CLASS",iconClass).replace("DATA-ICON",dataIcon));  
                }
                else{
                     $('#icon-preview' + suffix).html('');
                }

            
        });
	    
	}  
   


   
    function initMenuUsers(){
       
    
        var responsiveHelper_datatable_fixed_column = undefined;
    
        var breakpointDefinition = {
            tablet: 1024,
            phone: 480
        };
    
        /* COLUMN FILTER  */
         otableUsers = $('#datatable_fixed_column2').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>" +
                    "t" +
                    "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "autoWidth": true,
            "processing": false,
            "serverSide": true,
          //  "order": [[ 2, "asc" ]],
            "ajax": {
                "type": "GET",
                "url": "//<?php echo HTML_PATH ?>/cop/backend/modules/customMenu/controllers/getMenuUsers.php",
                "data": function(data){
                      data.menuID = "<?php echo $menuID; ?>";
                      data.showAll = $('#showUsersFilter').val();
                  }

            },
            "columns": [
                { "data": "icon" },
                { "data": "username" },
                { "data": "user_info" },
                { "data": "form" }
            ],
            "deferRender": true,
            "autoWidth": true,
            "buttons": [
                "copyHtml5",
                "excelHtml5",
                "csvHtml5",
                {
                    extend: 'pdfHtml5',
                    orientation: 'landscape',
                    pageSize: 'LEGAL'
                }
            ],
            "preDrawCallback": function() {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column2'), breakpointDefinition);
                }
            },
            "rowCallback": function(nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback": function(oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }
        });
    
        // Apply the filter
        $("#datatable_fixed_column2 thead th input[type=text]").on('keyup change', function() {
            otableUsers
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        });
 
}

    function initMenuItems(){
    	 var responsiveHelper_datatable_fixed_column = undefined;
    
        var breakpointDefinition = {
            tablet: 1024,
            phone: 480
        };
        
        
  
    
        /* COLUMN FILTER  */
         otableItems = $('#datatable_fixed_column1').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>" +
                    "t" +
                    "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "autoWidth": true,
            "processing": false,
            "serverSide": true,
            "ajax": {
                "type": "GET",
                "url": "//<?php echo HTML_PATH ?>/cop/backend/modules/customMenu/controllers/getMenuObjectItems.php",
                 "data": function(data){
                    data.menuID = "<?php echo $menuID; ?>";
                    data.parentItemFilter = $('#parentItemFilter').val();
                 }

            },
            "columns": [
                 { "data": "icon" },
                { "data": "menu_item" },
                { "data": "name" },
                { "data": "parent" },
                { "data": "position" },
                { "data": "form" }
            ],
            "order": [[ 4, "asc" ]],
            "deferRender": true,
            "autoWidth": true,
            "buttons": [
                "copyHtml5",
                "excelHtml5",
                "csvHtml5",
                {
                    extend: 'pdfHtml5',
                    orientation: 'landscape',
                    pageSize: 'LEGAL'
                }
            ],
            "preDrawCallback": function() {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column1'), breakpointDefinition);
                }
            },
            "rowCallback": function(nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback": function(oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }
        });

        // Apply the filter
        $("#datatable_fixed_column1 thead th input[type=text]").on('keyup change', function() {
            var filterID = $(this).attr('id');

            if(filterID !== undefined && filterID.localeCompare('parentItemFilter') == 0){
                otableItems.draw();
            } else {
                otableItems
                    .column($(this).parent().index() + ':visible')
                    .search(this.value)
                    .draw();
            }
        });
}

    function saveMenuItemDefinition(){
        $('#saveButton').hide();
        $('#saveButton').prop("disabled", true);

        var name = $('#name-modalDef').val().trim();
        var icon = $('#icon-modalDef').val().trim();
        var url = $('#url-modalDef').val().trim();
        var params = $('#params-modalDef').val().trim();

        if (!name) {
            highlightDataError($('#name-modalDef'), "empty_field");
            $('#saveButton').show();
            $('#saveButton').prop("disabled", false);
            return;
        }


        $.ajax({
            type: "POST",
            "url": "//<?php echo HTML_PATH ?>/cop/backend/modules/customMenu/controllers/add_menu_item_definition.php",
            data: {
                'name': name,
                'icon': icon,
                'url': url,
                'params': params
            },

            success: function (result) {

                if(result.localeCompare('existingName') == 0){

                    highlightDataError($('#name-modalDef'), "existingName");

                    $('#saveButton').show();
                    $('#saveButton').prop("disabled",false);

                } else {

                    $.smallBox({
                        title : "Success!",
                        content : "Menu Item Definition successfully entered.",
                        color : "#739E73",
                        timeout: 3000,
                        icon : "fa fa-user swing animated"
                    });


                    window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/modules/customMenu/views/edit_custom_menu.php?menuID="+<?php echo $menuID; ?>);

                }
            }
        });
    }

    function showIconInModal(){
        $('#icon-modalDef').select2();


        var defaultIcon = $('#icon-modalDef').val();
        $('#icon-preview-definitionModal').html('<i class="fa ' + defaultIcon + '"></i>');

        $('#icon-modalDef').on('change', function() {
            $('#icon-preview-definitionModal').html('<i class="fa ' + $(this).val() + '"></i>');
        });
    }

    function highlightDataError(element,error){
        element.css('border-color','firebrick').css('background-color','#ffd0bd');
        if(error==="empty_field"){
            element.after('<span class="error-message" style="color: firebrick; font-size: 12px;">This field cannot be empty</span>');

        }
        if(error==="existingName"){
            element.after('<span class="error-message" style="color: firebrick; font-size: 12px;">Existing Menu Name</span>');
        }
        window.setTimeout(function(){
            element.css('border-color','').css('background-color','');
            element.next('.error-message').fadeOut(500);

        },3000);
    }

    $(document).ready(function() {
        pageSetUp();
        initMenuItems();
        initMenuUsers();
        showIconInModal();
    });
       
</script>							
								
