<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');
// DB table to use
$table = 'Contract_Schedules';

// Table's primary key
$primaryKey = "contract_schedule_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(

    array( 'db' => '`csh`.`contract_schedule_id`', 'dt' =>  'contract_schedule_id', 'formatter' => function( $d, $row ) {return $d;}, 'field' =>'contract_schedule_id'),
    array( 'db' => '`csh`.`contract_id`', 'dt' =>  'contract_id', 'formatter' => function( $d, $row ) {return $d;}, 'field' =>'contract_id'),
    array( 'db' => '`csh`.`service_call_id`', 'dt' =>  'service_call_id', 'formatter' => function( $d, $row ) {return $d;}, 'field' =>'service_call_id'),
    array( 'db' => '`csh`.`contract_type_id`', 'dt' =>  'contract_type_id', 'formatter' => function( $d, $row ) {return $d;}, 'field' =>'contract_type_id'),
    array( 'db' => '`csh`.`assign_salesperson_id`', 'dt' =>  'assign_salesperson_id', 'formatter' => function( $d, $row ) {return $d;}, 'field' =>'assign_salesperson_id'),
    array( 'db' => '`csh`.`type_of_schedule`', 'dt' =>  'type_of_schedule', 'formatter' => function( $d, $row ) {return $d;}, 'field' =>'type_of_schedule'),
    array( 'db' => '`csh`.`start_date`', 'dt' =>  'start_date', 'formatter' => function( $d, $row ) {
        if(strcmp("$d","0000-00-00 00:00:00")==0){
            return "-";
        } else {
            return date_format(date_create($d),"d/m/Y");
        }
    }, 'field' =>'start_date'),
    array( 'db' => '`csh`.`start_time`', 'dt' =>  'start_time', 'formatter' => function( $d, $row ) {
        if(strcmp("$d","0000-00-00 00:00:00")==0){
            return "-";
        } else {
            return date_format(date_create($d),"H:i");
        }
    }, 'field' =>'start_time'),
    array( 'db' => '`csh`.`end_time`', 'dt' =>  'end_time', 'formatter' => function( $d, $row ) {
        if(strcmp("$d","0000-00-00 00:00:00")==0){
            return "-";
        } else {
            return date_format(date_create($d),"H:i");
        }
    }, 'field' =>'end_time'),
    array( 'db' => '`csh`.`days`', 'dt' =>  'days', 'formatter' => function( $d, $row ) {
        $dayNames = array('-','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday');
        $days = explode(',',$d);
        $display = array();
        foreach($days as $day){
            array_push($display,$dayNames[intval($day)]);
        }
        $daysStr = implode(', ',$display);
        return $daysStr;
    }, 'field' =>'days'),
    array( 'db' => '`csh`.`months`', 'dt' =>  'months', 'formatter' => function( $d, $row ) {
        $monthNames = array('-','January','February','March','April','May','June','July','August','September','October','November','December');
        $months = explode(',',$d);
        $display = array();
        foreach($months as $month){
            array_push($display,$monthNames[intval($month)]);
        }
        $monthsStr = implode(', ',$display);
        return $monthsStr;
    }, 'field' =>'months'),
    array( 'db' => '`csh`.`days_of_month`', 'dt' =>  'days_of_month', 'formatter' => function( $d, $row ) {
        $days = explode(',',$d);
        $display = array();
        foreach($days as $day){
            if(intval($day) == 0){$day = '-';}
            else if(intval($day) == 1){$day = '1st';}
            else if(intval($day) == 2){$day = '2nd';}
            else if(intval($day) == 3){$day = '3rd';}
            else if(intval($day) == 21){$day = '21st';}
            else if(intval($day) == 22){$day = '22nd';}
            else if(intval($day) == 23){$day = '23rd';}
            else if(intval($day) == 31){$day = '31st';}
            else {$day = $day.'th';}
            array_push($display,$day);
        }
        $daysStr = implode(', ',$display);
        return $daysStr;
    }, 'field' =>'days_of_month'),
    array( 'db' => '`csh`.`last_run_date`', 'dt' =>  'last_run_date', 'formatter' => function( $d, $row ) {
        if(strcmp("$d","0000-00-00 00:00:00")==0){
            return "-";
        } else {
            return date_format(date_create($d),"d/m/Y");
        }
    }, 'field' =>'last_run_date'),
    array( 'db' => '`csh`.`next_run_date`', 'dt' =>  'next_run_date', 'formatter' => function( $d, $row ) {
        if(strcmp("$d","0000-00-00 00:00:00")==0){
            return "-";
        } else {
            return date_format(date_create($d),"d/m/Y");
        }
    }, 'field' =>'next_run_date'),
    array( 'db' => '`csh`.`schedule_status`', 'dt' =>  'schedule_status', 'formatter' => function( $d, $row ) {return $d;}, 'field' =>'schedule_status'),
    array( 'db' => '`csh`.`details`', 'dt' =>  'details', 'formatter' => function( $d, $row ) {return $d;}, 'field' =>'details'),
    array( 'db' => '`csh`.`contract_schedule_id`', 'dt' =>  'actions', 'formatter' => function( $d, $row ) {
        $buttons  ='';
        $buttons .= '<button type="button" class="btn btn-primary btn-sm" onclick="editContractSchedule('.$d.')" ><i class="fa fa-edit"></i>&nbsp; Edit</a>';

        return $buttons;
    }, 'field' =>'contract_schedule_id'),

    array( 'db' => '`sp`.`salesperson_id`', 'dt' =>  'salesperson_id', 'formatter' => function( $d, $row ) {$GLOBALS['salesperson_id']=$d;return $d;}, 'field' =>'salesperson_id'),
    array( 'db' => '`sp`.`first_name`', 'dt' =>  'first_name', 'formatter' => function( $d, $row ) {$GLOBALS['first_name']=$d;return $d;}, 'field' =>'first_name'),
    array( 'db' => '`sp`.`last_name`', 'dt' =>  'last_name', 'formatter' => function( $d, $row ) {$GLOBALS['last_name']=$d;return $d;}, 'field' =>'last_name'),
    array( 'db' => '`sp`.`salesperson_code`', 'dt' =>  'salesperson', 'formatter' => function( $d, $row ) {
        $salespersonID = $GLOBALS['salesperson_id'];

        if($salespersonID == 0){
            return '-';
        } else {
            return $d . ' - ' . $GLOBALS['first_name'] . ' ' . $GLOBALS['last_name'];
        }

    }, 'field' =>'salesperson_code'),
    array( 'db' => '`sct`.`type_name`', 'dt' =>  'service_call_type', 'formatter' => function( $d, $row ) {return $d;}, 'field' =>'type_name'),




);
global $username,$password,$database;
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


$contractID = $_GET['contractID'];
if(isset($contractID) && intval($contractID) > 0){
    $where= " NOT`csh`.`schedule_status`='deleted' AND `csh`.`contract_id`  = $contractID";
} else {
    $where = " 0=1 ";
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Contract_Schedules` AS `csh` LEFT JOIN `SalesPersons` AS `sp` ON (`csh`.`assign_salesperson_id` = `sp`.`salesperson_id`) LEFT JOIN `SC_Types` AS `sct` ON (`csh`.`service_call_type_id` = `sct`.`type_id`)";
require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>