<?php
require("./concc/dbinfo.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("../../../login.php");
}



function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

function endsWith($haystack, $needle)
{
    $length = strlen($needle);
    if ($length == 0) {
        return true;
    }

    return (substr($haystack, -$length) === $needle);
}


$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT `page_id`, 
                                  `show_slider_featured`, 
                                  `show_slider_brands`, 
                                  `brand_slider_name`, 
                                  `default_configuration`, 
                                  `items_per_page`, 
                                  `show_category_search`, 
                                  `popular_products_show`, 
                                  `popular_products_title`, 
                                  `popular_products_number`, 
                                  `popular_products_category`, 
                                  `popular_products_position`, 
                                  `new_products_show`, 
                                  `new_products_title`, 
                                  `new_products_days`, 
                                  `new_products_category`, 
                                  `new_products_position`, 
                                  `category_id_to_load`, 
                                  `category_id_to_load_anonymous`, 
                                  `category_title`, 
                                  `recommended_retail_price`, 
                                  `numeric_stock`, 
                                  `promo_categories_title`,
                                  `load_product_grid`, 
                                  `promotion_everywhere`,
                                  `get_stock_from`,
                                  `sort_items_by`,
                                  `stock_from_warehouse`,
                                  `include_subcategory_products`,
                                  `popular_products_from`,
                                   use_custom_table_of_item,
                                   items_custom_table_id,
                                   paging_box_position,
                                   custom_fields_per_row,
                                   sub_categories_with_items,
                                   stock_warning_qty,
                                   show_non_stock_items,
                                   show_add_to_cart_button,
                                   allow_user_favorites,
                                   allow_product_history,
                                   product_history_limit,
                                   product_history_source
                             FROM `B2B_Page_Catalogue`
                             WHERE `page_id`=1");
$stm->execute();
$stm->bind_result($pageID,
               $showSlider,
                     $showBrands,
                $brandSliderName,
                  $defaultConfig,
                   $itemsPerPage,
             $showCategorySearch,
            $showPopularProducts,
           $popularProductsTitle,
          $popularProductsNumber,
        $popularProductsCategory,
        $popularProductsPosition,
                $showNewProducts,
                $newProductTitle,
                 $newProductDays,
             $newProductCategory,
             $newProductPosition,
               $categoryIdToLoad,
      $categoryIdToLoadAnonymous,
                  $categoryTitle,
         $recommendedRetailPrice,
                   $numericStock,
           $promoCategoriesTitle,
                $loadProductGrid,
            $promotionEverywhere,
                   $getStockFrom,
                   $itemsOrderBy,
         $getStockFromWarehouses,
     $includeSubcategoryProducts,
                 $getPopularFrom,
           $linkUserDefinedForms,
                  $customTableID,
            $paging_box_position,
                $udfFieldsPerRow,
             $splitSubCategories,
                $stockWarningQty,
              $showNonStockItems,
            $showAddToCartButton,
            $showUserFavorites,
            $showOrderProductHistory,
            $orderProductHistoryLimit,
            $productHistorySource

);
while ($stm->fetch()) {}
$stm-> close();

$db->set_charset("utf8");
$stm2 = $db->prepare("SELECT b2b_price_list,b2b_offer_price_list,use_as_b2c,show_discount_bubble FROM `B2B_Configuration` LIMIT 1");
$stm2->execute();
$stm2->bind_result($b2bRetailPrice, $b2bOfferPrice,$useAsB2C,$showDiscountBubble);
while ($stm2->fetch()) {}
$stm2-> close();

$db->set_charset("utf8");
$stm2 = $db->prepare("SELECT `warehouse_id`, CONCAT(`warehouse_code`, ' - ', `name`) as namecode FROM `Warehouses`");
$stm2->execute();
$stm2->bind_result($warehouseID, $warehouseNameCode);
while ($stm2->fetch()) {
    $StockFromWarehouses = explode(',',$getStockFromWarehouses);
    $selected = "";
    foreach ($StockFromWarehouses AS $stockFromWarehouse) {
        if($stockFromWarehouse==$warehouseID) {
            $selected = "selected";
            break;
        }
    }
    $warehouseSelection .= "<option value='$warehouseID' $selected>$warehouseNameCode</option>";


}
$stm2-> close();


$db->set_charset("utf8");
$stm2 = $db->prepare("SELECT `category_id`, CONCAT(`category_code`, ' - ', `name`) as namecode FROM `Categories`");
$stm2->execute();
$stm2->bind_result($categoryID, $categoryNameCode);
while ($stm2->fetch()) {

    // Selection for Popular Category
    if(strcmp($categoryID,$popularProductsCategory)==0) {
        $popProdCategorySelect = $popProdCategorySelect . '<option value="' . $categoryID . '" selected >' . $categoryNameCode . '</option>';
    }else{
        $popProdCategorySelect = $popProdCategorySelect . '<option value="' . $categoryID . '" >' . $categoryNameCode . '</option>';
    }

    // Selection for new category
    if(strcmp($categoryID,$newProductCategory)==0) {
        $newProdCategorySelect = $newProdCategorySelect . '<option value="' . $categoryID . '" selected >' . $categoryNameCode . '</option>';
    }else{
        $newProdCategorySelect = $newProdCategorySelect . '<option value="' . $categoryID . '" >' . $categoryNameCode . '</option>';
    }

    // Selection for category to load
    if(strcmp($categoryID,$categoryIdToLoad)==0) {
        $categoryToLoadSelect = $categoryToLoadSelect . '<option value="' . $categoryID . '" selected >' . $categoryNameCode . '</option>';
    }else{
        $categoryToLoadSelect = $categoryToLoadSelect . '<option value="' . $categoryID . '" >' . $categoryNameCode . '</option>';
    }
    // Selection for category to load for Anonymous
    if(strcmp($categoryID,$categoryIdToLoadAnonymous)==0) {
        $categoryToLoadAnonymousSelect = $categoryToLoadAnonymousSelect . '<option value="' . $categoryID . '" selected >' . $categoryNameCode . '</option>';
    }else{
        $categoryToLoadAnonymousSelect = $categoryToLoadAnonymousSelect . '<option value="' . $categoryID . '" >' . $categoryNameCode . '</option>';
    }

if(strcmp($categoryIdToLoadAnonymous,'-1')==0){$categoryToLoadAnonymousSelected = 'selected';}
if(strcmp($categoryIdToLoad,'-1')==0){$categoryToLoadSelected = 'selected';}
if(strcmp($includeSubcategoryProducts,'yes')==0){$includeSubcategoryProductsYesSelected = 'selected';}

}
$stm2-> close();

$db->set_charset("utf8");
$stm3 = $db->prepare("SELECT `pricetype_id`, CONCAT(`price_code`,' - ' ,`name`) codename  FROM `PriceTypes`");
$stm3->execute();
$stm3->bind_result($priceTypeID, $priceTypeNameCode);

// Selection for Recommended Retail Price if No Price is selected
if(strcmp($recommendedRetailPrice,'0')==0) {
    $priceSelect = $priceSelect . '<option value="' . $recommendedRetailPrice . '" selected > - No Price - </option>';
} else {
    $priceSelect = $priceSelect . '<option value=" " > - No Price - </option>';
}

while ($stm3->fetch()) {

    // Selection for Recommended Retail Price
     if(strcmp($priceTypeID,$recommendedRetailPrice)==0) {
        $priceSelect = $priceSelect . '<option value="' . $priceTypeID . '" selected >' . $priceTypeNameCode . '</option>';
    } else {
        $priceSelect = $priceSelect . '<option value="' . $priceTypeID . '" >' . $priceTypeNameCode . '</option>';
    }
}


$stm3-> close();

$db->set_charset("utf8");
$stm3 = $db->prepare("SELECT `pricetype_id`, CONCAT(`price_code`,' - ' ,`name`) codename  FROM `PriceTypes`");
$stm3->execute();
$stm3->bind_result($priceTypeID, $priceTypeNameCode);

// Selection for Retail Price if No Price is selected
if(strcmp($b2bRetailPrice,'0')==0) {
    $b2bPriceSelect = $b2bPriceSelect . '<option value="' . $b2bRetailPrice . '" selected > - Default Price List - </option>';
} else {
    $b2bPriceSelect = $b2bPriceSelect . '<option value=" " > - No Price - </option>';
}

while ($stm3->fetch()) {

    // Selection for Offer Price
    if(strcmp($priceTypeID,$b2bRetailPrice)==0) {
        $b2bPriceSelect = $b2bPriceSelect . '<option value="' . $priceTypeID . '" selected >' . $priceTypeNameCode . '</option>';
    } else {
        $b2bPriceSelect = $b2bPriceSelect . '<option value="' . $priceTypeID . '" >' . $priceTypeNameCode . '</option>';
    }
}

$stm3-> close();

$db->set_charset("utf8");
$stm3 = $db->prepare("SELECT `pricetype_id`, CONCAT(`price_code`,' - ' ,`name`) codename  FROM `PriceTypes`");
$stm3->execute();
$stm3->bind_result($priceTypeID, $priceTypeNameCode);

// Selection for Recommended Retail Price if No Price is selected
if(strcmp($b2bOfferPrice,'0')==0) {
    $b2bOfferPriceSelect = $b2bOfferPriceSelect . '<option value="' . $b2bOfferPrice . '" selected > - No Offer Prices - </option>';
} else {
    $b2bOfferPriceSelect = $b2bOfferPriceSelect . '<option value=" " > - No Price - </option>';
}

while ($stm3->fetch()) {

    // Selection for Recommended Retail Price
    if(strcmp($priceTypeID,$b2bOfferPrice)==0) {
        $b2bOfferPriceSelect = $b2bOfferPriceSelect . '<option value="' . $priceTypeID . '" selected >' . $priceTypeNameCode . '</option>';
    } else {
        $b2bOfferPriceSelect = $b2bOfferPriceSelect . '<option value="' . $priceTypeID . '" >' . $priceTypeNameCode . '</option>';
    }
}

$stm3-> close();


// Yes/No Values from DB

if(strcmp($getStockFrom,              'available')==0){$getStockFromAvailableOnly  = 'selected';}
if(strcmp($getStockFrom,         'ignoreReserved')==0){$getStockFromAvailable      = 'selected';}
if(strcmp($getStockFrom,                   'both')==0){$getStockFromBoth           = 'selected';}
if(strcmp($splitSubCategories,              'yes')==0){$splitSubCategoriesYes      = 'selected';}

if(strcmp($loadProductGrid,    'yes')==0){$loadProductGridYes     = 'selected';}
if(strcmp($loadProductGrid,     'no')==0){$loadProductGridNo      = 'selected';}
if(strcmp($loadProductGrid,  'login')==0){$loadProductGridLogin   = 'selected';}
if(strcmp($loadProductGrid, 'logout')==0){$loadProductGridLogout  = 'selected';}

if(strcmp($showSlider,         'yes')==0){$showSliderYes     = 'selected';}
if(strcmp($showSlider,          'no')==0){$showSliderNo      = 'selected';}
if(strcmp($showSlider,       'login')==0){$showSliderLogin   = 'selected';}
if(strcmp($showSlider,      'logout')==0){$showSliderLogout  = 'selected';}

if(strcmp($showBrands,         'yes')==0){$showBrandsYes         = 'selected';}
if(strcmp($showBrands,          'no')==0){$showBrandsNo          = 'selected';}
if(strcmp($showBrands,       'login')==0){$showBrandsLogin       = 'selected';}
if(strcmp($showBrands,      'logout')==0){$showBrandsLogout      = 'selected';}

if(strcmp($numericStock,       'yes')==0){$numericStockYes       = 'selected';}
if(strcmp($numericStock,       'dot')==0){$numericStockDot       = 'selected';}
if(strcmp($numericStock,        'no')==0){$numericStockNo        = 'selected';}

if(strcmp($showCategorySearch,    'yes')==0){$showCategorySearchYes     = 'selected';}
if(strcmp($showCategorySearch,     'no')==0){$showCategorySearchNo      = 'selected';}
if(strcmp($showCategorySearch,  'login')==0){$showCategorySearchLogin   = 'selected';}
if(strcmp($showCategorySearch, 'logout')==0){$showCategorySearchLogout  = 'selected';}

if(strcmp($showNewProducts,    'yes')==0){$showNewProductsYes    = 'selected';}
if(strcmp($showNewProducts,     'no')==0){$showNewProductsNo     = 'selected';}
if(strcmp($showNewProducts,  'login')==0){$showNewProductsLogin  = 'selected';}
if(strcmp($showNewProducts, 'logout')==0){$showNewProductsLogout = 'selected';}

if(strcmp($showPopularProducts,    'yes')==0){$showPopularProductsYes      = 'selected';}
if(strcmp($showPopularProducts,     'no')==0){$showPopularProductsNo       = 'selected';}
if(strcmp($showPopularProducts,  'login')==0){$showPopularProductsLogin    = 'selected';}
if(strcmp($showPopularProducts, 'logout')==0){$showPopularProductsLogout   = 'selected';}

if(strcmp($promotionEverywhere, 'no')==0){$promotionEverywhereNo = 'selected';}

// Default Config Values from DB
if(strcmp($defaultConfig,        'list')==0){$defaultConfigList    = 'selected';}
if(strcmp($defaultConfig, 'grid1PerRow')==0){$defaultConfig1PerRow = 'selected';}
if(strcmp($defaultConfig, 'grid2PerRow')==0){$defaultConfig2PerRow = 'selected';}
if(strcmp($defaultConfig, 'grid3PerRow')==0){$defaultConfig3PerRow = 'selected';}
if(strcmp($defaultConfig,        'grid')==0){$defaultConfig6PerRow = 'selected';}

// Items Per Page selection from DB
if(strcmp($itemsPerPage, '1')==0){$itemsPerPageSelect[1] = 'selected';}
if(strcmp($itemsPerPage, '2')==0){$itemsPerPageSelect[2] = 'selected';}
if(strcmp($itemsPerPage, '3')==0){$itemsPerPageSelect[3] = 'selected';}


if(strcmp($paging_box_position, 'bottom-left')==0){$paging_box_position_bottom_left_selected = 'selected';}
if(strcmp($paging_box_position, 'bottom-right')==0){$paging_box_position_bottom_right_selected = 'selected';}
if(strcmp($paging_box_position, 'bottom-center')==0){$paging_box_position_bottom_center_selected = 'selected';}


if(strcmp($popularProductsPosition, 'top')==0){$popularProductsPositionTopSelected = 'selected';}
if(strcmp($newProductPosition, 'top')==0){$newProductPositionTopSelected = 'selected';}

for($count = 4; $count < 10; $count++){
    $tempValue += 6;
    if(strcmp($itemsPerPage, $tempValue)==0){
        $itemsPerPageSelect[$count] = 'selected';
        break;
    }
}

if(strcmp($itemsPerPage, '60')==0){$itemsPerPageSelect[10] = 'selected';}
if(strcmp($itemsPerPage, '96')==0){$itemsPerPageSelect[11] = 'selected';}

if(strcmp($getPopularFrom,'2')==0){$getPopularFromInvoice = 'selected';}
if(strcmp($getPopularFrom,'1')==0){$getPopularFromERP = 'selected';}

if(strcmp($itemsOrderBy, 'item_code')==0){$itemsOrderByCode = 'selected';}
if(strcmp($itemsOrderBy, 'name')==0){$itemsOrderByName = 'selected';}
if(strcmp($itemsOrderBy, 'long_description')==0){$itemsOrderByLongDescription = 'selected';}
if(strcmp($itemsOrderBy, 'item_sku')==0){$itemsOrderBySku = 'selected';}
if(strcmp($itemsOrderBy, 'Category_Item.position')==0){$itemsOrderByPosition = 'selected';}

if(strcmp($showAddToCartButton, 'yes')==0){$showAddToCartButtonYes = 'selected';}

if(strcmp($linkUserDefinedForms, 'yes')==0){$linkUserDefinedFormsYes = 'selected';}

if(strcmp($showUserFavorites, 'yes')==0){$userFavoritesYes = 'selected';}

if(strcmp($showOrderProductHistory, 'yes')==0){$orderProductHistoryYes = 'selected';}


$udfSelection = '<option value="0"> - No User Defined Form - </option>';
$db->set_charset("utf8");
$stm3 = $db->prepare("SELECT custom_table_id,custom_table_code,display_name  FROM ZA_Custom_Tables WHERE linked_table='Items'");
$stm3->execute();
$stm3->bind_result($udfID, $udfCode,$udfName);
while ($stm3->fetch()) {
    if($udfID == $customTableID){
        $udfSelection .= "<option value='$udfID' selected>$udfCode - $udfName</option>";

    } else {
        $udfSelection .= "<option value='$udfID'>$udfCode - $udfName</option>";

    }
}
$stm3->close();

if(strcmp($udfFieldsPerRow,'')==0){$udfFieldsPerRow = 3;}

if(strcmp($showDiscountBubble,'yes')==0){$showDiscountBubbleYes = 'selected';}
if(strcmp($showDiscountBubble,'no')==0){$showDiscountBubbleNo = 'selected';}
if(strcmp($showDiscountBubble,'bubble')==0){$showDiscountBubbleBubble = 'selected';}
if(strcmp($showDiscountBubble,'price')==0){$showDiscountBubblePrice = 'selected';}

if(strcmp($showNonStockItems,'yes')==0){$showNonStockItemsYes = 'selected';}
if(strcmp($showNonStockItems,'notavailable')==0){$showNonStockItemsNotAvailable = 'selected';}
if(strcmp($showNonStockItems,'no')==0){$showNonStockItemsNo = 'selected';}


?>


<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white"> B2B Page Catalogue </li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content" style="padding-top: 0;">
        <div class="row">
            <div class="col-xs-12 col-sm-7 col-md-7 col-lg-10">
                <h1 class="page-title txt-color-blueDark"><i class="fa-fw fa fa-gears"></i> Page Catalogue</h1>
            </div>
            <div class="col-xs-12 col-sm-5 col-md-5 col-lg-2">
                    <span class="pull-right show-stat-buttons">
                        <span> <button id="saveButton" onclick="savePost()" class="btn btn-success btn-block" style="margin-top: 15px;">
                                <i class="fa fa-check"></i>&nbsp; Save Configuration</button>
                        </span>
                    </span>
            </div>
        </div>


                <!-- widget grid -->
                    <section id="widget-grid" class="">
                        <div class="row">

                            <!-- widget sliders -->
                            <article class="col-xs-6 col-sm-4 col-md-4 col-lg-4" >
                                <div  class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                                    <header>
                                        <span class="widget-icon"> <i class="fa fa-gears"></i> </span>
                                        <h2>Manage Sliders </h2>
                                    </header>
                                    <!-- widget div-->
  
                                        <!-- widget content -->
                                        <div class="" style="padding: 10px; 10px; 10px; 10px;" >
                                            <div class="">
                                                <section>
                                                    <div class="row">
                                                        <div class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
                                                            <label class="label-bold  align-left">Show Slider Featured: </label>
                                                            <select  class="form-control" id="showSlider">
                                                                <option value="yes" <?php echo $showSliderYes;?>>yes</option>
                                                                <option value="login" <?php echo $showSliderLogin;?>>On Login</option>
                                                                <option value="logout" <?php echo $showSliderLogout;?>>On Logout</option>
                                                                <option value="no" <?php echo $showSliderNo;?>>no</option>
                                                            </select>
                                                        </div>
                                                        <div class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
                                                            <button class="btn btn-primary btn-block" onclick="window.location.href = './slider.php';" style="margin-top: 26px">Configure Featured Slider</button>
                                                        </div>
                                                    </div>
                                                </section>
                                                <section>
                                                    <div class="row">
                                                        <div class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
                                                            <label class="label-bold  align-left">Show Slider Brands: </label>
                                                            <select  class="form-control" id="showBrands">
                                                                <option value="yes" <?php echo $showBrandsYes;?>>yes</option>
                                                                <option value="login" <?php echo $showBrandsLogin;?>>On Login</option>
                                                                <option value="logout" <?php echo $showBrandsLogout;?>>On Logout</option>
                                                                <option value="no" <?php echo $showBrandsNo;?>>no</option>
                                                            </select>
                                                        </div>
                                                        <div class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
                                                            <button class="btn btn-primary btn-block" onclick="window.location.href = './brands.php';" style="margin-top: 26px">Configure Brands Slider</button>
                                                        </div>
                                                    </div>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Slider Brands Title: </label>
                                                    <input type="text" class="form-control"  id="brandSliderName" value="<?php echo $brandSliderName?>" />
                                                </section>
                                            </div>
                                        </div>
                                    </div>
                            </article>

                            <!-- widget popular products -->
                            <article class="col-xs-6 col-sm-4 col-md-4 col-lg-4" >
                                <div  class="jarviswidget jarviswidget-color-blueDark" id="wid-id-2" data-widget-editbutton="false" data-widget-deletebutton="false">
                                    <header>
                                        <span class="widget-icon"> <i class="fa fa-gears"></i> </span>
                                        <h2>Manage Popular Products </h2>
                                    </header>
                                    <!-- widget div-->
                                    <div class="no-padding" >
                                        <!-- widget content -->
                                        <div class="" style="padding: 10px; 10px; 10px; 10px;" >
                                            <div class="">
                                                <section>
                                                    <label class="label-bold  align-left">Show Popular Products: </label>
                                                    <select  class="form-control" id="showPopularProducts">
                                                        <option value="yes" <?php echo $showPopularProductsYes;?>>yes</option>
                                                        <option value="login" <?php echo $showPopularProductsLogin;?>>On Login</option>
                                                        <option value="logout" <?php echo $showPopularProductsLogout;?>>On Logout</option>
                                                        <option value="no" <?php echo $showPopularProductsNo;?>>no</option>
                                                    </select>
                                                </section>
                                                <section>
                                                    <label class="label-bold  align-left">Popular Products Number: </label>
                                                    <input type="number" min="1" class="form-control" id="popularProductsNumber" value="<?php echo $popularProductsNumber?>"/>
                                                </section>
                                                <section>
                                                    <table style="width: 100%;">
                                                        <tr>
                                                            <td>
                                                                <div align="left">
                                                                    <label class="label-bold  align-left">Popular Products Title: </label>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div align="left">
                                                                    <label class="label-bold  align-left"> Position: </label>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <input type="text" class="form-control" id="popularProductsTitle" value="<?php echo $popularProductsTitle?>"/>
                                                            </td>
                                                            <td>
                                                                <select class="form-control" id="popularProductsPosition">
                                                                    <option value="left">Left Side</option>
                                                                    <option value="top" <?php echo $popularProductsPositionTopSelected; ?>>Top Side</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </section>
                                            </div>
                                        </div>
                                    </div>
                            </article>

                            <!-- widget new products -->
                            <article class="col-xs-6 col-sm-4 col-md-4 col-lg-4" >
                                <div  class="jarviswidget jarviswidget-color-blueDark" id="wid-id-3" data-widget-editbutton="false" data-widget-deletebutton="false">
                                    <header>
                                        <span class="widget-icon"> <i class="fa fa-gears"></i> </span>
                                        <h2>Manage New Products </h2>
                                    </header>
                                    <!-- widget div-->
                                    <div class="no-padding" >
                                        <!-- widget content -->
                                        <div class="" style="padding: 10px; 10px; 10px; 10px;" >
                                            <div class="">
                                                <section>
                                                    <label class="label-bold  align-left">Show New Products: </label>
                                                    <select  class="form-control" id="showNewProducts">
                                                        <option value="yes" <?php echo $showNewProductsYes;?>>yes</option>
                                                        <option value="login" <?php echo $showNewProductsLogin;?>>On Login</option>
                                                        <option value="logout" <?php echo $showNewProductsLogout;?>>On Logout</option>
                                                        <option value="no" <?php echo $showNewProductsNo;?>>no</option>
                                                    </select>
                                                </section>
                                                <section>
                                                    <label class="label-bold  align-left">New Products Days: </label>
                                                    <input type="number" min="1" class="form-control" id="newProductDays" value="<?php echo $newProductDays?>"/>
                                                </section>
                                                <section>
                                                    <table style="width: 100%;">
                                                        <tr>
                                                            <td>
                                                                <div align="left">
                                                                    <label class="label-bold  align-left">New Products Title: </label>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div align="left">
                                                                    <label class="label-bold  align-left"> Position: </label>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <input type="text" class="form-control" id="newProductTitle" value="<?php echo $newProductTitle?>"/>
                                                            </td>
                                                            <td>
                                                                <select class="form-control" id="newProductsPosition">
                                                                    <option value="left">Left Side</option>
                                                                    <option value="top" <?php echo $newProductPositionTopSelected; ?>>Top Side</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </section>
                                            </div>
                                        </div>
                                    </div>
                            </article>

                            <!-- widget new products -->
                            <article class="col-xs-6 col-sm-4 col-md-4 col-lg-6" >
                                <div  class="jarviswidget jarviswidget-color-blueDark" id="wid-id-4" data-widget-editbutton="false" data-widget-deletebutton="false">
                                    <header>
                                        <span class="widget-icon"> <i class="fa fa-gears"></i> </span>
                                        <h2>Manage Products View </h2>
                                    </header>
                                    <!-- widget div-->
                                    <div class="no-padding" >
                                        <!-- widget content -->
                                        <div class="" style="padding: 10px; 10px; 10px; 10px;" >
                                            <div class="">
                                                <section>
                                                    <table style="width: 100%">
                                                        <tr>
                                                            <td style="width: 30%"><div align="left"><label class="label-bold  align-left">Show Product Grid: </label></div></td>
                                                            <td style="width: 30%"><div align="left"><label class="label-bold  align-left">Add to Cart Button: </label></div></td>
                                                            <td style="width: 30%"><div align="left"><label class="label-bold  align-left">&nbsp;Promotion Everywhere: </label></div></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="width: 30%">
                                                                <select  class="form-control" id="showProductsGrid">
                                                                    <option value="yes" <?php echo $loadProductGridYes;?>>yes </option>
                                                                    <option value="login" <?php echo $loadProductGridLogin;?>>On Login</option>
                                                                    <option value="logout" <?php echo $loadProductGridLogout;?>>On Logout</option>
                                                                    <option value="no" <?php echo $loadProductGridNo;?>>no</option>
                                                                </select>
                                                            </td>
                                                            <td style="width: 30%">
                                                                <select  class="form-control" id="showAddToCartButton">
                                                                    <option value="no" >no</option>
                                                                    <option value="yes" <?php echo $showAddToCartButtonYes;?>>yes </option>
                                                                </select>
                                                            </td>
                                                            <td style="width: 30%">
                                                                <select  class="form-control" id="promotionEverywhere">
                                                                    <option value="yes" >yes</option>
                                                                    <option value="no" <?php echo $promotionEverywhereNo;?>>On Login</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>

                                                </section>
                                                <section>
                                                    <table style="width: 100%">
                                                        <tr>
                                                            <td style="width: 33%"><div align="left"><label class="label-bold  align-left" style="margin-top: 2px;text-align: left;margin-bottom: -1px;">Use User Defined Forms </label></div></td>
                                                            <td style="width: 33%"><div align="left"><label class="label-bold  align-left" style="margin-top: 2px;text-align: left;margin-bottom: -1px;">&nbsp;Select User Defined Form </label></div></td>
                                                            <td style="width: 33%"><div align="left"><label class="label-bold  align-left" style="margin-top: 2px;text-align: left;margin-bottom: -1px;">&nbsp;Fields Per Row </label></div></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="width: 33%">
                                                                <select  class="form-control" id="linkUDFs">
                                                                    <option value="no" >no</option>
                                                                    <option value="yes" <?php echo $linkUserDefinedFormsYes;?>>yes</option>
                                                                </select>
                                                            </td>
                                                            <td style="width: 33%">
                                                                <select  class="form-control" id="UDFID">
                                                                    <?php echo $udfSelection; ?>
                                                                </select>
                                                            </td>
                                                            <td style="width: 33%">
                                                                <input type="number" class="form-control" style="padding: 5px !important;"  id="UDFsPerRow" min="1" value="<?php echo $udfFieldsPerRow?>" />
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </section>
                                                <section>
                                                    <table style="width: 100%">
                                                        <tr>
                                                            <td style="width: 25%"><div align="left"><label class="label-bold  align-left" style="margin-top: 2px;text-align: left;margin-bottom: -1px;">Enable User Favorites </label></div></td>
                                                            <td style="width: 25%"><div align="left"><label class="label-bold  align-left" style="margin-top: 2px;text-align: left;margin-bottom: -1px;">&nbsp;Enable Product History </label></div></td>
                                                            <td style="width: 25%"><div align="left"><label class="label-bold  align-left" style="margin-top: 2px;text-align: left;margin-bottom: -1px;">Product History Source </label></div></td>
                                                            <td style="width: 25%"><div align="left"><label class="label-bold  align-left" style="margin-top: 2px;text-align: left;margin-bottom: -1px;">Product History Limit </label></div></td>

                                                        </tr>
                                                        <tr>
                                                            <td style="width: 25%">
                                                                <select  class="form-control" id="showUserFavorites">
                                                                    <option value="no" >no</option>
                                                                    <option value="yes" <?php echo $userFavoritesYes;?>>yes</option>
                                                                </select>
                                                            </td>
                                                            <td style="width: 25%">
                                                                <select class="form-control"
                                                                        id="showOrderProductHistory">
                                                                    <option value="no">no</option>
                                                                    <option value="yes" <?php echo $orderProductHistoryYes; ?>>
                                                                        yes
                                                                    </option>
                                                                </select>
                                                            </td>
                                                            <td style="width: 25%">
                                                                <select class="form-control" id="productHistorySource">
                                                                    <option value="orders">Orders</option>
                                                                    <option value="invoices" <?php if(strcmp($productHistorySource,"invoices")==0) {echo "selected";}?>>Invoices</option>
                                                                    <option value="erp_last_prices" <?php if(strcmp($productHistorySource,"erp_last_prices")==0) {echo "selected";}?>>ERP Last Prices</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <input type="number" class="form-control" id="orderProductHistoryLimit" min = '1' max = '20' style="padding-left: 10px !important;" value="<?php echo $orderProductHistoryLimit;?>" />
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </section>
                                                <section>
                                                    <table style="width: 100%;">
                                                        <tr>
                                                            <td style="width:25%;">
                                                                <div align="left" style="margin-top: 5px;">
                                                                    <label class="label-bold  align-left" style="margin-top: 2px;text-align: left;">Default Items Per Page </label>
                                                                    <select  class="form-control" id="itemsPerPage">
                                                                        <option value="1"  <?php echo $itemsPerPageSelect[1];?>>  1 Item </option>
                                                                        <option value="2"  <?php echo $itemsPerPageSelect[2];?>>  2 Items</option>
                                                                        <option value="3"  <?php echo $itemsPerPageSelect[3];?>>  3 Items</option>
                                                                        <option value="6"  <?php echo $itemsPerPageSelect[4];?>>  6 Items</option>
                                                                        <option value="12" <?php echo $itemsPerPageSelect[5];?>> 12 Items</option>
                                                                        <option value="18" <?php echo $itemsPerPageSelect[6];?>> 18 Items</option>
                                                                        <option value="24" <?php echo $itemsPerPageSelect[7];?>> 24 Items</option>
                                                                        <option value="30" <?php echo $itemsPerPageSelect[8];?>> 30 Items</option>
                                                                        <option value="36" <?php echo $itemsPerPageSelect[9];?>> 36 Items</option>
                                                                        <option value="60" <?php echo $itemsPerPageSelect[10];?>>60 Items</option>
                                                                        <option value="96" <?php echo $itemsPerPageSelect[11];?>>96 Items</option>
                                                                    </select>
                                                                </div>
                                                            </td>
                                                            <td style="width:25%;">
                                                                <div align="left" style="margin-top: 5px;">
                                                                    <label class="label-bold  align-left" style="margin-top: 2px;">&nbsp;Default Sorting: </label>
                                                                    <select  class="form-control" id="itemsSorting">
                                                                    <option value="item_code"  <?php echo $itemsOrderByCode;?>> Item Code </option>
                                                                    <option value="name"  <?php echo $itemsOrderByName;?>> Item Name </option>
                                                                    <option value="item_sku"  <?php echo $itemsOrderBySku;?>> Item SKU </option>
                                                                    <option value="long_description"  <?php echo $itemsOrderByLongDescription;?>> Item Long Description </option>
                                                                    <option value="Category_Item.position"  <?php echo $itemsOrderByPosition;?>> Item Position in Category </option>

                                                                </select>
                                                                </div>
                                                            </td>
                                                            <td style="width:25%;">
                                                                <div align="left" style="margin-top: 5px;">
                                                                    <label class="label-bold  align-left" style="margin-top: 2px;">&nbsp;Default Items Per Row: </label>
                                                                    <select  class="form-control" id="defaultConfig">
                                                                        <option value="list" <?php echo $defaultConfigList;?>>List View</option>
                                                                        <option value="grid1PerRow" <?php echo $defaultConfig1PerRow;?>> 1 Item Per Row</option>
                                                                        <option value="grid2PerRow" <?php echo $defaultConfig2PerRow;?>> 2 Items Per Row</option>
                                                                        <option value="grid3PerRow" <?php echo $defaultConfig3PerRow;?>> 3 Items Per Row</option>
                                                                        <option value="grid" <?php echo $defaultConfig6PerRow;?>> 6 Items Per Row</option>
                                                                    </select>
                                                                </div>
                                                            </td>
                                                            <td style="width:25%;">
                                                                <div align="left" style="margin-top: 5px;">
                                                                    <label class="label-bold  align-left" style="margin-top: 2px;">&nbsp;Paging Position: </label>
                                                                    <select  class="form-control" id="pagingBoxPosition">
                                                                        <option value="top" >Top Right</option>
                                                                        <option value="bottom-right" <?php echo $paging_box_position_bottom_right_selected;?>>Bottom Right</option>
                                                                        <option value="bottom-center" <?php echo $paging_box_position_bottom_center_selected;?>>Bottom Center</option>
                                                                        <option value="bottom-left" <?php echo $paging_box_position_bottom_left_selected;?>>Bottom Left</option>
                                                                    </select>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </section>
                                                <section>
                                                    <table style="width: 100%;margin-top: 8px;">
                                                        <tr>
                                                            <td style="width: 25%">
                                                                <div align="left">
                                                                    <label class="label-bold  align-left" >B2B Price List: </label>
                                                                    <select  class="form-control" id="b2bRetailPrice">
                                                                        <?php echo $b2bPriceSelect; ?>
                                                                    </select>
                                                                </div>
                                                            </td>
                                                            <td style="width: 25%">
                                                                <div align="left">
                                                                    <label class="label-bold  align-left" style="margin-left: 5px;">B2B Offer Price: </label>
                                                                    <select  class="form-control" id="b2bOfferPrice">
                                                                        <?php echo $b2bOfferPriceSelect; ?>
                                                                    </select>
                                                                </div>
                                                            </td>
                                                            <td style="width: 25%">
                                                                <div align="left">
                                                                    <label class="label-bold  align-left" style="margin-left: 5px;">Show Discounts: </label>
                                                                    <select  class="form-control" id="showDiscountBubble">
                                                                        <option value="yes" <?php echo $showDiscountBubbleYes; ?>>yes</option>
                                                                        <option value="bubble" <?php echo $showDiscountBubbleBubble; ?>>Only Disc.%</option>
                                                                        <option value="price" <?php echo $showDiscountBubblePrice; ?>>Only Prev.Price</option>
                                                                        <option value="no" <?php echo $showDiscountBubbleNo; ?>>no</option>
                                                                    </select>
                                                                </div>
                                                            </td>
                                                            <td style="width: 25%">
                                                                <div align="left">
                                                                    <label class="label-bold  align-left" style="margin-left: 5px;">Recom. Retail Price: </label>
                                                                    <select  class="form-control" id="recommendedRetailPrice">
                                                                        <?php echo $priceSelect; ?>
                                                                    </select>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                <section>
                                                    <table style="width: 100%;margin-top: 8px;">
                                                        <tr>
                                                            <td style="width: 50%">
                                                                <div align="left">
                                                                    <label class="label-bold  align-left" >Show Numeric Stock: </label>
                                                                    <select  class="form-control" id="numericStock">
                                                                        <option value="yes" <?php echo $numericStockYes;?>>yes</option>
                                                                        <option value="dot" <?php echo $numericStockDot;?>>Show Dot</option>
                                                                        <option value="no" <?php echo $numericStockNo;?>>no</option>
                                                                    </select>
                                                                </div>
                                                            </td>
                                                            <td style="width: 50%">
                                                                <div align="left">
                                                                    <label class="label-bold  align-left" style="margin-left: 5px;">Get Stock From: </label>
                                                                    <select  class="form-control" id="getStockFrom">
                                                                        <option value="available" <?php echo $getStockFromAvailableOnly;?>>Available Only(Available - Reserved)</option>
                                                                        <option value="ignoreReserved" <?php echo $getStockFromAvailable;?>>Available (Ignore Reserved)</option>
                                                                        <option value="both" <?php echo $getStockFromBoth;?>>Both (Available + Reserved)</option>
                                                                    </select>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="width: 50%">
                                                                <div align="left" style="padding-top: 3px;">
                                                                    <label class="label-bold  align-left" >Show Out of Stock Items: </label>
                                                                    <select  class="form-control" id="showNonStockItems">
                                                                        <option value="yes" <?php echo $showNonStockItemsYes;?>>yes</option>
                                                                        <option value="notavailable" <?php echo $showNonStockItemsNotAvailable;?>>Temporary Unavailable</option>
                                                                        <option value="no" <?php echo $showNonStockItemsNo;?>>no</option>
                                                                    </select>
                                                                </div>
                                                            </td>
                                                            <td style="width: 50%">
                                                                <div align="left" style="padding-top: 3px;">
                                                                    <label class="label-bold  align-left" style="margin-left: 5px;">Stock Warning Quantity: </label>
                                                                    <input type="number" class="form-control" id="stockWarningQty" style="padding-left: 10px !important;" value="<?php echo $stockWarningQty;?>" />
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </table>

                                                </section>
                                                <section>
                                                    <label class="label-bold  pull-left" style="margin-top: 2px;">Get Stock From Specific Warehouses: </label>
                                                    <select  style="display: inline-block;width: 100%;" id="getStockFromWarehouse" multiple="multiple">
                                                        <?php echo $warehouseSelection; ?>
                                                    </select>
                                                </section>
                                            </div>
                                        </div>
                                    </div>
                            </article>

                            <!-- widget new products -->
                            <article class="col-xs-6 col-sm-4 col-md-4 col-lg-6" >
                                <div  class="jarviswidget jarviswidget-color-blueDark" id="wid-id-5" data-widget-editbutton="false" data-widget-deletebutton="false">
                                    <header>
                                        <span class="widget-icon"> <i class="fa fa-gears"></i> </span>
                                        <h2>Manage Product Categories </h2>
                                    </header>
                                    <!-- widget div-->
                                    <div class="no-padding" >
                                        <!-- widget content -->
                                        <div class="" style="padding: 10px; 10px; 10px; 10px;" >
                                            <div class="">
                                                <section>
                                                    <table style="width: 100%;margin-top: 3px;">
                                                        <tr>
                                                            <td style="width:50%;" >
                                                                <div align="left">
                                                                    <label class="label-bold  align-left">Include Sub-Category Products In Category: </label>
                                                            </td>
                                                            <td>
                                                                <div align="left">
                                                                    <label class="label-bold  align-left">Show Sub-Category menu on Product grid: </label>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="width:50%;">
                                                                <select  class="form-control" id="includeSubcategoryProducts">
                                                                    <option value="no" >No</option>
                                                                    <option value="yes" <?php echo $includeSubcategoryProductsYesSelected ?>>Yes</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <select  class="form-control" id="splitSubCategories">
                                                                    <option value="no" >no</option>
                                                                    <option value="yes" <?php echo $splitSubCategoriesYes?>>yes</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>

                                                </section>

                                                <section style="padding-top: 5px;">
                                                    <label class="label-bold  align-left">Category Title: </label>
                                                    <input type="text" class="form-control" id="categoryTitle" value="<?php echo $categoryTitle?>"/>
                                                </section>

                                                <section tyle="padding-top: 5px;">
                                                    <label class="label-bold  align-left">Promo Category Title: </label>
                                                    <input type="text" class="form-control" id="promoCategoriesTitle" value="<?php echo $promoCategoriesTitle?>"/>
                                                </section>

                                                <section>
                                                    <label class="label-bold  align-left">Show Category Search: </label>
                                                    <select  class="form-control" id="showCategorySearch">
                                                        <option value="yes" <?php echo $showCategorySearchYes ?>>yes</option>
                                                        <option value="no" <?php echo $showCategorySearchNo ?>>On Login</option>
                                                    </select>
                                                </section>
                                                <section>
                                                    <label class="label-bold  align-left">New Products Category: </label>
                                                    <select  class="form-control" id="newProductsCategory">
                                                        <?php echo $newProdCategorySelect ?>
                                                    </select>
                                                </section>
                                                <section>
                                                    <table style="width: 100%;margin-top: 5px;">
                                                        <tr>
                                                            <td style="width:50%;" >
                                                                <div align="left">
                                                                <label class="label-bold  align-left">Popular Products Category: </label>
                                                            </td>
                                                            <td>
                                                                <div align="left">
                                                                    <label class="label-bold  align-left">Popular Products From (Source): </label>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="width:50%;">
                                                                <select  class="form-control align-left" id="popularProductsCategory">
                                                                    <?php echo $popProdCategorySelect ?>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <select  class="form-control" id="popularProductsFrom">
                                                                    <option value="0">Order History </option>
                                                                    <option value="2" <?php echo $getPopularFromInvoice?>>Invoice History</option>
                                                                    <option value="1" <?php echo $getPopularFromERP?>>ERP Popular Products</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </section>
                                                <section>
                                                    <table style="width: 100%;margin-top: 7px;">
                                                        <tr>
                                                            <td style="width:50%;" >
                                                                <div align="left">
                                                                <label class="label-bold  align-left" >Category to Load (On Login): </label>
                                                            </td>
                                                            <td>
                                                                <div align="left">
                                                                <label class="label-bold  align-left">Category to Load (On Logout): </label>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="width:50%;">
                                                                <select  class="form-control align-left" id="categoryIdToLoad">
                                                                    <?php echo $categoryToLoadSelect ?>
                                                                    <option value="-1" <?php echo $categoryToLoadSelected?>>B2B - Image & Brand Sliders</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <select  class="form-control align-left" id="categoryIdToLoadAnonymous">
                                                                    <?php echo $categoryToLoadAnonymousSelect ?>
                                                                    <option value="-1" <?php echo $categoryToLoadAnonymousSelected?>>B2B - Image & Brand Sliders</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </section>
                                            </div>
                                        </div>
                                    </div>
                            </article>
                        </div>
                    </section>
    </div>
</div>








<script src="./js/plugin/dropzone/dropzone.min.js"></script>


<script type="text/javascript">





    function savePost() {

        var pageID                    = '<?php echo $pageID;?>';
        var showSlider                = $('#showSlider').val();
        var showBrands                = $('#showBrands').val();
        var brandSliderName           = $('#brandSliderName').val();
        var defaultConfig             = $('#defaultConfig').val();
        var pagingBoxPosition         = $('#pagingBoxPosition').val();
        var itemsPerPage              = $('#itemsPerPage').val();
        var showCategorySearch        = $('#showCategorySearch').val();
        var showPopularProducts       = $('#showPopularProducts').val();
        var popularProductsTitle      = $('#popularProductsTitle').val();
        var popularProductsNumber     = $('#popularProductsNumber').val();
        var popularProductsCategory   = $('#popularProductsCategory').val();
        var showNewProducts           = $('#showNewProducts').val();
        var newProductTitle           = $('#newProductTitle').val();
        var newProductDays            = $('#newProductDays').val();
        var newProductsCategory       = $('#newProductsCategory').val();
        var categoryIdToLoad          = $('#categoryIdToLoad').val();
        var categoryTitle             = $('#categoryTitle').val();
        var recommendedRetailPrice    = $('#recommendedRetailPrice').val();
        var b2bRetailPrice            = $('#b2bRetailPrice').val();
        var b2bOfferPrice             = $('#b2bOfferPrice').val();
        var numericStock              = $('#numericStock').val();
        var getStockFrom              = $('#getStockFrom').val();
        var promoCategoriesTitle      = $('#promoCategoriesTitle').val();
        var promotionEverywhere       = $('#promotionEverywhere').val();
        var showProductsGrid          = $('#showProductsGrid').val();
        var categoryIdToLoadAnonymous = $('#categoryIdToLoadAnonymous').val();
        var popularProductsFrom       = $('#popularProductsFrom').val();
        var itemsSorting              = $('#itemsSorting').val();
        var getStockFromWarehouse     = $('#getStockFromWarehouse').val();
        var popularProductsPosition   = $('#popularProductsPosition').val();
        var newProductsPosition       = $('#newProductsPosition').val();
        var UDFsPerRow                = $('#UDFsPerRow').val();
        var linkUDFs                  = $('#linkUDFs').val();
        var UDFID                     = $('#UDFID').val();
        var includeSubcategoryProducts= $('#includeSubcategoryProducts').val();
        var splitSubCategories        = $('#splitSubCategories').val();
        var stockWarningQty           = $('#stockWarningQty').val();
        var showAddToCartButton       = $('#showAddToCartButton').val();
        var showDiscountBubble        = $('#showDiscountBubble').val();
        var showNonStockItems         = $('#showNonStockItems').val();
        var showUserFavorites             = $('#showUserFavorites').val();
        var showOrderProductHistory   = $('#showOrderProductHistory').val();
        var orderProductHistoryLimit  = $('#orderProductHistoryLimit').val();
        var productHistorySource  = $('#productHistorySource').val();



        $.ajax({
            type: 'POST',
            url: './concc/edit_page_catalogue.php',
            dataType: 'html',
            data: {
                'pageID': pageID,
                'showSlider': showSlider,
                'showBrands': showBrands,
                'brandSliderName': brandSliderName,
                'defaultConfig': defaultConfig,
                'pagingBoxPosition': pagingBoxPosition,
                'itemsPerPage': itemsPerPage,
                'showCategorySearch': showCategorySearch,
                'showPopularProducts': showPopularProducts,
                'popularProductsTitle': popularProductsTitle,
                'popularProductsNumber': popularProductsNumber,
                'popularProductsCategory': popularProductsCategory,
                'showNewProducts': showNewProducts,
                'newProductTitle': newProductTitle,
                'newProductDays': newProductDays,
                'newProductsCategory': newProductsCategory,
                'categoryIdToLoad': categoryIdToLoad,
                'categoryTitle': categoryTitle,
                'recommendedRetailPrice': recommendedRetailPrice,
                'b2bRetailPrice': b2bRetailPrice,
                'b2bOfferPrice': b2bOfferPrice,
                'numericStock': numericStock,
                'getStockFrom': getStockFrom,
                'promoCategoriesTitle': promoCategoriesTitle,
                'promotionEverywhere': promotionEverywhere,
                'categoryIdToLoadAnonymous': categoryIdToLoadAnonymous,
                'popularProductsFrom': popularProductsFrom,
                'itemsSorting': itemsSorting,
                'getStockFromWarehouse': getStockFromWarehouse,
                'popularProductsPosition': popularProductsPosition,
                'newProductsPosition': newProductsPosition,
                'showProductsGrid': showProductsGrid,
                'UDFsPerRow': UDFsPerRow,
                'linkUDFs': linkUDFs,
                'UDFID': UDFID,
                'includeSubcategoryProducts': includeSubcategoryProducts,
                'stockWarningQty': stockWarningQty,
                'showAddToCartButton': showAddToCartButton,
                'showDiscountBubble': showDiscountBubble,
                'showNonStockItems': showNonStockItems,
                'splitSubCategories': splitSubCategories,
                'showUserFavorites':showUserFavorites,
                'showOrderProductHistory':showOrderProductHistory,
                'orderProductHistoryLimit':orderProductHistoryLimit,
                'productHistorySource':productHistorySource

            },
            success: function (result) {
                $.smallBox({
                    title: 'Success!',
                    content: "Post successfully entered",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
            }
        });

    }

    // End of SavePost()

    $(document).ready(function() {

        pageSetUp();
        $('#getStockFromWarehouse').select2();
        $('#newProductsCategory').select2();
        $('#popularProductsCategory').select2();
        $('#categoryIdToLoad').select2();
        $('#categoryIdToLoadAnonymous').select2();


    });
</script>

<script src="js/plugin/select2/select2.min.js"></script>



