<?php
include_once("../../../param.php");
require("./concc/dbinfo.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("../../../login.php");
}



function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

function endsWith($haystack, $needle)
{
    $length = strlen($needle);
    if ($length == 0) {
        return true;
    }

    return (substr($haystack, -$length) === $needle);
}


    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");



    $stm = $db->prepare("SELECT use_coupons FROM B2C_Configuration LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($useCoupons);
    while ($stm->fetch()) {
        if(strcmp($useCoupons, 'yes')==0){$useCouponsYes = 'selected';}
    }
    $stm-> close();

    $stm = $db->prepare("SELECT `subunits_1_force_integer`, 
                                       `product_code_to_show`, 
                                       `use_packing`, 
                                       `site_url`, 
                                       `primary_language`, 
                                       `ftpuser`, 
                                       `ftppass`, 
                                       `show_prices`, 
                                       `allow_quotation`, 
                                       `allow_order`, 
                                       `popular_products_days_back`, 
                                       `company_name`, 
                                       `allow_anonymous`,
                                       `facebook_link`,
                                       `instagram_link`,
                                       `twitter_link`,
                                        `logo_link`, 
                                        `gdpr_confirmation`, 
                                        `gdpr_link`, 
                                        `email_host`, 
                                        `email_from`, 
                                        `email_username`, 
                                        `email_password`,
                                        `delivery_days_after`,
                                        `delay_delivery_after_time`,
                                        `theme`,
                                        `use_max_stock_on_item`,
                                        `minimum_order`,
                                        `minimum_order_qty`,
                                        `allow_order_over_stock`,
                                        `allow_order_over_credit_limit`,
                                        `max_stock_limit`,
                                        `favicon`,
                                        `google_analytics_id`,
                                        `show_prices_with_vat`, 
                                        `show_language_selection`,
                                        `css_theme`,
                                        `footer`,
                                        `delivery_on_weekend`,
                                        `link_delivery_to_schedules`,
                                        `show_prices_anonymous`,
                                        `salesperson_for_order`,
                                        `show_customer_logo`,
                                        `multi_currency`,
                                        `weight_fee_item_id`,
                                        `categories_display_type`,
                                        `drop_ship_item_id`,
                                        `use_billing_address`,
                                        `import_order_from_file`,
                                        `order_with_attachment`,                                        
                                        `custom_delivery_time_slots`,                                        
                                        `use_loyalty`,                                        
                                        `block_order_for_loyalty`,                                        
                                        `use_as_b2c`,
                                        has_delivery_approval,
                                        order_qty_by_subunits,
                                        b2b_app_firebase_authorization_key
                                FROM `B2B_Configuration` 
                                WHERE b2b_confuguration_id=1 LIMIT 1");
    $stm->execute();
    $stm->bind_result($subUnits, $showProductCode, $usePacking, $siteURl, $language, $ftpUser, $ftpPass, $showPrices,$allowQuotation,$allowOrder,$popProdDaysBack,$companyName,$allowAnonymus,$facebook,$instagram,$twitter,$logo,$gdprConfirm,$gdprLink, $emailHost,$emailSender,$emailUsername,$emailPassword,$deliveryDaysAfter,$delayDeliveryAfter,$theme,$useMaxStock, $minimumOrder,$minimumOrderQty,$allowOrderOverStock,$allowOrderOverCreditLimit,$maxStockLimit,$custfavicon,$googleAnalyticsID,$showPricesWithVAT,$showLanguageSelection,$cssTheme,$footerLabel,$deliveryOnWeekend,$linkSchedulesToB2B,$showPricesAnonymous,$salesPersonForOrder,$showCustomerLogo,$multiCurrency,$weightFeeItemID,$categoryDisplayType,$dropshipItemID,$useBillingAddress,$importOrderFromFile,$orderWithAttachment,$customDeliveryTimeSlots,$useLoyalty,$lockOrderOnLoyalty,$useAsB2C,$hasDeliveryApproval,$orderQtyBySubunits,$b2bAppFirebaseAuthorizationKey);
    while ($stm->fetch()) {}
    $stm-> close();


    if($weightFeeItemID == 0){
        $weightFeeItemSearch = ' - No Fees on Weight - ';
    } else {
        $stm2 = $db->prepare("SELECT CONCAT(item_code, ' - ' ,name) FROM Items WHERE item_id='$weightFeeItemID'");
        $stm2-> execute();
        $stm2-> bind_result($weightFeeItemSearch);
        while ($stm2->fetch()) {}
        $stm2-> close();
    }
    if($dropshipItemID == 0){
        $dropShipItemSearch = ' - No Box Item - ';
    } else {
        $stm2 = $db->prepare("SELECT CONCAT(item_code, ' - ' ,name) FROM Items WHERE item_id='$dropshipItemID'");
        $stm2-> execute();
        $stm2-> bind_result($dropShipItemSearch);
        while ($stm2->fetch()) {}
        $stm2-> close();
    }

    $salespersonSearch ='';
    $db->set_charset("utf8");
    $stm2 = $db->prepare("SELECT salesperson_id, CONCAT(salesperson_code, ' - ' ,first_name, ' ' ,last_name) FROM SalesPersons ORDER BY salesperson_code ASC");
    $stm2-> execute();
    $stm2-> bind_result($salespersonID,$salespersonName);
    while ($stm2->fetch()) {
        if($salespersonID == $salesPersonForOrder) {
            $salespersonSearch .= "<option value='$salespersonID' selected>$salespersonName</option>";
        } else {
            $salespersonSearch .= "<option value='$salespersonID' >$salespersonName</option>";

        }
    }
    $stm2-> close();


    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT delivery_method_category_id FROM B2C_Configuration LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($deliveryMethodCategoryID);
    while ($stm->fetch()) {}
    $stm-> close();

    $categorySearch ="<option value='0' > - NONE - </option>";
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT category_id, CONCAT(category_code, ' - ' ,name) FROM Categories ORDER BY category_code ASC");
    $stm-> execute();
    $stm-> bind_result($categoryID,$categoryName);
    while ($stm->fetch()) {
        if($categoryID == $deliveryMethodCategoryID) {
            $categorySearch .= "<option value='$categoryID' selected>$categoryName</option>";
        } else {
            $categorySearch .= "<option value='$categoryID' >$categoryName</option>";

        }
    }
    $stm-> close();


    //allagh
    $stm = $db->prepare("SELECT device_id FROM B2B_Delivery_Approval_Devices LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($devicesPopIDdb);
    while ($stm->fetch()) {}
    $stm-> close();

    $selectPopDevicesDeliveryApproval = "<select class='form-control' id='popDeviceDeliveryApproval'>";
    $selectPopDevicesDeliveryApproval.="<option value='0'> - Select Device - </option>";
    $stm = $db->prepare("SELECT device_pop_id,activation_code FROM Devices_Pop WHERE status='active'");
    $stm-> execute();
    $stm-> bind_result($devicesPopID,$activationCode);
    while ($stm->fetch()) {
        if ($devicesPopID==$devicesPopIDdb){
            $selectPopDevicesDeliveryApproval.="<option value='$devicesPopID' selected>$activationCode</option>";
        }else{
            $selectPopDevicesDeliveryApproval.="<option value='$devicesPopID'>$activationCode</option>";
        }
    }
    $stm-> close();
    $selectPopDevicesDeliveryApproval .= "</select>";

    if (strcmp($hasDeliveryApproval,'yes')==0){$checkHasYesDeliveryApproval='selected';}
    if (strcmp($hasDeliveryApproval,'no')==0){$checkHasNoDeliveryApproval='selected';}

    //telos allaghs

    $favicon = "favicon.ico";
    if(strcmp($custfavicon,'')!=0){
        $favicon = $custfavicon;
    }

// Print  image, if an image exists
    if(strcmp($logo, "")!=0) {
        $logo = ltrim($logo,'./');
        $currentImage = '<section>
                            <label class="label-bold  align-left" style="font-size: 25px; color:grey;">Current Logo: </label>
                           <img class="img-rounded img-responsive center-canvas" src="//' . HTML_PATH . '/cop/b2b/' . $logo . '" width="200" height="200">
                      </section>';
    }
    if(strcmp($allowAnonymus, 'no')==0){$NoAllowAnonymous  = 'selected';}
    if(strcmp($usePacking,    'no')==0){$NoUsePacking      = 'selected';}
    if(strcmp($gdprConfirm,   'no')==0){$NoGdprConfirm     = 'selected';}
    if(strcmp($allowQuotation,'no')==0){$NoAllowQuotation  = 'selected';}
    if(strcmp($allowOrder,    'no')==0){$NoAllowOrder      = 'selected';}
    if(strcmp($language,      'el')==0){$languageGR        = 'selected';}
    if(strcmp($subUnits,     'yes')==0){$YesForceSubUnits  = 'selected';}
    if(strcmp($orderQtyBySubunits,     'yes')==0){$YesOrderQtyBySubunits = 'selected';}
    if(strcmp($showProductCode,    'barcode')==0){$barcode = 'selected';}
    if(strcmp($showProductCode,    'sku')==0){$sku = 'selected';}
    if(strcmp($showProductCode,    'none')==0){$none = 'selected';}
    if(strcmp($useMaxStock,    'yes')==0){$YesUseMaxStock  = 'selected';}
    if(strcmp($allowOrderOverStock,    'yes')==0){$YesAllowOrderOverStock  = 'selected';}
    if(strcmp($allowOrderOverStock,    'split')==0){$splitAllowOrderOverStock  = 'selected';}
    if(strcmp($showPricesWithVAT,    'yes')==0){$YesShowPricesWithVAT  = 'selected';}
    if(strcmp($showPricesWithVAT,    'both')==0){$BothShowPricesWithVAT  = 'selected';}
    if(strcmp($maxStockLimit,    '')==0){$maxStockLimit  = 0;}

    if(strcmp($linkSchedulesToB2B,   'yes')==0){$YesLinkSchedulesToB2B  = 'selected';}
    if(strcmp($deliveryOnWeekend,    'no')==0){$NoDeliveryOnWeekend  = 'selected';}
    if(strcmp($deliveryOnWeekend,    'saturday')==0){$SutDeliveryOnWeekend  = 'selected';}
    if(strcmp($deliveryOnWeekend,    'sunday')==0){$SunDeliveryOnWeekend  = 'selected';}

    if(strcmp($allowOrderOverCreditLimit,    'yes')==0){$allowOrderOverCreditLimitYes  = 'selected';}
    if(strcmp($allowOrderOverCreditLimit,    'no')==0){$allowOrderOverCreditLimitNo  = 'selected';}
    if(strcmp($allowOrderOverCreditLimit,    'online')==0){$allowOrderOverCreditLimitOnline  = 'selected';}
    if(strcmp($allowOrderOverCreditLimit,    'warning')==0){$allowOrderOverCreditLimitWarning  = 'selected';}

    if(strcmp($importOrderFromFile,    'yes')==0){$importOrderFromFileYes  = 'selected';}
    if(strcmp($importOrderFromFile,    'no')==0){$importOrderFromFileNo  = 'selected';}

    if(strcmp($orderWithAttachment,    'yes')==0){$orderWithAttachmentYes  = 'selected';}
    if(strcmp($orderWithAttachment,    'no')==0){$orderWithAttachmentNo  = 'selected';}

    if(strcmp($customDeliveryTimeSlots,    'no')==0){$customDeliveryTimeSlotsNo  = 'selected';}
    if(strcmp($customDeliveryTimeSlots,    'city')==0){$customDeliveryTimeSlotsCity  = 'selected';}
    if(strcmp($customDeliveryTimeSlots,    'zipcode')==0){$customDeliveryTimeSlotsZipcode  = 'selected';}


    if(strcmp($theme,        'NavyBlue')==0){$themeNavyBlue = 'selected';}
    if(strcmp($theme,        'DarkSlateBlue')==0){$themeDarkSlateBlue = 'selected';}
    if(strcmp($theme,        'Red')==0){$themeRed          = 'selected';}
    if(strcmp($theme,        'Green')==0){$themeGreen      = 'selected';}
    if(strcmp($theme,        'Gold')==0){$themeGold      = 'selected';}
    if(strcmp($theme,        'Orange')==0){$themeOrange      = 'selected';}
    if(strcmp($theme,        'Black')==0){$themeBlack     = 'selected';}

    if(strcmp($showLanguageSelection, 'no')==0){$showLanguageSelectionNo  = 'selected';}
    if($cssTheme ==2){$cssTheme2Selected='selected';}
    if($cssTheme ==3){$cssTheme3Selected='selected';}
    if($cssTheme ==4){$cssTheme4Selected='selected';}

if(strcmp($showPrices,    'no')==0){$NoShowPrices      = 'selected';}
else if(strcmp($showPrices,    'yes')==0 && strcmp($showPricesAnonymous,    'no')==0){$loginShowPrices      = 'selected';}

if(strcmp($showCustomerLogo,'yes')==0){$showCustomerLogoSelected      = 'selected';}
if(strcmp($multiCurrency,'yes')==0){$multiCurrencySelected      = 'selected';}
if(strcmp($useBillingAddress,'yes')==0){$useBillingAddressSelected      = 'selected';}
if(strcmp($useLoyalty,'yes')==0){$useLoyaltyYes      = 'selected';}
if(strcmp($lockOrderOnLoyalty,'yes')==0){$lockOrderOnLoyaltyYes      = 'selected';}

    if($cssTheme ==2 && $categoryDisplayType == 1){$cssTheme201Selected='selected';}
?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white"> Home / B2B General</li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">


        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-10">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-info-circle"></i>
                    B2B General
                </h3>
            </div>

            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                    <span class="pull-right show-stat-buttons">
                        <span> <button id="PostSubmit1" class="btn btn-success btn-block">
                                <i class="fa fa-check"></i>&nbsp; Save Configuration</button>
                        </span>
                    </span>
            </div>
        </div>

        <!-- NEW WIDGET START -->
        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
        <!-- row -->
            <div class="row">

                <!-- new widget -->
                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2>General Settings</h2>
                    </header>

                    <div class="widget-body">

                        <div class="row">

                            <div class="col-sm-12 no-padding">

                                    <fieldset style="padding-top:0px">
                                        <section>
                                            <h2 style="font-weight:bold;"></h2>
                                        </section>

                                        <section class="col-xs-12 col-sm-12 col-md-12 col-lg-6">
                                                    <div style="border-radius: 10px;margin-bottom:20px;margin-right:10px;margin-left:10px;box-shadow: rgba(0, 0, 0, 0.16) 0px 3px 6px, rgba(0, 0, 0, 0.23) 0px 3px 6px;">
                                                        <div class="label-bold padding-5 text-center" style="border-radius: 10px 10px 0px 0px;background-color: lightslategray ;color: white" >Company Settings</div>
                                                        <div class="padding-10">
                                                        <section>
                                                            <label class="label-bold align-left">Company Name </label>
                                                            <input type="text" class="form-control"  id="companyName" value="<?php echo $companyName?>" />
                                                        </section>
                                                        <section>
                                                            <table style="width: 100%">
                                                                <tr>
                                                                    <td><div align="left"><label class="label-bold  align-left">Company's Facebook </label></td>
                                                                    <td><div align="left"><label class="label-bold  align-left">Company's Instagram </label></td>
                                                                    <td><div align="left"><label class="label-bold  align-right">Company's Twitter </label></td>
                                                                </tr>
                                                                <tr>
                                                                    <td><input type="text" class="form-control"  id="facebookLink" value="<?php echo $facebook?>" placeholder="http://facebook.link"/></td>
                                                                    <td><input type="text" class="form-control"  id="instagramLink" value="<?php echo $instagram?>" placeholder="http://instagram.link"/></td>
                                                                    <td><input type="text" class="form-control"  id="twitterLink" value="<?php echo $twitter?>" placeholder="http://twitter.link"/></td>
                                                                </tr>
                                                            </table>
                                                        </section>
                                                        <section>
                                                            <label class="label-bold align-left">Google Analytics ID </label>
                                                            <input type="text" class="form-control"  id="googleAnalyticsID" value="<?php echo $googleAnalyticsID?>" placeholder="Google Analytics ID"/>
                                                        </section>
                                                        <section>
                                                            <table style="width: 100%">
                                                                <tr >
                                                                    <td style="width: 50%;"><div align="left"> <label class="label-bold  align-left">Primary Language: </label></div></td>
                                                                    <td style="width: 50%;"><div align="left"> <label class="label-bold  align-left">Show Language Selection: </label></div></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <select  class="form-control" id="language">
                                                                            <option value="en" >english</option>
                                                                            <option value="el" <?php echo $languageGR;?>>greek</option>
                                                                        </select>
                                                                    </td>
                                                                    <td>
                                                                        <select  class="form-control" id="showLanguage">
                                                                            <option value="yes" >yes</option>
                                                                            <option value="no" <?php echo $showLanguageSelectionNo;?>>no</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>

                                                        </section>
                                                        <section>

                                                            <table style="width: 100%">
                                                                <tr >
                                                                    <td style="width: 50%;"><div align="left"> <label class="label-bold  align-left">Product Code to Show: </label></div></td>
                                                                    <td style="width: 50%;"><div align="left"> <label class="label-bold  align-left">Popular Products (Days Back): </label></div></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <select  class="form-control" id="showProductCode">
                                                                            <option value="itemcode" >Item Code</option>
                                                                            <option value="barcode" <?php echo $barcode;?>>Bar Code</option>
                                                                            <option value="sku" <?php echo $sku;?>>Item SKU</option>
                                                                            <option value="none" <?php echo $none;?>>- None -</option>
                                                                        </select>
                                                                    </td>
                                                                    <td>
                                                                        <input type="number" min="0" class="form-control" id="popProdDaysBack" value="<?php echo $popProdDaysBack?>"/>
                                                                    </td>
                                                                </tr>
                                                            </table>


                                                        </section>
                                                    </div>
                                                </div>

                                                <div style="border-radius: 10px;margin-bottom:20px;margin-right:10px;margin-left:10px;box-shadow: rgba(0, 0, 0, 0.16) 0px 3px 6px, rgba(0, 0, 0, 0.23) 0px 3px 6px;">
                                                    <div class="label-bold padding-5 text-center" style="border-radius: 10px 10px 0px 0px;background-color: lightslategray ;color: white" >Delivery Settings</div>
                                                    <div class="padding-10">

                                                        <section>
                                                            <table style="width: 100%">
                                                                <tr>
                                                                    <td style="width: 50%;"><div align="left"><label class="label-bold  align-left" >Delivery Date (Days After): </label></td>
                                                                    <td style="width: 50%;"><div align="left"><label class="label-bold  align-right">Delay Delivery (After Time): </label></td>
                                                                </tr>
                                                                <tr>
                                                                    <td><input type="number" min="0" class="form-control" id="deliveryDaysAfter"  value="<?php echo $deliveryDaysAfter?>" /></td>
                                                                    <td><input type="time"   min="0" class="form-control" id="delayDeliveryAfter" value="<?php echo $delayDeliveryAfter?>" /></td>
                                                                </tr>
                                                            </table>
                                                        </section>

                                                        <section>
                                                            <table style="width: 100%;margin-top: 5px;">
                                                                <tr>
                                                                    <td style="width: 33%;"><div align="left"><label class="label-bold  align-left" >Delivery On Weekend: </label></td>
                                                                    <td style="width: 33%;"><div align="left"><label class="label-bold  align-right">Link Delivery To Schedules: </label></td>
                                                                    <td style="width: 33%;"><div align="left"><label class="label-bold  align-right">Schedule Holidays: </label></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <select  class="form-control" id="deliveryOnWeekend">
                                                                            <option value="yes" >Yes</option>
                                                                            <option value="saturday" <?php echo $SutDeliveryOnWeekend; ?>>Saturday Only</option>
                                                                            <option value="sunday" <?php echo $SunDeliveryOnWeekend; ?>>Sunday Only</option>
                                                                            <option value="no" <?php echo $NoDeliveryOnWeekend; ?>>no</option>
                                                                        </select>
                                                                    </td>
                                                                    <td>
                                                                        <select  class="form-control" id="linkSchedulesToB2B" >
                                                                            <option value="no" >no</option>
                                                                            <option value="yes" <?php echo $YesLinkSchedulesToB2B; ?>>yes</option>
                                                                        </select>
                                                                    </td>
                                                                    <td>
                                                                        <a href="./manage_schedule_holidays.php" target="_blank"><button type="button" class="btn btn-primary btn-block" ><i class="fa fa-calendar"></i>&nbsp; Manage Holidays</button> </a>
                                                                    </td>

                                                                </tr>
                                                                <tr>
                                                                    <td colspan="3"><div align="left"><label class="label-bold  align-left" >Custom Time Slots: </label></td>

                                                                </tr>
                                                                <tr>
                                                                    <td colspan="3">
                                                                    <select  class="form-control" id="customDeliveryTimeSlots">
                                                                        <option value="no" >no</option>
                                                                        <option value="city" <?php echo $customDeliveryTimeSlotsCity; ?>>By City</option>
                                                                        <option value="zipcode" <?php echo $customDeliveryTimeSlotsZipcode; ?>>By Zip Code</option>
                                                                    </select>
                                                                    </td>
                                                                </tr>

                                                            </table>
                                                        </section>


                                                        <section  >
                                                            <label class="label-bold  align-left" >Delivery Methods Category: </label>
                                                            <select  class="form-control" style="text-align: left;" id="deliveryMethodsCategory">
                                                                <?php echo $categorySearch;?>
                                                            </select>
                                                        </section>





                                                    </div>
                                                </div>

                                            <div style="border-radius: 10px;margin-bottom:20px;margin-right:10px;margin-left:10px;box-shadow: rgba(0, 0, 0, 0.16) 0px 3px 6px, rgba(0, 0, 0, 0.23) 0px 3px 6px;">
                                                <div class="label-bold padding-5 text-center" style="border-radius: 10px 10px 0px 0px;background-color: lightslategray ;color: white" >Delivery Approval Settings</div>
                                                <div class="padding-10">

                                                    <section>
                                                        <table style="width: 100%">
                                                            <tr>
                                                                <td style="width: 50%;"><div align="left"><label class="label-bold  align-left" >Enable Delivery Approval: </label></td>
                                                                <td style="width: 50%;"><div align="left"><label class="label-bold  align-right">Delivery Approval Device :</label></td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <select  class="form-control" id="hasDeliveryApproval">
                                                                        <option value="yes" <?php echo $checkHasYesDeliveryApproval; ?>>yes</option>
                                                                        <option value="no" <?php echo $checkHasNoDeliveryApproval; ?>>no</option>
                                                                    </select>
                                                                </td>
                                                                <td>
                                                                    <?php echo $selectPopDevicesDeliveryApproval; ?>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </section>

                                                    <section>
                                                        <table style="width: 100%">
                                                            <tr>
                                                                <td style="width: 50%;"><div align="left"><label class="label-bold  align-left" >Firebase Authorization Token: </label></td>
                                                            </tr>
                                                            <tr>
                                                                <td><textarea rows="3"  class="form-control" id="firebaseAuthorizationToken" style="padding: 3px !important;"  ><?php echo "$b2bAppFirebaseAuthorizationKey"; ?></textarea></td>
                                                            </tr>
                                                        </table>
                                                    </section>


                                                </div>
                                            </div>


                                                    <div style="border-radius: 10px;margin-bottom:20px;margin-right:10px;margin-left:10px;box-shadow: rgba(0, 0, 0, 0.16) 0px 3px 6px, rgba(0, 0, 0, 0.23) 0px 3px 6px;">
                                                     <div class="label-bold padding-5 text-center" style="border-radius: 10px 10px 0px 0px;background-color: lightslategray ;color: white" >Theme Settings</div>
                                                     <div class="padding-10">
                                                        <section>
                                                            <table style="width: 100%">
                                                                <tr>
                                                                    <td style="width: 50%;"><div align="left"><label class="label-bold align-left">Theme Style: </label></td>
                                                                    <td style="width: 50%;"><div align="left"><label class="label-bold align-left">Theme Color: </label></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <select  class="form-control" id="cssTheme">
                                                                            <option value="1" style="" >Coprime Original</option>
                                                                            <option value="2" style="" <?php echo $cssTheme2Selected;?>>Slick Site (DropDown Categories)</option>
                                                                            <option value="201" style="" <?php echo $cssTheme201Selected;?>>Slick Site (Boxed Categories)</option>
                                                                            <option value="3" style="" <?php echo $cssTheme3Selected;?>>Fantastic</option>
                                                                            <option value="4" style="" <?php echo $cssTheme4Selected;?>>Masterpiece </option>
                                                                        </select>
                                                                    </td>
                                                                    <td>
                                                                        <select  class="form-control" id="theme">
                                                                            <option value="" style="color: #0a6ebd;">Coprime Blue</option>
                                                                            <option value="DarkSlateBlue" style="color: #1d4f9c;" <?php echo $themeDarkSlateBlue;?>>Dark Slate Blue</option>
                                                                            <option value="NavyBlue" style="color: #000080;" <?php echo $themeNavyBlue;?>>Navy Blue</option>
                                                                            <option value="Red" style="color: firebrick;" <?php echo $themeRed;?>>Red</option>
                                                                            <option value="Green" style="color: green;" <?php echo $themeGreen;?>>Green</option>
                                                                            <option value="Gold" style="color: goldenrod;" <?php echo $themeGold;?>>Gold</option>
                                                                            <option value="Orange" style="color: #ff741a;" <?php echo $themeOrange;?>>Orange</option>
                                                                            <option value="Yellow" style="color: gold;" <?php echo $themeYellow;?>>Yellow</option>
                                                                            <option value="Black" style="color: black;" <?php echo $themeBlack;?>>Black</option>

                                                                        </select>
                                                                    </td>

                                                                </tr>
                                                            </table>
                                                        </section>

                                                        <section>
                                                            <label class="label-bold align-left">Logo Type:</label>
                                                                <select  class="form-control" id="showCustomerLogo">
                                                                    <option value="no"  >Current Logo</option>
                                                                    <option value="yes" <?php echo $showCustomerLogoSelected;?>>Customer Logo</option>
                                                                </select>
                                                        </section>
                                                     </div>
                                                </div>

                                                    <div style="border-radius: 10px;margin-bottom:20px;margin-right:10px;margin-left:10px;box-shadow: rgba(0, 0, 0, 0.16) 0px 3px 6px, rgba(0, 0, 0, 0.23) 0px 3px 6px;">
                                                        <div class="label-bold padding-5 text-center" style="border-radius: 10px 10px 0px 0px;background-color: lightslategray ;color: white" >Logo Settings</div>
                                                        <div class="padding-10">

                                                            <section>
                                                                <?php echo $currentImage?></br>
                                                            </section>
                                                            <section>
                                                                <label class="label-bold  align-left" style="font-size: 25px; color:grey;">Update Logo: </label>
                                                                <form  style="margin-top:10px;min-width:500px;height:120px;min-height: 0px;  !important;"  enctype= "multipart/form-data" class="dropzone" id="logodropzone"></form>
                                                            </section>
                                                            <section>
                                                                <table style="width: 100%">
                                                                    <tr>
                                                                        <td>
                                                                            <div align="left" style="width: 50%;">
                                                                                <label class="label-bold  align-left" >
                                                                                    <label class="label-bold  align-left" style="font-size: 25px; color:grey;margin-top: 45px;">Update Tab Icon: </label>
                                                                                </label>
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div style="width: 50%;">
                                                                                <img src="<?php echo '//'.HTML_PATH.'/cop/b2b/assets/ico/'.$favicon?>" alt="b2bicon" height="20" width="20" style="margin-top: 45px;">
                                                                            </div>
                                                                        </td>
                                                                    </tr>

                                                                </table>
                                                                <form  style="margin-bottom:30px;margin-top:10px;min-width:500px;height:120px;min-height: 0px;  !important;"  enctype= "multipart/form-data" class="dropzone" id="favicon"></form>
                                                            </section>

                                                        </div>
                                                    </div>

                                            </section>
                                        <section class="col-xs-12 col-sm-12 col-md-12 col-lg-6">

                                                <div style="border-radius: 10px;margin-bottom:20px;margin-right:10px;margin-left:10px;box-shadow: rgba(0, 0, 0, 0.16) 0px 3px 6px, rgba(0, 0, 0, 0.23) 0px 3px 6px;">
                                                    <div class="label-bold padding-5 text-center" style="border-radius: 10px 10px 0px 0px;background-color: lightslategray ;color: white" >Allowance Settings</div>
                                                    <div class="padding-10">

                                                        <section>
                                                            <label class="label-bold  align-left">GDPR Confirmation: </label>
                                                            <select  class="form-control" id="gdprConfirm">
                                                                <option value="yes" >yes</option>
                                                                <option value="no" <?php echo $NoGdprConfirm;?>>no</option>
                                                            </select>
                                                        </section>

                                                        <section>
                                                            <label class="label-bold  align-left">Allow Billing Address: </label>
                                                            <select  class="form-control" id="useBillingAddress">
                                                                <option value="no" >no</option>
                                                                <option value="yes" <?php echo $useBillingAddressSelected;?>>yes</option>

                                                            </select>
                                                        </section>
                                                        <section>
                                                            <label class="label-bold  align-left">Allow Anonymous: </label>
                                                            <select  class="form-control" id="allowAnonymous">
                                                                <option value="yes" >yes</option>
                                                                <option value="no" <?php echo $NoAllowAnonymous;?>>no</option>
                                                            </select>
                                                        </section>
                                                    </div>
                                                </div>

                                                <div style="border-radius: 10px;margin-bottom:20px;margin-right:10px;margin-left:10px;box-shadow: rgba(0, 0, 0, 0.16) 0px 3px 6px, rgba(0, 0, 0, 0.23) 0px 3px 6px;">
                                                    <div class="label-bold padding-5 text-center" style="border-radius: 10px 10px 0px 0px;background-color: lightslategray ;color: white" >Ordering Settings</div>
                                                    <div class="padding-10">

                                                        <section>
                                                            <label class="label-bold  align-left">Allow Quotation: </label>
                                                            <select  class="form-control" id="allowQuotation">
                                                                <option value="yes" >yes</option>
                                                                <option value="no" <?php echo $NoAllowQuotation;?>>no</option>
                                                            </select>
                                                        </section>
                                                        <section>
                                                            <table style="width: 100%;margin-top: 0px;">
                                                                <tr>
                                                                    <td><div align="left"><label class="label-bold  align-left" >Allow Order: </label></td>
                                                                    <td><div align="left"><label class="label-bold  align-right">Place Orders as Salesperson: </label></td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="width: 50%">
                                                                        <select  class="form-control" id="allowOrder">
                                                                            <option value="yes" >yes</option>
                                                                            <option value="no" <?php echo $NoAllowOrder;?>>no</option>
                                                                        </select>
                                                                    </td>
                                                                    <td style="width: 50%">
                                                                        <select  class="form-control" id="defaultSalesPerson"><?php echo $salespersonSearch;?></select>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td></td>
                                                                    <td></td>
                                                                </tr>
                                                                <tr>
                                                                    <td><div align="left"><label class="label-bold  align-right">Minimum Order Price: </label></td>
                                                                    <td><div align="left"><label class="label-bold  align-right">Minimum Order Quantity: </label></td>
                                                                </tr>
                                                                <tr>

                                                                    <td style="width: 50%">
                                                                        <input class="form-control" type="number" id="minOrder" name="minOrder" value="<?php echo $minimumOrder?>" >
                                                                    </td>
                                                                    <td style="width: 50%">
                                                                        <input class="form-control" type="number" id="minOrderQty" name="minOrderQty" value="<?php echo $minimumOrderQty?>" >
                                                                    </td>

                                                                </tr>
                                                            </table>
                                                        </section>
                                                        <section>
                                                            <table style="width: 100%;margin-top: 0px;">
                                                                <tr>
                                                                    <td><div align="left"><label class="label-bold  align-left" >Allow Order Over Stock: </label></td>
                                                                    <td><div align="left"><label class="label-bold  align-right">Max Stock Limit: </label></td>
                                                                    <td><div align="left"><label class="label-bold  align-right">Use Max Stock On Items: </label></td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="width: 33%">
                                                                        <select  class="form-control" id="allowOrderOverStock">
                                                                            <option value="no" >no</option>
                                                                            <option value="yes" <?php echo $YesAllowOrderOverStock;?>>yes</option>
                                                                            <option value="split" <?php echo $splitAllowOrderOverStock;?>>With Special Order</option>
                                                                        </select>
                                                                    </td>
                                                                    <td style="width: 33%">
                                                                        <input type="number" min="0" class="form-control" id="maxStockLimit"  value="<?php echo $maxStockLimit?>" />
                                                                    </td>
                                                                    <td style="width: 33%">
                                                                        <select  class="form-control" id="useMaxStock">
                                                                            <option value="no" >no</option>
                                                                            <option value="yes" <?php echo $YesUseMaxStock;?>>yes</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </section>
                                                        <section>
                                                            <label class="label-bold  align-left">Allow Order Over Credit Limit: </label>
                                                            <select  class="form-control" id="allowOrderOverCreditLimit">
                                                                <option value="yes" <?php echo $allowOrderOverCreditLimitYes;?>>yes</option>
                                                                <option value="warning" <?php echo $allowOrderOverCreditLimitWarning;?>>Display Warning</option>
                                                                <?php
                                                                if(strcmp($useAsB2C,'yes')==0){
                                                                    echo '<option value="online"  '.$allowOrderOverCreditLimitOnline.'>Online Payments Only (No Credit)</option>';
                                                                }
                                                                ?>

                                                                <option value="no" <?php echo $allowOrderOverCreditLimitNo;?>>no (Block Ordering)</option>
                                                            </select>
                                                        </section>
                                                        <section>
                                                            <table style="width: 100%;margin-top: 1px;">
                                                                <tr>
                                                                    <td><div align="left"><label class="label-bold  align-left" >Import Order From File: </label></td>
                                                                    <td><div align="left"><label class="label-bold  align-right">Add Attachment to Order: </label></td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="width: 50%">
                                                                        <select  class="form-control" id="importOrderFromFile">
                                                                            <option value="no" <?php echo $importOrderFromFileNo; ?>>no</option>
                                                                            <option value="yes" <?php echo $importOrderFromFileYes; ?>>yes</option>
                                                                        </select>
                                                                    </td>

                                                                    <td style="width: 50%">
                                                                        <select  class="form-control" id="orderWithAttachment">
                                                                            <option value="no" <?php echo $orderWithAttachmentNo; ?>>no</option>
                                                                            <option value="yes" <?php echo $orderWithAttachmentYes; ?>>yes</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </section>

                                                    </div>
                                                </div>

                                                <div style="border-radius: 10px;margin-bottom:20px;margin-right:10px;margin-left:10px;box-shadow: rgba(0, 0, 0, 0.16) 0px 3px 6px, rgba(0, 0, 0, 0.23) 0px 3px 6px;">
                                                    <div class="label-bold padding-5 text-center" style="border-radius: 10px 10px 0px 0px;background-color: lightslategray ;color: white" >DropShip Settings</div>
                                                    <div class="padding-10">

                                                        <section  >
                                                            <table style="width: 99%">
                                                                <tr>
                                                                    <td style="width: 50%;"><div align="left"><label class="label-bold  align-right">&nbsp;Weight Fee Item: </label></td>
                                                                    <td style="width: 50%;"><div align="left"><label class="label-bold  align-right">&nbsp;Add Box Item: </label></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <input type="text" class="form-control" style="padding-left: 5px !important;" id="weightFeeItemSearch" value='<?php echo $weightFeeItemSearch; ?>'/>
                                                                        <input type="hidden" class="form-control" id="weightFeeItemID" value='<?php echo $weightFeeItemID; ?>'/>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control" style="padding-left: 5px !important;" id="dropShipItemSearch" value='<?php echo $dropShipItemSearch; ?>'/>
                                                                        <input type="hidden" class="form-control" id="dropShipItemID" value='<?php echo $dropshipItemID; ?>'/>
                                                                    </td>

                                                                </tr>
                                                            </table>
                                                        </section>

                                                    </div>
                                                </div>

                                                <div style="border-radius: 10px;margin-bottom:20px;margin-right:10px;margin-left:10px;box-shadow: rgba(0, 0, 0, 0.16) 0px 3px 6px, rgba(0, 0, 0, 0.23) 0px 3px 6px;">
                                                    <div class="label-bold padding-5 text-center" style="border-radius: 10px 10px 0px 0px;background-color: lightslategray ;color: white" >Price & Pack Settings</div>
                                                    <div class="padding-10">

                                                        <section>

                                                            <table style="width: 100%;margin-top: 0px;">
                                                                <tr>
                                                                    <td><div align="left"><label class="label-bold  align-left">Show Prices: </label></td>
                                                                    <td><div align="left"><label class="label-bold  align-right">Show Prices with VAT: </label></td>
                                                                    <td><div align="left"><label class="label-bold  align-right">Multi Currency: </label></td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="width: 33%">
                                                                        <select  class="form-control" id="showPrices">
                                                                            <option value="yes" >yes</option>
                                                                            <option value="login" <?php echo $loginShowPrices;?>>On Login</option>
                                                                            <option value="no" <?php echo $NoShowPrices;?>>no</option>
                                                                        </select>
                                                                    </td>
                                                                    <td style="width: 33%">
                                                                        <select  class="form-control" id="showPricesWithVAT">
                                                                            <option value="no" >no</option>
                                                                            <option value="both" <?php echo $BothShowPricesWithVAT;?>>yes (Below Price)</option>
                                                                            <option value="yes" <?php echo $YesShowPricesWithVAT;?>>Include VAT on Price</option>
                                                                        </select>
                                                                    </td>
                                                                    <td style="width: 33%">
                                                                        <select  class="form-control" id="multiCurrency">
                                                                            <option value="no" >no</option>
                                                                            <option value="yes" <?php echo $multiCurrencySelected;?>>yes</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </section>
                                                        <section>
                                                            <table style="width: 100%;margin-top: 0px;">
                                                                <tr>
                                                                    <td><div align="left"><label class="label-bold  align-left">Force Integer on Quantity: </label></td>
                                                                    <td><div align="left"><label class="label-bold  align-right">Use Only Subunits on Quantity: </label></td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="width: 50%">
                                                                        <select  class="form-control" id="forceSupunits">
                                                                            <option value="no"> no</option>
                                                                            <option value="yes" <?php echo $YesForceSubUnits;?>>yes</option>
                                                                        </select>
                                                                    </td>
                                                                    <td style="width: 50%">
                                                                        <select  class="form-control" id="orderQtyBySubunits">
                                                                            <option value="no"> no</option>
                                                                            <option value="yes" <?php echo $YesOrderQtyBySubunits;?>>yes</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>

                                                        </section>

                                                        <section>
                                                            <label class="label-bold  align-left">Quantity Increment by Packing: </label>
                                                            <select  class="form-control" id="usePacking">
                                                                <option value="yes" >yes</option>
                                                                <option value="no" <?php echo $NoUsePacking;?>>no</option>
                                                            </select>
                                                        </section>
                                                        <section>

                                                            <table style="width: 100%;margin-top: 0px;">
                                                                <tr>
                                                                    <td><div align="left"><label class="label-bold  align-left">Enable Coupons: </label></td>
                                                                    <td><div align="left"><label class="label-bold  align-right">Enable Loyalty: </label></td>
                                                                    <td><div align="left"><label class="label-bold  align-right">Lock Order on Loyalty: </label></td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="width: 33%">
                                                                        <select  class="form-control" id="useCoupons">
                                                                            <option value="no" >no</option>
                                                                            <option value="yes" <?php echo $useCouponsYes;?>>yes</option>
                                                                        </select>
                                                                    </td>
                                                                    <td style="width: 33%">
                                                                        <select  class="form-control" id="useLoyalty">
                                                                            <option value="no" >no</option>
                                                                            <option value="yes" <?php echo $useLoyaltyYes;?>>yes</option>
                                                                        </select>
                                                                    </td>
                                                                    <td style="width: 33%">
                                                                        <select  class="form-control" id="lockOrderOnLoyalty">
                                                                            <option value="no" >no</option>
                                                                            <option value="yes" <?php echo $lockOrderOnLoyaltyYes;?>>yes (Limited Time Items)</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </section>

                                                    </div>
                                                </div>

                                    <div style="border-radius: 10px;margin-bottom:20px;margin-right:10px;margin-left:10px;box-shadow: rgba(0, 0, 0, 0.16) 0px 3px 6px, rgba(0, 0, 0, 0.23) 0px 3px 6px;">
                                        <div class="label-bold padding-5 text-center" style="border-radius: 10px 10px 0px 0px;background-color: lightslategray ;color: white" >GDPR Settings</div>
                                        <div class="padding-10">

                                            <section>
                                                <label class="label-bold  align-left" style="font-size: 25px; color:grey;">Current GDPR: </label>
                                                <a href="../../../b2b/pdfs/<?php echo basename($gdprLink);?>" target="_blank">
                                                    <img style='display: block;margin-left: auto;margin-right: auto;width: 20%;' src='//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/pdficon.png' alt='<?php echo basename($gdprLink);?>'/>
                                                </a>
                                            </section>
                                            <section>
                                                <label class="label-bold  align-left"  style="font-size: 25px; color:grey;">Update GDPR: </label>
                                                <form  style="margin-top:10px;min-width:500px;height:120px;min-height: 0px;   !important;"  enctype= "multipart/form-data" class="dropzone" id="gdprdropzone"></form>
                                            </section>

                                            <section >
                                                <label class="label-bold  align-left" style="font-size: 25px; color:grey;margin-top: 35px;margin-bottom: 10px;">Reset GDPR Confirmation: </label>
                                                <button class="btn btn-primary pull-right" data-toggle="modal" data-target="#addCustomerGroupModal" style=" font-size: 15px; width: 200px; margin-top: 35px;margin-bottom: 10px;">Reset GDPR for All Users</button>
                                            </section>

                                        </div>
                                    </div>

                                </section>
                                    </fieldset>

                            </div>

                        </div>

                    </div>
                    <!-- end widget div -->
                </div>
                <!-- end widget -->

                <!-- new widget -->
                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-2" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2>Footer Custom Text</h2>
                    </header>

                    <div class="widget-body">

                        <textarea id="footerText" name="footerText" ></textarea>

                    </div>
                    <!-- end widget div -->
                </div>
                <!-- end widget -->

                <!-- new widget -->
                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-3" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2>Email Hosting Settings</h2>
                    </header>

                    <div class="widget-body">

                        <div class="row">

                            <div class="col-sm-12">

                                <form id="sliderForm" method="post" class="smart-form" enctype="multipart/form-data">

                                    <fieldset style="padding-top:0px">

                                        <section class="col-sm-12">
                                            <section class="col-xs-12 col-sm-12 col-md-12 col-lg-2">
                                                <section>
                                                    <label class="label-bold align-left">Email Host </label>
                                                    <input type="text" class="form-control"  id="emailHost" value="<?php echo $emailHost?>" />
                                                </section>
                                            </section>
                                            <section class="col-xs-12 col-sm-12 col-md-12 col-lg-1"></section>
                                            <section class="col-xs-12 col-sm-12 col-md-12 col-lg-2">
                                                <section>
                                                    <label class="label-bold  align-left">Sender Email </label>
                                                    <input type="text" class="form-control"  id="emailSender" value="<?php echo $emailSender?>" />
                                                </section>
                                            </section>
                                            <section class="col-xs-12 col-sm-12 col-md-12 col-lg-1"></section>
                                            <section class="col-xs-12 col-sm-12 col-md-12 col-lg-2">
                                                <section>
                                                    <label class="label-bold  align-left">Mail Server Username </label>
                                                    <input type="text" class="form-control"  id="emailUsername" value="<?php echo $emailUsername?>" />
                                                </section>
                                            </section>
                                            <section class="col-xs-12 col-sm-12 col-md-12 col-lg-1"></section>
                                            <section class="col-xs-12 col-sm-12 col-md-12 col-lg-2">
                                                <section>
                                                    <label class="label-bold  align-left">Mail Server Password </label>
                                                    <input type="text" class="form-control"  id="emailPassword" value="<?php echo $emailPassword?>" />

                                                </section>
                                            </section>

                                        </section>
                                        <section class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                            <section class="col-xs-12 col-sm-12 col-md-12 col-lg-3"></section>
                                            <section class="col-xs-12 col-sm-12 col-md-12 col-lg-2">
                                                <button type="button" id="testEmail"  class="btn btn-success btn-block" style="height: 30px;" onclick="testEmailHost()">Test Email Host</button>
                                            </section>
                                            <section class="col-xs-12 col-sm-12 col-md-12 col-lg-1"></section>
                                            <section class="col-xs-12 col-sm-12 col-md-12 col-lg-2">
                                                <input id="emailTest" name="emailTest" value="" class="form-control" placeholder="Recipient email for Test">
                                            </section>
                                        </section>
                                        <section class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                            <div id="debugEmailHost" ></div>
                                        </section>
                                    </fieldset>
                                </form>

                                <footer>

                                </footer>

                            </div>

                        </div>

                    </div>
                    <!-- end widget div -->
                </div>
                <!-- end widget -->
            </div>

        </article>

        <!-- end row -->
    </div>


    <!-- Modal -->
    <div class="modal fade" id="addCustomerGroupModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
                        &times;
                    </button>
                    <h4 class="modal-title" style="margin-left:10px;"><i class="fa fa-lg fa-fw fa-group"></i><strong style="padding-left:5px;">Reset GDPR for All Users?</strong></h4>
                </div>

                        </select>
                        <footer class="modal-footer" >
                            <button onclick="$('#addCustomerGroupModal').modal('toggle');" class="btn btn-default" type="button" style="margin-right:10px;">
                                Cancel
                            </button>
                            <button id="resetGdprButton" class="btn btn-primary" style="margin-right:20px;" onclick="$('#addCustomerGroupModal').modal('toggle');resetGdpr();">
                                Reset GDPR
                            </button>
                        </footer>


            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </div><!-- /.modal -->



</div>




<script src="./js/plugin/dropzone/dropzone.min.js"></script>


<script type="text/javascript">


    function resetGdpr() {
        $.ajax({
            type: 'POST',
            url: './concc/resetGdprConfirm.php',
            dataType: 'html',
            success: function (result) {

                $.smallBox({
                    title: 'Success!',
                    content: "Post successfully entered",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
            }
        });
    }

    function testEmailHost() {

        $('#debugEmailHost').html("Generating Results...");

        var emailHost        = $('#emailHost').val();
        var emailSender      = $('#emailSender').val();
        var emailUsername    = $('#emailUsername').val();
        var emailPassword    = $('#emailPassword').val();
        var emailTest        = $('#emailTest').val();

        $.ajax({
            type: 'POST',
            url: './sendTemplateEmail.php',
            dataType: 'html',
            data: {
                'emailHost': emailHost,
                'emailTest': emailTest,
                'emailSender': emailSender,
                'emailUsername': emailUsername,
                'emailPassword': emailPassword,
                'test': "yes"
            },
            success: function (result) {

                $('#debugEmailHost').html(result);
            }
        });
    }

    function savePost() {

        var usePacking          = $('#usePacking').val();
        var showProductCode     = $('#showProductCode').val();
        var forceSupunits       = $('#forceSupunits').val();
        var orderQtyBySubunits  = $('#orderQtyBySubunits').val();
        var showPrices          = $('#showPrices').val();
        var allowOrder          = $('#allowOrder').val();
        var gdprLink            = $('#gdprLink').val();
        var allowQuotation      = $('#allowQuotation').val();
        var allowAnonymous      = $('#allowAnonymous').val();
        var gdprConfirm         = $('#gdprConfirm').val();
        var language            = $('#language').val();
        var popProdDaysBack     = $('#popProdDaysBack').val();
        var companyName         = $('#companyName').val();
        var facebookLink        = $('#facebookLink').val();
        var instagramLink        = $('#instagramLink').val();
        var twitterLink         = $('#twitterLink').val();
        var emailHost           = $('#emailHost').val();
        var emailSender         = $('#emailSender').val();
        var emailUsername       = $('#emailUsername').val();
        var emailPassword       = $('#emailPassword').val();
        var deliveryDays        = $('#deliveryDaysAfter').val();
        var delayDelivery       = $('#delayDeliveryAfter').val();
        var useMaxStock         = $('#useMaxStock').val();
        var theme               = $('#theme').val();
        var minOrder            = $('#minOrder').val();
        var minOrderQty         = $('#minOrderQty').val();
        var allowOrderOverStock = $('#allowOrderOverStock').val();
        var maxStockLimit       = $('#maxStockLimit').val();
        var googleAnalyticsID   = $('#googleAnalyticsID').val();
        var showPricesWithVAT   = $('#showPricesWithVAT').val();
        var defaultSalesPerson  = $('#defaultSalesPerson').val();
        var showLanguage        = $('#showLanguage').val();
        var cssTheme            = $('#cssTheme').val();
        var footer              = $('#footerText').summernote('code');
        var linkSchedulesToB2B  = $('#linkSchedulesToB2B').val();
        var deliveryOnWeekend   = $('#deliveryOnWeekend').val();
        var showCustomerLogo    = $('#showCustomerLogo').val();
        var allowOrderOverCreditLimit   = $('#allowOrderOverCreditLimit').val();
        var deliveryMethodsCategory   = $('#deliveryMethodsCategory').val();
        var multiCurrency   = $('#multiCurrency').val();
        var weightFeeItemID   = $('#weightFeeItemID').val();
        var dropShipItemID   = $('#dropShipItemID').val();
        var useBillingAddress   = $('#useBillingAddress').val();
        var orderWithAttachment   = $('#orderWithAttachment').val();
        var importOrderFromFile   = $('#importOrderFromFile').val();
        var customDeliveryTimeSlots   = $('#customDeliveryTimeSlots').val();
        var useCoupons   = $('#useCoupons').val();
        var useLoyalty   = $('#useLoyalty').val();
        var lockOrderOnLoyalty   = $('#lockOrderOnLoyalty').val();
        var hasDeliveryApproval = $("#hasDeliveryApproval option:selected").val();
        var popDeviceDeliveryApproval = $("#popDeviceDeliveryApproval option:selected").val();
        var firebaseAuthorizationToken = $('#firebaseAuthorizationToken').val();

        $.ajax({
                type: 'POST',
                url: './concc/edit_general.php',
                dataType: 'html',
                data: {
                    'usePacking': usePacking,
                    'showProductCode': showProductCode,
                    'forceSupunits': forceSupunits,
                    'orderQtyBySubunits':orderQtyBySubunits,
                    'showPrices': showPrices,
                    'allowOrder': allowOrder,
                    'gdprLink': gdprLink,
                    'allowQuotation': allowQuotation,
                    'allowAnonymous': allowAnonymous,
                    'gdprConfirm': gdprConfirm,
                    'companyName': companyName,
                    'facebookLink': facebookLink,
                    'instagramLink': instagramLink,
                    'twitterLink': twitterLink,
                    'popProdDaysBack': popProdDaysBack,
                    'emailHost': emailHost,
                    'emailSender': emailSender,
                    'emailUsername': emailUsername,
                    'emailPassword': emailPassword,
                    'deliveryDays': deliveryDays,
                    'delayDelivery': delayDelivery,
                    'useMaxStock': useMaxStock,
                    'theme': theme,
                    'minOrder': minOrder,
                    'minOrderQty': minOrderQty,
                    'allowOrderOverStock': allowOrderOverStock,
                    'maxStockLimit': maxStockLimit,
                    'googleAnalyticsID': googleAnalyticsID,
                    'showPricesWithVAT': showPricesWithVAT,
                    'defaultSalesPerson': defaultSalesPerson,
                    'showLanguage': showLanguage,
                    'cssTheme': cssTheme,
                    'footer': footer,
                    'linkSchedulesToB2B': linkSchedulesToB2B,
                    'deliveryOnWeekend': deliveryOnWeekend,
                    'allowOrderOverCreditLimit': allowOrderOverCreditLimit,
                    'deliveryMethodsCategory': deliveryMethodsCategory,
                    'showCustomerLogo': showCustomerLogo,
                    'multiCurrency': multiCurrency,
                    'weightFeeItemID': weightFeeItemID,
                    'dropShipItemID': dropShipItemID,
                    'useBillingAddress': useBillingAddress,
                    'orderWithAttachment': orderWithAttachment,
                    'importOrderFromFile': importOrderFromFile,
                    'customDeliveryTimeSlots': customDeliveryTimeSlots,
                    'useCoupons': useCoupons,
                    'useLoyalty': useLoyalty,
                    'lockOrderOnLoyalty': lockOrderOnLoyalty,
                    'language': language,
                    'hasDeliveryApproval':hasDeliveryApproval,
                    'popDeviceDeliveryApproval':popDeviceDeliveryApproval,
                    'firebaseAuthorizationToken':firebaseAuthorizationToken
                },
                success: function (result) {
console.log(result);
                    $.smallBox({
                        title: 'Success!',
                        content: "Post successfully entered",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                    // setTimeout(function(){location.reload();}, 10);
                }
            });

    }

    // End of SavePost()

    $(document).ready(function() {

        pageSetUp();
        initAutocomplete();

        $('#deliveryMethodsCategory').select2();
        $('#popDeviceDeliveryApproval').select2();
        $('#footerText').summernote({
            callbacks: {
                onImageUpload: function(files) {
                    for(let i=0; i < files.length; i++) {
                        $.upload(files[i]);
                    }
                }
            },
            height: 200,                 // set editor height
            minHeight: 200,             // set minimum height of editor
            maxHeight: null,            // set maximum height of editor
            focus: false                // set focus to editable area after initializing summernote

        });

        $.upload = function (file) {
            let out = new FormData();
            out.append('file', file, file.name);

            $.ajax({
                method: 'POST',
                url: 'summernoteImageUpload.php',
                contentType: false,
                cache: false,
                processData: false,
                data: out,
                success: function (img) {
                    $('#footerText').summernote('insertImage', img);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.error(textStatus + " " + errorThrown);
                }
            });
        };


        $.ajax({
            type: "POST",
            url: './concc/getFooterText.php',
            data: {},
            success: function (result) {
                // alert(result);
                $('#footerText').summernote('code', result);

            }
        });

        Dropzone.autoDiscover = false;



        $("#logodropzone").dropzone({
            url: "./concc/edit_general.php",
            maxFiles: 1,
            addRemoveLinks : true,
            maxFileSize: 10,
            dictResponseError: 'Error uploading file!',
            autoProcessQueue:false,
            uploadMultiple: true,
            paramName: 'logoFile',
            acceptedFiles: ".png,.jpg,.gif,.bmp,.jpeg",


            init: function() {

                var thisDropzone1 = this;

                //$.getJSON('../getProductImages.php?itemID=<?php //echo $itemID?>//', function(data) { // get the json response
                //
                //    $.each(data, function(key,value){ //loop through it
                //
                //        var mockFile = { name: value.name, size: value.size }; // here we get the file name and size as response
                //
                //        thisDropzone.options.addedfile.call(thisDropzone, mockFile);
                //
                //        thisDropzone.options.thumbnail.call(thisDropzone, mockFile, "../productImages/"+value.name+".jpg");//uploadsfolder is the folder where you have all those uploaded files
                //
                //    });
                //
                //});

                dzClosure1 = this; // Makes sure that 'this' is understood inside the functions below.

                // for Dropzone to process the queue (instead of default form behavior):
                document.getElementById("PostSubmit1").addEventListener("click", function(e) {
                    // Make sure that the form isn't actually being sent.
                    e.preventDefault();
                    e.stopPropagation();
                    if (dzClosure1.getQueuedFiles().length > 0) {
                        dzClosure1.processQueue();
                    }
                    else {
                        savePost();
                    }

                });


                //send all the form data along with the files:
                this.on("sendingmultiple", function(data, xhr, formData) {

                    formData.append("usePacking"      , $('#usePacking').val());
                    formData.append("showProductCode" , $("#showProductCode").val());
                    formData.append("forceSupunits"   , $("#forceSupunits").val());
                    formData.append("orderQtyBySubunits"   , $("#orderQtyBySubunits").val());
                    formData.append("showPrices"      , $("#showPrices").val());
                    formData.append("allowOrder"      , $("#allowOrder").val());
                    formData.append("allowAnonymous"  , $("#allowAnonymous").val());
                    formData.append("allowQuotation"  , $("#allowQuotation").val());
                    formData.append("gdprConfirm"     , $("#gdprConfirm").val());
                    formData.append("language"        , $("#language").val());
                    formData.append("popProdDaysBack" , $("#popProdDaysBack").val());
                    formData.append("companyName"     , $("#companyName").val());
                    formData.append("facebookLink"    , $("#facebookLink").val());
                    formData.append("instagramLink"    , $("#instagramLink").val());
                    formData.append("twitterLink"     , $("#twitterLink").val());
                    formData.append("gdprLink"        , $("#gdprLink").val());
                    formData.append("emailHost"       , $("#emailHost").val());
                    formData.append("emailSender"     , $("#emailSender").val());
                    formData.append("emailUsername"   , $("#emailUsername").val());
                    formData.append("emailPassword"   , $("#emailPassword").val());
                    formData.append("deliveryDays"    , $("#deliveryDaysAfter").val());
                    formData.append("delayDelivery"   , $("#delayDeliveryAfter").val());
                    formData.append("useMaxStock"     , $("#useMaxStock").val());
                    formData.append("theme"           , $("#theme").val());
                    formData.append("minOrder"        , $("#minOrder").val());
                    formData.append("minOrderQty"        , $("#minOrderQty").val());
                    formData.append("allowOrderOverStock" , $("#allowOrderOverStock").val());
                    formData.append("maxStockLimit"   , $("#maxStockLimit").val());
                    formData.append("googleAnalyticsID"   , $("#googleAnalyticsID").val());
                    formData.append("showPricesWithVAT"   , $("#showPricesWithVAT").val());
                    formData.append("defaultSalesPerson"   , $("#defaultSalesPerson").val());
                    formData.append("showLanguage"      , $("#showLanguage").val());
                    formData.append("cssTheme"          , $("#cssTheme").val());
                    formData.append("footer"            , $('#footerText').summernote('code'));
                    formData.append("linkSchedulesToB2B"   , $("#linkSchedulesToB2B").val());
                    formData.append("deliveryOnWeekend"   , $("#deliveryOnWeekend").val());
                    formData.append("showPricesWithVAT"   , $("#showPricesWithVAT").val());
                    formData.append("showCustomerLogo"   , $("#showCustomerLogo").val());
                    formData.append("allowOrderOverCreditLimit"   , $("#allowOrderOverCreditLimit").val());
                    formData.append("deliveryMethodsCategory"   , $("#deliveryMethodsCategory").val());
                    formData.append("multiCurrency"   , $("#multiCurrency").val());
                    formData.append("weightFeeItemID"   , $("#weightFeeItemID").val());
                    formData.append("dropShipItemID"   , $("#dropShipItemID").val());
                    formData.append("useBillingAddress"   , $("#useBillingAddress").val());
                    formData.append("importOrderFromFile"   , $("#importOrderFromFile").val());
                    formData.append("orderWithAttachment"   , $("#orderWithAttachment").val());
                    formData.append("customDeliveryTimeSlots"   , $("#customDeliveryTimeSlots").val());
                    formData.append("useCoupons"   , $("#useCoupons").val());
                    formData.append("useLoyalty"   , $("#useLoyalty").val());
                    formData.append("lockOrderOnLoyalty"   , $("#lockOrderOnLoyalty").val());
                    formData.append("hasDeliveryApproval"   , $("#hasDeliveryApproval").val());
                    formData.append("popDeviceDeliveryApproval"   , $("#popDeviceDeliveryApproval").val());




                });

                this.on("success", function(file, responseText) {

                    this.removeAllFiles(true);

                    $.smallBox({
                        title: "Success!",
                        content: "Post successfully entered",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                    setTimeout(function(){location.reload();}, 10);

                });

            },
            removedfile: function(file) {
                // var name = file.name;
                //alert(file.name);
                //$.ajax({
                //    type: 'POST',
                //    url: '../deleteProductImage.php',
                //    data: {imageName:name,itemID:<?php //echo $itemID?>//},
                //    dataType: 'html'
                //
                //});

                var _ref;
                return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
            }
        }).get(0).dropzone.on("addedfile", function(file)
        {

        });

        $("#gdprdropzone").dropzone({
            url: "./concc/edit_general.php",
            maxFiles: 1,
            addRemoveLinks : true,
            maxFileSize: 10,
            dictResponseError: 'Error uploading file!',
            autoProcessQueue:false,
            uploadMultiple: true,
            paramName: 'gdprFile',
            acceptedFiles: ".pdf",

            init: function() {

                var thisDropzone2 = this;

                //$.getJSON('../getProductImages.php?itemID=<?php //echo $itemID?>//', function(data) { // get the json response
                //
                //    $.each(data, function(key,value){ //loop through it
                //
                //        var mockFile = { name: value.name, size: value.size }; // here we get the file name and size as response
                //
                //        thisDropzone.options.addedfile.call(thisDropzone, mockFile);
                //
                //        thisDropzone.options.thumbnail.call(thisDropzone, mockFile, "../productImages/"+value.name+".jpg");//uploadsfolder is the folder where you have all those uploaded files
                //
                //    });
                //
                //});

                dzClosure2 = this; // Makes sure that 'this' is understood inside the functions below.

                // for Dropzone to process the queue (instead of default form behavior):
                document.getElementById("PostSubmit1").addEventListener("click", function(e) {
                    // Make sure that the form isn't actually being sent.
                    e.preventDefault();
                    e.stopPropagation();
                    if (dzClosure2.getQueuedFiles().length > 0) {
                        dzClosure2.processQueue();
                    }


                });


                //send all the form data along with the files:
                this.on("sendingmultiple", function(data, xhr, formData) {

                    formData.append("usePacking"      , $('#usePacking').val());
                    formData.append("showProductCode" , $("#showProductCode").val());
                    formData.append("forceSupunits"   , $("#forceSupunits").val());
                    formData.append("orderQtyBySubunits"   , $("#orderQtyBySubunits").val());
                    formData.append("showPrices"      , $("#showPrices").val());
                    formData.append("allowOrder"      , $("#allowOrder").val());
                    formData.append("allowAnonymous"  , $("#allowAnonymous").val());
                    formData.append("allowQuotation"  , $("#allowQuotation").val());
                    formData.append("gdprConfirm"     , $("#gdprConfirm").val());
                    formData.append("language"        , $("#language").val());
                    formData.append("popProdDaysBack" , $("#popProdDaysBack").val());
                    formData.append("companyName"     , $("#companyName").val());
                    formData.append("facebookLink"    , $("#facebookLink").val());
                    formData.append("instagramLink"    , $("#instagramLink").val());
                    formData.append("twitterLink"     , $("#twitterLink").val());
                    formData.append("gdprLink"        , $("#gdprLink").val());
                    formData.append("emailHost"       , $("#emailHost").val());
                    formData.append("emailSender"     , $("#emailSender").val());
                    formData.append("emailUsername"   , $("#emailUsername").val());
                    formData.append("emailPassword"   , $("#emailPassword").val());
                    formData.append("deliveryDays"    , $("#deliveryDays").val());
                    formData.append("deliveryDays"    , $("#deliveryDaysAfter").val());
                    formData.append("delayDelivery"   , $("#delayDeliveryAfter").val());
                    formData.append("theme"           , $("#theme").val());
                    formData.append("minOrderQty"        , $("#minOrderQty").val());
                    formData.append("allowOrderOverStock" , $("#allowOrderOverStock").val());
                    formData.append("maxStockLimit"   , $("#maxStockLimit").val());
                    formData.append("googleAnalyticsID"   , $("#googleAnalyticsID").val());
                    formData.append("showPricesWithVAT"   , $("#showPricesWithVAT").val());
                    formData.append("defaultSalesPerson"   , $("#defaultSalesPerson").val());
                    formData.append("showLanguage"      , $("#showLanguage").val());
                    formData.append("cssTheme"          , $("#cssTheme").val());
                    formData.append("footer"            , $('#footerText').summernote('code'));
                    formData.append("linkSchedulesToB2B"   , $("#linkSchedulesToB2B").val());
                    formData.append("deliveryOnWeekend"   , $("#deliveryOnWeekend").val());
                    formData.append("showPricesWithVAT"   , $("#showPricesWithVAT").val());
                    formData.append("showCustomerLogo"   , $("#showCustomerLogo").val());
                    formData.append("allowOrderOverCreditLimit"   , $("#allowOrderOverCreditLimit").val());
                    formData.append("deliveryMethodsCategory"   , $("#deliveryMethodsCategory").val());
                    formData.append("multiCurrency"   , $("#multiCurrency").val());
                    formData.append("weightFeeItemID"   , $("#weightFeeItemID").val());
                    formData.append("dropShipItemID"   , $("#dropShipItemID").val());
                    formData.append("useBillingAddress"   , $("#useBillingAddress").val());
                    formData.append("importOrderFromFile"   , $("#importOrderFromFile").val());
                    formData.append("orderWithAttachment"   , $("#orderWithAttachment").val());
                    formData.append("customDeliveryTimeSlots"   , $("#customDeliveryTimeSlots").val());
                    formData.append("useCoupons"   , $("#useCoupons").val());
                    formData.append("useLoyalty"   , $("#useLoyalty").val());
                    formData.append("lockOrderOnLoyalty"   , $("#lockOrderOnLoyalty").val());
                    formData.append("hasDeliveryApproval"   , $("#hasDeliveryApproval").val());
                    formData.append("popDeviceDeliveryApproval"   , $("#popDeviceDeliveryApproval").val());


                });

                this.on("success", function(file, responseText) {
                    this.removeAllFiles(true);

                    $.smallBox({
                        title: "Success!",
                        content: "Post successfully entered",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                    setTimeout(function(){location.reload();}, 10);

                });

            },
            removedfile: function(file) {
                // var name = file.name;
                //alert(file.name);
                //$.ajax({
                //    type: 'POST',
                //    url: '../deleteProductImage.php',
                //    data: {imageName:name,itemID:<?php //echo $itemID?>//},
                //    dataType: 'html'
                //
                //});

                var _ref;
                return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
            }
        }).get(0).dropzone.on("addedfile", function(file)
        {

        });

        $("#favicon").dropzone({
            url: "./concc/edit_general.php",
            maxFiles: 1,
            addRemoveLinks : true,
            maxFileSize: 10,
            dictResponseError: 'Error uploading file!',
            autoProcessQueue:false,
            uploadMultiple: true,
            paramName: 'faviconFile',
            acceptedFiles: ".png,.jpg,.gif,.bmp,.jpeg,.ico",


            init: function() {

                var thisDropzone = this;

                //$.getJSON('../getProductImages.php?itemID=<?php //echo $itemID?>//', function(data) { // get the json response
                //
                //    $.each(data, function(key,value){ //loop through it
                //
                //        var mockFile = { name: value.name, size: value.size }; // here we get the file name and size as response
                //
                //        thisDropzone.options.addedfile.call(thisDropzone, mockFile);
                //
                //        thisDropzone.options.thumbnail.call(thisDropzone, mockFile, "../productImages/"+value.name+".jpg");//uploadsfolder is the folder where you have all those uploaded files
                //
                //    });
                //
                //});

                dzClosure3 = this; // Makes sure that 'this' is understood inside the functions below.

                // for Dropzone to process the queue (instead of default form behavior):
                document.getElementById("PostSubmit1").addEventListener("click", function(e) {
                    // Make sure that the form isn't actually being sent.
                    e.preventDefault();
                    e.stopPropagation();
                    if (dzClosure3.getQueuedFiles().length > 0) {
                        dzClosure3.processQueue();
                    }


                });


                //send all the form data along with the files:
                this.on("sendingmultiple", function(data, xhr, formData) {

                    formData.append("usePacking"      , $('#usePacking').val());
                    formData.append("showProductCode" , $("#showProductCode").val());
                    formData.append("forceSupunits"   , $("#forceSupunits").val());
                    formData.append("orderQtyBySubunits"   , $("#orderQtyBySubunits").val());
                    formData.append("showPrices"      , $("#showPrices").val());
                    formData.append("allowOrder"      , $("#allowOrder").val());
                    formData.append("allowAnonymous"  , $("#allowAnonymous").val());
                    formData.append("allowQuotation"  , $("#allowQuotation").val());
                    formData.append("gdprConfirm"     , $("#gdprConfirm").val());
                    formData.append("language"        , $("#language").val());
                    formData.append("popProdDaysBack" , $("#popProdDaysBack").val());
                    formData.append("companyName"     , $("#companyName").val());
                    formData.append("facebookLink"    , $("#facebookLink").val());
                    formData.append("instagramLink"    , $("#instagramLink").val());
                    formData.append("twitterLink"     , $("#twitterLink").val());
                    formData.append("gdprLink"        , $("#gdprLink").val());
                    formData.append("emailHost"       , $("#emailHost").val());
                    formData.append("emailSender"     , $("#emailSender").val());
                    formData.append("emailUsername"   , $("#emailUsername").val());
                    formData.append("emailPassword"   , $("#emailPassword").val());
                    formData.append("deliveryDays"    , $("#deliveryDaysAfter").val());
                    formData.append("delayDelivery"   , $("#delayDeliveryAfter").val());
                    formData.append("useMaxStock"     , $("#useMaxStock").val());
                    formData.append("theme"           , $("#theme").val());
                    formData.append("minOrderQty"        , $("#minOrderQty").val());
                    formData.append("allowOrderOverStock" , $("#allowOrderOverStock").val());
                    formData.append("maxStockLimit"   , $("#maxStockLimit").val());
                    formData.append("googleAnalyticsID"   , $("#googleAnalyticsID").val());
                    formData.append("showPricesWithVAT"   , $("#showPricesWithVAT").val());
                    formData.append("defaultSalesPerson"   , $("#defaultSalesPerson").val());
                    formData.append("showLanguage"      , $("#showLanguage").val());
                    formData.append("cssTheme"          , $("#cssTheme").val());
                    formData.append("footer"            , $('#footerText').summernote('code'));
                    formData.append("linkSchedulesToB2B"   , $("#linkSchedulesToB2B").val());
                    formData.append("deliveryOnWeekend"   , $("#deliveryOnWeekend").val());
                    formData.append("showPricesWithVAT"   , $("#showPricesWithVAT").val());
                    formData.append("showCustomerLogo"   , $("#showCustomerLogo").val());
                    formData.append("allowOrderOverCreditLimit"   , $("#allowOrderOverCreditLimit").val());
                    formData.append("deliveryMethodsCategory"   , $("#deliveryMethodsCategory").val());
                    formData.append("multiCurrency"   , $("#multiCurrency").val());
                    formData.append("weightFeeItemID"   , $("#weightFeeItemID").val());
                    formData.append("dropShipItemID"   , $("#dropShipItemID").val());
                    formData.append("useBillingAddress"   , $("#useBillingAddress").val());
                    formData.append("importOrderFromFile"   , $("#importOrderFromFile").val());
                    formData.append("orderWithAttachment"   , $("#orderWithAttachment").val());
                    formData.append("customDeliveryTimeSlots"   , $("#customDeliveryTimeSlots").val());
                    formData.append("useCoupons"   , $("#useCoupons").val());
                    formData.append("useLoyalty"   , $("#useLoyalty").val());
                    formData.append("lockOrderOnLoyalty"   , $("#lockOrderOnLoyalty").val());
                    formData.append("hasDeliveryApproval"   , $("#hasDeliveryApproval").val());
                    formData.append("popDeviceDeliveryApproval"   , $("#popDeviceDeliveryApproval").val());




                });

                this.on("success", function(file, responseText) {
                    this.removeAllFiles(true);

                    $.smallBox({
                        title: "Success!",
                        content: "Post successfully entered",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                    setTimeout(function(){location.reload();}, 10);

                });

            },
            removedfile: function(file) {


                var _ref;
                return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
            }
        }).get(0).dropzone.on("addedfile", function(file)
        {

        });

    });

    function initAutocomplete()
    {
        $("#weightFeeItemSearch").autocomplete({
            source: "./concc/item_autocomplete.php",
            autoFocus: true,

            select: function (event, ui) {
                // Modify this  information to match the information coming from assets/ajax-services/fetch-inventory.php
                $('#weightFeeItemID').val(ui.item.item_id); // Hidden input on form
                $('#weightFeeItemSearch').text(ui.item.item_code+' - '+ui.item.name);
            }
        });
        $("#dropShipItemSearch").autocomplete({
            source: "./concc/item_autocomplete.php",
            autoFocus: true,

            select: function (event, ui) {
                // Modify this  information to match the information coming from assets/ajax-services/fetch-inventory.php
                $('#dropShipItemID').val(ui.item.item_id); // Hidden input on form
                $('#dropShipItemSearch').text(ui.item.item_code+' - '+ui.item.name);
            }
        });
    }
</script>

<script src="js/plugin/select2/select2.min.js"></script>
<!-- include summernote css/js -->
<link rel="stylesheet" href="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.css">
<script type="text/javascript" src="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.js"></script>


