<?php
require("./concc/dbinfo.php");
require("./concc/dbhelper.php");
include_once("../../../param.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("../../../login.php");
}

$edit=false;


function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}


if(isset($_GET['id'])) {

    $isEdit      = true;
    $pageStatus  = 'Edit';
    $postURL     = 'edit_promotion_post.php';
    $categoryID  = trim($_GET['id']);
    $rangesButton = ' <form id="$categoryID" action="promotion_ranges.php?id='.$categoryID.'" method="post">
                          <input type="hidden" name="categoryID" value="'.$categoryID.'">
                          <input style="font-weight:400;font-size:15px;margin-top:30px;float:right;margin-right:10px;width:180px; display: inline;" type="submit" class="btn btn-primary" value="Edit Ranges" name="rangesButton" id="rangesButton" >
                       </form>';

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT position, details, banner_text FROM B2B_Categories_Promotions WHERE category_id=" . $categoryID);
    $stm->execute();
    $stm->bind_result($position, $details, $banner);
    while ($stm->fetch()) {}
    $stm->close();


} else {

    $isEdit      = false;
    $pageStatus  = 'New';
    $postURL     = 'add_promotion_post.php';
}

$details = str_replace("'","’",$details);
$banner = str_replace("'","’",$banner);
?>
<div id="main" role="main">

    <!-- Start CUSTOM CODE-->
    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class='txt-color-white'>Home / B2B <?php echo $pageStatus?> Promotion</li>";
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <article id="content">


        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-10">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-info-circle"></i>
                    B2B <?php echo $pageStatus?> Promotion
                </h3>
            </div>
        </div>

        <!-- NEW WIDGET START -->
        <section id="widget-grid" class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="widget-body">


                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2><?php echo $pageStatus?> Promotion</h2>
                    </header>

                    <!-- row -->
                    <div class="row">
                    <article class="">

                        <form method="post" class="smart-form" enctype="multipart/form-data">
                            <section class="col-sm-12">
                                <section>
                                    <label class="label-bold align-left">Promotion Position:
                                        <input type="text" class="form-control" style=" width: 160%" id="position" value="<?php echo $position?>" />
                                    </label>
                                </section>
                                <section>
                                    <label class="label-bold align-left">Select Category:
                                        <select name="catID" id="catID" style=" width: 100%" class="form-control">
                                            <?php

                                            $db->set_charset("utf8");
                                            $stm = $db->prepare("SELECT category_id, CONCAT(category_code, ' - ', name) codeName FROM Categories WHERE Categories.category_id  NOT IN(SELECT category_id FROM B2B_Categories_Promotions) ");
                                            $stm->execute();
                                            $stm->bind_result($catID, $codeName);
                                            while ($stm->fetch()) {
                                                echo '<option value="'.$catID.'" > '. $codeName .'</option>';
                                            }
                                            $stm->close();

                                            if($isEdit == True) {
                                                $db->set_charset("utf8");
                                                $stm2 = $db->prepare("SELECT category_id, CONCAT(category_code, ' - ', name) codeName FROM Categories WHERE category_id = " . $categoryID);
                                                $stm2->execute();
                                                $stm2->bind_result($selectedCatID, $selectedCodeName);
                                                while ($stm2->fetch()) {
                                                }
                                                $stm2->close();

                                                echo '<option value="'.$selectedCatID.'" selected> '. $selectedCodeName .'</option>';
                                            }

                                            ?>
                                        </select>
                                    </label>
                                </section>
                                <section>
                                    <label class="label-bold align-left">Promotion Banner: </label>
                                    <textarea class="form-control" id="summernote_banner" name="bannerdata" ></textarea>
                                </section>
                                <section>
                                    <label class="label-bold align-left">Promotion Details: </label>
                                    <textarea class="form-control" id="summernote_details" name="detaildata" ></textarea>
                                </section>

                        </form>
                        <footer>
                        <input type="button" id="PostSubmit" class="btn btn-success"  style="font-weight:400;font-size:15px;margin-top:30px;float:right;margin-right:10px;width:180px;" value="Save Promotion" onclick="savePost()">
                            <button id="removePromotion" type="button" class="btn btn-danger" onclick="deletePromotion()" style="font-weight:400;font-size:15px;margin-top:30px;float:left;margin-left:1px;width:180px;" >Remove Promotion</button>
                        <?php echo $rangesButton?>
                        </footer>
                    </article>
                </div>
            </div>
            <!-- end row -->
            </div>
        </section>

</div>





<script type="text/javascript">




    function deletePromotion(){
        var promotionID  = '<?php echo $categoryID;?>';

        if(promotionID .length > 0) {

            $.ajax({
                type: 'POST',
                url: './concc/remove_promotion.php',
                dataType: 'html',
                data: {
                    'promotionID': promotionID


                },
                success: function (result) {

                    $.smallBox({
                        title: 'Promotion Deleted!',
                        content: "Promotion successfully Deleted",
                        color: "#B22222",
                        timeout: 3000,
                        icon: "fa fa-gift swing animated"
                    });
                   setTimeout(function(){window.location.assign('promotions.php');}, 1000);
                }
            });
        }

    }
    function savePost()
    {
        var detailStr  = $('#summernote_details').summernote('code');
        var bannerStr  = $('#summernote_banner').summernote('code');
        var position   = $('#position').val();
        var catID      = $('#catID').val();
        var categoryID = '<?php echo $categoryID?>';

        $.ajax({
            type: "POST",
            url: './concc/<?php echo $postURL?>',
            data: {
                'categoryID':categoryID,
                'catID':catID,
                'position':position,
                'detailStr':detailStr,
                'bannerStr':bannerStr
            },

            success: function (result) {

                $.smallBox({
                    title : "Success!",
                    content : "Promotion successfully saved",
                    color : "#739E73",
                    timeout: 3000,
                    icon : "fa fa-gift swing animated"
                });
                setTimeout(function(){window.location.assign('promotions.php');}, 1000);
            }

        });
    }

    $(document).ready(function() {

        pageSetUp();

        $('#rangesButton').click(function(){
            savePost();
        });

        $('#summernote_details').summernote({
            height: 200,                 // set editor height
            minHeight: 200,             // set minimum height of editor
            maxHeight: null,            // set maximum height of editor
            focus: true,                // set focus to editable area after initializing summernote
            table: 'table table-striped'

        });

        $('#summernote_details').summernote('code', '<?php echo $details ?>');

        $('#summernote_banner').summernote({
            height: 100,                 // set editor height
            minHeight: 100,             // set minimum height of editor
            maxHeight: null,            // set maximum height of editor
            focus: true                // set focus to editable area after initializing summernote

        });

        $('#summernote_banner').summernote('code', '<?php echo $banner ?>');

    });



</script>


<script src="js/notification/SmartNotification.min.js"></script>



<!-- include summernote css/js -->
<link rel="stylesheet" href="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.css">
<script type="text/javascript" src="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.js"></script>