<?php
require("./concc/dbinfo.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("login.php");
}



function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

function endsWith($haystack, $needle)
{
    $length = strlen($needle);
    if ($length == 0) {
        return true;
    }

    return (substr($haystack, -$length) === $needle);
}

if(isset($_POST['area_id'])){

    $isEdit      = true;
    $areaID      = trim($_POST['area_id']);
    $pageStatus  = 'Edit';
    $postURL     = 'edit_area_post.php';

    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT zip_code_id, zip_code_region, zip_codes, time_slots,next_day_only_time_slots, disable_slot_hours_before, next_day_delivery_after_time,enable_timeslots,enable_delivery_approval FROM ZZ_Zip_Codes WHERE zip_code_id='$areaID'");
    $stm-> execute();
    $stm-> bind_result($areaID,$area,$zipCodes,$timeSlots,$nextDaySlots,$disableSlotsBefore,$nextDayAfter,$enableTimeslots,$enableDeliveryApproval);
    while ($stm->fetch()) {}
    $stm-> close();

    if(strcmp($enableTimeslots,'yes')==0){
        $selectedYesTimeslots = 'selected';
    } else {
        $selectedNoTimeslots = 'selected';
    }

    if(strcmp($enableDeliveryApproval,'yes')==0){
        $selectedYesDeliveryApproval = 'selected';
    } else {
        $selectedNoDeliveryApproval = 'selected';
    }






} else {
    $isEdit      = false;
    $pageStatus  = 'New';
    $postURL     = 'add_area_post.php';
}
?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white"> <?php echo $pageStatus?> Area</li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">
        <!-- row -->
        <div class="row">
            <article class="col-xs-12 col-sm-12 col-md-12 col-lg-6">
                <!-- new widget -->
                <div class="jarviswidget" id="wid-id-0" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2><?php echo $pageStatus?> Area</h2>
                    </header>

                    <div class="widget-body">

                        <div class="row">

                            <div class="col-sm-12">

                                <form id="pageForm" method="post" class="smart-form" enctype="multipart/form-data">

                                    <fieldset style="padding-top:0px">
                                        <section>
                                            <h2 style="font-weight:bold;"></h2>
                                        </section>
                                        <div class="row">

                                            <section class="col-sm-11">
                                                <section>
                                                    <label class="label-bold align-left">Area Name: </label>
                                                    <input type="text" class="form-control"  id="areaName" value="<?php echo $area?>" />
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Minutes Before Disable Each Slot : </label>
                                                    <input type="number" class="form-control"  id="hours" min="0" value="<?php echo $disableSlotsBefore;?>"/>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Next Day Delivery After Time: </label>
                                                    <input type="time" class="form-control"  id="nextDayAfterTime"  value="<?php echo $nextDayAfter;?>"/>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Time Slots : </label>
                                                    <input type="text" class="form-control"  id="timeSlots" value="<?php echo $timeSlots?>"/>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Following Day(s) Only Time Slots : </label>
                                                    <input type="text" class="form-control"  id="nextDaySlots" value="<?php echo $nextDaySlots?>"/>
                                                </section>
                                                <section>
                                                    <label class="label-bold align-left">Area ZIP Codes: </label>
                                                    <div class="label-bold align-left" id="verbalzipCodes"><?php echo str_replace(',',', ',$zipCodes);?></div>
                                                    <input type="text" class="form-control"  id="zipCodes" style="display: none" value="<?php echo $zipCodes?>"/>
                                                    <table style="width: 100%" class="table table-bordered">
                                                        <tr>
                                                            <td style="width: 30%">
                                                                <input type="number" class="form-control" placeholder="ZIP Code" id="newZip" min="1000" max="9999" value=""/>
                                                            </td>
                                                            <td>
                                                                <button type="button" class="btn btn-primary" style="padding: 5px;" onclick="checkZipExists();">Check If Zip Code Exists</button>
                                                            </td>
                                                            <td>
                                                                <button type="button" class="btn btn-success" style="padding: 5px;" onclick="addZip();">Add Zip Code</button>
                                                            </td>
                                                            <td>
                                                                <button type="button" class="btn btn-danger" style="padding: 5px;" onclick="removeZip();">Remove Zip Code</button>
                                                            </td>
                                                        </tr>
                                                    </table>

                                                </section>

                                                <section>
                                                    <table style="width: 100%;" class="table table-bordered">
                                                        <tr>
                                                            <td style="width: 50%;">
                                                                <center>
                                                                <label class="label-bold align-left">Enable Area Time Slots: </label>
                                                                <select class="form-control text-center" id="enableTimesSlots" style="width: 150px;">
                                                                    <option value="yes" <?php echo $selectedYesTimeslots?>>Yes</option>
                                                                    <option value="no" <?php echo $selectedNoTimeslots?>>No</option>
                                                                </select>
                                                                </center>
                                                            </td>
                                                            <td>
                                                                <center>
                                                                <label class="label-bold align-left">Enable Instant Delivery: </label>
                                                                <select class="form-control text-center" id="enableDeliveryApproval"  style="width: 150px;">
                                                                    <option value="no" <?php echo $selectedNoDeliveryApproval?>>No</option>
                                                                    <option value="yes" <?php echo $selectedYesDeliveryApproval?>>Yes</option>
                                                                </select>
                                                                </center>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </section>

                                                <section>
                                                    <input type="hidden" class="form-control" id="areaID" value="<?php echo $areaID?>"/>
                                                </section>


                                            </section>

                                        </div>
                                    </fieldset>
                                </form>


                                <footer>
                                    <input type="button" id="PostSubmit" class="btn btn-primary"  style="font-weight:400;font-size:15px;margin-top:30px;float:right;margin-right:10px;width:150px;" value="Save Area" onclick="savePost()">
                                </footer>

                            </div>

                        </div>

                    </div>
                    <!-- end widget div -->
                </div>
                <!-- end widget -->

            </article>

        </div>
        <!-- end row -->
    </div>






</div>





<script type="text/javascript">

    function addZip(){
        var zips = $('#zipCodes').val();
        var zip =  $('#newZip').val();
        var verbalzipCodes = $('#verbalzipCodes').html();

        if(!checkZipExists()){
            $('#zipCodes').val(zips+','+zip);
            $('#verbalzipCodes').html(verbalzipCodes+', '+zip);
            checkZipExists();
        }
    }
    function removeZip(){
        var zips = $('#zipCodes').val();
        var zip =  $('#newZip').val();

        var cleanVerbal = zips.replaceAll(",", ", ");
        $('#verbalzipCodes').html(cleanVerbal);

        var verbalzipCodes = $('#verbalzipCodes').html();

        if(checkZipExists()){
            var result = zips.replace(zip, "");
            var resultVerbal = verbalzipCodes.replace(zip, "");
            $('#zipCodes').val(result.replace(",,", ","));
            $('#verbalzipCodes').val(resultVerbal.replace(", ,", ", "));
            checkZipExists();
        }
    }

    function checkZipExists(){
        var zips = $('#zipCodes').val();
        var zip =  $('#newZip').val();

        var cleanVerbal = zips.replaceAll(",", ", ");
        $('#verbalzipCodes').html(cleanVerbal);

        if(zips.includes(zip)){

            var result = cleanVerbal.replace(zip, "<b style='color:darkgreen;'>"+zip+"</b>");

            $('#verbalzipCodes').html(result);
            return true;
        } else {
            return false;
        }
    }

    function deletePage(){
        var pageID       = $('#pageID').val();

        if(pageID.length > 0) {

            $.ajax({
                type: 'POST',
                url: './concc/remove_page.php',
                dataType: 'html',
                data: {
                    'pageID': pageID


                },
                success: function (result) {
                    $('#pageName').val('');
                    $('#pageName').trigger('change');
                    $('#position').val('');
                    $('#position').trigger('change');
                    $.smallBox({
                        title: 'Page Deleted!',
                        content: "Post successfully entered",
                        color: "#B22222",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                    setTimeout(function(){window.history.back();}, 1000);
                }
            });
        }

    }

    function savePost() {

        var areaID       = $('#areaID').val();
        var areaName     = $('#areaName').val();
        var hours        = $('#hours').val();
        var nextDayAfterTime = $('#nextDayAfterTime').val();
        var timeSlots     = $('#timeSlots').val();
        var zipCodes   = $('#zipCodes').val();
        var nextDaySlots   = $('#nextDaySlots').val();
        var enableTimesSlots = $('#enableTimesSlots').val();
        var enableDeliveryApproval = $('#enableDeliveryApproval').val();



        if(areaName.length > 0) {

            $.ajax({
                type: 'POST',
                url: './concc/<?php echo $postURL?>',
                dataType: 'html',
                data: {
                    'areaID': areaID,
                    'areaName': areaName,
                    'hours': hours,
                    'nextDayAfterTime': nextDayAfterTime,
                    'timeSlots': timeSlots,
                    'nextDaySlots': nextDaySlots,
                    'zipCodes': zipCodes,
                    'enableTimesSlots': enableTimesSlots,
                    'enableDeliveryApproval': enableDeliveryApproval

                },
                success: function (result) {

                    $.smallBox({
                        title: 'Success!',
                        content: "Area successfully entered",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });

                    setTimeout(location.reload(), 1000);
                }
            });
        }
    }

    // End of SavePost()

    $(document).ready(function() {

        pageSetUp();

    });
</script>

<script src="js/plugin/select2/select2.min.js"></script>



?>