<?php


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('dbinfo.php');
// DB table to use
$table = 'Categories';

// Table's primary key
$primaryKey = "category_id";

$userID = trim($_GET['uid']);

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array('db' => '`c`.`creation_date`',        'dt' => 'date',         'field' => 'creation_date'),
    array('db' => '`c`.`category_code`',        'dt' => 'code',         'field' => 'category_code'),
    array('db' => '`c`.`name`',                 'dt' => 'name',         'field' => 'name'),
    array('db' => '`c`.`description`',          'dt' => 'description',  'field' => 'description'),
    array('db' => '`c`.`category_id`',          'dt' => 'form',     'formatter' => function( $d, $row ) {
        global $userID;

        require("dbinfo.php");
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT count(b2b_user_id) FROM B2B_Allow_Categories_User WHERE category_id='$d' AND b2b_user_id='$userID'");
        $stm->execute();
        $stm->bind_result($u);
        while ($stm->fetch()) {}
        $stm->close();

        if($u > 0) {
            $statusButton = '<button type="button"  id="b'.$d.'" class="btn btn-danger" onclick="denyButtonClicked('.$d.');" style="width:120px; display: inline-block;">Deny Access</button>';
        } else {
            $statusButton = '<button type="button" id="b'.$d.'"  class="btn btn-success" onclick="allowButtonClicked('.$d.');"  style="width:120px; display: inline-block;">Allow Access</button>';
        }
        return $statusButton;}, 'field' => 'category_id' )

);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db' => $database,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Categories` AS `c` ";
require('ssp2.class.php');

echo json_encode(
    SSP::simple($_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery)
);

