<?php
session_start();
require("dbinfo.php");
require("dbhelper.php");
include_once("../../../../param.php");


$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

$brandID       = trim($_POST['brandID']);

//START Rename of image & select path

$fileName         = basename($_FILES['brandFile']['name'][0]);

//CHECK if image is already formatted
if( strpos( $fileName, $brandID ) !== true) {

    $str              = [' ', '.'];
    $rpc              = ['', $brandID.'.'];
    $fileName         = str_replace($str, $rpc, basename($_FILES['brandFile']['name'][0]));

}
$file_path        = ROOT . "b2b/assets/brandslider/" . $fileName;

//END Rename of image & select path

move_uploaded_file($_FILES['brandFile']['tmp_name'][0], $file_path);
$brandImageURL = $fileName;

$brandCode     = trim($_POST['brandCode']);
$brandName     = trim($_POST['brandName']);
$brandLinkURL  = trim($_POST['brandLinkURL']);
$position      = trim($_POST['position']);
$popupText     = trim($_POST['popupText']);
$sliderPosition= trim($_POST['sliderPosition']);
$slider        = trim($_POST['slider']);
$categoryID    = trim($_POST['categoryID']);


// If DropZone is empty don't Update the image URL
if($brandImageURL == "") {

    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE `B2B_Brands` SET  `brand_code`=?,`brand_name`=?,`brand_link_url`=?,`position`=?,`slider_number`=?,`slider_position`=?,`popup_text`=?,category_id=?,`timestamp`=NOW() WHERE `brand_id`=?");
    $stmt->bind_param('sssiisssi',$brandCode,$brandName,$brandLinkURL,$position,$slider,$sliderPosition,$popupText,$categoryID,$brandID);
    $stmt->execute();
    $stmt->close();

} else {

// Remove Last Uploaded Image
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT brand_image_url FROM B2B_Brands WHERE brand_id = '$brandID'");
    $stm->execute();
    $stm->bind_result($lastImg);
    while ($stm->fetch()) {}
    $stm->close();

// If the image is the same don't delete
    if($lastImg != $brandImageURL) {
        unlink(ROOT . "b2b/assets/brandslider/".$lastImg);
    }
// Upload New Image
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE `B2B_Brands` SET `brand_code`=?,`brand_name`=?,`brand_image_url`=?,`brand_link_url`=?,`position`=?,`slider_number`=?,`slider_position`=?,`popup_text`=?,category_id=?,`timestamp`=NOW() WHERE `brand_id`=?");
    $stmt->bind_param('ssssiisssi',$brandCode,$brandName,$brandImageURL,$brandLinkURL,$position,$slider,$sliderPosition,$popupText,$categoryID,$brandID);
    $stmt->execute();
    $stmt->close();
}

?>