<?php
include_once("../../../../param.php");

function getNextKey($tableName,$idName)
{
    global $username, $password, $database, $prefix;
 $z=0;
 $db1 = new mysqli(localhost,$username,$password,$database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db1->set_charset("greek");

 $likeVar = $prefix."%";
 $stm1 = $db1->prepare("SELECT $idName FROM $tableName WHERE $idName LIKE '$likeVar' ORDER BY $idName DESC LIMIT 1");
 $stm1-> execute();
 $stm1-> bind_result($nextID);
 while ($stm1->fetch()) {

  $z = substr($nextID,4,strlen($nextID));
  $z+=1;


 }
 $stm1->close();


 return $prefix.$z;




}


function getDefaultPrice($itemID,$customerID)
{
    global $username, $password, $database;
    $z=0;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("greek");
    $stm1 = $db1->prepare("SELECT price FROM ContractPrices WHERE item_id= '$itemID' AND customer_id='$customerID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($price);
    while ($stm1->fetch()) {

        $z = $price;



    }
    $stm1->close();

    if($z>0)
    {
        return $z;
    }


    $stm1 = $db1->prepare("SELECT price_group_definition_id FROM Price_Group_Customer WHERE customer_id='$customerID'");
    $stm1-> execute();
    $stm1-> bind_result($priceGroupDefinitionID);
    while ($stm1->fetch()) {

        $categories = array();
        $categories = getItemCategories($itemID);

        foreach($categories as $category)
        {
            $db = new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db->set_charset("greek");
            $stm = $db->prepare("SELECT discount_percent,price_type_id FROM Price_Group_Rules WHERE  price_group_definition_id ='$priceGroupDefinitionID' AND category_id='$category'");
            $stm-> execute();
            $stm-> bind_result($discountPercent,$priceTypeID);
            while ($stm->fetch()) {

                     $price = getPriceFromPriceType($itemID,$priceTypeID) - getPriceFromPriceType($itemID,$priceTypeID)*$discountPercent/100;
                     $z = $price;
                if($z>0)
                {
                    break;
                }



            }
            $stm->close();
            if($z>0)
            {
                break;
            }

        }
        if($z>0)
        {
            break;
        }
    }
    $stm1->close();


    if($z>0)
    {
        return $z;
    }



    $stm1 = $db1->prepare("SELECT price_group_definition_id FROM Price_Group_Customer_Group WHERE customer_group_id IN(SELECT group_id AS customer_group_id FROM Customer_CustomersGroup WHERE customer_id='$customerID')");
    $stm1-> execute();
    $stm1-> bind_result($priceGroupDefinitionID);
    while ($stm1->fetch()) {

        $categories = array();
        $categories = getItemCategories($itemID);

        foreach($categories as $category)
        {
            $db = new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db->set_charset("greek");
            $stm = $db->prepare("SELECT discount_percent,price_type_id FROM Price_Group_Rules WHERE  price_group_definition_id ='$priceGroupDefinitionID' AND category_id='$category'");
            $stm-> execute();
            $stm-> bind_result($discountPercent,$priceTypeID);
            while ($stm->fetch()) {

                $price = getPriceFromPriceType($itemID,$priceTypeID) - getPriceFromPriceType($itemID,$priceTypeID)*$discountPercent/100;
                $z = $price;
                if($z>0)
                {
                    break;
                }



            }
            $stm->close();
            if($z>0)
            {
                break;
            }

        }
        if($z>0)
        {
            break;
        }
    }
    $stm1->close();


    if($z>0)
    {
        return $z;
    }




    $stm1 = $db1->prepare("SELECT pricetype_id FROM Customer_Pricelist WHERE customer_id ='$customerID' AND NOT allow_discount='onlydisc'");
    $stm1-> execute();
    $stm1-> bind_result($priceTypeID);
    while ($stm1->fetch()) {

        $z = getPriceFromPriceType($itemID,$priceTypeID);



    }
    $stm1->close();

    if($z>0)
    {
        return $z;
    }


    $stm1 = $db1->prepare("SELECT price FROM Prices,PriceTypes WHERE item_id= '$itemID' AND default_type=\"yes\" AND Prices.pricetype_id=PriceTypes.pricetype_id  LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($price);
    while ($stm1->fetch()) {

        $z = $price;



    }
    $stm1->close();


 return $z;
}


function getDefaultImage($itemID)
{
    global $username, $password, $database;
 $z=0;
 $db1 = new mysqli(localhost,$username,$password,$database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db1->set_charset("greek");

 $stm1 = $db1->prepare("SELECT image_url FROM Item_Images WHERE item_id= '$itemID' LIMIT 1");
 $stm1-> execute();
 $stm1-> bind_result($image);
 while ($stm1->fetch()) {

  $z = "//" . HTML_PATH . "/cop/media/$image.jpg";



 }
 $stm1->close();

 if(!file_exists($z))
 {
  $z = "./assets/img/noimage.jpg";
 }

 return $z;
}

function getVatPercentage($vatID) {
    global $username, $password, $database;
 $db1 = new mysqli(localhost,$username,$password,$database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db1->set_charset("utf8");

 $stm1 = $db1->prepare("SELECT percentage FROM Vats WHERE vat_id='$vatID'");
 $stm1-> execute();
 $stm1-> bind_result($percentage);
 while ($stm1->fetch()) {
  return $percentage;
 }
 $stm1->close();
 return $percentage;


}


function getQtyFromCart($orderID,$itemID) {
    global $username, $password, $database;
 $qty=0;
 $db1 = new mysqli(localhost,$username,$password,$database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db1->set_charset("utf8");

 $stm1 = $db1->prepare("SELECT qty FROM Online_Order_Item WHERE order_id='$orderID' AND item_id='$itemID'");
 $stm1-> execute();
 $stm1-> bind_result($qty);
 while ($stm1->fetch()) {

 }
 $stm1->close();
 return $qty;


}


function itemInCart($itemID,$orderID) {
    global $username, $password, $database;
 $z=false;

 $db1 = new mysqli(localhost,$username,$password,$database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db1->set_charset("utf8");

 $stm1 = $db1->prepare("SELECT COUNT(*)FROM Online_Order_Item WHERE order_id='$orderID' AND item_id='$itemID'");
 $stm1-> execute();
 $stm1-> bind_result($counter);
 while ($stm1->fetch()) {

  if($counter>0)
  {
   $z=true;
  }
 }
 $stm1->close();
 return $z;


}


function updateItemInCart($itemID,$orderID,$qty,$customerID){
    global $username, $password, $database;
 $unitPrice = getDefaultPrice($itemID,$customerID);
 $db = new mysqli(localhost,$username,$password,$database);
 if (mysqli_connect_errno())
 {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db->set_charset("utf8");
 $stmt = $db->prepare("UPDATE Online_Order_Item SET qty=?,unit_price=? WHERE order_id=? AND item_id=?");
 $stmt->bind_param('ddii',$qty,$unitPrice,$orderID,$itemID);
 $stmt->execute();
 $stmt->close();


}


function  insertItemInCart($itemID,$orderID,$qty,$customerID)
{
    global $username, $password, $database;
 $unitPrice = getDefaultPrice($itemID,$customerID);
 $onlineOrderItemID=getNextKey("Online_Order_Item","order_item_id");
 $db = new mysqli(localhost, $username, $password, $database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db->set_charset("utf8");


 $stmt = $db->prepare("INSERT INTO Online_Order_Item (order_item_id,order_id,item_id,qty,unit_price,timestamp) VALUES(?,?,?,?,?,NOW())");
 $stmt->bind_param('iiidd', $onlineOrderItemID, $orderID, $itemID, $qty, $unitPrice);
 $stmt->execute();
 $stmt->close();
}


function  removeItemFromCart($itemID,$orderID)
{
    global $username, $password, $database;
 $db = new mysqli(localhost, $username, $password, $database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db->set_charset("utf8");


 $stmt = $db->prepare("DELETE FROM Online_Order_Item WHERE item_id=? AND order_id=?");
 $stmt->bind_param('ii',$itemID,$orderID);
 $stmt->execute();
 $stmt->close();
}


function  getAvailableOrderID($customerID,$userID)
{
    global $username, $password, $database;
 $z=false;

 $db1 = new mysqli(localhost,$username,$password,$database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db1->set_charset("utf8");

 $stm1 = $db1->prepare("SELECT order_id FROM Online_Orders WHERE customer_id='$customerID' AND salesperson_id='$userID' AND status='draft'");
 $stm1-> execute();
 $stm1-> bind_result($orderID);
 while ($stm1->fetch()) {

 }
 $stm1->close();
 if(strcmp($orderID,"0")!=0 &&strcmp($orderID,"")!=0 &&strcmp($orderID," ")!=0)
 {
   return $orderID;
 }
 else{

  $orderID=getNextKey("Online_Orders","order_id");
  $status="draft";
  $db = new mysqli(localhost, $username, $password, $database);
  if (mysqli_connect_errno()) {
   printf("Connect failed: %s\n", mysqli_connect_error());
   exit();
  }
  $db->set_charset("utf8");


  $stmt = $db->prepare("INSERT INTO Online_Orders (order_id,customer_id,salesperson_id,status,timestamp) VALUES(?,?,?,?,NOW())");
  $stmt->bind_param('iiis', $orderID, $customerID, $userID, $status);
  $stmt->execute();
  $stmt->close();

  return $orderID;
 }

}

function getPrefix($activationCode)
{
    global $username, $password, $database;
 $displayPrefix="";

 $db1 = new mysqli(localhost,$username,$password,$database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db1->set_charset("utf8");

 $stm1 = $db1->prepare("SELECT display_prefix FROM Devices WHERE activation_code='$activationCode'");
 $stm1-> execute();
 $stm1-> bind_result($displayPrefix);
 while ($stm1->fetch()) {

 }
 $stm1->close();
 return "O".$displayPrefix;
}

function getNextOrderCode($activationCode)
{
    global $username, $password, $database;
 $beginOrderNumber="";

 $db1 = new mysqli(localhost,$username,$password,$database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db1->set_charset("utf8");

 $stm1 = $db1->prepare("SELECT begin_order_number FROM Devices WHERE activation_code='$activationCode'");
 $stm1-> execute();
 $stm1-> bind_result($beginOrderNumber);
 while ($stm1->fetch()) {

 }
 $stm1->close();
 return $beginOrderNumber;
}


function setNextOrderCode($activationCode)
{
    global $username, $password, $database;

 $db = new mysqli(localhost,$username,$password,$database);
 if (mysqli_connect_errno())
 {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db->set_charset("utf8");
 $stmt = $db->prepare("UPDATE Devices SET begin_order_number=begin_order_number+1 WHERE activation_code='$activationCode'");
 $stmt->execute();
 $stmt->close();



}


function getOrderPDFForPrinting($orderID)
{
    global $username, $password, $database;
 $db = new mysqli(localhost, $username, $password, $database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db->set_charset("utf8");

 $stm = $db->prepare("SELECT order_code,order_date,subtotal,grand_total,vat_amount,customer_id,company_id,order_address_id FROM Orders WHERE order_id='$orderID'");
 $stm->execute();
 $stm->bind_result($orderCode, $orderDate, $subtotal, $grandTotal, $vatAmount,$customerID,$companyID,$orderAddressID);

 while ($stm->fetch()) {


 }
 $stm->close();

    $orderDate = date_format( date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');

    $subtotal = number_format($subtotal,2);
    $grandTotal = number_format($grandTotal,2);
    $vatAmount = number_format($vatAmount,2);


 $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
 $stm->execute();
 $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);

 while ($stm->fetch()) {


 }
 $stm->close();


 $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
 $stm->execute();
 $stm->bind_result($customerCode, $customerName);

 while ($stm->fetch()) {


 }
 $stm->close();


 $stm = $db->prepare("SELECT address_line_1,address_line_2 FROM CustomerAddress WHERE customer_address_id='$orderAddressID'");
 $stm->execute();
 $stm->bind_result($addressLine1, $addressLine2);

 while ($stm->fetch()) {


 }
 $stm->close();
 $displayDate =$orderDate;



 $result= "
<div class='row'>
<div  class='col-sm-8 col-sm-offset-2'>

<style>




        *
        {
            margin:0;
            padding:0;
            font-family:Arial;
            font-size:10pt;
            color:#000;
        }
        body
        {
            width:100%;
            font-family:Arial;
            font-size:10pt;
            margin:0;
            padding:0;
        }

        p
        {
            margin:0;
            padding:0;
        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {
            height:50mm;
        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_bodyr
        {
            height: 149mm;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;

            border-spacing:0;
            border-collapse: collapse;


        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size:9pt;
  border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family:monospace;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


       @page {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

    </style>


<htmlpageheader name='myHTMLHeader1'>
    <p style='text-align:center; font-weight:bold; font-size:22px;padding-top:10px;'>Online Order</p>
    <br/>
    <table class='heading' style='width:100%;'>
        <tr>
            <td style='width:100mm;'>
                <h1 class='heading' style='padding-top:2px;padding-bottom:2px;'>$line1</h1>
                <h2 class='heading'>
                    $line2<br/>
                    $line3<br/>
                    $line4<br/>
                    $line5<br/>
                    $line6<br/>
                    $line7
                </h2>
            </td>
            <td rowspan='2' valign='top' align='right' style='padding:3mm;'>
                <table>
                    <tr><td style='font-weight:bold'>Order No: </td><td>$orderCode</td></tr>
                    <tr><td style='font-weight:bold'>Date: </td><td>$displayDate</td></tr>
                    <tr><td style='font-weight:bold'>Type : </td><td>Online Order</td></tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class='customer'>
                <b>Customer</b> :<br />
                $customerCode -  $customerName<br />
               $addressLine1
                <br />
               $addressLine2<br />
            </td>
        </tr>
    </table>
<div id='invoice_body'>
     <table id='tableHeader' style='margin-top:10px;'>
            <tr style='background:#eee;'>
                <td style='width:8%' ><b>No.</b></td>
                <td style='width:17%'><b>Code</b></td>
                 <td style='width:30%'><b>Description</b></td>
                <td style='width:15%'><b>Quantity</b></td>
                <td style='width:15%' ><b>Unit Price</b></td>
                <td style='width:15%'><b>Total</b></td>
            </tr>
            </table>
</div>
</htmlpageheader>

    <div id='content' >

        <div id='invoice_body' >

            <table style='overflow:hidden;'>

            ";

 $counter = 0;
 $stm = $db->prepare("SELECT Order_Item.item_id,qty,unit_price,Items.vat_id,item_code,name FROM Order_Item,Items WHERE Order_Item.item_id=Items.item_id AND Order_Item.order_id='$orderID'");
 $stm->execute();
 $stm->bind_result($itemID, $qty, $unitPrice, $vatID, $itemCode, $name);

    $unitPrice = number_format($unitPrice,2);

 while ($stm->fetch()) {
  $counter++;
  $lineTotal = $unitPrice * $qty;

     $lineTotal = number_format($lineTotal,2);

  $result.= "<tr>
                <td style='width:8%'> $counter</td >
                <td style='width:17%;' > $itemCode  </td >
                <td style='width:30%'> $name </td >
                <td style='width:15%;text-align:right;padding-right:5px;'  > $qty</td >
                <td style='width:15%;text-align:right;padding-right:5px;' > $unitPrice</td >
                <td style='width:15%;text-align:right;padding-right:5px;'  > $lineTotal</td >
            </tr >";

 }
 $stm->close();


 $result.=
     "

        </table>
        </div>


        <div id='invoice_total' style='margin-top:20px;'>
            <table>
                <tr>
                    <td style='text-align:left; padding-left:10px;'></td>
                    <td style='width:15%;text-align:right;font-weight:bold'> Subtotal</td>
                    <td style='width:15%;text-align:right;' >$subtotal</td>
                </tr>
                <tr>
                    <td style='text-align:left; padding-left:10px;'></td>
                    <td style='width:15%;text-align:right;font-weight:bold'> Vat</td>
                    <td style='width:15%;text-align:right;' >$vatAmount</td>
                </tr>
                <tr>
                    <td style='text-align:left; padding-left:10px;'></td>
                    <td style='width:15%;text-align:right;font-weight:bold'> Grand Total</td>
                    <td style='width:15%;text-align:right;' >$grandTotal</td>
                </tr>
            </table>
        </div>


    </div>



    </div>

</div>
<htmlpagefooter name='myFooter1'>
            <table width='100%' style='vertical-align: bottom; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 8pt;
                color: #000000;  '><tr>
                <td width='33%'><span style=''>{DATE d-m-Y}</span></td>
                <td width='33%' align='center' style=''>{PAGENO} of {nbpg}</td>
                <td width='33%' style='text-align: right; '>$orderCode</td>
                </tr></table>
            </htmlpagefooter>

<sethtmlpagefooter name='myHTMLHeader1' value='on'' />
<sethtmlpagefooter name='myFooter1' value='on'' />
";


 return $result;
}


function getItemCategories($itemID)
{
    global $username, $password, $database;
    $categories=array();

    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT category_id FROM Category_Item WHERE item_id='$itemID'");
    $stm->execute();
    $stm->bind_result($categoryID);

    while ($stm->fetch()) {
        array_push($categories,$categoryID);
    }
    $stm->close();

    return $categories;
}

function getPriceFromPriceType($itemID,$priceTypeID)
{
    global $username, $password, $database;
    $z=0;

    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT price FROM Prices WHERE item_id='$itemID' AND pricetype_id='$priceTypeID'");
    $stm->execute();
    $stm->bind_result($price);

    while ($stm->fetch()) {
        $z=$price;
    }
    $stm->close();

    return $z;
}

function round_up($number, $precision = 2)
{
    $fig = (int) str_pad('1', $precision, '0');
    return (ceil($number * $fig) / $fig);
}

function getOrderPDF($orderID)
{
    global $username, $password, $database;
    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT order_code,order_date,subtotal,grand_total,vat_amount,customer_id,company_id,order_address_id FROM Orders WHERE order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($orderCode, $orderDate, $subtotal, $grandTotal, $vatAmount, $customerID, $companyID, $orderAddressID);

    while ($stm->fetch()) {


    }
    $stm->close();

    $orderDate = date_format( date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');

    $subtotal = number_format($subtotal,2);
    $grandTotal = number_format($grandTotal,2);
    $vatAmount = number_format($vatAmount,2);


    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT address_line_1,address_line_2 FROM CustomerAddress WHERE customer_address_id='$orderAddressID'");
    $stm->execute();
    $stm->bind_result($addressLine1, $addressLine2);

    while ($stm->fetch()) {


    }
    $stm->close();
    $displayDate = $orderDate;


    $counter = 0;
    $stm = $db->prepare("SELECT COUNT(*) FROM Order_Item WHERE order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($counter);

    $maxLoop=0;
    while ($stm->fetch()) {

        $maxLoop = intval($counter / 12);
        if ($counter % 12 > 0) {
            $maxLoop++;

        }

    }

    $stm->close();
    $result= "
        <div class='row'>
<div  class='col-sm-8 col-sm-offset-2' style='border: #888 1px solid'>

<style>




        *
        {
            margin:0;
            padding:0;
            font-family:Arial;
            font-size:10pt;
            color:#000;
        }
        body
        {
            width:100%;
            font-family:Arial;
            font-size:10pt;
            margin:0;
            padding:0;
        }

        p
        {
            margin:0;
            padding:0;
        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {
            height:50mm;
        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_bodyr
        {
            height: 149mm;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;

            border-spacing:0;
            border-collapse: collapse;


        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size:9pt;
  border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family:monospace;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


       @page {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

    </style>";

    $counter = 0;
    for ($i = 0; $i < $maxLoop; $i++) {

        $result.="

    <p style='text-align:center; font-weight:bold; font-size:22px;padding-top:10px;'>Online Order</p>
    <br/>
    <table class='heading' style='width:100%;'>
        <tr>
            <td style='width:100mm;'>
                <h1 class='heading' style='padding-top:2px;padding-bottom:2px;'>$line1</h1>
                <h2 class='heading'>
                    $line2<br/>
                    $line3<br/>
                    $line4<br/>
                    $line5<br/>
                    $line6<br/>
                    $line7
                </h2>
            </td>
            <td rowspan='2' valign='top' align='right' style='padding:3mm;'>
                <table>
                    <tr><td style='font-weight:bold'>Order No: </td><td> $orderCode</td></tr>
                    <tr><td style='font-weight:bold'>Date: </td><td> $displayDate</td></tr>
                    <tr><td style='font-weight:bold'>Type : </td><td>Online Order</td></tr>
                </table>
            </td>
        </tr>
        <tr>
            <td>
                <b>Customer</b> :<br />
                $customerCode -  $customerName<br />
               $addressLine1
                <br />
               $addressLine2<br />
            </td>
        </tr>
    </table>


    <div id='content'>

        <div id='invoice_body' style='margin-top:10px;'>
            <table>
            <tr style='background:#eee;'>
                <td style='width:8%;'><b>No.</b></td>
                <td><b>Code</b></td>
                 <td><b>Description</b></td>
                <td style='width:15%;'><b>Quantity</b></td>
                <td style='width:15%;'><b>Unit Price</b></td>
                <td style='width:15%;'><b>Total</b></td>
            </tr>
            </table>

            <table>

            ";


        $pageStart = ($i) * 12;

        $stm = $db->prepare("SELECT Order_Item.item_id,qty,unit_price,Items.vat_id,item_code,name FROM Order_Item,Items WHERE Order_Item.item_id=Items.item_id AND Order_Item.order_id='$orderID' ORDER BY Order_Item.order_item_id  LIMIT $pageStart,12");
        $stm->execute();
        $stm->bind_result($itemID, $qty, $unitPrice, $vatID, $itemCode, $name);

        $unitPrice = number_format($unitPrice,2);

        while ($stm->fetch()) {
            $counter++;
            $lineTotal = $unitPrice * $qty;

            $lineTotal = number_format($lineTotal,2);

            $result .= "<tr>
                <td style = 'width:8%;' > $counter</td >
                <td style = 'text-align:left; padding-left:10px;' > $itemCode  </td >
                <td style = 'text-align:left; padding-left:10px;' > $name </td >
                <td class='mono' style = 'width:15%;' > $qty</td >
                <td style = 'width:15%;' class='mono' > $unitPrice</td >
                <td style = 'width:15%;' class='mono' > $lineTotal</td >
            </tr >";

        }
        $stm->close();


        if($i+1==$maxLoop) {


            $result .=
                "


        </table>
        </div>
        <div id='invoice_total' style='margin-top:10px;'>
            <table>
                <tr>
                    <td style='text-align:left; padding-left:10px;'></td>
                    <td style='width:15%;'> Subtotal</td>
                    <td style='width:15%;' class='mono'>$subtotal</td>
                </tr>
                <tr>
                    <td style='text-align:left; padding-left:10px;'></td>
                    <td style='width:15%;'> Vat</td>
                    <td style='width:15%;' class='mono'>$vatAmount</td>
                </tr>
                <tr>
                    <td style='text-align:left; padding-left:10px;'></td>
                    <td style='width:15%;'> Grand Total</td>
                    <td style='width:15%;' class='mono'>$grandTotal</td>
                </tr>
            </table>
        </div>
        <br />
        <hr />
        <br />

    </div>

    <br />

    </div>

</div>

<pagebreak/>

";
        }
        else{
            $result .=
                "


        </table>
          </div>
        <pagebreak/>
        ";
        }



    }
    return $result;
}

 ?>