<?php
session_start();
require("dbinfo.php");
require("dbhelper.php");
include_once("../../../../param.php");

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
if (isset($_FILES['sliderFile']) && !empty($_FILES['sliderFile'])) {

    $featuredID       = getNextKey("B2B_Featured_Slider", "featured_id");

//START Rename of image & select path
    $str              = [' ', '.'];
    $rpc              = ['', $featuredID.'.'];
    $fileName         = str_replace($str, $rpc, basename($_FILES['sliderFile']['name'][0]));
    $file_path        = ROOT . "b2b/assets/featuredslider/" . $fileName;
    move_uploaded_file($_FILES['sliderFile']['tmp_name'][0], $file_path);
//END Rename of image & select path

    $featuredImageURL = $fileName;
    $featuredCode     = trim($_POST['featuredCode']);
    $featuredTitle    = trim($_POST['featuredTitle']);
    $featuredText     = trim($_POST['featuredText']);
    $featuredLinkURL  = trim($_POST['featuredLinkURL']);
    $position         = trim($_POST['position']);
    $active           = trim($_POST['active']);
    $sliderNumber     = trim($_POST['sliderNumber']);
    $height           = trim($_POST['height']);
    $width            = trim($_POST['width']);

    if(is_numeric($height)){$height .= 'px';}
    if(is_numeric($width)){$width .= 'px';}

    $db->set_charset("utf8");
    $stmt = $db->prepare("INSERT INTO B2B_Featured_Slider (featured_id,featured_code,featured_title,featured_text,featured_image_url,featured_link_url,featured_width,featured_height,slider_number,position,active,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW())");
    $stmt->bind_param('isssssssiis', $featuredID, $featuredCode, $featuredTitle, $featuredText, $featuredImageURL, $featuredLinkURL,$width,$height,$sliderNumber, $position, $active);
    $stmt->execute();
    $stmt->close();



    $fileIconName = basename($_FILES['sliderIconFile']['name'][0]);
    if($fileIconName != "") {

        if( strpos( $fileIconName, $featuredID ) !== true) {

            $str              = [' ', '.'];
            $rpc              = ['', $featuredID.'.'];
            $fileIconName         = str_replace($str, $rpc, basename($_FILES['sliderIconFile']['name'][0]));

        }

        // Remove Last Uploaded Image
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT featured_icon_url FROM B2B_Featured_Slider WHERE featured_id='$featuredID'");
        $stm->execute();
        $stm->bind_result($lastIcon);
        while ($stm->fetch()) {}
        $stm->close();

        // If the image is the same don't delete
        if($lastIcon != $fileIconName) {
            unlink("../../../b2b/assets/featuredslider/" . $lastIcon);
        }

        $fileIconPath = ROOT . "b2b/assets/featuredslider/" . $fileIconName;
        move_uploaded_file($_FILES['sliderIconFile']['tmp_name'][0], $fileIconPath);
        $featuredIconURL = $fileIconName;
        $db->set_charset("utf8");
        $stmt = $db->prepare("UPDATE `B2B_Featured_Slider` SET `featured_icon_url`=? WHERE `featured_id`=?");
        $stmt->bind_param('si',$featuredIconURL,$featuredID);
        $stmt->execute();
        $stmt->close();
    }


}
?>