<?php
include_once("../../../param.php");
require("./concc/dbinfo.php");
require("./concc/dbhelper.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("../../../login.php");
}
function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

?>
<div id="main" role="main">

    <!-- Start CUSTOM CODE-->
    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class='txt-color-white'>Home / Meta Description </li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <article id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-info-circle"></i>
                    Meta Descriptions
                </h3>
            </div>

        </div>

        <!-- NEW WIDGET START -->
        <section id="widget-grid" class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <!-- row -->
            <div class="row">

                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-154" data-widget-editbutton="false" data-widget-deletebutton="false">
                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2>Item Meta Description</h2>
                    </header>


                    <div>
                        <div class="widget-body no-padding">
                            <center>
                                <table class="table" style="width: 90%;">
                                    <tr>
                                        <td style="width:40%"><label><b>Item:</b></label></td>
                                        <td style="width:40%"><label><b>Meta Description:</b></label></td>
                                        <td style="width:20%"><label><b>Actions</b></label></td>
                                    </tr>
                                    <tr>
                                        <td><input type="text"  id="itemSelection" class=" text-center" ></td>
                                        <td><textarea type="text" id="metaDescription" class="form-control text-center" disabled> </textarea></td>
                                        <td><button type="button" id="saveButton" class="btn btn-block btn-success" onclick="saveMetaDescription();">Save</button> </td>
                                    </tr>
                                    <tr>

                                    </tr>
                                </table>
                            </center>

                        </div>
                    </div>





                </div>
            </div>
            <!-- end row -->

        </section>

        <!-- NEW WIDGET START -->


</div>

<style>

.select2-container {
    width:100% !important;
    box-sizing: border-box;
    margin: 0;
    padding: 0;

}
.select2-container .select2-choice>.select2-chosen{
    color: #000000;
    font-weight: 400;
    font-family:"verdana", "sans-serif";
}


.select2-container .select2-choice,
.select2-search input,
.select2-drop-active ,
.select2-container-multi .select2-choices,
.select2-container-multi .select2-search input,
.select2-container-multi .select2-choices li,
.select2-container-multi .select2-drop-active {
border-radius: 4px !important;

}

</style>

<script type="text/javascript">


    function saveMetaDescription(){
        $('#saveButton').prop("disabled", true);
        var description = $("#metaDescription").val().trim();
        var itemID = $("#itemSelection").val();

        if(description == null || description === ""){
            $('#saveButton').prop("disabled", false);
            return;
        }

        $.ajax({
            type: "POST",
            url: "./concc/addItemMetaDescription.php",
            data: {
                description: description,
                itemID: itemID
            },
            success: function(){
                $.smallBox({
                    title: "Success!",
                    content: "Description successfully entered.",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
            }
        });

        $('#saveButton').prop("disabled", false);
    }

    function initItemSelection(){
        $("#itemSelection").select2({

            minimumInputLength: 2,
            minimumResultsForSearch: 1,
            ajax: {
                url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/productSearch.php",
                dataType: "json",
                type: "GET",
                data: function (term, page) {
                    return {
                        query: term
                        //page: page,
                        // pageLimit: 25
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

    }

    $(document).ready(function() {

        pageSetUp();
        initItemSelection();
        $("#itemSelection").on('change', function() {
            if ($(this).val()) {
                $('#metaDescription').prop('disabled', false);
            } else {
                $('#metaDescription').prop('disabled', true);
            }
        });




    });



</script>





<link rel="stylesheet" href="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.css">
<script type="text/javascript" src="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.js"></script>