<?php
include_once("../../../../param.php");

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$whereSP = '';
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    $whereSP .= " WHERE salesperson_id IN (".$_SESSION['Allow_Salespersons'].")";
}

$stm = $db->prepare("SELECT CONCAT(salesperson_code, ' - ',first_name, ' ', last_name), salesperson_id FROM SalesPersons $whereSP");
$stm-> execute();
$stm-> bind_result($salespersonName, $salespersonID);
while ($stm->fetch()) {
    $salespersonSelection .= "<option value='$salespersonID'>$salespersonName</option>";
}

$stm = $db->prepare("SELECT reason FROM Visit_Reasons WHERE 1=1");
$stm-> execute();
$stm-> bind_result($visitReason);
while ($stm->fetch()) {
    $visitReasonOptions .= "<option value='$visitReason%'>$visitReason</option>";
}

$stm-> close();

function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}
?>

<div id="main" role="main" class="background-color-whitish">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Reports / Single  Report</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                <span>  <a onclick="backToReports()" class="btn btn-primary"><i class="fa fa-arrow-left"></i>&nbsp; Back to Reports</a> </span>
                <h3 style="display:inline;margin-left:10px;" class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-signal"></i>
                    Reports
                </h3>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="" style="margin-top:10px;">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-2" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Report Criteria</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

                                <label style="display: block"><b>Select Date Range:</b></label>
                                <input type="date" name="dateFrom" id="dateFrom" class="form-control" style="display: inline-block;width: 25%" value="<?php echo date('Y-m-d')?>" >
                                <input type="date" name="dateTo" id="dateTo" class="form-control" style="display: inline-block;width: 25%" value="<?php echo date('Y-m-d')?>">

                                <label style="display: block; margin-top: 10px"><b>Date Filter Type:</b></label>
                                <select  name="dateFilterType" id="dateFilterType" class="form-control" style="width: 50%">
                                    <option value="invoiceDate">Order Date</option>
                                    <option value="dueDate">Delivery Date</option>
                                </select>

                                <label style="display: block; margin-top: 10px"><b>Filter Customers:</b></label>
                                <input type='hidden' placeholder="All Customers" id='customerSearch' name='customerSearch[]' class="form-control" style="width: 50%"/>

<!--                                <label style="display: block; margin-top: 10px"><b>Filter Items:</b></label>-->
<!--                                <input type='hidden' placeholder="All Items" id='itemSearch' name='itemSearch[]' class="form-control" style="width: 50%"/>-->

                                <label style="display: block; margin-top: 10px"><b>Filter Salespersons:</b></label>
                                <input type='hidden' placeholder="All Salespersons" id='salespersonSearch' name='salespersonSearch[]' class="form-control" style="width: 50%"/>

                                <label style="display: block; margin-top: 10px"><b>Select Report Type:</b></label>
                                <select  name="analyticOrSummary" id="analyticOrSummary" class="form-control" style="width: 50%">
                                    <option value="summary">VAT Analysis Table</option>
                                    <option value="analytic">VAT Per Order Table</option>
                                    <option value="all">VAT Analysis and Per Order Table</option>
                                </select>
                                <br><br>

                                <button type="button" name="generateReport" id="generateReport" class="btn btn-primary" onclick="getReport()" >Generate Report</button>
                                <button type="button" name="generateExcel"  id="generateExcel"  class="btn btn-waybill" onclick="exportXLS()" >Export to Excel</button>
                                <button type="button" name="generatePDF"    id="generatePDF"    class="btn btn-danger"  onclick="exportPDF()" >Export PDF</button>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-3" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Report</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

                            <div name="reportResult" id="reportResult"></div>
                                <form method="POST" action="#" name="xlsForm" id="xlsForm" >
                                    <input type="hidden" name="inputResult" id="inputResult" value=""/>
                                    <input type="hidden" name="orientation" id="orientation" value="landscape"/>
                                    <input type="hidden" name="inputTitle" id="inputTitle" value="OrdersVatAnalysis"/>
                                </form>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

            </div>


    </div>
    <!-- end widget content -->

    <!-- end row -->
    </section>

</div>

<script type="text/javascript">

    $(document).ready(function() {

        pageSetUp();
        initCustomerAutocomplete();
        initItemAutocomplete();
        initSalespersonAutocomplete();

    });

    function initCustomerAutocomplete(){
        $("#customerSearch").select2({
            tags: true,
            multiple: true,
            tokenSeparators: [',', ' '],
            minimumInputLength: 2,
            minimumResultsForSearch: 1,
            ajax: {
                url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/customerSearch.php",
                dataType: "json",
                type: "GET",
                data: function (term, page) {
                    return {
                        query: term
                        //page: page,
                        // pageLimit: 25
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
    }

    function initItemAutocomplete(){
        $("#itemSearch").select2({
            tags: true,
            multiple: true,
            tokenSeparators: [',', ' '],
            minimumInputLength: 2,
            minimumResultsForSearch: 1,
            ajax: {
                url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/productSearch.php",
                dataType: "json",
                type: "GET",
                data: function (term, page) {
                    return {
                        query: term
                        //page: page,
                        // pageLimit: 25
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
    }

    function initSalespersonAutocomplete(){
        $("#salespersonSearch").select2({
            tags: true,
            multiple: true,
            tokenSeparators: [',', ' '],
            minimumInputLength: 0,
            minimumResultsForSearch: 1,
            ajax: {
                url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/salespersonSearch.php",
                dataType: "json",
                type: "GET",
                data: function (term, page) {
                    return {
                        query: term
                        //page: page,
                        // pageLimit: 25
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
    }

    function getReport(){

        var dateFrom    = $('#dateFrom').val();
        var dateTo      = $('#dateTo').val();
        var dateFilterType = $('#dateFilterType').val();
        var customerSearch = $('#customerSearch').val();
        var itemSearch = $('#itemSearch').val();
        var salespersonSearch = $('#salespersonSearch').val();
        var analyticOrSummary = $('#analyticOrSummary').val();


        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateOrdersVatAnalysisReport.php',
            data: {
                'dateFrom':dateFrom,
                'dateTo':dateTo,
                'dateFilterType':dateFilterType,
                'customerSearch':customerSearch,
                'itemSearch':itemSearch,
                'analyticOrSummary':analyticOrSummary,
                'salespersonSearch':salespersonSearch

            },

            success: function (result) {
                $('#reportResult').html(result);
            }
        });

    }

    function exportXLS(){

        var dateFrom    = $('#dateFrom').val();
        var dateTo      = $('#dateTo').val();
        var dateFilterType = $('#dateFilterType').val();
        var customerSearch = $('#customerSearch').val();
        var itemSearch = $('#itemSearch').val();
        var salespersonSearch = $('#salespersonSearch').val();
        var analyticOrSummary = $('#analyticOrSummary').val();

        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateOrdersVatAnalysisReport.php',
            data: {
                'dateFrom':dateFrom,
                'dateTo':dateTo,
                'dateFilterType':dateFilterType,
                'customerSearch':customerSearch,
                'itemSearch':itemSearch,
                'analyticOrSummary':analyticOrSummary,
                'salespersonSearch':salespersonSearch

            },

            success: function (result) {
                $('#reportResult').html(result);
                $('#inputResult').val(result);
                $('#xlsForm').attr('action','//<?php echo HTML_PATH ?>/cop/backend/core/templates/xls/generateGeneralXLS.php').submit();
            }
        });


    }

    function exportPDF(){

        var dateFrom    = $('#dateFrom').val();
        var dateTo      = $('#dateTo').val();
        var dateFilterType = $('#dateFilterType').val();
        var customerSearch = $('#customerSearch').val();
        var itemSearch = $('#itemSearch').val();
        var salespersonSearch = $('#salespersonSearch').val();
        var analyticOrSummary = $('#analyticOrSummary').val();

        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateOrdersVatAnalysisReport.php',
            data: {
                'dateFrom':dateFrom,
                'dateTo':dateTo,
                'dateFilterType':dateFilterType,
                'customerSearch':customerSearch,
                'itemSearch':itemSearch,
                'analyticOrSummary':analyticOrSummary,
                'salespersonSearch':salespersonSearch

            },

            success: function (result) {
                $('#reportResult').html(result);
                $('#inputResult').val(result);
                $('#xlsForm').attr('action','//<?php echo HTML_PATH ?>/cop/backend/core/templates/pdf/generatePDFFromHTML.php').submit();
            }
        });


    }

    function backToReports() {
        try {
            $(".swLinkMenu")[0].click();
        }
        catch(err)
        {

        }

        setTimeout(function() {
            window.location = "reports_list.php";
        }, 1000);


    }

</script>


