<?php
include_once("../../../../param.php");

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Reader\Html;
include_once '../../../../libs/phpSpreadsheet/vendor/autoload.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);
$fromWH         = $_POST['fromWH'];
$toWH           = $_POST['toWH'];
$typeReport     = $_POST['typeReport'];
if (strcmp($fromWH,'')==0 || strcmp($toWH,'')==0){
    echo 0;
}else{
    $arrayObjAll = getArrayWithData($fromWH,$toWH);
    $arrayObj = $arrayObjAll[0];
    $arrayAll = $arrayObjAll[1];
    $htmlCode = getHtmlCode($arrayObj,$arrayAll,$fromWH,$toWH);
    if (strcmp($typeReport,'excel')==0){
        exportXLSfileNew($htmlCode);
    }else{
        echo $htmlCode;
    }
}

function exportXLSfile($htmlExcelCode){
    $filename = "Warehouse_Compare_file_report.xlsx";
    $tmpfile = tempnam(sys_get_temp_dir(), 'html');
    file_put_contents($tmpfile, $htmlExcelCode);

    $objPHPExcel     = new PHPExcel();
    $excelHTMLReader = PHPExcel_IOFactory::createReader('HTML');
    $excelHTMLReader->loadIntoExisting($tmpfile, $objPHPExcel);
    $objPHPExcel->getActiveSheet()->setTitle('Excel Export'); // Change sheet's title if you want

    foreach(range('B','Z') as $columnID) {
        $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)
            ->setAutoSize(true);
    }
    unlink($tmpfile);


    ob_start();

    $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    $writer->save('php://output');
    $ret = base64_encode(ob_get_contents());
    ob_end_clean();
    echo $ret;
}

function exportXLSfileNew($htmlString){
    $spreadsheet = new Spreadsheet();
    $reader = new Html();
    $spreadsheet = $reader->loadFromString($htmlString);
    $writer = new Xlsx($spreadsheet);

    ob_start();
    $writer->save('php://output');
    $ret = base64_encode(ob_get_contents());
    ob_end_clean();
//    $filename = "Warehouse_Compare_file_report.xlsx";
//    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
//    header('Content-Disposition: attachment;filename="' . time() . '_' . $filename . '"');
//    header('Cache-Control: max-age=0');

    echo $ret;

}

function getHtmlCode($arrayObj,$arrayAll,$fromWH,$toWH){
    $result = "<style>
                table {
                    width:100%;
                    border-collapse: collapse;
                }
                td{
                    border: 1px solid black;
                    padding: 4px;
                    vertical-align: middle !important;
                    padding:10px !important;
                }
            </style>";
    $wareHouseCompare               = getWarehouseInfo($fromWH);
    $wareHouseCompareWithSelected   = getWarehouseInfo($toWH);

    $result .= "<table class='table' style='width: 100%'>";
    $result .="<tr>";
        $result .="<td  style='text-align:center !important;background-color:#cbdbf3;font-weight: bold;height: 50px;text-align: center;width: 100px'><b>Item Code<b></td>";
        $result .="<td  style='text-align:center !important;background-color:#cbdbf3;font-weight: bold;height: 50px;text-align: center;width: 300px'><b>Item Name<b></td>";
        $result .="<td  style='text-align:center !important;background-color:#cbdbf3;font-weight: bold;height: 50px;text-align: center;width: 200px'><b>$wareHouseCompare<b></td>";
        $result .="<td  style='text-align:center !important;background-color:#cbdbf3;font-weight: bold;height: 50px;text-align: center;width: 200px'><b>$wareHouseCompareWithSelected<b></td>";
    $result .="</tr>";

    $itemArrayExits = array();

    $arrayFilterWareHouseFrom = getArrayByWarehouse($arrayObj,$fromWH);
    $arrayFilterWareHouseTo   = getArrayByWarehouse($arrayObj,$toWH);
    if (count($arrayFilterWareHouseFrom)>0){
        foreach ($arrayFilterWareHouseFrom as $obj){
            $itemID     = $obj->itemID;
            $fromWH_available  = $obj->available;
            $toWH_available = $arrayAll["$toWH"]["$itemID"]["available"];

            if ($fromWH_available!=$toWH_available){
                $colorFrom = '#097969';
                $colorTo = 'red';
            }else{
                $colorFrom = '#097969';
                $colorTo = '#097969';
            }
            if (strcmp($toWH_available,'')==0){
                $toWH_available = '-';
                $colorTo = '';
            }
            $itemInfo = getItemInfo($itemID);
            if (!in_array($itemID,$itemArrayExits)){
                array_push($itemArrayExits,$itemID);
                $result .= "<tr>";
                    $result .="<td style='text-align:center !important;background-color: ;font-weight: bold;height: 50px;text-align: center;'>$itemInfo->code</td>";
                    $result .="<td style='text-align:center !important;background-color: ;font-weight: bold;height: 50px;text-align: center;'>$itemInfo->name</td>";
                    $result .="<td style='text-align:center !important;color: $colorFrom;font-weight: bold;height: 50px;text-align: center;'>$fromWH_available</td>";
                    $result .="<td style='text-align:center !important;color: $colorTo;font-weight: bold;height: 50px;text-align: center;'>$toWH_available</td>";
                $result .= "</tr>";
            }
        }
    }
    if (count($arrayFilterWareHouseTo)>0){
        foreach ($arrayFilterWareHouseTo as $obj){
            if (!in_array($obj->itemID,$itemArrayExits)){
                $itemID     = $obj->itemID;
                $toWH_available  = $obj->available;
                $fromWH_available = $arrayAll["$fromWH"]["$itemID"]["available"];
                if (strcmp($fromWH_available,'')==0){
                    $fromWH_available = '-';
                    $colorFrom = '';
                }
                if ($fromWH_available!=$toWH_available){
                    $colorTo = 'red';
                }
                $itemInfo = getItemInfo($itemID);

                array_push($itemArrayExits,$itemID);
                $result .= "<tr>";
                $result .="<td style='text-align:center !important;background-color: ;font-weight: bold;height: 50px;text-align: center;'>$itemInfo->code</td>";
                $result .="<td style='text-align:center !important;background-color: ;font-weight: bold;height: 50px;text-align: center;'>$itemInfo->name</td>";
                $result .="<td style='text-align:center !important;color: $colorFrom;font-weight: bold;height: 50px;text-align: center;'>$fromWH_available</td>";
                $result .="<td style='text-align:center !important;color: $colorTo;font-weight: bold;height: 50px;text-align: center;'>$toWH_available</td>";
                $result .= "</tr>";
            }
        }
    }
    $result .="</table>";
    return $result;
}

function getArrayByWarehouse($arrayObj,$allowedWarehouse){
    $arraySelected = array_filter($arrayObj, function($record) use ($allowedWarehouse) {
        return $record->warehouseID == $allowedWarehouse;
    });
    return $arraySelected;
}

function getArrayWithData($fromWH,$toWH){
    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $arrayReturn = array();
    $arrayWithAll = array();
    $stm = $db->prepare("SELECT warehouse_id,item_id,SUM(available) FROM Stock WHERE warehouse_id IN($fromWH,$toWH) AND available>0 GROUP BY item_id,warehouse_id");
    $stm-> execute();
    $stm-> bind_result($warehouseID,$itemID,$available);
    while ($stm->fetch()) {
        $arrayWithAll["$warehouseID"]["$itemID"]["available"] = $available;
        $obj = new stdClass();
        $obj->warehouseID   = $warehouseID;
        $obj->itemID        = $itemID;
        $obj->available     = $available;
        array_push($arrayReturn,$obj);
    }
    $stm-> close();

    return [$arrayReturn,$arrayWithAll];
}

function viewArray($arr){
    echo "<pre>";
    var_dump($arr);
    echo "</pre>";
}


function getItemInfo($itemID){
    global $username,$password,$database;
    $db2 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");

    $stm2 = $db2->prepare("SELECT item_code,name FROM Items WHERE item_id='$itemID' LIMIT 1");
    $stm2-> execute();
    $stm2-> bind_result($itemCode,$itemName);
    while ($stm2->fetch()) {
        $objItemInfo = new stdClass();
        $objItemInfo->code = $itemCode;
        $objItemInfo->name = $itemName;
    }
    $stm2-> close();
    return $objItemInfo;
}

function getWarehouseInfo($whIDto){
    global $username,$password,$database;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $warehouseInfo = '';
    $stm = $db1->prepare("SELECT CONCAT(warehouse_code, ' - ',name) FROM Warehouses WHERE warehouse_id='$whIDto' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($warehouseInfo);
    while ($stm->fetch()) {
        $warehouseInfo = $warehouseInfo;
    }
    $stm-> close();

    return $warehouseInfo;
}

?>