<?php
include_once("../../../../param.php");
$customers    = $_POST['customers'];
$customergroups = $_POST['customergroups'];
$categories = $_POST['categories'];

$dateFrom    = trim($_POST['dateFrom']);
$dateFromD    = date("Y-m-d", strtotime($dateFrom));
$dateTo      = trim($_POST['dateTo']);
$dateToD      = date("Y-m-d", strtotime($dateTo));
$report = '';

header("content-type: text/html;charset=utf-8");

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

if (strcmp($customergroups, '') != 0) {
    $stm = $db->prepare("SELECT customer_id FROM Customer_CustomersGroup WHERE group_id IN ($customergroups)");
    $stm->execute();
    $stm->bind_result($customerFromGroup);
    while ($stm->fetch()) {$customers .= ",$customerFromGroup";}
    $stm->close();
}

$customers = trim($customers,',');

$customers = implode(",",array_unique(explode(',', $customers)));

if (strcmp($dateFrom, '') != 0 && strcmp($dateTo, '') != 0) {
    $dateFilter = "AND date >= '$dateFromD' AND date <= '$dateToD'";
}

if (strcmp($customers, '') != 0) {
    $customerFilter = "AND Customer_Stock_Taking.customer_id IN ($customers)";
}

if (strcmp($categories, '') != 0) {
    $categoryFilter = "AND Category_Item.category_id IN ($categories)";
}

if(isset($_SESSION['Allow_CustomerGroups']) && strcmp($_SESSION['Allow_CustomerGroups'],'')!=0) {
    $Allow_CustomerGroups = "AND CustomerGroups.group_id IN(".$_SESSION['Allow_CustomerGroups'].")";
}
if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0) {
    $Allow_Customers = "AND Customers.customer_id IN(".$_SESSION['Allow_Customers'].")";
}

if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    $Allow_Salespersons = " AND Customer_Stock_Taking.salesperson_id IN (".$_SESSION['Allow_Salespersons'].")";
}
if(isset($_SESSION['Allow_Items']) && strcmp($_SESSION['Allow_Items'],'')!=0) {
    $Allow_Items = "AND Items.item_id IN(".$_SESSION['Allow_Items'].")";
}
if(isset($_SESSION['Allow_Categories']) && strcmp($_SESSION['Allow_Categories'],'')!=0) {
    $Allow_Categories = "AND Categories.category_id IN(".$_SESSION['Allow_Categories'].")";
}

$stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies LIMIT 1");
$stm->execute();
$stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
while ($stm->fetch()) {}
$stm->close();

//----------------------------------------------------------------------------------
$report = "



<style>


        body
        {
           font-family: Helvetica Neue, Helvetica, Arial, sans-serif;

        }

        p
        {

        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        td {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        }
        
        tr:nth-child(even) {background-color: #f2f2f2;}

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
        
             margin-left: 1.4cm;
             margin-right: 1.4cm;
        
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }

    </style>


<htmlpageheader name='myHTMLHeader1'>
  <table class='heading' style='width: 100%'>
  <tr>
  <td valign='top' style='width:30%'>
      <img style='display:block;max-width: 200px;' src='//".HTML_PATH."/cop/media/pdfimage/logo.png'/>
  </td>
  <td  valign='top' style='width:40%' align='center'>
     <p style='display:block;font-weight:bold; font-size:24px; width:100%'>Customer Stock Taking Summary </p><p style='display:block;font-weight:bold; font-size:14px; width:100%'><br/>$customerName<br/> $displayDateFrom $displayDateTo</p>
  </td>
  <td valign='top' style='width:30%' align='right'>
     <h1 class='heading' style='display:block;padding-top:2px;padding-bottom:2px;text-align: right;'>$line1</h1>
                <h2 class='heading' style='text-align: right;'>
                    $line2<br/>
                    $line3<br/>
                    $line4<br/>
                    $line5<br/>
                    $line6<br/>
                    $line7
                </h2>
  </td>
   </tr>
  </table>

</htmlpageheader>



     <table repeat_header='1' id='tableHeader' style='padding: 2px;' >



            ";




$rows = '';
$categoriesArray = array();
$stm = $db->prepare("SELECT 
                                    Customers.customer_id,
                                    customer_code,
                                    customer_company_name,
                                    Categories.category_id,
                                    Categories.category_code,
                                    Categories.name,
                                    COUNT(DISTINCT(Customer_Stock_Taking_Item.item_id)) 
                                FROM 
                                    Customer_Stock_Taking, 
                                    Customer_Stock_Taking_Item,
                                    Customers, 
                                    Category_Item,
                                    Categories 
                                WHERE 
                                    Categories.category_id=Category_Item.category_id 
                                AND Customer_Stock_Taking_Item.customer_stock_taking_id=Customer_Stock_Taking.customer_stock_taking_id 
                                AND Customer_Stock_Taking_Item.item_id=Category_Item.Item_id 
                                AND Customers.customer_id=Customer_Stock_Taking.customer_id 
                                    $Allow_Customers
                                    $Allow_Categories
                                    $Allow_Salespersons
                                    $customerFilter
                                    $categoryFilter
                                    $dateFilter  
                                GROUP BY Customers.customer_id, Category_Item.category_id");
$stm->execute();
$stm->bind_result($customerID,$customerCode,$customerName,$categoryID,$categoryCode,$categoryName, $count);
$customers= array();
$categories=array();
$stocks= array();
while ($stm->fetch()) {

    $customer='';
    $customer->id = $customerID;
    $customer->code = $customerCode;
    $customer->name = $customerName;
    $customer->count = $count;
    $customers[$customerID] =$customer;

    $stocks[$customerID][$categoryID] = $count;
    $categories[$categoryID]=$categoryName;
}
$stm->close();

$report .='<tr style="background-color: lightblue;font-weight: bold;"  valign=\'middle\'><td style="">Customers</td>';
foreach ($categories as $categoryID=>$categoryName){
    $report .="<td  valign='middle'><div align='center' style=''>$categoryName</td>";
}
$report .="</tr>";

foreach ($customers as $customerID=>$customer){
    $report .="<tr><td style='border-bottom: 1px solid lightskyblue;border-right: 1px dotted skyblue;border-left: 1px solid skyblue;' valign='middle' >".$customer->name."</td>";
    foreach ($categories as $categoryID=>$categoryName){
        $report .="<td style='border-bottom: 1px solid lightskyblue;border-right: 1px dotted skyblue' valign='middle'><div align='center' >";
        if (!empty($stocks[$customer->id][$categoryID])){
            $report .= $stocks[$customer->id][$categoryID];
        } else {
            $report .= "-";
        }
        $report .="</td>";
    }
    $report .="<tr>";
}

$report .="</tr></table>";



if(strcmp($report,'') == 0){$report = '<center><b>No Data Found</b></center>';}
echo $report;
?>