<?php
include_once("../../../../param.php");



$where   = '';

$salesperson  = trim($_POST['salesperson']);
$dateFrom     = trim($_POST['dateFrom']);
$dateTo       = trim($_POST['dateTo']);
$coordinates  = trim($_POST['coordinates']);
$hideLines    = trim($_POST['hideLines']);
$visitReasonsFilter = $_POST['visitReasonsFilter'];
$incVisits          = trim($_POST['incVisits']);
$incTenders         = trim($_POST['incTenders']);
$incOrders          = trim($_POST['incOrders']);
$incWaybills        = trim($_POST['incWaybills']);
$incInvoices        = trim($_POST['incInvoices']);
$incReturns         = trim($_POST['incReturns']);
$incReceipts        = trim($_POST['incReceipts']);
$incWHTransactions  = trim($_POST['incWHTransfers']);


if(strcmp("$visitReasonsFilter","")!=0){
    $visitReasonsFilter = implode("' OR Visits.notes LIKE '",$visitReasonsFilter);
}

if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0) {
    $Allow_Customers = "AND Customers.customer_id IN(".$_SESSION['Allow_Customers'].")";
}

if(strcmp($coordinates,'yes')==0){
    $showLatLng = true;
} else {
    $showLatLng = false;
}

if(strcmp($hideLines,'yes')==0){
    $showActionLines = false;
} else {
    $showActionLines = true;
}

if(strcmp($salesperson,'0')!=0){
    $where .= " AND salesperson_id = '$salesperson'";
}
if(strcmp($dateFrom,'')==0){
    $dateFrom = date('Y-m-d');
}

if(strcmp($dateTo,'')==0){
    $dateTo = date('Y-m-d');
}
global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

$salespersons= array();
$db->set_charset("utf8");
$stm = $db->prepare("SELECT salesperson_id,salesperson_code, first_name, last_name, username FROM SalesPersons WHERE NOT salesperson_code='' $where");
$stm->execute();
$stm->bind_result( $salespersonID,$salespersonCode, $firstName, $lastName,$userName);
while ($stm->fetch()) {
    $salesperson=new stdClass();
    $salesperson->id = $salespersonID;
    $salesperson->code = $salespersonCode;
    $salesperson->name = "$firstName $lastName";
    $salesperson->username = $userName;
    array_push($salespersons, $salesperson);
}
$stm->close();

foreach ($salespersons as $sp) {

    $salespersonName = $sp->name;
    $salespersonCode = $sp->code;
    $salespersonID   = $sp->id;
    $userName = $sp->username;
    $where = " AND salesperson_id = '$sp->id'";



    $actions = array();
    $counter = 0;
    $receiptTotal = 0;
    $returnTotal  = 0;
    $orderTotal   = 0;
    $invoiceTotal = 0;
    $customers = 0;
    $CustomersWithOrder = 0;

    if(strcmp($incVisits,'yes')==0) {
        if(strcmp($visitReasonsFilter,'')!=0){$visitReasonsQuery = " AND (Visits.notes LIKE '$visitReasonsFilter')";}
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT visit_id,visit_code, Visits.customer_id, CONCAT(customer_code,' - ',customer_company_name),visit_date,Visits.notes FROM Visits , Customers WHERE Visits.customer_id = Customers.customer_id $where  AND DATE(visit_date) BETWEEN '$dateFrom' AND '$dateTo' $Allow_Customers $visitReasonsQuery");
        $stm->execute();
        $stm->bind_result($ID, $code, $customerID, $customerName, $date, $notes);
        while ($stm->fetch()) {

            $distance = getDistance('Visits', 'visit_code', $code);

            $visit = new stdClass();
            $visit->id = $ID;
            $visit->code = $code;
            $visit->customerID = $customerID;
            $visit->customerName = $customerName;
            $visit->date = date("d-m-Y H:i:s", strtotime($date));
            $visit->notes = $notes;
            $visit->distance = $distance[0];
            $visit->customerLatLng = "Lat: " . $distance[1] . "<br/> Lng: " . $distance[2];
            $visit->customerLng = "Lat: " . $distance[3] . "<br/> Lng: " . $distance[4];
            $visit->type = "Visit";

            array_push($actions, $visit);
        }
        $stm->close();
    }

    if(strcmp($incTenders,'yes')==0) {
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT tender_id,tender_code, Tenders.customer_id, CONCAT(customer_code,' - ',customer_company_name),tender_date,details FROM Tenders , Customers WHERE Tenders.customer_id = Customers.customer_id $where AND tender_date BETWEEN '$dateFrom' AND '$dateTo' $Allow_Customers");
        $stm->execute();
        $stm->bind_result($ID, $code, $customerID, $customerName, $date, $notes);
        while ($stm->fetch()) {

            $distance = getDistance('Tenders', 'tender_code', $code);
            $time = getActionTime($code, 'Tender');

            $tender = new stdClass();
            $tender->id = $ID;
            $tender->code = $code;
            $tender->customerID = $customerID;
            $tender->customerName = $customerName;
            $tender->date = date("d-m-Y", strtotime($date)) . " $time";
            $tender->notes = $notes;
            $tender->distance = $distance[0];
            $tender->customerLatLng = "Lat: " . $distance[1] . "<br/> Lng: " . $distance[2];
            $tender->customerLng = "Lat: " . $distance[3] . "<br/> Lng: " . $distance[4];
            $tender->type = "Tender";

            array_push($actions, $tender);
        }
        $stm->close();
    }

    if(strcmp($incOrders,'yes')==0) {
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT order_id,order_code, Orders.customer_id, CONCAT(customer_code,' - ',customer_company_name),order_date,details,Orders.subtotal-Orders.discount_amount FROM Orders , Customers WHERE Orders.customer_id = Customers.customer_id $where AND order_date BETWEEN '$dateFrom' AND '$dateTo' $Allow_Customers");
        $stm->execute();
        $stm->bind_result($ID, $code, $customerID, $customerName, $date, $notes, $orderNet);
        while ($stm->fetch()) {

            $distance = getDistance('Orders', 'order_code', $code);
            $time = getActionTime($code, 'Order');

            $order = new stdClass();
            $order->id = $ID;
            $order->code = $code;
            $order->customerID = $customerID;
            $order->customerName = $customerName;
            $order->date = date("d-m-Y", strtotime($date)) . " $time";
            $order->notes = $notes;
            $order->net = number_format($orderNet,2);
            $order->distance = $distance[0];
            $order->customerLatLng = "Lat: " . $distance[1] . "<br/> Lng: " . $distance[2];
            $order->customerLng = "Lat: " . $distance[3] . "<br/> Lng: " . $distance[4];
            $order->type = "Order";

            $orderTotal += $orderNet;

            $CustomersWithOrder .= "$customerID,";

            array_push($actions, $order);
        }
        $stm->close();
    }

    if(strcmp($incWaybills,'yes')==0) {
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT waybill_id,waybill_code,Waybills.customer_id,CONCAT(customer_code,' - ',customer_company_name),waybill_date,Waybills.details FROM Waybills , Customers WHERE Waybills.customer_id = Customers.customer_id $where AND waybill_date BETWEEN '$dateFrom' AND '$dateTo' $Allow_Customers");
        $stm->execute();
        $stm->bind_result($ID, $code, $customerID, $customerName, $date, $notes);
        while ($stm->fetch()) {

            $distance = getDistance('Waybills', 'waybill_code', $code);
            $time = getActionTime($code, 'Waybill');

            $waybill = new stdClass();
            $waybill->id = $ID;
            $waybill->code = $code;
            $waybill->customerID = $customerID;
            $waybill->customerName = $customerName;
            $waybill->date = date("d-m-Y", strtotime($date)) . " $time";
            $waybill->notes = $notes;
            $waybill->distance = $distance[0];
            $waybill->customerLatLng = "Lat: " . $distance[1] . "<br/> Lng: " . $distance[2];
            $waybill->customerLng = "Lat: " . $distance[3] . "<br/> Lng: " . $distance[4];
            $waybill->type = "Waybill";

            array_push($actions, $waybill);
        }
        $stm->close();
    }

    if(strcmp($incInvoices,'yes')==0) {
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT invoice_id,invoice_code,Invoices.customer_id,CONCAT(customer_code,' - ',customer_company_name),invoice_date,details,Invoices.subtotal-Invoices.discount_amount FROM Invoices , Customers WHERE Invoices.customer_id = Customers.customer_id $where AND invoice_date BETWEEN '$dateFrom' AND '$dateTo' $Allow_Customers");
        $stm->execute();
        $stm->bind_result($ID, $code, $customerID, $customerName, $date, $notes, $invoiceNet);
        while ($stm->fetch()) {

            $distance = getDistance('Invoices', 'invoice_code', $code);
            $time = getActionTime($code, 'Invoice');

            $invoice = new stdClass();
            $invoice->id = $ID;
            $invoice->code = $code;
            $invoice->customerID = $customerID;
            $invoice->customerName = $customerName;
            $invoice->date = date("d-m-Y", strtotime($date)) . " $time";
            $invoice->notes = $notes;
            $invoice->net = number_format($invoiceNet,2);
            $invoice->distance = $distance[0];
            $invoice->customerLatLng = "Lat: " . $distance[1] . "<br/> Lng: " . $distance[2];
            $invoice->customerLng = "Lat: " . $distance[3] . "<br/> Lng: " . $distance[4];
            $invoice->type = "Invoice";

            $invoiceTotal += $invoiceNet;

            array_push($actions, $invoice);
        }
        $stm->close();
    }

    if(strcmp($incReturns,'yes')==0) {
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT return_id,return_code,Returns.customer_id,CONCAT(customer_code,' - ',customer_company_name),return_date,details,Returns.subtotal-Returns.discount_amount FROM Returns , Customers WHERE Returns.customer_id = Customers.customer_id $where AND return_date BETWEEN '$dateFrom' AND '$dateTo' $Allow_Customers");
        $stm->execute();
        $stm->bind_result($ID, $code, $customerID, $customerName, $date, $notes, $returnNet);
        while ($stm->fetch()) {

            $distance = getDistance('Returns', 'return_code', $code);
            $time = getActionTime($code, 'Return');

            $return = new stdClass();
            $return->id = $ID;
            $return->code = $code;
            $return->customerID = $customerID;
            $return->customerName = $customerName;
            $return->date = date("d-m-Y", strtotime($date)) . " $time";
            $return->notes = $notes;
            $return->net = number_format($returnNet,2);
            $return->distance = $distance[0];
            $return->customerLatLng = "Lat: " . $distance[1] . "<br/> Lng: " . $distance[2];
            $return->customerLng = "Lat: " . $distance[3] . "<br/> Lng: " . $distance[4];
            $return->type = "Return";

            $returnTotal += $returnNet;

            array_push($actions, $return);
        }
        $stm->close();
    }

    if(strcmp($incReceipts,'yes')==0) {
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT receipt_id,receipt_code,Receipts.customer_id,CONCAT(customer_code,' - ',customer_company_name),receipt_date,notes, Receipts.amount+Receipts.cash_discount FROM Receipts , Customers WHERE Receipts.customer_id = Customers.customer_id $where AND receipt_date BETWEEN '$dateFrom' AND '$dateTo' $Allow_Customers");
        $stm->execute();
        $stm->bind_result($ID, $code, $customerID, $customerName, $date, $notes, $receiptNet);
        while ($stm->fetch()) {

            $distance = getDistance('Receipts', 'receipt_code', $code);
            $time = getActionTime($code, 'Receipt');

            $receipt = new stdClass();
            $receipt->id = $ID;
            $receipt->code = $code;
            $receipt->customerID = $customerID;
            $receipt->customerName = $customerName;
            $receipt->date = date("d-m-Y", strtotime($date)) . " $time";
            $receipt->notes = $notes;
            $receipt->net = number_format($receiptNet,2);
            $receipt->distance = $distance[0];
            $receipt->customerLatLng = "Lat: " . $distance[1] . "<br/> Lng: " . $distance[2];
            $receipt->customerLng = "Lat: " . $distance[3] . "<br/> Lng: " . $distance[4];
            $receipt->type = "Receipt";

            $receiptTotal += $receiptNet;

            array_push($actions, $receipt);
        }
        $stm->close();
    }

    if(strcmp($incWHTransactions,'yes')==0) {
        $whTransactions = array();
        $stm2 = $db->prepare("SELECT warehouse_transaction_id,warehouse_transaction_code, warehouse_id_from, warehouse_id_to, type,transaction_date  FROM Warehouse_Transactions WHERE salesperson_id = $salespersonID AND DATE(transaction_date) BETWEEN '$dateFrom' AND '$dateTo' ORDER BY transaction_date DESC");
        $stm2->execute();
        $stm2->bind_result($whid, $whCode, $whFrom, $hwTo, $whType, $whDate);
        while ($stm2->fetch()) {
            $countWHTransactions++;
            $whTransaction = new stdClass();

            $whTransaction->counter = $countWHTransactions;
            $whTransaction->id = $whid;
            $whTransaction->code = $whCode;
            $whTransaction->type = $whType;
            $whTransaction->from = $whFrom;
            $whTransaction->to = $hwTo;
            $whTransaction->date = $whDate;
            array_push($whTransactions, $whTransaction);


        }
        $stm2->close();
    }

    usort($actions, function($a, $b) {
        return strtotime($b->date) - strtotime($a->date);
    });

    if (!empty($actions) || !empty($whTransactions)) {
        $report .= "<table style='margin-top: 20px;border-collapse: collapse;width: 100%' >
                     
                     <tr><td style='border: 1px solid lightgrey;padding:0;background:#cadbf7;width: 15%'>Code:      &nbsp;</td><td style='border: 1px solid lightgrey;padding-right: 5px;'>&nbsp; $salespersonCode  </td></tr>
                     <tr><td style='border: 1px solid lightgrey;padding:0;background:#cadbf7;width: 15%'>Name:      &nbsp;</td><td style='border: 1px solid lightgrey;padding-right: 5px;'>&nbsp; $userName         </td></tr>
                     <tr><td style='border: 1px solid lightgrey;padding:0;background:#cadbf7;width: 15%'>Full Name: &nbsp;</td><td style='border: 1px solid lightgrey;padding-right: 5px;'>&nbsp; $salespersonName  </td></tr>
                     
                 </table>      
";
        if(strcmp($incVisits,'yes')==0 || strcmp($incTenders,'yes')==0 || strcmp($incOrders,'yes')==0 || strcmp($incWaybills,'yes')==0 || strcmp($incInvoices,'yes')==0 || strcmp($incReceipts,'yes')==0 || strcmp($incReturns,'yes')==0) {
            if($showActionLines) {
                $report .= "<table class='table table-striped table-bordered' style='border-collapse: collapse; width: 100%;margin-bottom: 0px;'>
            <thead>
            <tr style='border-top: 1px solid #a7c6f9;border-bottom: 1px solid #a7c6f9;padding:0;background:#cadbf7;'>
            <th><b><center>No.</center></b></th>
            <th><b><center>Customer</center></b></th>
            <th><b><center>Action Type</center></b></th>
            <th><b><center>Code</center></b></th>
            <th><b><center>Notes</center></b></th>
            <th><b><center>Distance</center></b></th>";
                if ($showLatLng) {
                    $report .= "
            <th><b><center>Customer<br/>Location</center></b></th>
            <th><b><center>Sales Person<br/>Location</center></b></th>";
                }
                $report .= "
            <th><b><center>sDate / Time</center></b></th>
            <th><b><center>Net Value</center></b></th>
            </tr>        
            </thead>
            <tbody >";
            } else {
                $report .= "<table class='table table-striped table-bordered' style='border-collapse: collapse; width: 100%;margin-bottom: 0px;'>
            <thead>
            <tr style='border-top: 1px solid #a7c6f9;border-bottom: 1px solid #a7c6f9;padding:0;background:#cadbf7;'>
            <th><b><center></center></b></th>
            <th><b><center></center></b></th>
            <th><b><center></center></b></th>
            <th><b><center></center></b></th>
            <th><b><center></center></b></th>
            <th><b><center></center></b></th>";
                if ($showLatLng) {
                    $report .= "
            <th><b><center><br/></center></b></th>
            <th><b><center><br/></center></b></th>";
                }
                $report .= "
            <th><b><center></center></b></th>
            <th><b><center></center></b></th>
            </tr>        
            </thead>
            <tbody >";

            }

            foreach ($actions as $action) {

                $counter++;
                if($showActionLines) {
                    $report .= "<tr ><td  align='center' style='border: 1px solid lightgray;'>$counter</td><td style='border: 1px solid lightgray;'><a target='_blank' href='//" . HTML_PATH . "/cop/backend/core/views/view/view_customer.php?customerID=$action->customerID'>$action->customerName</td><td  align='center' style='border: 1px solid lightgray;'><div align='center'>$action->type</td><td  align='center' style='border: 1px solid lightgray;'><a target='_blank' href='//" . HTML_PATH . "/cop/backend/core/views/view/view_action.php?actionCode=$action->code&actionType=$action->type'><div align='center'>$action->code</td><td style='border: 1px solid lightgray;'>$action->notes</td><td  align='center' style='border: 1px solid lightgray;'><div align='center'>$action->distance</td>";
                    if ($showLatLng) {
                        $report .= "<td style='border: 1px solid lightgray;'>$action->customerLatLng</td><td style='border: 1px solid lightgray;'>$action->customerLng</td>";
                    }
                    $report .= "<td style='border: 1px solid lightgray;' align='center'>$action->date</td><td  align='right' style='border: 1px solid lightgray;'><div align='right'>$action->net</div></td></tr>";
                }
                $customers .= $action->customerID . ",";
            }
        }

        $customers = rtrim($customers, ',');
        $CustomersWithOrder = rtrim($CustomersWithOrder, ',');
        $countCustomers = 0;
        $customersWithOrders = 0;
        $countNotes = '';
        $countWHTransactions = 0;
        $countTransactions = '';

        if(strcmp($customers,'')!=0) {

            $stm2 = $db->prepare("SELECT COUNT(DISTINCT customer_id) FROM Customers WHERE  customer_id IN($customers)");
            $stm2->execute();
            $stm2->bind_result($countCustomers);
            while ($stm2->fetch()) {}
            $stm2->close();
        } else { $countCustomers = 0;}

        if(strcmp($CustomersWithOrder,'')!=0) {

            $stm2 = $db->prepare("SELECT COUNT(DISTINCT customer_id) FROM Customers WHERE  customer_id IN($CustomersWithOrder)");
            $stm2->execute();
            $stm2->bind_result($CustomersWithOrders);
            while ($stm2->fetch()) {}
            $stm2->close();
        } else { $CustomersWithOrders = 0;}

        $stm2 = $db->prepare("SELECT DISTINCT COUNT(customer_id), notes FROM Visits  WHERE salesperson_id = $salespersonID AND DATE(visit_date) BETWEEN '$dateFrom' AND '$dateTo' $visitReasonsQuery GROUP BY notes");
        $stm2->execute();
        $stm2->bind_result($customers, $reason);
        while ($stm2->fetch()) {
            if(strcmp($reason,'') != 0) {
                $countNotes .= "<tr><td style='border: 1px solid lightgray;'> $reason </td><td style='border: 1px solid lightgray;'> $customers</td></tr>";
            }

        }
        $stm2->close();
        if(strcmp($countNotes,'')==0){
            $countNotes = "<tr><td colspan='2' style='border: 1px solid lightgray;' align='center'> No Visit Reasons</td></tr>";
        }


        if(!empty($whTransactions)) {
            $warehouse = array();
            $stm2 = $db->prepare("SELECT warehouse_id,warehouse_code, name FROM Warehouses ");
            $stm2->execute();
            $stm2->bind_result($whid, $whCode, $whName);
            while ($stm2->fetch()) {
                $warehouse[$whid] = "$whCode $whName";
            }
            $stm2->close();
        }

        foreach ($whTransactions as $whTransaction){


            $whFrom = $warehouse[$whTransaction->from];
            $whTo = $warehouse[$whTransaction->to];

            $whTransDate = date_format( date_create_from_format('Y-m-d', $whTransaction->date), 'd-m-Y');
            $countTransactions .= "<tr>
                                            <td style='border: 1px solid lightgray;'> $whTransaction->counter </td>
                                            <td style='border: 1px solid lightgray;'><a target='_blank' href='//".HTML_PATH."/cop/backend/core/views/view/view_warehouse_transaction.php?warehouse_transaction_id=$whTransaction->id'> $whTransaction->code </a></td>
                                            <td style='border: 1px solid lightgray;'> $whTransaction->type</td>
                                            <td style='border: 1px solid lightgray;'> $whFrom</td>
                                            <td style='border: 1px solid lightgray;'> $whTo</td>
                                            <td style='border: 1px solid lightgray;'> $whTransDate</td>
                                       </tr>";
        }
        if(strcmp($countTransactions,'')==0){
            $countTransactions = "<tr><td colspan='6' style='border: 1px solid lightgray;' align='center'> No Warehouse Transactions</td></tr>";
        }

        $orderTotal = number_format($orderTotal,2);
        $invoiceTotal = number_format($invoiceTotal,2);
        $returnTotal = number_format($returnTotal,2);
        $receiptTotal = number_format($receiptTotal,2);

        if($showLatLng){
            $colspan = 6;
        } else {
            $colspan = 4;
        }
        if(strcmp($incVisits,'yes')==0 || strcmp($incTenders,'yes')==0 || strcmp($incOrders,'yes')==0 || strcmp($incWaybills,'yes')==0 || strcmp($incInvoices,'yes')==0 || strcmp($incReceipts,'yes')==0 || strcmp($incReturns,'yes')==0) {
            $report .= "<tr><td colspan='2' style='border: 1px solid lightgray;' align='center'><b>Unique Customers: $countCustomers </td><td colspan='$colspan' style='border: 1px solid lightgray;' align='center'><b>Customers With Orders: $CustomersWithOrders</td><td colspan='2' style='border: 1px solid lightgray;' align='center'><b><div align='right' ><table style='width: 100%; border-collapse: collapse;'><tr><td style='text-align: right;' ><div style='text-align: right;'>Orders Total:</td><td style='text-align: right;'><div style='text-align: right;'> $orderTotal</td></tr><tr><td style='text-align: right;'><div style='text-align: right;'>Invoices Total:</td><td style='text-align: right;'><div style='text-align: right;'> $invoiceTotal</td></tr><tr><td style='text-align: right;'><div style='text-align: right;'>Returns Total:</td><td style='text-align: right;'><div style='text-align: right;'> $returnTotal</td></tr><tr><td style='text-align: right;'><div style='text-align: right;'>Receipts total:</td><td style='text-align: right;'><div style='text-align: right;'> $receiptTotal</td></tr><tr><td style='text-align: right;border-bottom: 2px solid black;'></td><td style='text-align: right;border-bottom: 2px solid black;'></td></tr></table>";
            $report .= "</tbody></table>";
        }
        if(strcmp($incVisits,'yes')==0) {
            $report .= "<table class='table table-striped table-bordered' style='width: 100%; border-collapse: collapse;margin-bottom: 50px !important;'>
                                                  <tr><td style='border: 1px solid lightgray;background:#cadbf7;' align='center'><b>Visit Reasons </b></td><td style='border: 1px solid lightgray;background:#cadbf7;' align='center'><b> Number of Customers </b></td></tr>
                                                  $countNotes
                                               </table>";
        }
        if(strcmp($incWHTransactions,'yes')==0) {
            $report .= "<table class='table table-striped table-bordered' style='width: 100%; border-collapse: collapse; margin-bottom: 20px;'>
                                                  <tr>
                                                    <td style='border: 1px solid lightgray;background:#cadbf7;' align='center'><b>No. </b></td>
                                                    <td style='border: 1px solid lightgray;background:#cadbf7;' align='center'><b>Warehouse Transaction </b></td>
                                                    <td style='border: 1px solid lightgray;background:#cadbf7;' align='center'><b> Type </b></td>
                                                    <td style='border: 1px solid lightgray;background:#cadbf7;' align='center'><b> From </b></td>
                                                    <td style='border: 1px solid lightgray;background:#cadbf7;' align='center'><b> To </b></td>
                                                    <td style='border: 1px solid lightgray;background:#cadbf7;' align='center'><b> Date </b></td>
                                                  </tr>
                                                  $countTransactions
                                               </table>";
        }
    }
}

if(strcmp($report,'')==0) {
    $report = "<center><b>No Data found </b></center>";
}

$report = "<style>


        body
        {
           font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
           

        }

        p
        {

        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }
        

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }
       

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        td {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
        
             margin-left: 1.4cm;
             margin-right: 1.4cm;
        
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }

    </style>
    <htmlpageheader name='myHTMLHeader1'></htmlpageheader>

".$report;

echo $report;
return $report;

function sort_objects_by_date($a, $b)
{
    if ($a->date == $b->date) {
        return 0;
    }
    return ($a->date < $b->date) ? 1 : -1;
}

function getDistance($actionTable,$actionColumn,$actionID){

    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT Schedule_Object_Actions.customer_id, Schedule_Object_Actions.lat, Schedule_Object_Actions.lng
                                FROM  $actionTable, Schedule_Object_Actions
                                WHERE $actionTable.$actionColumn = Schedule_Object_Actions.action_id
                                AND Schedule_Object_Actions.action_id = '$actionID' LIMIT 1");
    $stm->execute();
    $stm->bind_result( $customerID, $spLat, $spLng);
    while ($stm->fetch()) {}
    $stm->close();
    if($customerID > 0) {
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT CustomerAddress.lat, CustomerAddress.lng
                                    FROM  CustomerAddress
                                    WHERE CustomerAddress.customer_id='$customerID'");
        $stm->execute();
        $stm->bind_result($customerLat, $customerLng);
        while ($stm->fetch()) {}
        $stm->close();
    }



    $distance = round( distance($customerLat, $customerLng, $spLat, $spLng) , 2 );

    $empty = false;
    if(strcmp($distance,'')==0 || $distance == 0) {
        $distance = 0 ;
    }
    if(strcmp($customerLat,'')==0 || $customerLat == 0) {
        $customerLat = '-' ;
        $empty = true;
    } else {
        $customerLat = number_format($customerLat, 3, '.', ',');
    }
    if(strcmp($customerLng,'')==0  || $customerLng == 0) {
        $customerLng = '-' ;
        $empty = true;
    } else {
        $customerLng = number_format($customerLng, 3, '.', ',');
    }
    if(strcmp($spLat,'')==0 || $spLat == 0) {
        $spLat = '-' ;
        $empty = true;
    } else {
        $spLat = number_format($spLat, 3, '.', ',');
    }
    if(strcmp($spLng,'')==0 || $spLng == 0) {
        $spLng = '-' ;
        $empty = true;
    } else {
        $spLng = number_format($spLng, 3, '.', ',');
    }

    if($empty){
        $distance = '-' ;
    }
    return  array($distance, $customerLat, $customerLng, $spLat, $spLng);

}

function getActionTime($code,$type){
    global $username,$password,$database;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stm2 = $db1->prepare("SELECT date FROM Schedule_Object_Actions WHERE action_id='$code' AND action_type='$type'");
    $stm2-> execute();
    $stm2-> bind_result($soDate);
    while ($stm2->fetch()) {$soTime = date_format( date_create_from_format('Y-m-d H:i:s', $soDate), 'H:i');}
    $stm2-> close();
    return $soTime;
}

function distance($lat1, $lon1, $lat2, $lon2) {
    $pi80 = M_PI / 180;
    $lat1 *= $pi80;
    $lon1 *= $pi80;
    $lat2 *= $pi80;
    $lon2 *= $pi80;
    $r = 6372.797; // mean radius of Earth in km
    $dlat = $lat2 - $lat1;
    $dlon = $lon2 - $lon1;
    $a = sin($dlat / 2) * sin($dlat / 2) + cos($lat1) * cos($lat2) * sin($dlon / 2) * sin($dlon / 2);
    $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
    $km = $r * $c;
//echo ' '.$km;
    return $km;
}

?>

