<?php
include_once("../../../../param.php");

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$whereSP = '';
$whereSPSchedule = '';
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    $whereSP .= " AND salesperson_id IN (".$_SESSION['Allow_Salespersons'].")";
    $schedulesArray = array();
    $stm = $db->prepare("SELECT schedule_id FROM Schedule_Salesperson $whereSP");
    $stm-> execute();
    $stm-> bind_result( $scheduleFilterID);
    while ($stm->fetch()) {
        array_push($schedulesArray,$scheduleFilterID);
    }
    $whereSPSchedule = implode(',',$schedulesArray);
    if(strcmp($whereSPSchedule,'')!=0){$whereSPSchedule = "AND schedule_id IN($whereSPSchedule)";}
}

$scheduleSelection = "<option value='0'>- All Schedules -</option>";
$stm = $db->prepare("SELECT schedule_id, name, type FROM Schedules WHERE 1=1 $whereSP");
$stm-> execute();
$stm-> bind_result($chID,$chName, $chType);
while ($stm->fetch()) {
    $scheduleSelection .= "<option value='$chID'>$chName ($chType)</option>";
}

$stm-> close();

$salespersonSelection = "<option value='0'>- All Sales Persons -</option>";
$stm = $db->prepare("SELECT salesperson_id,CONCAT(salesperson_code,' - ',first_name,' ',last_name) FROM SalesPersons WHERE 1=1 $whereSP");
$stm-> execute();
$stm-> bind_result($spID,$spName);
while ($stm->fetch()) {
    $salespersonSelection .= "<option value='$spID'>$spName</option>";
}

$stm-> close();



?>

<div id="main" role="main" class="background-color-whitish">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Reports / Single  Report</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                <span>  <a onclick="backToReports()" class="btn btn-primary"><i class="fa fa-arrow-left"></i>&nbsp; Back to Reports</a> </span>
                <h3 style="display:inline;margin-left:10px;" class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-signal"></i>
                    Reports
                </h3>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="" style="margin-top:10px;">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-110" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Filter Scheduled Customers Without Location </h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">
                                <label style="display: block; margin-top: 10px"><b>Select Schedule:</b></label>
                                <select name="schedule" id="schedule" class="form-control" style="width: 30%">
                                    <?php echo $scheduleSelection; ?>
                                </select>
                                <label style="display: block; margin-top: 10px"><b>Select Sales Person:</b></label>
                                <select name="salesPerson" id="salesPerson" class="form-control" style="width: 30%">
                                    <?php echo $salespersonSelection; ?>
                                </select>
                                <label style="display: block; margin-top: 10px"><b>Customer Status:</b></label>
                                <table style="width: 30%">
                                <tr>
                                    <td>Active</td>
                                    <td>Inactive</td>
                                </tr>
                                <tr>
                                    <td><input type="checkbox" class="form-control" width="50" height="50" id="customerActive" name="customerActive" value="yes" checked="checked"></td>
                                    <td><input type="checkbox" class="form-control" width="50" height="50" id="customerInActive" name="customerInActive" value="yes" checked="checked"></td>
                                </tr>
                                </table>
                                <br/>
                                <br/>
                                <button type="button" name="generateReport" id="generateReport" class="btn btn-primary" onclick="getReport()" >Generate Report</button>
                                <button type="button" name="generateExcel"  id="generateExcel"  class="btn btn-waybill" onclick="exportXLS()" >Export to Excel</button>
                                <button type="button" name="generatePDF"    id="generatePDF"    class="btn btn-danger"  onclick="exportPDF()" >Export PDF</button>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Scheduled Customers Without Location Report</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

                            <div name="reportResult" id="reportResult"></div>
                                <form method="POST" action="#" name="xlsForm" id="xlsForm" >
                                    <input type="hidden" name="inputResult" id="inputResult" value=""/>
                                    <input type="hidden" name="inputTitle" id="inputTitle" value="ScheduledCustomersWithoutLocation"/>
                                </form>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

            </div>


    </div>
    <!-- end widget content -->

    <!-- end row -->
    </section>

</div>

<script type="text/javascript">

    $(document).ready(function() {

        pageSetUp();

        $('#schedule').select2();
        $('#salesPerson').select2();

    });

    function getReport(){

        var salesPerson = $('#salesPerson').val();
        var schedule = $('#schedule').val();
        var customerActive = $('#customerActive:checked').val();
        var customerInActive = $('#customerInActive:checked').val();


        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateScheduledCustomersWithoutLocationReport.php',
            data: {
                'schedule':schedule,
                'salesPerson':salesPerson,
                'customerActive':customerActive,
                'customerInActive':customerInActive

            },

            success: function (result) {
                $('#reportResult').html(result);
            }
        });

    }

    function exportXLS(){

        var salesPerson = $('#salesPerson').val();
        var schedule = $('#schedule').val();
        var customerActive = $('#customerActive:checked').val();
        var customerInActive = $('#customerInActive:checked').val();


        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateScheduledCustomersWithoutLocationReport.php',
            data: {
                'schedule':schedule,
                'salesPerson':salesPerson,
                'customerActive':customerActive,
                'customerInActive':customerInActive
            },

            success: function (result) {
                $('#reportResult').html(result);
                $('#inputResult').val(result);
                $('#xlsForm').attr('action','//<?php echo HTML_PATH ?>/cop/backend/core/templates/xls/generateGeneralXLS.php').submit();
            }
        });

    }

    function exportPDF(){

        var salesPerson = $('#salesPerson').val();
        var schedule = $('#schedule').val();
        var customerActive = $('#customerActive:checked').val();
        var customerInActive = $('#customerInActive:checked').val();


        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateScheduledCustomersWithoutLocationReport.php',
            data: {
                'schedule':schedule,
                'salesPerson':salesPerson,
                'customerInActive':customerInActive,
                'customerActive':customerActive
            },

            success: function (result) {
                $('#reportResult').html(result);
                $('#inputResult').val(result);
                $('#xlsForm').attr('action','//<?php echo HTML_PATH ?>/cop/backend/core/templates/pdf/generatePDFFromHTML.php').submit();
            }
        });

    }



    function backToReports() {
        try {
            $(".swLinkMenu")[0].click();
        }
        catch(err)
        {

        }

        setTimeout(function() {
            window.location = "//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/reports_list.php";
        }, 1000);


    }

</script>


