<?php
include_once("../../../../param.php");

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");


$stm = $db->prepare("SELECT CONCAT(salesperson_code, ' - ',first_name, ' ', last_name) , salesperson_id FROM SalesPersons");
$stm-> execute();
$stm-> bind_result($salespersonName, $salespersonID);
while ($stm->fetch()) {
    $salesPersonSelection .= "<option value='$salespersonID'>$salespersonName</option>";
}

$stm-> close();


?>

<div id="main" role="main" class="background-color-whitish">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Reports / Single  Report</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                <h3 style="display:inline;margin-left:10px;" class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-signal"></i>
                    CRM Posts Report
                </h3>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="" style="margin-top:10px;">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>CRM Posts Criteria</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">
                                <label style="display: block"><b>Select Date Range (From / To):</b></label>
                                <input type="date" name="dateFrom" id="dateFrom" class="form-control" style="display: inline-block;width: 199px;">
                                <input type="date" name="dateTo" id="dateTo" class="form-control" style="display: inline-block;width: 199px;">
                                <label style="display: block; margin-top: 10px"><b>Select Customer:</b></label>
                                <input type="text" name="customer" id="customer" class="form-control" style="width: 400px;display: inline-block;">

                                <label style="display: block; margin-top: 10px"><b>Select Sales Person:</b></label>
                                <select name="salesPerson" id="salesPerson"  class="form-control" style="width: 400px;">
                                    <option value="" selected> All Sales Persons</option>
                                    <?php echo $salesPersonSelection; ?>
                                </select>
                                <br><br>
                                <button type="button" name="generateReport" id="generateReport" class="btn btn-primary" onclick="getReport()" >Generate Report</button>
                                <button type="button" name="generateExcel"  id="generateExcel"  class="btn btn-tender" onclick="exportPDF()" >Export PDF</button>
                                <button type="button" name="generatePDF"    id="generatePDF"    class="btn btn-waybill" onclick="exportXLS()" >Export Excel</button>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>CRM Posts Report</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

                            <div name="reportResult" id="reportResult"></div>
                                <form method="POST" action="//<?php echo HTML_PATH ?>/cop/backend/core/templates/pdf/generatePDFFromHTML.php" name="pdfForm" id="pdfForm" target="_blank">
                                    <input type="hidden" name="inputResult" id="inputResultPDF" value=""/>
                                </form>
                                <form method="POST" action="//<?php echo HTML_PATH ?>/cop/backend/core/templates/xls/generateGeneralXLS.php" name="xlsForm" id="xlsForm" target="_blank">
                                    <input type="hidden" name="inputResult" id="inputResultXLS" value=""/>
                                </form>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

            </div>


    </div>
    <!-- end widget content -->

    <!-- end row -->
    </section>

</div>

<script type="text/javascript">

    $(document).ready(function() {

        pageSetUp();
        // $('#customer').select2();
        $('#salesPerson').select2();
        $("#customer").select2({
            tags: true,
            multiple: true,
            tokenSeparators: [',', ' '],
            minimumInputLength: 2,
            minimumResultsForSearch: 1,
            ajax: {
                url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/customerSearch.php",
                dataType: "json",
                type: "GET",
                data: function (term, page) {
                    return {
                        query: term
                        //page: page,
                        // pageLimit: 25
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

    });

    function getReport(){

        var salesPerson = $('#salesPerson').val();
        var customer   = $('#customer').val();
        var dateFrom    = $('#dateFrom').val();
        var dateTo      = $('#dateTo').val();

        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateCRMPostsReport.php',
            data: {
                'salesPerson':salesPerson,
                'customer':customer,
                'dateFrom':dateFrom,
                'dateTo':dateTo

            },

            success: function (result) {
                $('#reportResult').html(result);
            }
        });

    }

    function exportXLS() {

        var salesPerson = $('#salesPerson').val();
        var customer    = $('#customer').val();
        var dateFrom    = $('#dateFrom').val();
        var dateTo      = $('#dateTo').val();

        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateCRMPostsReport.php',
            data: {
                'salesPerson':salesPerson,
                'customer':customer,
                'dateFrom':dateFrom,
                'dateTo':dateTo

            },

            success: function (result) {
                $('#reportResult').html(result);
                $('#inputResultXLS').val(result);
                $('#xlsForm').submit();
            }
        });
    }

    function exportPDF(){

            var salesPerson = $('#salesPerson').val();
            var customer    = $('#customer').val();
            var dateFrom    = $('#dateFrom').val();
            var dateTo      = $('#dateTo').val();

            $('#reportResult').html('<center><b>Generating Report..</b></center>');

            $.ajax({
                type: "POST",
                url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateCRMPostsReport.php',
                data: {
                    'salesPerson':salesPerson,
                    'customer':customer,
                    'dateFrom':dateFrom,
                    'dateTo':dateTo

                },

                success: function (result) {
                    $('#reportResult').html(result);
                    $('#inputResultPDF').val(result);
                    $('#pdfForm').submit();
                }
            });



    }

    function backToReports() {
        try {
            $(".swLinkMenu")[0].click();
        }
        catch(err)
        {

        }

        setTimeout(function() {
            window.location = "//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/reports_list.php";
        }, 1000);


    }

</script>


