<?php
include_once("../../../../param.php");

$todayDBFormat = date("Y-m-d");



?>

<div class="container" id="main" role="main">

    <div class="row" style="margin-left:10px;margin-top:10px;">
        <div class="col-xs-12 col-sm-8 col-md-9 col-lg-2">
            <h4 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;" id="currentDateText">
                <i class="fa-fw fa fa-map-marker"></i>
                Salesperson Locations
            </h4>
        </div>

        <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
            <div class="hasinput ">
                <input id="dateselect_filter" type="text" placeholder="Select Date" class="form-control datepicker text-center" data-dateformat="yy-mm-dd" value="<?php echo $todayDBFormat ?>">
            </div>
        </div>
        <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
            <select id="salespersonSelect" class="js-example-basic-single form-control" style="margin-left:20px;display: inline">
                <?php
                $whereSP = '';
                if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
                    $whereSP .= " AND salesperson_id IN (".$_SESSION['Allow_Salespersons'].")";
                }
                global $username,$password,$database;
                $db = new mysqli('localhost',$username,$password,$database);
                if (mysqli_connect_errno()) {
                    printf("Connect failed: %s\n", mysqli_connect_error());
                    exit();
                }
                $db->set_charset("utf8");
                // WHERE compani code in  Session
                $stm = $db->prepare("SELECT salesperson_id,salesperson_code,first_name,last_name FROM SalesPersons WHERE gps_track = 'yes' $whereSP");
                $stm-> execute();
                $stm-> bind_result($salespersonID,$code,$first_name,$last_name);
                while ($stm->fetch()) {

                    echo "<option value='$salespersonID'>$code $first_name $last_name</option>";
                }
                $stm-> close();
                ?>
            </select>

        </div>
        <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
            <button class="btn btn-primary btn-block" onclick="toggleCustomers()"><i class="fa fa-map-marker"></i>&nbsp; Toggle Customers</button>

        </div>

        <div class="col-xs-12 col-sm-4 col-md-3 col-lg-1">
            <button class="btn btn-info btn-block" onclick="toggleLines()"> Show Lines</button>

        </div>

        <div class="col-xs-12 col-sm-4 col-md-3 col-lg-1">
            <button style="display: inline" class="btn btn-primary" onclick="previousMarker()"><i class="fa fa-arrow-left"></i></button>
            <button style="display: inline" class="btn btn-primary" onclick="nextMarker()"><i class="fa fa-arrow-right"></i></button>
        </div>




    </div>

    <!-- MAIN CONTENT -->

    <div class="map" id="map_coprime" ></div>

</div>

<script
        src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAonEryABOdRQBcgEfH51-nOoXTca3XlWs">
</script>

<style>

    html { height: 100% }
    body { height: 100%; margin: 0px; padding: 0px }
    .container { width: 100%; height: 100% }
    #nav { z-index: 100; position: absolute;
        margin: 10px 0px 0px 200px; background-color: #fff;
        border: 1px #000 Solid; padding: 5px; }
    .map { width: 100%; height: 100% }
</style>


<script type="text/javascript">

    var copMap;
    var markers=[];

    var customerMarkers = [];

    var showCustomers = false;
    var showLines = false;

    var currentMarkerPosition = 0;
    var flightPath;
    var latlngs = [];

    function initMap() {
        copMap = new google.maps.Map(document.getElementById('map_coprime'), {
            center: {lat: 34.92, lng: 33.63},
            zoom: 8
        });
    }

    function updateMarkers()
    {
        initMap();

        currentMarkerPosition = 0;

        var salespersonID = $('#salespersonSelect').val();
        var selectedDate = $('#dateselect_filter').val();


        if(flightPath != null) {
            flightPath.setMap(null);
        }
        if(latlngs != null)
        {
            latlngs = [];
        }


        $.ajax({
            type:"POST",
            dataType: "json",
            url: '<?php echo "//" . HTML_PATH . "/cop/backend/core/controllers/get/getSalespersonAnalyticMapRoutes.php"?>',
            data: {salespersonID:salespersonID, date: selectedDate},
            success: function(data) {
                console.log(data);
                var bounds = new google.maps.LatLngBounds();

                var counter = 0;

                for (var i = 0; i < markers.length; i++) {
                    markers[i].setMap(null);
                }

                $.each(data, function(index,value)
                {
                    counter = counter +1;

                    var marker = new google.maps.Marker({
                        position: new google.maps.LatLng(value.lat,value.lng),

                        map: copMap,
                        title: value.label+"\n"+value.time,
                        label: counter.toString(),
                        icon: {
                            path: google.maps.SymbolPath.CIRCLE,
                            scale: 13,
                            fillColor: value.color,
                            fillOpacity: 1,
                            strokeWeight: 1
                        },
                    });

                    marker.prevColor = value.color;
                    markers[index] = marker;
                    latlngs[index] = marker.position;

                    bounds.extend(markers[index].position);

                });
                copMap.fitBounds(bounds);

                if(showLines) {
                    flightPath = new google.maps.Polyline({
                        path: latlngs,
                        geodesic: true,
                        strokeColor: '#FF0000',
                        strokeOpacity: 1.0,
                        strokeWeight: 2
                    });
                    flightPath.setMap(copMap);
                }
            }
        });
    }

    function toggleLines()
    {
        if(showLines)
        {
            showLines = false;
            if(flightPath != null) {
                flightPath.setMap(null);
            }
        }
        else
        {
            showLines = true;

            flightPath = new google.maps.Polyline({
                path: latlngs,
                geodesic: true,
                strokeColor: '#FF0000',
                strokeOpacity: 1.0,
                strokeWeight: 2
            });
            flightPath.setMap(copMap);
        }
    }

    function toggleCustomers()
    {
        var salespersonID = $('#salespersonSelect').val();

        if(showCustomers)
        {
            showCustomers = false;

            for(i=0; i<customerMarkers.length; i++){
                customerMarkers[i].setMap(null);
            }
        }
        else
        {
            showCustomers = true;

            $.ajax({
                type:"POST",
                dataType: "json",
                url: '<?php echo "//" . HTML_PATH . "/cop/backend/core/controllers/get/getCustomersPositionForAnalyticRouteMap.php"?>',
                data: {salespersonID: salespersonID},
                success: function(data) {

                    for (var i = 0; i < customerMarkers.length; i++) {
                        customerMarkers[i].setMap(null);
                    }

                    $.each(data, function(index,value)
                    {
                        var marker = new google.maps.Marker({
                            position: new google.maps.LatLng(value.lat,value.lng),
                            map: copMap,
                            title: value.label
                        });

                        marker.setIcon('http://maps.google.com/mapfiles/ms/icons/blue-dot.png');
                        marker.setTitle(value.label);
                        customerMarkers[index] = marker;

                    });
                }
            });

        }
    }

    function previousMarker()
    {
        try {

            if(currentMarkerPosition > 0) {

                currentMarkerPosition = currentMarkerPosition - 1;
                var currentMarker = markers[currentMarkerPosition];
                var prevMarker = markers[currentMarkerPosition-1];
                if (prevMarker != null) {
                    prevMarker.icon.scale = 16;
                    prevMarker.icon.strokeWeight = 5;
                    prevMarker.icon.strokeColor = '#505626';
                    prevMarker.setLabel((currentMarkerPosition).toString());
                }
                if (currentMarker != null) {
                    var markerColor = currentMarker.prevColor;
                    currentMarker.icon.path = google.maps.SymbolPath.CIRCLE;
                    currentMarker.icon.fillColor = markerColor;
                    currentMarker.icon.scale = 13;
                    currentMarker.icon.strokeWeight = 2;
                    currentMarker.icon.strokeColor = '';

                    currentMarker.setLabel((currentMarkerPosition + 1).toString());
                    copMap.setZoom(18);
                    copMap.panTo(markers[currentMarkerPosition-1].position);
                    currentMarker.setZIndex(google.maps.Marker.MAX_ZINDEX - currentMarkerPosition);

                }
            } else {
                copMap.setZoom(10);
            }
        }
        catch (err){}

    }

    function nextMarker()
    {
        try {
            if(currentMarkerPosition < markers.length)
            {

                var currentMarker = markers[currentMarkerPosition];
                var prevMarker = markers[currentMarkerPosition-1];

                if (prevMarker != null) {
                    prevMarker.icon.scale = 13;
                    prevMarker.icon.strokeWeight = 1;
                    prevMarker.icon.strokeColor = '';
                    prevMarker.setLabel((currentMarkerPosition).toString());
                }
                if (currentMarker != null) {

                    currentMarker.icon.fillColor = '#8dc856';
                    currentMarker.icon.scale = 16;
                    currentMarker.icon.strokeWeight = 5;
                    currentMarker.icon.strokeColor = '#505626';

                    currentMarker.setLabel((currentMarkerPosition + 1).toString());
                    currentMarkerPosition = currentMarkerPosition + 1;
                    currentMarker.setZIndex(google.maps.Marker.MAX_ZINDEX + currentMarkerPosition);

                    copMap.setZoom(18);
                    copMap.panTo(currentMarker.position);
                }
            }
        }
        catch (err){}
    }

    $(document).ready(function() {

        pageSetUp();

        initMap();

        updateMarkers();

        $( "#salespersonSelect" ).change(function() {
            updateMarkers();
        });

        $( "#dateselect_filter" ).change(function() {
            updateMarkers();
        });



    })

</script>

