<?php
include_once("../../../../param.php");
?>

		<div id="main" role="main">
			<!-- Start CUSTOM CODE-->

			<!-- RIBBON -->
			<div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment"> 
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span> 
				</span>
				<!-- breadcrumb -->
				<ol class="breadcrumb">
					<li class="txt-color-white">Home / SC Status</li>
				</ol>
				<!-- end breadcrumb -->
			</div>
			<!-- END RIBBON -->

			<!-- MAIN CONTENT -->
			<div id="content">

				<div class="row">
					<div class="col-xs-12 col-sm-8 col-md-9 col-lg-8">
                        <img class="custom-rounded-image monthly" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/settingsicon.png" width="30" height="30" style="display: inline-block;">&nbsp;

						<h3 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;display: inline-block;" >
							 SC Status
						</h3>
				</div>
					<div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">

					</div>
					<div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
		<span class="pull-right show-stat-buttons"> <span > <a onclick = "$('#scStatusModal').modal('show');" class="btn btn-primary btn-block"><i class="fa fa-plus"></i>&nbsp; New Status</a> </span>

					</div>
				</div>
				
				
				

			<!-- row -->
			<section id="widget-grid" class="">
				
					<!-- row -->
					<div class="row">
						<!-- NEW WIDGET START -->
						<article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
											
							<div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">																
								<header>
									<span class="widget-icon"> <i class="fa fa-table"></i> </span>
									<h2>SC Status Table </h2>
								</header>
								<!-- widget div-->
								<div>
									
									<!-- widget content -->
									<div class="widget-body no-padding">
										<table id="datatable_fixed_column" class="table table-striped table-hover dataTabl" width="100%">
					
									        <thead>
												<tr>
												     <th class="hasinput" >
														<input type="text" class="form-control text-center" placeholder="Filter Status Code" />
													</th>
													<th class="hasinput" >
														<input type="text" class="form-control text-center" placeholder="Filter Name" />
													</th>													
												
													<th class="hasinput" >
														<input type="text" class="form-control text-center" placeholder="Filter Position" />
													</th>
													<th class="hasinput" >
														<input type="text" class="form-control text-center" placeholder="Filter Visible" />
													</th>
													<th class="hasinput" >
														<input type="text" class="form-control text-center" placeholder="Filter Calendar Fixed" />
													</th>
													<th class="hasinput" >
														<input type="text" class="form-control text-center" placeholder="Status Color" />
													</th>
                                                    
												</tr>
									            <tr>
									            <th class='text-center'>Status Code</th>                
           									    <th class='text-center'>Status Name</th>
            									<th class='text-center'>Position</th>
                                                <th class='text-center'>Visible</th>
                                                <th class='text-center'>Calendar fixed</th>
                                                <th class='text-center'>Status Color</th>
            								
            									   
									            </tr>
									        </thead>
									        
									        <tbody></tbody>
										</table>
				
									</div>
									<!-- end widget content -->
				
								</div>
								<!-- end widget div -->
				
							</div>
							<!-- end widget -->
			</article>
			<!-- WIDGET END -->
		</div>
        <!-- end row -->
	</section>

	</div>
</div>
	
	

<!-- Modal (New Sc Status)-->
<div class="modal fade" id="scStatusModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" >
    <div class="modal-dialog" role="document" >
        <div class="modal-content">
            <div class="modal-header">
                <center>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="font-size: 30px;">
                            <span aria-hidden="true">&times;</span> 
                        </button>
                        <img class="custom-rounded-image monthly" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/settingsicon.png" width="30" height="30" style="display: inline-block;">&nbsp;
                        <h4 class="modal-title"  style="display: inline-block;"><strong >New SC Status<span id="statusModalHeader"></span></strong></h4>
                </center>
                
                
            </div>
                <div class="modal-body">
                    <input class="form-control text-center" type="hidden" id="statusID">
                    <table class="table table-bordered">
                        <tr>
                            <td>Status Code:</td>
                            <td><input class="form-control text-center" type="text" id="statusCode"></td>
                        </tr>
                        <tr>
                            <td>Status Name:</td>
                            <td><input class="form-control text-center" type="text" id="statusName"></td>
                        </tr>
                        <tr>
                            <td>Position:</td>
                            <td><input class="form-control text-center" type="number" id="statusPosition"></td>
                        </tr>
                        
                        <tr>
                            <td>Visible:</td>
                            <td>
                                <select class="form-control text-center" id="statusVisible">
                                    <option value="yes" selected>yes</option>
                                    <option value="no">no</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <td>Calendar Fixed:</td>
                            <td>
                                <select class="form-control text-center" id="statusCalendar">
                                    <option value="yes">yes</option>
                                    <option value="no" selected>no</option>
                                    <option value="hide" >hide</option>
                                </select>
                            </td>
                        </tr>
                         <tr>
                            <td>Status Color:</td>
                            <td >
                                <span id="statusSelectedColor">
                                    <label>No Color:<input type="checkbox" id="noColor" style="margin: 0 5px;vertical-align: middle;width:35px;height:20px;' " checked> </label>
                                    <input type="color" id="statusColor" class="form-control" style="margin-left:10px;vertical-align: middle;width:20%; display: inline">
                                </span>
                            </td>
                           
                        </tr>
                    </table>
    
                    <br>
                    <center>
                    <button type="button" id = "saveButton" class="btn btn-success" onclick="saveStatus()">Save Status</button>
                    </center>
                </div>

        </div>
    </div>
</div>



	 <script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
		<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
		<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
		<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
		<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
     <script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>
     
     
     
    
     
	<script type="text/javascript">
	
	
	function saveStatusField(id, elementName, newValue, suffix) {
	    
	   if(elementName==="code" && newValue === ""){
           $.smallBox({
                    title: "Warning!",
                    content: "The Status Code cannot be empty.",
                    color: '#b22222',
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
            closeEditFields(suffix);
	    return;
	   }

        if(elementName==="name" && newValue === ""){
            $.smallBox({
                title: "Warning!",
                content: "The Status Name cannot be empty.",
                color: '#b22222',
                timeout: 3000,
                icon: "fa fa-user swing animated"
            });
            closeEditFields(suffix);
            return;
        }
	    
        $.ajax({
            type: "POST",
            url: "//<?php echo HTML_PATH; ?>/cop/backend/core/controllers/edit/edit_sc_status.php",
            data: {
                'statusID': id,
                'fieldName': elementName,
                'fieldValue': newValue
            }
            ,
            success: function(result) {
                if (result.localeCompare('existingCode') == 0 ) {
                    $.smallBox({
                        title: "Warning!",
                        content: "Existing Status Code.",
                        color: '#b22222',
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                    
    
                } else {
                    $.smallBox({
                        title: "Success!",
                        content: "Field successfully updated.",
                        color: "#739E73",
                        timeout: 2000,
                        icon: "fa fa-check swing animated"
                    });
                    
                    $('#value' + suffix).html(newValue);
                    closeEditFields(suffix);
                    $('#datatable_fixed_column').DataTable().draw(null, false);
    
                }
            }
        });
    }
    function  closeEditFields(suffix){
        $('#input' + suffix).hide();
        $('#inputDiv' + suffix).hide();
        $('#value' + suffix).show();
        $('#pen' + suffix).show();
        $('#save' + suffix).hide(); 
           
    }
    


	function openEditField(id, elementName, element){

	    var suffix = '-' + elementName + '-' + id;
	    var value  = $('#value' + suffix).html();
	    
        var initialCheckboxChecked = $('#noColor' + suffix).is(':checked'); 
        var initialColorValue = $('#statusColor' + suffix).val(); 
        
        if (value === '&nbsp;' ) {
            value = '';
    }

	    $('#value' + suffix).hide();
	    $('#pen' + suffix).hide();
	    
	    $('#input' + suffix).val(value);
	    $('#input' + suffix).show();
	    $('#input' + suffix).focus();
	    
	    
	    $('#inputDiv' + suffix).show();
	    
	    $('#statusColor' + suffix).focus();
	    $('#noColor' + suffix).focus();

	    $('#save' + suffix).show(); 

        $('#save' + suffix).unbind().on('click', function() {
            var newValue = $('#input' + suffix).val().trim();  
    	        if(value.localeCompare(newValue)!=0 ){       
                    saveStatusField(id, elementName, newValue,suffix);
    	        }
    	        else {
    	            closeEditFields(suffix);
    	        }
         
        });
        
    
        $('#input' + suffix).focusout(function(){
            if (!$(event.relatedTarget).is($('#save' + suffix))) {
                 closeEditFields(suffix);
            }
        });
        
        
         $('#statusColor' + suffix).focusout(function(){
            if (!$(event.relatedTarget).is($('#save' + suffix)) && !$(event.relatedTarget).is($('#noColor' + suffix)) ) {
                $('#noColor' + suffix).prop('checked', initialCheckboxChecked); 
                $('#statusColor' + suffix).val(initialColorValue);
                closeEditFields(suffix); 
            }
        });
        
        $('#noColor' + suffix).focusout(function(){
            if (!$(event.relatedTarget).is($('#save' + suffix)) && !$(event.relatedTarget).is($('#statusColor' + suffix)) ) {
                $('#noColor' + suffix).prop('checked', initialCheckboxChecked); 
                $('#statusColor' + suffix).val(initialColorValue); 
                closeEditFields(suffix); 
            }
        });
	    
	}
	
	
	function saveStatus(){
	    	
        $('#saveButton').hide();
        $('#saveButton').prop("disabled",true);

		var statusCode = $('#statusCode').val().trim();
		var statusName = $('#statusName').val().trim();
		var statusPosition =  $('#statusPosition').val().trim();
		var statusVisible =  $('#statusVisible').val().trim();
		var statusCalendar =  $('#statusCalendar').val().trim();
		var selectedColor = $('#statusSelectedColor').val();

		
        if(!statusCode)
        {
            $.smallBox({
                title : "Status Code Missing!",
                content : "Please enter a Status Code.",
                color : "#b22222",
                timeout: 2000,
                icon : "fa fa-user swing animated"
            });
            
            highlightDataError($('#statusCode'));

            $('#saveButton').show();
            $('#saveButton').prop("disabled",false);

            return;
        }

        if(!statusName)
        {
            $.smallBox({
                title : "Status Name Missing!",
                content : "Please enter a Status Name.",
                color : "#b22222",
                timeout: 2000,
                icon : "fa fa-user swing animated"
            });
            
            highlightDataError($('#statusName'));

            $('#saveButton').show();
            $('#saveButton').prop("disabled",false);

            return;
        }


		$.ajax({
			type: "POST",

			<?php
                echo "url: '//" . HTML_PATH . "/cop/backend/core/controllers/add/add_sc_status.php',";
            
           ?>
           data: {
                'statusCode':statusCode,
                'statusName':statusName,
                'statusPosition':statusPosition,
                'statusVisible':statusVisible,
                'statusCalendar': statusCalendar,
                'statusColor':selectedColor
            },
			success: function (result) {
			    
                if(result.localeCompare('existingCode') == 0){
                    
                    $.smallBox({
                       title: "Warning!",
                       content: "Existing Status Code.",
                       color: '#b22222',
                       timeout: 3000,
                       icon: "fa fa-user swing animated"
                    });
                   
                    highlightDataError($('#statusCode'));
                   
                    $('#saveButton').show();
                    $('#saveButton').prop("disabled",false);
                   
                } else {
                    
    				$.smallBox({
    					title : "Success!",
    					content : "Status successfully entered.",
    					color : "#739E73",
    					timeout: 2000,
    					icon : "fa fa-user swing animated"
    				});
                    

                    window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/core/views/manage/manage_sc_statuses.php");
    				
                }
			}
		});
	}
	
	
		$(document).ready(function() {
			
			pageSetUp();		

            $("#chooseParentSelect").select2({
              placeholder: "No Parent Selected",
              allowClear: true
             
            });

			var responsiveHelper_datatable_fixed_column = undefined;

			var breakpointDefinition = {
				tablet : 1024,
				phone : 480
			};
			
			/* COLUMN FILTER  */
		    var otable = $('#datatable_fixed_column').DataTable({		    	
				"sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>"+
						"t"+
						"<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
				"autoWidth" : true,
				"processing": false,

        "serverSide": true,

        "ajax": {
            "type": "GET",
            "url": "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/getAll/getAllScStatuses.php",
            
        },
        "columns": [

            { "data": "code_with_edit" },
            { "data": "name_with_edit" },
            { "data": "position_with_edit" },
            { "data": "visible_with_edit" },
            { "data": "calendar_fixed_with_edit" },
            { "data": "status_color_with_edit" }
        ],
				"deferRender": true,
				"autoWidth" : true,
                 "buttons": ["copyHtml5",
                    "excelHtml5",
                    "csvHtml5",
                     {
                         extend: 'pdfHtml5',
                         orientation: 'landscape',
                         pageSize: 'LEGAL'
                     }
                ],
				"preDrawCallback" : function() {
					// Initialize the responsive datatables helper once.
					if (!responsiveHelper_datatable_fixed_column) {
						responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
					}
				},
				"rowCallback" : function(nRow) {
					responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
				},
				"drawCallback" : function(oSettings) {
					responsiveHelper_datatable_fixed_column.respond();
				}		
			
		    });
		    
  
		    // Apply the filter
		    $("#datatable_fixed_column thead th input[type=text]").on( 'keyup change', function () {
		    	
		        otable
		            .column( $(this).parent().index()+':visible' )
		            .search( this.value )
		            .draw();
		            
		    });
		    
		    initColorChange('noColor','statusColor','statusSelectedColor');
		
		})
		
    
    function highlightDataError(element){
        element.css('border-color','firebrick').css('background-color','#ffd0bd');
        window.setTimeout(function(){element.css('border-color','').css('background-color','');
        },2500);
    }
    
    function initColorChange(checkboxElementID,colorElementID,selectionElementID){
	    var noColorCheckbox = $('#' + checkboxElementID);
        var colorInput = $('#' + colorElementID);
        var colorSelected = $('#' + selectionElementID);
        
        
        if (noColorCheckbox.is(':checked')) {
                colorSelected.val(''); 
                colorInput.hide(); 
        }
        
          if (!noColorCheckbox.is(':checked')) {
                colorInput.show();    
                colorSelected.val(colorInput.val());
        }
    
     
         noColorCheckbox.unbind().on('change', function() {
            if (noColorCheckbox.is(':checked')) {
                colorSelected.val(''); 
                colorInput.hide();   
            } else {
                colorInput.show();    
                colorSelected.val(colorInput.val());
            }
        });
        
        //When a color is selected save it to the 'colorSelected' variable
        colorInput.unbind().on('change', function() { 
            if (!noColorCheckbox.is(':checked')) { 
                colorSelected.val(colorInput.val());
            }
        });
    }

		</script>



