<?php
include_once("../../../../param.php");

?>
<div id="main" role="main" class="background-color-whitish">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Payment Types</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->
    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-4 col-md-8 col-lg-8">
                <h3 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;">
                    <i class="fa fa-wrench "></i>
                    Payment Types
                </h3>
            </div>

            <div class="col-xs-12 col-sm-4 col-md-2 col-lg-2">
            </div>

            <div class="col-xs-12 col-sm-4 col-md-2 col-lg-2">
		<span class="pull-right show-stat-buttons"> <span > <a onclick="openNewModal()" class="btn btn-primary btn-block"><i class="fa fa-plus"></i>&nbsp; New Payment Type</a> </span>

            </div>

        </div>

        <!-- row -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1089" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Payment Types Table </h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%">
                                    <thead>
                                    <tr>

                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter Payment Type"  />
                                        </th>
                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter Payment Name"  />
                                        </th>

                                        <th class="hasinput" style="width:15%" >
                                        </th>

                                    </tr>
                                    <tr>
                                        <th class='text-center'>Payment Code</th>
                                        <th class='text-center'>Payment Name</th>
                                        <th class='text-center'></th>
                                    </tr>
                                    </thead>

                                </table>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->

                </article>
                <!-- WIDGET END -->

            </div>

            <!-- end row -->

        </section>
    </div>


</div>

<!-- Modal -->
<div class="modal fade" id="paymentTypeModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document" >
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="font-size: 30px;">
                    <span aria-hidden="true"  id="closeModalBtn">&times;</span>
                </button>
                <h4 class="modal-title" style="text-align: center" id="myModalLabel">New Payment type</h4>
            </div>
            <div class="modal-body">
                <input class="form-control text-center" type="hidden" id="paymentTypeID">
                <table class="table table-bordered">
                    <tr>
                        <td>Payment Type Code:</td>
                        <td><input class="form-control text-center" type="text" id="paymentTypeCode"></td>
                    </tr>
                    <tr>
                        <td>Name:</td>
                        <td><input class="form-control text-center" type="text" id="paymentTypeName"></td>
                    </tr>

                </table>

                <br>
                <center>
                    <button type="button" class="btn btn-success" id="saveButton" onclick="savePaymentType()">Save Payment type </button>
                </center>
            </div>

        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="imageModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document" >
        <div class="modal-content">
            <div class="modal-body">

                <img class="img-responsive img-rounded center-canvas" src="" id='modalImage'>


            </div>

        </div>
    </div>
</div>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>

<script type="text/javascript">

    function openEditModal(paymentTypeID, paymentTypeCode, paymentTypeName){
        $('#paymentTypeCode').val(paymentTypeCode);
        $('#paymentTypeName').val(paymentTypeName);
        $('#paymentTypeID').val(paymentTypeID);
        $('#paymentTypeModal .modal-title').html('<strong>Edit Payment Type</strong>');
        $('#saveButton').text('Update');
        $('#paymentTypeModal').modal('show');
    }

    function openNewModal(){
        clearModalFields();
        $('#paymentTypeModal .modal-title').html('<strong>New Payment Type</strong>');
        $('#saveButton').text('Save');
        $('#paymentTypeModal').modal('show');
    }

    function clearModalFields(){
        $('#paymentTypeCode').val('');
        $('#paymentTypeName').val('');
        $('#paymentTypeID').val('');

    }

    function savePaymentType(){
        paymentTypeCode = $('#paymentTypeCode').val();
        paymentTypeName = $('#paymentTypeName').val();
        paymentTypeID = $('#paymentTypeID').val();

        var emptyValues = false;
        if (!paymentTypeCode) {
            highlightDataError($('#paymentTypeCode'));
            emptyValues = true;
        }
        if (!paymentTypeName) {
            highlightDataError($('#paymentTypeName'));
            emptyValues = true;
        }

        if(emptyValues) {
            $.smallBox({
                title: "Warning!",
                content: "Please fill in the fields",
                color: "#b22222",
                timeout: 3000,
                icon: "fa fa-exclamation-triangle swing animated"
            });
            return;
        }

        if(paymentTypeID && paymentTypeID > 0){
            data = {name:paymentTypeName,code:paymentTypeCode,id:paymentTypeID};
            message = " updated";
        }
        else{
            data = {name:paymentTypeName,code:paymentTypeCode};
            message = " entered";
        }

        $.ajax({
            url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/edit/edit_payment_type.php",
            type: "POST",
            data: data,
            success: function(result){
                if(result.localeCompare('error') == 0){
                    $.smallBox({
                        title: "Warning!",
                        content: "Something went wrong.",
                        color: "#b22222",
                        timeout: 3000,
                        icon: "fa fa-exclamation-triangle swing animated"
                    });
                } else if (result.localeCompare('existingCode') == 0 ) {
                    $.smallBox({
                        title: "Warning!",
                        content: "Existing Code.",
                        color: '#b22222',
                        timeout: 3000,
                        icon: "fa fa-exclamation-triangle swing animated"
                    });
                    highlightDataError($('#paymentTypeCode'));

                }else {
                    $.smallBox({
                        title: "Success!",
                        content: "Payment Type successfully" + message + ".",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-check swing animated"
                    });
                    $('#paymentTypeModal').modal('hide');
                    clearModalFields();
                    $('#datatable_fixed_column').DataTable().draw(null, false);

                }
            }
        });
    }

    function highlightDataError(element){
        element.css('border-color','firebrick').css('background-color','#ffd0bd');
        window.setTimeout(function(){
            element.css('border-color','').css('background-color','');
        },3000);
    }


    $(document).ready(function() {

        pageSetUp();

        $('#closeModalBtn').on('click', function() {
            $('#paymentTypeModal').modal('hide');
        });

        var responsiveHelper_datatable_fixed_column = undefined;
        var breakpointDefinition = {
            tablet : 1024,
            phone : 480
        };

        /* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>"+
                "t"+
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "processing": false,
            "serverSide": true,
            "ajax": "//<?php echo HTML_PATH . "/cop/backend/core/controllers/getAll/getAllPaymentTypes.php";?>",
            "columns": [
                { "data": "code" },
                { "data": "name" },
                { "data": "form" }
            ],
            "deferRender": true,
            "autoWidth" : true,
            "buttons": [
                "copyHtml5",
                "excelHtml5",
                "csvHtml5",
                {
                    extend: 'pdfHtml5',
                    orientation: 'landscape',
                    pageSize: 'LEGAL'
                }
            ],
            "preDrawCallback" : function() {
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback" : function(nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback" : function(oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }
        });

        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on( 'keyup change', function () {
            otable
                .column( $(this).parent().index()+':visible' )
                .search( this.value )
                .draw();
        } );
        /* END COLUMN FILTER */

    })

</script>