<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include_once("../../../../param.php");
global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$companySelection = '';
$stm = $db->prepare("SELECT CONCAT(company_code, ' - ',company_name), company_id FROM Companies");
$stm-> execute();
$stm-> bind_result($customerName, $customerID);
while ($stm->fetch()) {
    $companySelection .= "<option value='$customerID'>$customerName</option>";
}

$stm-> close();

$salesPersonSelection = '';
$stm = $db->prepare("SELECT CONCAT(salesperson_code, ' - ',first_name, ' ',last_name), salesperson_id FROM SalesPersons");
$stm-> execute();
$stm-> bind_result($salesPersonName, $salesPersonID);
while ($stm->fetch()) {
    $salesPersonSelection .= "<option value='$salesPersonID'>$salesPersonName</option>";
}
$stm-> close();



?>


<div id="main" role="main">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">
        <span class="ribbon-button-alignment">
            <span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
                <i class="fa fa-refresh "></i>
            </span>
        </span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Manage Action Numberings</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->





    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-8">
                <h3 class="page-title txt-color-blueDark" style="margin-top: 5px; margin-bottom: 15px;">
                    <i class="fa fa-lg fa-fw fa-wrench"> </i>  &nbsp; Action Numberings
                </h3>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                <span class="pull-right show-stat-buttons"><span><a href="javascript:void(0);" class="btn btn-primary btn-block" onclick="openNewModal();"><i class="fa fa-plus"></i>&nbsp; New Action Numbering</a> </span> </span>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="">

            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Action Numberings Table </h2>
                        </header>
                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding">
                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTabl" width="100%">
                                    <thead>
                                    <tr>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Company" />
                                        </th>
                                        <th class="hasinput" >
                                            <input type="text" class="form-control text-center" placeholder="Filter SalesPerson" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Action" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Prefix" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Device Prefix" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Begin Num" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Title" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Details" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Notes" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Position" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Active" />
                                        </th>
                                        <th class="hasinput"  style="width:15%">
                                        </th>
                                    </tr>
                                    <tr>
                                        <th class="text-center">Company</th>
                                        <th class="text-center">SalesPerson</th>
                                        <th class="text-center">Action</th>
                                        <th class="text-center">Prefix</th>
                                        <th class="text-center">Preceding device prefix</th>
                                        <th class="text-center">Begin Number</th>
                                        <th class="text-center"> Title</th>
                                        <th class="text-center">Details</th>
                                        <th class="text-center">Notes</th>
                                        <th class="text-center">Position</th>
                                        <th class="text-center">Active</th>
                                        <th class="text-center">Actions</th>


                                    </tr>
                                    </thead>
                                </table>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- WIDGET END -->
            </div>
            <!-- end row -->
        </section>

    </div>
</div>

<!-- Modal (New Action Numbering) -->
<div class="modal fade" id="newActionNumbering" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <center>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="font-size: 30px;">
                        <span aria-hidden="true"  id="closeModalBtn">&times;</span>
                    </button>
                    <h4 class="modal-title" style="display: inline-block;"><strong>New Action Numbering</strong></h4>
                </center>
            </div>
            <div class="modal-body">
                <input type="hidden" id="editActionNumberingId">
                <table class="table table-bordered">
                    <tr>
                        <td>Company:</td>
                        <td>
                            <select  class="form-control text-center" id="companySelection">
                                <?php echo $companySelection; ?>
                            </select>
                    </tr>
                    <tr>
                        <td>SalesPerson:</td>
                        <td>
                            <select  class="form-control text-center" id="salesPersonSelection">
                                <?php echo $salesPersonSelection; ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>Action:</td>
                        <td>
                            <select class="form-control text-center" id="action" required>
                                <option value="Tenders">Tenders</option>
                                <option value="Orders">Orders</option>
                                <option value="Waybills">Waybills</option>
                                <option value="Invoices">Invoices</option>
                                <option value="Returns">Returns</option>
                                <option value="Receipts">Receipts</option>
                                <option value="Visits">Visits</option>
                            </select></td>
                    </tr>
                    <tr>
                        <td>Prefix:</td>
                        <td><input class="form-control text-center" type="text" id="prefix" required></td>
                    </tr>
                    <tr>
                        <td>Preceding Device Prefix:</td>
                        <td><input class="form-control text-center" type="text" id="devicePrefix"></td>
                    </tr>
                    <tr>
                        <td>Begin Num:</td>
                        <td><input class="form-control text-center" min="0" type="number" id="beginNum"></td>
                    </tr>
                    <tr>
                        <td>Title:</td>
                        <td><input class="form-control text-center" type="text" id="title"></td>
                    </tr>
                    <tr>
                        <td>Details:</td>
                        <td><input class="form-control text-center" type="text" id="details"></td>
                    </tr>
                    <tr>
                        <td>Notes:</td>
                        <td><input class="form-control text-center" type="text" id="notes"></td>
                    </tr>
                    <tr>
                        <td>Position:</td>
                        <td><input class="form-control text-center" type="number" id="position"></td>
                    </tr>
                    <tr>
                        <td>Active:</td>
                        <td>
                            <select class="form-control text-center" id="active">
                                <option value="yes" selected>yes</option>
                                <option value="no">no</option>
                            </select>
                        </td>
                    </tr>
                </table>

                <br>
                <center>
                    <button type="button" id="saveButton" style="width:100px" class="btn btn-success" onclick="saveActionNumbering()">Save</button>

                </center>
            </div>
        </div>
    </div>
</div>




<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>

<script type="text/javascript">

    function activateButtonClicked(id) {
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH . "/cop/backend/core/controllers/change/changeActionNumberingStatus.php" ?>',
            data: {
                'actionNumID': id,
                'active': "yes"
            },
            success: function(result) {
                $('#a' + id).text('Deactivate')
                    .removeClass('btn-success')
                    .addClass('btn-danger')
                    .unbind('click')
                    .click(function() {
                        deactivateButtonClicked(id);
                    });

                $('#datatable_fixed_column').DataTable().draw(null, false);

            }
        });
    }

    function deactivateButtonClicked(id) {
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH . "/cop/backend/core/controllers/change/changeActionNumberingStatus.php" ?>',
            data: {
                'actionNumID': id,
                'active': "no"
            },
            success: function(result) {
                $('#a' + id).text('Activate')
                    .removeClass('btn-danger')
                    .addClass('btn-success')
                    .unbind('click')
                    .click(function() {
                        activateButtonClicked(id);
                    });
                $('#datatable_fixed_column').DataTable().draw(null, false);
            }
        });
    }

    function clearModalFields(){
        $('#editActionNumberingId').val('');
        $('#companySelection').val('');
        $('#salesPersonSelection').val('');
        $('#action').val('');
        $('#prefix').val('');
        $('#devicePrefix').val('');
        $('#beginNum').val('');
        $('#title').val('');
        $('#details').val('');
        $('#notes').val('');
        $('#position').val('');
        $('#active').val('yes');
    }

    function openNewModal(){
        clearModalFields();
        $('#newActionNumbering .modal-title').html('<strong>New Action Numbering</strong>');
        $('#saveButton').text('Save');
        $('#newActionNumbering').modal('show');
    }

    function openEditModal(numberingID) {
        clearModalFields();
        $.ajax({
            url: '//<?php echo HTML_PATH . "/cop/backend/core/controllers/get/getActionNumbering.php" ?>',
            type: 'POST',
            data: { 'numberingID': numberingID },
            dataType: 'json',
            success: function(response) {
                if (response != null) {
                    $('#editActionNumberingId').val(numberingID);
                    $('#companySelection').val(response.company_id)
                    $('#salesPersonSelection').val(response.salesperson_id)
                    $('#action').val(response.action);
                    $('#prefix').val(response.prefix);
                    $('#devicePrefix').val(response.device_prefix);
                    $('#beginNum').val(response.begin_num);
                    $('#title').val(response.title);
                    $('#details').val(response.details);
                    $('#notes').val(response.notes);
                    $('#position').val(response.position);
                    $('#active').val(response.active);

                    $('#newActionNumbering .modal-title').html('<strong>Edit Action Numbering</strong>');
                    $('#saveButton').text('Update');
                    $('#newActionNumbering').modal('show');
                }
            },
        });
    }

    function highlightDataError(element){
        element.css('border-color','firebrick').css('background-color','#ffd0bd');
        window.setTimeout(function(){
            element.css('border-color','').css('background-color','');
        },3000);
    }



    function saveActionNumbering(){
        var numberingID = $('#editActionNumberingId').val();
        var company = $('#companySelection').val()
        var salesperson = $('#salesPersonSelection').val()
        var action = $('#action').val();
        var prefix = $('#prefix').val();
        var devicePrefix = $('#devicePrefix').val();
        var beginNum = $('#beginNum').val();
        var title = $('#title').val();
        var details = $('#details').val();
        var notes = $('#notes').val();
        var position = $('#position').val();
        var active = $('#active').val();

        var emptyValues = false;
        if (!company) {
            highlightDataError($('#companySelection'));
            emptyValues = true;
        }
        if (!action) {
            highlightDataError($('#action'));
            emptyValues = true;
        }
        if (!prefix) {
            highlightDataError($('#prefix'));
            emptyValues = true;
        }
        if (!devicePrefix) {
            highlightDataError($('#devicePrefix'));
            emptyValues = true;
        }
        if (!beginNum) {
            highlightDataError($('#beginNum'));
            emptyValues = true;
        }

        if(emptyValues) {
            $.smallBox({
                title: "Warning!",
                content: "Please fill in the fields",
                color: "#b22222",
                timeout: 3000,
                icon: "fa fa-exclamation-triangle swing animated"
            });
            return;
        }

        var url,message;
        if($('#editActionNumberingId').val() !== ''){
            url = '//<?php echo HTML_PATH?>/cop/backend/core/controllers/edit/edit_action_numbering.php';
            message = " updated";
        }
        else{
            url = '//<?php echo HTML_PATH?>/cop/backend/core/controllers/add/add_action_numbering.php';
            message = " entered";

        }


        $.ajax({
            type: "POST",
            url: url,
            data: {
                'numberingID': numberingID,
                'company': company,
                'salesperson': salesperson,
                'action': action,
                'prefix': prefix,
                'devicePrefix': devicePrefix,
                'beginNum': beginNum,
                'title': title,
                'details': details,
                'notes': notes,
                'position': position,
                'active': active,
            },
            success: function(result) {
                if(result === "success"){
                    $.smallBox({
                        title: "Success!",
                        content: "Action Numbering successfully" + message + ".",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-check swing animated"
                    });
                    $('#newActionNumbering').modal('hide');
                }
                else{
                    $.smallBox({
                        title: "Warning!",
                        content: "Something Went Wrong.",
                        color: "#b22222",
                        timeout: 3000,
                        icon: "fa fa-exclamation-triangle swing animated"
                    });
                }
                $('#saveButton').prop('disabled', false);
                $('#datatable_fixed_column').DataTable().draw(null, false);


            },
            error: function() {
                $('#saveButton').prop('disabled', false);


            }


        });



    }



    $(document).ready(function() {

        pageSetUp();
        $('#companySelection').select2({
            minimumInputLength: 2
        });

        $('#salesPersonSelection').select2({
            minimumInputLength: 2
        });

        $('#closeModalBtn').on('click', function() {
            $('#newActionNumbering').modal('hide');
        });

        var responsiveHelper_datatable_fixed_column = undefined;

        var breakpointDefinition = {
            tablet: 1024,
            phone: 480
        };

        /* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "autoWidth": true,
            "processing": false,
            "serverSide": true,
            "ajax": {
                "type": "GET",
                "url": "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/getAll/getAllActionNumberings.php",
            },
            "columns": [
                { "data": "company" },
                { "data": "salesperson" },
                { "data": "action" },
                { "data": "prefix" },
                { "data": "device_prefix" },
                { "data": "begin_number" },
                { "data": "title" },
                { "data": "details" },
                { "data": "notes" },
                { "data": "position" },
                { "data": "active" },
                { "data": "form" }
            ],
            "deferRender": true,
            "autoWidth": true,
            "buttons": [
                "copyHtml5",
                "excelHtml5",
                "csvHtml5",
                {
                    extend: 'pdfHtml5',
                    orientation: 'landscape',
                    pageSize: 'LEGAL'
                }
            ],
            "preDrawCallback": function() {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback": function(nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback": function(oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }
        });

        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on('keyup change', function() {
            otable
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        });
    });
</script>
