<!--Andreas Spanos @ 19/07/2019 Added Location Mark on customers table and Button for setting location (Modal)-->

<?php

require_once("../../../../param.php");
if(isset($_POST['schedule_id']))
{

    $scheduleID=$_POST['schedule_id'];
    $_SESSION['schedule_id'] = $scheduleID;
}
else
{
    $scheduleID=$_SESSION['schedule_id'];
}
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT name,creation_date,type,date,repeat_period,day,week,month,notes FROM Schedules WHERE schedule_id='$scheduleID'");
$stm-> execute();
$stm-> bind_result($name,$creationDate,$type,$date,$repeatPeriod,$day,$week,$month,$notes);
while ($stm->fetch()) {

    $myDateTime = DateTime::createFromFormat('Y-m-d', $date);
    $newDateString = $myDateTime->format('d/m/Y');


}
$stm-> close();

$routeOptimization = false;
$stm = $db->prepare("SELECT enable_route_optimization FROM Cloud_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($enableRouteOptimization);
while ($stm->fetch()) {
    if(strcmp($enableRouteOptimization,'yes')==0 || strcmp($enableRouteOptimization,'schedules')==0){
        $routeOptimization = true;
    }
}
$stm-> close();



if(isset($_GET['file'])){
    $importFileName = trim($_GET['file']);
    $inputDirectory = ROOT.'interface/import/error/';
    $htmlDirectory = "//".HTML_PATH."/cop/interface/import/error/";
    if(isset($_GET['replace']) && strcmp($_GET['replace'],'1')==0){

        $replace = true;
    } else {
        $replace = false;
    }
    if(file_exists($inputDirectory.$importFileName)){
        $hasImportFile = true;
    } else {
        $hasImportFile = false;
    }

}


function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}
?>
<div style="display:none;">
    <form id="exportScheduleForm" action="//<?php echo HTML_PATH ?>/cop/backend/core/controllers/export/exportScheduleExcel.php" method="POST">
        <input type="hidden" name="scheduleID" value="<?php echo "$scheduleID" ?>">
    </form>

</div>
<div id="main" role="main">

    <!-- Start CUSTOM CODE-->
    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / View Schedule</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-2">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa fa-calendar"></i>
                    View Schedule
                </h3>
            </div>
<!--            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">-->
<!--		<span class="pull-right show-stat-buttons"> <span >-->
<!--                <form method="GET" action="//--><?php //echo HTML_PATH ?><!--/cop/backend/core/views/maps/schedule_on_map.php" target="_blank">-->
<!--                    <input type="hidden" name="scheduleID" id="scheduleID  " value="--><?php //echo $scheduleID ?><!--">-->
<!--                    <button type="submit"  class="btn btn-invoice btn-block" id="exportScheduleButton">-->
<!--                        <i class="fa fa-map-marker"></i>&nbsp; View Schedule on Map-->
<!--                    </button>-->
<!--                </form>-->
<!--            </span>-->
<!--            </div>-->

            <div class='col-xs-12 col-sm-12 col-md-12 col-lg-2'>
                        <?php
                        if($routeOptimization){
                            echo "
                            <span class='btn btn-group btn-block show-stat-buttons' style='padding: 0px;'>
                                <button class='btn btn-invoice btn-block dropdown-toggle' data-toggle='dropdown' >
                                    <i class='fa fa-map-marker'></i>&nbsp; Map Options <span class='pull-right'> <span class='caret'></span></span>
                                </button>
    
                                <ul class='dropdown-menu' style='width: 100%;margin-bottom: 3px;'>
                                    <li style=\"margin-bottom: 3px;\">
                                         <form method=\"GET\" action=\"//".HTML_PATH."/cop/backend/core/views/view/view_schedule_route.php\" target=\"_blank\">
                                            <input type=\"hidden\" name=\"scheduleID\" id=\"scheduleIDToOptimize\" value=\"$scheduleID\">
                                            <input type=\"hidden\" name=\"date\" id=\"dateToOptimize\" value=\"$newDateString\">
                                            <button type=\"submit\"  class=\"btn btn-invoice btn-block\" id=\"optimizeRouteButton\">
                                                <i class=\"fa fa-map-marker\"></i>&nbsp; View On Map
                                            </button>
                                         </form>
                                    </li>
                                    <li >
                                        <button class=\"btn btn-invoice btn-block\"  onclick=\"$('#modalOptimizeRouteFromMap').modal('show');\">
                                            <i class=\"fa fa-map-marker\"></i>&nbsp; Optimize Route
                                        </button>
                                    </li>
                                </ul>
                            </span>
                            ";
                        }else{
                            echo "
                                <span class=\"pull-right show-stat-buttons\"> <span >
                                    <form method=\"GET\" action=\"//".HTML_PATH."/cop/backend/core/views/maps/schedule_on_map.php\" target=\"_blank\">
                                    <input type=\"hidden\" name=\"scheduleID\" id=\"scheduleID\" value='$scheduleID'>
                                    <button type=\"submit\"  class=\"btn btn-invoice btn-block\" id=\"exportScheduleButton\">
                                        <i class=\"fa fa-map-marker\"></i>&nbsp; View Schedule on Map
                                    </button>
                                    </form>
                                </span>       
                            ";
                        }
                        ?>

            </div>


<!--            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-1">-->
<!--                <span class="pull-right show-stat-buttons"> <span >-->
<!--                        <form method="GET" action="//--><?php //echo HTML_PATH ?><!--/cop/backend/core/views/addedit/optimize_schedule_route.php" target="_blank">-->
<!--                            <input type="hidden" name="scheduleID" id="scheduleIDToOptimize" value="--><?php //echo $scheduleID ?><!--">-->
<!--                            <input type="hidden" name="date" id="dateToOptimize" value="--><?php //echo $newDateString ?><!--">-->
<!--                            <button type="submit"  class="btn btn-invoice btn-block" id="optimizeRouteButton">-->
<!--                                <i class="fa fa-map-marker"></i>&nbsp; Optimize Route-->
<!--                            </button>-->
<!--                        </form>-->
<!--                </span>-->
<!--            </div>-->
<!--            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-1">-->
<!--                <span class="pull-right show-stat-buttons"> <span >-->
<!--                        <form method="GET" action="//--><?php //echo HTML_PATH ?><!--/cop/backend/core/views/view/view_schedule_route.php" target="_blank">-->
<!--                            <input type="hidden" name="scheduleID" id="scheduleIDToOptimize" value="--><?php //echo $scheduleID ?><!--">-->
<!--                            <input type="hidden" name="date" id="dateToOptimize" value="--><?php //echo $newDateString ?><!--">-->
<!--                            <button type="submit"  class="btn btn-invoice btn-block" id="optimizeRouteButton">-->
<!--                                <i class="fa fa-map-marker"></i>&nbsp; View Route-->
<!--                            </button>-->
<!--                        </form>-->
<!--                </span>-->
<!--            </div>-->

            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
		<span class="pull-right show-stat-buttons"> <span > <a target="_blank" class="btn btn-primary btn-block" onclick="exportSchedule()" id="exportScheduleButton"><i class="fa fa-cloud-download "></i>&nbsp; Export Schedule</a> </span>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
		<span class="pull-right show-stat-buttons"> <span > <a target="_blank" class="btn btn-primary btn-block" onclick="importSchedule()" id="importScheduleButton"><i class="fa fa-cloud-upload "></i>&nbsp; Import Schedule</a> </span>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
		<span class="pull-right show-stat-buttons"> <span > <a target="_blank" class="btn btn-danger btn-block" onclick="$('#deleteScheduleModal').modal('show')"><i class="fa fa-minus-circle"></i>&nbsp; Delete Schedule</a> </span>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
		<span class="pull-right show-stat-buttons"> <span > <a target="_blank" class="btn btn-success btn-block" id="saveScheduleButton"><i class="fa fa-check"></i>&nbsp; Save Changes</a> </span>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="mapModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
            <div class="modal-dialog" role="document" >
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 style="color:black;" class="modal-title" id="myModalLabel">Select Location</h4>
                    </div>
                    <div class="modal-body">

                        <pre class="invRowsClass"><div class="google_maps" style='height:300px; width:100%;   border-radius: 25px;' id="map_coprime" ></div></pre>
                        <label>Latitude</label>
                        <input class="form-control" type="text" id="lat" name="lat" value="">
                        <label>Longitude</label>
                        <input class="form-control" type="text" id="lng" name="lng" value="">
                        <input type="hidden" id="customerAddressID" value="">


                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-primary" id="addLocation" name="addLocation">Submit</button>
                    </div>
                </div>
            </div>
        </div>
        <!-- row -->
        <section id="widget-grid" class="">

            <div class="row" >

                <!-- NEW WIDGET START -->
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark no-margin" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>View Schedule Form</h2>

                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <form action="//<?php echo HTML_PATH ?>/cop/backend/core/controllers/edit/edit_schedule.php" id="scheduleForm" class="smart-form" method="post">
                                    <input id='scheduleID' name='scheduleID' type='hidden' value='<?php echo $scheduleID ?>'>
                                    <fieldset style="padding-top:10px;">
                                        <div class="row">
                                            <section class="col col-4 no-margin" style="padding-right:2px" >
                                                <section>
                                                    <i class="fa fa-calendar"></i>
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Basic Details</h3>
                                                </section>
                                                <table id="basicDetailsTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
                                                    <thead >
                                                    </thead>
                                                    <tbody >
                                                    <tr >
                                                        <td class="custom-td-label-medium"><label class="label-bold  align-left">Schedule Name: </label></td>
                                                        <td class="custom-td-input-medium"><input  class='text-center form-control slim-input' id='scheduleName' name='scheduleName' type='text' value='<?php echo $name?>'></td>
                                                    </tr>
                                                    <tr >
                                                        <td class="custom-td-label-medium"><label class="label-bold  align-left">Start Date: </label></td>
                                                        <td class="custom-td-input-medium">
                                                            <label class="input"> <i class="icon-append fa fa-calendar"></i>
                                                                <input type="text" name="startDate" id="startdate" placeholder="Expected start date" value='<?php echo $newDateString ?>'>
                                                            </label>

                                                        </td>
                                                    </tr>
                                                    <tr>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                                <section style="margin-right:8px;">
                                                    <label class="label-bold  align-left" >Notes: </label>
                                                    <textarea  class='form-control custom-textarea' rows='4' id='notes' name='notes'><?php echo $notes?></textarea>
                                                </section>

                                            </section>
                                            <section class="col col-4 no-margin" style="border-left:1px dotted #ADD8E6;border-right:1px dotted #ADD8E6;padding-right:2px;">
                                                <section>
                                                    <img style="width:30px;height:30px;display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/scheduleicon.png" width="25" height="25">
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Type Details</h3>
                                                </section>

                                                <table id="detailsTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
                                                    <thead >
                                                    </thead>
                                                    <tbody>
                                                    <tr >
                                                        <td class="custom-td-label-medium"><label class="label-bold align-left" >Schedule Type: </label></td>
                                                        <td class="custom-td-input-medium">
                                                            <label class="select">
                                                                <select id="scheduleTypeSelect" class='form-control slim-input' name='type' type='text' value=''>


                                                                    <option value="Single Date">Single Date</option>
                                                                    <option value="Repeat">Repeat</option>
                                                                    <option value="Custom">Custom</option>

                                                                </select>
                                                                <i></i>
                                                            </label></td>
                                                    </tr>
                                                    <tr id="repeatPeriodTr">
                                                        <td class="custom-td-label-medium"><label class="label-bold align-left" >Repeat Period: </label></td>
                                                        <td class="custom-td-input-medium">     <label class="select">
                                                                <select id="repeatPeriod" class='form-control slim-input' name='repeatPeriod' type='text' value=''>
                                                                    <option value="1">Daily</option>
                                                                    <option value="7">Weekly</option>
                                                                    <option value="14">Two Weeks</option>
                                                                    <option value="21">Three Weeks</option>
                                                                    <option value="28">Four Weeks</option>
                                                                </select>
                                                                <i></i>
                                                            </label></td>
                                                    </tr>
                                                    <tr id="dayTr">
                                                        <td class="custom-td-label-medium"><label class="label-bold align-left" >Select Day: </label></td>
                                                        <td class="custom-td-input-medium">     <label class="select">
                                                                <select id="daySelect" class='form-control slim-input' name='day' type='text' value=''>
                                                                    <option value="1">Monday</option>
                                                                    <option value="2">Tuesday</option>
                                                                    <option value="3">Wednesday</option>
                                                                    <option value="4">Thursday</option>
                                                                    <option value="5">Friday</option>
                                                                    <option value="6">Saturday</option>
                                                                    <option value="7">Sunday</option>
                                                                </select>
                                                                <i></i>
                                                            </label></td>
                                                    </tr>
                                                    <tr id="weekTr">
                                                        <td class="custom-td-label-medium"><label class="label-bold align-left" >Select Week: </label></td>
                                                        <td class="custom-td-input-medium">     <label class="select">
                                                                <select id="weekSelect" class='form-control slim-input' name='week' type='text' value=''>
                                                                    <option value="0">ALL</option>
                                                                    <option value="1">1st of Month</option>
                                                                    <option value="2">2nd of Month</option>
                                                                    <option value="3">3rd of Month</option>
                                                                    <option value="4">4th of Month</option>
                                                                </select>
                                                                <i></i>
                                                            </label>
                                                        </td>
                                                    </tr>
                                                    <tr id="monthTr">
                                                        <td class="custom-td-label-medium"><label class="label-bold align-left" >Select Month: </label></td>
                                                        <td class="custom-td-input-medium">     <label class="select">
                                                                <select id="monthSelect" class='form-control slim-input' name='month' type='text' value=''>
                                                                    <option value="0">All</option>
                                                                    <option value="1">January</option>
                                                                    <option value="2">February</option>
                                                                    <option value="3">March</option>
                                                                    <option value="4">April</option>
                                                                    <option value="5">May</option>
                                                                    <option value="6">June</option>
                                                                    <option value="7">July</option>
                                                                    <option value="8">August</option>
                                                                    <option value="9">September</option>
                                                                    <option value="10">October</option>
                                                                    <option value="11">November</option>
                                                                    <option value="12">December</option>
                                                                </select>
                                                                <i></i>
                                                            </label></td>
                                                    </tr>

                                                    </tbody>
                                                </table>
                                            </section>
                                            <section class="col col-4 no-margin" style="padding-right:2px;">
                                                <section>
                                                    <img style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/infoicon.png" width="30" height="30">
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Salesperson Details</h3>
                                                </section>
                                                <section style="margin-right:8px;">
                                                    <table id="detailsTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
                                                        <thead >
                                                        </thead>
                                                        <tbody>
                                                        <select multiple="multiple" style="width:100%;" name="salespersonsIDs[]" id="salespersonSelect" class="js-example-basic-single">
                                                            <?php




                                                            $db = new mysqli(localhost,$username,$password,$database);
                                                            if (mysqli_connect_errno()) {
                                                                printf("Connect failed: %s\n", mysqli_connect_error());
                                                                exit();
                                                            }
                                                            $db->set_charset("utf8");
                                                            // WHERE compani code in  Session
                                                            $stm = $db->prepare("SELECT salesperson_id,salesperson_code,first_name,last_name,status FROM SalesPersons WHERE salesperson_id IN (SELECT salesperson_id AS salesperson_id FROM Schedule_Salesperson WHERE schedule_id='$scheduleID')");
                                                            $stm-> execute();
                                                            $stm-> bind_result($salespersonID,$code,$first_name,$last_name,$status);
                                                            while ($stm->fetch()) {
                                                                echo "<option value='$salespersonID' selected>$code $first_name $last_name</option>";
                                                            }
                                                            $stm-> close();

                                                            $stm2 = $db->prepare("SELECT salesperson_id,salesperson_code,first_name,last_name FROM SalesPersons WHERE NOT status='disabled' AND salesperson_id NOT IN (SELECT salesperson_id AS salesperson_id FROM Schedule_Salesperson WHERE schedule_id='$scheduleID')");
                                                            $stm2-> execute();
                                                            $stm2-> bind_result($salespersonID,$code,$first_name,$last_name);
                                                            while ($stm2->fetch()) {
                                                                echo "<option value='$salespersonID' >$code $first_name $last_name</option>";
                                                            }
                                                            $stm2-> close();
                                                            ?>
                                                        </select>

                                                        </tbody>
                                                    </table>
                                                </section>

                                            </section>
                                        </div>
                                    </fieldset>


                                    <table id="datatable_fixed_column" class="table table-hover" width="100%" border="0" cellpadding="0" cellspacing="0">
                                        <thead>
                                        <tr>
                                            <th class='text-center'></th>
                                            <th class='text-center'>#</th>
                                            <th class='text-center'>Customer Code</th>
                                            <th class='text-center'>Customer Name</th>
                                            <th class='text-center'>Address</th>
                                            <th class='text-center'>Appointment Time</th>
                                            <th class='text-center'>Location</th>
                                        </tr>
                                        </thead>

                                        <tbody>
                                        <?php

                                        $db = new mysqli(localhost,$username,$password,$database);
                                        if (mysqli_connect_errno()) {
                                            printf("Connect failed: %s\n", mysqli_connect_error());
                                            exit();
                                        }
                                        $db->set_charset("utf8");

                                        $db2 = new mysqli(localhost,$username,$password,$database);
                                        if (mysqli_connect_errno()) {
                                            printf("Connect failed: %s\n", mysqli_connect_error());
                                            exit();
                                        }
                                        $db2->set_charset("utf8");

                                        $i = 0;
                                        $hasCustomers = false;


                                        $stm = $db->prepare("SELECT Customers.customer_id,customer_code,customer_company_name,position,type_of_business,appointment_time FROM Customers,Schedule_Customer WHERE Customers.customer_id =Schedule_Customer.customer_id AND schedule_id='$scheduleID' ORDER BY position");
                                        //	$stm = $db->prepare("SELECT customer_id,customer_code,customer_company_name,position FROM Customers WHERE customer_id IN (SELECT customer_id AS customer_id FROM Schedule_Customer WHERE schedule_id='$scheduleID')");
                                        $stm-> execute();
                                        $stm-> bind_result($customerID,$code,$name,$position,$typeOfBussiness,$appointmentTime);
                                        while ($stm->fetch()) {

                                            $hasCustomers = true;
                                            $style = "";
                                            $address = "";
                                            $i++;

                                            if(strcmp(strtolower($typeOfBussiness),'inactive')==0){
                                                $style = "style='background-color: firebrick'";
                                            }

                                            $stm5 = $db2->prepare("SELECT customer_address_id,address_code,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,landline,fax,primary_address,timestamp FROM CustomerAddress WHERE customer_id ='$customerID' ORDER BY primary_address,timestamp DESC LIMIT 1");
                                            $stm5-> execute();
                                            $stm5-> bind_result($customerAddressID,$addressCode,$country,$city,$addressLine1,$addressLine2,$postcode,$region,$lat,$lng,$pobox,$landline,$fax,$primaryAddress,$timestamp);
                                            while ($stm5->fetch()) {

                                                $address  .= $addressLine1;
                                                if(strcmp(trim("$address"),"")!=0 && strcmp(trim("$addressLine2"),"")!=0){$address .= ', ';}
                                                $address .= $addressLine2;
                                                if(strcmp(trim("$address"),"")!=0 && strcmp(trim("$city $postcode"),"")!=0){$address .= ', ';}
                                                $address .= trim("$city $postcode");
                                                if(strcmp(trim("$address"),"")!=0 && strcmp(trim("$region"),"")!=0){$address .= ', ';}
                                                $address .= $region;
                                                if(strcmp(trim("$address"),"")!=0 && strcmp(trim("$country"),"")!=0){$address .= ', ';}
                                                $address .= $country;
                                                if(strcmp(trim("$address"),"")!=0 && strcmp(trim("$pobox"),"")!=0){$address .= ', ';}
                                                $address .= $pobox;

                                                if($lng == 0 || $lat== 0){
                                                    $marker = "<a  data-toggle='modal' data-target='#mapModal' id='$customerAddressID'><button type='button'  onclick='initModalMap(35.15,33.35,$customerAddressID)' style='width: 50px;height: 25px' class='btn btn-primary'>Add</button></a>";
                                                } else {
                                                    $marker = "<a  data-toggle='modal' data-target='#mapModal' id='$customerAddressID' onclick='initModalMap($lat,$lng,$customerAddressID)'><i class='fa fa-map-marker'></i></a>";
                                                }

                                            }
                                            $stm5-> close();


                                            echo "<tr $style>";

                                            echo "<td  >
                                                    <img class='deletRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:20px;height:20px;'/>
												  </td>";

                                            echo "<td class='index text-center' style='width:5%'>
                                                    <strong>$i</strong>
												  </td>";

                                            echo "<td>
	                                                <input id='customerID' name='customerIDs[]' type='hidden' value='$customerID'>
                                                    <input style='width:100%' class='customerCode text-center form-control' id='customerCode' name='customerCode' type='text' value='$code'>
                                                  </td>";

                                            echo "<td style='width:25%' class='text-center'  >
                                                    <input style='width:100%;' class='text-center form-control' id='customerName' name='customerName' type='text' value='$name' />
                                                  </td>";


                                            echo "<td style='width:25%' class='text-center'  >
                                                    <input style='width:100%;' class='text-center form-control custom-textarea'  id='customerAddress' name='customerAddress' type='text' value='$address'>
                                                  </td>";

                                            echo "<td style='width:15%' class='text-center'  >
                                                    <input style='width:100%;' class='text-center form-control custom-textarea'  id='appointmentTime' name='appointmentTimes[]' type='text' maxlength='20' value='$appointmentTime'>
                                                  </td>";


                                            echo "<td style='width:3%' class='text-center'  >
                                                    <input  id='lat' name='lat' type='hidden' value='$lat'>
                                                    <input  id='lng' name='lng' type='hidden' value='$lng'>
                                                    $marker
                                                  </td>";

                                            echo "</tr>";


                                        }
                                        $stm-> close();

                                        if(!$hasCustomers){
                                            echo "<tr $style>";

                                            echo "<td  >
                                                    <img class='deletRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:20px;height:20px;'/>
												  </td>";

                                            echo "<td class='index text-center' style='width:5%'>
                                                     <strong>1</strong>
												  </td>";

                                            echo "<td>
	                                                <input id='customerID' name='customerIDs[]' type='hidden' value=''>
                                                    <input style='width:100%' class='customerCode text-center form-control' id='customerCode' name='customerCode' type='text' value=''>
                                                  </td>";

                                            echo "<td style='width:25%' class='text-center'  >
                                                    <input style='width:100%;' class='text-center form-control' id='customerName' name='customerName' type='text' value='' />
                                                  </td>";

                                            echo "<td style='width:25%' class='text-center'  >
                                                    <input style='width:100%;' class='text-center form-control custom-textarea'  id='customerAddress' name='customerAddress' type='text' value=''>
                                                  </td>";

                                            echo "<td style='width:15%' class='text-center'  >
                                                    <input style='width:100%;' class='text-center form-control custom-textarea'  id='appointmentTime' name='appointmentTimes[]' maxlength='20' type='text' value=''>
                                                  </td>";

                                            echo "<td style='width:3%' class='text-center'  >
                                                    <input  id='lat' name='lat' type='hidden' value='0'>
                                                    <input  id='lng' name='lng' type='hidden' value='0'>
                                                    <i class='fa fa-map-marker'></i>
                                                  </td>";

                                            echo "</tr>";
                                        }

                                        ?>
                                        </tbody>

                                    </table>
                                </form>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>


            </div>

            <!-- end row -->

            <div class="row" style="margin-top:10px;" >
                <div class="col-sm-9">

                    <a style="width: 180px " target="_blank" id="newLineButton" class="btn btn-primary btn-block">
                        <i class="fa fa-plus  ">
                        </i>&nbsp; Add Customer</a>
                </div>
            </div>



        </section>
    </div>
</div>


<!-- Modal -->
<div class="modal fade" id="uploadModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" style="margin-left:10px;"><i class="fa fa-cloud-upload "></i>&nbsp;<strong style="padding-left:5px;">&nbsp Import Schedule</strong></h4>
            </div>

            <div class="modal-body" style="margin-top:5px;padding-top:5px;">
                <center>
                    <form method="POST" action="//<?php echo HTML_PATH; ?>/cop/backend/core/controllers/upload/uploadXlsSchedule.php" enctype="multipart/form-data">

                        <table style="width: 100%" >
                            <tr>
                                <td>
                                    <input type="file" id="excelFile" name="excelFile" class="btn btn-success" style="display: inline-block;margin-right: 0px;height: 35px;" required>
                                </td>
                                <td style="vertical-align: center;border: 5px solid transparent;bo">
                                    <div style="height: 40px;">
                                        <input type="checkbox" id="uppendFile" name="uppendFile" class="form-control" value='yes' style="display: inline-block;margin: 5px;height: 25px;width: 25px;">
                                        <label style="display: inline-block;width: 75px;">Replace Schedule</label>
                                    </div>
                                </td>
                                <td>
                                    <input type="submit" class="btn btn-waybill" value="Upload File" style="display: inline-block;margin-left: 0px;height: 35px;">
                                </td>
                            </tr>
                        </table>
                    </form>
            </div>

            <footer class="modal-footer" >
                <button onclick="$('#uploadModal').modal('toggle');" class="btn btn-default" type="button" style="margin-right:10px;">Cancel</button>
            </footer>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<!-- Modal -->
<div class="modal fade" id="deleteScheduleModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" style="margin-left:3px;"><strong style="padding-left:5px;color: firebrick"><i class="fa fa-minus-circle"></i>&nbsp; Delete Schedule</strong></h4>
            </div>

            <div class="modal-body" style="margin-top:5px;padding-top:5px;">
                <h3>
                    You are about to <b>Delete Schedule</b>.<br>
                    Are you sure?
                </h3>
            </div>

            <footer class="modal-footer" >
                <button type="button" class="btn btn-danger pull-left" id="deleteScheduleButton">Yes, Delete</button>
                <button onclick="$('#deleteScheduleModal').modal('hide');" class="btn btn-default" type="button" style="margin-right:10px;">No, Close</button>
            </footer>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div id="modalOptimizeRouteFromMap" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><b><h2 class="modal-title" id="titleModal" style="font-weight: bold">Optimize Route Options</h2></b></center>
            </div>
            <div class="modal-body">
                <div id="container" class="ui-front modal-body">
                    <table class="table">
                        <tr>
                            <td>Starting Location:</td>
                            <td><input class="form-control text-center" id='warehouseSearch' name='warehouseSearch'  type='text' value='' ></td>
                        </tr>
                        <tr>
                            <td>Starting Time:</td>
                            <td><input type="time" id="startingTime" class="form-control"  value="08:00"></td>
                        </tr>
                    </table>
                    <input  id='warehouseID' name='warehouseID' type='hidden' value=''>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-invoice pull-left" onclick="optimizeRouteForMap();" >Optimize Route</button>
                <button type="button" class="btn btn-link pull-right" onclick="$('#modalOptimizeRouteFromMap').modal('hide');" >Close</button>
            </div>
        </div>
    </div>
</div>
<style>

    td input {
        width:100%;
    }

    table#datatable_fixed_column tr td img { display:none;}
    table#datatable_fixed_column tr:hover td img { display:inline-block;}



    table#datatable_fixed_column tr td {
        padding-left:4px;
        padding-right:4px;
    }

    td.index {
        font-weight:bold;
    }

    tr td textarea {
        white-space: normal;
        text-align: justify;
        -moz-text-align-last: center; /* Firefox 12+ */
        text-align-last: center;
    }

    #detailsTable thead th {
        background-color: white !important;
        border:none;
        height:0px;
    }

</style>


<script type="text/javascript">
    function optimizeRouteForMap(){
        var warehouseID = $('#warehouseID').val();
        var timeToOptimize = $('#startingTime').val();
        window.location.replace("//<?php echo HTML_PATH; ?>/cop/backend/core/views/addedit/optimize_schedule_route.php?scheduleID=<?php echo $scheduleID; ?>&date=<?php echo date_format(date_create_from_format('d/m/Y', $newDateString), 'Y-m-d'); ?>&warehouse=" + warehouseID +"&startTime=" + timeToOptimize);
    }
    function initWarehouseAutocomplete()
    {

        $("#warehouseSearch").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/warehouse_autocomplete.php",
            autoFocus: true,
            minLength:0,

            select: function (event, ui) {
                $('#warehouseID').val(ui.item.warehouse_id);
                return true;
            }
        }).focus(function()
            {
                $(this).autocomplete("search","");
            }


        );
    }

    function processXLSFile(excelfile){
        $('#processfilebutton').hide();
        $('#fileDiv').html('Processing File: '+excelfile);

        $.ajax({
            type:"POST",
            url: '//<?php echo HTML_PATH ?>/cop/interface/XLSXimportConverterGeneral.php',
            data:{
                'excelFile':excelfile
            },
            success:function(result){
                var userresult = result.replace('->','<i class="fa fa-arrow-right"></i>')
                $('#fileDiv').html(result);

            }
        });
    }


    function initModalMap(lat,lng, customerAddressID) {

        $('#lat').val(lat);
        $('#lng').val(lng);
        $('#customerAddressID').val(customerAddressID);

        $('#mapModal').toggle();

        copMap = new google.maps.Map(document.getElementById('map_coprime'), {
            center: {lat: lat, lng: lng},
            zoom: 15,
            mapTypeControl: false,
            streetViewControl: false,
            zoomControl: true
        });

        var copMarker = new google.maps.Marker({
            position: {lat: lat, lng: lng},
            map: copMap,
            title: 'Company Location',
            draggable: true
        });

        copMarker.addListener('mouseout', function() {
            var newLat = copMarker.getPosition().lat();
            var newLng = copMarker.getPosition().lng();
            $('#lat').val(newLat);
            $('#lat').trigger('change');
            $('#lng').val(newLng);
            $('#lng').trigger('change');
        });


    }

    function updateTrNumbering()
    {
        var $i = 0;
        $('#datatable_fixed_column tr').each(function (i, row) {

            // reference all the stuff you need first
            var $row = $(row);

            $row.find("td.index").text($i);
            $i++;
        });
    }

    function initAutocomplete()
    {
        $(".customerCode").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/customer_autocomplete.php",
            autoFocus: true,
            open: function(){
                $('.ui-autocomplete').css('width', '400px');
            },
            select: function (event, ui) {

                var $itemRow = $(this).closest('tr');

                // Modify this  information to match the information coming from assets/ajax-services/fetch-inventory.php
                $itemRow.find('#customerID').val(ui.item.customer_id); // Hidden input on form
                $itemRow.find('#customerCode').val(ui.item.customer_code);
                $itemRow.find('#customerName').val(ui.item.customer_company_name);
                $itemRow.find('#customerAddress').val(ui.item.address);
                $itemRow.find('#customerName').prop( "disabled", false );
                $itemRow.find('#customerAddress').prop( "disabled", false );

                var customerType = ui.item.type;
                if(customerType.localeCompare('Inactive')==0 || customerType.localeCompare('inactive')==0){
                    $(this).closest('tr').css( 'background-color','firebrick');
                }

                return false;
            }
        });
    }

    function importFromFile(filename){
        readTextFile(filename);
    }

    function readTextFile(file)
    {
        var rawFile = new XMLHttpRequest();
        rawFile.open("GET", file, false);
        rawFile.onreadystatechange = function ()
        {
            if(rawFile.readyState === 4)
            {
                if(rawFile.status === 200 || rawFile.status == 0)
                {
                    <?php
                    if($replace){
                        echo '
                            $lastTr = $(\'tr:last\', $(\'#datatable_fixed_column\'));
                            var removeCounter = parseInt($lastTr.find("td.index").text());
    
                            var i;
                            for (i = 0; i < removeCounter; i++) {$(\'#datatable_fixed_column tr:first\').remove();}
                            
                                 ';
                    }
                    ?>



                    var allText = rawFile.responseText;
                    var lines = allText.split("\n");
                    // alert(allText);
                    lines.forEach(function(line) {
                        var data = line.split("|");
                        var customer_code = data[0];
                        if(customer_code.localeCompare('') !=0 ) {
                            // alert(data);
                            $lastTr = $('tr:last', $('#datatable_fixed_column'));
                            $lastTd = $('td:last', $lastTr);
                            $newTr = $lastTr.clone();
                            $lastTr.after($newTr);
                            $newTr.find("input").val("");
                            $newTr.find("textarea").text("");
                            $newTr.find("label").text("");
                            $i = $newTr.find("td.index").text();
                            $i++;
                            $newTr.find("td.index").text($i);

                            $newTr.find('#customerName').prop("disabled", true);
                            $newTr.find('#customerAddress').prop("disabled", true);
                            $newTr.css('background-color', '');
                            $(".deletRowButton").click(function () {
                                deleteRow(this);
                            });

                            $newTr.attr('id', customer_code);

                            $.ajax({
                                type: "POST",
                                url: '//<?php echo HTML_PATH; ?>/cop/backend/core/controllers/get/getCustomerFromCode.php',
                                data: {'customer_code': customer_code},
                                success: function (result) {
                                    if (result != null) {

                                        $('#' + customer_code).css('background-color','skyblue');
                                        $('#' + customer_code).find('#customerID').val(result.customer_id); // Hidden input on form
                                        $('#' + customer_code).find('#customerName').val(result.customer_company_name);
                                        $('#' + customer_code).find('#customerCode').val(result.customer_code);
                                        $('#' + customer_code).find('#customerAddress').val(result.address);
                                        $('#' + customer_code).find('#customerName').prop("disabled", false);
                                        $('#' + customer_code).find('#customerAddress').prop("disabled", false);

                                        initAutocomplete();

                                    }
                                }
                            });
                        }
                    });
                    updateTrNumbering();
                    <?php
                    if($replace){
                        echo "$('#datatable_fixed_column tr:first').remove();";
                    }
                    ?>


                }
            }
        }
        rawFile.send(null);

    }

    function addNewLine()
    {
        $lastTr = $('tr:last', $('#datatable_fixed_column'));
        $lastTd = $('td:last', $lastTr);
        $newTr = $lastTr.clone();
        $lastTr.after($newTr);
        $newTr.find("input").val("");
        $newTr.find("textarea").text("");
        $newTr.find("label").text("");
        $i = $newTr.find("td.index").text();
        $i++;
        $newTr.find("td.index").text($i);

        $newTr.find('#customerName').prop( "disabled", true );
        $newTr.find('#customerAddress').prop( "disabled", true );
        $newTr.css( 'background-color','');
        $( ".deletRowButton" ).click(function() {
            deleteRow(this);
        });

        initAutocomplete();

    }

    function deleteRow(row)
    {
        var rowCount = $('#datatable_fixed_column tr').length;

        if (rowCount > 2) {
            $(row).parents('tr').remove();
        }
        updateTrNumbering();
    }
    function exportSchedule()
    {
        $("#exportScheduleForm").submit();
    }
    function importSchedule()
    {
        $('#uploadModal').modal('toggle');
    }
    $(document).ready(function() {
        initWarehouseAutocomplete();
        pageSetUp();
        updateTrNumbering();

        <?php
        if($hasImportFile){
            echo "importFromFile('$htmlDirectory$importFileName')";
        }
        ?>



        $('#addLocation').click(function (e) {
            var lat = $('#lat').val();
            var lng = $('#lng').val();
            var customerAddressID = $('#customerAddressID').val();


            $.ajax({
                type: "POST",
                url: '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/add/add_customer_address_coordinates.php',
                data: {
                    'lat': lat,
                    'lng': lng,
                    'customerAddressID': customerAddressID
                },
                success: function (result) {
                    $('#mapModal').modal('hide');
                    $('#'+customerAddressID).html("<i class='fa fa-map-marker'>");
                    $('#lat').val('');
                    $('#lng').val('');
                    $('#customerAddressID').val('');
                }

            });

        });


        $("#deleteScheduleButton").click(function() {
            var scheduleid = <?php echo "$scheduleID"; ?>

                $.ajax({
                    url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/delete/delete_schedule.php",
                    method: "POST",
                    data: {scheduleID:scheduleid},
                    dataType: "html",
                    success: function(result){
                        $.smallBox({
                            title : "Deletion Successful!",
                            content : "Schedule Successfully Deleted",
                            color : "#739E73",
                            timeout: 3000,
                            icon : "fa fa-user swing animated"
                        });

                        window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/core/views/manage/manage_schedules.php");
                    }
                });
        });

        $("#saveScheduleButton").click(function() {
            $("#scheduleForm").submit();
        });

        $("#salespersonSelect").select2({
            placeholder: "Select Salesperson"

        });

        // START AND FINISH DATE
        $('#startdate').datepicker({
            dateFormat : 'dd/mm/yy',
            prevText : '<i class="fa fa-chevron-left"></i>',
            nextText : '<i class="fa fa-chevron-right"></i>',
            onSelect : function(selectedDate) {

            }
        });

        initAutocomplete();

        var fixHelperModified = function(e, tr) {
                var $originals = tr.children();
                var $helper = tr.clone();
                $helper.children().each(function(tr) {
                    $(this).width($originals.eq(tr).width())
                });
                return $helper;
            },
            updateIndex = function(e, ui) {
                $('td.index', ui.item.parent()).each(function (i) {
                    $(this).text(i + 1);
                });
            };

        $("#datatable_fixed_column tbody").sortable({
            helper: fixHelperModified,
            stop: updateIndex
        });

        $( "#newLineButton" ).click(function() {
            addNewLine();
        });

        $( ".deletRowButton" ).click(function() {
            deleteRow(this);
        });

        $('#datatable_fixed_column').on('keydown', 'input', function (e) {
            var keyCode = e.keyCode;
            if (keyCode !== 9) return;

            var $this = $(this),
                $lastTr = $('tr:last', $('#datatable_fixed_column')),
                $lastTd = $('td:last', $lastTr);
            if (($(e.target).closest('td')).is($lastTd)) {

                $newTr = $lastTr.clone();
                $lastTr.after($newTr);
                $newTr.find("input").val("");
                $newTr.find("textarea").text("");
                $newTr.find("label").text("");
                $i = $newTr.find("td.index").text();
                $i++;
                $newTr.find("td.index").text($i);

                $newTr.find('#customerName').prop( "disabled", true );
                $newTr.find('#customerAddress').prop( "disabled", true );

                initAutocomplete();
                $( ".deletRowButton" ).click(function() {
                    deleteRow(this);
                });
            }
        });

        $('#datatable_fixed_column').on('keydown', 'input', function (e) {
            var keyCode = e.keyCode;
            if (keyCode !== 13) return;
            var $this = $(this);

            var $thisTd = $(e.target).closest('tr');
            $lastTd = $('td:last', $thisTd);

            if (($(e.target).closest('td')).is($lastTd)) {
                $newTr = $thisTd.clone();
                $thisTd.after($newTr);
                $newTr.find("input").val("");
                $newTr.find("textarea").text("");
                $newTr.find("label").text("");
                $i = $newTr.find("td.index").text();
                $i++;
                $newTr.find("td.index").text($i);

                $newTr.find('#customerName').prop( "disabled", true );
                $newTr.find('#customerAddress').prop( "disabled", true );

                initAutocomplete();
                $(".deletRowButton").click(function () {
                    deleteRow(this);
                });
            }
            updateTrNumbering();
        });



        $("#scheduleTypeSelect").change(function() {

            var type = this.value;
            if(type == "Single Date")
            {
                $("#repeatPeriodTr").hide();
                $("#dayTr").hide();
                $("#weekTr").hide();
                $("#monthTr").hide();
            }
            else if(type == "Repeat")
            {
                $("#repeatPeriodTr").show();
                $("#dayTr").hide();
                $("#weekTr").hide();
                $("#monthTr").hide();
            }
            else
            {
                $("#repeatPeriodTr").hide();
                $("#dayTr").show();
                $("#weekTr").show();
                $("#monthTr").show();
            }

        });

        var scheduleType = "<?php echo $type?>";
        var repeatPeriod = "<?php echo $repeatPeriod?>";
        var day = "<?php echo $day?>";
        var week = "<?php echo $week?>";
        var month = "<?php echo $month?>";


        $('select#scheduleTypeSelect option')
            .each(function() { this.selected = (this.value == scheduleType); });

        $('select#repeatPeriod option')
            .each(function() { this.selected = (this.value == repeatPeriod); });

        $('select#daySelect option')
            .each(function() { this.selected = (this.value == day); });

        $('select#weekSelect option')
            .each(function() { this.selected = (this.value == week); });

        $('select#monthSelect option')
            .each(function() { this.selected = (this.value == month); });


        if(scheduleType == "Single Date")
        {
            $("#repeatPeriodTr").hide();
            $("#dayTr").hide();
            $("#weekTr").hide();
            $("#monthTr").hide();
        }
        else if(scheduleType == "Repeat")
        {
            $("#repeatPeriodTr").show();
            $("#dayTr").hide();
            $("#weekTr").hide();
            $("#monthTr").hide();
        }
        else
        {
            $("#repeatPeriodTr").hide();
            $("#dayTr").show();
            $("#weekTr").show();
            $("#monthTr").show();
        }
    });

</script>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAonEryABOdRQBcgEfH51-nOoXTca3XlWs"></script>
