<?php
include_once("../../../../param.php");
require_once(ROOT . "backend/core/model/CustomerAddress.php");
require_once(ROOT . "concc/dbhelpers/classes/DBCustomer.php");
require_once(ROOT . "concc/dbhelpers/classes/DBItem.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$dbHelbelCustomer= new DBCustomer();
$dbHelbelItem= new DBItem();

$serviceCallID=0;
$fromServiceCall=false;
if(isset($_GET['service_call_id']))
{
    $serviceCallID=$_GET['service_call_id'];
    $customerID= $_GET['customer_id'];
    $fromServiceCall=true;
    $customer=$dbHelbelCustomer->getSupplierByID($customerID);

    $salespersonID = $_SESSION['adminID'];
    if(strcmp($salespersonID,'')!=0){
        $stm = $db->prepare("SELECT salesperson_code,first_name,last_name,warehouse_code, Warehouses.name,Warehouses.warehouse_id FROM SalesPersons,Warehouses WHERE Warehouses.warehouse_id=SalesPersons.default_warehouse_id AND SalesPersons.salesperson_id='$salespersonID'");
        $stm->execute();
        $stm->bind_result($salespersonCode,$firstName,$lastName,$warehouseCode,$warehouseName,$warehouseID);
        while ($stm->fetch()) {}
        $stm->close();
    }
}

if(isset($_GET['purchase_invoice_id']))
{

$_POST['invoice_id'] = $_GET['purchase_invoice_id'];
}
if(isset($_POST['invoice_id']))
{

$invoiceID=$_POST['invoice_id'];
$edit = true;
}
else{

    if(isset($_GET['invoice_id']))
    {

        $invoiceID=$_GET['invoice_id'];
        $edit = true;
    }
    else{
        $edit=false;

    }

}

if(isset($_POST['order_id']))
{
    $orderID = $_POST['order_id'];
    $edit=false;
    $convertFromOrder=true;
    if(isset($_POST['service_call_id']))
    {
        $serviceCallID=$_POST['service_call_id'];
    }
}

$draft = false;
if(isset($_POST['draft_invoice_id']))
{
    $invoiceID = $_POST['draft_invoice_id'];
    $edit=false;
    $convertFromOrder=false;
    $draft = true;
}
if(isset($_GET['draft_invoice_id']))
{
    $invoiceID = $_GET['draft_invoice_id'];
    $edit=false;
    $convertFromOrder=false;
    $draft = true;
}


$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");


if($edit) {


    $stm = $db->prepare("SELECT invoice_id,invoice_code,company_id,customer_id,salesperson_id,paymenttype_id,order_id,tender_id,subtotal,grand_total,vat_amount,vat_i_e,discount_amount,invoice_address_id,delivery_address_id,print_count,invoice_date,details,invoice_type,due_date,status,currency_id,global_discount_percentage,timestamp FROM Purchase_Invoices WHERE invoice_id='$invoiceID'");
    $stm->execute();
    $stm->bind_result($invoiceID, $invoiceCode, $companyID, $customerID, $salespersonID, $paymentTypeID, $orderID, $tenderID, $subtotal, $grandTotal, $vatAmount, $vatIorE, $discountAmount, $invoiceAddressID, $deliveryAdressID, $printCount, $invoiceDATE, $details, $invoiceType, $dueDate, $status, $currencyID, $globalDiscountPercentage, $timestamp);
    while ($stm->fetch()) {

              $customer=$dbHelbelCustomer->getSupplierByID($customerID);
        $db2= new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");

        $stm2 = $db2->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_id='$salespersonID'");
        $stm2->execute();
        $stm2->bind_result($salespersonCode,$firstName,$lastName);
        while ($stm2->fetch()) {

        }
        $stm2->close();

        $stm2 = $db2->prepare("SELECT Purchase_Invoice_Item.warehouse_id,warehouse_code,name FROM Warehouses,Purchase_Invoice_Item WHERE Purchase_Invoice_Item.warehouse_id=Warehouses.warehouse_id AND invoice_id='$invoiceID'");
        $stm2->execute();
        $stm2->bind_result($warehouseID,$warehouseCode,$warehouseName);
        while ($stm2->fetch()) {

        }
        $stm2->close();
    }
    $stm->close();

}


if($convertFromOrder)
{
    $stm = $db->prepare("SELECT order_id,order_code,company_id,customer_id,salesperson_id,paymenttype_id,order_id,tender_id,subtotal,grand_total,vat_amount,vat_i_or_e,discount_amount,order_address_id,delivery_address_id,print_count,order_date,details,status,currency_id,global_discount_percentage,timestamp FROM Purchase_Orders WHERE order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($orderID, $orderCode, $companyID, $customerID, $salespersonID, $paymentTypeID, $orderID, $tenderID, $subtotal, $grandTotal, $vatAmount, $vatIorE, $discountAmount, $orderAddressID, $deliveryAdressID, $printCount, $orderDATE, $details, $status, $currencyID, $globalDiscountPercentage, $timestamp);
    while ($stm->fetch()) {

        $customer=$dbHelbelCustomer->getSupplierByID($customerID);
        $db2= new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");

        $stm2 = $db2->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_id='$salespersonID'");
        $stm2->execute();
        $stm2->bind_result($salespersonCode,$firstName,$lastName);
        while ($stm2->fetch()) {

        }
        $stm2->close();

		$stm2 = $db2->prepare("SELECT warehouse_id,warehouse_code,name FROM Warehouses,Purchase_Orders WHERE Purchase_Orders.delivery_method=Warehouses.warehouse_id AND order_id='$orderID'");
		$stm2->execute();
		$stm2->bind_result($warehouseID,$warehouseCode,$warehouseName);
		while ($stm2->fetch()) {

		}
		$stm2->close();
    }
    $stm->close();
}


if($draft) {


    $stm = $db->prepare("SELECT invoice_id,invoice_code,company_id,customer_id,salesperson_id,paymenttype_id,order_id,tender_id,subtotal,grand_total,vat_amount,vat_i_e,discount_amount,invoice_address_id,delivery_address_id,print_count,invoice_date,details,invoice_type,due_date,status,currency_id,global_discount_percentage,timestamp FROM Invoices_Draft WHERE invoice_id='$invoiceID'");
    $stm->execute();
    $stm->bind_result($invoiceID, $invoiceCode, $companyID, $customerID, $salespersonID, $paymentTypeID, $orderID, $tenderID, $subtotal, $grandTotal, $vatAmount, $vatIorE, $discountAmount, $invoiceAddressID, $deliveryAdressID, $printCount, $invoiceDATE, $details, $invoiceType, $dueDate, $status, $currencyID, $globalDiscountPercentage, $timestamp);
    while ($stm->fetch()) {

        $customer=$dbHelbelCustomer->getSupplierByID($customerID);
        $db2= new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");

        $stm2 = $db2->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_id='$salespersonID'");
        $stm2->execute();
        $stm2->bind_result($salespersonCode,$firstName,$lastName);
        while ($stm2->fetch()) {

        }
        $stm2->close();

        $stm2 = $db2->prepare("SELECT Invoice_Item.warehouse_id,warehouse_code,name FROM Warehouses,Invoice_Item WHERE Invoice_Item.warehouse_id=Warehouses.warehouse_id AND invoice_id='$invoiceID'");
        $stm2->execute();
        $stm2->bind_result($warehouseID,$warehouseCode,$warehouseName);
        while ($stm2->fetch()) {

        }
        $stm2->close();
    }
    $stm->close();

}


function getVatCode($vatID) {
    global $username;
    global $password;
    global $database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT vat_code FROM Vats WHERE vat_id='$vatID'");
    $stm1-> execute();
    $stm1-> bind_result($percentage);
    while ($stm1->fetch()) {
        return $percentage;
    }
    $stm1->close();
    return $percentage;


}




function redirect($url)
{
	if (headers_sent())
	{
		die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
	}
	else
	{
		header('Location: ' . $url);
		die();
	}    
}
$includeScLink = false;
if($draft){
    $custForm = new CustomForm('Invoices_Draft', $invoiceID);
} else {
    $custForm = new CustomForm('Purchase_Invoices', $invoiceID);
    $custTable = new CustomTable('Purchase_Invoices',$invoiceID);
}
?>
		<div id="main" role="main">
			
			<!-- Start CUSTOM CODE-->

			<!-- RIBBON -->
			<div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment"> 
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span> 
				</span>

				<!-- breadcrumb -->
				<ol class="breadcrumb">
					<li class="txt-color-white">Home / <?php if($edit){echo "Edit";} else if($draft) {echo "Draft";} else {echo "New";}?> Purchase Invoice</li>
				</ol>
				<!-- end breadcrumb -->

			</div>
			<!-- END RIBBON -->

			<!-- MAIN CONTENT -->
			<div id="content">

<div class="row">
	<div class="col-xs-12 col-sm-8 col-md-9 col-lg-4">
		<h3 class="page-title txt-color-blueDark header-margin">
			<img class="custom-rounded-image-padding invoice" style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/invoiceicon.png" width="30" height="30">
            <?php if($edit){echo "Edit";} else if($draft) {echo "Draft";} else {echo "New";}?> Purchase Invoice
			</h3>
	</div>


    <?php

    if ($fromServiceCall || $hasServiceCall) {
        $scRedirect = " <form method='POST' action='//" . HTML_PATH . "/cop/backend/modules/service/views/service_call.php' >
                                <input type='hidden' name='service_call_id' value='$serviceCallID'/>
                                <input type='submit' class='show-stat-buttons btn btn-return' style='text-transform: capitalize;'id='orderPDFButton' value='Back To Service Call'/>
                                </form>";
    } else {
        if($edit) {
            $stm = $db->prepare("SELECT service_call_id FROM Service_Call_Reply WHERE reply_type_id='3' AND document_type='Purchase_Invoice' AND document_id='$invoiceID'");
            $stm->execute();
            $stm->bind_result($serviceCallID);
            while ($stm->fetch()) {}
            $stm->close();

            if ($serviceCallID > 0) {
                $scRedirect = "<form method='POST' action='//" . HTML_PATH . "/cop/backend/modules/service/views/service_call.php' >
                                <input type='hidden' name='service_call_id' value='$serviceCallID'/>
                                <input type='submit' class='show-stat-buttons btn btn-return' style='text-transform: capitalize;'id='orderPDFButton' value='Related Service Call'/>
                                </form>";
            } else {
                if($edit) {
                    $includeScLink = true;
                    include_once(ROOT . "backend/core/model/linkActionToSc.php");
                    $scLink = new linkActionToSc();
                    $scLink->setAction($invoiceID,"Purchase_Invoice");
                    $scRedirect = $scLink->scLinkModal();
                }
            }
        }

    }

    if($edit)
    {
         echo "<div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'>
                $scRedirect
                </div>
<div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'>
		        <span class=\"pull-right show-stat-buttons\"> <span > <a target=\"_blank\" href=\"create_purchase_invoice.php\" class=\"btn btn-invoice btn-block\"><i class=\"fa fa-plus\"></i>&nbsp; New P.Invoice</a> </span>
		    </div>
<div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'>
        <form style='margin:0' method='POST' action='//" . HTML_PATH . "/cop/backend/core/templates/pdf/generatePurchaseInvoicePDF.php' target='_blank' >
            <input type='hidden' name='invoiceID' value='$invoiceID'/>
            <input type='hidden' name='invoiceCode' value='$invoiceCode'/>
            <button type='submit' class='show-stat-buttons btn btn-tender btn-block' style='text-transform: capitalize;'id='invoicePDFButton'><i class='fa fa-file-pdf-o'></i>&nbsp; Create PDF</button>
        </form>
        </div>
        ";
    }
    else
    {
    echo "<div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'>
             
          </div>
          <div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'>
          $scRedirect
          </div>
          <div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'>
          </div>";
    }

    ?>


    <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
		<span class="pull-right show-stat-buttons">  <button id="saveButton" onclick="saveInvoice();" class="btn btn-success btn-block"><i class="fa fa-check"></i>&nbsp; Place P.Invoice</button> </span>
    </div>


</div>

<!-- row -->
<section id="widget-grid" class="">
					
					<div class="row" >
					
					<!-- NEW WIDGET START -->
						<!-- NEW WIDGET START -->
						<article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                            <div style="margin-bottom:10px;" class="jarviswidget jarviswidget-color-blueDark" id="wid-id-5" data-widget-editbutton="false" data-widget-deletebutton="false">
								<header>
									<span class="widget-icon"> <i class="fa fa-table"></i> </span>
									<h2>Purchase Invoice Form</h2>
				
								</header>
				
								<!-- widget div-->
								<div>

									<!-- widget content -->
									<div class="widget-body no-padding">

										<form action="" id="checkout-form" class="smart-form">
											<fieldset>
												<div class="row">
													<section class="col col-4 no-margin" style="padding-left:20px;border-left:1px dotted #ADD8E6;border-right:1px dotted #ADD8E6;">
														<section>
															<img style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/customerdefault.jpg" width="25" height="25">
															<h3 style="display: inline;margin-left:6px;vertical-align: middle"> Supplier Details</h3>
                                                            <input type='hidden' name='serviceCallID' id="serviceCallID" value='<?php echo $serviceCallID;?>'/>
														</section>
														<section>
															<label style="display:inline;" class="label-bold form-label-space" >Find Supplier: </label>
                                                            <input style='display:inline;' class='text-center form-control' id='customerSearch' name='customerSearch' type='text' value='<?php if($edit||$convertFromOrder||$fromServiceCall||$draft)
                                                            {
                                                                echo "$customer->customerCode - $customer->companyName";
                                                            }
                                                            ?>'>

														</section>
                                                        <section class="no-margin">
                                                            <input type="hidden" id="customerID" value="<?php if($edit||$convertFromOrder||$fromServiceCall||$draft){echo "$customer->customerID";} ?>"/>
                                                            <label class="label-bold form-label-space"> Supplier Code: </label>
                                                            <label  style='color:#4682c4' class="label-text  bold" id='customerCode'><?php if($edit||$convertFromOrder||$fromServiceCall||$draft){echo "$customer->customerCode";} ?>  </label>
                                                        </section>
														<section class="no-margin">
															<label class="label-bold form-label-space"> Supplier Name: </label>
                                                            <label style='color:#4682c4' class="label-text bold" id='customerName'><?php if($edit||$convertFromOrder||$fromServiceCall||$draft){echo "$customer->companyName";} ?>  </label>
														</section>
                                                        <section class="no-margin">
                                                            <label class="label-bold form-label-space"> Balance : </label>
                                                            <label style='color:#4682c4' class="label-text bold" id='balance'><?php if($edit||$convertFromOrder||$fromServiceCall||$draft){echo number_format($customer->balance,2);} ?>  </label>
                                                        </section>
                                                        <div class="row" style="margin-top:10px;">
                                                            <section class="col col-6" style="padding-left:8px;padding-right:5px; ">

                                                                <?php
                                                                if($edit||$convertFromOrder||$fromServiceCall||$draft) {

                                                                    $db2 = new mysqli(localhost, $username, $password, $database);
                                                                    if (mysqli_connect_errno()) {
                                                                        printf("Connect failed: %s\n", mysqli_connect_error());
                                                                        exit();
                                                                    }
                                                                    $addresses = array();
                                                                    $db2->set_charset("utf8");
                                                                    $stm5 = $db2->prepare("SELECT supplier_address_id,address_code,supplier_id,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,landline,fax,primary_address,timestamp FROM SupplierAddress WHERE supplier_id ='$customerID'");
                                                                    $stm5->execute();
                                                                    $stm5->bind_result($customerAddressID, $addressCode, $customerID, $country, $city, $addressLine1, $addressLine2, $postcode, $region, $lat, $lng, $pobox, $landline, $fax, $primaryAddress, $timestamp);
                                                                    while ($stm5->fetch()) {
                                                                        $address = new CustomerAddress($customerAddressID, $addressCode, $customerID, $country, $city, $addressLine1, $addressLine2, $postcode, $region, $lat, $lng, $pobox, $landline, $fax, $primaryAddress);
                                                                        array_push($addresses, $address);


                                                                    }
                                                                    $stm5->close();
                                                                }
                                                                ?>
                                                                <label class="label-bold"> Delivery Address: </label>
                                                                <select  class='form-control' id='deliveryAddress' name='deliveryAddress'>
                                                                    <?php
                                                                    if($edit||$convertFromOrder||$fromServiceCall||$draft) {
                                                                        foreach ($addresses as $address) {
                                                                            if ($address->id == $deliveryAdressID) {
                                                                                echo "<option value=\"" . $address->id . "\" selected>".$address->addressLine1. "</option>";
                                                                         } else {
                                                                                echo "<option value=\"" . $address->id . "\">".$address->addressLine1. "</option>";
                                                                            }
                                                                        }
                                                                    }
                                                                    else{
                                                                        echo" <option></option>";
                                                                    }


                                                                    ?>


                                                                </select>

                                                            </section>
                                                            <section class="col col-6" style="padding-left:5px;padding-right:8px; ">
                                                                <label class="label-bold"> Billing Address: </label>
                                                                <select  class='form-control' id='billingAddress' name='billingAddress' >
                                                                    <?php
                                                                    if($edit||$convertFromOrder||$fromServiceCall||$draft) {
                                                                        foreach ($addresses as $address) {
                                                                            if ($address->id == $invoiceAddressID||$draft) {
                                                                                echo "<option value=\"" . $address->id . "\" selected>".$address->addressLine1. "</option>";
                                                                            } else {
                                                                                echo "<option value=\"" . $address->id . "\">".$address->addressLine1. "</option>";
                                                                            }
                                                                        }
                                                                    }
                                                                    else{
                                                                        echo" <option></option>";
                                                                    }


                                                                    ?>
                                                                </select>

                                                            </section>
                                                        </div>
													</section>
													<section class="col col-4 no-margin" style="padding-left:20px;border-right:1px dotted #ADD8E6;">
														<section>
															<img style="width:20px;height:20px;" class="custom-rounded-image-padding invoice" style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/invoiceicon.png" width="25" height="25">
															<h3 style="display: inline;margin-left:6px;vertical-align: middle"> Invoice Details</h3>
														</section>

                                                        <table id="detailsTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">

                                                            <thead class="height:1px;">


                                                            </thead>
                                                            <tbody>
                                                            <tr >
                                                                  <td><label class="label-bold form-label-space align-left">P. Invoice Number: </label></td>
                                                                  <td><input  class='text-center form-control' id='invoiceNumber' name='invoiceNumber' type='text' value='<?php if($edit ||$draft){echo $invoiceCode;} ?>' readonly></td>
                                                                <?php
                                                                 if($edit||$draft)
                                                                 {
                                                                     echo"<input  class='text-center form-control slim-input' id='invoiceID' name='invoiceID' type='hidden' value='$invoiceID' readonly></td>";
                                                                 }
                                                                ?>
                                                              </tr>
                                                              <tr style="margin-top:15px;" class="small-margin">
                                                                  <td> <label  class="label-bold form-label-space align-left" >P. Invoice Type:</label></td>
                                                                  <td>
                                                                      <label class="select">
                                                                      <select class='form-control slim-input' id =invoiceType name='invoiceType' <?php if($edit){echo "disabled";} ?>>
                                                                          <?php
                                                                              if($edit && strcmp($invoiceType,"Cash")==0 || $draft && strcmp($invoiceType,"Cash")==0)
                                                                              {
                                                                                  echo "  <option value='Cash'>Cash</option>
                                                                                     <option value='Credit'>Credit</option>";
                                                                              }
                                                                            else{
                                                                                echo "  <option value='Credit'>Credit</option>
                                                                          <option value='Cash'>Cash</option>";
                                                                            }
                                                                          ?>
                                                                      </select>
                                                                          <i></i>
                                                                          </label>
                                                                  </td>
                                                              </tr>
                                                            <tr >
                                                              <td><label class="label-bold form-label-space align-left" >P. Invoice Date: </label></td>
                                                              <td><input type="text" id="invoiceDate" value="<?php
                                                                  if($edit || $draft)
                                                                  {
                                                                      $old_date_timestamp = strtotime($invoiceDATE);
                                                                      $invoiceDATE = date('d/m/Y', $old_date_timestamp);
                                                                      echo $invoiceDATE;
                                                                  }
                                                                  else {
                                                                      echo date('d/m/Y');
                                                                  }?>" data-dateformat="dd/mm/yy" class="form-control text-center slim-input"
                                                                         data-mask="99/99/9999" data-mask-placeholder= "-">
                                                              </td>
                                                            </tr>
                                                            <tr >
                                                                <td><label class="label-bold form-label-space align-left" >Due Date: </label></td>
                                                                <td><input type="text" id="dueDate" data-dateformat="dd/mm/yy" class="form-control text-center slim-input"
                                                                           data-mask="99/99/9999" data-mask-placeholder= "-"  value="<?php
                                                                    if($edit && strcmp($dueDate,'0000-00-00')!=0 || $draft && strcmp($dueDate,'0000-00-00')!=0)
                                                                    {
                                                                        $old_date_timestamp = strtotime($dueDate);
                                                                        $dueDate = date('d/m/Y', $old_date_timestamp);
                                                                        echo $dueDate;
                                                                    }
                                                                   ?>"></td>
                                                            </tr>
                                                            <tr >
                                                                <td><label class="label-bold form-label-space align-left" >Payment Method: </label></td>
                                                                <td>
                                                                    <label class="select">
                                                                        <select class='form-control slim-input'  id='paymentMethod' name='paymentMethod'>
                                                                            <?php
                                                                            global $username, $password, $database;



                                                                            $db = new mysqli(localhost,$username,$password,$database);
                                                                            if (mysqli_connect_errno()) {
                                                                                printf("Connect failed: %s\n", mysqli_connect_error());
                                                                                exit();
                                                                            }
                                                                            $db->set_charset("utf8");
                                                                            // WHERE compani code in  Session
                                                                            $stm = $db->prepare("SELECT paymenttype_id,paymenttype_code,name FROM PaymentTypes");
                                                                            $stm-> execute();
                                                                            $stm-> bind_result($paymentMethodID,$paymentCode,$paymentName);
                                                                            while ($stm->fetch()) {

                                                                                if($edit || $draft)
                                                                                {
                                                                                  if($paymentMethodID ==$paymentTypeID){
                                                                                      echo "<option value='$paymentMethodID' selected>$paymentCode - $paymentName </option>";
                                                                                  }
                                                                                    else{
                                                                                        echo "<option value='$paymentMethodID'>$paymentCode - $paymentName </option>";
                                                                                    }
                                                                                }
                                                                                else {
                                                                                    echo "<option value='$paymentMethodID'>$paymentCode - $paymentName </option>";
                                                                                }

                                                                            }
                                                                            $stm->close();





                                                                            ?>
                                                                        </select>
                                                                        <i></i>
                                                                    </label>
                                                                </td>
                                                            </tr>

                                                            </tbody>
                                                        </table>
													</section>
                                                    <section class="col col-4 no-margin" >
                                                        <section>
                                                            <img style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/infoicon.png" width="30" height="30">
                                                            <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Additional Details</h3>



                                                        </section>
                                                        <section>
                                                            <label style="display:inline;" class="label-bold form-label-space" >Select Salesperson: </label>
                                                            <input style='display:inline;' class='text-center form-control' id='salespersonSearch' name='salespersonSearch' type='text' value='<?php if($edit||$fromServiceCall||$convertFromOrder|| $draft){echo "$salespersonCode - $firstName $lastName";}?>'>
                                                            <input  id='salespersonID' name='salespersonID' type='hidden' value='<?php if($edit||$convertFromOrder||$fromServiceCall|| $draft){echo $salespersonID;}?>'>
                                                        </section>
                                                        <section>
                                                            <label style="display:inline;" class="label-bold form-label-space" >Select Warehouse: </label>
                                                            <input style='display:inline;' class='text-center form-control' id='warehouseSearch' name='warehouseSearch' type='text' value='<?php if($edit||$fromServiceCall||$convertFromOrder|| $draft){echo "$warehouseCode - $warehouseName";}?>'>
                                                            <input  id='warehouseID' name='warehouseID' type='hidden' value='<?php if($edit||$fromServiceCall||$convertFromOrder|| $draft){echo $warehouseID;}?>'>
                                                        </section>

                                                        <!-- Custom Fields-->
                                                        <input type="hidden" id="order_id" name="order_id" value="<?php if($convertFromOrder||$edit) {echo $orderID;} ?>">

                                                        <section>
                                                            <?php
                                                            $custForm->editCustomFormValues();
                                                            $custTable->editCustomTableValues();
                                                            ?>

                                                        </section>
                                                        <!-- Custom Fields/-->

                                                    </section>

											</fieldset>
										</form>


										<table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%" border="0" cellpadding="0" cellspacing="0">
					
									        <thead>
												
									            <tr>
												<th class='text-center'></th>
                                                <th class='text-center'>#</th>
                                                <th class='text-center' style="display:none">itemID</th>
                                                <th class='text-center' style="display:none">orderItemID</th>
                                                <th class='text-center' style="display:none">globalDiscount</th>
                                                <th class='text-center' style="display:none">vatLine</th>
                                                <th class='text-center' style="display:none">vatPercentage</th>
									            <th class='text-center'>Item Code</th>                
           									    <th class='text-center'>Details</th>
           									    <th class='text-center'>Notes</th>
												<th class='text-center'>PC</th>
           									    <th class='text-center'>UP</th>
            								    <th class='text-center'>Qty</th>
            								    <th class='text-center'>VAT</C></th>
												<th class='text-center'>Extras</C></th>
												<th class='text-center'>LD</C></th>
								  			    <th class='text-center'>Line Total</th>
                                                <?php
                                                $custTableLine = new CustomTable('Purchase_Invoice_Item');
                                                echo $custTableLine->embedCustomTableAsLines()->headers;
                                                ?>
									            </tr>
									        </thead>
				
									        <tbody>
									           <?php


      global $username, $password, $database;

      include_once(ROOT . "concc/dbhelpers/functions/subunitsFunctions.php");
if($edit)
{

    $i=1;
    $lineDiscountTotals=0;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");


    $stm = $db->prepare("SELECT invoice_item_id,invoice_id,item_id,batch_number,warehouse_id,qty,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,serialnumber,description,cost,timestamp FROM Purchase_Invoice_Item WHERE invoice_id ='$invoiceID'");
    $stm-> execute();
    $stm-> bind_result($invoiceItemID,$invoiceID,$itemID,$batchNumber,$warehouseID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmountLine,$priceTypeID,$vatID,$serialnumber,$description,$cost,$timestamp);
    while ($stm->fetch()) {

        $item = $dbHelbelItem->getItemByID($itemID);
        $vatPercentage = getVatPercentage($vatID);
        $vatCode = getVatCode($vatID);
        $prices = $dbHelbelItem->getDefaultPurchasePrice($itemID,$customerID);

        $lineDiscountTotals+=$lineDiscount;
        $lastPricesHistory= "<table>
                   <thead>
                      <th>Invoice Code</th>
                      <th>Date</th>
                      <th>Qty</th>
                      <th>Price</th>
                   </thead>  <tbody> ";

        $db2 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("greek");
        $stm2 = $db2->prepare("SELECT invoice_code,invoice_date,qty,unit_price FROM Purchase_Invoices,Purchase_Invoice_Item WHERE Purchase_Invoices.invoice_id=Purchase_Invoice_Item.invoice_id AND item_id='$itemID' AND customer_id='$customerID' ORDER BY invoice_date DESC");
        $stm2-> execute();
        $stm2-> bind_result($invoiceCodeInfo,$invoiceDateInfo,$qtyInfo,$unitPriceInfo);
        while ($stm2->fetch()) {

            if(strcmp("$invoiceDate","0000-00-00")!=0 && strcmp("$invoiceDate","")!=0){
                $invoiceDate=date_format( date_create_from_format('Y-m-d',$invoiceDate), 'd-m-Y');
            } else {
                $invoiceDate="";
            }
            $lastPricesHistory.=" <tr>
                       <td>$invoiceCodeInfo</td>
                       <td>$invoiceDateInfo</td>
                       <td>$qtyInfo</td>
                       <td>$unitPriceInfo</td>
                    </tr>";

        }
        $stm2->close();

        $lastPricesHistory.=" </tbody>
                   </table>";

        $stockinfo= "<table>
                   <thead>
                      <th>Warehouse</th>
                      <th>Batch</th>
                      <th>Available</th>
                      <th>Reserved</th>
                   </thead>  <tbody> ";

        $stm3 = $db2->prepare("SELECT Stock.warehouse_id,available,reserved,warehouse_code,name,batch_number FROM Stock,Warehouses WHERE Stock.warehouse_id=Warehouses.warehouse_id AND item_id='$itemID'");
        $stm3-> execute();
        $stm3-> bind_result($warehouseIDInfo,$availableInfo,$reservedInfo,$warehouseCodeInfo,$warehouseNameInfo,$batchNumberInfo);
        while ($stm3->fetch()) {

            $stockinfo.=" <tr>
                       <td>$warehouseCodeInfo - $warehouseNameInfo</td>
                       <td>$batchNumberInfo</td>
                       <td>$availableInfo</td>
                       <td>$reservedInfo</td>
                    </tr>";

        }
        $stm3->close();

        $stockinfo.=" </tbody>
                   </table>";


        echo "<tr>";

        echo "<td  >
<img class='deletRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:20px;height:20px;'/>
												</td>";

        echo "<td class='index text-center' style='width:3%'>
                                                     <strong>$i</strong>
												</td>";

        echo "<td style='display:none;'>
          	    <input   id='itemID' name='itemID' type='hidden' value='$itemID'>
          	    </td>
          	    <td style='display:none;'>

          	    </td>
          	    <td style='display:none;'>
          	    <input  id='globalDiscount' name='globalDiscount' type='hidden' value='$globalDiscount'>
          	    </td>
          	    <td style='display:none;'>
                <input  id='vatLine' name='vatLine' type='hidden' value='$vatAmountLine'>
                </td>
                <td style='display:none;'>
                <input  id='vatPercentage' name='vatPercentage' type='hidden' value='$vatPercentage'>
</td>
<td>

				<input style='width:100%' class='itemCode text-center form-control' id='itemCode' name='itemCode' type='text' value='$item->itemCode'>



        </td>";

        echo "<td style='width:22%' class='text-center'  >

	<input style='width:100%' class='itemCode text-center form-control' id='itemDetails' name='itemDetails' type='text' value='$item->name'>

 </td>";

        echo "<td  style='width:12%' class='text-center' >

										<input class='text-center form-control' id='waybillItemNotes' name='waybillItemNotes' type='text' value='$description'>


 </td>";


        echo "<td style='width:6%' class='text-center' >

											<select  class='form-control' id='priceCode' name='priceCode'>";



                                              foreach($prices as $pricing)
                                              {

                                                  if($pricing->priceTypeID==$priceTypeID)
                                                  {
                                                      echo "<option value='$pricing->priceTypeID' selected data-price='$pricing->price'>$pricing->priceCode</option>";
                                                  }
                                                  else
                                                  {
                                                      echo "<option value='$pricing->priceTypeID' data-price='$pricing->price'>$pricing->priceCode</option>";
                                                  }
                                              }

                                      echo   "</select>
 </td>";

        echo "<td style='width:9%' class='text-center' >

											<input  class='text-center form-control' id='unitPrice' name='unitPrice[]' type='number'  rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>History Info</h4>'
											      data-content=\"$lastPricesHistory\" data-html='true' value='$unitPrice'>


 </td>";


        if($item->subunits==1)
        {
            echo "<td  style='width:8%' class='text-center' >
                                            <div id='unitsDiv'>
  <input  id='subUnits' name='subUnits' type='hidden' value='$item->subunits'>
											      <input class='text-center form-control' id='qty' name='qty[]' type='number' value='$qty' rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$stockinfo\" data-html='true'>









                                             </div>
                                            <div id='subunitsDiv' style='display: none'>
                                            <input class='text-center form-control' style='display:inline;width:45%' id='qtyUnits' name='qty[]' type='number' value='' placeholder='Units'  rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$stockinfo\" data-html='true' disabled>

											<input class='text-center form-control'  style='display:inline;width:45%' id='qtySubunits' name='qty[]' type='number' value='' placeholder='Subunits'  disabled>

                                             </div>
 </td>";
        }
        else
        {

            $qtyUnits = getUntis($qty,$item->subunits);
            $qtySubUnits = getSub($qty,$item->subunits);
            echo "<td  style='width:8%' class='text-center' >
                                            <div id='unitsDiv' style='display: none'>
  <input  id='subUnits' name='subUnits' type='hidden' value='$item->subunits'>
											      <input class='text-center form-control' id='qty' name='qty[]' type='text' value='' rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"\" data-html='true' disabled>









                                             </div>
                                            <div id='subunitsDiv' >
                                            <input class='text-center form-control' style='display:inline;width:45%' id='qtyUnits' name='qty[]' type='text' value='$qtyUnits' placeholder='Units'  rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$stockinfo\" data-html='true' >

											<input class='text-center form-control'  style='display:inline;width:45%'id='qtySubunits' name='qty[]' type='text' value='$qtySubUnits' placeholder='Subunits'  >

                                             </div>
 </td>";
        }


        if($lineDiscountPercentage>0)
        {
            $lineDiscountText = $lineDiscountPercentage."%";
        }
        else{
            $lineDiscountText=$lineDiscount;
        }

        echo "<td  style='width:4%' class='text-center' >

										<label class='text-center' id='vat'>$vatCode</label>


 </td>";
        echo "<td  style='width:7%' class='text-center' >

										  <button class='btn btn-info' id='extrasButton' rel='popover' data-trigger='click' data-placement='top' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$popoverTextExtras\" data-html='true' disabled><i class='fa fa-search'>
												</i></button>


 </td>";


        echo "<td  style='width:8%' class='text-center' >

											<input class='text-center form-control' id='lineDiscount' name='lineDiscount[]' type='text' value='$lineDiscountText'  >


 </td>";

        $lineTotal = ($unitPrice*$qty/$item->subunits) - $lineDiscount;
        echo "<td  style='width:10%' class='text-center' >

											<input class='text-center form-control' id='lineTotal' name='lineTotal[]' type='number' value='$lineTotal'  >


 </td>

 ";

        $custTableLine = new CustomTable('Purchase_Invoice_Item', $invoiceItemID);
        echo $custTableLine->embedCustomTableAsLines()->lines;
        echo "</tr>";






        $i++;

    }
    $stm-> close();









}
else if($convertFromOrder)
{

    $i=1;
    $lineDiscountTotals=0;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");


    $stm = $db->prepare("SELECT order_item_id,order_id,item_id,qty,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,description,timestamp FROM Purchase_Order_Item WHERE order_id ='$orderID'");
    $stm-> execute();
    $stm-> bind_result($orderItemID,$orderID,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmountLine,$priceTypeID,$vatID,$description,$timestamp);
    while ($stm->fetch()) {

        $item = $dbHelbelItem->getItemByID($itemID);
        $vatPercentage = getVatPercentage($vatID);
        $vatCode = getVatCode($vatID);
        $prices = $dbHelbelItem->getDefaultPurchasePrice($itemID,$customerID);

        $lineDiscountTotals+=$lineDiscount;
        $lastPricesHistory= "<table>
                   <thead>
                      <th>Order Code</th>
                      <th>Date</th>
                      <th>Qty</th>
                      <th>Price</th>
                   </thead>  <tbody> ";

        $db2 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("greek");
        $stm2 = $db2->prepare("SELECT order_code,order_date,qty,unit_price FROM Purchase_Orders,Purchase_Order_Item WHERE Purchase_Orders.order_id=Purchase_Order_Item.order_id AND item_id='$itemID' AND customer_id='$customerID' ORDER BY order_date DESC");
        $stm2-> execute();
        $stm2-> bind_result($orderCodeInfo,$orderDateInfo,$qtyInfo,$unitPriceInfo);
        while ($stm2->fetch()) {

            if(strcmp("$orderDateInfo","0000-00-00")!=0 && strcmp("$orderDateInfo","")!=0){
                $orderDateInfo=date_format( date_create_from_format('Y-m-d',$orderDateInfo), 'd-m-Y');
            } else {
                $orderDateInfo="";
            }
            $lastPricesHistory.=" <tr>
                       <td>$orderCodeInfo</td>
                       <td>$orderDateInfo</td>
                       <td>$qtyInfo</td>
                       <td>$unitPriceInfo</td>
                    </tr>";

        }
        $stm2->close();

        $lastPricesHistory.=" </tbody>
                   </table>";

        $stockinfo= "<table>
                   <thead>
                      <th>Warehouse</th>
                      <th>Batch</th>
                      <th>Available</th>
                      <th>Reserved</th>
                   </thead>  <tbody> ";

        $stm3 = $db2->prepare("SELECT Stock.warehouse_id,available,reserved,warehouse_code,name,batch_number FROM Stock,Warehouses WHERE Stock.warehouse_id=Warehouses.warehouse_id AND item_id='$itemID'");
        $stm3-> execute();
        $stm3-> bind_result($warehouseIDInfo,$availableInfo,$reservedInfo,$warehouseCodeInfo,$warehouseNameInfo,$batchNumberInfo);
        while ($stm3->fetch()) {

            $stockinfo.=" <tr>
                       <td>$warehouseCodeInfo - $warehouseNameInfo</td>
                       <td>$batchNumberInfo</td>
                       <td>$availableInfo</td>
                       <td>$reservedInfo</td>
                    </tr>";

        }
        $stm3->close();

        $stockinfo.=" </tbody>
                   </table>";


        echo "<tr>";

        echo "<td  >
<img class='deletRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:20px;height:20px;'/>
												</td>";

        echo "<td class='index text-center' style='width:3%'>
                                                     <strong>$i</strong>
												</td>";

        echo "<td style='display:none;'>
          	    <input   id='itemID' name='itemID' type='hidden' value='$itemID'>
          	    </td>
          	    <td style='display:none;'>
                <input   id='orderItemID' name='orderItemID' type='hidden' value='$orderItemID'>
          	    </td>
          	    <td style='display:none;'>
          	    <input  id='globalDiscount' name='globalDiscount' type='hidden' value='$globalDiscount'>
          	    </td>
          	    <td style='display:none;'>
                <input  id='vatLine' name='vatLine' type='hidden' value='$vatAmountLine'>
                </td>
                <td style='display:none;'>
                <input  id='vatPercentage' name='vatPercentage' type='hidden' value='$vatPercentage'>
</td>
<td>

				<input style='width:100%' class='itemCode text-center form-control' id='itemCode' name='itemCode' type='text' value='$item->itemCode'>



        </td>";

        echo "<td style='width:22%' class='text-center'  >

	<input style='width:100%' class='itemCode text-center form-control' id='itemDetails' name='itemDetails' type='text' value='$item->name'>

 </td>";

        echo "<td  style='width:12%' class='text-center' >

										<input class='text-center form-control' id='waybillItemNotes' name='waybillItemNotes' type='text' disabled>


 </td>";


        echo "<td style='width:6%' class='text-center' >

											<select  class='form-control' id='priceCode' name='priceCode'>";



        foreach($prices as $pricing)
        {

            if($pricing->priceTypeID==$priceTypeID)
            {
                echo "<option value='$pricing->priceTypeID' selected data-price='$pricing->price'>$pricing->priceCode</option>";
            }
            else
            {
                echo "<option value='$pricing->priceTypeID' data-price='$pricing->price'>$pricing->priceCode</option>";
            }
        }

        echo   "</select>
 </td>";

        echo "<td style='width:9%' class='text-center' >

											<input  class='text-center form-control' id='unitPrice' name='unitPrice[]' type='number'  rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>History Info</h4>'
											      data-content=\"$lastPricesHistory\" data-html='true' value='$unitPrice'>


 </td>";


        if($item->subunits==1)
        {
            echo "<td  style='width:8%' class='text-center' >
                                            <div id='unitsDiv'>
  <input  id='subUnits' name='subUnits' type='hidden' value='$item->subunits'>
											      <input class='text-center form-control' id='qty' name='qty[]' type='number' value='$qty' rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$stockinfo\" data-html='true'>









                                             </div>
                                            <div id='subunitsDiv' style='display: none'>
                                            <input class='text-center form-control' style='display:inline;width:45%' id='qtyUnits' name='qty[]' type='number' value='' placeholder='Units'  rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$stockinfo\" data-html='true' disabled>

											<input class='text-center form-control'  style='display:inline;width:45%' id='qtySubunits' name='qty[]' type='number' value='' placeholder='Subunits'  disabled>

                                             </div>
 </td>";
        }
        else
        {

            $qtyUnits = getUntis($qty,$item->subunits);
            $qtySubUnits = getSub($qty,$item->subunits);
            echo "<td  style='width:8%' class='text-center' >
                                            <div id='unitsDiv' style='display: none'>
  <input  id='subUnits' name='subUnits' type='hidden' value='$item->subunits'>
											      <input class='text-center form-control' id='qty' name='qty[]' type='text' value='' rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"\" data-html='true' disabled>









                                             </div>
                                            <div id='subunitsDiv' >
                                            <input class='text-center form-control' style='display:inline;width:45%' id='qtyUnits' name='qty[]' type='text' value='$qtyUnits' placeholder='Units'  rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$stockinfo\" data-html='true' >

											<input class='text-center form-control'  style='display:inline;width:45%'id='qtySubunits' name='qty[]' type='text' value='$qtySubUnits' placeholder='Subunits'  >

                                             </div>
 </td>";
        }


        if($lineDiscountPercentage>0)
        {
            $lineDiscountText = $lineDiscountPercentage."%";
        }
        else{
            $lineDiscountText=$lineDiscount;
        }

        echo "<td  style='width:4%' class='text-center' >

										<label class='text-center' id='vat'>$vatCode</label>


 </td>";
        echo "<td  style='width:7%' class='text-center' >

										  <button class='btn btn-info' id='extrasButton' rel='popover' data-trigger='click' data-placement='top' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$popoverTextExtras\" data-html='true' disabled><i class='fa fa-search'>
												</i></button>


 </td>";


        echo "<td  style='width:8%' class='text-center' >

											<input class='text-center form-control' id='lineDiscount' name='lineDiscount[]' type='text' value='$lineDiscountText'  >


 </td>";

        $lineTotal = ($unitPrice*$qty/$item->subunits) - $lineDiscount;
        echo "<td  style='width:10%' class='text-center' >

											<input class='text-center form-control' id='lineTotal' name='lineTotal[]' type='number' value='$lineTotal'  >


 </td>

 ";

        $custTableLine = new CustomTable('Purchase_Invoice_Item', $invoiceItemID);
        echo $custTableLine->embedCustomTableAsLines()->lines;
        echo "</tr>";






        $i++;

    }
    $stm-> close();









}
else if($draft)
{
     $i=1;
     $lineDiscountTotals=0;
     $db = new mysqli(localhost,$username,$password,$database);
     if (mysqli_connect_errno())
     {
         printf("Connect failed: %s\n", mysqli_connect_error());
         exit();
     }
     $db->set_charset("utf8");


     $stm = $db->prepare("SELECT invoice_item_id,invoice_id,item_id,batch_number,warehouse_id,qty,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,serialnumber,description,cost,timestamp FROM Invoice_Item_Draft WHERE invoice_id ='$invoiceID'");
     $stm-> execute();
     $stm-> bind_result($invoiceItemID,$invoiceID,$itemID,$batchNumber,$warehouseID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmountLine,$priceTypeID,$vatID,$serialnumber,$description,$cost,$timestamp);
     while ($stm->fetch()) {

         $item = $dbHelbelItem->getItemByID($itemID);
         $vatPercentage = getVatPercentage($vatID);
         $vatCode = getVatCode($vatID);
         $prices = $dbHelbelItem->getDefaultPurchasePrice($itemID,$customerID);

         $lineDiscountTotals+=$lineDiscount;
         $lastPricesHistory= "<table>
                                  <thead>
                                    <th>Invoice Code</th>
                                    <th>Date</th>
                                    <th>Qty</th>
                                    <th>Price</th>
                                  </thead> <tbody> ";

         $db2 = new mysqli(localhost,$username,$password,$database);
         if (mysqli_connect_errno()) {
             printf("Connect failed: %s\n", mysqli_connect_error());
             exit();
         }
         $db2->set_charset("greek");
         $stm2 = $db2->prepare("SELECT invoice_code,invoice_date,qty,unit_price FROM Purchase_Invoices,Purchase_Invoice_Item WHERE Purchase_Invoices.invoice_id=Purchase_Invoice_Item.invoice_id AND item_id='$itemID' AND customer_id='$customerID' ORDER BY invoice_date DESC");
         $stm2-> execute();
         $stm2-> bind_result($invoiceCodeInfo,$invoiceDateInfo,$qtyInfo,$unitPriceInfo);
         while ($stm2->fetch()) {

             $invoiceDate=    date_format( date_create_from_format('Y-m-d',$invoiceDate), 'd-m-Y');
             $lastPricesHistory.=" <tr>
                                        <td>$invoiceCodeInfo</td>
                                        <td>$invoiceDateInfo</td>
                                        <td>$qtyInfo</td>
                                        <td>$unitPriceInfo</td>
                                    </tr>";

         }
         $stm2->close();

         $lastPricesHistory.=" </tbody>
                              </table>";

         $stockinfo= "<table>
                         <thead>
                            <th>Warehouse</th>
                            <th>Batch</th>
                            <th>Available</th>
                            <th>Reserved</th>
                         </thead>  <tbody> ";

         $stm3 = $db2->prepare("SELECT Stock.warehouse_id,available,reserved,warehouse_code,name,batch_number FROM Stock,Warehouses WHERE Stock.warehouse_id=Warehouses.warehouse_id AND item_id='$itemID'");
         $stm3-> execute();
         $stm3-> bind_result($warehouseIDInfo,$availableInfo,$reservedInfo,$warehouseCodeInfo,$warehouseNameInfo,$batchNumberInfo);
         while ($stm3->fetch()) {

             $stockinfo.=" <tr>
                              <td>$warehouseCodeInfo - $warehouseNameInfo</td>
                              <td>$batchNumberInfo</td>
                              <td>$availableInfo</td>
                              <td>$reservedInfo</td>
                           </tr>";

         }
         $stm3->close();

         $stockinfo.=" </tbody>
                   </table>";


         echo "<tr>";
         echo "<td>
                <img class='deletRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:20px;height:20px;'/>
          	   </td>";

         echo "<td class='index text-center' style='width:3%'>
                      <strong>$i</strong>
		       </td>";

         echo "<td style='display:none;'>
          	    <input   id='itemID' name='itemID' type='hidden' value='$itemID'>
          	    </td>
          	    <td style='display:none;'>

          	    </td>
          	    <td style='display:none;'>
          	    <input  id='globalDiscount' name='globalDiscount' type='hidden' value='$globalDiscount'>
          	    </td>
          	    <td style='display:none;'>
                <input  id='vatLine' name='vatLine' type='hidden' value='$vatAmountLine'>
                </td>
                <td style='display:none;'>
                <input  id='vatPercentage' name='vatPercentage' type='hidden' value='$vatPercentage'>
                </td>
                <td>
				<input style='width:100%' class='itemCode text-center form-control' id='itemCode' name='itemCode' type='text' value='$item->itemCode'>
                </td>";

         echo "<td style='width:22%' class='text-center'  >
                    <input style='width:100%' class='itemCode text-center form-control' id='itemDetails' name='itemDetails' type='text' value='$item->name'>
                </td>";

         echo "<td  style='width:12%' class='text-center' >
					<input class='text-center form-control' id='waybillItemNotes' name='waybillItemNotes' type='text' value='$description'>
               </td>";


         echo "<td style='width:6%' class='text-center' >
                    <select  class='form-control' id='priceCode' name='priceCode'>";



         foreach($prices as $pricing)
         {

             if($pricing->priceTypeID==$priceTypeID)
             {
                 echo "<option value='$pricing->priceTypeID' selected data-price='$pricing->price'>$pricing->priceCode</option>";
             } else {
                 echo "<option value='$pricing->priceTypeID' data-price='$pricing->price'>$pricing->priceCode</option>";
             }
         }

         echo   "</select>
                 </td>";

         echo "<td style='width:9%' class='text-center' >
                    <input  class='text-center form-control' id='unitPrice' name='unitPrice[]' type='number'  rel='popover' data-trigger='focus'
                                                                                                                            data-placement='bottom' data-original-title='<h4>History Info</h4>'
                                                                                                                            data-content=\"$lastPricesHistory\" data-html='true' value='$unitPrice'>
               </td>";


         if($item->subunits==1)
         {
             echo "<td  style='width:8%' class='text-center' >
                      <div id='unitsDiv'>
                        <input  id='subUnits' name='subUnits' type='hidden' value='$item->subunits'>
						<input class='text-center form-control' id='qty' name='qty[]' type='number' value='$qty' rel='popover' data-trigger='focus'
                                                                                                                               data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
                                                                                                                               data-content=\"$stockinfo\" data-html='true'>
                      </div>
                      <div id='subunitsDiv' style='display: none'>
                          <input class='text-center form-control' style='display:inline;width:45%' id='qtyUnits' name='qty[]' type='number' value='' placeholder='Units'  rel='popover' data-trigger='focus'
                                                                                                                                                                                        data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
                                                                                                                                                                                        data-content=\"$stockinfo\" data-html='true' disabled>
                          <input class='text-center form-control'  style='display:inline;width:45%' id='qtySubunits' name='qty[]' type='number' value='' placeholder='Subunits'  disabled>

                      </div>
                    </td>";
         } else {

             $qtyUnits = getUntis($qty,$item->subunits);
             $qtySubUnits = getSub($qty,$item->subunits);
             echo "<td  style='width:8%' class='text-center' >
                       <div id='unitsDiv' style='display: none'>
                            <input  id='subUnits' name='subUnits' type='hidden' value='$item->subunits'>
					        <input class='text-center form-control' id='qty' name='qty[]' type='text' value='' rel='popover' data-trigger='focus'
                                                                                                                             data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
                                                                                                                             data-content=\"\" data-html='true' disabled>
                       </div>
                       <div id='subunitsDiv' >
                             <input class='text-center form-control' style='display:inline;width:45%' id='qtyUnits' name='qty[]' type='text' value='$qtyUnits' placeholder='Units'  rel='popover' data-trigger='focus'
                                                                                                                                                                                                  data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
                                                                                                                                                                                                  data-content=\"$stockinfo\" data-html='true' >

							 <input class='text-center form-control'  style='display:inline;width:45%'id='qtySubunits' name='qty[]' type='text' value='$qtySubUnits' placeholder='Subunits'  >
                       </div>
                    </td>";
         }


         if($lineDiscountPercentage>0)
         {
             $lineDiscountText = $lineDiscountPercentage."%";
         } else {
             $lineDiscountText=$lineDiscount;
         }

         echo "<td  style='width:4%' class='text-center' >
					<label class='text-center' id='vat'>$vatCode</label>
               </td>";

         echo "<td  style='width:7%' class='text-center' >
					<button class='btn btn-info' id='extrasButton' rel='popover' data-trigger='click' data-placement='top' data-original-title='<h4>Stock Info</h4>'
										      data-content=\"$popoverTextExtras\" data-html='true' disabled><i class='fa fa-search'></i>
					</button>
                </td>";


         echo "<td  style='width:8%' class='text-center' >
						<input class='text-center form-control' id='lineDiscount' name='lineDiscount[]' type='text' value='$lineDiscountText'  >
                </td>";

         $lineTotal = ($unitPrice*$qty/$item->subunits) - $lineDiscount;
         echo "<td  style='width:10%' class='text-center' >
					<input class='text-center form-control' id='lineTotal' name='lineTotal[]' type='number' value='$lineTotal'  >
               </td>";

         $custTableLine = new CustomTable('Purchase_Invoice_Item', $invoiceItemID);
         echo $custTableLine->embedCustomTableAsLines()->lines;
         echo "</tr>";


         $i++;
     }
     $stm-> close();

    for ($i; $i < 2; $i++) {

        echo "<tr>";

        echo "<td  >
<img class='deletRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:20px;height:20px;'/>
												</td>";

        echo "<td class='index text-center' style='width:3%'>
                                                     <strong>$i</strong>
												</td>";

        echo "<td style='display:none;'>
          	    <input   id='itemID' name='itemID' type='hidden' value=''>
          	    </td>
          	    <td style='display:none;'>

          	    </td>
          	    <td style='display:none;'>
          	    <input  id='globalDiscount' name='globalDiscount' type='hidden' value=''>
          	    </td>
          	    <td style='display:none;'>
                <input  id='vatLine' name='vatLine' type='hidden' value=''>
                </td>
                <td style='display:none;'>
                <input  id='vatPercentage' name='vatPercentage' type='hidden' value=''>
</td>
<td>

				<input style='width:100%' class='itemCode text-center form-control' id='itemCode' name='itemCode' type='text' value=''>



        </td>";

        echo "<td style='width:22%' class='text-center'  >

	<input style='width:100%' class='itemCode text-center form-control' id='itemDetails' name='itemDetails' type='text' value='' disabled>

 </td>";
        echo "<td  style='width:12%' class='text-center' >

										<input class='text-center form-control' id='waybillItemNotes' name='waybillItemNotes' type='text' disabled>


 </td>";

        echo "<td style='width:6%' class='text-center' >

											<select  class='form-control' id='priceCode' name='priceCode' type='text' value=''  disabled>

                                             </select>
 </td>";

        echo "<td style='width:9%' class='text-center' >

											<input  class='text-center form-control' id='unitPrice' name='unitPrice[]' type='number' value=''  rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>History Info</h4>'
											      data-content=\"\" data-html='true' disabled>


 </td>";

        echo "<td  style='width:8%' class='text-center' >
                                            <div id='unitsDiv'>
  <input  id='subUnits' name='subUnits' type='hidden' value=''>
											      <input class='text-center form-control' id='qty' name='qty[]' type='number' value='' rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"\" data-html='true' disabled>









                                             </div>
                                            <div id='subunitsDiv' style='display: none'>
                                            <input class='text-center form-control' style='display:inline;width:45%' id='qtyUnits' name='qty[]' type='number' value='' placeholder='Units'  rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$popoverText\" data-html='true' disabled>

											<input class='text-center form-control'  style='display:inline;width:45%'id='qtySubunits' name='qty[]' type='number' value='' placeholder='Subunits'  disabled>

                                             </div>
 </td>";

        echo "<td  style='width:4%' class='text-center' >

										<label class='text-center' id='vat'></label>


 </td>";
        echo "<td  style='width:7%' class='text-center' >

										  <button class='btn btn-info' id='extrasButton' rel='popover' data-trigger='click' data-placement='top' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$popoverTextExtras\" data-html='true' disabled><i class='fa fa-search'>
												</i></button>


 </td>";
        echo "<td  style='width:8%' class='text-center' >

											<input class='text-center form-control' id='lineDiscount' name='lineDiscount[]' type='text' value=''  disabled>


 </td>";
        echo "<td  style='width:10%' class='text-center' >

											<input class='text-center form-control' id='lineTotal' name='lineTotal[]' type='number' value=''  disabled>


 </td>

 ";

        $custTableLine = new CustomTable('Purchase_Invoice_Item', $invoiceItemID);
        echo $custTableLine->embedCustomTableAsLines()->lines;
        echo "</tr>";
    }

}
else {
    $popoverText = "";


    $popoverTextExtras = "";


    for ($i = 1; $i <= 2; $i++) {

        echo "<tr>";

        echo "<td  >
<img class='deletRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:20px;height:20px;'/>
												</td>";

        echo "<td class='index text-center' style='width:3%'>
                                                     <strong>$i</strong>
												</td>";

        echo "<td style='display:none;'>
          	    <input   id='itemID' name='itemID' type='hidden' value=''>
          	    </td>
          	    <td style='display:none;'>

          	    </td>
          	    <td style='display:none;'>
          	    <input  id='globalDiscount' name='globalDiscount' type='hidden' value=''>
          	    </td>
          	    <td style='display:none;'>
                <input  id='vatLine' name='vatLine' type='hidden' value=''>
                </td>
                <td style='display:none;'>
                <input  id='vatPercentage' name='vatPercentage' type='hidden' value=''>
</td>
<td>

				<input style='width:100%' class='itemCode text-center form-control' id='itemCode' name='itemCode' type='text' value=''>



        </td>";

        echo "<td style='width:22%' class='text-center'  >

	<input style='width:100%' class='itemCode text-center form-control' id='itemDetails' name='itemDetails' type='text' value='' disabled>

 </td>";
        echo "<td  style='width:12%' class='text-center' >

										<input class='text-center form-control' id='waybillItemNotes' name='waybillItemNotes' type='text' disabled>


 </td>";

        echo "<td style='width:6%' class='text-center' >

											<select  class='form-control' id='priceCode' name='priceCode' type='text' value=''  disabled>

                                             </select>
 </td>";

        echo "<td style='width:9%' class='text-center' >

											<input  class='text-center form-control' id='unitPrice' name='unitPrice[]' type='number' value=''  rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>History Info</h4>'
											      data-content=\"\" data-html='true' disabled>


 </td>";

        echo "<td  style='width:8%' class='text-center' >
                                            <div id='unitsDiv'>
  <input  id='subUnits' name='subUnits' type='hidden' value=''>
											      <input class='text-center form-control' id='qty' name='qty[]' type='number' value='' rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"\" data-html='true' disabled>









                                             </div>
                                            <div id='subunitsDiv' style='display: none'>
                                            <input class='text-center form-control' style='display:inline;width:45%' id='qtyUnits' name='qty[]' type='number' value='' placeholder='Units'  rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$popoverText\" data-html='true' disabled>

											<input class='text-center form-control'  style='display:inline;width:45%'id='qtySubunits' name='qty[]' type='number' value='' placeholder='Subunits'  disabled>

                                             </div>
 </td>";

        echo "<td  style='width:4%' class='text-center' >

										<label class='text-center' id='vat'></label>


 </td>";
        echo "<td  style='width:7%' class='text-center' >

										  <button class='btn btn-info' id='extrasButton' rel='popover' data-trigger='click' data-placement='top' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$popoverTextExtras\" data-html='true' disabled><i class='fa fa-search'>
												</i></button>


 </td>";
        echo "<td  style='width:8%' class='text-center' >

											<input class='text-center form-control' id='lineDiscount' name='lineDiscount[]' type='text' value=''  disabled>


 </td>";
        echo "<td  style='width:10%' class='text-center' >

											<input class='text-center form-control' id='lineTotal' name='lineTotal[]' type='number' value=''  disabled>


 </td>

 ";

        $custTableLine = new CustomTable('Purchase_Invoice_Item', $invoiceItemID);
        echo $custTableLine->embedCustomTableAsLines()->lines;
        echo "</tr>";
    }

}



    ?>

									        </tbody>
									
										</table>




<div class="row" style="margin-top:4px;margin-right:3px;">
								<div class="col-sm-9">

                                    <div class="col-sm-12" style="margin-top:8px;">
									      <span class="col-sm-2" >
											<a target="_blank" id="newLineButton" class="btn btn-primary btn-block">
												<i class="fa fa-plus  ">
												</i>&nbsp; Add Line</a>
										</span>
                                    </div>
                                    <div class="col-sm-12" style="margin-top:10px;" >
                                        <div class='col-sm-8'>
                                            <label class="label-bold form-label-space">P. Invoice Notes: </label>
                                    <textarea style='width:100%;' class='form-control custom-textarea' rows='3' id='details'><?php if($edit||$convertFromOrder||$draft){echo $details;} ?></textarea>
                                        </div>
                                    </div>

								</div>
								<div class="col-sm-3">
									<div>
										<div class="font-md">
											<strong>Subtotal :</strong>
											 <span id='subtotal'class="pull-right"><?php if($edit||$convertFromOrder||$draft){echo number_format($subtotal -$lineDiscountTotals,2);} ?></span>
										</div>
									</div>
<div>
										<div class="font-md" style="display:inline-block">
											<strong style="display:inline;">Discount:</strong>
                                            <input style="display:inline-block;width:25%;position: absolute; left:71%;bottom: 72%;" class='text-right form-control slim-input pull-right'  id='discount' oninput="this.value = this.value.replace(/[^0-9%.]/g, '').replace(/(\..*?)\..*/g, '$1');" name='discount' type='text' value='<?php if($edit||$convertFromOrder||$draft){

                                                if($globalDiscountPercentage>0)
                                                {
                                                    $globalDiscountText = $globalDiscountPercentage."%";
                                                }
                                                else{
                                                    $globalDiscountText = number_format($discountAmount -$lineDiscountTotals,2);
                                                }
                                                echo $globalDiscountText;
                                            } ?>'>
										</div>

									</div>
                                    <div>
                                        <div class="font-md">
                                            <strong>Net Amount :</strong>
                                            <span  id='netAmount' class="pull-right"><?php if($edit||$convertFromOrder||$draft){echo number_format($subtotal -$discountAmount,2);} ?></span>
                                        </div>

                                    </div>
									<div>
										<div class="font-md">
											<strong>VAT :</strong>
											<span  id='vatTotal' class="pull-right"><?php if($edit||$convertFromOrder||$draft){echo number_format($vatAmount,2);} ?></span>
										</div>

									</div>

									<div style='margin-top:4px;' class="well well-sm  bg-color-darken txt-color-white no-border">
										<div class="fa-lg">
											Grand Total :
											<span  id='grandTotal' class="pull-right"><?php if($edit||$convertFromOrder||$draft){echo number_format($grandTotal,2);} ?></span>
										</div>

									</div>
									<br>
									<br>
								</div>
							</div>

				
									</div>
									<!-- end widget content -->
				
								</div>
								<!-- end widget div -->
				
							</div>
							<!-- end widget -->
					</div>
				
					<!-- end row -->


				
				</section>
		</div>
		</div>

<style>

	td input {
		width:100%;
	}

	table#datatable_fixed_column tr td img { display:none;}
	table#datatable_fixed_column tr:hover td img { display:inline-block;}

    table#datatable_fixed_column {
        border: solid 1px #407bad;
    }

    table#datatable_fixed_column thead  {
        border: solid 1px #407bad;
    }

    table#datatable_fixed_column thead th {
          background-color: #4682B4;
          color: white;
        font-family: arial, sans-serif;
    }

    .form-control {
        font-family: arial, sans-serif;
        border-radius: 4px !important;
        color: #000;
        font-weight:400;
        margin: 0px;
        padding: 0px;
    }

    table#datatable_fixed_column tr td {
        padding-left:4px;
        padding-right:4px;
    }

    td.index {
        font-weight:bold;
    }

    .form-control:disabled {
        background-color: #fcfcfc;
    }



    .slim-input {
        height:22px;
        margin-left:8px;
        font-family: Calibri;
    }

    .small-margin {
        margin-bottom: 5px !important;
    }

    #detailsTable thead th {
        background-color: white !important;
        border:none;
        height:0px;
    }

    .align-left {
        text-align: left;
    }

    .popover {
        position: absolute;
        top: 0;
        left: 0;
        z-index: 1010;
        display: none;
        max-width: 600px;
        padding: 1px;
        text-align: left;
        white-space: normal;
        background-color: #ffffff;
        border: 1px solid #ccc;
        border: 1px solid rgba(0, 0, 0, 0.2);
        -webkit-border-radius: 6px;
        -moz-border-radius: 6px;
        border-radius: 6px;
        -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
        -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
        box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
        -webkit-background-clip: padding-box;
        -moz-background-clip: padding;
        background-clip: padding-box;
    }

</style>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/jquery.tabletojson.js"></script>
	<script type="text/javascript">

        function addGlobalDiscount() {
            //var $itemRow = $($this).closest('tr');
            //var $itemRow = $($this).closest('tr');
            // Calculate the price of the row.  Remove any $ so the calculation doesn't break
            subTotal = $('#subtotal').text();
            globalDiscount = $('#discount').val();

            if (globalDiscount.indexOf("%") >= 0)
            {
                globalDiscount = $('#discount').val().replace("%", "");


            }
            else
            {
                globalDiscount = globalDiscount/subTotal*100;
            }







            if(globalDiscount=='')
            {
                globalDiscount=0;
            }




            $('#datatable_fixed_column tr').each(function (i, row) {

                // reference all the stuff you need first
                var $itemRow = $(row);
                var percentage=  $itemRow.find('#vatPercentage').val();
                lineTotal =$itemRow.find('#lineTotal').val();

                globalDiscountOfLine = lineTotal *globalDiscount/100;
                $itemRow.find('#globalDiscount').val(globalDiscountOfLine);

                vatLine = (lineTotal-globalDiscountOfLine)*percentage/100;
            //    alert(vatLine);
                $itemRow.find('#vatLine').val(vatLine);


            });





            updateTotals();
        }
        function changeLineTotal($itemRow) {
            //var $itemRow = $($this).closest('tr');
            //var $itemRow = $($this).closest('tr');
            // Calculate the price of the row.  Remove any $ so the calculation doesn't break
            var lineTotal =$itemRow.find('#lineTotal').val();

            lineDiscount=0;





            lineTotal = lineTotal - lineDiscount;
            lineTotal = lineTotal.toFixed(2);
            var vatTotal = 0;
            var percentage = $itemRow.find('#vatPercentage').val();
            var check = $itemRow.find('#subUnits').val();
            if (check == 1) {
                $itemRow.find('#unitPrice').val(lineTotal / $itemRow.find('#qty').val());
            }
            else {
                if ($itemRow.find('#qtySubunits').val() == '') {
                    $itemRow.find('#qtySubunits').val(0)
                }

                $itemRow.find('#unitPrice').val(lineTotal / (+$itemRow.find('#qtyUnits').val() + +($itemRow.find('#qtySubunits').val() / $itemRow.find('#subUnits').val())));

            }
            globalLineDiscount = $itemRow.find('#globalDiscount').val();
            vatTotal = (lineTotal-globalLineDiscount)*percentage/100;

            isNaN(vatTotal) ? $itemRow.find('#vatLine').val("N/A") : $itemRow.find('#vatLine').val(vatTotal);
            $itemRow.find('#lineDiscount').val('');


            updateTotals();
        }



		function updateLineTotal($itemRow) {
			//var $itemRow = $($this).closest('tr');
			//var $itemRow = $($this).closest('tr');
			// Calculate the price of the row.  Remove any $ so the calculation doesn't break
			var lineTotal =0;
            var vatTotal =0;
			var percentage=  $itemRow.find('#vatPercentage').val();
            var check=  $itemRow.find('#subUnits').val();

			if(check ==1) {
				lineTotal = $itemRow.find('#unitPrice').val().replace("", "") * $itemRow.find('#qty').val();
			}
			else
			{
				if($itemRow.find('#qtySubunits').val()=='')
				{
					$itemRow.find('#qtySubunits').val(0)
				}
				lineTotal = $itemRow.find('#unitPrice').val().replace("", "") * $itemRow.find('#qtyUnits').val()+$itemRow.find('#unitPrice').val().replace("", "") * $itemRow.find('#qtySubunits').val()/$itemRow.find('#subUnits').val();
			}

             lineDiscount = $itemRow.find('#lineDiscount').val();



            if (lineDiscount.indexOf("%") >= 0)
            {
                lineDiscount = $itemRow.find('#lineDiscount').val().replace("%", "");
                lineDiscount = lineTotal*lineDiscount/100;
            }

            if(lineDiscount=='')
            {
                lineDiscount=0;
            }


            globalLineDiscount = $itemRow.find('#globalDiscount').val();


            if(globalLineDiscount=='')
            {
                globalLineDiscount=0;
            }

            lineTotal = lineTotal -lineDiscount;
			lineTotal = lineTotal.toFixed(2);
            vatTotal = (lineTotal-globalLineDiscount)*percentage/100;
			isNaN(lineTotal) ? $itemRow.find('#lineTotal').val("N/A") : $itemRow.find('#lineTotal').val(lineTotal);
            isNaN(vatTotal) ? $itemRow.find('#vatLine').val("N/A") : $itemRow.find('#vatLine').val(vatTotal);
            updateTotals();
		}


        function updateTotals() {
            //var $itemRow = $($this).closest('tr');
            //var $itemRow = $($this).closest('tr');
            // Calculate the price of the row.  Remove any $ so the calculation doesn't break
            var subTotal = 0;
            $('input#lineTotal').each(function (i) {
                lineTotal = $(this).val();
                if (!isNaN(lineTotal)) subTotal += Number(lineTotal);
            });

            $('#subtotal').text(subTotal.toFixed(2));


            globalDiscount = $('#discount').val();


            if (globalDiscount.indexOf("%") >= 0)
            {
                globalDiscount = $('#discount').val().replace("%", "");
                netAmount = subTotal - subTotal*globalDiscount/100;

            }
            else
            {
               netAmount = subTotal - globalDiscount;
             }



        if(globalDiscount=='')
        {
            globalDiscount=0;
            netAmount = subTotal;
        }




            $('#netAmount').text(netAmount.toFixed(2));





            var vatTotal = 0;
            $('input#vatLine').each(function (i) {
                vatLine = $(this).val();
                if (!isNaN(vatLine)) vatTotal += Number(vatLine);
            });


            $('#vatTotal').text(vatTotal.toFixed(2));
            var temp=netAmount+vatTotal;
        $('#grandTotal').text(temp.toFixed(2));
        }



        function updateTrNumbering()
        {
            var $i = 0;
            $('#datatable_fixed_column tr').each(function (i, row) {

                // reference all the stuff you need first
                var $row = $(row);

                $row.find("td.index").text($i);
                $i++;
            });
        }

        function initCustomerCodeAutocomplete()
        {
            $("#customerSearch").autocomplete({
                source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/supplier_autocomplete.php",
                autoFocus: true,
                select: function (event, ui) {
                    $('#customerID').val(ui.item.customer_id);
                    $('#customerCode').text(ui.item.customer_code);
                    $('#customerName').text(ui.item.customer_company_name);
                    $('#balance').text(ui.item.balance);

					var optionsAsString = "";
					for(var i = 0; i < ui.item.addresses.length; i++) {
                        if(i==0)
                        {
                            optionsAsString += "<option value=\"" + ui.item.addresses[i].id + "\" selected>" + ui.item.addresses[i].addressLine1 + "</option>";
                        }
                        else{
                            optionsAsString += "<option value=\"" + ui.item.addresses[i].id + "\">" + ui.item.addresses[i].addressLine1 + "</option>";
                        }


					}
					$("select[name='deliveryAddress']").find('option').remove().end().append($(optionsAsString));
                    $("select[name='billingAddress']").find('option').remove().end().append($(optionsAsString));
                    return true;
                }
            });
        }

        function initSalepersonCodeAutocomplete()
        {
            $("#salespersonSearch").autocomplete({
                source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/salesperson_autocomplete.php",
                autoFocus: true,
                minLength:0,
                select: function (event, ui) {

                    $('#salespersonID').val(ui.item.salesperson_id);
                    return true;
                }
            }).focus(function()
                {
                    $(this).autocomplete("search","");
                }


            );
        }

        function initWarehouseCodeAutocomplete()
        {
            $("#warehouseSearch").autocomplete({
                source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/warehouse_autocomplete.php",
                autoFocus: true,
                minLength:0,
                select: function (event, ui) {

                    $('#warehouseID').val(ui.item.warehouse_id);
                    return true;
                }
            }).focus(function()
                {
                   $(this).autocomplete("search","");
                }


            );
        }

		function initAutocomplete()
		{
			$(".itemCode").autocomplete({
				source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/invoice_autocomplete.php",
				autoFocus: true,
                open: function(){
                    $('.ui-autocomplete').css('width', '400px');
                },
				select: function (event, ui) {

					var $itemRow = $(this).closest('tr');

					// Modify this  information to match the information coming from assets/ajax-services/fetch-inventory.php
					$itemRow.find('#itemID').val(ui.item.item_id); // Hidden input on form
					$itemRow.find('#itemCode').val(ui.item.item_code);
					$itemRow.find('#itemDetails').val(ui.item.name);
					$itemRow.find('#vat').text(ui.item.vatCode);
					$itemRow.find('#unitPrice').val(ui.item.price);
					$itemRow.find('#subUnits').val(ui.item.subunits);
                    $itemRow.find('#vatPercentage').val(ui.item.percentage);






                    $itemRow.find('#itemDetails').prop( "disabled", false );
                    $itemRow.find('#unitPrice').prop( "disabled", false );
                    $itemRow.find('#priceCode').prop( "disabled", false );
                    $itemRow.find('#lineDiscount').prop( "disabled", false );
                    $itemRow.find('#qty').prop( "disabled", false );
                    $itemRow.find('#lineTotal').prop( "disabled", false );
                    $itemRow.find('#qtyUnits').prop( "disabled", false );
                    $itemRow.find('#qtySubunits').prop( "disabled", false );
                    $itemRow.find('#extrasButton').prop( "disabled", false );
                    $itemRow.find('#waybillItemNotes').prop( "disabled", false );

					//$itemRow.find('#itemPrice').val(ui.item.itemPrice);




                    $($itemRow.find('#priceCode')).bind("change keyup", function() {

                       var newPrice= $($itemRow.find('#priceCode option:selected')).attr("data-price");

                        $itemRow.find('#unitPrice').val(newPrice);
                        updateLineTotal($itemRow);
                    });

					$($itemRow.find('#unitPrice')).bind("change keyup", function() {
                        validateNumber($($itemRow.find('#unitPrice')));
                        updateLineTotal($itemRow);
					});

					$($itemRow.find('#qty')).bind("change keyup", function() {
                        validateNumber($($itemRow.find('#qty')));
						updateLineTotal($itemRow);
					});
					$($itemRow.find('#qtyUnits')).bind("change keyup", function() {
                        validateNumber($($itemRow.find('#qtyUnits')));
						updateLineTotal($itemRow);
					});
					$($itemRow.find('#qtySubunits')).bind("change keyup", function() {
                        validateNumber($($itemRow.find('#qtySubunits')));
						updateLineTotal($itemRow);
					});

                    $($itemRow.find('#lineDiscount')).bind("change keyup", function() {
                        updateLineTotal($itemRow);
                    });

                    $($itemRow.find('#lineTotal')).bind("change", function() {

                        validateNumber($($itemRow.find('#lineTotal')));
                        changeLineTotal($itemRow);
                    });

					updateLineTotal($itemRow);





                    var customerID= $('#customerID').val();
                    var itemID = ui.item.item_id;
                    $.ajax({
                        type: "POST",
                        url: '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/get/getItemPurchasePrices.php',
                        data: {
                            'customerID':customerID,
                            'itemID':itemID
                        },
                        dataType:"json",

                        success: function (result) {

                            var options = $itemRow.find('#priceCode');
                            $itemRow.find('#priceCode').find('option').remove();
                            $.each(result, function() {

                                options.append($("<option />").val(this.priceTypeID).text(this.priceCode).attr("data-price",this.price));
                            });
                            var newPrice= $($itemRow.find('#priceCode option:selected')).attr("data-price");
                            $itemRow.find('#unitPrice').val(newPrice);
                            updateLineTotal($itemRow);

                        }
                    });


                    $.ajax({
                        type: "POST",
                        url: '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/get/getItemStock.php',
                        data: {
                            'itemID':itemID
                        },

                        success: function (result) {


                          $itemRow.find('#qtyUnits').attr("data-content",result);
                            $itemRow.find('#qty').attr("data-content",result);

                        }
                    });

                    $.ajax({
                        type: "POST",
                        url: '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/get/getLastPrices.php',
                        data: {
                            'itemID':itemID,
                            'customerID':customerID
                        },

                        success: function (result) {



                            $itemRow.find('#unitPrice').attr("data-content",result);
                            if(ui.item.subunits != 1)
                            {
                                $itemRow.find('#unitsDiv').hide();
                                $itemRow.find('#subunitsDiv').show();
                                $itemRow.find('#waybillItemNotes').focus();
                            }
                            else
                            {
                                $itemRow.find('#unitsDiv').show();
                                $itemRow.find('#subunitsDiv').hide();
                                $itemRow.find('#waybillItemNotes').focus();
                            }

                        }
                    });

					return false;
				}
			});
		}

        function validateNumber(element)
        {
            if(!element.val())
            {

                element.css('color','red');
            }
            else{
                element.css('color','black');
            }
        }

		function addNewLine()
		{
			$lastTr = $('tr:last', $('#datatable_fixed_column'));
			$lastTd = $('td:last', $lastTr);
			$newTr = $lastTr.clone();
			$lastTr.after($newTr);
			$newTr.find("input").val("");
			$newTr.find("textarea").text("");
			$newTr.find("label").text("");
            $i = $newTr.find("td.index").text();
            $i++;
            $newTr.find("td.index").text($i);

            $newTr.find('#itemDetails').prop( "disabled", true );
            $newTr.find('#unitPrice').prop( "disabled", true );
            $newTr.find('#priceCode').prop( "disabled", true );
            $newTr.find('#lineDiscount').prop( "disabled", true );
            $newTr.find('#qty').prop( "disabled", true );
            $newTr.find('#lineTotal').prop( "disabled", true );
            $newTr.find('#qtyUnits').prop( "disabled", true );
            $newTr.find('#qtySubunits').prop( "disabled", true );
            $newTr.find('#waybillItemNotes').prop( "disabled", true );


			$( ".deletRowButton" ).click(function() {
				deleteRow(this);
			});

            initAutocomplete();

		}

		function deleteRow(row)
		{
			var rowCount = $('#datatable_fixed_column tr').length;

			if (rowCount > 2) {
				$(row).parents('tr').remove();
			}
            updateTrNumbering();
            updateTotals();
		}



        function saveInvoice()
        {
            $("#saveButton").attr("disabled", true);
            var invoiceID =$('#invoiceID').val();
            var invoiceCode =$('#invoiceNumber').val();
            var customerID= $('#customerID').val();
            var deliveryAddress = $('#deliveryAddress').val();
            var billingAddress = $('#billingAddress').val();
            var invoiceType = $('#invoiceType').val();
            var invoiceDate = $('#invoiceDate').val();
            var dueDate = $('#dueDate').val();
            var orderID=$('#order_id').val();
            var paymentMethod = $('#paymentMethod').val();
            var salespersonSearch = $('#salespersonID').val();
            var warehouseSearch = $('#warehouseID').val();
            var serviceCallID=$('#serviceCallID').val();

            var details = $('#details').val();
            var invoiceItems = $('#datatable_fixed_column').tableToJSON(
                {
                    ignoreColumns: [0,1],
                    textExtractor : {
                        0 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        1 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        2 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        3 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        4 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        5 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        6 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        7 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        8 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        9 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        10: function(cellIndex, $cell) {
                            return $cell.find('#priceCode').val();
                        },
                        11: function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        12: function(cellIndex, $cell) {

                          var subUnitsValue=  $cell.find('#subUnits').val();
                            if(subUnitsValue==1) {
                                return $cell.find('#qty').val();
                            }
                            else
                            {
                                var qtySub = parseInt($cell.find('#qtyUnits').val());
                                var qtySubUnits =parseInt($cell.find('#qtySubunits').val());
                                return subUnitsValue*qtySub +qtySubUnits;
                            }
                        },
                        13: function(cellIndex, $cell) {
                            return $cell.find('label').text();
                        },
                        14: function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        15: function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        16: function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        }
                        <?php
                        $custTableLine = new CustomTable('Purchase_Invoice_Item');
                        echo $custTableLine->embedCustomTableAsLines(17)->jsonLines;

                        ?>
                    },
                    ignoreHiddenRows: false,
                    ignoreEmptyRows: false
                }
            );

            var subtotal= $('#subtotal').text();
            var discount = $('#discount').val();
            var vatTotal = $('#vatTotal').text();
            var grandTotal = $('#grandTotal').text();

            subtotal = subtotal.replaceAll(',', '');
            discount = discount.replaceAll(',', '');
            vatTotal = vatTotal.replaceAll(',', '');
            grandTotal = grandTotal.replaceAll(',', '');

            var run=true;

            <?php
            $custForm->declareJsonVariables();
            $custTable->declareCustomTableJsonVariables();
            ?>

            if(!customerID || !invoiceDate|| !salespersonSearch||!warehouseSearch||grandTotal<=0)
            {
                run=false;

            }


           if(run) {
               $.ajax({
                   type: "POST",

                   <?php
                   if($edit)
                   {
                    echo "url: '//" . HTML_PATH . "/cop/backend/core/controllers/edit/edit_purchase_invoice.php',";
                   }
                  else
                  {
                    echo "url: '//" . HTML_PATH . "/cop/backend/core/controllers/add/add_purchase_invoice.php',";
                  }
                  ?>
                   data: {
                       'invoiceCode': invoiceCode,
                       'invoiceID': invoiceID,
                       'customerID': customerID,
                       'deliveryAddress': deliveryAddress,
                       'billingAddress': billingAddress,
                       'invoiceType': invoiceType,
                       'invoiceDate': invoiceDate,
                       'dueDate': dueDate,
                       'details': details,
                       'paymentMethod': paymentMethod,
                       'salespersonSearch': salespersonSearch,
                       'warehouseSearch': warehouseSearch,
                       'invoiceItems': invoiceItems,
                       'subtotal': subtotal,
                       'discount': discount,
                       'vatTotal': vatTotal,
                       'serviceCallID':serviceCallID,
                       'orderID':orderID,
                       'grandTotal': grandTotal
                       <?php
                       $custForm->passJsonVariables();
                       $custTable->passCustomTableJsonVariables();
                       ?>
                   },

                   success: function (result) {
                       if(result.localeCompare('error')===0){
                           $.smallBox({
                               title: "Warning!",
                               content: "Something Went Wrong Please Try again.",
                               color: '#b22222',
                               timeout: 3000,
                               icon: "fa fa-user swing animated"
                           });
                           $("#saveButton").attr("disabled", false);
                       } else {
                           $.smallBox({
                               title: "Success!",
                               content: "Invoice successfully entered",
                               color: "#739E73",
                               timeout: 3000,
                               icon: "fa fa-user swing animated"
                           });

                           window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/core/views/addedit/create_purchase_invoice.php?invoice_id=" + result);
                       }
                   }

               });

           }
            else
           {
               $.smallBox({
                   title: "Error!",
                   content: "Please complete invoice data",
                   color: "#b22222",
                   timeout: 3000,
                   icon: "fa fa-user swing animated"
               });
               $("#saveButton").attr("disabled", false);
           }





            //	alert(JSON.stringify(addresses));

            //	alert(JSON.stringify(contractPrices));
        }
        function saveDraft()
        {
            $("#saveButton").attr("disabled", true);
            $("#saveDraftButton").attr("disabled", true);
            var invoiceID =$('#invoiceID').val();
            var invoiceCode =$('#invoiceNumber').val();
            var customerID= $('#customerID').val();
            var deliveryAddress = $('#deliveryAddress').val();
            var billingAddress = $('#billingAddress').val();
            var invoiceType = $('#invoiceType').val();
            var invoiceDate = $('#invoiceDate').val();
            var dueDate = $('#dueDate').val();
            var paymentMethod = $('#paymentMethod').val();
            var salespersonSearch = $('#salespersonID').val();
            var warehouseSearch = $('#warehouseID').val();
            var serviceCallID=$('#serviceCallID').val();

            var details = $('#details').val();
            var invoiceItems = $('#datatable_fixed_column').tableToJSON(
                {
                    ignoreColumns: [0,1],
                    textExtractor : {
                        0 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        1 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        2 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        3 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        4 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        5 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        6 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        7 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        8 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        9 : function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        10: function(cellIndex, $cell) {
                            return $cell.find('#priceCode').val();
                        },
                        11: function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        12: function(cellIndex, $cell) {

                          var subUnitsValue=  $cell.find('#subUnits').val();
                            if(subUnitsValue==1) {
                                return $cell.find('#qty').val();
                            }
                            else
                            {
                                var qtySub = parseInt($cell.find('#qtyUnits').val());
                                var qtySubUnits =parseInt($cell.find('#qtySubunits').val());
                                return subUnitsValue*qtySub +qtySubUnits;
                            }
                        },
                        13: function(cellIndex, $cell) {
                            return $cell.find('label').text();
                        },
                        14: function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        15: function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        },
                        16: function(cellIndex, $cell) {
                            return $cell.find('input').val();
                        }
                    },
                    ignoreHiddenRows: false,
                    ignoreEmptyRows: false
                }
            );

            var subtotal= $('#subtotal').text();
            var discount = $('#discount').val();
            var vatTotal = $('#vatTotal').text();
            var grandTotal = $('#grandTotal').text();

            subtotal = subtotal.replaceAll(',', '');
            discount = discount.replaceAll(',', '');
            vatTotal = vatTotal.replaceAll(',', '');
            grandTotal = grandTotal.replaceAll(',', '');

            var run=true;

            <?php
            $custForm->declareJsonVariables();
            ?>

            // if(!customerID || !invoiceDate|| !salespersonSearch||!warehouseSearch||grandTotal<=0)
            // {
            //     run=false;
            //
            // }


           if(run) {
               $.ajax({
                   type: "POST",

                   <?php

                    echo "url: '//" . HTML_PATH . "/cop/backend/core/controllers/add/add_invoice_draft.php',";

                  ?>
                   data: {
                       'invoiceCode': invoiceCode,
                       'invoiceID': invoiceID,
                       'customerID': customerID,
                       'deliveryAddress': deliveryAddress,
                       'billingAddress': billingAddress,
                       'invoiceType': invoiceType,
                       'invoiceDate': invoiceDate,
                       'dueDate': dueDate,
                       'details': details,
                       'paymentMethod': paymentMethod,
                       'salespersonSearch': salespersonSearch,
                       'warehouseSearch': warehouseSearch,
                       'invoiceItems': invoiceItems,
                       'subtotal': subtotal,
                       'discount': discount,
                       'vatTotal': vatTotal,
                       'serviceCallID':serviceCallID,
                       'grandTotal': grandTotal
                       <?php
                       $custForm->passJsonVariables();
                       ?>
                   },

                   success: function (result) {
                       $.smallBox({
                           title: "Success!",
                           content: "Draft Saved",
                           color: "#809a00",
                           timeout: 3000,
                           icon: "fa fa-user swing animated"
                       });

                       window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/core/views/addedit/create_invoice.php?draft_invoice_id=" + result);
                   }

               });

           }
            else
           {
               $.smallBox({
                   title: "Error!",
                   content: "Please complete invoice data",
                   color: "#b22222",
                   timeout: 3000,
                   icon: "fa fa-user swing animated"
               });
               $("#saveButton").attr("disabled", false);
               $("#saveDraftButton").attr("disabled", false);
           }





            //	alert(JSON.stringify(addresses));

            //	alert(JSON.stringify(contractPrices));
        }

        <?php if($includeScLink){echo $scLink->linkScFunction();} ?>

		$(document).ready(function() {
			
			pageSetUp();

            <?php
            if(strcmp(strtolower($status),'canceled')==0 || strcmp(strtolower($status),'cancelled')==0){
                echo '$("#main :input").attr("disabled", true);';
                echo '$("#main").css("background-color", "#F3CFC6");';
                echo '$("#newLineButton").attr("disabled", true);';
            }

            ?>

            <?php if($includeScLink){echo $scLink->initScDataTable();} ?>

            var edit = <?php if($edit){
            echo "true";
            }
            else
            {
            echo "false";

            }?>;


            var convertFromOrder = <?php if($convertFromOrder){
                echo "true";
            }
            else
            {
                echo "false";

            }?>;

            var draft = <?php if($draft){
                echo "true";
            }
            else
            {
                echo "false";

            }?>;
            $('#discount').bind("change keyup", function() {
                addGlobalDiscount();
            });

			$('#datatable_fixed_column').on('keydown', 'input', function (e) {
				var keyCode = e.keyCode;
				if (keyCode !== 9) return;
				var $this = $(this),
					$lastTr = $('tr:last', $('#datatable_fixed_column')),
					$lastTd = $('td:last', $lastTr);
				if (($(e.target).closest('td')).is($lastTd)) {
					$newTr = $lastTr.clone();
					$lastTr.after($newTr);
					$newTr.find("input").val("");
					$newTr.find("textarea").text("");
					$newTr.find("label").text("");
                    $i = $newTr.find("td.index").text();
                    $i++;
                    $newTr.find("td.index").text($i);

                    $newTr.find('#itemDetails').prop( "disabled", true );
                    $newTr.find('#unitPrice').prop( "disabled", true );
                    $newTr.find('#priceCode').prop( "disabled", true );
                    $newTr.find('#lineDiscount').prop( "disabled", true );
                    $newTr.find('#qty').prop( "disabled", true );
                    $newTr.find('#lineTotal').prop( "disabled", true );
                    $newTr.find('#qtyUnits').prop( "disabled", true );
                    $newTr.find('#qtySubunits').prop( "disabled", true );

					initAutocomplete();
					$( ".deletRowButton" ).click(function() {
						deleteRow(this);
					});
				}
			});

            $('#datatable_fixed_column').on('keydown', 'input', function (e) {
                var keyCode = e.keyCode;
                if (keyCode !== 13) return;
                var $this = $(this);

                var $thisTd = $(e.target).closest('tr');
                $lastTd = $('td:last', $thisTd);

                if (($(e.target).closest('td')).is($lastTd)) {
                    $newTr = $thisTd.clone();
                    $thisTd.after($newTr);
                    $newTr.find("input").val("");
                    $newTr.find("textarea").text("");
                    $newTr.find("label").text("");
                    $i = $newTr.find("td.index").text();
                    $i++;
                    $newTr.find("td.index").text($i);

                    $newTr.find('#itemDetails').prop( "disabled", true );
                    $newTr.find('#unitPrice').prop( "disabled", true );
                    $newTr.find('#priceCode').prop( "disabled", true );
                    $newTr.find('#lineDiscount').prop( "disabled", true );
                    $newTr.find('#qty').prop( "disabled", true );
                    $newTr.find('#lineTotal').prop( "disabled", true );
                    $newTr.find('#qtyUnits').prop( "disabled", true );
                    $newTr.find('#qtySubunits').prop( "disabled", true );

                    initAutocomplete();
                    $(".deletRowButton").click(function () {
                        deleteRow(this);
                    });
                }
                updateTrNumbering();

            });

			$( "#newLineButton" ).click(function() {
				addNewLine();
			});

			$( ".deletRowButton" ).click(function() {
				deleteRow(this);
			});

            initAutocomplete();
            initCustomerCodeAutocomplete();
            initSalepersonCodeAutocomplete();
            initWarehouseCodeAutocomplete();
            var fixHelperModified = function(e, tr) {
                    var $originals = tr.children();
                    var $helper = tr.clone();
                    $helper.children().each(function(tr) {
                        $(this).width($originals.eq(tr).width())
                    });
                    return $helper;
                },
                updateIndex = function(e, ui) {
                    $('td.index', ui.item.parent()).each(function (i) {
                        $(this).text(i + 1);
                    });
                };

            $("#datatable_fixed_column tbody").sortable({
                helper: fixHelperModified,
                stop: updateIndex
            });

            if(edit || convertFromOrder || draft) {
                $('#datatable_fixed_column tr').each(function (i, row) {

                    // reference all the stuff you need first
                    var $itemRow = $(row);
                    $($itemRow.find('#priceCode')).bind("change keyup", function () {

                        var newPrice = $($itemRow.find('#priceCode option:selected')).attr("data-price");

                        $itemRow.find('#unitPrice').val(newPrice);
                        updateLineTotal($itemRow);
                    });

                    $($itemRow.find('#unitPrice')).bind("change keyup", function () {
                        validateNumber($($itemRow.find('#unitPrice')));
                        updateLineTotal($itemRow);
                    });

                    $($itemRow.find('#qty')).bind("change keyup", function () {
                        validateNumber($($itemRow.find('#qty')));
                        updateLineTotal($itemRow);
                    });
                    $($itemRow.find('#qtyUnits')).bind("change keyup", function () {
                        validateNumber($($itemRow.find('#qtyUnits')));
                        updateLineTotal($itemRow);
                    });
                    $($itemRow.find('#qtySubunits')).bind("change keyup", function () {
                        validateNumber($($itemRow.find('#qtySubunits')));
                        updateLineTotal($itemRow);
                    });

                    $($itemRow.find('#lineDiscount')).bind("change keyup", function () {
                        updateLineTotal($itemRow);
                    });

                    $($itemRow.find('#lineTotal')).bind("change", function () {
                        validateNumber($($itemRow.find('#lineTotal')));
                        changeLineTotal($itemRow);
                    });




                });


            }
        })

		</script>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>
