<?php
class FtpClient
{


    public $ftpIP;
    public $ftpUserName;
    public $ftpPassword;
    public $directoriesArray = array();
    public $ftpConnection;


    public function getFtpIP()
    {
        return $this->ftpIP;
    }

    public function getFtpUserName()
    {
        return $this->ftpUserName;
    }

    public function getFtpPassword()
    {
        return $this->ftpPassword;
    }

    public function getDirectoriesArray()
    {
        return $this->directoriesArray;
    }


    public function __construct($ftpIP, $ftpUserName, $ftpPassword)
    {
        $this->ftpIP = $ftpIP;
        $this->ftpUserName = $ftpUserName;
        $this->ftpPassword = $ftpPassword;
    }

    public function startConnection(){

        $ftpConn = ftp_connect($this->ftpIP);
        $login = ftp_login($ftpConn,$this->ftpUserName,$this->ftpPassword);

        if ((!$ftpConn) || (!$login)) {
            echo 'FTP connection has failed! Attempted to connect to '. $this->ftpIP. ' with user '.$this->ftpUserName.'.';
            $this->ftpConnection = false;
        } else{
            echo 'FTP connection Established.';
            $directory = ftp_nlist($ftpConn,'');
            $this->directoriesArray = $directory;
            $this->ftpConnection = $ftpConn;
        }

    }

    public function removeOldFilesFromDirectory($directory){
        $files = glob($directory."/*"); // get all file names
        foreach($files as $file){ // iterate files
            if(is_file($file)) {
                unlink($file); // delete file
            }
        }
        echo "<br>Local Directory ($directory) Cleared";
    }

    public function getFilesFromDirectory($directory,$fileContains='',$replaceFilesInDirectory = false,$localDirectorySubFolders=''){
        if(strcmp(trim($localDirectorySubFolders),'')!=0){$localDirectorySubFolders.='/';}
        if($replaceFilesInDirectory){
            if(file_exists("./".$localDirectorySubFolders.$directory)) {
                $this->removeOldFilesFromDirectory($localDirectorySubFolders . $directory);
            }
        }

        $directoryFiles = ftp_nlist($this->ftpConnection,$directory."/");
        foreach ($directoryFiles as $file)
        {
            if(strcmp($fileContains,'')!=0){
                if(strpos($file, $fileContains) !== false) {

                    $localDirectory = "./".$localDirectorySubFolders.dirname("$file");

                    if(!file_exists($localDirectory)){
                        if (!mkdir($localDirectory, 0777, true)) {
                            die('Failed to create directories...');
                        } else {
                            echo "<br>Directory $localDirectory Created.";
                        }
                    }

                    if (ftp_get($this->ftpConnection, $localDirectory.'/'.basename($file), $file, FTP_BINARY)) {
                        echo "<br>$file Successfully written in directory $localDirectory.";
                    } else {
                        echo "<br>$file ERROR: There was a problem with writing File.";
                    }
                }
            } else {

            }

        }

    }

    public function endConnection(){
        if(!$this->ftpConnection) {
            ftp_close($this->ftpConnection);
        }
        echo "<br>FTP Connection Closed.<br>";
    }

    public function displayValue($value){
        echo "<pre>";
        var_dump($value);
        echo "</pre>";
    }

}

?>