<?php
//$from_email = "info@coprime.co", $from_name = "Coprime Cloud"
include_once '../../../param.php';

//include_once ROOT.'b2b/emailer/PHPMailer/Exception.php';
//include_once ROOT.'b2b/emailer/PHPMailer/PHPMailer.php';
//include_once ROOT.'b2b/emailer/PHPMailer/SMTP.php';

include_once(ROOT . "libs/emailer/PHPMailer8/vendor/autoload.php");

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class CopMailer
{
    private $email_from;
    private $from_name;
    private $email_to;
    private $email_cc;
    private $email_bcc;
    private $email_action;
    private $email_action_code;
    private $attachment_path;
    private $email_content;
    private $email_subject;
    private $log_email;
    private $block_email_send;

    function setEmailFrom($email){$this->email_from = $email;}
    function setFromName($companyName){$this->from_name = $companyName;}
    function setEmailTo($email){$this->email_to = $email;}
    function setEmailCc($comma_separated_emails){$this->email_cc = $comma_separated_emails;}
    function setEmailBcc($comma_separated_emails){$this->email_bcc = $comma_separated_emails;}
    function setEmailAction($action){$this->email_action = $action;}
    function setActionDocumentCode($documentCode){$this->email_action_code = $documentCode;}
    function setAttachmentPath($filePath){$this->attachment_path = $filePath;}
    function setEmailContent($emailContent){$this->email_content = $emailContent;}
    function setEmailSubject($emailSubject){$this->email_subject = $emailSubject;}
    function setInsertDbRecord($True_False){$this->log_email = $True_False;}
    function setBlockEmailSend($True_False){$this->block_email_send = $True_False;}

    public function __construct($emailFrom, $fromName){
        $this->setEmailFrom($emailFrom);
        $this->setFromName($fromName);
        $this->setInsertDbRecord(false);
        $this->setBlockEmailSend(false);
        error_reporting(E_ERROR);

    }

    public function sendEmailWithAttachment($emailTo='',$emailSubject='',$emailContent='',$filePath=''){
        if(strcmp($emailTo,'')==0){$emailTo = $this->email_to;}
        if(strcmp($emailSubject,'')==0){$emailSubject = $this->email_subject;}
        if(strcmp($emailContent,'')==0){$emailContent = $this->email_content;}
        if(strcmp($filePath,'')==0){$filePath = $this->attachment_path;}

        if($this->block_email_send){
            echo " --Email Blocked-- <br>";
        } else {
            $this->sendEmailAttachment($this->email_from, $emailTo, $this->from_name, $emailSubject, $filePath, $emailContent);
            $this->addRecordToEmailDocument(basename($filePath), $action = 'Attachment', $emailTo);
        }

    }

    public function sendSimpleEmail($emailTo='',$emailSubject='',$emailContent=''){
        if(strcmp($emailTo,'')==0){$emailTo = $this->email_to;}
        if(strcmp($emailSubject,'')==0){$emailSubject = $this->email_subject;}
        if(strcmp($emailContent,'')==0){$emailContent = $this->email_content;}
        $filePath = "No Attachment";
        if($this->block_email_send){
            echo " --Email Blocked-- <br>";
        } else {
            $this->sendEmailAttachment($this->email_from, $emailTo, $this->from_name, $emailSubject, $filePath, $emailContent, false);
            $this->addRecordToEmailDocument($filePath= "Simple Mail (No Attachment)", $action = 'Attachment', $emailTo);
        }

    }

    public function sendSMTPEmail($emailHost='',$emailUsername='',$emailPassword='',$emailTo='',$emailSubject='',$emailContent=''){
        if(strcmp($emailTo,'')==0){$emailTo = $this->email_to;}
        if(strcmp($emailSubject,'')==0){$emailSubject = $this->email_subject;}
        if(strcmp($emailContent,'')==0){$emailContent = $this->email_content;}
        $filePath = "No Attachment";
        if($this->block_email_send){
            echo " --Email Blocked-- <br>";
        } else {
            $this->sendSMTPAttachment($emailHost,$emailUsername,$emailPassword,$this->email_from, $emailTo, $this->from_name, $emailSubject, $filePath, $emailContent,$this->email_cc, false);
            $this->addRecordToEmailDocument($filePath= "Simple Mail (No Attachment)", $action = 'Attachment', $emailTo);
        }

    }

    public function sendEmailWithAttachmentFromAction($to_email='', $action='', $actionCode = '', $filePath = '', $message = '',$subject='', $from_email = "", $from_name = "")
    {
        if(strcmp($to_email,'')==0){$to_email = $this->email_to;}
        if(strcmp($action,'')==0){$action = $this->email_action;}
        if(strcmp($actionCode,'')==0){$actionCode = $this->email_action_code;}
        if(strcmp($message,'')==0){$message = $this->email_content;}
        if(strcmp($filePath,'')==0){$filePath = $this->attachment_path;}
        if(strcmp($from_email,'')==0){$from_email = $this->email_from;}
        if(strcmp($from_name,'')==0){$from_name = $this->from_name;}
        if(strcmp($subject,'')==0){$subject = $this->email_subject;}

        if (strcmp($filePath, '') != 0) {
            $this->attachment_path = $filePath;
            $attachment = $filePath;
            $actionCode = basename($filePath);
            $actionCode = str_replace($action, '', $actionCode);
            $actionCode = str_replace('.pdf', '', $actionCode);
            $this->email_action_code = $actionCode;
        } else {
            $dirOfPDF =  ROOT."media/pdfs/" . strtolower($action) . "s/";
            $attachment = $dirOfPDF . $action . $actionCode . ".pdf";
            $this->attachment_path = $dirOfPDF.$attachment;
            $this->email_action_code = $actionCode;
        }

        $action = ucfirst(strtolower(rtrim($action, 's')));
        if(strcmp($subject,'')==0) {
            $subject = "New $action from Tablet";
        }

        if($this->block_email_send){
            echo " --Email Blocked-- <br>";
        } else {
            $this->sendEmailAttachment($from_email, $to_email, $from_name, $subject, $attachment, $message);
            $this->addRecordToEmailDocument($actionCode, $action, $to_email);
        }
    }

    private function sendSMTPAttachment($emailHost,$emailUsername,$emailPassword,$fromEmail, $to, $fromName, $subject, $file, $htmlContent,$ccEmail, $hasAttachment = true)
    {
        if (strcmp($to, '') != 0 && file_exists($file) || !$hasAttachment) {
            $message = "$htmlContent<br><br>";


            $mail = new PHPMailer(true);
            $mail->SMTPDebug = 0;                                 // Enable verbose debug output
            $mail->isSMTP();                                      // Set mailer to use SMTP
            $mail->Host = $emailHost;  // Specify main and backup SMTP servers
            $mail->SMTPAuth = true;                               // Enable SMTP authentication
            $mail->Username = $emailUsername;                 // SMTP username
            $mail->Password = $emailPassword;                           // SMTP password
            $mail->SMTPSecure = 'tls';                            // Enable TLS encryption, `ssl` also accepted
            $mail->Port = 587;                                    // TCP port to connect to
            $mail->setFrom($fromEmail, $fromName);
            $mail->addAddress($to, $to);
            if(strcmp($ccEmail,'')!=0) {
                $mail->addCC($ccEmail);
            }
            $mail->CharSet = 'UTF-8';
            $mail->Encoding = "base64";
            $mail->isHTML(true);                                  // Set email format to HTML
            $mail->Subject = $subject;
            $mail->Body = $message;
            $mail->AltBody = $message;



            if ($mail->send()) {
                echo "mail send to $to... OK<br>";
            } else {
                $errorMessage = error_get_last()['message'];
                echo "mail send to $to... ERROR : $errorMessage<br>";
            }
        } else {
            echo "File not found $file <br>";
        }
    }

    private function sendEmailAttachment($from, $to, $fromName, $subject, $file, $htmlContent, $hasAttachment = true)
    {
        if (strcmp($to, '') != 0 && file_exists($file) || !$hasAttachment) {
            $message = "$htmlContent<br><br>";
//            $message .= "---This is an automatic notice.There is no need to reply to this email.---";

            $separator = md5(time());

// carriage return type (we use a PHP end of line constant)
            $eol = PHP_EOL;

// attachment name
            $filename = basename($file);

//$pdfdoc is PDF generated by FPDF
            $file_size = filesize($file);
            $handle = fopen($file, "r");
            $content = fread($handle, $file_size);
            fclose($handle);
            $content = chunk_split(base64_encode($content));

// main header
            $header = "From: " . $fromName . " <" . $from . ">\r\n";
            $header .= "Reply-To: " . $to . "\r\n";
            if(strcmp($this->email_cc,'')!=0){
                $header .= "Cc : $this->email_cc \r\n" ;  // comma saparated emails
            }
            if(strcmp($this->email_bcc,'')!=0) {
                $header .= "Bcc :  $this->email_bcc \r\n"; // comma saparated emails
            }
            $header .= "MIME-Version: 1.0\r\n";
            if($hasAttachment) {
                $header .= "Content-Type: multipart/mixed; boundary=\"" . $separator . "\"\r\n";
                // $header .= "This is a multi-part message in MIME format.\r\n";
                $mailMessage .= "--" . $separator . "\r\n";
                $mailMessage .= "Content-type:text/html; charset=UTF-8\r\n";
                $mailMessage .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
                $mailMessage .= $message . "\r\n\r\n";
            } else {
                $header .= "Content-type:text/html; charset=UTF-8\r\n";
                $header .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
                $mailMessage .= $message . "\r\n\r\n";
            }
            if($hasAttachment) {
                $mailMessage .= "--" . $separator . "\r\n";
                $mailMessage .= "Content-Type: application/octet-stream; name=\"" . $filename . "\"\r\n"; // use different content types here
                $mailMessage .= "Content-Transfer-Encoding: base64\r\n";
                $mailMessage .= "Content-Disposition: attachment; filename=\"" . $filename . "\"\r\n\r\n";
                $mailMessage .= $content . "\r\n\r\n";
            }


// send message
            if (mail($to, $subject, $mailMessage, $header)) {
                echo "mail send to $to... OK<br>";
            } else {
                $errorMessage = error_get_last()['message'];
                echo "mail send to $to... ERROR : $errorMessage<br>";
            }
        } else {
            echo "File not found $file <br>";
        }
    }

    public function addRecordToEmailDocument($documentCode,$documentType,$email){

        if($this->log_email) {

            $table = $documentType . 's';
            $tableID = strtolower($documentType) . "_id";
            $tableCode = strtolower($documentType) . "_code";

            global $username, $password, $database;
            $db = new mysqli(localhost, $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }

            if (strcmp(trim($documentType), 'Attachment') == 0) {
                $documentID = 0;
                $db->set_charset("utf8");
                $mailStmt = $db->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                $mailStmt->bind_param('isss', $documentID, $documentCode, $documentType, $email);
                $mailStmt->execute();
                $mailStmt->close();
            } else {
                $mailStm = $db->prepare("SELECT $tableID FROM $table WHERE $tableCode='$documentCode' LIMIT 1");
                $mailStm->execute();
                $mailStm->bind_result($documentID);
                while ($mailStm->fetch()) {
                }
                $mailStm->close();

                if ($documentID > 0) {
                    $db->set_charset("utf8");
                    $mailStmt = $db->prepare("INSERT INTO Document_Email (document_id,document_code,document_type,email,timestamp) VALUES(?,?,?,?,NOW())");
                    $mailStmt->bind_param('isss', $documentID, $documentCode, $table, $email);
                    $mailStmt->execute();
                    $mailStmt->close();
                }
            }
        }
    }

    public function disableDuplicateActionEmails(){

        $now        = date('Y-m-d');
        $documentDate = date('Y-m-d');
        $table      = $this->email_action."s";
        $tableID    = strtolower($this->email_action)."_id";
        $tableCode  = strtolower($this->email_action)."_code";
        $documentCode = $this->email_action_code;

        global $username, $password, $database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $counter=0;
        $mailStm = $db->prepare("SELECT $tableID, DATE(timestamp) FROM $table WHERE $tableCode='$documentCode' ORDER BY timestamp DESC LIMIT 1");
        $mailStm->execute();
        $mailStm->bind_result($documentID,$documentDate);
        while ($mailStm->fetch()) { }
        $mailStm->close();



        $mailStm = $db->prepare("SELECT COUNT(id) FROM Document_Email WHERE document_code='$documentCode' AND document_id='$documentID' AND document_type='$table' LIMIT 1");
        $mailStm->execute();
        $mailStm->bind_result($counter);
        while ($mailStm->fetch()) {}
        $mailStm->close();

        if($counter>0 || $now > $documentDate){
            if($counter>0){echo $this->email_action." $documentCode Already Sent";}
            else {echo $this->email_action." $documentCode Older than today";}
            $this->setBlockEmailSend(true);
        } else {
            $this->setBlockEmailSend(false);
        }

    }
}




