<?php
class ActionItemList{

    private $db;
    private $action;
    private $actionID;
    private $javascript;
    private $categoryTree;
    private $itemsTable;
    private $modal;
    private $modalID;

    // Getters
    public function getDB(){return $this->db;}
    public function action(){return $this->action;}
    public function actionID(){return $this->actionID;}
    public function categoryTree(){return $this->categoryTree;}
    public function javascript(){return $this->javascript;}
    public function itemsTable(){return $this->itemsTable;}
    public function modal(){return $this->modal;}
    public function modalID(){return $this->modalID;}

    // Setters
    public function setAction($action){$this->action = $action;}
    public function setActionID($actionID){$this->actionID = $actionID;}
    public function setJavascript($javascript){$this->javascript = $javascript;}
    public function setCategoryTree($categoryTree){$this->categoryTree = $categoryTree;}
    public function setItemsTable($itemsTable){$this->itemsTable = $itemsTable;}
    public function setModal($modal){$this->modal = $modal;}
    public function setDB($db){$this->db = $db;}
    public function setModalID($modalID){$this->modalID = $modalID;}

    public function __construct($db,$action,$actionID,$showHiddenCategories=false,$actionLinesTableID='datatable_fixed_column',$vatComboBox=false){

        $this->setDB($db);
        $this->setAction($action);
        $this->setActionID((int)$actionID);


        $this->initModal($showHiddenCategories);
        $this->initJavaScript($actionLinesTableID,$vatComboBox);

    }


    // Modal Functions

    private function initModal($showHiddenCategories){

        $this->setModalID($this->action."_".$this->actionID.'_tree_items_modal');

        $headerID = $this->modalID.'_header';
        $bodyTreeID   = $this->modalID.'_body_tree';
        $bodyItemsID   = $this->modalID.'_body_items';
        $bodyCategoryID = $this->modalID.'_body_selected_category';

        $modal = "
        <!--Modal-->
        <div class='modal fade' id='$this->modalID' tabindex='-1' role='dialog' aria-labelledby='appInfoLabel' aria-hidden='true'>
            <div class='modal-dialog' style='width: 90%;'>
                <div class='modal-content' style='width: 100%;overflow-x: scroll;'>
                    <div class='modal-header'>
                        <button type='button' class='btn btn-default close' data-dismiss='modal' aria-hidden='true'>Close</button>
                            <h4 class='modal-title label-bold font-lg' style='margin-left:10px;' id='$headerID'></h4>
                    </div>
                    <table style='width: 100%;'>
                        <tr>
                            <td style='text-align: left !important;vertical-align: top !important;width: fit-content;white-space: nowrap;'>
                                <div class='modal-body no-padding' id='$bodyTreeID' style='' data-url='//".HTML_PATH."/cop/backend/core/controllers/get/getCategoriesTreeForActionItemList.php?hiddenCategories=$showHiddenCategories'></div>
                            </td>
                            <td style='vertical-align: top !important;'>
                                <div class='modal-body no-padding' id='$bodyItemsID' style='' >
                                    <input type='hidden' id='$bodyCategoryID'>
                                    <table id='datatable_fixed_column_$bodyItemsID' class='table table-striped table-hover dataTable' width='100%'>
									        <thead>
												<tr>
												     <th class='hasinput' >
													</th>
													<th class='hasinput' >
													</th>
													<th class='hasinput' >														
													</th>
													<th class='hasinput' >
													</th>
													<th class='hasinput' >														
													</th>													
													<th class='hasinput' >
													</th>
												</tr>
									            <tr>
									           	    <th class='text-center'>Image</th>
         									        <th class='text-center'>Item Code</th>
                                                    <th class='text-center'>Name</th>
            									    <th class='text-center'>Item Sku</th>
           										    <th class='text-center'>VAT</th>
            										<th class='text-center'>Actions</th>    
									            </tr>
									        </thead>
									</table>
									                                    
                                </div>
                            </td>
                        </tr>
                    </table>
                    
                    
    
                    <footer class='modal-footer'>
                        <button type='button' class='btn btn-default close' data-dismiss='modal' aria-hidden='true'>Close</button>
                    </footer>
                </div><!--/.modal-content-->
            </div><!--/.modal-dialog-->
        </div><!--/.modal-->
        ";
        $this->setModal($modal);
    }

    // Button Functions

    public function itemListButton($class='btn btn-primary',$text='&nbsp;<i class="fa fa-plus"></i>&nbsp; Add Items&nbsp;'){
        return "<button type='button' class='$class' onclick='$(\"#$this->modalID\").modal(\"toggle\");'>$text</button>";
    }

    // Javascript Functions

    private function initJavaScript($actionLinesTableID,$vatComboBox){

        $headerID = $this->modalID.'_header';
        $bodyTreeID   = $this->modalID.'_body_tree';
        $bodyItemsID   = $this->modalID.'_body_items';
        $bodyCategoryID = $this->modalID.'_body_selected_category';

        $itemNotesID = rtrim(strtolower($this->action),'s').'ItemNotes';

        if($vatComboBox){
            $customizedActions = "
            \$itemRow.find('#vat').val(line.percentage);
            \$itemRow.find('#vat').prop( \"disabled\", false );
            ";

            $customizedActionsInit ="
                $(\$itemRow.find('#vat')).bind(\"change keyup\", function() {
                    var newVat= $(\$itemRow.find('#vat option:selected')).val();
                    \$itemRow.find('#vatPercentage').val(newVat);
                    updateLineTotal(\$itemRow);
                    updateTotals();
                });
            ";
        } else {
            $customizedActions = "\$itemRow.find('#vat').text(line.vatCode);";
            $customizedActionsInit = "";
        }

        $javascript = "
        
        
        <script src='//". HTML_PATH."/cop/backend/themes/". THEME_NAME."/js/DataTables/datatables.js'></script>
        <script src='//". HTML_PATH."/cop/backend/themes/". THEME_NAME."/js/plugin/datatables/dataTables.colVis.min.js'></script>
        <script src='//". HTML_PATH."/cop/backend/themes/". THEME_NAME."/js/plugin/datatables/dataTables.tableTools.min.js'></script>
        <script src='//". HTML_PATH."/cop/backend/themes/". THEME_NAME."/js/plugin/datatables/dataTables.bootstrap.min.js'></script>
        <script src='//". HTML_PATH."/cop/backend/themes/". THEME_NAME."/js/plugin/datatable-responsive/datatables.responsive.min.js'></script>
        <script src='//". HTML_PATH."/cop/backend/themes/". THEME_NAME."/js/plugin/select2/select2.min.js'></script>

        <script src='//". HTML_PATH ."/cop/backend/themes/".THEME_NAME ."/js/qsTree/tree.jquery.js'></script>
        <link rel='stylesheet' href='//". HTML_PATH ."/cop/backend/themes/".THEME_NAME."/js/qsTree/jqtree.css'>
        
        <script type='text/javascript'>
            $('#$headerID').html('Select Category');
            
            var responsiveHelper_datatable_fixed_column = undefined;
		    var breakpointDefinition = {tablet : 1024,phone : 480};
            
            $('#datatable_fixed_column_$bodyItemsID').DataTable({		    	
				\"sDom\": \"<'dt-toolbar'<'col-xs-12 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>\"+
				\"t\"+
				\"<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>\",
				\"autoWidth\" : true,
				\"processing\": false,
                \"serverSide\": true,
                \"ajax\": {
                    \"url\": \"//".HTML_PATH."/cop/backend/core/controllers/get/getProductsForActionItemList.php\",
                    \"data\": function(data){
                            data.category = $('#$bodyCategoryID').val();
                     }
                },
                \"columns\": [
                    { \"data\": \"image\" },
                    { \"data\": \"code\" },
                    { \"data\": \"name\" },
                    { \"data\": \"sku\" },
                    { \"data\": \"vat\" },
                    { \"data\": \"form\" }
                ],
                \"order\": [[ 1, \"asc\" ]],
                \"deferRender\": true,
                \"buttons\": [
                    \"copyHtml5\",
                    \"excelHtml5\",
                    \"csvHtml5\",
                    {
                        extend: 'pdfHtml5',
                        orientation: 'landscape',
                        pageSize: 'LEGAL'
                    }
                ],
                \"preDrawCallback\" : function() {

                if (!responsiveHelper_datatable_fixed_column) {
                responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($(this), breakpointDefinition);
                }
                },
                \"rowCallback\" : function(nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
                },
                \"drawCallback\" : function(oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
                }
            });
                
            
            $(\"#datatable_fixed_column_$bodyItemsID thead th input[type=text]\").on( 'keyup change', function () {
                
               
                $(\"#datatable_fixed_column_$bodyItemsID\").DataTable()
                    .column($(this).parent().index() + ':visible')
                    .search(this.value)
                    .draw();
                
                
            });

            
            $('#$bodyTreeID').tree({

					dragAndDrop: false,
					autoOpen: false,
					saveState: false,
					onCreateLi: function(node, \$li) {

						\$li.find('.jqtree-element').css('font-weight','bold');
						\$li.find('.jqtree-element').css('font-size','16px');
						\$li.find('.jqtree-element').css('color','black');
						\$li.find('.jqtree-element').parent().css('padding','10px');
						\$li.find('.jqtree-element').parent().css('box-shadow','rgba(0, 0, 0, 0.1) 0px 0px 5px 0px, rgba(0, 0, 0, 0.1) 0px 0px 1px 0px');

						\$li.find('.jqtree-element').click(function(){selectActionItemList".$this->modalID."Category(node.id,node.name);});
                    }
            });
            
            function selectActionItemList".$this->modalID."Category(category,name){
                $('#$headerID').html(name);
                $('#$bodyCategoryID').val(category);
                $('#datatable_fixed_column_$bodyItemsID').DataTable().draw();
            }
            
            function addListItemLine(item){
                $('.ActionItemListButton').prop( \"disabled\", true );
                $.ajax({
                    type:\"POST\",
                    url: '//".HTML_PATH."/cop/backend/core/controllers/get/getSelectedItemForActionItemList.php',
                    data: {'item':item },
                    success:function(result){
                        
                        var line = JSON.parse(result)[0];
                        
                        
                        $('#$actionLinesTableID tr').each(function (i, row) {
                        
                            var rowCount = $('#$actionLinesTableID tr').length;
                            var existingItem = $($(row).find('#itemCode')).val(); 
                            
                            if(i > 1 && rowCount > 1 && existingItem.localeCompare('')===0){
                                $(row).remove();
                            }
                            
                        });
                        
                        addNewLine();
                        
                        $('#$actionLinesTableID tr:eq(1)').each(function (i, row) {
                        
                            var rowCount = $('#$actionLinesTableID tr').length;
                            var existingItem = $(row).find('#itemCode').val(); 
                                                        
                            if(rowCount > 2 && existingItem.localeCompare('')===0){
                                $(row).remove();
                            }
                        });
                        
                        
                        updateTrNumbering();

                        \$itemRow = $('tr:last', $('#$actionLinesTableID'));
                        
                        \$itemRow.find('#itemID').val(line.item_id); // Hidden input on form
                        \$itemRow.find('#itemCode').val(line.item_code);
                        \$itemRow.find('#itemDetails').val(line.name);
                        \$itemRow.find('#unitPrice').val(line.price);
                        \$itemRow.find('#subUnits').val(line.subunits);
                        \$itemRow.find('#vatPercentage').val(line.percentage);
                        \$itemRow.find('#qty').val(1);
                        \$itemRow.find('#qtyUnits').val(1);
                        
                        
                        
                        \$itemRow.find('#itemDetails').prop( \"disabled\", false );
                        \$itemRow.find('#unitPrice').prop( \"disabled\", false );
                        \$itemRow.find('#priceCode').prop( \"disabled\", false );
                        \$itemRow.find('#lineDiscount').prop( \"disabled\", false );
                        \$itemRow.find('#qty').prop( \"disabled\", false );
                        \$itemRow.find('#lineTotal').prop( \"disabled\", false );
                        \$itemRow.find('#qtyUnits').prop( \"disabled\", false );
                        \$itemRow.find('#qtySubunits').prop( \"disabled\", false );
                        \$itemRow.find('#extrasButton').prop( \"disabled\", false );
                        \$itemRow.find('#$itemNotesID').prop( \"disabled\", false );
                        \$itemRow.find('#itemStatus').prop( \"disabled\", false );
                        
                        $customizedActions
        
                        var customerID= $('#customerID').val();
                        var itemID = line.item_id;
                        
                        $.ajax({
                            type: \"POST\",
                            url: '//".HTML_PATH."/cop/backend/core/controllers/get/getItemPrices.php',
                            data: {'customerID':customerID,'itemID':itemID},
                            dataType:\"json\",
                            success: function (result) {
                                
                                var options = \$itemRow.find('#priceCode');
                                \$itemRow.find('#priceCode').find('option').remove();
                                
                                $.each(result, function() { options.append($(\"<option />\").val(this.priceTypeID).text(this.priceCode).attr(\"data-price\",this.price));});
                                    
                                var newPrice= $(\$itemRow.find('#priceCode option:selected')).attr(\"data-price\");
                                \$itemRow.find('#unitPrice').val(newPrice);
                                
                                updateLineTotal(\$itemRow);
                            }
                        });
        
        
                        $.ajax({
                            type: \"POST\",
                            url: '//".HTML_PATH."/cop/backend/core/controllers/get/getItemStock.php',
                            data: {'itemID':itemID},
                            success: function (result) {
                           
                                \$itemRow.find('#qtyUnits').attr(\"data-content\",result);
                                \$itemRow.find('#qty').attr(\"data-content\",result);
                            }
                        });
        
                        $.ajax({
                            type: \"POST\",
                            url: '//".HTML_PATH."/cop/backend/core/controllers/get/getLastPrices.php',
                            data: {'itemID':itemID,'customerID':customerID},
        
                            success: function (result) {
                                
                                \$itemRow.find('#unitPrice').attr(\"data-content\",result);
                                if(line.subunits != 1) {
                                    \$itemRow.find('#unitsDiv').hide();
                                    \$itemRow.find('#subunitsDiv').show();
                                    \$itemRow.find('#unitPrice').focus();
                                } else {
                                    \$itemRow.find('#unitsDiv').show();
                                    \$itemRow.find('#subunitsDiv').hide();
                                    \$itemRow.find('#unitPrice').focus();
                                }
                                $('.ActionItemListButton').prop( \"disabled\", false );
                            }
                            
                        });
                                
                        addNewLine();
                        
                        $('#$actionLinesTableID tr').each(function (i, row) {

                            var \$itemRow = $(row);
                            
                            $customizedActionsInit
                            
                            $(\$itemRow.find('#priceCode')).bind(\"change keyup\", function () {
            
                                var newPrice = $(\$itemRow.find('#priceCode option:selected')).attr(\"data-price\");
            
                                \$itemRow.find('#unitPrice').val(newPrice);
                                updateLineTotal(\$itemRow);
                            });
            
                            $(\$itemRow.find('#unitPrice')).bind(\"change keyup\", function () {
                                validateNumber($(\$itemRow.find('#unitPrice')));
                                updateLineTotal(\$itemRow);
                            });
            
                            $(\$itemRow.find('#qty')).bind(\"change keyup\", function () {
                                validateNumber($(\$itemRow.find('#qty')));
                                updateLineTotal(\$itemRow);
                            });
                            $(\$itemRow.find('#qtyUnits')).bind(\"change keyup\", function () {
                                validateNumber($(\$itemRow.find('#qtyUnits')));
                                updateLineTotal(\$itemRow);
                            });
                            $(\$itemRow.find('#qtySubunits')).bind(\"change keyup\", function () {
                                validateNumber($(\$itemRow.find('#qtySubunits')));
                                updateLineTotal(\$itemRow);
                            });
            
                            $(\$itemRow.find('#lineDiscount')).bind(\"change keyup\", function () {
                                updateLineTotal(\$itemRow);
                            });
            
                            $(\$itemRow.find('#lineTotal')).bind(\"change keyup\", function () {
                                validateNumber($(\$itemRow.find('#lineTotal')));
                                changeLineTotal(\$itemRow);
                            });
            
                            $(\$itemRow.find('#qty')).trigger('change');
                            updateTotals();
            
                        });
                                
                    }
                    
                });
                                

                
            }
        </script>
        ";

        $this->setJavascript($javascript);

    }


    /*
       // Category Tree Functions

       private function initCategoryTree($showHidden){

           $id = 0;
           $db = $this->db;

           $categoriesTree = array();
           $categoriesArray = Array();

           $stm = $db->prepare("SELECT category_id FROM Categories WHERE level=1 ORDER BY custom_order,category_id");
           $stm-> execute();
           $stm-> bind_result($id);
           while ($stm->fetch()) {array_push($categoriesArray,$id);}
           $stm-> close();

           foreach ($categoriesArray as $id) {
               array_push($categoriesTree, $this->getTreeByCategoryID($id));
           }

           if($showHidden) {

               $hiddenCategoriesArray = Array();

               $notShownCategory = new stdClass();
               $notShownCategory->name = "Hidden Categories";
               $notShownCategory->id = "0";
               $notShownCategory->children = array();


               $stm = $db->prepare("SELECT category_id FROM Categories WHERE level=0 AND category_id NOT IN(SELECT subcategory_id  AS category_id FROM Subcategories) ORDER BY custom_order,category_id");
               $stm->execute();
               $stm->bind_result($id);
               while ($stm->fetch()) {array_push($hiddenCategoriesArray, $id);}
               $stm->close();

               foreach ($categoriesArray as $id) {
                   array_push($notShownCategory->children, $this->getTreeByCategoryID($id));
               }

               array_push($categoriesTree,$notShownCategory);

           }

           $this->setCategoryTree(json_encode($categoriesTree));
       }

       private function getTreeByCategoryID($categoryID)
       {
           $db = $this->db;
           $catID = 0;
           $subID = 0;
           $name = '';

           $stm = $db->prepare("SELECT category_id,CONCAT(category_code,' - ',name) FROM Categories WHERE category_id='$categoryID'  ORDER BY custom_order,category_id LIMIT 1");
           $stm-> execute();
           $stm-> bind_result($catID,$name);
           while ($stm->fetch()) {}
           $stm-> close();

           $category = new stdClass();
           $category->id = $catID;
           $category->name = $name;
           $category->children = array();

           $subIDs = array();
           $stm = $db->prepare("SELECT subcategory_id FROM Subcategories,Categories WHERE Subcategories.subcategory_id=Categories.category_id AND  Subcategories.category_id='$categoryID' ORDER BY custom_order,Subcategories.subcategory_id");
           $stm-> execute();
           $stm-> bind_result($subID);
           while ($stm->fetch()) {array_push($subIDs,$subID);}
           $stm-> close();

           foreach ($subIDs as $subID){
               array_push($category->children,$this->getTreeByCategoryID($subID));
           }


           return $category;

       }

       */

    



}
?>